System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _cc, MergeManager, TextureManager, _crd, cc, ccclass, property;

  _export("TextureManager", void 0);

  return {
    setters: [function (_cc2) {
      _cclegacy = _cc2.cclegacy;
      __checkObsolete__ = _cc2.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc2.__checkObsoleteInNamespace__;
      _cc = _cc2;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "f8703oq2YlH6IUXvbn+kShn", "MergeManager-001", undefined);

      cc = __checkObsoleteInNamespace__(_cc);
      ({
        ccclass,
        property
      } = cc._decorator);
      MergeManager = class MergeManager {
        /*
        
            paths:路径数组
        
            col:列数
        
            row:行数
        
            imageWidth:单个图片宽度
        
            imageHeight:单个图片高度
        
        */
        constructor(paths, col, row, imageWidth, imageHeight) {
          //图片行数
          this._rowMax = 0;
          //图片列数
          this._colMax = 0;
          //图片行计数
          this._rowCount = 0;
          //图片列计数
          this._colCount = 0;
          //图片计数
          this._imageCount = 0;
          //单个图片宽
          this._imageWidth = 0;
          //单个图片高
          this._imageHeight = 0;
          //下载路径
          this._paths = void 0;
          this._mergeTexture = void 0;
          this._imageMap = new Map();
          this._loaded = false;
          this.onLoaded = void 0;
          this._paths = paths;
          this._colMax = col;
          this._rowMax = row;
          this._imageWidth = imageWidth;
          this._imageHeight = imageHeight;
        }

        init() {
          var array_length = this._imageWidth * this._colMax * this._imageHeight * this._rowMax * 4;
          var imageData = new Uint8Array(array_length);

          for (var i = 0; i < imageData.length; i++) {
            if (i % 4 == 3) {
              imageData[i] = 255;
            } else {
              imageData[i] = 255;
            }
          }

          this._mergeTexture = TextureManager.createTexture(imageData, this._imageWidth * this._colMax, this._imageHeight * this._rowMax);

          for (var path of this._paths) {
            this.loadImage(path);
          }
        }

        loadImage(path, loaded) {
          cc.resources.load(path, cc.ImageAsset, (err, image) => {
            if (err) {
              console.error(err);
            } else {
              var frame = cc.SpriteFrame.createWithImage(image);
              var add = frame.texture;
              var pos = cc.v2(this._colCount * this._imageWidth, this._rowCount * this._imageHeight);

              this._imageMap.set(path, pos);

              this._colCount++;

              if (this._colCount == this._colMax) {
                this._colCount = 0;
                this._rowCount++;
              }

              this._mergeTexture = TextureManager.addImage(this._mergeTexture, add, pos); //let frame1 = new SpriteFrame();
            }

            this._imageCount++;

            if (this._imageCount == this._paths.length) {
              this._loaded = true;
              this.onLoaded && this.onLoaded(this._mergeTexture);
            }
          });
        }

      };

      _export("TextureManager", TextureManager = class TextureManager {
        //通过data创建texture
        static createTexture(imgData, width, height) {
          //默认一张白色纹理
          var tex = new cc.Texture2D(); // /包含 RGBA 四通道的 32 位整形像素格式：RGBA8888。 一字节8位

          tex.reset({
            width: width,
            height: height,
            format: cc.Texture2D.PixelFormat.RGBA8888,
            mipmapLevel: 0
          });
          tex.uploadData(imgData, 0, 0); // 更新 0 级 Mipmap。

          tex.updateImage();
          return tex;
        } //扩展图片


        static expandImage(imgData, width, height, expand) {
          if (expand === void 0) {
            expand = 0;
          }

          var buffer = new Uint8Array(imgData.length + 4 * (expand * width * 2 + expand * height * 2 + height * width * 4));
          var row = 0;
          var col = 0;
          var img_index = 0;
          var new_width = width + expand * 2;
          var new_height = height + expand * 2;
          var color_value = 0;

          for (var index = 0; index < buffer.length; index = index + 4) {
            if (row < expand) {
              buffer[index] = color_value;
              buffer[index + 1] = color_value;
              buffer[index + 2] = color_value;
              buffer[index + 3] = color_value;
            } else if (row >= height + expand) {
              buffer[index] = color_value;
              buffer[index + 1] = color_value;
              buffer[index + 2] = color_value;
              buffer[index + 3] = color_value;
            } else {
              if (col < expand) {
                buffer[index] = color_value;
                buffer[index + 1] = color_value;
                buffer[index + 2] = color_value;
                buffer[index + 3] = color_value;
              } else if (col >= width + expand) {
                buffer[index] = color_value;
                buffer[index + 1] = color_value;
                buffer[index + 2] = color_value;
                buffer[index + 3] = color_value;
              } else {
                buffer[index] = imgData[img_index];
                buffer[index + 1] = imgData[img_index + 1];
                buffer[index + 2] = imgData[img_index + 2];
                buffer[index + 3] = imgData[img_index + 3];
                img_index = img_index + 4;
              }
            }

            col++;

            if (col >= new_width) {
              col = 0;
              row++;
            }
          }

          return buffer;
        }

        static addImage(oriTex, addTex, offset) {
          if (offset === void 0) {
            offset = cc.v2(0, 0);
          }

          var oriData = this.readPixelsForTexture(oriTex);
          var addData = this.readPixelsForTexture(addTex);
          var row = 0;
          var col = 0;
          var addIndex = 0; //console.log(addData);

          for (var index = 0; index < oriData.length; index = index + 4) {
            if (col >= offset.x && col < addTex.width + offset.x && row >= offset.y && row < addTex.height + offset.y) {
              var alpha = addData[addIndex + 3];
              oriData[index] = addData[addIndex];
              oriData[index + 1] = addData[addIndex + 1];
              oriData[index + 2] = addData[addIndex + 2];
              oriData[index + 3] = alpha;
              addIndex += 4;
            }

            col++;

            if (col == oriTex.width) {
              col = 0;
              row++;
              /*
                    let alpha = addData[addIndex+3]
                    oriData[index] = addData[addIndex];
                    oriData[index+1] = addData[addIndex+1];
                    oriData[index+2] = addData[addIndex+2];
                    oriData[index+3] = alpha;
                    addIndex  += 4;*/
            }
          }

          return this.createTexture(oriData, oriTex.width, oriTex.height);
        } //读取数组


        static readPixelsForTexture(tex) {
          var gfxTexture = tex.getGFXTexture();

          if (!gfxTexture) {
            return null;
          } //数组长度


          var needSize = 4 * tex.width * tex.height;
          var buffer = new Uint8Array(needSize);

          var gfxDevice = tex._getGFXDevice();

          var bufferViews = [];
          var regions = [];
          var region0 = new cc.gfx.BufferTextureCopy(); //数组设置起始和宽高

          region0.texOffset.x = 0;
          region0.texOffset.y = 0;
          region0.texExtent.width = tex.width;
          region0.texExtent.height = tex.height; //copy数据

          regions.push(region0);
          bufferViews.push(buffer);
          gfxDevice == null || gfxDevice.copyTextureToBuffers(gfxTexture, bufferViews, regions);
          return buffer;
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=524ce65cfd82f552c51514fc00c587ac91c44d59.js.map