System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _cc, StringUtil, _crd, cc;

  _export("StringUtil", void 0);

  return {
    setters: [function (_cc2) {
      _cclegacy = _cc2.cclegacy;
      __checkObsolete__ = _cc2.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc2.__checkObsoleteInNamespace__;
      _cc = _cc2;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "bc98bDNa55KdoMEw8FZYFye", "StringUtil", undefined);

      cc = __checkObsoleteInNamespace__(_cc);

      /**
       *
       * @author 
       *
       */
      _export("StringUtil", StringUtil = class StringUtil {
        constructor() {} //Base64.decode('4oGi4KaP4a2E6K+X55eV4L286qa/4L+Q')


        static haveErrorStr(str) {
          return /[^\u0391-\uFFE5\w,\.]/.test(str); //return /[^\u4e00-\u9fa5\w,\.]/.test(str)
        }

        static replaceErrorStr(str) {
          //return str.replace(/[^\u4e00-\u9fa5\w,\.]/g,'*')
          return str.replace(/[^\u0391-\uFFE5\w,\.]/g, '*');
        }

        static replace(str, str1, str2) {
          if (!str) return str;
          str = str + '';

          if (typeof str1 == "string") {
            return str.replace(str1, str2);
          } else {
            for (var i = 0; i < str1.length; i++) {
              str = str.replace(str1[i], str2);
            }
          }

          return str;
        }
        /** 字符串长度分割成int数组 */


        static stringToIntArray(str, split = ",") {
          if (!str) {
            return [];
          }

          var list = String(str).split(split);
          var newList = [];

          for (var i = 0; i < list.length; i++) {
            newList[i] = Number(list[i]);
          }

          return newList;
        }
        /** 字符串长度 1个汉字算2 字母算1 */


        static getStringLength(char) {
          if (!char) return 0;
          return (char + '').replace(/[^\x00-\xff]/g, "aa").length;
        }

        static joinToArr(paramList) {
          var arr = [];

          for (var key in paramList) arr.push(key + "=" + paramList[key]);

          return arr;
        }

        static join(paramList, joinStr = "&") {
          var arr = [];

          for (var key in paramList) arr.push(key + "=" + paramList[key]);

          return arr.join(joinStr);
        }
        /** 去掉左右空格，同trim方法 
         * is_global 传"g" 去掉全部空格
         */


        static Trim(str, is_global) {
          return StringUtil.trim(str, is_global);
        }
        /** 去掉左右空格，同Trim方法 
         * is_global 传"g" 去掉全部空格
         */


        static trim(str, is_global) {
          if (!str) return str;
          var result;
          result = str.replace(/(^\s+)|(\s+$)/g, "");

          if (is_global && is_global.toLowerCase() == "g") {
            result = result.replace(/\s/g, "");
          }

          return result;
        }
        /**  是否为空白 */


        static isWhitespace(char) {
          switch (char) {
            case " ":
            case "\t":
            case "\r":
            case "\n":
            case "\f":
              return true;

            default:
              return false;
          }
        }
        /** 去左空格 */


        static ltrim(char) {
          if (char == null) {
            return null;
          }

          var pattern = /^\s*/;
          return char.replace(pattern, "");
        }
        /** 去右空格 */


        static rtrim(char) {
          if (char == null) {
            return null;
          }

          var pattern = /\s*$/;
          return char.replace(pattern, "");
        }
        /** 从纹理里面读取指定区域的图像缓存数据 */


        static readTexture(texture, rect) {
          let newTexture = new cc.Texture2D();
          newTexture.reset({
            width: rect.width,
            height: rect.height
          });
          let buff = this.readTexturePixels(texture, rect);
          newTexture.uploadData(buff);
          return newTexture;
        }
        /** 从纹理里面读取指定区域的图像缓存数据 */


        static readTexturePixels(texture, rect) {
          const gfxTexture = texture.getGFXTexture();
          if (gfxTexture == null) return null;
          const bufferSize = 4 * texture.width * texture.height;
          const buffer = new Uint8Array(bufferSize);
          const region = new cc.gfx.BufferTextureCopy();
          region.texOffset.x = rect.x;
          region.texOffset.y = rect.y;
          region.texExtent.width = rect.width;
          region.texExtent.height = rect.height;
          const gfxDevice = texture['_getGFXDevice']();
          gfxDevice.copyTextureToBuffers(gfxTexture, [buffer], [region]);
          return buffer;
        }

      });

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=1faf71de792e523a7e1348935bd4e99ac4cf1d81.js.map