System.register([], (function (exports, module) {
  'use strict';
  return {
    execute: (function () {

      exports({
        BitMask: BitMask,
        CCClass: CCClass,
        Enum: Enum,
        Eventify: Eventify,
        WorldNode3DToLocalNodeUI: WorldNode3DToLocalNodeUI,
        WorldNode3DToWorldNodeUI: WorldNode3DToWorldNodeUI,
        __checkObsoleteInNamespace__: __checkObsoleteInNamespace__,
        __checkObsolete__: __checkObsolete__,
        _resetDebugSetting: _resetDebugSetting,
        absMax: absMax,
        absMaxComponent: absMaxComponent,
        applyMixins: applyMixins,
        approx: approx,
        assert: assert,
        assertID: assertID,
        assertIsNonNullable: assertIsNonNullable,
        assertIsTrue: assertIsTrue,
        assertsArrayIndex: assertsArrayIndex,
        bezier: bezier$1,
        bezierByTime: bezierByTime,
        binarySearch: binarySearch,
        binarySearchBy: binarySearchBy,
        binarySearchEpsilon: binarySearchEpsilon,
        ccenum: ccenum,
        clamp: clamp$1,
        clamp01: clamp01,
        color: color,
        computeRatioByType: computeRatioByType,
        createDefaultPipeline: createDefaultPipeline,
        debug: debug,
        debugID: debugID,
        deprecateModuleExportedName: deprecateModuleExportedName,
        deserialize: deserialize,
        enumerableProps: enumerableProps,
        equals: equals$2,
        error: error,
        errorID: errorID,
        find: find,
        flattenCodeArray: flattenCodeArray,
        floatToHalf: floatToHalf,
        formerlySerializedAs: formerlySerializedAs$2,
        fragmentText: fragmentText,
        getBaselineOffset: getBaselineOffset,
        getEnglishWordPartAtFirst: getEnglishWordPartAtFirst,
        getEnglishWordPartAtLast: getEnglishWordPartAtLast,
        getError: getError,
        getPathFromRoot: getPathFromRoot,
        getSerializationMetadata: getSerializationMetadata,
        getSymbolAt: getSymbolAt,
        getSymbolCodeAt: getSymbolCodeAt,
        getSymbolLength: getSymbolLength,
        getWorldTransformUntilRoot: getWorldTransformUntilRoot,
        halfToFloat: halfToFloat,
        instantiate: instantiate,
        inverseLerp: inverseLerp,
        isCCClassOrFastDefined: isCCClassOrFastDefined,
        isCCObject: isCCObject,
        isDisplayStats: isDisplayStats,
        isEnglishWordPartAtFirst: isEnglishWordPartAtFirst,
        isEnglishWordPartAtLast: isEnglishWordPartAtLast,
        isUnicodeCJK: isUnicodeCJK,
        isUnicodeSpace: isUnicodeSpace,
        isValid: isValid,
        lerp: lerp,
        loadWasmModuleSpine: loadWasmModuleSpine,
        log: log,
        logID: logID,
        mat4: mat4,
        murmurhash2_32_gc: murmurhash2_32_gc,
        nextPow2: nextPow2,
        pingPong: pingPong,
        pseudoRandom: pseudoRandom,
        pseudoRandomRange: pseudoRandomRange,
        pseudoRandomRangeInt: pseudoRandomRangeInt,
        quat: quat,
        random: random,
        randomRange: randomRange,
        randomRangeInt: randomRangeInt,
        rect: rect,
        repeat: repeat$2,
        safeMeasureText: safeMeasureText,
        sampleAnimationCurve: sampleAnimationCurve,
        setDefaultLogTimes: setDefaultLogTimes,
        setDisplayStats: setDisplayStats,
        setPropertyEnumType: setPropertyEnumType,
        setPropertyEnumTypeOnAttrs: setPropertyEnumTypeOnAttrs,
        setRandGenerator: setRandGenerator,
        shift: shift,
        size: size,
        toDegree: toDegree,
        toRadian: toRadian,
        tween: tween,
        tweenUtil: tweenUtil,
        v2: v2$1,
        v3: v3,
        v4: v4,
        warn: warn,
        warnID: warnID
      });

      function _initializerDefineProperty(target, property, descriptor, context) {
        if (!descriptor) return;
        Object.defineProperty(target, property, {
          enumerable: descriptor.enumerable,
          configurable: descriptor.configurable,
          writable: descriptor.writable,
          value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
        });
      }
      function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
        var desc = {};
        Object.keys(descriptor).forEach(function (key) {
          desc[key] = descriptor[key];
        });
        desc.enumerable = !!desc.enumerable;
        desc.configurable = !!desc.configurable;
        if ('value' in desc || desc.initializer) {
          desc.writable = true;
        }
        desc = decorators.slice().reverse().reduce(function (desc, decorator) {
          return decorator(target, property, desc) || desc;
        }, desc);
        if (context && desc.initializer !== void 0) {
          desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
          desc.initializer = undefined;
        }
        if (desc.initializer === void 0) {
          Object.defineProperty(target, property, desc);
          desc = null;
        }
        return desc;
      }

      function tryDefineGlobal (name, value) {
          const _global = typeof window === 'undefined' ? global : window;
          if (typeof _global[name] === 'undefined') {
              return (_global[name] = value);
          } else {
              // eslint-disable-next-line @typescript-eslint/no-unsafe-return
              return _global[name];
          }
      }

      const OPEN_HARMONY = false;
      tryDefineGlobal('CC_WECHAT', false);
      tryDefineGlobal('CC_BAIDU', false);

      const XIAOMI = false;
      tryDefineGlobal('CC_XIAOMI', false);
      tryDefineGlobal('CC_ALIPAY', false);
      tryDefineGlobal('CC_BYTEDANCE', false);
      tryDefineGlobal('CC_OPPO', false);
      tryDefineGlobal('CC_VIVO', false);
      tryDefineGlobal('CC_HUAWEI', false);
      tryDefineGlobal('CC_COCOSPLAY', false);
      tryDefineGlobal('CC_QTT', false);
      tryDefineGlobal('CC_LINKSURE', false);
      tryDefineGlobal('CC_MIGU', false);

      const EDITOR = false;
      tryDefineGlobal('CC_EDITOR', false);

      const EDITOR_NOT_IN_PREVIEW = false;

      const PREVIEW = false;
      tryDefineGlobal('CC_PREVIEW', false);
      tryDefineGlobal('CC_BUILD', true);
      tryDefineGlobal('CC_TEST', false);
      tryDefineGlobal('CC_DEBUG', true);
      tryDefineGlobal('CC_DEV', false);

      const MINIGAME = false;
      tryDefineGlobal('CC_MINIGAME', false);

      const RUNTIME_BASED = false;
      tryDefineGlobal('CC_RUNTIME_BASED', false);
      tryDefineGlobal('CC_SUPPORT_JIT', true);

      const JSB = true;
      tryDefineGlobal('CC_JSB', true);

      const _global = typeof window === 'undefined' ? global : window;
      const cclegacy = exports("cclegacy", {
        _global
      });
      const legacyCC = cclegacy;
      cclegacy.internal = {};
      const engineVersion = exports("VERSION", '3.8.5');
      _global.CocosEngine = legacyCC.ENGINE_VERSION = engineVersion;
      _global.cc = legacyCC;
      const ccwindow$1 = typeof globalThis.jsb !== 'undefined' ? typeof jsb.window !== 'undefined' ? jsb.window : globalThis : globalThis;
      _global.ccwindow = ccwindow$1;

      const INT_BITS = 32;
      const INT_MAX = 0x7fffffff;
      const INT_MIN = -1 << INT_BITS - 1;
      function sign$2(v) {
        return (v > 0) - (v < 0);
      }
      function abs$7(v) {
        const mask = v >> INT_BITS - 1;
        return (v ^ mask) - mask;
      }
      function min$8(x, y) {
        return y ^ (x ^ y) & -(x < y);
      }
      function max$b(x, y) {
        return x ^ (x ^ y) & -(x < y);
      }
      function isPow2(v) {
        return !(v & v - 1) && !!v;
      }
      function log2(v) {
        let r;
        let shift;
        r = (v > 0xFFFF) << 4;
        v >>>= r;
        shift = (v > 0xFF) << 3;
        v >>>= shift;
        r |= shift;
        shift = (v > 0xF) << 2;
        v >>>= shift;
        r |= shift;
        shift = (v > 0x3) << 1;
        v >>>= shift;
        r |= shift;
        return r | v >> 1;
      }
      function log10(v) {
        return v >= 1000000000 ? 9 : v >= 100000000 ? 8 : v >= 10000000 ? 7 : v >= 1000000 ? 6 : v >= 100000 ? 5 : v >= 10000 ? 4 : v >= 1000 ? 3 : v >= 100 ? 2 : v >= 10 ? 1 : 0;
      }
      function popCount(v) {
        v -= v >>> 1 & 0x55555555;
        v = (v & 0x33333333) + (v >>> 2 & 0x33333333);
        return (v + (v >>> 4) & 0xF0F0F0F) * 0x1010101 >>> 24;
      }
      function countTrailingZeros(v) {
        let c = 32;
        v &= -v;
        if (v) {
          c--;
        }
        if (v & 0x0000FFFF) {
          c -= 16;
        }
        if (v & 0x00FF00FF) {
          c -= 8;
        }
        if (v & 0x0F0F0F0F) {
          c -= 4;
        }
        if (v & 0x33333333) {
          c -= 2;
        }
        if (v & 0x55555555) {
          c -= 1;
        }
        return c;
      }
      function nextPow2$1(v) {
        --v;
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        return v + 1;
      }
      function prevPow2(v) {
        v |= v >>> 1;
        v |= v >>> 2;
        v |= v >>> 4;
        v |= v >>> 8;
        v |= v >>> 16;
        return v - (v >>> 1);
      }
      function parity(v) {
        v ^= v >>> 16;
        v ^= v >>> 8;
        v ^= v >>> 4;
        v &= 0xf;
        return 0x6996 >>> v & 1;
      }
      const REVERSE_TABLE = new Array(256);
      (tab => {
        for (let i = 0; i < 256; ++i) {
          let v = i;
          let r = i;
          let s = 7;
          for (v >>>= 1; v; v >>>= 1) {
            r <<= 1;
            r |= v & 1;
            --s;
          }
          tab[i] = r << s & 0xff;
        }
      })(REVERSE_TABLE);
      function reverse(v) {
        return REVERSE_TABLE[v & 0xff] << 24 | REVERSE_TABLE[v >>> 8 & 0xff] << 16 | REVERSE_TABLE[v >>> 16 & 0xff] << 8 | REVERSE_TABLE[v >>> 24 & 0xff];
      }
      function interleave2(x, y) {
        x &= 0xFFFF;
        x = (x | x << 8) & 0x00FF00FF;
        x = (x | x << 4) & 0x0F0F0F0F;
        x = (x | x << 2) & 0x33333333;
        x = (x | x << 1) & 0x55555555;
        y &= 0xFFFF;
        y = (y | y << 8) & 0x00FF00FF;
        y = (y | y << 4) & 0x0F0F0F0F;
        y = (y | y << 2) & 0x33333333;
        y = (y | y << 1) & 0x55555555;
        return x | y << 1;
      }
      function deinterleave2(v, n) {
        v = v >>> n & 0x55555555;
        v = (v | v >>> 1) & 0x33333333;
        v = (v | v >>> 2) & 0x0F0F0F0F;
        v = (v | v >>> 4) & 0x00FF00FF;
        v = (v | v >>> 16) & 0x000FFFF;
        return v << 16 >> 16;
      }
      function interleave3(x, y, z) {
        x &= 0x3FF;
        x = (x | x << 16) & 4278190335;
        x = (x | x << 8) & 251719695;
        x = (x | x << 4) & 3272356035;
        x = (x | x << 2) & 1227133513;
        y &= 0x3FF;
        y = (y | y << 16) & 4278190335;
        y = (y | y << 8) & 251719695;
        y = (y | y << 4) & 3272356035;
        y = (y | y << 2) & 1227133513;
        x |= y << 1;
        z &= 0x3FF;
        z = (z | z << 16) & 4278190335;
        z = (z | z << 8) & 251719695;
        z = (z | z << 4) & 3272356035;
        z = (z | z << 2) & 1227133513;
        return x | z << 2;
      }
      function deinterleave3(v, n) {
        v = v >>> n & 1227133513;
        v = (v | v >>> 2) & 3272356035;
        v = (v | v >>> 4) & 251719695;
        v = (v | v >>> 8) & 4278190335;
        v = (v | v >>> 16) & 0x3FF;
        return v << 22 >> 22;
      }
      function nextCombination(v) {
        const t = v | v - 1;
        return t + 1 | (~t & -~t) - 1 >>> countTrailingZeros(v) + 1;
      }

      var bits = /*#__PURE__*/Object.freeze({
        __proto__: null,
        INT_BITS: INT_BITS,
        INT_MAX: INT_MAX,
        INT_MIN: INT_MIN,
        abs: abs$7,
        countTrailingZeros: countTrailingZeros,
        deinterleave2: deinterleave2,
        deinterleave3: deinterleave3,
        interleave2: interleave2,
        interleave3: interleave3,
        isPow2: isPow2,
        log10: log10,
        log2: log2,
        max: max$b,
        min: min$8,
        nextCombination: nextCombination,
        nextPow2: nextPow2$1,
        parity: parity,
        popCount: popCount,
        prevPow2: prevPow2,
        reverse: reverse,
        sign: sign$2
      });
      exports("bits", bits);

      var debugInfos = {
      	"1006": "[Action step]. override me",
      	"1007": "[Action update]. override me",
      	"1008": "[Action reverse]. override me",
      	"1100": "Expected 'data' dict, but not found. Config file: %s",
      	"1101": "Please load the resource first : %s",
      	"1102": "Effect settings not found, effects will not be imported.",
      	"1103": "Success to load scene: %s",
      	"1200": "cocos2d: Director: Error in gettimeofday",
      	"1204": "Running scene should not be null",
      	"1205": "The scene should not be null",
      	"1206": "loadScene: The scene index to load (%s) is out of range.",
      	"1207": "loadScene: Unknown name type to load: '%s'",
      	"1208": "loadScene: Failed to load scene '%s' because '%s' is already being loaded.",
      	"1209": "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      	"1210": "Failed to preload '%s', %s",
      	"1211": "loadScene: The scene index to load (%s) is out of range.",
      	"1212": "loadScene: Unknown name type to load: '%s'",
      	"1213": "loadScene: Failed to load scene '%s' because '%s' is already loading",
      	"1214": "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      	"1215": "Failed to preload '%s', %s",
      	"1216": "Director.runSceneImmediate: scene is not valid",
      	"1217": "Director._initOnEngineInitialized: renderer root initialization failed",
      	"1218": "Forward render pipeline initialized.",
      	"1219": "Deferred render pipeline initialized. Note that non-transparent materials with no lighting will not be rendered, such as builtin-unlit.",
      	"1220": "Failed to set shading scale, pipelineSceneData is invalid.",
      	"1221": "Setting orientation is not supported yet.",
      	"1222": "Failed to initialize render pipeline.",
      	"1223": "Custom pipeline and legacy pipeline are all culled.",
      	"1300": "%s is not in the model pool and cannot be destroyed by destroyModel.",
      	"1400": "'%s' is deprecated, please use '%s' instead.",
      	"1404": "cc.spriteFrameCache is removed, please use cc.loader to load and cache sprite frames of atlas format.",
      	"1406": "'%s.%s' is removed",
      	"1408": "'%s' is removed",
      	"1409": "element type is wrong!",
      	"1502": "cc.scheduler.scheduleCallbackForTarget(): target should be non-null.",
      	"1503": "cc.Scheduler.pauseTarget():target should be non-null",
      	"1504": "cc.Scheduler.resumeTarget():target should be non-null",
      	"1505": "cc.Scheduler.isTargetPaused():target should be non-null",
      	"1506": "warning: you CANNOT change update priority in scheduled function",
      	"1507": "scheduler#scheduleSelector. Selector already scheduled. Updating interval from: %.4f to %.4f",
      	"1508": "Argument callback must not be empty",
      	"1509": "Argument target must be non-nullptr",
      	"1510": "cc.Scheduler: Illegal target which doesn't have id, you should do Scheduler.enableForTarget(target) before all scheduler API usage on target",
      	"1511": "cc.Scheduler: pause state of the scheduled task doesn't match the element pause state in Scheduler, the given paused state will be ignored.",
      	"1513": "cc.Scheduler: scheduler stopped using `__instanceId` as id since v2.0, you should do Scheduler.enableForTarget(target) before all scheduler API usage on target",
      	"1514": "since v3.8.0, `Scheduler.schedule(target, callback, interval)` is deprecated, please use `Scheduler.schedule(callback, target, interval)` instead.",
      	"1607": "removeFromParentAndCleanup is deprecated. Use removeFromParent instead",
      	"1619": "callback function must be non-null",
      	"1620": "interval must be positive",
      	"1623": "Set '%s' to normal node (not persist root node).",
      	"1624": "Replacing with the same sgNode",
      	"1625": "The replacement sgNode should not contain any child.",
      	"1626": "Should not set alpha via 'color', set 'opacity' please.",
      	"1627": "Not support for asynchronous creating node in SG",
      	"1632": "Node name can not include '/'.",
      	"1633": "Internal error, should not remove unknown node from parent.",
      	"1635": "reorderChild: this child is not in children list.",
      	"1636": "Node's zIndex value can't be greater than cc.macro.MAX_ZINDEX, setting to the maximum value",
      	"1637": "Node's zIndex value can't be smaller than cc.macro.MIN_ZINDEX, setting to the minimum value",
      	"1638": "Private node's zIndex can't be set, it will keep cc.macro.MIN_ZINDEX as its value",
      	"1640": "Node %s(%s) has not attached to a scene.",
      	"1800": "cc._EventListenerKeyboard.checkAvailable(): Invalid EventListenerKeyboard!",
      	"1801": "cc._EventListenerTouchOneByOne.checkAvailable(): Invalid EventListenerTouchOneByOne!",
      	"1802": "cc._EventListenerTouchAllAtOnce.checkAvailable(): Invalid EventListenerTouchAllAtOnce!",
      	"1803": "cc._EventListenerAcceleration.checkAvailable():_onAccelerationEvent must be non-nil",
      	"1900": "Invalid parameter.",
      	"2104": "Layer collision. The name of layer (%s) is collided with the name or value of some layer",
      	"2200": "Design resolution not valid",
      	"2201": "should set resolutionPolicy",
      	"2300": "The touches is more than MAX_TOUCHES.",
      	"2301": "Cannot create the same touch object.",
      	"2302": "The touches is more than MAX_TOUCHES, release touch id %s.",
      	"2402": "Forward pipeline startup failed!",
      	"3103": "cc.Texture.addImage(): path should be non-null",
      	"3119": "Lazy init texture with image element failed due to image loading failure: %s",
      	"3120": "Loading texture with unsupported type: '%s'. Add '%s' into 'cc.macro.SUPPORT_TEXTURE_FORMATS' please.",
      	"3121": "Can't find a texture format supported by the current platform! Please add a fallback format in the editor.",
      	"3122": "Error Texture in %s.",
      	"3123": "Set same texture %s.",
      	"3124": "Texture: setMipRange failed because base level is larger than max level",
      	"3300": "Rect width exceeds maximum margin: %s",
      	"3301": "Rect height exceeds maximum margin: %s",
      	"3500": "0 priority is forbidden for fixed priority since it's used for scene graph based priority.",
      	"3501": "Invalid listener type!",
      	"3502": "Can't set fixed priority with scene graph based listener.",
      	"3503": "Invalid parameters.",
      	"3504": "listener must be a cc.EventListener object when adding a fixed priority listener",
      	"3505": "The listener has been registered, please don't register it again.",
      	"3506": "Unsupported listener target.",
      	"3507": "Invalid scene graph priority!",
      	"3508": "If program goes here, there should be event in dispatch.",
      	"3509": "_inDispatch should be 1 here.",
      	"3510": "%s's scene graph node not contains in the parent's children",
      	"3511": "event is undefined",
      	"3512": "Event manager only support scene graph priority for ui nodes which contain UIComponent",
      	"3520": "Device Motion Event request permission: %s",
      	"3521": "Device Motion Event request permission failed: %s",
      	"3601": "The editor property 'playOnFocus' should be used with 'executeInEditMode' in class '%s'",
      	"3602": "Unknown editor property '%s' in class '%s'.",
      	"3603": "Use 'cc.Float' or 'cc.Integer' instead of 'cc.Number' please.",
      	"3604": "Can only indicate one type attribute for %s.",
      	"3605": "The default value of %s is not instance of %s.",
      	"3606": "No needs to indicate the '%s' attribute for %s, which its default value is type of %s.",
      	"3607": "The default value of %s must be an empty string.",
      	"3608": "The type of %s must be CCString, not String.",
      	"3609": "The type of %s must be CCBoolean, not Boolean.",
      	"3610": "The type of %s must be CCFloat or CCInteger, not Number.",
      	"3611": "Can not indicate the '%s' attribute for %s, which its default value is type of %s.",
      	"3612": "%s Just set the default value to 'new %s()' and it will be handled properly.",
      	"3613": "'No need to use 'serializable: false' or 'editorOnly: true' for the getter of '%s.%s', every getter is actually non-serialized.",
      	"3614": "Should not define constructor for cc.Component %s.",
      	"3615": "Each script can have at most one Component.",
      	"3616": "Should not specify class name %s for Component which defines in project.",
      	"3618": "ctor of '%s' can not be another CCClass",
      	"3623": "Can not use 'editor' attribute, '%s' not inherits from Components.",
      	"3625": "[isChildClassOf] superclass should be function type, not",
      	"3626": "Can't remove '%s' because '%s' depends on it.",
      	"3627": "Should not add renderer component (%s) to a Canvas node.",
      	"3628": "Should not add %s to a node which size is already used by its other component.",
      	"3633": "Properties function of '%s' should return an object!",
      	"3634": "Disallow to use '.' in property name",
      	"3637": "Can not declare %s.%s, it is already defined in the prototype of %s",
      	"3639": "Can not apply the specified attribute to the getter of '%s.%s', attribute index: %s",
      	"3640": "'%s': the setter of '%s' is already defined!",
      	"3641": "Can not construct %s because it contains object property.",
      	"3644": "Please define 'type' parameter of %s.%s as the actual constructor.",
      	"3645": "Please define 'type' parameter of %s.%s as the constructor of %s.",
      	"3646": "Unknown 'type' parameter of %s.%s：%s",
      	"3647": "The length of range array must be equal or greater than 2",
      	"3648": "Can not declare %s.%s method, it is already defined in the properties of %s.",
      	"3652": "Failed to `new %s()` under the hood, %s\nIt is used for getting default values declared in TypeScript in the first place.\nPlease ensure the constructor can be called during the script's initialization.",
      	"3653": "Please do not specify \"default\" attribute in decorator of \"%s\" property in \"%s\" class.\nDefault value must be initialized at their declaration:\n\n \n// Before:\n@property({\n  type: cc.SpriteFrame\n  default: null  // <--\n})\nmyProp;\n// After:\n@property({\n  type: cc.SpriteFrame\n})\nmyProp = null;   // <--",
      	"3654": "Please specify a default value for \"%s.%s\" property at its declaration:\n\n \n// Before:\n@property(...)\nmyProp;\n// After:\n@property(...)\nmyProp = 0;",
      	"3655": "Can not specify \"get\" or \"set\"  attribute in decorator for \"%s\" property in \"%s\" class.\nPlease use:\n\n \n@property(...)\nget %s () {\n    ...\n}\n@property\nset %s (value) {\n    ...\n}",
      	"3659": "Violation error: extending enumerations shall have non-overlaped member names or member values",
      	"3660": "You are explicitly specifying `undefined` type to cc property \"%s\" of cc class \"%s\".\nIs this intended? If not, this may indicate a circular reference.\nFor example:\n\n \n// foo.ts\nimport { _decorator } from 'cc';\nimport { Bar } from './bar';  // Given that './bar' also reference 'foo.ts'.\n                              // When importing './bar', execution of './bar' is hung on to wait execution of 'foo.ts',\n                              // the `Bar` imported here is `undefined` until './bar' finish its execution.\n                              // It leads to that\n@_decorator.ccclass           //  ↓\nexport class Foo {            //  ↓\n    @_decorator.type(Bar)     //  → is equivalent to `@_decorator.type(undefined)`\n    public bar: Bar;          // To eliminate this error, either:\n                              // - Refactor your module structure(recommended), or\n                              // - specify the type as cc class name: `@_decorator.type('Bar'/* or any name you specified for `Bar` */)`\n}",
      	"3700": "internal error: _prefab is undefined",
      	"3701": "Failed to load prefab asset for node '%s'",
      	"3800": "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      	"3801": "The node can not be made persist because it's not under root node.",
      	"3802": "The node can not be made persist because it's not in current scene.",
      	"3803": "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      	"3804": "getComponent: Type must be non-nil",
      	"3805": "Can't add component '%s' because %s already contains the same component.",
      	"3806": "Can't add component '%s' to %s because it conflicts with the existing '%s' derived component.",
      	"3807": "addComponent: Failed to get class '%s'",
      	"3808": "addComponent: Should not add component ('%s') when the scripts are still loading.",
      	"3809": "addComponent: The component to add must be a constructor",
      	"3810": "addComponent: The component to add must be child class of cc.Component",
      	"3811": "_addComponentAt: The component to add must be a constructor",
      	"3812": "_addComponentAt: Index out of range",
      	"3813": "removeComponent: Component must be non-nil",
      	"3814": "Argument must be non-nil",
      	"3815": "Component not owned by this entity",
      	"3816": "Node '%s' is already activating",
      	"3817": "Sorry, the component of '%s' which with an index of %s is corrupted! It has been removed.",
      	"3818": "Failed to read or parse project.json",
      	"3819": "Warning: target element is not a DIV or CANVAS",
      	"3820": "The renderer doesn't support the renderMode %s",
      	"3821": "Cannot change hierarchy while activating or deactivating the parent.",
      	"3822": "addComponent: Cannot add any component to the scene.",
      	"3823": "The enabled component (id: %s, name: %s) doesn't have a valid node",
      	"3900": "Invalid clip to add",
      	"3901": "Invalid clip to remove",
      	"3902": "clip is defaultClip, set force to true to force remove clip and animation state",
      	"3903": "animation state is playing, set force to true to force stop and remove clip and animation state",
      	"3904": "motion path of target [%s] in prop [%s] frame [%s] is not valid",
      	"3905": "sprite frames must be an Array.",
      	"3906": "Can't find easing type [%s]",
      	"3907": "Animation state is not playing or already removed",
      	"3912": "already-playing",
      	"3920": "Current context does not allow root motion.",
      	"3921": "You provided a ill-formed track path. The last component of track path should be property key, or the setter should not be empty.",
      	"3923": "Root motion is ignored since root bone could not be located in animation.",
      	"3924": "Root motion is ignored since the root bone could not be located in scene.",
      	"3925": "Target of hierarchy path should be of type Node.",
      	"3926": "Node \"%s\" has no path \"%s\".",
      	"3927": "Target of component path should be of type Node.",
      	"3928": "Node \"%s\" has no component \"%s\".",
      	"3929": "Target object has no property \"%s\".",
      	"3930": "Can not decide type for untyped track: runtime binding does not provide a getter.",
      	"3931": "Can not decide type for untyped track: got a unsupported value from runtime binding.",
      	"3932": "Common targets should only target Vectors/`Size`/`Color`.",
      	"3933": "Each curve that has common target should be numeric curve and targets string property.",
      	"3934": "Misconfigured legacy curve: the first keyframe value is number but others aren't.",
      	"3935": "We don't currently support conversion of \\`CubicSplineQuatValue\\`.",
      	"3936": "Instancing/Batching enabled for non-baked skinning model '%s', this may result in unexpected rendering artifacts. Consider turning it off in the material if you do not intend to do this.",
      	"3937": "Previous error occurred when instantiating animation clip %s on node %s.",
      	"3938": "'%s' is not found from '%s'. It's specified as the root node to play animation clip '%s'.",
      	"3940": "Error when animation attempted to bind material uniform target: target %s is not a material.",
      	"3941": "Error when animation attempted to bind material uniform target: material %s has no recorded pass %s.",
      	"3942": "Error when animation attempted to bind material uniform target: material %s at pass %s has no recorded uniform %s.",
      	"3943": "Error when animation attempted to bind material uniform target: material %s at pass %s's uniform %s has no recorded channel %s.",
      	"4003": "Label font size can't be shirnked less than 0!",
      	"4004": "force notify all fonts loaded!",
      	"4011": "Property spriteFrame of Font '%s' is invalid. Using system font instead.",
      	"4012": "The texture of Font '%s' must be already loaded on JSB. Using system font instead.",
      	"4013": "Sorry, lineHeight of system font not supported on JSB.",
      	"4200": "MaskType: IMAGE_STENCIL only support WebGL mode.",
      	"4201": "The alphaThreshold invalid in Canvas Mode.",
      	"4202": "The inverted invalid in Canvas Mode.",
      	"4300": "Can not found the %s page.",
      	"4301": "Can not add a page without UITransform.",
      	"4302": "Can not set the scroll view content when it hasn't UITransform or its parent hasn't UITransform.",
      	"4303": "The %s scrollBar on the '%s' node is not available, please check it.",
      	"4400": "Invalid RichText img tag! The sprite frame name can't be found in the ImageAtlas!",
      	"4500": "Graphics: There is no model in %s.",
      	"4600": "Script attached to '%s' is missing or invalid.",
      	"4601": "Failed to load wasm module, WebAssembly is not supported on this platform, but as a fallback Asm.js module is culled by mistake.",
      	"4700": "The dom control is not created!",
      	"4800": "unknown asset type",
      	"4901": "loadRes: should not specify the extname in %s %s",
      	"4902": "No need to release non-cached asset.",
      	"4914": "Resources url '%s' does not exist.",
      	"4915": "Pack indices and data do not match in size",
      	"4916": "Failed to download package for %s",
      	"4921": "Invalid pipe or invalid index provided!",
      	"4922": "The pipe to be inserted is already in the pipeline!",
      	"4923": "Uuid Loader: Parse asset [ %s ] failed : %s",
      	"4924": "JSON Loader: Input item doesn't contain string content",
      	"4925": "Uuid Loader: Deserialize asset [ %s ] failed : %s",
      	"4926": "Audio Downloader: no web audio context.",
      	"4927": "Audio Downloader: audio not supported on this browser!",
      	"4928": "Load %s failed!",
      	"4929": "Load Webp ( %s ) failed",
      	"4930": "Load image ( %s ) failed",
      	"4932": "Since v1.10, for any atlas (\"%s\") in the \"resources\" directory, it is not possible to find the contained SpriteFrames via `loadRes`, `getRes` or `releaseRes`. Load the SpriteAtlas first and then use `spriteAtlas.getSpriteFrame(name)` instead please.",
      	"4933": "Download Font [ %s ] failed, using Arial or system default font instead",
      	"4934": "Please assure that the full path of sub asset is correct!",
      	"4935": "Failed to skip prefab asset while deserializing PrefabInfo",
      	"5000": "You are trying to destroy a object twice or more.",
      	"5001": "object not yet destroyed",
      	"5100": "Not a plist file!",
      	"5200": "Warning: localStorage isn't enabled. Please confirm browser cookie or privacy option",
      	"5201": "browser don't support web audio",
      	"5202": "This feature supports WebGL render mode only.",
      	"5300": "Type of target to deserialize not matched with data: target is %s, data is %s",
      	"5301": "Can not find script '%s'",
      	"5302": "Can not find class '%s'",
      	"5303": "Failed to deserialize %s, missing _deserialize function.",
      	"5304": "Unable to deserialize version %s data.",
      	"5402": "cc.js.addon called on non-object:",
      	"5403": "cc.js.mixin: arguments must be type object:",
      	"5404": "The base class to extend from must be non-nil",
      	"5405": "The class to extend must be non-nil",
      	"5406": "Class should be extended before assigning any prototype members.",
      	"5500": "'notify' can not be used in 'get/set' !",
      	"5501": "'notify' must be used with 'default' !",
      	"5507": "The 'default' attribute of '%s.%s' must be an array",
      	"5508": "Invalid type of %s.%s",
      	"5510": "The 'type' attribute of '%s.%s' can not be 'Number', use cc.Float or cc.Integer instead please.",
      	"5511": "The 'type' attribute of '%s.%s' is undefined when loading script",
      	"5512": "Can not serialize '%s.%s' because the specified type is anonymous, please provide a class name or set the 'serializable' attribute of '%s.%s' to 'false'.",
      	"5513": "The 'default' value of '%s.%s' should not be used with a 'get' function.",
      	"5514": "The 'default' value of '%s.%s' should not be used with a 'set' function.",
      	"5515": "The 'default' value of '%s.%s' can not be an constructor. Set default to null please.",
      	"5517": "'%s.%s' hides inherited property '%s.%s'. To make the current property override that implementation, add the `override: true` attribute please.",
      	"5601": "Can not get current scene.",
      	"5602": "Scene is destroyed",
      	"5603": "reference node is destroyed",
      	"5700": "no %s or %s on %s",
      	"5800": "%s.lerp not yet implemented.",
      	"5801": "%s.clone not yet implemented.",
      	"5802": "%s.equals not yet implemented.",
      	"5900": "MotionStreak only support WebGL mode.",
      	"5901": "cc.MotionStreak.getOpacity has not been supported.",
      	"5902": "cc.MotionStreak.setOpacity has not been supported.",
      	"6000": "Custom should not be false if file is not specified.",
      	"6001": "The new %s must not be NaN",
      	"6017": "Incomplete or corrupt PNG file",
      	"6018": "Invalid filter algorithm: %s",
      	"6019": "Invalid byte order value.",
      	"6020": "You forgot your towel!",
      	"6021": "Unknown Field Tag: %s",
      	"6022": "Too many bits requested",
      	"6023": "No bits requested",
      	"6024": "Cannot recover from missing StripByteCounts",
      	"6025": "Cannot handle sub-byte bits per sample",
      	"6026": "Cannot handle sub-byte bits per pixel",
      	"6027": "Palette image missing color map",
      	"6028": "Unknown Photometric Interpretation: %s",
      	"6029": "Unkown error",
      	"6030": "cc.ParticleSystem: error decoding or ungzipping textureImageData",
      	"6031": "cc.ParticleSystem: unknown image format with Data",
      	"6032": "cc.ParticleSystem.initWithDictionary() : error loading the texture",
      	"6033": "cc.ParticleSystem: not allowing create to be invoked twice with different particle system",
      	"6034": "cc.ParticleSystem: shouldn't be initialized repetitively, otherwise there will be potential leak",
      	"6035": "cc.ParticleSystem: change material failed, please use proper particle material",
      	"6036": "cc.ParticleSystem: life time should bigger than 1 or buffer will be insufficient",
      	"6400": "asset.url is not usable in core process",
      	"6402": "AssetLibrary has already been initialized!",
      	"6500": "Widget target must be one of the parent nodes of it",
      	"6600": "collider not added or already removed",
      	"6601": "Can't find testFunc for (%s, $s).",
      	"6700": "Can't init canvas '%s' because it conflicts with the existing '%s', the scene should only have one active canvas at the same time.",
      	"6705": "Argument must be non-nil",
      	"6706": "Priority can't be set in RenderRoot2D node",
      	"6800": "Callback of event must be non-nil",
      	"6801": "The message must be provided",
      	"6900": "The thing you want to instantiate must be an object",
      	"6901": "The thing you want to instantiate is nil",
      	"6902": "The thing you want to instantiate is destroyed",
      	"6903": "The instantiate method for given asset do not implemented",
      	"6904": "Can not instantiate array",
      	"6905": "Can not instantiate DOM element",
      	"7100": "%s already defined in Enum.",
      	"7101": "Sorry, 'cc.Enum' not available on this platform, please report this error here: <https://github.com/cocos-creator/engine/issues/new>",
      	"7200": "Method 'initWithTMXFile' is no effect now, please set property 'tmxAsset' instead.",
      	"7201": "Method 'initWithXML' is no effect now, please set property 'tmxAsset' instead.",
      	"7202": "Add component TiledLayer into node failed.",
      	"7203": "Property 'mapLoaded' is unused now. Please write the logic to the callback 'start'.",
      	"7210": "TMX Hexa zOrder not supported",
      	"7211": "TMX invalid value",
      	"7215": "cocos2d: Warning: TMX Layer %s has no tiles",
      	"7216": "cocos2d: TMXFormat: Unsupported TMX version: %s",
      	"7217": "cocos2d: TMXFomat: Unsupported orientation: %s",
      	"7218": "cc.TMXMapInfo.parseXMLFile(): unsupported compression method",
      	"7219": "cc.TMXMapInfo.parseXMLFile(): Only base64 and/or gzip/zlib maps are supported",
      	"7221": "cc.TMXMapInfo.parseXMLFile(): Texture '%s' not found.",
      	"7222": "Parse %s failed.",
      	"7236": "cc.TMXLayer.getTileAt(): TMXLayer: the tiles map has been released",
      	"7237": "cc.TMXLayer.getTileGIDAt(): TMXLayer: the tiles map has been released",
      	"7238": "cc.TMXLayer.setTileGID(): TMXLayer: the tiles map has been released",
      	"7239": "cc.TMXLayer.setTileGID(): invalid gid: %s",
      	"7240": "cc.TMXLayer.getTileFlagsAt(): TMXLayer: the tiles map has been released",
      	"7241": "cc.TiledMap.initWithXML(): Map not found. Please check the filename.",
      	"7401": "Failed to set _defaultArmatureIndex for '%s' because the index is out of range.",
      	"7402": "Failed to set _animationIndex for '%s' because the index is out of range.",
      	"7501": "Failed to set _defaultSkinIndex for '%s' because the index is out of range.",
      	"7502": "Failed to set _animationIndex for '%s' because its skeletonData is invalid.",
      	"7503": "Failed to set _animationIndex for '%s' because the index is out of range.",
      	"7504": "Can not render dynamic created SkeletonData",
      	"7506": "Failed to load spine atlas '$s'",
      	"7507": "Please re-import '%s' because its textures is not initialized! (This workflow will be improved in the future.)",
      	"7508": "The atlas asset of '%s' is not exists!",
      	"7509": "Spine: Animation not found: %s",
      	"7510": "Spine: Animation not found: %s",
      	"7511": "Spine: Invalid input!",
      	"7600": "The context of RenderTexture is invalid.",
      	"7601": "cc.RenderTexture._initWithWidthAndHeightForWebGL() : only RGB and RGBA formats are valid for a render texture;",
      	"7602": "Could not attach texture to the framebuffer",
      	"7603": "clearDepth isn't supported on Cocos2d-Html5",
      	"7604": "saveToFile isn't supported on Cocos2d-Html5",
      	"7605": "newCCImage isn't supported on Cocos2d-Html5",
      	"7606": "GFXTexture is null",
      	"7607": "readPixels buffer size smaller than %d",
      	"7700": "On the web is always keep the aspect ratio",
      	"7701": "Can't know status",
      	"7702": "Video player's duration is not ready to get now!",
      	"7703": "Video Downloader: video not supported on this browser!",
      	"7800": "Web does not support loading",
      	"7801": "Web does not support query history",
      	"7802": "Web does not support query history",
      	"7803": "The current browser does not support the GoBack",
      	"7804": "The current browser does not support the GoForward",
      	"7805": "Web does not support zoom",
      	"7900": "cc.math.Matrix3.assign(): current matrix equals matIn",
      	"7901": "cc.math.mat4Assign(): pOut equals pIn",
      	"7902": "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      	"7903": "cc.math.Matrix4 equal: pMat1 and pMat2 are same object.",
      	"7904": "cc.math.Matrix4.extractPlane: Invalid plane index",
      	"7905": "cc.math.mat4Assign(): pOut equals pIn",
      	"7906": "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      	"7907": "cc.math.Matrix4 equals: pMat1 and pMat2 are same object.",
      	"7908": "Invalid matrix mode specified",
      	"7909": "current quaternion is an invalid value",
      	"8000": "Can't handle this field type or size",
      	"8001": "No bytes requested",
      	"8002": "Too many bytes requested",
      	"8003": "Missing StripByteCounts!",
      	"8100": "cocos2d: ERROR: Failed to compile shader:\n %s",
      	"8101": "cocos2d: ERROR: Failed to compile vertex shader",
      	"8102": "cocos2d: ERROR: Failed to compile fragment shader",
      	"8103": "cc.GLProgram.link(): Cannot link invalid program",
      	"8104": "cocos2d: ERROR: Failed to link program: %s",
      	"8105": "cocos2d: cc.shaderCache._loadDefaultShader, error shader type",
      	"8106": "Please load the resource firset : %s",
      	"8107": "cc.GLProgram.getUniformLocationForName(): uniform name should be non-null",
      	"8108": "cc.GLProgram.getUniformLocationForName(): Invalid operation. Cannot get uniform location when program is not initialized",
      	"8109": "modelView matrix is undefined.",
      	"8200": "Please set node's active instead of rigidbody's enabled.",
      	"8300": "Should only one camera exists, please check your project.",
      	"8301": "Camera does not support Canvas Mode.",
      	"8302": "Camera.viewport is deprecated, please use setViewportInOrientedSpace instead.",
      	"8400": "Wrong type arguments, 'filePath' must be a String.",
      	"9000": "Stencil manager does not support level bigger than %d in this device.",
      	"9001": "Stencil manager is already empty, cannot pop any mask",
      	"9002": "Failed to request any buffer from a mesh buffer without accessor",
      	"9003": "The internal state of LinearBufferAccessor have severe issue and irreversible, please check the reason",
      	"9004": "Failed to allocate chunk in StaticVBAccessor, the requested buffer might be too large: %d bytes",
      	"9005": "BATCHER2D_MEM_INCREMENT is too large, the Max value for BATCHER2D_MEM_INCREMENT is 2303KB (smaller than 65536 *9* 4 / 1024 = 2304KB)",
      	"9006": "QuadRenderData is removed, please use MeshRenderData instead.",
      	"9007": "Since v3.6, Because mask changes the inheritance relationship, you can directly manipulate the rendering components under the same node to complete the operation.",
      	"9100": "texture size exceeds current device limits %d/%d",
      	"9101": "The length of the TypedArrayBuffer must be an integer.",
      	"9201": "Cannot access game frame or container.",
      	"9202": "Setting window size is not supported.",
      	"9300": "The current buffer beyond the limit in ui static component, please reduce the amount",
      	"9301": "The UI has not been initialized",
      	"9302": "Can't getGFXSampler with out device",
      	"9600": "[Physics]: please check to see if physics modules are included",
      	"9610": "[Physics]: cannon.js physics system doesn't support capsule collider",
      	"9611": "[Physics]: builtin physics system doesn't support mesh collider",
      	"9612": "[Physics]: builtin physics system doesn't support cylinder collider",
      	"9613": "[Physics]: cannon.js physics system doesn't support hinge drive and angular limit",
      	"9620": "[Physics][Ammo]: changing the mesh is not supported after the initialization is completed",
      	"9630": "[Physics]: A dynamic rigid body can not have the following collider shapes: Terrain, Plane and Non-convex Mesh. Node name: %s",
      	"9640": "[Physics][builtin]: sweep functions are not supported in builtin",
      	"9641": "[Physics][cannon.js]: sweep functions are not supported in cannon.js",
      	"9642": "[Physics] PhysicsSystem initDefaultMaterial() Failed to load builtinMaterial.",
      	"9643": "[Physics] Failed to load user customized default physics material: %s, will fallback to built-in default physics material",
      	"10001": "The sub-mesh contains %d vertices, which beyonds the capability (%d vertices most) of renderer of your platform.",
      	"10002": "Sub-mesh may include at most %d morph targets, but you specified %d.",
      	"11000": "WebGL context lost.",
      	"12001": "BlendFactors are disabled when using custom material, please modify the blend state in the material instead.",
      	"12002": "Can't add renderable component to this node because it already have one.",
      	"12004": "SubModel can only support %d passes.",
      	"12005": "Material already initialized, request aborted.",
      	"12006": "Pass already destroyed.",
      	"12007": "This is old usage, please swap the parameters.",
      	"12008": "GeometryRenderer: too many lines.",
      	"12009": "GeometryRenderer: too many triangles.",
      	"12010": "PassUtils: illegal uniform handle, accessing uniform at offset %d",
      	"12011": "Pass: setUniform is invoked with incompatible uniform data type for binding %d, expected type is %s",
      	"12012": "Can't set a material instance to a sharedMaterial slot",
      	"12100": "The font size is too big to be fitted into texture atlas. Please switch to other label cache modes or choose a smaller font size.",
      	"12101": "The asset %s has been destroyed!",
      	"12102": "Base pass cannot override states, please use pass instance instead.",
      	"12103": "Custom pipeline create shader %s failed. Please reimport all effects (Menu->Developer->Refresh All Effect) and restart creator.",
      	"12104": "Create shader %s failed.",
      	"12105": "Pass resources incomplete.",
      	"12106": "Cannot patch non-builtin macros.",
      	"12107": "Custom pipeline invalid render pass, program: %s. Please reimport all effects (Menu->Developer->Refresh All Effect) and restart creator.",
      	"12108": "Custom pipeline invalid render phase, program: %s. Please reimport all effects (Menu->Developer->Refresh All Effect) and restart creator.",
      	"12109": "custom-pipeline module not available.",
      	"12110": "MaterialPass passID in legacy pipeline is wrongly initialized.",
      	"13100": "Incorrect CCON magic.",
      	"13101": "Unknown CCON version number: %d.",
      	"13102": "CCON Format error.",
      	"13103": "Can not encode CCON binary: lack of text encoder.",
      	"13104": "Can not decode CCON binary: lack of text decoder.",
      	"14000": "State machine matched too many transitions(greater than %s) during this frame: %s.",
      	"14100": "Pool.destroy no longer take a function as parameter, Please specify destruct function in the construction of Pool instead",
      	"14200": "Can not update a static mesh.",
      	"14201": "The primitiveIndex is out of range.",
      	"14202": "meshopt asm decoder initialized",
      	"14203": "meshopt wasm decoder initialized",
      	"14204": "meshopt decoder error: %d",
      	"14300": "Can not keep world transform due to the zero scaling of parent node",
      	"14400": "Spline error: less than 2 knots.",
      	"14401": "Spline error: less than 4 knots or not a multiple of 4.\n\n<!-- Rendering algorithm reserved: 15000 - 16000 -->",
      	"15000": "Can not find corresponding diffuse map for environment lighting, use hemisphere diffuse instead, change environment lighting type to regenerate diffuse map",
      	"15001": "Can not find environment map, disable IBL lighting",
      	"15002": "Diffuse map resource is missing, please change environment lighting type to regenerate resource",
      	"15003": "The shadow visible distance is so small that CSM stratification is not effective, Please change the value of shadowDistance so that it is 10 times greater than 0.1",
      	"15004": "The native folder may be generated from older versions, please refer https://docs.cocos.com/creator/manual/en/release-notes/ to upgrade.",
      	"15100": "Camera '%s' clear flag is skybox, but skybox is disabled,  may cause strange background effect, please set camera clear flag to solid color.",
      	"16000": "'%s' is deprecated since v%s.",
      	"16001": "'%s' is deprecated since v%s, please use '%s' instead.",
      	"16002": "'%s' is removed since v%s.",
      	"16003": "'%s' is removed since v%s, please use '%s' instead.",
      	"16101": "The effect('%s') you are looking for does not exist, please confirm the effect name in the editor. NOTE: Since 3.6, the name of the built-in effect has been changed to its name in the editor, please check it out. More information please refer to https://docs.cocos.com/creator/manual/en/shader/effect-inspector.html",
      	"16201": "The asset replacing failed, can not found override asset('%s') for '%s'",
      	"16301": "node '%s' doesn't have any ModelRenderer component, this component will not work. please add ModelRenderer component first",
      	"16302": "There is no reflection probe in the scene or no probe is near the current object. No reflection probe will take effect on this object. Please create a new reflection probe or move existing ones closer.",
      	"16303": "Skin material needs floating-point render target, please check ENABLE_FLOAT_OUTPUT define in Project Settings--Macro",
      	"16304": "Skin material may need more accurate calculations, please select a head model of standard size, check the isGlobalStandardSkinObject option in the MeshRender component.",
      	"16305": "failed to stop accelerometer",
      	"16306": "The data must have positions field",
      	"16307": "please change type to sprite_stencil first",
      	"16308": "illegal index count!",
      	"16309": "Unsupported Format, convert to WebGL internal format failed.",
      	"16310": "Unsupported Format, convert to WebGL format failed.",
      	"16311": "Unsupported GLType, convert to GL type failed.",
      	"16312": "Unsupported GLType, convert to TypedArrayConstructor failed.",
      	"16313": "Unsupported GLType, convert to Type failed.",
      	"16314": "Unsupported GLType, get type failed.",
      	"16315": "Unsupported BufferType, create buffer failed.",
      	"16316": "Unsupported BufferType, update buffer failed.",
      	"16317": "Unsupported TextureType, create texture failed.",
      	"16318": "glCheckFramebufferStatus() - FRAMEBUFFER_INCOMPLETE_ATTACHMENT",
      	"16319": "glCheckFramebufferStatus() - FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT",
      	"16320": "glCheckFramebufferStatus() - FRAMEBUFFER_INCOMPLETE_DIMENSIONS",
      	"16321": "glCheckFramebufferStatus() - FRAMEBUFFER_UNSUPPORTED",
      	"16322": "Unsupported ShaderType.",
      	"16323": "%s in '%s' compilation failed.",
      	"16324": "Shader source dump: %s",
      	"16325": "Shader '%s' compilation succeeded.",
      	"16326": "Failed to link shader: %s",
      	"16327": "Unsupported GL texture type, copy buffer to texture failed.",
      	"16328": "Command 'draw' must be recorded inside a render pass.",
      	"16329": "Command 'updateBuffer' must be recorded outside a render pass.",
      	"16330": "Command 'copyBufferToTexture' must be recorded outside a render pass.",
      	"16331": "InputAssemblerInfo.vertexBuffers is null.",
      	"16332": "Illegal index buffer stride.",
      	"16333": "This device does not support WebGL.",
      	"16334": "A Class already exists with the same %s : %s. %s",
      	"16335": "\"%s\" has already been set as name or alias of another class.",
      	"16336": "\"%s\" has already been set as id or alias of another class.",
      	"16337": "can not support canvas rendering in 3D",
      	"16338": "The '_$erialized' prop in MissingScript is missing. Please contact jare.",
      	"16339": "Error props: ['%s']",
      	"16340": "Error when checking MissingScript 5, %s",
      	"16341": "The '_$erialized' prop of MissingScript is missing. Will force the raw data to be save.",
      	"16342": "Error props: ['%s']. Please contact jare.",
      	"16343": "Unable to stash previously serialized data. %s",
      	"16344": "Error when checking MissingScript 6, %s",
      	"16345": "uniform '%s' must have a count",
      	"16346": "Invalid GFX API!",
      	"16347": "The number of mipmaps of each face is different.",
      	"16348": "builtin UBO '%s' not available!",
      	"16349": "builtin samplerTexture '%s' not available!",
      	"16350": "The asset %s is missing!",
      	"16351": "the native asset of %s is missing!",
      	"16352": "The asset %s is invalid for some reason, detail message: %s, stack: %s",
      	"16353": "Can't find letter in this bitmap-font",
      	"16354": "Can't find letter definition in texture atlas %s for letter:%s",
      	"16355": "Can't find letter definition in font family %s for letter: %s",
      	"16356": "wrong format of version when compare version",
      	"16357": "should use Vec3.multiply for vector * vector operation",
      	"16358": "should use Vec3.scale for vector * scalar operation",
      	"16359": "should use Vec2.multiply for vector * vector operation",
      	"16360": "should use Vec2.scale for vector * scalar operation",
      	"16361": "should use Vec4.multiply for vector * vector operation",
      	"16362": "should use Vec4.scale for vector * scalar operation",
      	"16363": "Unable to get device",
      	"16364": "bitNum can't be undefined",
      	"16365": "maximum layers reached.",
      	"16366": "do not change buildin layers.",
      	"16367": "name can't be undefined",
      	"16368": "Unable to access unknown layer.",
      	"16369": "unknown define type '%s'",
      	"16370": "Shaders in material asset '%s' cannot be modified at runtime, please instantiate the material first.",
      	"16371": "Pipeline states in material asset '%s' cannot be modified at runtime, please instantiate the material first.",
      	"16372": "illegal pass index: %s.",
      	"16373": "illegal property name: %s.",
      	"16374": "Unexpected attribute!",
      	"16375": "Unexpected: failed to create morph texture?",
      	"16376": "The fnt config is not exists!",
      	"16377": "SpriteAtlas is null.",
      	"16378": "node '%s' doesn't have any renderable component",
      	"16379": "cannot resize buffer views!",
      	"16380": "cannot update through buffer views!",
      	"16381": "Profiler._stats is deprecated, please use Profiler.stats instead.",
      	"16382": "reverse: could not reverse a non-relative action",
      	"16383": "Need 'clone' for custom prop '%s'",
      	"16384": "Need 'add' for custom prop '%s'",
      	"16385": "Need 'sub' for custom prop '%s' in reverse mode",
      	"16386": "TweenAction: '%s' can't be converted to number",
      	"16387": "Wrong return type for 'progress', number or string needed",
      	"16388": "reverse: current tween could not be reversed, empty actions",
      	"16389": "pause: tween wasn't started, can't pause",
      	"16390": "resume: tween wasn't started, can't resume",
      	"16391": "reverse: could not find action id %s",
      	"16392": "Please set target to tween first",
      	"16393": "start: no actions in Tween",
      	"16394": "repeatForever: the last action is not ActionInterval",
      	"16395": "reverseTime: the last action is not ActionInterval",
      	"16396": "tweenUtil' is deprecated, please use 'tween' instead",
      	"16397": "ProgressBar FILLED mode only works when barSprite's Type is FILLED!",
      	"16398": "ProgressBar non-FILLED mode only works when barSprite's Type is non-FILLED!",
      	"16399": "CopyTextureToBuffers: not supported texture target.",
      	"16400": "Limit values to be greater than 0",
      	"16401": "beginRenderPass: Only primary command buffer is supported.",
      	"16402": "execute is not supported.",
      	"16403": "GPU memory alias is not supported",
      	"16404": "Block '%s' does not bound",
      	"16405": "This device does not support WebGL2",
      	"16406": "Can't find the spriteFrame of tilesets %s",
      	"16407": "Spline error: invalid mode",
      	"0100": "%s not yet implemented.",
      	"0200": "You should specify a valid DOM canvas element."
      };

      const ccdocument$6 = ccwindow$1.document;
      let logList = null;
      let ccLog = console.log.bind(console);
      let ccWarn = ccLog;
      let ccError = ccLog;
      let ccAssert = (condition, message, ...optionalParams) => {
        if (!condition) {
          console.log(`ASSERT: ${formatString(message, ...optionalParams)}`);
        }
      };
      let ccDebug = ccLog;
      function formatString(...data) {
        return legacyCC.js.formatStr.apply(null, data);
      }
      function log(...data) {
        return ccLog(...data);
      }
      function warn(...data) {
        return ccWarn(...data);
      }
      function error(...data) {
        return ccError(...data);
      }
      function assert(condition, message, ...optionalParams) {
        return ccAssert(condition, message, ...optionalParams);
      }
      function debug(...data) {
        return ccDebug(...data);
      }
      function _resetDebugSetting(mode) {
        ccLog = ccWarn = ccError = ccAssert = ccDebug = () => {};
        if (mode === 0) {
          return;
        }
        if (mode > 4) {
          const logToWebPage = msg => {
            if (!legacyCC.game.canvas) {
              return;
            }
            if (!logList) {
              const logDiv = ccdocument$6.createElement('Div');
              logDiv.setAttribute('id', 'logInfoDiv');
              logDiv.setAttribute('width', '200');
              const height = legacyCC.game.canvas.height;
              logDiv.setAttribute('height', `${height}`);
              const logDivStyle = logDiv.style;
              logDivStyle.zIndex = '99999';
              logDivStyle.position = 'absolute';
              logDivStyle.top = logDivStyle.left = '0';
              logList = ccdocument$6.createElement('textarea');
              logList.setAttribute('rows', '20');
              logList.setAttribute('cols', '30');
              logList.setAttribute('disabled', 'true');
              const logListStyle = logList.style;
              logListStyle.backgroundColor = 'transparent';
              logListStyle.borderBottom = '1px solid #cccccc';
              logListStyle.borderTopWidth = logListStyle.borderLeftWidth = logListStyle.borderRightWidth = '0px';
              logListStyle.borderTopStyle = logListStyle.borderLeftStyle = logListStyle.borderRightStyle = 'none';
              logListStyle.padding = '0px';
              logListStyle.margin = '0px';
              logDiv.appendChild(logList);
              legacyCC.game.canvas.parentNode.appendChild(logDiv);
            }
            logList.value = `${logList.value + msg}\r\n`;
            logList.scrollTop = logList.scrollHeight;
          };
          ccError = (...data) => {
            logToWebPage(`ERROR :  ${formatString(...data)}`);
          };
          ccAssert = (condition, message, ...optionalParams) => {
            if (!condition) {
              logToWebPage(`ASSERT: ${formatString(message, ...optionalParams)}`);
            }
          };
          if (mode !== 7) {
            ccWarn = (...data) => {
              logToWebPage(`WARN :  ${formatString(...data)}`);
            };
          }
          if (mode === 5) {
            ccLog = (...data) => {
              logToWebPage(formatString(...data));
            };
          }
        } else if (console) {
          if (!console.error) {
            console.error = console.log;
          }
          if (!console.warn) {
            console.warn = console.log;
          }
          if (console.error.bind) {
            ccError = console.error.bind(console);
          } else {
            ccError = console.error ;
          }
          ccAssert = (condition, message, ...optionalParams) => {
            if (!condition) {
              const errorText = formatString(message, ...optionalParams);
              {
                throw new Error(errorText);
              }
            }
          };
        }
        if (mode !== 4) {
          if (console.warn.bind) {
            ccWarn = console.warn.bind(console);
          } else {
            ccWarn = console.warn ;
          }
        }
        if (mode <= 2) {
          {
            ccLog = console.log;
          }
        }
        if (mode <= 1) {
          if (typeof console.debug === 'function') {
            const vendorDebug = console.debug.bind(console);
            ccDebug = (...data) => vendorDebug(...data);
          }
        }
      }
      function _throw(error_) {
        {
          const stack = error_.stack;
          if (stack) {
            error(`${error_}\n${stack}` );
          } else {
            error(error_);
          }
          return undefined;
        }
      }
      function getTypedFormatter(type) {
        return (id, ...args) => {
          const msg = debugInfos[id] || 'unknown id' ;
          if (args.length === 0) {
            return msg;
          }
          return formatString(msg, ...args) ;
        };
      }
      const logFormatter = getTypedFormatter();
      function logID(id, ...optionalParams) {
        log(logFormatter(id, ...optionalParams));
      }
      const debugFormatter = getTypedFormatter();
      function debugID(id, ...optionalParams) {
        debug(debugFormatter(id, ...optionalParams));
      }
      const warnFormatter = getTypedFormatter();
      function warnID(id, ...optionalParams) {
        warn(warnFormatter(id, ...optionalParams));
      }
      const errorFormatter = getTypedFormatter();
      function errorID(id, ...optionalParams) {
        error(errorFormatter(id, ...optionalParams));
      }
      const assertFormatter = getTypedFormatter();
      function assertID(condition, id, ...optionalParams) {
        if (condition) {
          return;
        }
        assert(false, assertFormatter(id, ...optionalParams));
      }
      const DebugMode = exports("DebugMode", {
        "NONE": 0,
        "VERBOSE": 1,
        "INFO": 2,
        "WARN": 3,
        "ERROR": 4,
        "INFO_FOR_WEB_PAGE": 5,
        "WARN_FOR_WEB_PAGE": 6,
        "ERROR_FOR_WEB_PAGE": 7
      });
      function getError(errorId, ...param) {
        return errorFormatter(errorId, ...param);
      }
      function isDisplayStats() {
        return legacyCC.profiler ? legacyCC.profiler.isShowingStats() : false;
      }
      function setDisplayStats(displayStats) {
        if (legacyCC.profiler) {
          displayStats ? legacyCC.profiler.showStats() : legacyCC.profiler.hideStats();
        }
      }

      var debug$1 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        DebugMode: DebugMode,
        _resetDebugSetting: _resetDebugSetting,
        _throw: _throw,
        assert: assert,
        assertID: assertID,
        debug: debug,
        debugID: debugID,
        error: error,
        errorID: errorID,
        getError: getError,
        isDisplayStats: isDisplayStats,
        log: log,
        logID: logID,
        setDisplayStats: setDisplayStats,
        warn: warn,
        warnID: warnID
      });

      let defaultLogTimes = 10;
      function setDefaultLogTimes(times) {
        if (times > 0) {
          defaultLogTimes = times;
        }
      }
      let replaceProperty; exports("replaceProperty", replaceProperty);
      let removeProperty; exports("removeProperty", removeProperty);
      let markAsWarning; exports("markAsWarning", markAsWarning);
      let replacePropertyLog;
      let markAsWarningLog;
      let removePropertyLog;
      let messageID = 0;
      const messageMap = new Map();
      replacePropertyLog = (n, dp, n2, newp, f, id, s) => {
        const item = messageMap.get(id);
        if (item && item.logTimes > item.count) {
          f(`'%s' is deprecated, please use '%s' instead. ${s}`, `${n}.${dp}`, `${n2}.${newp}`);
          item.count++;
        }
      };
      exports("replaceProperty", replaceProperty = (owner, ownerName, properties) => {
        if (owner == null) return;
        properties.forEach(item => {
          const id = messageID++;
          messageMap.set(id, {
            id,
            count: 0,
            logTimes: item.logTimes !== undefined ? item.logTimes : defaultLogTimes
          });
          const target = item.target != null ? item.target : owner;
          const newName = item.newName != null ? item.newName : item.name;
          const targetName = item.targetName != null ? item.targetName : ownerName;
          const sameTarget = target === owner;
          const suggest = item.suggest ? `(${item.suggest})` : '';
          if (item.customFunction != null) {
            owner[item.name] = function () {
              replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
              return item.customFunction.call(this, ...arguments);
            };
          } else if (item.customSetter != null || item.customGetter != null) {
            const hasSetter = item.customSetter != null;
            const hasGetter = item.customGetter != null;
            if (hasSetter && hasGetter) {
              Object.defineProperty(owner, item.name, {
                get() {
                  replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
                  return item.customGetter.call(this);
                },
                set(v) {
                  replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
                  item.customSetter.call(this, v);
                },
                enumerable: false
              });
            } else if (hasSetter) {
              Object.defineProperty(owner, item.name, {
                set(v) {
                  replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
                  item.customSetter.call(this, v);
                },
                enumerable: false
              });
            } else if (hasGetter) {
              Object.defineProperty(owner, item.name, {
                get() {
                  replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
                  return item.customGetter.call(this);
                },
                enumerable: false
              });
            }
          } else {
            Object.defineProperty(owner, item.name, {
              get() {
                replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
                return sameTarget ? this[newName] : target[newName];
              },
              set(v) {
                replacePropertyLog(ownerName, item.name, targetName, newName, warn, id, suggest);
                if (sameTarget) {
                  this[newName] = v;
                } else {
                  target[newName] = v;
                }
              },
              enumerable: false
            });
          }
        });
      });
      removePropertyLog = (n, dp, f, id, s) => {
        const item = messageMap.get(id);
        if (item && item.logTimes > item.count) {
          f(`'%s' has been removed. ${s}`, `${n}.${dp}`);
          item.count++;
        }
      };
      exports("removeProperty", removeProperty = (owner, ownerName, properties) => {
        if (owner == null) return;
        properties.forEach(item => {
          const id = messageID++;
          messageMap.set(id, {
            id,
            count: 0,
            logTimes: item.logTimes !== undefined ? item.logTimes : defaultLogTimes
          });
          const suggest = item.suggest ? `(${item.suggest})` : '';
          Object.defineProperty(owner, item.name, {
            get() {
              return removePropertyLog(ownerName, item.name, error, id, suggest);
            },
            set() {
              removePropertyLog(ownerName, item.name, error, id, suggest);
            },
            enumerable: false
          });
        });
      });
      markAsWarningLog = (n, dp, f, id, s) => {
        const item = messageMap.get(id);
        if (item && item.logTimes > item.count) {
          f(`'%s' is deprecated. ${s}`, `${n}.${dp}`);
          item.count++;
        }
      };
      exports("markAsWarning", markAsWarning = (owner, ownerName, properties) => {
        if (owner == null) return;
        const _defaultGetSet = (d, n, dp, f, id, s) => {
          if (d.get) {
            const oldGet = d.get;
            d.get = function () {
              markAsWarningLog(n, dp, f, id, s);
              return oldGet.call(this);
            };
          }
          if (d.set) {
            const oldSet = d.set;
            d.set = function (v) {
              markAsWarningLog(n, dp, f, id, s);
              oldSet.call(this, v);
            };
          }
          Object.defineProperty(owner, dp, d);
        };
        properties.forEach(item => {
          const deprecatedProp = item.name;
          const descriptor = Object.getOwnPropertyDescriptor(owner, deprecatedProp);
          if (!descriptor || !descriptor.configurable) {
            return;
          }
          const id = messageID++;
          messageMap.set(id, {
            id,
            count: 0,
            logTimes: item.logTimes !== undefined ? item.logTimes : defaultLogTimes
          });
          const suggest = item.suggest ? `(${item.suggest})` : '';
          if (typeof descriptor.value !== 'undefined') {
            if (typeof descriptor.value === 'function') {
              const oldValue = descriptor.value;
              owner[deprecatedProp] = function () {
                markAsWarningLog(ownerName, deprecatedProp, warn, id, suggest);
                return oldValue.call(this, ...arguments);
              };
            } else {
              let oldValue = descriptor.value;
              Object.defineProperty(owner, deprecatedProp, {
                configurable: true,
                get() {
                  markAsWarningLog(ownerName, deprecatedProp, warn, id, suggest);
                  return oldValue;
                }
              });
              if (descriptor.writable) {
                Object.defineProperty(owner, deprecatedProp, {
                  set(value) {
                    markAsWarningLog(ownerName, deprecatedProp, warn, id, suggest);
                    oldValue = value;
                  }
                });
              }
            }
          } else {
            _defaultGetSet(descriptor, ownerName, deprecatedProp, warn, id, suggest);
          }
          Object.defineProperty(owner, deprecatedProp, {
            enumerable: false
          });
        });
      });
      const topLevelDeprecateList = {};
      function deprecateModuleExportedName(deprecateList) {
        for (let deprecateName in deprecateList) {
          const deprecateInfo = deprecateList[deprecateName];
          topLevelDeprecateList[deprecateName] = deprecateInfo;
        }
      }
      function _checkObsoleteByName(checkName) {
        const deprecateInfo = topLevelDeprecateList[checkName];
        if (!deprecateInfo) {
          return;
        }
        const {
          newName,
          since,
          removed
        } = deprecateInfo;
        if (removed) {
          if (newName) {
            errorID(16003, checkName, since, newName);
          } else {
            errorID(16002, checkName, since);
          }
        } else if (newName) {
          warnID(16001, checkName, since, newName);
        } else {
          warnID(16000, checkName, since);
        }
      }
      function __checkObsolete__(checkList) {
        for (let checkName of checkList) {
          _checkObsoleteByName(checkName);
        }
      }
      let _cachedProxy;
      function __checkObsoleteInNamespace__(ccNamespace) {
        if (!_cachedProxy) {
          if (typeof Proxy === 'undefined') {
            _cachedProxy = {};
          } else {
            _cachedProxy = new Proxy(ccNamespace, {
              get(target, name, receiver) {
                _checkObsoleteByName(name);
                return Reflect.get(target, name, receiver);
              }
            });
          }
        }
        return _cachedProxy;
      }

      var _class$2z;
      const NonUuidMark = '.';
      class IDGenerator {
        constructor(category) {
          this.id = 0 | Math.random() * 998;
          this.prefix = category ? category + NonUuidMark : '';
        }
        getNewId() {
          return this.prefix + (++this.id).toString();
        }
      }
      _class$2z = IDGenerator;
      IDGenerator.global = new _class$2z('global');

      const tempCIDGenerator = new IDGenerator('TmpCId.');
      const aliasesTag = typeof Symbol === 'undefined' ? '__aliases__' : Symbol('[[Aliases]]');
      const classNameTag = '__classname__';
      const classIdTag = '__cid__';
      function isNumber(object) {
        return typeof object === 'number' || object instanceof Number;
      }
      function isString(object) {
        return typeof object === 'string' || object instanceof String;
      }
      function isEmptyObject(obj) {
        for (const key in obj) {
          return false;
        }
        return true;
      }
      const value = (() => {
        const descriptor = {
          value: undefined,
          enumerable: false,
          writable: false,
          configurable: true
        };
        return (object, propertyName, value_, writable, enumerable) => {
          descriptor.value = value_;
          descriptor.writable = writable;
          descriptor.enumerable = enumerable;
          Object.defineProperty(object, propertyName, descriptor);
          descriptor.value = undefined;
        };
      })();
      const getset = (() => {
        const descriptor = {
          get: undefined,
          set: undefined,
          enumerable: false
        };
        return (object, propertyName, getter, setter, enumerable = false, configurable = false) => {
          if (typeof setter === 'boolean') {
            console.log('Set `setter` to boolean is deprecated. Please don not use like this again.');
            enumerable = setter;
            setter = undefined;
          }
          descriptor.get = getter;
          descriptor.set = setter;
          descriptor.enumerable = enumerable;
          descriptor.configurable = configurable;
          Object.defineProperty(object, propertyName, descriptor);
          descriptor.get = undefined;
          descriptor.set = undefined;
        };
      })();
      const get = (() => {
        const descriptor = {
          get: undefined,
          enumerable: false,
          configurable: false
        };
        return (object, propertyName, getter, enumerable, configurable) => {
          descriptor.get = getter;
          descriptor.enumerable = enumerable;
          descriptor.configurable = configurable;
          Object.defineProperty(object, propertyName, descriptor);
          descriptor.get = undefined;
        };
      })();
      const set = (() => {
        const descriptor = {
          set: undefined,
          enumerable: false,
          configurable: false
        };
        return (object, propertyName, setter, enumerable, configurable) => {
          descriptor.set = setter;
          descriptor.enumerable = enumerable;
          descriptor.configurable = configurable;
          Object.defineProperty(object, propertyName, descriptor);
          descriptor.set = undefined;
        };
      })();
      function createMap(forceDictMode) {
        const map = Object.create(null);
        if (forceDictMode) {
          const INVALID_IDENTIFIER_1 = '.';
          const INVALID_IDENTIFIER_2 = '/';
          map[INVALID_IDENTIFIER_1] = 1;
          map[INVALID_IDENTIFIER_2] = 1;
          delete map[INVALID_IDENTIFIER_1];
          delete map[INVALID_IDENTIFIER_2];
        }
        return map;
      }
      function getClassName(objOrCtor) {
        if (typeof objOrCtor === 'function') {
          const prototype = objOrCtor.prototype;
          if (prototype && prototype.hasOwnProperty(classNameTag) && prototype[classNameTag]) {
            return prototype[classNameTag];
          }
          let ret = '';
          if (objOrCtor.name) {
            ret = objOrCtor.name;
          } else if (objOrCtor.toString) {
            let arr;
            const str = objOrCtor.toString();
            if (str.charAt(0) === '[') {
              arr = /\[\w+\s*(\w+)\]/.exec(str);
            } else {
              arr = /^function\s*(\w+)/.exec(str);
            }
            if (arr && arr.length === 2) {
              ret = arr[1];
            }
          }
          return ret !== 'Object' ? ret : '';
        } else if (objOrCtor && objOrCtor.constructor) {
          return getClassName(objOrCtor.constructor);
        }
        return '';
      }
      function obsolete(object, obsoleted, newExpr, writable) {
        const extractPropName = /([^.]+)$/;
        const oldProp = extractPropName.exec(obsoleted)[0];
        const newProp = extractPropName.exec(newExpr)[0];
        function getter() {
          return this[newProp];
        }
        function setter(value_) {
          this[newProp] = value_;
        }
        if (writable) {
          getset(object, oldProp, getter, setter);
        } else {
          get(object, oldProp, getter);
        }
      }
      function obsoletes(obj, objName, props, writable) {
        for (const obsoleted in props) {
          const newName = props[obsoleted];
          obsolete(obj, `${objName}.${obsoleted}`, newName, writable);
        }
      }
      const REGEXP_NUM_OR_STR = /(%d)|(%s)/;
      const REGEXP_STR = /%s/;
      function formatStr(msg, ...subst) {
        if (arguments.length === 0) {
          return '';
        }
        if (subst.length === 0) {
          return `${msg}`;
        }
        const hasSubstitution = typeof msg === 'string' && REGEXP_NUM_OR_STR.test(msg);
        if (hasSubstitution) {
          for (const arg of subst) {
            const regExpToTest = typeof arg === 'number' ? REGEXP_NUM_OR_STR : REGEXP_STR;
            if (regExpToTest.test(msg)) {
              const notReplaceFunction = `${arg}`;
              msg = msg.replace(regExpToTest, notReplaceFunction);
            } else {
              msg += ` ${arg}`;
            }
          }
        } else {
          for (const arg of subst) {
            msg += ` ${arg}`;
          }
        }
        return msg;
      }
      function shiftArguments() {
        const len = arguments.length - 1;
        const args = new Array(len);
        for (let i = 0; i < len; ++i) {
          args[i] = arguments[i + 1];
        }
        return args;
      }
      function getPropertyDescriptor(object, propertyName) {
        while (object) {
          const pd = Object.getOwnPropertyDescriptor(object, propertyName);
          if (pd) {
            return pd;
          }
          object = Object.getPrototypeOf(object);
        }
        return null;
      }
      function _copyProp(name, source, target) {
        const pd = getPropertyDescriptor(source, name);
        if (pd) {
          Object.defineProperty(target, name, pd);
        }
      }
      function copyAllProperties(source, target, excepts) {
        const propertyNames = Object.getOwnPropertyNames(source);
        for (let i = 0, len = propertyNames.length; i < len; ++i) {
          const propertyName = propertyNames[i];
          if (excepts.indexOf(propertyName) !== -1) {
            continue;
          }
          _copyProp(propertyName, source, target);
        }
      }
      function addon(object, ...sources) {
        object = object || {};
        for (const source of sources) {
          if (source) {
            if (typeof source !== 'object') {
              errorID(5402, source);
              continue;
            }
            for (const name in source) {
              if (!(name in object)) {
                _copyProp(name, source, object);
              }
            }
          }
        }
        return object;
      }
      function mixin(object, ...sources) {
        object = object || {};
        for (const source of sources) {
          if (source) {
            if (typeof source !== 'object') {
              errorID(5403, source);
              continue;
            }
            for (const name in source) {
              _copyProp(name, source, object);
            }
          }
        }
        return object;
      }
      function extend(cls, base) {
        for (const p in base) {
          if (base.hasOwnProperty(p)) {
            cls[p] = base[p];
          }
        }
        cls.prototype = Object.create(base.prototype, {
          constructor: {
            value: cls,
            writable: true,
            configurable: true
          }
        });
        return cls;
      }
      function getSuper(constructor) {
        const proto = constructor.prototype;
        const dunderProto = proto && Object.getPrototypeOf(proto);
        return dunderProto && dunderProto.constructor;
      }
      function isChildClassOf(subclass, superclass) {
        if (subclass && superclass) {
          if (typeof subclass !== 'function') {
            return false;
          }
          if (typeof superclass !== 'function') {
            return false;
          }
          if (subclass === superclass) {
            return true;
          }
          for (;;) {
            subclass = getSuper(subclass);
            if (!subclass) {
              return false;
            }
            if (subclass === superclass) {
              return true;
            }
          }
        }
        return false;
      }
      function clear$1(object) {
        for (const key of Object.keys(object)) {
          delete object[key];
        }
      }
      function isTempClassId(id) {
        return typeof id !== 'string' || id.startsWith(tempCIDGenerator.prefix);
      }
      const _idToClass = createMap(true);
      const _nameToClass = createMap(true);
      function setup(tag, table, allowExist) {
        return function (id, constructor) {
          if (constructor.prototype.hasOwnProperty(tag)) {
            delete table[constructor.prototype[tag]];
          }
          value(constructor.prototype, tag, id);
          if (id) {
            const registered = table[id];
            if (!allowExist && registered && registered !== constructor) {
              let detail = '';
              errorID(16334, tag, id, detail);
            } else {
              table[id] = constructor;
            }
          }
        };
      }
      const _setClassId = setup('__cid__', _idToClass, false);
      const doSetClassName = setup('__classname__', _nameToClass, true);
      function setClassName(className, constructor) {
        doSetClassName(className, constructor);
        if (!constructor.prototype.hasOwnProperty(classIdTag)) {
          const id = className || tempCIDGenerator.getNewId();
          if (id) {
            _setClassId(id, constructor);
          }
        }
      }
      function setClassAlias(target, alias) {
        const nameRegistry = _nameToClass[alias];
        const idRegistry = _idToClass[alias];
        let ok = true;
        if (nameRegistry && nameRegistry !== target) {
          errorID(16335, alias);
          ok = false;
        }
        if (idRegistry && idRegistry !== target) {
          errorID(16336, alias);
          ok = false;
        }
        if (ok) {
          let classAliases = target[aliasesTag];
          if (!classAliases) {
            classAliases = [];
            target[aliasesTag] = classAliases;
          }
          classAliases.push(alias);
          _nameToClass[alias] = target;
          _idToClass[alias] = target;
        }
      }
      function unregisterClass(...constructors) {
        for (const constructor of constructors) {
          const p = constructor.prototype;
          const classId = p[classIdTag];
          if (classId) {
            delete _idToClass[classId];
          }
          const classname = p[classNameTag];
          if (classname) {
            delete _nameToClass[classname];
          }
          const aliases = p[aliasesTag];
          if (aliases) {
            for (let iAlias = 0; iAlias < aliases.length; ++iAlias) {
              const alias = aliases[iAlias];
              delete _nameToClass[alias];
              delete _idToClass[alias];
            }
          }
        }
      }
      function _getClassById(classId) {
        return getClassById(classId);
      }
      function getClassById(classId) {
        return _idToClass[classId];
      }
      function getClassByName(classname) {
        return _nameToClass[classname];
      }
      function _getClassId(obj, allowTempId) {
        return getClassId(obj, allowTempId);
      }
      function getClassId(obj, allowTempId) {
        allowTempId = typeof allowTempId !== 'undefined' ? allowTempId : true;
        let res;
        if (typeof obj === 'function' && obj.prototype.hasOwnProperty(classIdTag)) {
          res = obj.prototype[classIdTag];
          if (!allowTempId && (EDITOR) && isTempClassId(res)) {
            return '';
          }
          return res;
        }
        if (obj && obj.constructor) {
          const prototype = obj.constructor.prototype;
          if (prototype && prototype.hasOwnProperty(classIdTag)) {
            res = obj[classIdTag];
            if (!allowTempId && (EDITOR) && isTempClassId(res)) {
              return '';
            }
            return res;
          }
        }
        return '';
      }

      let Pool$1 = class Pool {
        get() {
          return this._get();
        }
        constructor(_0, _1) {
          this.count = 0;
          const size = _1 === undefined ? _0 : _1;
          const cleanupFunc = _1 === undefined ? null : _0;
          this._pool = new Array(size);
          this._cleanup = cleanupFunc;
        }
        _get() {
          if (this.count > 0) {
            --this.count;
            const cache = this._pool[this.count];
            this._pool[this.count] = null;
            return cache;
          }
          return null;
        }
        put(obj) {
          const pool = this._pool;
          if (this.count < pool.length) {
            if (this._cleanup && this._cleanup(obj) === false) {
              return;
            }
            pool[this.count] = obj;
            ++this.count;
          }
        }
        resize(length) {
          if (length >= 0) {
            this._pool.length = length;
            if (this.count > length) {
              this.count = length;
            }
          }
        }
      };

      class MutableForwardIterator {
        constructor(array) {
          this.i = 0;
          this.array = array;
        }
        get length() {
          return this.array.length;
        }
        set length(value) {
          this.array.length = value;
          if (this.i >= value) {
            this.i = value - 1;
          }
        }
        remove(value) {
          const index = this.array.indexOf(value);
          if (index >= 0) {
            this.removeAt(index);
          }
        }
        removeAt(i) {
          this.array.splice(i, 1);
          if (i <= this.i) {
            --this.i;
          }
        }
        fastRemove(value) {
          const index = this.array.indexOf(value);
          if (index >= 0) {
            this.fastRemoveAt(index);
          }
        }
        fastRemoveAt(i) {
          const array = this.array;
          array[i] = array[array.length - 1];
          --array.length;
          if (i <= this.i) {
            --this.i;
          }
        }
        push(item) {
          this.array.push(item);
        }
      }
      function removeAt(array, index) {
        array.splice(index, 1);
      }
      function fastRemoveAt$2(array, index) {
        const length = array.length;
        if (index < 0 || index >= length) {
          return;
        }
        array[index] = array[length - 1];
        array.length = length - 1;
      }
      function remove(array, value) {
        const index = array.indexOf(value);
        if (index >= 0) {
          removeAt(array, index);
          return true;
        } else {
          return false;
        }
      }
      function fastRemove(array, value) {
        const index = array.indexOf(value);
        if (index >= 0) {
          array[index] = array[array.length - 1];
          --array.length;
        }
      }
      function removeIf(array, predicate) {
        const index = array.findIndex(predicate);
        if (index >= 0) {
          const value = array[index];
          removeAt(array, index);
          return value;
        }
        return undefined;
      }
      function verifyType(array, type) {
        if (array && array.length > 0) {
          for (const item of array) {
            if (!(item instanceof type)) {
              logID(1300);
              return false;
            }
          }
        }
        return true;
      }
      function removeArray(array, removals) {
        for (let i = 0, l = removals.length; i < l; i++) {
          remove(array, removals[i]);
        }
      }
      function appendObjectsAt(array, objects, index) {
        array.splice.apply(array, [index, 0, ...objects]);
        return array;
      }
      function contains$2(array, value) {
        return array.indexOf(value) >= 0;
      }
      function copy(array) {
        const len = array.length;
        const cloned = new Array(len);
        for (let i = 0; i < len; i += 1) {
          cloned[i] = array[i];
        }
        return cloned;
      }

      var array = /*#__PURE__*/Object.freeze({
        __proto__: null,
        MutableForwardIterator: MutableForwardIterator,
        appendObjectsAt: appendObjectsAt,
        contains: contains$2,
        copy: copy,
        fastRemove: fastRemove,
        fastRemoveAt: fastRemoveAt$2,
        remove: remove,
        removeArray: removeArray,
        removeAt: removeAt,
        removeIf: removeIf,
        verifyType: verifyType
      });

      const js = {
        IDGenerator,
        Pool: Pool$1,
        array,
        isNumber,
        isString,
        isEmptyObject,
        getPropertyDescriptor,
        addon,
        mixin,
        extend,
        getSuper,
        isChildClassOf,
        clear: clear$1,
        value,
        getset,
        get,
        set,
        unregisterClass,
        getClassName,
        setClassName,
        setClassAlias,
        getClassByName,
        getClassById,
        get _registeredClassNames() {
          return {
            ..._nameToClass
          };
        },
        set _registeredClassNames(value) {
          clear$1(_nameToClass);
          Object.assign(_nameToClass, value);
        },
        get _registeredClassIds() {
          return {
            ..._idToClass
          };
        },
        set _registeredClassIds(value) {
          clear$1(_idToClass);
          Object.assign(_idToClass, value);
        },
        _getClassId,
        getClassId,
        _setClassId,
        _getClassById,
        obsolete,
        obsoletes,
        formatStr,
        shiftArguments,
        createMap
      };
      legacyCC.js = js;

      var js$1 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        IDGenerator: IDGenerator,
        Pool: Pool$1,
        _getClassById: _getClassById,
        _getClassId: _getClassId,
        _idToClass: _idToClass,
        _nameToClass: _nameToClass,
        _setClassId: _setClassId,
        addon: addon,
        array: array,
        clear: clear$1,
        copyAllProperties: copyAllProperties,
        createMap: createMap,
        extend: extend,
        formatStr: formatStr,
        get: get,
        getClassById: getClassById,
        getClassByName: getClassByName,
        getClassId: getClassId,
        getClassName: getClassName,
        getPropertyDescriptor: getPropertyDescriptor,
        getSuper: getSuper,
        getset: getset,
        isChildClassOf: isChildClassOf,
        isEmptyObject: isEmptyObject,
        isNumber: isNumber,
        isString: isString,
        js: js,
        mixin: mixin,
        obsolete: obsolete,
        obsoletes: obsoletes,
        set: set,
        setClassAlias: setClassAlias,
        setClassName: setClassName,
        shiftArguments: shiftArguments,
        unregisterClass: unregisterClass,
        value: value
      });
      exports("js", js$1);

      function BitMask(obj) {
        if ('__bitmask__' in obj) {
          return obj;
        }
        value(obj, '__bitmask__', null, true);
        let lastIndex = -1;
        const keys = Object.keys(obj);
        for (let i = 0; i < keys.length; i++) {
          const key = keys[i];
          let val = obj[key];
          if (val === -1) {
            val = ++lastIndex;
            obj[key] = val;
          } else if (typeof val === 'number') {
            lastIndex = val;
          } else if (typeof val === 'string' && Number.isInteger(parseFloat(key))) {
            continue;
          }
          const reverseKey = `${val}`;
          if (key !== reverseKey) {
            value(obj, reverseKey, key);
          }
        }
        return obj;
      }
      BitMask.isBitMask = BitMaskType => BitMaskType && Object.prototype.hasOwnProperty.call(BitMaskType, '__bitmask__');
      BitMask.getList = BitMaskDef => {
        if (BitMaskDef.__bitmask__) {
          return BitMaskDef.__bitmask__;
        }
        return BitMask.update(BitMaskDef);
      };
      BitMask.update = BitMaskDef => {
        if (!Array.isArray(BitMaskDef.__bitmask__)) {
          BitMaskDef.__bitmask__ = [];
        }
        const bitList = BitMaskDef.__bitmask__;
        bitList.length = 0;
        for (const name in BitMaskDef) {
          const v = BitMaskDef[name];
          if (Number.isInteger(v)) {
            bitList.push({
              name,
              value: v
            });
          }
        }
        bitList.sort((a, b) => a.value - b.value);
        return bitList;
      };
      legacyCC.BitMask = BitMask;

      function assertIsNonNullable(expr, message) {
        assertIsTrue(!(expr === null || expr === undefined), message);
      }
      function assertIsTrue(expr, message) {
        if (!expr) {
          throw new Error(`Assertion failed: ${message !== null && message !== void 0 ? message : '<no-message>'}`);
        }
      }
      function assertsArrayIndex(array, index) {
        assertIsTrue(index >= 0 && index < array.length, `Array index ${index} out of bounds: [0, ${array.length})`);
      }

      const hasOwnPropertyProto = Object.prototype.hasOwnProperty;
      function Enum(obj) {
        if ('__enums__' in obj) {
          return obj;
        }
        value(obj, '__enums__', null, true);
        return Enum.update(obj);
      }
      Enum.update = obj => {
        let lastIndex = -1;
        const keys = Object.keys(obj);
        for (let i = 0; i < keys.length; i++) {
          const key = keys[i];
          let val = obj[key];
          if (val === -1) {
            val = ++lastIndex;
            obj[key] = val;
          } else if (typeof val === 'number') {
            lastIndex = val;
          } else if (typeof val === 'string' && Number.isInteger(parseFloat(key))) {
            continue;
          }
          const reverseKey = `${val}`;
          if (key !== reverseKey) {
            value(obj, reverseKey, key);
          }
        }
        if (Array.isArray(obj.__enums__)) {
          updateList(obj);
        }
        return obj;
      };
      (function (_Enum) {})(Enum || (exports("Enum", Enum = {})));
      Enum.isEnum = enumType => enumType && hasOwnPropertyProto.call(enumType, '__enums__');
      function assertIsEnum(enumType) {
        assertIsTrue(hasOwnPropertyProto.call(enumType, '__enums__'));
      }
      Enum.getList = enumType => {
        assertIsEnum(enumType);
        if (enumType.__enums__) {
          return enumType.__enums__;
        }
        return updateList(enumType);
      };
      function updateList(enumType) {
        assertIsEnum(enumType);
        const enums = enumType.__enums__ || [];
        enums.length = 0;
        let isAllInteger = true;
        for (const name in enumType) {
          const v = enumType[name];
          const isIntegerValue = Number.isInteger(v);
          if (!isIntegerValue) {
            isAllInteger = false;
          }
          if (isIntegerValue || typeof v === 'string' && enumType[v] !== Number.parseInt(name)) {
            enums.push({
              name,
              value: v
            });
          }
        }
        if (isAllInteger) {
          enums.sort((a, b) => a.value - b.value);
        }
        enumType.__enums__ = enums;
        return enums;
      }
      Enum.sortList = (enumType, compareFn) => {
        assertIsEnum(enumType);
        if (!Array.isArray(enumType.__enums__)) {
          return;
        }
        enumType.__enums__.sort(compareFn);
      };
      function ccenum(enumType) {
        if (!('__enums__' in enumType)) {
          value(enumType, '__enums__', null, true);
        }
      }
      legacyCC.Enum = Enum;

      class ValueType {
        clone() {
          errorID(100, `${getClassName(this)}.clone`);
          return this;
        }
        equals(other) {
          return false;
        }
        set(other) {
          errorID(100, `${getClassName(this)}.set`);
        }
        toString() {
          return `${''}`;
        }
      } exports("ValueType", ValueType);
      setClassName('cc.ValueType', ValueType);
      legacyCC.ValueType = ValueType;

      const SettingsCategory = exports("SettingsCategory", {
        "PATH": "path",
        "ENGINE": "engine",
        "ASSETS": "assets",
        "SCRIPTING": "scripting",
        "PHYSICS": "physics",
        "RENDERING": "rendering",
        "LAUNCH": "launch",
        "SCREEN": "screen",
        "SPLASH_SCREEN": "splashScreen",
        "ANIMATION": "animation",
        "PROFILING": "profiling",
        "PLUGINS": "plugins",
        "XR": "xr"
      });
      class Settings {
        constructor() {
          this._settings = {};
          this._override = {};
        }
        init(path = '', overrides = {}) {
          for (const categoryName in overrides) {
            const category = overrides[categoryName];
            if (category) {
              for (const name in category) {
                this.overrideSettings(categoryName, name, category[name]);
              }
            }
          }
          if (!path) return Promise.resolve();
          {
            if (window.oh && window.scriptEngineType === 'napi') {
              return new Promise((resolve, reject) => {
                const settingsModule = '../settings.js';
                module.import(settingsModule).then(res => {
                  this._settings = res.default;
                  resolve();
                }).catch(e => reject(e));
              });
            }
          }
          return new Promise((resolve, reject) => {
            if (!path.startsWith('http')) {
              {
                const result = fsUtils.readJsonSync(path);
                if (result instanceof Error) {
                  reject(result);
                } else {
                  this._settings = result;
                  resolve();
                }
              }
            } else {
              const xhr = new XMLHttpRequest();
              xhr.open('GET', path);
              xhr.responseType = 'text';
              xhr.onload = () => {
                this._settings = JSON.parse(xhr.response);
                resolve();
              };
              xhr.onerror = () => {
                reject(new Error('request settings failed!'));
              };
              xhr.send(null);
            }
          });
        }
        overrideSettings(category, name, value) {
          if (!(category in this._override)) {
            this._override[category] = {};
          }
          this._override[category][name] = value;
        }
        querySettings(category, name) {
          if (category in this._override) {
            const categorySettings = this._override[category];
            if (categorySettings && name in categorySettings) {
              return categorySettings[name];
            }
          }
          if (category in this._settings) {
            const categorySettings = this._settings[category];
            if (categorySettings && name in categorySettings) {
              return categorySettings[name];
            }
          }
          return null;
        }
      } exports("Settings", Settings);
      Settings.Category = SettingsCategory;
      const settings = exports("settings", new Settings());
      legacyCC.settings = settings;

      let Orientation$1;
      (function (Orientation) {
        Orientation[Orientation["PORTRAIT"] = 1] = "PORTRAIT";
        Orientation[Orientation["PORTRAIT_UPSIDE_DOWN"] = 2] = "PORTRAIT_UPSIDE_DOWN";
        Orientation[Orientation["LANDSCAPE_LEFT"] = 4] = "LANDSCAPE_LEFT";
        Orientation[Orientation["LANDSCAPE_RIGHT"] = 8] = "LANDSCAPE_RIGHT";
        Orientation[Orientation["LANDSCAPE"] = 12] = "LANDSCAPE";
        Orientation[Orientation["AUTO"] = 13] = "AUTO";
      })(Orientation$1 || (Orientation$1 = {}));

      const SUPPORT_TEXTURE_FORMATS = ['.astc', '.pkm', '.pvr', '.webp', '.jpg', '.jpeg', '.bmp', '.png'];
      const KEY = {
        none: 0,
        back: 6,
        menu: 18,
        backspace: 8,
        tab: 9,
        enter: 13,
        shift: 16,
        ctrl: 17,
        alt: 18,
        pause: 19,
        capslock: 20,
        escape: 27,
        space: 32,
        pageup: 33,
        pagedown: 34,
        end: 35,
        home: 36,
        left: 37,
        up: 38,
        right: 39,
        down: 40,
        select: 41,
        insert: 45,
        Delete: 46,
        0: 48,
        1: 49,
        2: 50,
        3: 51,
        4: 52,
        5: 53,
        6: 54,
        7: 55,
        8: 56,
        9: 57,
        a: 65,
        b: 66,
        c: 67,
        d: 68,
        e: 69,
        f: 70,
        g: 71,
        h: 72,
        i: 73,
        j: 74,
        k: 75,
        l: 76,
        m: 77,
        n: 78,
        o: 79,
        p: 80,
        q: 81,
        r: 82,
        s: 83,
        t: 84,
        u: 85,
        v: 86,
        w: 87,
        x: 88,
        y: 89,
        z: 90,
        num0: 96,
        num1: 97,
        num2: 98,
        num3: 99,
        num4: 100,
        num5: 101,
        num6: 102,
        num7: 103,
        num8: 104,
        num9: 105,
        '*': 106,
        '+': 107,
        '-': 109,
        numdel: 110,
        '/': 111,
        f1: 112,
        f2: 113,
        f3: 114,
        f4: 115,
        f5: 116,
        f6: 117,
        f7: 118,
        f8: 119,
        f9: 120,
        f10: 121,
        f11: 122,
        f12: 123,
        numlock: 144,
        scrolllock: 145,
        ';': 186,
        semicolon: 186,
        equal: 187,
        '=': 187,
        ',': 188,
        comma: 188,
        dash: 189,
        '.': 190,
        period: 190,
        forwardslash: 191,
        grave: 192,
        '[': 219,
        openbracket: 219,
        backslash: 220,
        ']': 221,
        closebracket: 221,
        quote: 222,
        dpadLeft: 1000,
        dpadRight: 1001,
        dpadUp: 1003,
        dpadDown: 1004,
        dpadCenter: 1005
      };
      const macro = exports("macro", {
        SUPPORT_TEXTURE_FORMATS,
        KEY,
        RAD: Math.PI / 180,
        DEG: 180 / Math.PI,
        REPEAT_FOREVER: Number.MAX_VALUE - 1,
        FLT_EPSILON: 0.0000001192092896,
        ORIENTATION_PORTRAIT: Orientation$1.PORTRAIT,
        ORIENTATION_PORTRAIT_UPSIDE_DOWN: Orientation$1.PORTRAIT_UPSIDE_DOWN,
        ORIENTATION_LANDSCAPE: Orientation$1.LANDSCAPE,
        ORIENTATION_LANDSCAPE_LEFT: Orientation$1.LANDSCAPE_LEFT,
        ORIENTATION_LANDSCAPE_RIGHT: Orientation$1.LANDSCAPE_RIGHT,
        ORIENTATION_AUTO: Orientation$1.AUTO,
        ENABLE_TILEDMAP_CULLING: true,
        TOUCH_TIMEOUT: 5000,
        ENABLE_TRANSPARENT_CANVAS: false,
        ENABLE_WEBGL_ANTIALIAS: true,
        ENABLE_FLOAT_OUTPUT: false,
        CLEANUP_IMAGE_CACHE: false,
        ENABLE_MULTI_TOUCH: true,
        MAX_LABEL_CANVAS_POOL_SIZE: 20,
        ENABLE_WEBGL_HIGHP_STRUCT_VALUES: false,
        BATCHER2D_MEM_INCREMENT: 144,
        CUSTOM_PIPELINE_NAME: 'Builtin',
        init() {
          {
            this.CLEANUP_IMAGE_CACHE = true;
          }
          const defaultValues = settings.querySettings("engine", 'macros');
          if (defaultValues) {
            for (const key in defaultValues) {
              macro[key] = defaultValues[key];
            }
          }
        }
      });
      legacyCC.macro = macro;

      function setTimeoutRAF(callback, delay, ...args) {
        var _globalThis$__globalX;
        const start = performance.now();
        const raf = requestAnimationFrame || window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame;
        if (raf === undefined || (_globalThis$__globalX = globalThis.__globalXR) !== null && _globalThis$__globalX !== void 0 && _globalThis$__globalX.isWebXR) {
          return setTimeout(callback, delay, ...args);
        }
        const handleRAF = () => {
          if (performance.now() - start < delay) {
            raf(handleRAF);
          } else {
            callback(...args);
          }
        };
        return raf(handleRAF);
      }

      const BUILTIN_CLASSID_RE = /^(?:cc|dragonBones|sp|ccsg)\..+/;
      const BASE64_KEYS$1 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
      const values = new Array(123);
      for (let i = 0; i < 123; ++i) {
        values[i] = 64;
      }
      for (let i = 0; i < 64; ++i) {
        values[BASE64_KEYS$1.charCodeAt(i)] = i;
      }
      const BASE64_VALUES$1 = values;
      function propertyDefine(ctor, sameNameGetSets, diffNameGetSets) {
        function define(np, propName, getter, setter) {
          const pd = Object.getOwnPropertyDescriptor(np, propName);
          if (pd) {
            if (pd.get && getter) {
              np[getter] = pd.get;
            }
            if (pd.set && setter) {
              np[setter] = pd.set;
            }
          } else {
            const getterFunc = np[getter];
            {
              getset(np, propName, getterFunc, np[setter]);
            }
          }
        }
        let propName;
        const np = ctor.prototype;
        for (let i = 0, len = sameNameGetSets.length; i < len; ++i) {
          propName = sameNameGetSets[i];
          const suffix = propName[0].toUpperCase() + propName.slice(1);
          define(np, propName, `get${suffix}`, `set${suffix}`);
        }
        for (propName in diffNameGetSets) {
          const gs = diffNameGetSets[propName];
          define(np, propName, gs[0], gs[1]);
        }
      }
      function pushToMap(map, key, value, pushFront) {
        const exists = map[key];
        if (exists) {
          if (Array.isArray(exists)) {
            if (pushFront) {
              exists.push(exists[0]);
              exists[0] = value;
            } else {
              exists.push(value);
            }
          } else {
            map[key] = pushFront ? [value, exists] : [exists, value];
          }
        } else {
          map[key] = value;
        }
      }
      function contains$1(refNode, otherNode) {
        if (typeof refNode.contains === 'function') {
          return refNode.contains(otherNode);
        } else if (typeof refNode.compareDocumentPosition === 'function') {
          return !!(refNode.compareDocumentPosition(otherNode) & 16);
        } else {
          let node = otherNode.parentNode;
          if (node) {
            do {
              if (node === refNode) {
                return true;
              } else {
                node = node.parentNode;
              }
            } while (node !== null);
          }
          return false;
        }
      }
      function isDomNode(node) {
        if (typeof window === 'object' && typeof Node === 'function') {
          return node instanceof Node;
        } else {
          return !!node && typeof node === 'object' && typeof node.nodeType === 'number' && typeof node.nodeName === 'string';
        }
      }
      function callInNextTick(callback, ...args) {
        if (callback) {
          setTimeoutRAF(() => {
            callback(...args);
          }, 0);
        }
      }
      function tryCatchFunctor_EDITOR(funcName) {
        return Function('target', `${'try {\n' + '  target.'}${funcName}();\n` + `}\n` + `catch (e) {\n` + `  cc._throw(e);\n` + `}`);
      }
      function isPlainEmptyObj_DEV(obj) {
        if (!obj || obj.constructor !== Object) {
          return false;
        }
        return isEmptyObject(obj);
      }
      function clampf(value, min_inclusive, max_inclusive) {
        if (min_inclusive > max_inclusive) {
          const temp = min_inclusive;
          min_inclusive = max_inclusive;
          max_inclusive = temp;
        }
        return value < min_inclusive ? min_inclusive : value < max_inclusive ? value : max_inclusive;
      }
      function degreesToRadians(angle) {
        return angle * macro.RAD;
      }
      function radiansToDegrees(angle) {
        return angle * macro.DEG;
      }
      legacyCC.misc = {
        BUILTIN_CLASSID_RE,
        BASE64_VALUES: BASE64_VALUES$1,
        propertyDefine,
        pushToMap,
        contains: contains$1,
        isDomNode,
        callInNextTick,
        isPlainEmptyObj_DEV,
        clampf,
        degreesToRadians,
        radiansToDegrees
      };

      var misc = /*#__PURE__*/Object.freeze({
        __proto__: null,
        BASE64_VALUES: BASE64_VALUES$1,
        BUILTIN_CLASSID_RE: BUILTIN_CLASSID_RE,
        callInNextTick: callInNextTick,
        clampf: clampf,
        contains: contains$1,
        degreesToRadians: degreesToRadians,
        isDomNode: isDomNode,
        isPlainEmptyObj_DEV: isPlainEmptyObj_DEV,
        propertyDefine: propertyDefine,
        pushToMap: pushToMap,
        radiansToDegrees: radiansToDegrees,
        tryCatchFunctor_EDITOR: tryCatchFunctor_EDITOR
      });
      exports("misc", misc);

      const DELIMETER$1 = '$_$';
      function createAttrsSingle(owner, superAttrs) {
        const attrs = superAttrs ? Object.create(superAttrs) : {};
        value(owner, '__attrs__', attrs);
        return attrs;
      }
      function createAttrs(subclass) {
        if (typeof subclass !== 'function') {
          const instance = subclass;
          return createAttrsSingle(instance, getClassAttrs(instance.constructor));
        }
        let superClass;
        const chains = legacyCC.Class.getInheritanceChain(subclass);
        for (let i = chains.length - 1; i >= 0; i--) {
          const cls = chains[i];
          const attrs = cls.hasOwnProperty('__attrs__') && cls.__attrs__;
          if (!attrs) {
            superClass = chains[i + 1];
            createAttrsSingle(cls, superClass && superClass.__attrs__);
          }
        }
        superClass = chains[0];
        createAttrsSingle(subclass, superClass && superClass.__attrs__);
        return subclass.__attrs__;
      }
      function attr(constructor, propertyName) {
        const attrs = getClassAttrs(constructor);
        const prefix = propertyName + DELIMETER$1;
        const ret = {};
        for (const key in attrs) {
          if (key.startsWith(prefix)) {
            ret[key.slice(prefix.length)] = attrs[key];
          }
        }
        return ret;
      }
      function getClassAttrs(constructor) {
        return constructor.hasOwnProperty('__attrs__') && constructor.__attrs__ || createAttrs(constructor);
      }
      function setClassAttr(ctor, propName, key, value) {
        getClassAttrs(ctor)[propName + DELIMETER$1 + key] = value;
      }
      class PrimitiveType {
        constructor(name, defaultValue) {
          this.name = name;
          this.default = defaultValue;
        }
        toString() {
          return this.name;
        }
      }
      const CCInteger = exports("CCInteger", new PrimitiveType('Integer', 0));
      legacyCC.Integer = CCInteger;
      legacyCC.CCInteger = CCInteger;
      const CCFloat = exports("CCFloat", new PrimitiveType('Float', 0.0));
      legacyCC.Float = CCFloat;
      legacyCC.CCFloat = CCFloat;
      const CCBoolean = exports("CCBoolean", new PrimitiveType('Boolean', false));
      legacyCC.Boolean = CCBoolean;
      legacyCC.CCBoolean = CCBoolean;
      const CCString = exports("CCString", new PrimitiveType('String', ''));
      legacyCC.String = CCString;
      legacyCC.CCString = CCString;
      function getTypeChecker_ET(type, attributeName) {
        return function (constructor, mainPropertyName) {
          const propInfo = `"${getClassName(constructor)}.${mainPropertyName}"`;
          const mainPropAttrs = attr(constructor, mainPropertyName);
          let mainPropAttrsType = mainPropAttrs.type;
          if (mainPropAttrsType === CCInteger || mainPropAttrsType === CCFloat) {
            mainPropAttrsType = 'Number';
          } else if (mainPropAttrsType === CCString || mainPropAttrsType === CCBoolean) {
            mainPropAttrsType = `${mainPropAttrsType}`;
          }
          if (mainPropAttrsType !== type) {
            warnID(3604, propInfo);
            return;
          }
          if (!mainPropAttrs.hasOwnProperty('default')) {
            return;
          }
          const defaultVal = mainPropAttrs.default;
          if (typeof defaultVal === 'undefined') {
            return;
          }
          const isContainer = Array.isArray(defaultVal) || isPlainEmptyObj_DEV(defaultVal);
          if (isContainer) {
            return;
          }
          const defaultType = typeof defaultVal;
          const type_lowerCase = type.toLowerCase();
          if (defaultType === type_lowerCase) {
            if (type_lowerCase === 'object') {
              if (defaultVal && !(defaultVal instanceof mainPropAttrs.ctor)) {
                warnID(3605, propInfo, getClassName(mainPropAttrs.ctor));
              } else {
                return;
              }
            } else if (type !== 'Number') {
              warnID(3606, attributeName, propInfo, type);
            }
          } else if (defaultType !== 'function') {
            if (type === CCString.default && defaultVal == null) {
              warnID(3607, propInfo);
            } else {
              warnID(3611, attributeName, propInfo, defaultType);
            }
          } else {
            return;
          }
          delete mainPropAttrs.type;
        };
      }
      function getObjTypeChecker_ET(typeCtor) {
        return function (classCtor, mainPropName) {
          getTypeChecker_ET('Object', 'type')(classCtor, mainPropName);
          const defaultDef = getClassAttrs(classCtor)[`${mainPropName + DELIMETER$1}default`];
          const defaultVal = legacyCC.Class.getDefault(defaultDef);
          if (!Array.isArray(defaultVal) && isChildClassOf(typeCtor, legacyCC.ValueType)) {
            const typename = getClassName(typeCtor);
            const info = formatStr('No need to specify the "type" of "%s.%s" because %s is a child class of ValueType.', getClassName(classCtor), mainPropName, typename);
            if (defaultDef) {
              log(info);
            } else {
              warnID(3612, info, typename, getClassName(classCtor), mainPropName, typename);
            }
          }
        };
      }

      var attributeUtils = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CCBoolean: CCBoolean,
        CCFloat: CCFloat,
        CCInteger: CCInteger,
        CCString: CCString,
        DELIMETER: DELIMETER$1,
        PrimitiveType: PrimitiveType,
        attr: attr,
        createAttrs: createAttrs,
        createAttrsSingle: createAttrsSingle,
        getClassAttrs: getClassAttrs,
        getObjTypeChecker_ET: getObjTypeChecker_ET,
        getTypeChecker_ET: getTypeChecker_ET,
        setClassAttr: setClassAttr
      });

      const SerializableAttrs = {
        default: {},
        serializable: {},
        editorOnly: {},
        formerlySerializedAs: {}
      };
      function parseNotify(val, propName, notify, properties) {
        if (val.get || val.set) {
          return;
        }
        if (val.hasOwnProperty('default')) {
          const newKey = `_N$${propName}`;
          val.get = function () {
            return this[newKey];
          };
          val.set = function (value) {
            const oldValue = this[newKey];
            this[newKey] = value;
            notify.call(this, oldValue);
          };
          const newValue = {};
          properties[newKey] = newValue;
          for (const attr in SerializableAttrs) {
            const v = SerializableAttrs[attr];
            if (val.hasOwnProperty(attr)) {
              newValue[attr] = val[attr];
              if (!v.canUsedInGet) {
                delete val[attr];
              }
            }
          }
        }
      }
      function parseType(val, type, className, propName) {
        if (Array.isArray(type)) {
          if (type.length > 0) {
            val.type = type = type[0];
          } else {
            return errorID(5508, className, propName);
          }
        }
        if (typeof type === 'function') {
          if (type === String) {
            val.type = legacyCC.String;
          } else if (type === Boolean) {
            val.type = legacyCC.Boolean;
          } else if (type === Number) {
            val.type = legacyCC.Float;
          }
        }
      }
      function _wrapOptions(isGetset, _default, type) {
        const res = isGetset || typeof _default === 'undefined' ? {
          _short: true
        } : {
          _short: true,
          default: _default
        };
        if (type) {
          res.type = type;
        }
        return res;
      }
      function getFullFormOfProperty(options, isGetset) {
        const isLiteral = options && options.constructor === Object;
        if (!isLiteral) {
          if (Array.isArray(options) && options.length > 0) {
            return _wrapOptions(isGetset, [], options);
          } else if (typeof options === 'function') {
            const type = options;
            return _wrapOptions(isGetset, isChildClassOf(type, legacyCC.ValueType) ? new type() : null, type);
          } else if (options instanceof PrimitiveType) {
            return _wrapOptions(isGetset, undefined, options);
          } else {
            return _wrapOptions(isGetset, options);
          }
        }
        return null;
      }
      function preprocessAttrs(properties, className, cls) {
        for (const propName in properties) {
          let val = properties[propName];
          const fullForm = getFullFormOfProperty(val, false);
          if (fullForm) {
            val = properties[propName] = fullForm;
          }
          if (val) {
            const notify = val.notify;
            if (notify) {
              {
                parseNotify(val, propName, notify, properties);
              }
            }
            if ('type' in val) {
              parseType(val, val.type, className, propName);
            }
          }
        }
      }

      let requiringFrames = [];
      function push(module, uuid, script, importMeta) {
        if (script === undefined) {
          script = uuid;
          uuid = '';
        }
        requiringFrames.push({
          uuid,
          script,
          module,
          exports: module.exports,
          beh: null,
          importMeta
        });
      }
      function pop() {
        const frameInfo = requiringFrames.pop();
        const module = frameInfo.module;
        let exports = module.exports;
        if (exports === frameInfo.exports) {
          for (const anykey in exports) {
            return;
          }
          module.exports = exports = frameInfo.cls;
        }
      }
      function peek() {
        return requiringFrames[requiringFrames.length - 1];
      }
      legacyCC._RF = {
        push,
        pop,
        peek
      };

      function setPropertyEnumType(objectOrConstructor, propertyName, enumType) {
        setPropertyEnumTypeOnAttrs(getClassAttrs(objectOrConstructor), propertyName, enumType);
      }
      function setPropertyEnumTypeOnAttrs(attrs, propertyName, enumType) {
        attrs[`${propertyName}${DELIMETER$1}type`] = 'Enum';
        attrs[`${propertyName}${DELIMETER$1}enumList`] = Enum.getList(enumType);
      }

      const DELIMETER = DELIMETER$1;
      const CCCLASS_TAG = '__ctors__';
      const ENUM_TAG = exports("ENUM_TAG", 'Enum');
      const BITMASK_TAG = exports("BITMASK_TAG", 'BitMask');
      function pushUnique(array, item) {
        if (array.indexOf(item) < 0) {
          array.push(item);
        }
      }
      function appendProp(cls, name) {
        pushUnique(cls.__props__, name);
      }
      function defineProp(cls, className, propName, val) {
        appendProp(cls, propName);
        parseAttributes(cls, val, className, propName);
      }
      function defineGetSet(cls, name, propName, val) {
        const getter = val.get;
        val.set;
        if (getter) {
          parseAttributes(cls, val, name, propName);
          setClassAttr(cls, propName, 'serializable', false);
        }
      }
      function getDefault(defaultVal) {
        if (typeof defaultVal === 'function') {
          {
            return defaultVal();
          }
        }
        return defaultVal;
      }
      function doDefine(className, baseClass, options) {
        const ctor = options.ctor;
        value(ctor, CCCLASS_TAG, true, true);
        ctor.prototype;
        if (baseClass) {
          ctor.$super = baseClass;
        }
        setClassName(className, ctor);
        return ctor;
      }
      function define$1(className, baseClass, options) {
        const Component = legacyCC.Component;
        const frame = peek();
        if (frame && isChildClassOf(baseClass, Component)) {
          if (isChildClassOf(frame.cls, Component)) {
            errorID(3615);
            return null;
          }
          className = className || frame.script;
        }
        const cls = doDefine(className, baseClass, options);
        if (frame) {
          if (isChildClassOf(baseClass, Component)) {
            const uuid = frame.uuid;
            if (uuid) {
              _setClassId(uuid, cls);
            }
            frame.cls = cls;
          } else if (!isChildClassOf(frame.cls, Component)) {
            frame.cls = cls;
          }
        }
        return cls;
      }
      function getNewValueTypeCodeJit(value) {
        const clsName = getClassName(value);
        const type = value.constructor;
        let res = `new ${clsName}(`;
        for (let i = 0; i < type.__props__.length; i++) {
          const prop = type.__props__[i];
          const propVal = value[prop];
          res += propVal;
          if (i < type.__props__.length - 1) {
            res += ',';
          }
        }
        return `${res})`;
      }
      function escapeForJS$1(s) {
        return JSON.stringify(s).replace(/\u2028/g, '\\u2028').replace(/\u2029/g, '\\u2029');
      }
      const IDENTIFIER_RE$1 = /^[A-Za-z_$][0-9A-Za-z_$]*$/;
      function declareProperties(cls, className, properties, baseClass) {
        cls.__props__ = [];
        if (baseClass && baseClass.__props__) {
          cls.__props__ = baseClass.__props__.slice();
        }
        if (properties) {
          preprocessAttrs(properties, className);
          for (const propName in properties) {
            const val = properties[propName];
            if (!val.get && !val.set) {
              defineProp(cls, className, propName, val);
            } else {
              defineGetSet(cls, className, propName, val);
            }
          }
        }
        const attrs = getClassAttrs(cls);
        cls.__values__ = cls.__props__.filter(prop => attrs[`${prop}${DELIMETER}serializable`] !== false);
      }
      function CCClass(options) {
        let name = options.name;
        const base = options.extends;
        const cls = define$1(name, base, options);
        if (!name) {
          name = legacyCC.js.getClassName(cls);
        }
        cls._sealed = true;
        if (base) {
          base._sealed = false;
        }
        const properties = options.properties;
        declareProperties(cls, name, properties, base);
        const editor = options.editor;
        if (editor) {
          if (isChildClassOf(base, legacyCC.Component)) {
            legacyCC.Component._registerEditorProps(cls, editor);
          }
        }
        return cls;
      }
      CCClass._isCCClass = function isCCClass(constructor) {
        var _constructor$hasOwnPr;
        return constructor === null || constructor === void 0 ? void 0 : (_constructor$hasOwnPr = constructor.hasOwnProperty) === null || _constructor$hasOwnPr === void 0 ? void 0 : _constructor$hasOwnPr.call(constructor, CCCLASS_TAG);
      };
      CCClass.fastDefine = function (className, constructor, serializableFields) {
        setClassName(className, constructor);
        const props = constructor.__props__ = constructor.__values__ = Object.keys(serializableFields);
        const attrs = getClassAttrs(constructor);
        for (let i = 0; i < props.length; i++) {
          const key = props[i];
          attrs[`${key + DELIMETER}visible`] = false;
          attrs[`${key + DELIMETER}default`] = serializableFields[key];
        }
      };
      CCClass.Attr = attributeUtils;
      CCClass.attr = attr;
      function isCCClassOrFastDefined(constructor) {
        var _constructor$hasOwnPr2;
        return constructor === null || constructor === void 0 ? void 0 : (_constructor$hasOwnPr2 = constructor.hasOwnProperty) === null || _constructor$hasOwnPr2 === void 0 ? void 0 : _constructor$hasOwnPr2.call(constructor, '__values__');
      }
      CCClass.isCCClassOrFastDefined = isCCClassOrFastDefined;
      function getInheritanceChain(constructor) {
        const chain = [];
        for (;;) {
          constructor = getSuper(constructor);
          if (!constructor) {
            break;
          }
          if (constructor !== Object) {
            chain.push(constructor);
          }
        }
        return chain;
      }
      CCClass.getInheritanceChain = getInheritanceChain;
      const PrimitiveTypes = {
        Integer: 'Number',
        Float: 'Number',
        Boolean: 'Boolean',
        String: 'String'
      };
      function parseAttributes(constructor, attributes, className, propertyName, usedInGetter) {
        let attrs = null;
        let propertyNamePrefix = '';
        function initAttrs() {
          propertyNamePrefix = propertyName + DELIMETER;
          return attrs = getClassAttrs(constructor);
        }
        if ('type' in attributes && typeof attributes.type === 'undefined') {
          warnID(3660, propertyName, className);
        }
        const type = attributes.type;
        if (type) {
          const primitiveType = PrimitiveTypes[type];
          if (primitiveType) {
            (attrs || initAttrs())[`${propertyNamePrefix}type`] = type;
          } else if (type === 'Object') ; else if (typeof type === 'object') {
            if (Enum.isEnum(type)) {
              setPropertyEnumTypeOnAttrs(attrs || initAttrs(), propertyName, type);
            } else if (BitMask.isBitMask(type)) {
              (attrs || initAttrs())[`${propertyNamePrefix}type`] = BITMASK_TAG;
              attrs[`${propertyNamePrefix}bitmaskList`] = BitMask.getList(type);
            } else ;
          } else if (typeof type === 'function') {
            (attrs || initAttrs())[`${propertyNamePrefix}type`] = 'Object';
            attrs[`${propertyNamePrefix}ctor`] = type;
          } else ;
        }
        if ('default' in attributes) {
          (attrs || initAttrs())[`${propertyNamePrefix}default`] = attributes.default;
        }
        const parseSimpleAttribute = (attributeName, expectType) => {
          if (attributeName in attributes) {
            const val = attributes[attributeName];
            if (typeof val === expectType) {
              (attrs || initAttrs())[propertyNamePrefix + attributeName] = val;
            }
          }
        };
        if (attributes.editorOnly) {
          {
            (attrs || initAttrs())[`${propertyNamePrefix}editorOnly`] = true;
          }
        }
        const isStandaloneMode = attributes.__internalFlags & 1;
        let normalizedSerializable;
        if (isStandaloneMode) {
          normalizedSerializable = attributes.serializable === true || (attributes.__internalFlags & 4) !== 0;
        } else if (attributes.serializable === false) {
          normalizedSerializable = false;
        }
        if (typeof normalizedSerializable !== 'undefined') {
          (attrs || initAttrs())[`${propertyNamePrefix}serializable`] = normalizedSerializable;
        }
        parseSimpleAttribute('formerlySerializedAs', 'string');
        const range = attributes.range;
        if (range) {
          if (Array.isArray(range)) {
            if (range.length >= 2) {
              (attrs || initAttrs())[`${propertyNamePrefix}min`] = range[0];
              attrs[`${propertyNamePrefix}max`] = range[1];
              if (range.length > 2) {
                attrs[`${propertyNamePrefix}step`] = range[2];
              }
            }
          }
        }
        parseSimpleAttribute('step', 'number');
        parseSimpleAttribute('userData', 'object');
      }
      CCClass.isArray = function (defaultVal) {
        defaultVal = getDefault(defaultVal);
        return Array.isArray(defaultVal);
      };
      CCClass.getDefault = getDefault;
      CCClass.escapeForJS = escapeForJS$1;
      CCClass.IDENTIFIER_RE = IDENTIFIER_RE$1;
      CCClass.getNewValueTypeCode = getNewValueTypeCodeJit;
      legacyCC.Class = CCClass;

      const _d2r = Math.PI / 180.0;
      const _r2d = 180.0 / Math.PI;
      let _random = Math.random;
      const HALF_PI = exports("HALF_PI", Math.PI * 0.5);
      const TWO_PI = exports("TWO_PI", Math.PI * 2.0);
      const EPSILON$2 = exports("EPSILON", 0.000001);
      function equals$2(a, b) {
        return Math.abs(a - b) <= EPSILON$2 * Math.max(1.0, Math.abs(a), Math.abs(b));
      }
      function approx(a, b, maxDiff) {
        maxDiff = maxDiff || EPSILON$2;
        return Math.abs(a - b) <= maxDiff;
      }
      function clamp$1(val, min, max) {
        if (min > max) {
          const temp = min;
          min = max;
          max = temp;
        }
        return val < min ? min : val > max ? max : val;
      }
      function clamp01(val) {
        return val < 0 ? 0 : val > 1 ? 1 : val;
      }
      function lerp(from, to, ratio) {
        return from + (to - from) * ratio;
      }
      function toRadian(a) {
        return a * _d2r;
      }
      function toDegree(a) {
        return a * _r2d;
      }
      function random() {
        return _random();
      }
      function setRandGenerator(func) {
        _random = func;
      }
      function randomRange(min, max) {
        return random() * (max - min) + min;
      }
      function randomRangeInt(min, max) {
        return Math.floor(randomRange(min, max));
      }
      function pseudoRandom(seed) {
        seed = (seed * 9301 + 49297) % 233280;
        return seed / 233280.0;
      }
      function pseudoRandomRange(seed, min, max) {
        return pseudoRandom(seed) * (max - min) + min;
      }
      function pseudoRandomRangeInt(seed, min, max) {
        return Math.floor(pseudoRandomRange(seed, min, max));
      }
      function nextPow2(val) {
        return nextPow2$1(val);
      }
      function repeat$2(t, length) {
        return t - Math.floor(t / length) * length;
      }
      function pingPong(t, length) {
        t = repeat$2(t, length * 2);
        t = length - Math.abs(t - length);
        return t;
      }
      function inverseLerp(from, to, value) {
        return (value - from) / (to - from);
      }
      function absMaxComponent(v) {
        if (Math.abs(v.x) > Math.abs(v.y)) {
          if (Math.abs(v.x) > Math.abs(v.z)) {
            return v.x;
          } else {
            return v.z;
          }
        } else if (Math.abs(v.y) > Math.abs(v.z)) {
          return v.y;
        } else {
          return v.z;
        }
      }
      function absMax(a, b) {
        if (Math.abs(a) > Math.abs(b)) {
          return a;
        } else {
          return b;
        }
      }
      function enumerableProps(prototype, attrs) {
        attrs.forEach(key => {
          Object.defineProperty(prototype, key, {
            enumerable: true
          });
        });
      }
      const toHalf = function toHalf() {
        const floatView = new Float32Array(1);
        const int32View = new Int32Array(floatView.buffer);
        return function toHalf(fval) {
          floatView[0] = fval;
          const fbits = int32View[0];
          const s = fbits >> 16 & 0x8000;
          const em = fbits & 0x7fffffff;
          let h = em - (112 << 23) + (1 << 12) >> 13;
          h = em < 113 << 23 ? 0 : h;
          h = em >= 143 << 23 ? 0x7c00 : h;
          h = em > 255 << 23 ? 0x7e00 : h;
          int32View[0] = s | h;
          return int32View[0];
        };
      }();
      const fromHalf = function fromHalf() {
        const floatView = new Float32Array(1);
        const int32View = new Int32Array(floatView.buffer);
        return function fromHalf(hval) {
          const s = hval >> 15 & 0x00000001;
          const em = hval & 0x00007fff;
          let h = em << 13;
          let fbits = 0;
          if (h !== 0x7c00) {
            h += 112 << 23;
            if (em === 0) {
              h = (h & 0xfffff) >> 1;
            } else if (em === 0x7fff) {
              h = 0x7fffffff;
            }
          } else {
            h = 0x7f800000;
          }
          fbits = s << 31 | h;
          int32View[0] = fbits;
          return floatView[0];
        };
      }();
      function floatToHalf(val) {
        return toHalf(val);
      }
      function halfToFloat(val) {
        return fromHalf(val);
      }

      var _class$2y;
      const abs$6 = Math.abs;
      const max$a = Math.max;
      const min$7 = Math.min;
      const PI$5 = Math.PI;
      const sin$6 = Math.sin;
      const cos$7 = Math.cos;
      const atan2$3 = Math.atan2;
      const sqrt$5 = Math.sqrt;
      const ceil$4 = Math.ceil;
      const floor$2 = Math.floor;
      const round$2 = Math.round;
      class Vec4 extends ValueType {
        static clone(a) {
          return new Vec4(a.x, a.y, a.z, a.w);
        }
        static copy(out, a) {
          out.x = a.x;
          out.y = a.y;
          out.z = a.z;
          out.w = a.w;
          return out;
        }
        static set(out, x, y, z, w) {
          out.x = x;
          out.y = y;
          out.z = z;
          out.w = w;
          return out;
        }
        static fromColor(out, color) {
          out.x = color.r;
          out.y = color.g;
          out.z = color.b;
          out.w = color.a;
          return out;
        }
        static angle(a, b) {
          const dx = a.y * b.z - a.z * b.y;
          const dy = a.z * b.x - a.x * b.z;
          const dz = a.x * b.y - a.y * b.x;
          const dotVal = a.x * b.x + a.y * b.y + a.z * b.z;
          return atan2$3(sqrt$5(dx * dx + dy * dy + dz * dz), dotVal);
        }
        static add(out, a, b) {
          out.x = a.x + b.x;
          out.y = a.y + b.y;
          out.z = a.z + b.z;
          out.w = a.w + b.w;
          return out;
        }
        static subtract(out, a, b) {
          out.x = a.x - b.x;
          out.y = a.y - b.y;
          out.z = a.z - b.z;
          out.w = a.w - b.w;
          return out;
        }
        static multiply(out, a, b) {
          out.x = a.x * b.x;
          out.y = a.y * b.y;
          out.z = a.z * b.z;
          out.w = a.w * b.w;
          return out;
        }
        static divide(out, a, b) {
          out.x = a.x / b.x;
          out.y = a.y / b.y;
          out.z = a.z / b.z;
          out.w = a.w / b.w;
          return out;
        }
        static ceil(out, a) {
          out.x = ceil$4(a.x);
          out.y = ceil$4(a.y);
          out.z = ceil$4(a.z);
          out.w = ceil$4(a.w);
          return out;
        }
        static floor(out, a) {
          out.x = floor$2(a.x);
          out.y = floor$2(a.y);
          out.z = floor$2(a.z);
          out.w = floor$2(a.w);
          return out;
        }
        static min(out, a, b) {
          out.x = min$7(a.x, b.x);
          out.y = min$7(a.y, b.y);
          out.z = min$7(a.z, b.z);
          out.w = min$7(a.w, b.w);
          return out;
        }
        static max(out, a, b) {
          out.x = max$a(a.x, b.x);
          out.y = max$a(a.y, b.y);
          out.z = max$a(a.z, b.z);
          out.w = max$a(a.w, b.w);
          return out;
        }
        static round(out, a) {
          out.x = round$2(a.x);
          out.y = round$2(a.y);
          out.z = round$2(a.z);
          out.w = round$2(a.w);
          return out;
        }
        static multiplyScalar(out, a, b) {
          out.x = a.x * b;
          out.y = a.y * b;
          out.z = a.z * b;
          out.w = a.w * b;
          return out;
        }
        static scaleAndAdd(out, a, b, scale) {
          out.x = a.x + b.x * scale;
          out.y = a.y + b.y * scale;
          out.z = a.z + b.z * scale;
          out.w = a.w + b.w * scale;
          return out;
        }
        static distance(a, b) {
          const x = b.x - a.x;
          const y = b.y - a.y;
          const z = b.z - a.z;
          const w = b.w - a.w;
          return sqrt$5(x * x + y * y + z * z + w * w);
        }
        static squaredDistance(a, b) {
          const x = b.x - a.x;
          const y = b.y - a.y;
          const z = b.z - a.z;
          const w = b.w - a.w;
          return x * x + y * y + z * z + w * w;
        }
        static len(a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          const w = a.w;
          return sqrt$5(x * x + y * y + z * z + w * w);
        }
        static lengthSqr(a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          const w = a.w;
          return x * x + y * y + z * z + w * w;
        }
        static negate(out, a) {
          out.x = -a.x;
          out.y = -a.y;
          out.z = -a.z;
          out.w = -a.w;
          return out;
        }
        static inverse(out, a) {
          out.x = 1.0 / a.x;
          out.y = 1.0 / a.y;
          out.z = 1.0 / a.z;
          out.w = 1.0 / a.w;
          return out;
        }
        static inverseSafe(out, a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          const w = a.w;
          if (abs$6(x) < EPSILON$2) {
            out.x = 0;
          } else {
            out.x = 1.0 / x;
          }
          if (abs$6(y) < EPSILON$2) {
            out.y = 0;
          } else {
            out.y = 1.0 / y;
          }
          if (abs$6(z) < EPSILON$2) {
            out.z = 0;
          } else {
            out.z = 1.0 / z;
          }
          if (abs$6(w) < EPSILON$2) {
            out.w = 0;
          } else {
            out.w = 1.0 / w;
          }
          return out;
        }
        static normalize(out, a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          const w = a.w;
          let len = x * x + y * y + z * z + w * w;
          if (len > 0) {
            len = 1 / sqrt$5(len);
            out.x = x * len;
            out.y = y * len;
            out.z = z * len;
            out.w = w * len;
          } else {
            out.x = 0;
            out.y = 0;
            out.z = 0;
            out.w = 0;
          }
          return out;
        }
        static dot(a, b) {
          return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
        }
        static lerp(out, a, b, t) {
          out.x = a.x + t * (b.x - a.x);
          out.y = a.y + t * (b.y - a.y);
          out.z = a.z + t * (b.z - a.z);
          out.w = a.w + t * (b.w - a.w);
          return out;
        }
        static scale(out, a, b) {
          out.x = a.x * b;
          out.y = a.y * b;
          out.z = a.z * b;
          out.w = a.w * b;
          return out;
        }
        static random(out, scale) {
          scale = scale || 1.0;
          const phi = random() * 2.0 * PI$5;
          const cosTheta = random() * 2 - 1;
          const sinTheta = sqrt$5(1 - cosTheta * cosTheta);
          out.x = sinTheta * cos$7(phi) * scale;
          out.y = sinTheta * sin$6(phi) * scale;
          out.z = cosTheta * scale;
          out.w = 0;
          return out;
        }
        static transformMat4(out, a, m) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          const w = a.w;
          out.x = m.m00 * x + m.m04 * y + m.m08 * z + m.m12 * w;
          out.y = m.m01 * x + m.m05 * y + m.m09 * z + m.m13 * w;
          out.z = m.m02 * x + m.m06 * y + m.m10 * z + m.m14 * w;
          out.w = m.m03 * x + m.m07 * y + m.m11 * z + m.m15 * w;
          return out;
        }
        static transformAffine(out, v, m) {
          const x = v.x;
          const y = v.y;
          const z = v.z;
          const w = v.w;
          out.x = m.m00 * x + m.m04 * y + m.m08 * z + m.m12 * w;
          out.y = m.m01 * x + m.m05 * y + m.m09 * z + m.m13 * w;
          out.z = m.m02 * x + m.m06 * y + m.m10 * z + m.m14 * w;
          out.w = v.w;
          return out;
        }
        static transformQuat(out, a, q) {
          const {
            x,
            y,
            z
          } = a;
          const _x = q.x;
          const _y = q.y;
          const _z = q.z;
          const _w = q.w;
          const ix = _w * x + _y * z - _z * y;
          const iy = _w * y + _z * x - _x * z;
          const iz = _w * z + _x * y - _y * x;
          const iw = -_x * x - _y * y - _z * z;
          out.x = ix * _w + iw * -_x + iy * -_z - iz * -_y;
          out.y = iy * _w + iw * -_y + iz * -_x - ix * -_z;
          out.z = iz * _w + iw * -_z + ix * -_y - iy * -_x;
          out.w = a.w;
          return out;
        }
        static toArray(out, v, ofs = 0) {
          out[ofs + 0] = v.x;
          out[ofs + 1] = v.y;
          out[ofs + 2] = v.z;
          out[ofs + 3] = v.w;
          return out;
        }
        static fromArray(out, arr, ofs = 0) {
          out.x = arr[ofs + 0];
          out.y = arr[ofs + 1];
          out.z = arr[ofs + 2];
          out.w = arr[ofs + 3];
          return out;
        }
        static strictEquals(a, b) {
          return a.x === b.x && a.y === b.y && a.z === b.z && a.w === b.w;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          const inf = Infinity;
          const hasInf = abs$6(a.x) === inf || abs$6(a.y) === inf || abs$6(a.z) === inf || abs$6(a.w) === inf || abs$6(b.x) === inf || abs$6(b.y) === inf || abs$6(b.z) === inf || abs$6(b.w) === inf;
          return !hasInf && abs$6(a.x - b.x) <= epsilon * max$a(1.0, abs$6(a.x), abs$6(b.x)) && abs$6(a.y - b.y) <= epsilon * max$a(1.0, abs$6(a.y), abs$6(b.y)) && abs$6(a.z - b.z) <= epsilon * max$a(1.0, abs$6(a.z), abs$6(b.z)) && abs$6(a.w - b.w) <= epsilon * max$a(1.0, abs$6(a.w), abs$6(b.w));
        }
        constructor(x, y, z, w) {
          super();
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.z = x.z;
            this.w = x.w;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.z = z || 0;
            this.w = w || 0;
          }
        }
        clone() {
          return new Vec4(this.x, this.y, this.z, this.w);
        }
        set(x, y, z, w) {
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.z = x.z;
            this.w = x.w;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.z = z || 0;
            this.w = w || 0;
          }
          return this;
        }
        equals(other, epsilon = EPSILON$2) {
          const self = this;
          return abs$6(self.x - other.x) <= epsilon * max$a(1.0, abs$6(self.x), abs$6(other.x)) && abs$6(self.y - other.y) <= epsilon * max$a(1.0, abs$6(self.y), abs$6(other.y)) && abs$6(self.z - other.z) <= epsilon * max$a(1.0, abs$6(self.z), abs$6(other.z)) && abs$6(self.w - other.w) <= epsilon * max$a(1.0, abs$6(self.w), abs$6(other.w));
        }
        equals4f(x, y, z, w, epsilon = EPSILON$2) {
          const self = this;
          return abs$6(self.x - x) <= epsilon * max$a(1.0, abs$6(self.x), abs$6(x)) && abs$6(self.y - y) <= epsilon * max$a(1.0, abs$6(self.y), abs$6(y)) && abs$6(self.z - z) <= epsilon * max$a(1.0, abs$6(self.z), abs$6(z)) && abs$6(self.w - w) <= epsilon * max$a(1.0, abs$6(self.w), abs$6(w));
        }
        strictEquals(other) {
          return this.x === other.x && this.y === other.y && this.z === other.z && this.w === other.w;
        }
        strictEquals4f(x, y, z, w) {
          return this.x === x && this.y === y && this.z === z && this.w === w;
        }
        lerp(to, ratio) {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          const w = self.w;
          self.x = x + ratio * (to.x - x);
          self.y = y + ratio * (to.y - y);
          self.z = z + ratio * (to.z - z);
          self.w = w + ratio * (to.w - w);
          return self;
        }
        toString() {
          return `(${this.x.toFixed(2)}, ${this.y.toFixed(2)}, ${this.z.toFixed(2)}, ${this.w.toFixed(2)})`;
        }
        clampf(minInclusive, maxInclusive) {
          const self = this;
          self.x = clamp$1(self.x, minInclusive.x, maxInclusive.x);
          self.y = clamp$1(self.y, minInclusive.y, maxInclusive.y);
          self.z = clamp$1(self.z, minInclusive.z, maxInclusive.z);
          self.w = clamp$1(self.w, minInclusive.w, maxInclusive.w);
          return self;
        }
        add(other) {
          const self = this;
          self.x += other.x;
          self.y += other.y;
          self.z += other.z;
          self.w += other.w;
          return self;
        }
        add4f(x, y, z, w) {
          const self = this;
          self.x += x;
          self.y += y;
          self.z += z;
          self.w += w;
          return self;
        }
        subtract(other) {
          const self = this;
          self.x -= other.x;
          self.y -= other.y;
          self.z -= other.z;
          self.w -= other.w;
          return self;
        }
        subtract4f(x, y, z, w) {
          const self = this;
          self.x -= x;
          self.y -= y;
          self.z -= z;
          self.w -= w;
          return self;
        }
        multiplyScalar(scalar) {
          const self = this;
          self.x *= scalar;
          self.y *= scalar;
          self.z *= scalar;
          self.w *= scalar;
          return self;
        }
        multiply(other) {
          const self = this;
          self.x *= other.x;
          self.y *= other.y;
          self.z *= other.z;
          self.w *= other.w;
          return self;
        }
        multiply4f(x, y, z, w) {
          const self = this;
          self.x *= x;
          self.y *= y;
          self.z *= z;
          self.w *= w;
          return self;
        }
        divide(other) {
          const self = this;
          self.x /= other.x;
          self.y /= other.y;
          self.z /= other.z;
          self.w /= other.w;
          return self;
        }
        divide4f(x, y, z, w) {
          const self = this;
          self.x /= x;
          self.y /= y;
          self.z /= z;
          self.w /= w;
          return self;
        }
        negative() {
          const self = this;
          self.x = -self.x;
          self.y = -self.y;
          self.z = -self.z;
          self.w = -self.w;
          return self;
        }
        dot(vector) {
          const self = this;
          return self.x * vector.x + self.y * vector.y + self.z * vector.z + self.w * vector.w;
        }
        cross(vector) {
          const self = this;
          const {
            x: ax,
            y: ay,
            z: az
          } = self;
          const {
            x: bx,
            y: by,
            z: bz
          } = vector;
          self.x = ay * bz - az * by;
          self.y = az * bx - ax * bz;
          self.z = ax * by - ay * bx;
          return self;
        }
        length() {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          const w = self.w;
          return sqrt$5(x * x + y * y + z * z + w * w);
        }
        lengthSqr() {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          const w = self.w;
          return x * x + y * y + z * z + w * w;
        }
        normalize() {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          const w = self.w;
          let len = x * x + y * y + z * z + w * w;
          if (len > 0) {
            len = 1 / sqrt$5(len);
            self.x = x * len;
            self.y = y * len;
            self.z = z * len;
            self.w = w * len;
          }
          return self;
        }
        scale(scalar) {
          const self = this;
          self.x *= scalar;
          self.y *= scalar;
          self.z *= scalar;
          self.w *= scalar;
          return self;
        }
        transformMat4(matrix) {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          const w = self.w;
          self.x = matrix.m00 * x + matrix.m04 * y + matrix.m08 * z + matrix.m12 * w;
          self.y = matrix.m01 * x + matrix.m05 * y + matrix.m09 * z + matrix.m13 * w;
          self.z = matrix.m02 * x + matrix.m06 * y + matrix.m10 * z + matrix.m14 * w;
          self.w = matrix.m03 * x + matrix.m07 * y + matrix.m11 * z + matrix.m15 * w;
          return self;
        }
      } exports("Vec4", Vec4);
      _class$2y = Vec4;
      Vec4.ZERO = Object.freeze(new _class$2y(0, 0, 0, 0));
      Vec4.ONE = Object.freeze(new _class$2y(1, 1, 1, 1));
      Vec4.NEG_ONE = Object.freeze(new _class$2y(-1, -1, -1, -1));
      Vec4.UNIT_X = Object.freeze(new _class$2y(1, 0, 0, 0));
      Vec4.UNIT_Y = Object.freeze(new _class$2y(0, 1, 0, 0));
      Vec4.UNIT_Z = Object.freeze(new _class$2y(0, 0, 1, 0));
      Vec4.UNIT_W = Object.freeze(new _class$2y(0, 0, 0, 1));
      CCClass.fastDefine('cc.Vec4', Vec4, {
        x: 0,
        y: 0,
        z: 0,
        w: 0
      });
      legacyCC.Vec4 = Vec4;
      function v4(x, y, z, w) {
        return new Vec4(x, y, z, w);
      }
      legacyCC.v4 = v4;

      var _class$2x;
      const abs$5 = Math.abs;
      const max$9 = Math.max;
      const min$6 = Math.min;
      const PI$4 = Math.PI;
      const acos$4 = Math.acos;
      const sin$5 = Math.sin;
      const cos$6 = Math.cos;
      const sqrt$4 = Math.sqrt;
      const ceil$3 = Math.ceil;
      const floor$1 = Math.floor;
      const round$1 = Math.round;
      class Vec3 extends ValueType {
        static zero(out) {
          out.x = 0;
          out.y = 0;
          out.z = 0;
          return out;
        }
        static clone(a) {
          return new Vec3(a.x, a.y, a.z);
        }
        static copy(out, a) {
          out.x = a.x;
          out.y = a.y;
          out.z = a.z;
          return out;
        }
        static set(out, x, y, z) {
          out.x = x;
          out.y = y;
          out.z = z;
          return out;
        }
        static add(out, a, b) {
          out.x = a.x + b.x;
          out.y = a.y + b.y;
          out.z = a.z + b.z;
          return out;
        }
        static subtract(out, a, b) {
          out.x = a.x - b.x;
          out.y = a.y - b.y;
          out.z = a.z - b.z;
          return out;
        }
        static multiply(out, a, b) {
          out.x = a.x * b.x;
          out.y = a.y * b.y;
          out.z = a.z * b.z;
          return out;
        }
        static divide(out, a, b) {
          out.x = a.x / b.x;
          out.y = a.y / b.y;
          out.z = a.z / b.z;
          return out;
        }
        static ceil(out, a) {
          out.x = ceil$3(a.x);
          out.y = ceil$3(a.y);
          out.z = ceil$3(a.z);
          return out;
        }
        static floor(out, a) {
          out.x = floor$1(a.x);
          out.y = floor$1(a.y);
          out.z = floor$1(a.z);
          return out;
        }
        static min(out, a, b) {
          out.x = min$6(a.x, b.x);
          out.y = min$6(a.y, b.y);
          out.z = min$6(a.z, b.z);
          return out;
        }
        static max(out, a, b) {
          out.x = max$9(a.x, b.x);
          out.y = max$9(a.y, b.y);
          out.z = max$9(a.z, b.z);
          return out;
        }
        static round(out, a) {
          out.x = round$1(a.x);
          out.y = round$1(a.y);
          out.z = round$1(a.z);
          return out;
        }
        static multiplyScalar(out, a, b) {
          out.x = a.x * b;
          out.y = a.y * b;
          out.z = a.z * b;
          return out;
        }
        static scaleAndAdd(out, a, b, scale) {
          out.x = a.x + b.x * scale;
          out.y = a.y + b.y * scale;
          out.z = a.z + b.z * scale;
          return out;
        }
        static distance(a, b) {
          const x = b.x - a.x;
          const y = b.y - a.y;
          const z = b.z - a.z;
          return sqrt$4(x * x + y * y + z * z);
        }
        static squaredDistance(a, b) {
          const x = b.x - a.x;
          const y = b.y - a.y;
          const z = b.z - a.z;
          return x * x + y * y + z * z;
        }
        static len(a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          return sqrt$4(x * x + y * y + z * z);
        }
        static lengthSqr(a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          return x * x + y * y + z * z;
        }
        static negate(out, a) {
          out.x = -a.x;
          out.y = -a.y;
          out.z = -a.z;
          return out;
        }
        static invert(out, a) {
          out.x = 1.0 / a.x;
          out.y = 1.0 / a.y;
          out.z = 1.0 / a.z;
          return out;
        }
        static invertSafe(out, a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          if (abs$5(x) < EPSILON$2) {
            out.x = 0;
          } else {
            out.x = 1.0 / x;
          }
          if (abs$5(y) < EPSILON$2) {
            out.y = 0;
          } else {
            out.y = 1.0 / y;
          }
          if (abs$5(z) < EPSILON$2) {
            out.z = 0;
          } else {
            out.z = 1.0 / z;
          }
          return out;
        }
        static normalize(out, a) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          let len = x * x + y * y + z * z;
          if (len > 0) {
            len = 1 / sqrt$4(len);
            out.x = x * len;
            out.y = y * len;
            out.z = z * len;
          } else {
            out.x = 0;
            out.y = 0;
            out.z = 0;
          }
          return out;
        }
        static dot(a, b) {
          return a.x * b.x + a.y * b.y + a.z * b.z;
        }
        static cross(out, a, b) {
          const {
            x: ax,
            y: ay,
            z: az
          } = a;
          const {
            x: bx,
            y: by,
            z: bz
          } = b;
          out.x = ay * bz - az * by;
          out.y = az * bx - ax * bz;
          out.z = ax * by - ay * bx;
          return out;
        }
        static lerp(out, a, b, t) {
          out.x = a.x + t * (b.x - a.x);
          out.y = a.y + t * (b.y - a.y);
          out.z = a.z + t * (b.z - a.z);
          return out;
        }
        static random(out, scale) {
          scale = scale || 1.0;
          const phi = random() * 2.0 * PI$4;
          const cosTheta = random() * 2 - 1;
          const sinTheta = sqrt$4(1 - cosTheta * cosTheta);
          out.x = sinTheta * cos$6(phi) * scale;
          out.y = sinTheta * sin$5(phi) * scale;
          out.z = cosTheta * scale;
          return out;
        }
        static transformMat4(out, a, m) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          let rhw = m.m03 * x + m.m07 * y + m.m11 * z + m.m15;
          rhw = rhw ? 1 / rhw : 1;
          out.x = (m.m00 * x + m.m04 * y + m.m08 * z + m.m12) * rhw;
          out.y = (m.m01 * x + m.m05 * y + m.m09 * z + m.m13) * rhw;
          out.z = (m.m02 * x + m.m06 * y + m.m10 * z + m.m14) * rhw;
          return out;
        }
        static transformMat4Normal(out, a, m) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          let rhw = m.m03 * x + m.m07 * y + m.m11 * z;
          rhw = rhw ? 1 / rhw : 1;
          out.x = (m.m00 * x + m.m04 * y + m.m08 * z) * rhw;
          out.y = (m.m01 * x + m.m05 * y + m.m09 * z) * rhw;
          out.z = (m.m02 * x + m.m06 * y + m.m10 * z) * rhw;
          return out;
        }
        static transformMat3(out, a, m) {
          const x = a.x;
          const y = a.y;
          const z = a.z;
          out.x = x * m.m00 + y * m.m03 + z * m.m06;
          out.y = x * m.m01 + y * m.m04 + z * m.m07;
          out.z = x * m.m02 + y * m.m05 + z * m.m08;
          return out;
        }
        static transformAffine(out, v, m) {
          const x = v.x;
          const y = v.y;
          const z = v.z;
          out.x = m.m00 * x + m.m04 * y + m.m08 * z + m.m12;
          out.y = m.m01 * x + m.m05 * y + m.m09 * z + m.m13;
          out.z = m.m02 * x + m.m06 * y + m.m10 * z + m.m14;
          return out;
        }
        static transformQuat(out, a, q) {
          const ix = q.w * a.x + q.y * a.z - q.z * a.y;
          const iy = q.w * a.y + q.z * a.x - q.x * a.z;
          const iz = q.w * a.z + q.x * a.y - q.y * a.x;
          const iw = -q.x * a.x - q.y * a.y - q.z * a.z;
          out.x = ix * q.w + iw * -q.x + iy * -q.z - iz * -q.y;
          out.y = iy * q.w + iw * -q.y + iz * -q.x - ix * -q.z;
          out.z = iz * q.w + iw * -q.z + ix * -q.y - iy * -q.x;
          return out;
        }
        static transformRTS(out, a, r, t, s) {
          const x = a.x * s.x;
          const y = a.y * s.y;
          const z = a.z * s.z;
          const ix = r.w * x + r.y * z - r.z * y;
          const iy = r.w * y + r.z * x - r.x * z;
          const iz = r.w * z + r.x * y - r.y * x;
          const iw = -r.x * x - r.y * y - r.z * z;
          out.x = ix * r.w + iw * -r.x + iy * -r.z - iz * -r.y + t.x;
          out.y = iy * r.w + iw * -r.y + iz * -r.x - ix * -r.z + t.y;
          out.z = iz * r.w + iw * -r.z + ix * -r.y - iy * -r.x + t.z;
          return out;
        }
        static transformInverseRTS(out, a, r, t, s) {
          const x = a.x - t.x;
          const y = a.y - t.y;
          const z = a.z - t.z;
          const ix = r.w * x - r.y * z + r.z * y;
          const iy = r.w * y - r.z * x + r.x * z;
          const iz = r.w * z - r.x * y + r.y * x;
          const iw = r.x * x + r.y * y + r.z * z;
          out.x = (ix * r.w + iw * r.x + iy * r.z - iz * r.y) / s.x;
          out.y = (iy * r.w + iw * r.y + iz * r.x - ix * r.z) / s.y;
          out.z = (iz * r.w + iw * r.z + ix * r.y - iy * r.x) / s.z;
          return out;
        }
        static rotateX(out, v, o, a) {
          const x = v.x - o.x;
          const y = v.y - o.y;
          const z = v.z - o.z;
          const c = cos$6(a);
          const s = sin$5(a);
          const rx = x;
          const ry = y * c - z * s;
          const rz = y * s + z * c;
          out.x = rx + o.x;
          out.y = ry + o.y;
          out.z = rz + o.z;
          return out;
        }
        static rotateY(out, v, o, a) {
          const x = v.x - o.x;
          const y = v.y - o.y;
          const z = v.z - o.z;
          const c = cos$6(a);
          const s = sin$5(a);
          const rx = z * s + x * c;
          const ry = y;
          const rz = z * c - x * s;
          out.x = rx + o.x;
          out.y = ry + o.y;
          out.z = rz + o.z;
          return out;
        }
        static rotateZ(out, v, o, a) {
          const x = v.x - o.x;
          const y = v.y - o.y;
          const z = v.z - o.z;
          const c = cos$6(a);
          const s = sin$5(a);
          const rx = x * c - y * s;
          const ry = x * s + y * c;
          const rz = z;
          out.x = rx + o.x;
          out.y = ry + o.y;
          out.z = rz + o.z;
          return out;
        }
        static rotateN(out, v, o, n, a) {
          const x = v.x - o.x;
          const y = v.y - o.y;
          const z = v.z - o.z;
          const nx = n.x;
          const ny = n.y;
          const nz = n.z;
          const c = cos$6(a);
          const s = sin$5(a);
          const rx = x * (nx * nx * (1.0 - c) + c) + y * (nx * ny * (1.0 - c) - nz * s) + z * (nx * nz * (1.0 - c) + ny * s);
          const ry = x * (nx * ny * (1.0 - c) + nz * s) + y * (ny * ny * (1.0 - c) + c) + z * (ny * nz * (1.0 - c) - nx * s);
          const rz = x * (nx * nz * (1.0 - c) - ny * s) + y * (ny * nz * (1.0 - c) + nx * s) + z * (nz * nz * (1.0 - c) + c);
          out.x = rx + o.x;
          out.y = ry + o.y;
          out.z = rz + o.z;
          return out;
        }
        static toArray(out, v, ofs = 0) {
          out[ofs + 0] = v.x;
          out[ofs + 1] = v.y;
          out[ofs + 2] = v.z;
          return out;
        }
        static fromArray(out, arr, ofs = 0) {
          out.x = arr[ofs + 0];
          out.y = arr[ofs + 1];
          out.z = arr[ofs + 2];
          return out;
        }
        static strictEquals(a, b) {
          return a.x === b.x && a.y === b.y && a.z === b.z;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          const {
            x: a0,
            y: a1,
            z: a2
          } = a;
          const {
            x: b0,
            y: b1,
            z: b2
          } = b;
          return abs$5(a0 - b0) <= epsilon * max$9(1.0, abs$5(a0), abs$5(b0)) && abs$5(a1 - b1) <= epsilon * max$9(1.0, abs$5(a1), abs$5(b1)) && abs$5(a2 - b2) <= epsilon * max$9(1.0, abs$5(a2), abs$5(b2));
        }
        static angle(a, b) {
          const magSqr1 = a.x * a.x + a.y * a.y + a.z * a.z;
          const magSqr2 = b.x * b.x + b.y * b.y + b.z * b.z;
          if (magSqr1 === 0 || magSqr2 === 0) {
            return 0.0;
          }
          const dot = a.x * b.x + a.y * b.y + a.z * b.z;
          let cosine = dot / sqrt$4(magSqr1 * magSqr2);
          cosine = clamp$1(cosine, -1.0, 1.0);
          return acos$4(cosine);
        }
        static projectOnPlane(out, a, n) {
          return Vec3.subtract(out, a, Vec3.project(out, a, n));
        }
        static project(out, a, b) {
          const sqrLen = Vec3.lengthSqr(b);
          if (sqrLen < 0.000001) {
            return Vec3.set(out, 0, 0, 0);
          } else {
            return Vec3.multiplyScalar(out, b, Vec3.dot(a, b) / sqrLen);
          }
        }
        static moveTowards(out, current, target, maxStep) {
          const deltaX = target.x - current.x;
          const deltaY = target.y - current.y;
          const deltaZ = target.z - current.z;
          const distanceSqr = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
          if (distanceSqr === 0 || maxStep >= 0 && distanceSqr < maxStep * maxStep) {
            out.x = target.x;
            out.y = target.y;
            out.z = target.z;
            return out;
          }
          const distance = sqrt$4(distanceSqr);
          const scale = maxStep / distance;
          out.x = current.x + deltaX * scale;
          out.y = current.y + deltaY * scale;
          out.z = current.z + deltaZ * scale;
          return out;
        }
        static generateOrthogonal(out, n) {
          const {
            x,
            y,
            z
          } = n;
          const absX = abs$5(x);
          const absY = abs$5(y);
          const absZ = abs$5(z);
          if (absX < absY && absX < absZ) {
            Vec3.set(out, 0.0, z, -y);
          } else if (absY < absZ) {
            Vec3.set(out, z, 0.0, -x);
          } else {
            Vec3.set(out, y, -x, 0.0);
          }
          return Vec3.normalize(out, out);
        }
        constructor(x, y, z) {
          super();
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.z = x.z;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.z = z || 0;
          }
        }
        clone() {
          return new Vec3(this.x, this.y, this.z);
        }
        set(x, y, z) {
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.z = x.z;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.z = z || 0;
          }
          return this;
        }
        equals(other, epsilon = EPSILON$2) {
          return abs$5(this.x - other.x) <= epsilon && abs$5(this.y - other.y) <= epsilon && abs$5(this.z - other.z) <= epsilon;
        }
        equals3f(x, y, z, epsilon = EPSILON$2) {
          return abs$5(this.x - x) <= epsilon && abs$5(this.y - y) <= epsilon && abs$5(this.z - z) <= epsilon;
        }
        strictEquals(other) {
          return this.x === other.x && this.y === other.y && this.z === other.z;
        }
        strictEquals3f(x, y, z) {
          return this.x === x && this.y === y && this.z === z;
        }
        toString() {
          return `(${this.x.toFixed(2)}, ${this.y.toFixed(2)}, ${this.z.toFixed(2)})`;
        }
        lerp(to, ratio) {
          this.x += ratio * (to.x - this.x);
          this.y += ratio * (to.y - this.y);
          this.z += ratio * (to.z - this.z);
          return this;
        }
        add(other) {
          this.x += other.x;
          this.y += other.y;
          this.z += other.z;
          return this;
        }
        add3f(x, y, z) {
          this.x += x;
          this.y += y;
          this.z += z;
          return this;
        }
        subtract(other) {
          this.x -= other.x;
          this.y -= other.y;
          this.z -= other.z;
          return this;
        }
        subtract3f(x, y, z) {
          this.x -= x;
          this.y -= y;
          this.z -= z;
          return this;
        }
        multiplyScalar(scalar) {
          if (typeof scalar === 'object') {
            warnID(16357);
          }
          this.x *= scalar;
          this.y *= scalar;
          this.z *= scalar;
          return this;
        }
        multiply(other) {
          if (typeof other !== 'object') {
            warnID(16358);
          }
          this.x *= other.x;
          this.y *= other.y;
          this.z *= other.z;
          return this;
        }
        multiply3f(x, y, z) {
          this.x *= x;
          this.y *= y;
          this.z *= z;
          return this;
        }
        divide(other) {
          this.x /= other.x;
          this.y /= other.y;
          this.z /= other.z;
          return this;
        }
        divide3f(x, y, z) {
          this.x /= x;
          this.y /= y;
          this.z /= z;
          return this;
        }
        negative() {
          this.x = -this.x;
          this.y = -this.y;
          this.z = -this.z;
          return this;
        }
        clampf(minInclusive, maxInclusive) {
          this.x = clamp$1(this.x, minInclusive.x, maxInclusive.x);
          this.y = clamp$1(this.y, minInclusive.y, maxInclusive.y);
          this.z = clamp$1(this.z, minInclusive.z, maxInclusive.z);
          return this;
        }
        dot(other) {
          return this.x * other.x + this.y * other.y + this.z * other.z;
        }
        cross(other) {
          const {
            x: ax,
            y: ay,
            z: az
          } = this;
          const {
            x: bx,
            y: by,
            z: bz
          } = other;
          this.x = ay * bz - az * by;
          this.y = az * bx - ax * bz;
          this.z = ax * by - ay * bx;
          return this;
        }
        length() {
          const self = this;
          return sqrt$4(self.x * self.x + self.y * self.y + self.z * self.z);
        }
        lengthSqr() {
          const self = this;
          return self.x * self.x + self.y * self.y + self.z * self.z;
        }
        normalize() {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          let len = x * x + y * y + z * z;
          if (len > 0) {
            len = 1 / sqrt$4(len);
            self.x = x * len;
            self.y = y * len;
            self.z = z * len;
          }
          return self;
        }
        transformMat4(matrix) {
          const self = this;
          const x = self.x;
          const y = self.y;
          const z = self.z;
          let rhw = matrix.m03 * x + matrix.m07 * y + matrix.m11 * z + matrix.m15;
          rhw = rhw ? 1 / rhw : 1;
          self.x = (matrix.m00 * x + matrix.m04 * y + matrix.m08 * z + matrix.m12) * rhw;
          self.y = (matrix.m01 * x + matrix.m05 * y + matrix.m09 * z + matrix.m13) * rhw;
          self.z = (matrix.m02 * x + matrix.m06 * y + matrix.m10 * z + matrix.m14) * rhw;
          return self;
        }
        toVec2() {
          return new legacyCC.Vec2(this.x, this.y);
        }
      } exports("Vec3", Vec3);
      _class$2x = Vec3;
      Vec3.UNIT_X = Object.freeze(new _class$2x(1, 0, 0));
      Vec3.UNIT_Y = Object.freeze(new _class$2x(0, 1, 0));
      Vec3.UNIT_Z = Object.freeze(new _class$2x(0, 0, 1));
      Vec3.RIGHT = Object.freeze(new _class$2x(1, 0, 0));
      Vec3.UP = Object.freeze(new _class$2x(0, 1, 0));
      Vec3.FORWARD = Object.freeze(new _class$2x(0, 0, -1));
      Vec3.ZERO = Object.freeze(new _class$2x(0, 0, 0));
      Vec3.ONE = Object.freeze(new _class$2x(1, 1, 1));
      Vec3.NEG_ONE = Object.freeze(new _class$2x(-1, -1, -1));
      Vec3.slerp = (() => {
        const cacheV1 = new _class$2x();
        const cacheV2 = new _class$2x();
        const cacheV3 = new _class$2x();
        return (out, from, to, t) => {
          const EPSILON = 1e-5;
          const lenFrom = _class$2x.len(from);
          const lenTo = _class$2x.len(to);
          if (lenFrom < EPSILON || lenTo < EPSILON) {
            return _class$2x.lerp(out, from, to, t);
          }
          const lenLerped = lerp(lenFrom, lenTo, t);
          const dot = _class$2x.dot(from, to) / (lenFrom * lenTo);
          if (dot > 1.0 - EPSILON) {
            return _class$2x.lerp(out, from, to, t);
          } else if (dot < -1.0 + EPSILON) {
            const fromNormalized = _class$2x.multiplyScalar(cacheV1, from, 1.0 / lenFrom);
            const axis = _class$2x.generateOrthogonal(cacheV2, fromNormalized);
            const angle = PI$4 * t;
            rotateAxisAngle(cacheV3, fromNormalized, axis, angle);
            _class$2x.multiplyScalar(out, cacheV3, lenLerped);
            return out;
          } else {
            const dotClamped = dot;
            const theta = acos$4(dotClamped) * t;
            const fromNormalized = _class$2x.multiplyScalar(cacheV1, from, 1.0 / lenFrom);
            const toNormalized = _class$2x.multiplyScalar(cacheV2, to, 1.0 / lenTo);
            _class$2x.scaleAndAdd(cacheV3, toNormalized, fromNormalized, -dotClamped);
            _class$2x.normalize(cacheV3, cacheV3);
            _class$2x.multiplyScalar(cacheV3, cacheV3, sin$5(theta));
            _class$2x.scaleAndAdd(cacheV3, cacheV3, fromNormalized, cos$6(theta));
            _class$2x.multiplyScalar(out, cacheV3, lenLerped);
            return out;
          }
        };
      })();
      Vec3.signedAngle = (() => {
        const cacheCross = new _class$2x();
        return (a, b, normal) => {
          const angle = _class$2x.angle(a, b);
          const cross = _class$2x.cross(cacheCross, a, b);
          const dot = _class$2x.dot(cross, normal);
          return dot < 0 ? -angle : angle;
        };
      })();
      CCClass.fastDefine('cc.Vec3', Vec3, {
        x: 0,
        y: 0,
        z: 0
      });
      legacyCC.Vec3 = Vec3;
      function v3(x, y, z) {
        return new Vec3(x, y, z);
      }
      const rotateAxisAngle = (() => {
        const cacheQ = {
          x: 0.0,
          y: 0.0,
          z: 0.0,
          w: 0.0
        };
        return (out, input, axis, angle) => {
          const rad = angle * 0.5;
          const s = sin$5(rad);
          cacheQ.x = s * axis.x;
          cacheQ.y = s * axis.y;
          cacheQ.z = s * axis.z;
          cacheQ.w = cos$6(rad);
          Vec3.transformQuat(out, input, cacheQ);
          return out;
        };
      })();
      legacyCC.v3 = v3;

      var _class$2w;
      const toFloat = 1 / 255;
      const R_INDEX = 0;
      const G_INDEX = 1;
      const B_INDEX = 2;
      const A_INDEX = 3;
      let Color$1 = class Color extends ValueType {
        static clone(a) {
          const out = new Color();
          out.r = a.r;
          out.g = a.g;
          out.b = a.b;
          out.a = a.a;
          return out;
        }
        static copy(out, a) {
          out.r = a.r;
          out.g = a.g;
          out.b = a.b;
          out.a = a.a;
          return out;
        }
        static set(out, r, g, b, a) {
          out.r = r;
          out.g = g;
          out.b = b;
          out.a = a;
          return out;
        }
        static toVec4(color, out) {
          out = out !== undefined ? out : new Vec4();
          out.x = color._data[R_INDEX] * toFloat;
          out.y = color._data[G_INDEX] * toFloat;
          out.z = color._data[B_INDEX] * toFloat;
          out.w = color._data[A_INDEX] * toFloat;
          return out;
        }
        static fromVec4(value, out) {
          out = out === undefined ? new Color() : out;
          out._data[R_INDEX] = value.x / toFloat;
          out._data[G_INDEX] = value.y / toFloat;
          out._data[B_INDEX] = value.z / toFloat;
          out._data[A_INDEX] = value.w / toFloat;
          return out;
        }
        static fromHEX(out, hex) {
          let hexNumber;
          if (typeof hex === 'string') {
            hex = hex[0] === '#' ? hex.substring(1) : hex;
            if (hex.length === 6) {
              hex += 'FF';
            } else if (hex.length === 3) {
              hex = `${hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2]}FF`;
            } else if (hex.length === 4) {
              hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2] + hex[3] + hex[3];
            }
            hexNumber = Number(`0x${hex}`);
          } else {
            if (hex < 0x1000000) {
              hex = (hex << 8) + 0xff;
            }
            hexNumber = hex;
          }
          out.r = hexNumber >>> 24;
          out.g = (hexNumber & 0x00ff0000) >>> 16;
          out.b = (hexNumber & 0x0000ff00) >>> 8;
          out.a = hexNumber & 0x000000ff;
          return out;
        }
        static add(out, a, b) {
          out.r = a.r + b.r;
          out.g = a.g + b.g;
          out.b = a.b + b.b;
          out.a = a.a + b.a;
          return out;
        }
        static subtract(out, a, b) {
          out.r = a.r - b.r;
          out.g = a.g - b.g;
          out.b = a.b - b.b;
          out.a = a.a - b.a;
          return out;
        }
        static multiply(out, a, b) {
          out.r = a.r * b.r;
          out.g = a.g * b.g;
          out.b = a.b * b.b;
          out.a = a.a * b.a;
          return out;
        }
        static divide(out, a, b) {
          out.r = a.r / b.r;
          out.g = a.g / b.g;
          out.b = a.b / b.b;
          out.a = a.a / b.a;
          return out;
        }
        static scale(out, a, b) {
          out.r = a.r * b;
          out.g = a.g * b;
          out.b = a.b * b;
          out.a = a.a * b;
          return out;
        }
        static lerp(out, from, to, ratio) {
          const fromR = from.r;
          const fromG = from.g;
          const fromB = from.b;
          const fromA = from.a;
          out.r = fromR + (to.r - fromR) * ratio;
          out.g = fromG + (to.g - fromG) * ratio;
          out.b = fromB + (to.b - fromB) * ratio;
          out.a = fromA + (to.a - fromA) * ratio;
          return out;
        }
        static toArray(out, a, ofs = 0) {
          const scale = a instanceof Color || a.a > 1 ? 1 / 255 : 1;
          out[ofs + 0] = a.r * scale;
          out[ofs + 1] = a.g * scale;
          out[ofs + 2] = a.b * scale;
          out[ofs + 3] = a.a * scale;
          return out;
        }
        static fromArray(arr, out, ofs = 0) {
          out.r = arr[ofs + 0] * 255;
          out.g = arr[ofs + 1] * 255;
          out.b = arr[ofs + 2] * 255;
          out.a = arr[ofs + 3] * 255;
          return out;
        }
        static fromUint32(out, uint32) {
          uint32 >>>= 0;
          out.r = uint32 & 0xff;
          out.g = uint32 >> 8 & 0xff;
          out.b = uint32 >> 16 & 0xff;
          out.a = uint32 >> 24 & 0xff;
          return out;
        }
        static toUint32(color) {
          return (color.a << 24 | color.b << 16 | color.g << 8 | color.r) >>> 0;
        }
        static strictEquals(a, b) {
          return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          const hasInf = Math.abs(a.r) === Infinity || Math.abs(a.g) === Infinity || Math.abs(a.b) === Infinity || Math.abs(a.a) === Infinity;
          return !hasInf && Math.abs(a.r - b.r) <= epsilon * Math.max(1.0, Math.abs(a.r), Math.abs(b.r)) && Math.abs(a.g - b.g) <= epsilon * Math.max(1.0, Math.abs(a.g), Math.abs(b.g)) && Math.abs(a.b - b.b) <= epsilon * Math.max(1.0, Math.abs(a.b), Math.abs(b.b)) && Math.abs(a.a - b.a) <= epsilon * Math.max(1.0, Math.abs(a.a), Math.abs(b.a));
        }
        static hex(a) {
          return (a.r * 255 << 24 | a.g * 255 << 16 | a.b * 255 << 8 | a.a * 255) >>> 0;
        }
        get r() {
          return this._data[R_INDEX];
        }
        set r(red) {
          this._data[R_INDEX] = red;
        }
        get g() {
          return this._data[G_INDEX];
        }
        set g(green) {
          this._data[G_INDEX] = green;
        }
        get b() {
          return this._data[B_INDEX];
        }
        set b(blue) {
          this._data[B_INDEX] = blue;
        }
        get a() {
          return this._data[A_INDEX];
        }
        set a(alpha) {
          this._data[A_INDEX] = alpha;
        }
        get x() {
          return this._data[R_INDEX] * toFloat;
        }
        set x(value) {
          this._data[R_INDEX] = value * 255;
        }
        get y() {
          return this._data[G_INDEX] * toFloat;
        }
        set y(value) {
          this._data[G_INDEX] = value * 255;
        }
        get z() {
          return this._data[B_INDEX] * toFloat;
        }
        set z(value) {
          this._data[B_INDEX] = value * 255;
        }
        get w() {
          return this._data[A_INDEX] * toFloat;
        }
        set w(value) {
          this._data[A_INDEX] = value * 255;
        }
        constructor(r, g, b, a) {
          super();
          this._data = new Uint8ClampedArray(4);
          if (typeof r === 'string') {
            this.fromHEX(r);
          } else if (g !== undefined) {
            this.set(r, g, b, a);
          } else {
            this.set(r);
          }
        }
        clone() {
          const ret = new Color();
          ret._data.set(this._data);
          return ret;
        }
        equals(other) {
          const otherColor = other;
          return other && this._data[R_INDEX] === otherColor.r && this._data[G_INDEX] === otherColor.g && this._data[B_INDEX] === otherColor.b && this._data[A_INDEX] === otherColor.a;
        }
        lerp(to, ratio) {
          Color.lerp(this, this, to, ratio);
          return this;
        }
        toString() {
          return `rgba(${this.r.toFixed()}, ${this.g.toFixed()}, ${this.b.toFixed()}, ${this.a.toFixed()})`;
        }
        toCSS(opt = 'rgba') {
          if (opt === 'rgba') {
            return `rgba(${this.r},${this.g},${this.b},${(this.a * toFloat).toFixed(2)})`;
          } else if (opt === 'rgb') {
            return `rgb(${this.r},${this.g},${this.b})`;
          } else {
            return `#${this.toHEX(opt)}`;
          }
        }
        fromHEX(hex) {
          let hexNumber;
          if (typeof hex === 'string') {
            hex = hex[0] === '#' ? hex.substring(1) : hex;
            if (hex.length === 6) {
              hex += 'FF';
            } else if (hex.length === 3) {
              hex = `${hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2]}FF`;
            } else if (hex.length === 4) {
              hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2] + hex[3] + hex[3];
            }
            hexNumber = Number(`0x${hex}`);
          } else {
            if (hex < 0x1000000) {
              hex = (hex << 8) + 0xff;
            }
            hexNumber = hex;
          }
          this.r = hexNumber >>> 24;
          this.g = (hexNumber & 0x00ff0000) >>> 16;
          this.b = (hexNumber & 0x0000ff00) >>> 8;
          this.a = hexNumber & 0x000000ff;
          return this;
        }
        toHEX(fmt = '#rrggbb') {
          const prefix = '0';
          const hex = [(this._data[R_INDEX] < 16 ? prefix : '') + this._data[R_INDEX].toString(16), (this._data[G_INDEX] < 16 ? prefix : '') + this._data[G_INDEX].toString(16), (this._data[B_INDEX] < 16 ? prefix : '') + this._data[B_INDEX].toString(16)];
          if (fmt === '#rgb') {
            hex[0] = hex[0][0];
            hex[1] = hex[1][0];
            hex[2] = hex[2][0];
          } else if (fmt === '#rrggbbaa') {
            hex.push((this._data[A_INDEX] < 16 ? prefix : '') + this._data[A_INDEX].toString(16));
          }
          return hex.join('');
        }
        toRGBValue() {
          return this._data[B_INDEX] << 16 | this._data[G_INDEX] << 8 | this._data[R_INDEX];
        }
        fromHSV(h, s, v) {
          let r = 0;
          let g = 0;
          let b = 0;
          if (s === 0) {
            r = g = b = v;
          } else if (v === 0) {
            r = g = b = 0;
          } else {
            if (h === 1) {
              h = 0;
            }
            h *= 6;
            const i = Math.floor(h);
            const f = h - i;
            const p = v * (1 - s);
            const q = v * (1 - s * f);
            const t = v * (1 - s * (1 - f));
            switch (i) {
              default:
                assertIsTrue(false);
              case 0:
                r = v;
                g = t;
                b = p;
                break;
              case 1:
                r = q;
                g = v;
                b = p;
                break;
              case 2:
                r = p;
                g = v;
                b = t;
                break;
              case 3:
                r = p;
                g = q;
                b = v;
                break;
              case 4:
                r = t;
                g = p;
                b = v;
                break;
              case 5:
                r = v;
                g = p;
                b = q;
                break;
            }
          }
          this._data[R_INDEX] = r * 255;
          this._data[G_INDEX] = g * 255;
          this._data[B_INDEX] = b * 255;
          return this;
        }
        toHSV() {
          const r = this._data[R_INDEX] * toFloat;
          const g = this._data[G_INDEX] * toFloat;
          const b = this._data[B_INDEX] * toFloat;
          const hsv = {
            h: 0,
            s: 0,
            v: 0
          };
          const max = Math.max(r, g, b);
          const min = Math.min(r, g, b);
          let delta = 0;
          hsv.v = max;
          hsv.s = max ? (max - min) / max : 0;
          if (!hsv.s) {
            hsv.h = 0;
          } else {
            delta = max - min;
            if (r === max) {
              hsv.h = (g - b) / delta;
            } else if (g === max) {
              hsv.h = 2 + (b - r) / delta;
            } else {
              hsv.h = 4 + (r - g) / delta;
            }
            hsv.h /= 6;
            if (hsv.h < 0) {
              hsv.h += 1.0;
            }
          }
          return hsv;
        }
        set(r, g, b, a) {
          if (typeof r === 'object') {
            const other = r;
            if (other._data) {
              this._data.set(other._data);
            } else {
              var _other$r, _other$g, _other$b, _other$a;
              this._data[R_INDEX] = (_other$r = other.r) !== null && _other$r !== void 0 ? _other$r : 0;
              this._data[G_INDEX] = (_other$g = other.g) !== null && _other$g !== void 0 ? _other$g : 0;
              this._data[B_INDEX] = (_other$b = other.b) !== null && _other$b !== void 0 ? _other$b : 0;
              this._data[A_INDEX] = (_other$a = other.a) !== null && _other$a !== void 0 ? _other$a : 255;
            }
          } else {
            this._data[R_INDEX] = r !== null && r !== void 0 ? r : 0;
            this._data[G_INDEX] = g !== null && g !== void 0 ? g : 0;
            this._data[B_INDEX] = b !== null && b !== void 0 ? b : 0;
            this._data[A_INDEX] = a !== null && a !== void 0 ? a : 255;
          }
          return this;
        }
        multiply(other) {
          this._data[R_INDEX] *= other.r / 255;
          this._data[G_INDEX] *= other.g / 255;
          this._data[B_INDEX] *= other.b / 255;
          this._data[A_INDEX] *= other.a / 255;
          return this;
        }
        getModifiableProperties() {
          return ['r', 'g', 'b', 'a'];
        }
      }; exports("Color", Color$1);
      _class$2w = Color$1;
      Color$1.WHITE = Object.freeze(new _class$2w(255, 255, 255, 255));
      Color$1.GRAY = Object.freeze(new _class$2w(127, 127, 127, 255));
      Color$1.BLACK = Object.freeze(new _class$2w(0, 0, 0, 255));
      Color$1.TRANSPARENT = Object.freeze(new _class$2w(0, 0, 0, 0));
      Color$1.RED = Object.freeze(new _class$2w(255, 0, 0, 255));
      Color$1.GREEN = Object.freeze(new _class$2w(0, 255, 0, 255));
      Color$1.BLUE = Object.freeze(new _class$2w(0, 0, 255, 255));
      Color$1.CYAN = Object.freeze(new _class$2w(0, 255, 255, 255));
      Color$1.MAGENTA = Object.freeze(new _class$2w(255, 0, 255, 255));
      Color$1.YELLOW = Object.freeze(new _class$2w(255, 255, 0, 255));
      CCClass.fastDefine('cc.Color', Color$1, {
        r: 0,
        g: 0,
        b: 0,
        a: 255
      });
      legacyCC.Color = Color$1;
      function color(r, g, b, a) {
        return new Color$1(r, g, b, a);
      }
      legacyCC.color = color;

      var _class$2v;
      const abs$4 = Math.abs;
      const max$8 = Math.max;
      class Mat3 extends ValueType {
        static clone(a) {
          return new Mat3(a.m00, a.m01, a.m02, a.m03, a.m04, a.m05, a.m06, a.m07, a.m08);
        }
        static copy(out, a) {
          out.m00 = a.m00;
          out.m01 = a.m01;
          out.m02 = a.m02;
          out.m03 = a.m03;
          out.m04 = a.m04;
          out.m05 = a.m05;
          out.m06 = a.m06;
          out.m07 = a.m07;
          out.m08 = a.m08;
          return out;
        }
        static set(out, m00, m01, m02, m03, m04, m05, m06, m07, m08) {
          out.m00 = m00;
          out.m01 = m01;
          out.m02 = m02;
          out.m03 = m03;
          out.m04 = m04;
          out.m05 = m05;
          out.m06 = m06;
          out.m07 = m07;
          out.m08 = m08;
          return out;
        }
        static identity(out) {
          out.m00 = 1;
          out.m01 = 0;
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = 1;
          out.m05 = 0;
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 1;
          return out;
        }
        static transpose(out, a) {
          if (out === a) {
            const a01 = a.m01;
            const a02 = a.m02;
            const a12 = a.m05;
            out.m01 = a.m03;
            out.m02 = a.m06;
            out.m03 = a01;
            out.m05 = a.m07;
            out.m06 = a02;
            out.m07 = a12;
          } else {
            out.m00 = a.m00;
            out.m01 = a.m03;
            out.m02 = a.m06;
            out.m03 = a.m01;
            out.m04 = a.m04;
            out.m05 = a.m07;
            out.m06 = a.m02;
            out.m07 = a.m05;
            out.m08 = a.m08;
          }
          return out;
        }
        static invert(out, a) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a10 = a.m03;
          const a11 = a.m04;
          const a12 = a.m05;
          const a20 = a.m06;
          const a21 = a.m07;
          const a22 = a.m08;
          const b01 = a22 * a11 - a12 * a21;
          const b11 = -a22 * a10 + a12 * a20;
          const b21 = a21 * a10 - a11 * a20;
          let det = a00 * b01 + a01 * b11 + a02 * b21;
          if (det === 0) {
            Mat3.set(out, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            return out;
          }
          det = 1.0 / det;
          out.m00 = b01 * det;
          out.m01 = (-a22 * a01 + a02 * a21) * det;
          out.m02 = (a12 * a01 - a02 * a11) * det;
          out.m03 = b11 * det;
          out.m04 = (a22 * a00 - a02 * a20) * det;
          out.m05 = (-a12 * a00 + a02 * a10) * det;
          out.m06 = b21 * det;
          out.m07 = (-a21 * a00 + a01 * a20) * det;
          out.m08 = (a11 * a00 - a01 * a10) * det;
          return out;
        }
        static determinant(a) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a10 = a.m03;
          const a11 = a.m04;
          const a12 = a.m05;
          const a20 = a.m06;
          const a21 = a.m07;
          const a22 = a.m08;
          return a00 * (a22 * a11 - a12 * a21) + a01 * (-a22 * a10 + a12 * a20) + a02 * (a21 * a10 - a11 * a20);
        }
        static multiply(out, a, b) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a10 = a.m03;
          const a11 = a.m04;
          const a12 = a.m05;
          const a20 = a.m06;
          const a21 = a.m07;
          const a22 = a.m08;
          const b00 = b.m00;
          const b01 = b.m01;
          const b02 = b.m02;
          const b10 = b.m03;
          const b11 = b.m04;
          const b12 = b.m05;
          const b20 = b.m06;
          const b21 = b.m07;
          const b22 = b.m08;
          out.m00 = b00 * a00 + b01 * a10 + b02 * a20;
          out.m01 = b00 * a01 + b01 * a11 + b02 * a21;
          out.m02 = b00 * a02 + b01 * a12 + b02 * a22;
          out.m03 = b10 * a00 + b11 * a10 + b12 * a20;
          out.m04 = b10 * a01 + b11 * a11 + b12 * a21;
          out.m05 = b10 * a02 + b11 * a12 + b12 * a22;
          out.m06 = b20 * a00 + b21 * a10 + b22 * a20;
          out.m07 = b20 * a01 + b21 * a11 + b22 * a21;
          out.m08 = b20 * a02 + b21 * a12 + b22 * a22;
          return out;
        }
        static multiplyMat4(out, a, b) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a10 = a.m03;
          const a11 = a.m04;
          const a12 = a.m05;
          const a20 = a.m06;
          const a21 = a.m07;
          const a22 = a.m08;
          const b00 = b.m00;
          const b01 = b.m01;
          const b02 = b.m02;
          const b10 = b.m04;
          const b11 = b.m05;
          const b12 = b.m06;
          const b20 = b.m08;
          const b21 = b.m09;
          const b22 = b.m10;
          out.m00 = b00 * a00 + b01 * a10 + b02 * a20;
          out.m01 = b00 * a01 + b01 * a11 + b02 * a21;
          out.m02 = b00 * a02 + b01 * a12 + b02 * a22;
          out.m03 = b10 * a00 + b11 * a10 + b12 * a20;
          out.m04 = b10 * a01 + b11 * a11 + b12 * a21;
          out.m05 = b10 * a02 + b11 * a12 + b12 * a22;
          out.m06 = b20 * a00 + b21 * a10 + b22 * a20;
          out.m07 = b20 * a01 + b21 * a11 + b22 * a21;
          out.m08 = b20 * a02 + b21 * a12 + b22 * a22;
          return out;
        }
        static transform(out, a, v) {
          this.translate(out, a, v);
        }
        static translate(out, a, v) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a10 = a.m03;
          const a11 = a.m04;
          const a12 = a.m05;
          const a20 = a.m06;
          const a21 = a.m07;
          const a22 = a.m08;
          const x = v.x;
          const y = v.y;
          out.m00 = a00;
          out.m01 = a01;
          out.m02 = a02;
          out.m03 = a10;
          out.m04 = a11;
          out.m05 = a12;
          out.m06 = x * a00 + y * a10 + a20;
          out.m07 = x * a01 + y * a11 + a21;
          out.m08 = x * a02 + y * a12 + a22;
          return out;
        }
        static scale(out, a, v) {
          const x = v.x;
          const y = v.y;
          out.m00 = x * a.m00;
          out.m01 = x * a.m01;
          out.m02 = x * a.m02;
          out.m03 = y * a.m03;
          out.m04 = y * a.m04;
          out.m05 = y * a.m05;
          out.m06 = a.m06;
          out.m07 = a.m07;
          out.m08 = a.m08;
          return out;
        }
        static rotate(out, a, rad) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a10 = a.m03;
          const a11 = a.m04;
          const a12 = a.m05;
          const a20 = a.m06;
          const a21 = a.m07;
          const a22 = a.m08;
          const s = Math.sin(rad);
          const c = Math.cos(rad);
          out.m00 = c * a00 + s * a10;
          out.m01 = c * a01 + s * a11;
          out.m02 = c * a02 + s * a12;
          out.m03 = c * a10 - s * a00;
          out.m04 = c * a11 - s * a01;
          out.m05 = c * a12 - s * a02;
          out.m06 = a20;
          out.m07 = a21;
          out.m08 = a22;
          return out;
        }
        static fromMat4(out, a) {
          out.m00 = a.m00;
          out.m01 = a.m01;
          out.m02 = a.m02;
          out.m03 = a.m04;
          out.m04 = a.m05;
          out.m05 = a.m06;
          out.m06 = a.m08;
          out.m07 = a.m09;
          out.m08 = a.m10;
          return out;
        }
        static fromViewUp(out, view, up) {
          if (Vec3.lengthSqr(view) < EPSILON$2 * EPSILON$2) {
            Mat3.identity(out);
            return out;
          }
          up = up || Vec3.UNIT_Y;
          Vec3.normalize(v3_1$3, Vec3.cross(v3_1$3, up, view));
          if (Vec3.lengthSqr(v3_1$3) < EPSILON$2 * EPSILON$2) {
            Mat3.identity(out);
            return out;
          }
          Vec3.cross(v3_2, view, v3_1$3);
          Mat3.set(out, v3_1$3.x, v3_1$3.y, v3_1$3.z, v3_2.x, v3_2.y, v3_2.z, view.x, view.y, view.z);
          return out;
        }
        static fromTranslation(out, v) {
          out.m00 = 1;
          out.m01 = 0;
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = 1;
          out.m05 = 0;
          out.m06 = v.x;
          out.m07 = v.y;
          out.m08 = 1;
          return out;
        }
        static fromScaling(out, v) {
          out.m00 = v.x;
          out.m01 = 0;
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = v.y;
          out.m05 = 0;
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 1;
          return out;
        }
        static fromRotation(out, rad) {
          const s = Math.sin(rad);
          const c = Math.cos(rad);
          out.m00 = c;
          out.m01 = s;
          out.m02 = 0;
          out.m03 = -s;
          out.m04 = c;
          out.m05 = 0;
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 1;
          return out;
        }
        static fromQuat(out, q) {
          const x = q.x;
          const y = q.y;
          const z = q.z;
          const w = q.w;
          const x2 = x + x;
          const y2 = y + y;
          const z2 = z + z;
          const xx = x * x2;
          const yx = y * x2;
          const yy = y * y2;
          const zx = z * x2;
          const zy = z * y2;
          const zz = z * z2;
          const wx = w * x2;
          const wy = w * y2;
          const wz = w * z2;
          out.m00 = 1 - yy - zz;
          out.m03 = yx - wz;
          out.m06 = zx + wy;
          out.m01 = yx + wz;
          out.m04 = 1 - xx - zz;
          out.m07 = zy - wx;
          out.m02 = zx - wy;
          out.m05 = zy + wx;
          out.m08 = 1 - xx - yy;
          return out;
        }
        static inverseTransposeMat4(out, a) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          const a30 = a.m12;
          const a31 = a.m13;
          const a32 = a.m14;
          const a33 = a.m15;
          const b00 = a00 * a11 - a01 * a10;
          const b01 = a00 * a12 - a02 * a10;
          const b02 = a00 * a13 - a03 * a10;
          const b03 = a01 * a12 - a02 * a11;
          const b04 = a01 * a13 - a03 * a11;
          const b05 = a02 * a13 - a03 * a12;
          const b06 = a20 * a31 - a21 * a30;
          const b07 = a20 * a32 - a22 * a30;
          const b08 = a20 * a33 - a23 * a30;
          const b09 = a21 * a32 - a22 * a31;
          const b10 = a21 * a33 - a23 * a31;
          const b11 = a22 * a33 - a23 * a32;
          let det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
          if (!det) {
            return null;
          }
          det = 1.0 / det;
          out.m00 = (a11 * b11 - a12 * b10 + a13 * b09) * det;
          out.m01 = (a12 * b08 - a10 * b11 - a13 * b07) * det;
          out.m02 = (a10 * b10 - a11 * b08 + a13 * b06) * det;
          out.m03 = (a02 * b10 - a01 * b11 - a03 * b09) * det;
          out.m04 = (a00 * b11 - a02 * b08 + a03 * b07) * det;
          out.m05 = (a01 * b08 - a00 * b10 - a03 * b06) * det;
          out.m06 = (a31 * b05 - a32 * b04 + a33 * b03) * det;
          out.m07 = (a32 * b02 - a30 * b05 - a33 * b01) * det;
          out.m08 = (a30 * b04 - a31 * b02 + a33 * b00) * det;
          return out;
        }
        static toArray(out, m, ofs = 0) {
          out[ofs + 0] = m.m00;
          out[ofs + 1] = m.m01;
          out[ofs + 2] = m.m02;
          out[ofs + 3] = m.m03;
          out[ofs + 4] = m.m04;
          out[ofs + 5] = m.m05;
          out[ofs + 6] = m.m06;
          out[ofs + 7] = m.m07;
          out[ofs + 8] = m.m08;
          return out;
        }
        static fromArray(out, arr, ofs = 0) {
          out.m00 = arr[ofs + 0];
          out.m01 = arr[ofs + 1];
          out.m02 = arr[ofs + 2];
          out.m03 = arr[ofs + 3];
          out.m04 = arr[ofs + 4];
          out.m05 = arr[ofs + 5];
          out.m06 = arr[ofs + 6];
          out.m07 = arr[ofs + 7];
          out.m08 = arr[ofs + 8];
          return out;
        }
        static add(out, a, b) {
          out.m00 = a.m00 + b.m00;
          out.m01 = a.m01 + b.m01;
          out.m02 = a.m02 + b.m02;
          out.m03 = a.m03 + b.m03;
          out.m04 = a.m04 + b.m04;
          out.m05 = a.m05 + b.m05;
          out.m06 = a.m06 + b.m06;
          out.m07 = a.m07 + b.m07;
          out.m08 = a.m08 + b.m08;
          return out;
        }
        static subtract(out, a, b) {
          out.m00 = a.m00 - b.m00;
          out.m01 = a.m01 - b.m01;
          out.m02 = a.m02 - b.m02;
          out.m03 = a.m03 - b.m03;
          out.m04 = a.m04 - b.m04;
          out.m05 = a.m05 - b.m05;
          out.m06 = a.m06 - b.m06;
          out.m07 = a.m07 - b.m07;
          out.m08 = a.m08 - b.m08;
          return out;
        }
        static multiplyScalar(out, a, b) {
          out.m00 = a.m00 * b;
          out.m01 = a.m01 * b;
          out.m02 = a.m02 * b;
          out.m03 = a.m03 * b;
          out.m04 = a.m04 * b;
          out.m05 = a.m05 * b;
          out.m06 = a.m06 * b;
          out.m07 = a.m07 * b;
          out.m08 = a.m08 * b;
          return out;
        }
        static multiplyScalarAndAdd(out, a, b, scale) {
          out.m00 = b.m00 * scale + a.m00;
          out.m01 = b.m01 * scale + a.m01;
          out.m02 = b.m02 * scale + a.m02;
          out.m03 = b.m03 * scale + a.m03;
          out.m04 = b.m04 * scale + a.m04;
          out.m05 = b.m05 * scale + a.m05;
          out.m06 = b.m06 * scale + a.m06;
          out.m07 = b.m07 * scale + a.m07;
          out.m08 = b.m08 * scale + a.m08;
          return out;
        }
        static strictEquals(a, b) {
          return a.m00 === b.m00 && a.m01 === b.m01 && a.m02 === b.m02 && a.m03 === b.m03 && a.m04 === b.m04 && a.m05 === b.m05 && a.m06 === b.m06 && a.m07 === b.m07 && a.m08 === b.m08;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          return abs$4(a.m00 - b.m00) <= epsilon * max$8(1.0, abs$4(a.m00), abs$4(b.m00)) && abs$4(a.m01 - b.m01) <= epsilon * max$8(1.0, abs$4(a.m01), abs$4(b.m01)) && abs$4(a.m02 - b.m02) <= epsilon * max$8(1.0, abs$4(a.m02), abs$4(b.m02)) && abs$4(a.m03 - b.m03) <= epsilon * max$8(1.0, abs$4(a.m03), abs$4(b.m03)) && abs$4(a.m04 - b.m04) <= epsilon * max$8(1.0, abs$4(a.m04), abs$4(b.m04)) && abs$4(a.m05 - b.m05) <= epsilon * max$8(1.0, abs$4(a.m05), abs$4(b.m05)) && abs$4(a.m06 - b.m06) <= epsilon * max$8(1.0, abs$4(a.m06), abs$4(b.m06)) && abs$4(a.m07 - b.m07) <= epsilon * max$8(1.0, abs$4(a.m07), abs$4(b.m07)) && abs$4(a.m08 - b.m08) <= epsilon * max$8(1.0, abs$4(a.m08), abs$4(b.m08));
        }
        static toEuler(matrix, v) {
          const a00 = matrix.m00;
          const a01 = matrix.m01;
          matrix.m02;
          const a10 = matrix.m03;
          const a11 = matrix.m04;
          matrix.m05;
          const a20 = matrix.m06;
          const a21 = matrix.m07;
          const a22 = matrix.m08;
          if (a21 < 0.999) {
            if (a21 > -0.999) {
              v.x = Math.asin(-a21);
              v.y = Math.atan2(a20, a22);
              v.z = Math.atan2(a01, a11);
              return true;
            } else {
              v.x = HALF_PI;
              v.y = Math.atan2(a10, a00);
              v.z = 0.0;
              return false;
            }
          } else {
            v.x = -HALF_PI;
            v.y = Math.atan2(-a10, a00);
            v.z = 0.0;
            return false;
          }
        }
        constructor(m00 = 1, m01 = 0, m02 = 0, m03 = 0, m04 = 1, m05 = 0, m06 = 0, m07 = 0, m08 = 1) {
          super();
          const self = this;
          if (typeof m00 === 'object') {
            self.m00 = m00.m00;
            self.m01 = m00.m01;
            self.m02 = m00.m02;
            self.m03 = m00.m03;
            self.m04 = m00.m04;
            self.m05 = m00.m05;
            self.m06 = m00.m06;
            self.m07 = m00.m07;
            self.m08 = m00.m08;
          } else {
            self.m00 = m00;
            self.m01 = m01;
            self.m02 = m02;
            self.m03 = m03;
            self.m04 = m04;
            self.m05 = m05;
            self.m06 = m06;
            self.m07 = m07;
            self.m08 = m08;
          }
        }
        clone() {
          return new Mat3(this);
        }
        set(m00 = 1, m01 = 0, m02 = 0, m03 = 0, m04 = 1, m05 = 0, m06 = 0, m07 = 0, m08 = 1) {
          const self = this;
          if (typeof m00 === 'object') {
            self.m00 = m00.m00;
            self.m01 = m00.m01;
            self.m02 = m00.m02;
            self.m03 = m00.m03;
            self.m04 = m00.m04;
            self.m05 = m00.m05;
            self.m06 = m00.m06;
            self.m07 = m00.m07;
            self.m08 = m00.m08;
          } else {
            self.m00 = m00;
            self.m01 = m01;
            self.m02 = m02;
            self.m03 = m03;
            self.m04 = m04;
            self.m05 = m05;
            self.m06 = m06;
            self.m07 = m07;
            self.m08 = m08;
          }
          return self;
        }
        equals(other, epsilon = EPSILON$2) {
          return Mat3.equals(this, other, epsilon);
        }
        strictEquals(other) {
          return Mat3.strictEquals(this, other);
        }
        toString() {
          const t = this;
          return `[\n${t.m00}, ${t.m01}, ${t.m02},\n${t.m03},\n${t.m04}, ${t.m05},\n${t.m06}, ${t.m07},\n${t.m08}\n` + `]`;
        }
        identity() {
          return Mat3.identity(this);
        }
        transpose() {
          const self = this;
          const a01 = self.m01;
          const a02 = self.m02;
          const a12 = self.m05;
          self.m01 = self.m03;
          self.m02 = self.m06;
          self.m03 = a01;
          self.m05 = self.m07;
          self.m06 = a02;
          self.m07 = a12;
          return self;
        }
        invert() {
          return Mat3.invert(this, this);
        }
        determinant() {
          return Mat3.determinant(this);
        }
        add(mat) {
          const self = this;
          self.m00 += mat.m00;
          self.m01 += mat.m01;
          self.m02 += mat.m02;
          self.m03 += mat.m03;
          self.m04 += mat.m04;
          self.m05 += mat.m05;
          self.m06 += mat.m06;
          self.m07 += mat.m07;
          self.m08 += mat.m08;
          return self;
        }
        subtract(mat) {
          const self = this;
          self.m00 -= mat.m00;
          self.m01 -= mat.m01;
          self.m02 -= mat.m02;
          self.m03 -= mat.m03;
          self.m04 -= mat.m04;
          self.m05 -= mat.m05;
          self.m06 -= mat.m06;
          self.m07 -= mat.m07;
          self.m08 -= mat.m08;
          return self;
        }
        multiply(mat) {
          return Mat3.multiply(this, this, mat);
        }
        multiplyScalar(scalar) {
          const self = this;
          self.m00 *= scalar;
          self.m01 *= scalar;
          self.m02 *= scalar;
          self.m03 *= scalar;
          self.m04 *= scalar;
          self.m05 *= scalar;
          self.m06 *= scalar;
          self.m07 *= scalar;
          self.m08 *= scalar;
          return self;
        }
        scale(vec) {
          const x = vec.x;
          const y = vec.y;
          const self = this;
          self.m00 *= x;
          self.m01 *= x;
          self.m02 *= x;
          self.m03 *= y;
          self.m04 *= y;
          self.m05 *= y;
          return self;
        }
        rotate(rad) {
          const self = this;
          const a00 = self.m00;
          const a01 = self.m01;
          const a02 = self.m02;
          const a10 = self.m03;
          const a11 = self.m04;
          const a12 = self.m05;
          const a20 = self.m06;
          const a21 = self.m07;
          const a22 = self.m08;
          const s = Math.sin(rad);
          const c = Math.cos(rad);
          self.m00 = c * a00 + s * a10;
          self.m01 = c * a01 + s * a11;
          self.m02 = c * a02 + s * a12;
          self.m03 = c * a10 - s * a00;
          self.m04 = c * a11 - s * a01;
          self.m05 = c * a12 - s * a02;
          self.m06 = a20;
          self.m07 = a21;
          self.m08 = a22;
          return self;
        }
        fromQuat(q) {
          const x = q.x;
          const y = q.y;
          const z = q.z;
          const w = q.w;
          const x2 = x + x;
          const y2 = y + y;
          const z2 = z + z;
          const xx = x * x2;
          const yx = y * x2;
          const yy = y * y2;
          const zx = z * x2;
          const zy = z * y2;
          const zz = z * z2;
          const wx = w * x2;
          const wy = w * y2;
          const wz = w * z2;
          const self = this;
          self.m00 = 1 - yy - zz;
          self.m03 = yx - wz;
          self.m06 = zx + wy;
          self.m01 = yx + wz;
          self.m04 = 1 - xx - zz;
          self.m07 = zy - wx;
          self.m02 = zx - wy;
          self.m05 = zy + wx;
          self.m08 = 1 - xx - yy;
          return self;
        }
      } exports("Mat3", Mat3);
      _class$2v = Mat3;
      Mat3.IDENTITY = Object.freeze(new _class$2v());
      const v3_1$3 = new Vec3();
      const v3_2 = new Vec3();
      CCClass.fastDefine('cc.Mat3', Mat3, {
        m00: 1,
        m01: 0,
        m02: 0,
        m03: 0,
        m04: 1,
        m05: 0,
        m06: 0,
        m07: 0,
        m08: 1
      });
      legacyCC.Mat3 = Mat3;

      var _class$2u;
      const abs$3 = Math.abs;
      const max$7 = Math.max;
      const min$5 = Math.min;
      const PI$3 = Math.PI;
      const acos$3 = Math.acos;
      const sin$4 = Math.sin;
      const cos$5 = Math.cos;
      const sqrt$3 = Math.sqrt;
      const atan2$2 = Math.atan2;
      const asin = Math.asin;
      const sign$1 = Math.sign;
      class Quat extends ValueType {
        static clone(a) {
          return new Quat(a.x, a.y, a.z, a.w);
        }
        static copy(out, a) {
          out.x = a.x;
          out.y = a.y;
          out.z = a.z;
          out.w = a.w;
          return out;
        }
        static set(out, x, y, z, w) {
          out.x = x;
          out.y = y;
          out.z = z;
          out.w = w;
          return out;
        }
        static identity(out) {
          out.x = 0;
          out.y = 0;
          out.z = 0;
          out.w = 1;
          return out;
        }
        static rotationTo(out, a, b) {
          const dot = Vec3.dot(a, b);
          if (dot < -0.999999) {
            Vec3.cross(v3_1$2, Vec3.UNIT_X, a);
            if (v3_1$2.length() < 0.000001) {
              Vec3.cross(v3_1$2, Vec3.UNIT_Y, a);
            }
            Vec3.normalize(v3_1$2, v3_1$2);
            Quat.fromAxisAngle(out, v3_1$2, PI$3);
            return out;
          } else if (dot > 0.999999) {
            out.x = 0;
            out.y = 0;
            out.z = 0;
            out.w = 1;
            return out;
          } else {
            Vec3.cross(v3_1$2, a, b);
            out.x = v3_1$2.x;
            out.y = v3_1$2.y;
            out.z = v3_1$2.z;
            out.w = 1 + dot;
            return Quat.normalize(out, out);
          }
        }
        static getAxisAngle(outAxis, q) {
          const rad = acos$3(q.w) * 2.0;
          const s = sin$4(rad / 2.0);
          if (s !== 0.0) {
            outAxis.x = q.x / s;
            outAxis.y = q.y / s;
            outAxis.z = q.z / s;
          } else {
            outAxis.x = 1;
            outAxis.y = 0;
            outAxis.z = 0;
          }
          return rad;
        }
        static multiply(out, a, b) {
          const x = a.x * b.w + a.w * b.x + a.y * b.z - a.z * b.y;
          const y = a.y * b.w + a.w * b.y + a.z * b.x - a.x * b.z;
          const z = a.z * b.w + a.w * b.z + a.x * b.y - a.y * b.x;
          const w = a.w * b.w - a.x * b.x - a.y * b.y - a.z * b.z;
          out.x = x;
          out.y = y;
          out.z = z;
          out.w = w;
          return out;
        }
        static multiplyScalar(out, a, b) {
          out.x = a.x * b;
          out.y = a.y * b;
          out.z = a.z * b;
          out.w = a.w * b;
          return out;
        }
        static scaleAndAdd(out, a, b, scale) {
          out.x = a.x + b.x * scale;
          out.y = a.y + b.y * scale;
          out.z = a.z + b.z * scale;
          out.w = a.w + b.w * scale;
          return out;
        }
        static rotateX(out, a, rad) {
          rad *= 0.5;
          const bx = sin$4(rad);
          const bw = cos$5(rad);
          const {
            x,
            y,
            z,
            w
          } = a;
          out.x = x * bw + w * bx;
          out.y = y * bw + z * bx;
          out.z = z * bw - y * bx;
          out.w = w * bw - x * bx;
          return out;
        }
        static rotateY(out, a, rad) {
          rad *= 0.5;
          const by = sin$4(rad);
          const bw = cos$5(rad);
          const {
            x,
            y,
            z,
            w
          } = a;
          out.x = x * bw - z * by;
          out.y = y * bw + w * by;
          out.z = z * bw + x * by;
          out.w = w * bw - y * by;
          return out;
        }
        static rotateZ(out, a, rad) {
          rad *= 0.5;
          const bz = sin$4(rad);
          const bw = cos$5(rad);
          const {
            x,
            y,
            z,
            w
          } = a;
          out.x = x * bw + y * bz;
          out.y = y * bw - x * bz;
          out.z = z * bw + w * bz;
          out.w = w * bw - z * bz;
          return out;
        }
        static rotateAround(out, rot, axis, rad) {
          Quat.invert(qt_1, rot);
          Vec3.transformQuat(v3_1$2, axis, qt_1);
          Quat.fromAxisAngle(qt_1, v3_1$2, rad);
          Quat.multiply(out, rot, qt_1);
          return out;
        }
        static rotateAroundLocal(out, rot, axis, rad) {
          Quat.fromAxisAngle(qt_1, axis, rad);
          Quat.multiply(out, rot, qt_1);
          return out;
        }
        static calculateW(out, a) {
          out.x = a.x;
          out.y = a.y;
          out.z = a.z;
          out.w = sqrt$3(abs$3(1.0 - a.x * a.x - a.y * a.y - a.z * a.z));
          return out;
        }
        static dot(a, b) {
          return a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
        }
        static lerp(out, a, b, t) {
          out.x = a.x + t * (b.x - a.x);
          out.y = a.y + t * (b.y - a.y);
          out.z = a.z + t * (b.z - a.z);
          out.w = a.w + t * (b.w - a.w);
          return out;
        }
        static slerp(out, a, b, t) {
          let scale0 = 0;
          let scale1 = 0;
          let bx = b.x;
          let by = b.y;
          let bz = b.z;
          let bw = b.w;
          let cosom = a.x * b.x + a.y * b.y + a.z * b.z + a.w * b.w;
          if (cosom < 0.0) {
            cosom = -cosom;
            bx = -bx;
            by = -by;
            bz = -bz;
            bw = -bw;
          }
          if (1.0 - cosom > 0.000001) {
            const omega = acos$3(cosom);
            const sinom = sin$4(omega);
            scale0 = sin$4((1.0 - t) * omega) / sinom;
            scale1 = sin$4(t * omega) / sinom;
          } else {
            scale0 = 1.0 - t;
            scale1 = t;
          }
          out.x = scale0 * a.x + scale1 * bx;
          out.y = scale0 * a.y + scale1 * by;
          out.z = scale0 * a.z + scale1 * bz;
          out.w = scale0 * a.w + scale1 * bw;
          return out;
        }
        static sqlerp(out, a, b, c, d, t) {
          Quat.slerp(qt_1, a, d, t);
          Quat.slerp(qt_2, b, c, t);
          Quat.slerp(out, qt_1, qt_2, 2 * t * (1 - t));
          return out;
        }
        static invert(out, a) {
          const dot = a.x * a.x + a.y * a.y + a.z * a.z + a.w * a.w;
          const invDot = dot ? 1.0 / dot : 0;
          out.x = -a.x * invDot;
          out.y = -a.y * invDot;
          out.z = -a.z * invDot;
          out.w = a.w * invDot;
          return out;
        }
        static conjugate(out, a) {
          out.x = -a.x;
          out.y = -a.y;
          out.z = -a.z;
          out.w = a.w;
          return out;
        }
        static len(a) {
          return sqrt$3(a.x * a.x + a.y * a.y + a.z * a.z + a.w * a.w);
        }
        static lengthSqr(a) {
          return a.x * a.x + a.y * a.y + a.z * a.z + a.w * a.w;
        }
        static normalize(out, a) {
          let len = a.x * a.x + a.y * a.y + a.z * a.z + a.w * a.w;
          if (len > 0) {
            len = 1 / sqrt$3(len);
            out.x = a.x * len;
            out.y = a.y * len;
            out.z = a.z * len;
            out.w = a.w * len;
          } else {
            out.x = 0;
            out.y = 0;
            out.z = 0;
            out.w = 0;
          }
          return out;
        }
        static fromAxes(out, xAxis, yAxis, zAxis) {
          Mat3.set(m3_1$1, xAxis.x, xAxis.y, xAxis.z, yAxis.x, yAxis.y, yAxis.z, zAxis.x, zAxis.y, zAxis.z);
          return Quat.normalize(out, Quat.fromMat3(out, m3_1$1));
        }
        static fromViewUp(out, view, up) {
          Mat3.fromViewUp(m3_1$1, view, up);
          return Quat.normalize(out, Quat.fromMat3(out, m3_1$1));
        }
        static fromAxisAngle(out, axis, rad) {
          rad *= 0.5;
          const s = sin$4(rad);
          out.x = s * axis.x;
          out.y = s * axis.y;
          out.z = s * axis.z;
          out.w = cos$5(rad);
          return out;
        }
        static fromMat3(out, m) {
          const {
            m00,
            m01,
            m02,
            m03: m10,
            m04: m11,
            m05: m12,
            m06: m20,
            m07: m21,
            m08: m22
          } = m;
          const fourXSquaredMinus1 = m00 - m11 - m22;
          const fourYSquaredMinus1 = m11 - m00 - m22;
          const fourZSquaredMinus1 = m22 - m00 - m11;
          const fourWSquaredMinus1 = m00 + m11 + m22;
          let biggestIndex = 0;
          let fourBiggestSquaredMinus1 = fourWSquaredMinus1;
          if (fourXSquaredMinus1 > fourBiggestSquaredMinus1) {
            fourBiggestSquaredMinus1 = fourXSquaredMinus1;
            biggestIndex = 1;
          }
          if (fourYSquaredMinus1 > fourBiggestSquaredMinus1) {
            fourBiggestSquaredMinus1 = fourYSquaredMinus1;
            biggestIndex = 2;
          }
          if (fourZSquaredMinus1 > fourBiggestSquaredMinus1) {
            fourBiggestSquaredMinus1 = fourZSquaredMinus1;
            biggestIndex = 3;
          }
          const biggestVal = sqrt$3(fourBiggestSquaredMinus1 + 1) * 0.5;
          const mult = 0.25 / biggestVal;
          switch (biggestIndex) {
            case 0:
              out.w = biggestVal;
              out.x = (m12 - m21) * mult;
              out.y = (m20 - m02) * mult;
              out.z = (m01 - m10) * mult;
              break;
            case 1:
              out.w = (m12 - m21) * mult;
              out.x = biggestVal;
              out.y = (m01 + m10) * mult;
              out.z = (m20 + m02) * mult;
              break;
            case 2:
              out.w = (m20 - m02) * mult;
              out.x = (m01 + m10) * mult;
              out.y = biggestVal;
              out.z = (m12 + m21) * mult;
              break;
            case 3:
              out.w = (m01 - m10) * mult;
              out.x = (m20 + m02) * mult;
              out.y = (m12 + m21) * mult;
              out.z = biggestVal;
              break;
            default:
              out.w = 1;
              out.x = 0;
              out.y = 0;
              out.z = 0;
              break;
          }
          return out;
        }
        static fromEuler(out, x, y, z) {
          x *= halfToRad;
          y *= halfToRad;
          z *= halfToRad;
          const sx = sin$4(x);
          const cx = cos$5(x);
          const sy = sin$4(y);
          const cy = cos$5(y);
          const sz = sin$4(z);
          const cz = cos$5(z);
          out.x = sx * cy * cz + cx * sy * sz;
          out.y = cx * sy * cz + sx * cy * sz;
          out.z = cx * cy * sz - sx * sy * cz;
          out.w = cx * cy * cz - sx * sy * sz;
          return out;
        }
        static fromAngleZ(out, z) {
          z *= halfToRad;
          out.x = out.y = 0;
          out.z = sin$4(z);
          out.w = cos$5(z);
          return out;
        }
        static toAxisX(out, q) {
          const fy = 2.0 * q.y;
          const fz = 2.0 * q.z;
          out.x = 1.0 - fy * q.y - fz * q.z;
          out.y = fy * q.x + fz * q.w;
          out.z = fz * q.x - fy * q.w;
          return out;
        }
        static toAxisY(out, q) {
          const fx = 2.0 * q.x;
          const fy = 2.0 * q.y;
          const fz = 2.0 * q.z;
          out.x = fy * q.x - fz * q.w;
          out.y = 1.0 - fx * q.x - fz * q.z;
          out.z = fz * q.y + fx * q.w;
          return out;
        }
        static toAxisZ(out, q) {
          const fx = 2.0 * q.x;
          const fy = 2.0 * q.y;
          const fz = 2.0 * q.z;
          out.x = fz * q.x + fy * q.w;
          out.y = fz * q.y - fx * q.w;
          out.z = 1.0 - fx * q.x - fy * q.y;
          return out;
        }
        static toEuler(out, q, outerZ) {
          const {
            x,
            y,
            z,
            w
          } = q;
          let bank = 0;
          let heading = 0;
          let attitude = 0;
          const test = x * y + z * w;
          if (test > 0.499999) {
            bank = 0;
            heading = toDegree(2 * atan2$2(x, w));
            attitude = 90;
          } else if (test < -0.499999) {
            bank = 0;
            heading = -toDegree(2 * atan2$2(x, w));
            attitude = -90;
          } else {
            const sqx = x * x;
            const sqy = y * y;
            const sqz = z * z;
            bank = toDegree(atan2$2(2 * x * w - 2 * y * z, 1 - 2 * sqx - 2 * sqz));
            heading = toDegree(atan2$2(2 * y * w - 2 * x * z, 1 - 2 * sqy - 2 * sqz));
            attitude = toDegree(asin(2 * test));
            if (outerZ) {
              bank = -180 * sign$1(bank + 1e-6) + bank;
              heading = -180 * sign$1(heading + 1e-6) + heading;
              attitude = 180 * sign$1(attitude + 1e-6) - attitude;
            }
          }
          out.x = bank;
          out.y = heading;
          out.z = attitude;
          return out;
        }
        static toEulerInYXZOrder(out, q) {
          Mat3.fromQuat(m3_1$1, q);
          Mat3.toEuler(m3_1$1, out);
          out.x = toDegree(out.x);
          out.y = toDegree(out.y);
          out.z = toDegree(out.z);
        }
        static toArray(out, q, ofs = 0) {
          out[ofs + 0] = q.x;
          out[ofs + 1] = q.y;
          out[ofs + 2] = q.z;
          out[ofs + 3] = q.w;
          return out;
        }
        static fromArray(out, arr, ofs = 0) {
          out.x = arr[ofs + 0];
          out.y = arr[ofs + 1];
          out.z = arr[ofs + 2];
          out.w = arr[ofs + 3];
          return out;
        }
        static strictEquals(a, b) {
          return a.x === b.x && a.y === b.y && a.z === b.z && a.w === b.w;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          return abs$3(a.x - b.x) <= epsilon * max$7(1.0, abs$3(a.x), abs$3(b.x)) && abs$3(a.y - b.y) <= epsilon * max$7(1.0, abs$3(a.y), abs$3(b.y)) && abs$3(a.z - b.z) <= epsilon * max$7(1.0, abs$3(a.z), abs$3(b.z)) && abs$3(a.w - b.w) <= epsilon * max$7(1.0, abs$3(a.w), abs$3(b.w));
        }
        static angle(a, b) {
          const dot = min$5(abs$3(Quat.dot(a, b)), 1.0);
          return acos$3(dot) * 2.0;
        }
        static rotateTowards(out, from, to, maxStep) {
          const angle = Quat.angle(from, to);
          if (angle === 0) {
            out.x = to.x;
            out.y = to.y;
            out.z = to.z;
            out.w = to.w;
            return out;
          }
          const t = min$5(maxStep / toDegree(angle), 1.0);
          return Quat.slerp(out, from, to, t);
        }
        constructor(x, y, z, w) {
          super();
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.z = x.z;
            this.w = x.w;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.z = z || 0;
            this.w = w !== null && w !== void 0 ? w : 1;
          }
        }
        clone() {
          return new Quat(this.x, this.y, this.z, this.w);
        }
        set(x, y, z, w) {
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.z = x.z;
            this.w = x.w;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.z = z || 0;
            this.w = w !== null && w !== void 0 ? w : 1;
          }
          return this;
        }
        equals(other, epsilon = EPSILON$2) {
          return Quat.equals(this, other, epsilon);
        }
        strictEquals(other) {
          return other && this.x === other.x && this.y === other.y && this.z === other.z && this.w === other.w;
        }
        getEulerAngles(out) {
          return Quat.toEuler(out, this);
        }
        lerp(to, ratio) {
          const self = this;
          self.x += ratio * (to.x - self.x);
          self.y += ratio * (to.y - self.y);
          self.z += ratio * (to.z - self.z);
          self.w += ratio * (to.w - self.w);
          return self;
        }
        slerp(to, ratio) {
          return Quat.slerp(this, this, to, ratio);
        }
        length() {
          const self = this;
          const {
            x,
            y,
            z,
            w
          } = self;
          return sqrt$3(x * x + y * y + z * z + w * w);
        }
        lengthSqr() {
          const self = this;
          const {
            x,
            y,
            z,
            w
          } = self;
          return x * x + y * y + z * z + w * w;
        }
      } exports("Quat", Quat);
      _class$2u = Quat;
      Quat.IDENTITY = Object.freeze(new _class$2u());
      const qt_1 = new Quat();
      const qt_2 = new Quat();
      const v3_1$2 = new Vec3();
      const m3_1$1 = new Mat3();
      const halfToRad = 0.5 * PI$3 / 180.0;
      CCClass.fastDefine('cc.Quat', Quat, {
        x: 0,
        y: 0,
        z: 0,
        w: 1
      });
      legacyCC.Quat = Quat;
      function quat(x = 0, y = 0, z = 0, w = 1) {
        return new Quat(x, y, z, w);
      }
      legacyCC.quat = quat;

      var _class$2t;
      const preTransforms = exports("preTransforms", Object.freeze([Object.freeze([1, 0, 0, 1]), Object.freeze([0, 1, -1, 0]), Object.freeze([-1, 0, 0, -1]), Object.freeze([0, -1, 1, 0])]));
      const abs$2 = Math.abs;
      const max$6 = Math.max;
      const sqrt$2 = Math.sqrt;
      const sin$3 = Math.sin;
      const cos$4 = Math.cos;
      const tan = Math.tan;
      class Mat4 extends ValueType {
        static clone(a) {
          return new Mat4(a.m00, a.m01, a.m02, a.m03, a.m04, a.m05, a.m06, a.m07, a.m08, a.m09, a.m10, a.m11, a.m12, a.m13, a.m14, a.m15);
        }
        static copy(out, a) {
          out.m00 = a.m00;
          out.m01 = a.m01;
          out.m02 = a.m02;
          out.m03 = a.m03;
          out.m04 = a.m04;
          out.m05 = a.m05;
          out.m06 = a.m06;
          out.m07 = a.m07;
          out.m08 = a.m08;
          out.m09 = a.m09;
          out.m10 = a.m10;
          out.m11 = a.m11;
          out.m12 = a.m12;
          out.m13 = a.m13;
          out.m14 = a.m14;
          out.m15 = a.m15;
          return out;
        }
        static set(out, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
          out.m00 = m00;
          out.m01 = m01;
          out.m02 = m02;
          out.m03 = m03;
          out.m04 = m10;
          out.m05 = m11;
          out.m06 = m12;
          out.m07 = m13;
          out.m08 = m20;
          out.m09 = m21;
          out.m10 = m22;
          out.m11 = m23;
          out.m12 = m30;
          out.m13 = m31;
          out.m14 = m32;
          out.m15 = m33;
          return out;
        }
        static identity(out) {
          out.m00 = 1;
          out.m01 = 0;
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = 0;
          out.m05 = 1;
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 0;
          out.m09 = 0;
          out.m10 = 1;
          out.m11 = 0;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = 0;
          out.m15 = 1;
          return out;
        }
        static zero(out) {
          out.m00 = 0;
          out.m01 = 0;
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = 0;
          out.m05 = 0;
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 0;
          out.m09 = 0;
          out.m10 = 0;
          out.m11 = 0;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = 0;
          out.m15 = 0;
          return out;
        }
        static transpose(out, a) {
          if (out === a) {
            const a01 = a.m01;
            const a02 = a.m02;
            const a03 = a.m03;
            const a12 = a.m06;
            const a13 = a.m07;
            const a23 = a.m11;
            out.m01 = a.m04;
            out.m02 = a.m08;
            out.m03 = a.m12;
            out.m04 = a01;
            out.m06 = a.m09;
            out.m07 = a.m13;
            out.m08 = a02;
            out.m09 = a12;
            out.m11 = a.m14;
            out.m12 = a03;
            out.m13 = a13;
            out.m14 = a23;
          } else {
            out.m00 = a.m00;
            out.m01 = a.m04;
            out.m02 = a.m08;
            out.m03 = a.m12;
            out.m04 = a.m01;
            out.m05 = a.m05;
            out.m06 = a.m09;
            out.m07 = a.m13;
            out.m08 = a.m02;
            out.m09 = a.m06;
            out.m10 = a.m10;
            out.m11 = a.m14;
            out.m12 = a.m03;
            out.m13 = a.m07;
            out.m14 = a.m11;
            out.m15 = a.m15;
          }
          return out;
        }
        static invert(out, a) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          const a30 = a.m12;
          const a31 = a.m13;
          const a32 = a.m14;
          const a33 = a.m15;
          const b00 = a00 * a11 - a01 * a10;
          const b01 = a00 * a12 - a02 * a10;
          const b02 = a00 * a13 - a03 * a10;
          const b03 = a01 * a12 - a02 * a11;
          const b04 = a01 * a13 - a03 * a11;
          const b05 = a02 * a13 - a03 * a12;
          const b06 = a20 * a31 - a21 * a30;
          const b07 = a20 * a32 - a22 * a30;
          const b08 = a20 * a33 - a23 * a30;
          const b09 = a21 * a32 - a22 * a31;
          const b10 = a21 * a33 - a23 * a31;
          const b11 = a22 * a33 - a23 * a32;
          let det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
          if (det === 0) {
            return Mat4.zero(out);
          }
          det = 1.0 / det;
          out.m00 = (a11 * b11 - a12 * b10 + a13 * b09) * det;
          out.m01 = (a02 * b10 - a01 * b11 - a03 * b09) * det;
          out.m02 = (a31 * b05 - a32 * b04 + a33 * b03) * det;
          out.m03 = (a22 * b04 - a21 * b05 - a23 * b03) * det;
          out.m04 = (a12 * b08 - a10 * b11 - a13 * b07) * det;
          out.m05 = (a00 * b11 - a02 * b08 + a03 * b07) * det;
          out.m06 = (a32 * b02 - a30 * b05 - a33 * b01) * det;
          out.m07 = (a20 * b05 - a22 * b02 + a23 * b01) * det;
          out.m08 = (a10 * b10 - a11 * b08 + a13 * b06) * det;
          out.m09 = (a01 * b08 - a00 * b10 - a03 * b06) * det;
          out.m10 = (a30 * b04 - a31 * b02 + a33 * b00) * det;
          out.m11 = (a21 * b02 - a20 * b04 - a23 * b00) * det;
          out.m12 = (a11 * b07 - a10 * b09 - a12 * b06) * det;
          out.m13 = (a00 * b09 - a01 * b07 + a02 * b06) * det;
          out.m14 = (a31 * b01 - a30 * b03 - a32 * b00) * det;
          out.m15 = (a20 * b03 - a21 * b01 + a22 * b00) * det;
          return out;
        }
        static determinant(a) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          const a30 = a.m12;
          const a31 = a.m13;
          const a32 = a.m14;
          const a33 = a.m15;
          const b00 = a00 * a11 - a01 * a10;
          const b01 = a00 * a12 - a02 * a10;
          const b02 = a00 * a13 - a03 * a10;
          const b03 = a01 * a12 - a02 * a11;
          const b04 = a01 * a13 - a03 * a11;
          const b05 = a02 * a13 - a03 * a12;
          const b06 = a20 * a31 - a21 * a30;
          const b07 = a20 * a32 - a22 * a30;
          const b08 = a20 * a33 - a23 * a30;
          const b09 = a21 * a32 - a22 * a31;
          const b10 = a21 * a33 - a23 * a31;
          const b11 = a22 * a33 - a23 * a32;
          return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
        }
        static multiply(out, a, b) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          const a30 = a.m12;
          const a31 = a.m13;
          const a32 = a.m14;
          const a33 = a.m15;
          let b0 = b.m00;
          let b1 = b.m01;
          let b2 = b.m02;
          let b3 = b.m03;
          out.m00 = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
          out.m01 = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
          out.m02 = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
          out.m03 = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
          b0 = b.m04;
          b1 = b.m05;
          b2 = b.m06;
          b3 = b.m07;
          out.m04 = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
          out.m05 = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
          out.m06 = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
          out.m07 = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
          b0 = b.m08;
          b1 = b.m09;
          b2 = b.m10;
          b3 = b.m11;
          out.m08 = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
          out.m09 = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
          out.m10 = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
          out.m11 = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
          b0 = b.m12;
          b1 = b.m13;
          b2 = b.m14;
          b3 = b.m15;
          out.m12 = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
          out.m13 = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
          out.m14 = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
          out.m15 = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
          return out;
        }
        static transform(out, a, v) {
          const x = v.x;
          const y = v.y;
          const z = v.z;
          if (a === out) {
            out.m12 = a.m00 * x + a.m04 * y + a.m08 * z + a.m12;
            out.m13 = a.m01 * x + a.m05 * y + a.m09 * z + a.m13;
            out.m14 = a.m02 * x + a.m06 * y + a.m10 * z + a.m14;
            out.m15 = a.m03 * x + a.m07 * y + a.m11 * z + a.m15;
          } else {
            const a00 = a.m00;
            const a01 = a.m01;
            const a02 = a.m02;
            const a03 = a.m03;
            const a10 = a.m04;
            const a11 = a.m05;
            const a12 = a.m06;
            const a13 = a.m07;
            const a20 = a.m08;
            const a21 = a.m09;
            const a22 = a.m10;
            const a23 = a.m11;
            out.m00 = a00;
            out.m01 = a01;
            out.m02 = a02;
            out.m03 = a03;
            out.m04 = a10;
            out.m05 = a11;
            out.m06 = a12;
            out.m07 = a13;
            out.m08 = a20;
            out.m09 = a21;
            out.m10 = a22;
            out.m11 = a23;
            out.m12 = a00 * x + a10 * y + a20 * z + a.m12;
            out.m13 = a01 * x + a11 * y + a21 * z + a.m13;
            out.m14 = a02 * x + a12 * y + a22 * z + a.m14;
            out.m15 = a03 * x + a13 * y + a23 * z + a.m15;
          }
          return out;
        }
        static translate(out, a, v) {
          if (a === out) {
            out.m12 += v.x;
            out.m13 += v.y;
            out.m14 += v.z;
          } else {
            out.m00 = a.m00;
            out.m01 = a.m01;
            out.m02 = a.m02;
            out.m03 = a.m03;
            out.m04 = a.m04;
            out.m05 = a.m05;
            out.m06 = a.m06;
            out.m07 = a.m07;
            out.m08 = a.m08;
            out.m09 = a.m09;
            out.m10 = a.m10;
            out.m11 = a.m11;
            out.m12 = a.m12 + v.x;
            out.m13 = a.m13 + v.y;
            out.m14 = a.m14 + v.z;
            out.m15 = a.m15;
          }
          return out;
        }
        static scale(out, a, v) {
          const x = v.x;
          const y = v.y;
          const z = v.z;
          out.m00 = a.m00 * x;
          out.m01 = a.m01 * x;
          out.m02 = a.m02 * x;
          out.m03 = a.m03 * x;
          out.m04 = a.m04 * y;
          out.m05 = a.m05 * y;
          out.m06 = a.m06 * y;
          out.m07 = a.m07 * y;
          out.m08 = a.m08 * z;
          out.m09 = a.m09 * z;
          out.m10 = a.m10 * z;
          out.m11 = a.m11 * z;
          out.m12 = a.m12;
          out.m13 = a.m13;
          out.m14 = a.m14;
          out.m15 = a.m15;
          return out;
        }
        static rotate(out, a, rad, axis) {
          let x = axis.x;
          let y = axis.y;
          let z = axis.z;
          let len = sqrt$2(x * x + y * y + z * z);
          if (abs$2(len) < EPSILON$2) {
            return null;
          }
          len = 1 / len;
          x *= len;
          y *= len;
          z *= len;
          const s = sin$3(rad);
          const c = cos$4(rad);
          const t = 1 - c;
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          const b00 = x * x * t + c;
          const b01 = y * x * t + z * s;
          const b02 = z * x * t - y * s;
          const b10 = x * y * t - z * s;
          const b11 = y * y * t + c;
          const b12 = z * y * t + x * s;
          const b20 = x * z * t + y * s;
          const b21 = y * z * t - x * s;
          const b22 = z * z * t + c;
          out.m00 = a00 * b00 + a10 * b01 + a20 * b02;
          out.m01 = a01 * b00 + a11 * b01 + a21 * b02;
          out.m02 = a02 * b00 + a12 * b01 + a22 * b02;
          out.m03 = a03 * b00 + a13 * b01 + a23 * b02;
          out.m04 = a00 * b10 + a10 * b11 + a20 * b12;
          out.m05 = a01 * b10 + a11 * b11 + a21 * b12;
          out.m06 = a02 * b10 + a12 * b11 + a22 * b12;
          out.m07 = a03 * b10 + a13 * b11 + a23 * b12;
          out.m08 = a00 * b20 + a10 * b21 + a20 * b22;
          out.m09 = a01 * b20 + a11 * b21 + a21 * b22;
          out.m10 = a02 * b20 + a12 * b21 + a22 * b22;
          out.m11 = a03 * b20 + a13 * b21 + a23 * b22;
          if (a !== out) {
            out.m12 = a.m12;
            out.m13 = a.m13;
            out.m14 = a.m14;
            out.m15 = a.m15;
          }
          return out;
        }
        static rotateX(out, a, rad) {
          const s = sin$3(rad);
          const c = cos$4(rad);
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          if (a !== out) {
            out.m00 = a.m00;
            out.m01 = a.m01;
            out.m02 = a.m02;
            out.m03 = a.m03;
            out.m12 = a.m12;
            out.m13 = a.m13;
            out.m14 = a.m14;
            out.m15 = a.m15;
          }
          out.m04 = a10 * c + a20 * s;
          out.m05 = a11 * c + a21 * s;
          out.m06 = a12 * c + a22 * s;
          out.m07 = a13 * c + a23 * s;
          out.m08 = a20 * c - a10 * s;
          out.m09 = a21 * c - a11 * s;
          out.m10 = a22 * c - a12 * s;
          out.m11 = a23 * c - a13 * s;
          return out;
        }
        static rotateY(out, a, rad) {
          const s = sin$3(rad);
          const c = cos$4(rad);
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          if (a !== out) {
            out.m04 = a.m04;
            out.m05 = a.m05;
            out.m06 = a.m06;
            out.m07 = a.m07;
            out.m12 = a.m12;
            out.m13 = a.m13;
            out.m14 = a.m14;
            out.m15 = a.m15;
          }
          out.m00 = a00 * c - a20 * s;
          out.m01 = a01 * c - a21 * s;
          out.m02 = a02 * c - a22 * s;
          out.m03 = a03 * c - a23 * s;
          out.m08 = a00 * s + a20 * c;
          out.m09 = a01 * s + a21 * c;
          out.m10 = a02 * s + a22 * c;
          out.m11 = a03 * s + a23 * c;
          return out;
        }
        static rotateZ(out, a, rad) {
          const s = sin$3(rad);
          const c = cos$4(rad);
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          if (a !== out) {
            out.m08 = a.m08;
            out.m09 = a.m09;
            out.m10 = a.m10;
            out.m11 = a.m11;
            out.m12 = a.m12;
            out.m13 = a.m13;
            out.m14 = a.m14;
            out.m15 = a.m15;
          }
          out.m00 = a00 * c + a10 * s;
          out.m01 = a01 * c + a11 * s;
          out.m02 = a02 * c + a12 * s;
          out.m03 = a03 * c + a13 * s;
          out.m04 = a10 * c - a00 * s;
          out.m05 = a11 * c - a01 * s;
          out.m06 = a12 * c - a02 * s;
          out.m07 = a13 * c - a03 * s;
          return out;
        }
        static fromTranslation(out, v) {
          Mat4.identity(out);
          out.m12 = v.x;
          out.m13 = v.y;
          out.m14 = v.z;
          return out;
        }
        static fromScaling(out, v) {
          Mat4.identity(out);
          out.m00 = v.x;
          out.m05 = v.y;
          out.m10 = v.z;
          return out;
        }
        static fromRotation(out, rad, axis) {
          let x = axis.x;
          let y = axis.y;
          let z = axis.z;
          let len = sqrt$2(x * x + y * y + z * z);
          if (abs$2(len) < EPSILON$2) {
            return null;
          }
          len = 1 / len;
          x *= len;
          y *= len;
          z *= len;
          const s = sin$3(rad);
          const c = cos$4(rad);
          const t = 1 - c;
          out.m00 = x * x * t + c;
          out.m01 = y * x * t + z * s;
          out.m02 = z * x * t - y * s;
          out.m03 = 0;
          out.m04 = x * y * t - z * s;
          out.m05 = y * y * t + c;
          out.m06 = z * y * t + x * s;
          out.m07 = 0;
          out.m08 = x * z * t + y * s;
          out.m09 = y * z * t - x * s;
          out.m10 = z * z * t + c;
          out.m11 = 0;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = 0;
          out.m15 = 1;
          return out;
        }
        static fromXRotation(out, rad) {
          const s = sin$3(rad);
          const c = cos$4(rad);
          Mat4.identity(out);
          out.m05 = c;
          out.m06 = s;
          out.m09 = -s;
          out.m10 = c;
          return out;
        }
        static fromYRotation(out, rad) {
          const s = sin$3(rad);
          const c = cos$4(rad);
          Mat4.identity(out);
          out.m00 = c;
          out.m02 = -s;
          out.m08 = s;
          out.m10 = c;
          return out;
        }
        static fromZRotation(out, rad) {
          const s = sin$3(rad);
          const c = cos$4(rad);
          Mat4.identity(out);
          out.m00 = c;
          out.m01 = s;
          out.m04 = -s;
          out.m05 = c;
          return out;
        }
        static fromRT(out, q, v) {
          const x = q.x;
          const y = q.y;
          const z = q.z;
          const w = q.w;
          const x2 = x + x;
          const y2 = y + y;
          const z2 = z + z;
          const xx = x * x2;
          const xy = x * y2;
          const xz = x * z2;
          const yy = y * y2;
          const yz = y * z2;
          const zz = z * z2;
          const wx = w * x2;
          const wy = w * y2;
          const wz = w * z2;
          out.m00 = 1 - (yy + zz);
          out.m01 = xy + wz;
          out.m02 = xz - wy;
          out.m03 = 0;
          out.m04 = xy - wz;
          out.m05 = 1 - (xx + zz);
          out.m06 = yz + wx;
          out.m07 = 0;
          out.m08 = xz + wy;
          out.m09 = yz - wx;
          out.m10 = 1 - (xx + yy);
          out.m11 = 0;
          out.m12 = v.x;
          out.m13 = v.y;
          out.m14 = v.z;
          out.m15 = 1;
          return out;
        }
        static getTranslation(out, mat) {
          out.x = mat.m12;
          out.y = mat.m13;
          out.z = mat.m14;
          return out;
        }
        static getScaling(out, mat) {
          const m00 = m3_1.m00 = mat.m00;
          const m01 = m3_1.m01 = mat.m01;
          const m02 = m3_1.m02 = mat.m02;
          const m04 = m3_1.m03 = mat.m04;
          const m05 = m3_1.m04 = mat.m05;
          const m06 = m3_1.m05 = mat.m06;
          const m08 = m3_1.m06 = mat.m08;
          const m09 = m3_1.m07 = mat.m09;
          const m10 = m3_1.m08 = mat.m10;
          out.x = sqrt$2(m00 * m00 + m01 * m01 + m02 * m02);
          out.y = sqrt$2(m04 * m04 + m05 * m05 + m06 * m06);
          out.z = sqrt$2(m08 * m08 + m09 * m09 + m10 * m10);
          if (Mat3.determinant(m3_1) < 0) {
            out.x *= -1;
          }
          return out;
        }
        static getRotation(out, mat) {
          const trace = mat.m00 + mat.m05 + mat.m10;
          let S = 0;
          if (trace > 0) {
            S = sqrt$2(trace + 1.0) * 2;
            out.w = 0.25 * S;
            out.x = (mat.m06 - mat.m09) / S;
            out.y = (mat.m08 - mat.m02) / S;
            out.z = (mat.m01 - mat.m04) / S;
          } else if (mat.m00 > mat.m05 && mat.m00 > mat.m10) {
            S = sqrt$2(1.0 + mat.m00 - mat.m05 - mat.m10) * 2;
            out.w = (mat.m06 - mat.m09) / S;
            out.x = 0.25 * S;
            out.y = (mat.m01 + mat.m04) / S;
            out.z = (mat.m08 + mat.m02) / S;
          } else if (mat.m05 > mat.m10) {
            S = sqrt$2(1.0 + mat.m05 - mat.m00 - mat.m10) * 2;
            out.w = (mat.m08 - mat.m02) / S;
            out.x = (mat.m01 + mat.m04) / S;
            out.y = 0.25 * S;
            out.z = (mat.m06 + mat.m09) / S;
          } else {
            S = sqrt$2(1.0 + mat.m10 - mat.m00 - mat.m05) * 2;
            out.w = (mat.m01 - mat.m04) / S;
            out.x = (mat.m08 + mat.m02) / S;
            out.y = (mat.m06 + mat.m09) / S;
            out.z = 0.25 * S;
          }
          return out;
        }
        static toRTS(m, q, v, s) {
          Mat4.toSRT(m, q, v, s);
        }
        static toSRT(m, q, v, s) {
          if (v) {
            Vec3.set(v, m.m12, m.m13, m.m14);
          }
          const sx = Vec3.set(v3_1$1, m.m00, m.m01, m.m02).length();
          const sy = Vec3.set(v3_1$1, m.m04, m.m05, m.m06).length();
          const sz = Vec3.set(v3_1$1, m.m08, m.m09, m.m10).length();
          if (s) {
            s.x = sx;
            s.y = sy;
            s.z = sz;
          }
          if (sx === 0 || sy === 0 || sz === 0) {
            if (q) {
              Quat.identity(q);
            }
            return;
          }
          m3_1.m00 = m.m00 / sx;
          m3_1.m01 = m.m01 / sx;
          m3_1.m02 = m.m02 / sx;
          m3_1.m03 = m.m04 / sy;
          m3_1.m04 = m.m05 / sy;
          m3_1.m05 = m.m06 / sy;
          m3_1.m06 = m.m08 / sz;
          m3_1.m07 = m.m09 / sz;
          m3_1.m08 = m.m10 / sz;
          const det = Mat3.determinant(m3_1);
          if (s) {
            if (det < 0) {
              s.x *= -1;
            }
          }
          if (q) {
            if (det < 0) {
              m3_1.m00 *= -1;
              m3_1.m01 *= -1;
              m3_1.m02 *= -1;
            }
            Quat.fromMat3(q, m3_1);
          }
        }
        static toEuler(m, v) {
          Mat3.set(m3_1, m.m00, m.m01, m.m02, m.m04, m.m05, m.m06, m.m08, m.m09, m.m10);
          return Mat3.toEuler(m3_1, v);
        }
        static fromRTS(out, q, v, s) {
          return Mat4.fromSRT(out, q, v, s);
        }
        static fromSRT(out, q, v, s) {
          const {
            x,
            y,
            z,
            w
          } = q;
          const x2 = x + x;
          const y2 = y + y;
          const z2 = z + z;
          const xx = x * x2;
          const xy = x * y2;
          const xz = x * z2;
          const yy = y * y2;
          const yz = y * z2;
          const zz = z * z2;
          const wx = w * x2;
          const wy = w * y2;
          const wz = w * z2;
          const sx = s.x;
          const sy = s.y;
          const sz = s.z;
          out.m00 = (1 - (yy + zz)) * sx;
          out.m01 = (xy + wz) * sx;
          out.m02 = (xz - wy) * sx;
          out.m03 = 0;
          out.m04 = (xy - wz) * sy;
          out.m05 = (1 - (xx + zz)) * sy;
          out.m06 = (yz + wx) * sy;
          out.m07 = 0;
          out.m08 = (xz + wy) * sz;
          out.m09 = (yz - wx) * sz;
          out.m10 = (1 - (xx + yy)) * sz;
          out.m11 = 0;
          out.m12 = v.x;
          out.m13 = v.y;
          out.m14 = v.z;
          out.m15 = 1;
          return out;
        }
        static fromRTSOrigin(out, q, v, s, o) {
          return Mat4.fromSRTOrigin(out, q, v, s, o);
        }
        static fromSRTOrigin(out, q, v, s, o) {
          const x = q.x;
          const y = q.y;
          const z = q.z;
          const w = q.w;
          const x2 = x + x;
          const y2 = y + y;
          const z2 = z + z;
          const xx = x * x2;
          const xy = x * y2;
          const xz = x * z2;
          const yy = y * y2;
          const yz = y * z2;
          const zz = z * z2;
          const wx = w * x2;
          const wy = w * y2;
          const wz = w * z2;
          const sx = s.x;
          const sy = s.y;
          const sz = s.z;
          const ox = o.x;
          const oy = o.y;
          const oz = o.z;
          out.m00 = (1 - (yy + zz)) * sx;
          out.m01 = (xy + wz) * sx;
          out.m02 = (xz - wy) * sx;
          out.m03 = 0;
          out.m04 = (xy - wz) * sy;
          out.m05 = (1 - (xx + zz)) * sy;
          out.m06 = (yz + wx) * sy;
          out.m07 = 0;
          out.m08 = (xz + wy) * sz;
          out.m09 = (yz - wx) * sz;
          out.m10 = (1 - (xx + yy)) * sz;
          out.m11 = 0;
          out.m12 = v.x + ox - (out.m00 * ox + out.m04 * oy + out.m08 * oz);
          out.m13 = v.y + oy - (out.m01 * ox + out.m05 * oy + out.m09 * oz);
          out.m14 = v.z + oz - (out.m02 * ox + out.m06 * oy + out.m10 * oz);
          out.m15 = 1;
          return out;
        }
        static fromQuat(out, q) {
          const x = q.x;
          const y = q.y;
          const z = q.z;
          const w = q.w;
          const x2 = x + x;
          const y2 = y + y;
          const z2 = z + z;
          const xx = x * x2;
          const yx = y * x2;
          const yy = y * y2;
          const zx = z * x2;
          const zy = z * y2;
          const zz = z * z2;
          const wx = w * x2;
          const wy = w * y2;
          const wz = w * z2;
          out.m00 = 1 - yy - zz;
          out.m01 = yx + wz;
          out.m02 = zx - wy;
          out.m03 = 0;
          out.m04 = yx - wz;
          out.m05 = 1 - xx - zz;
          out.m06 = zy + wx;
          out.m07 = 0;
          out.m08 = zx + wy;
          out.m09 = zy - wx;
          out.m10 = 1 - xx - yy;
          out.m11 = 0;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = 0;
          out.m15 = 1;
          return out;
        }
        static frustum(out, left, right, bottom, top, near, far) {
          const rl = 1 / (right - left);
          const tb = 1 / (top - bottom);
          const nf = 1 / (near - far);
          out.m00 = near * 2 * rl;
          out.m01 = 0;
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = 0;
          out.m05 = near * 2 * tb;
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = (right + left) * rl;
          out.m09 = (top + bottom) * tb;
          out.m10 = (far + near) * nf;
          out.m11 = -1;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = far * near * 2 * nf;
          out.m15 = 0;
          return out;
        }
        static perspective(out, fov, aspect, near, far, isFOVY = true, minClipZ = -1, projectionSignY = 1, orientation = 0) {
          const f = 1.0 / tan(fov / 2);
          const nf = 1 / (near - far);
          const x = isFOVY ? f / aspect : f;
          const y = (isFOVY ? f : f * aspect) * projectionSignY;
          const preTransform = preTransforms[orientation];
          out.m00 = x * preTransform[0];
          out.m01 = x * preTransform[1];
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = y * preTransform[2];
          out.m05 = y * preTransform[3];
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 0;
          out.m09 = 0;
          out.m10 = (far - minClipZ * near) * nf;
          out.m11 = -1;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = far * near * nf * (1 - minClipZ);
          out.m15 = 0;
          return out;
        }
        static ortho(out, left, right, bottom, top, near, far, minClipZ = -1, projectionSignY = 1, orientation = 0) {
          const lr = 1 / (left - right);
          const bt = 1 / (bottom - top) * projectionSignY;
          const nf = 1 / (near - far);
          const x = -2 * lr;
          const y = -2 * bt;
          const dx = (left + right) * lr;
          const dy = (top + bottom) * bt;
          const preTransform = preTransforms[orientation];
          out.m00 = x * preTransform[0];
          out.m01 = x * preTransform[1];
          out.m02 = 0;
          out.m03 = 0;
          out.m04 = y * preTransform[2];
          out.m05 = y * preTransform[3];
          out.m06 = 0;
          out.m07 = 0;
          out.m08 = 0;
          out.m09 = 0;
          out.m10 = nf * (1 - minClipZ);
          out.m11 = 0;
          out.m12 = dx * preTransform[0] + dy * preTransform[2];
          out.m13 = dx * preTransform[1] + dy * preTransform[3];
          out.m14 = (near - minClipZ * far) * nf;
          out.m15 = 1;
          return out;
        }
        static lookAt(out, eye, center, up) {
          const eyex = eye.x;
          const eyey = eye.y;
          const eyez = eye.z;
          const upx = up.x;
          const upy = up.y;
          const upz = up.z;
          const centerx = center.x;
          const centery = center.y;
          const centerz = center.z;
          let z0 = eyex - centerx;
          let z1 = eyey - centery;
          let z2 = eyez - centerz;
          let len = 1 / sqrt$2(z0 * z0 + z1 * z1 + z2 * z2);
          z0 *= len;
          z1 *= len;
          z2 *= len;
          let x0 = upy * z2 - upz * z1;
          let x1 = upz * z0 - upx * z2;
          let x2 = upx * z1 - upy * z0;
          len = 1 / sqrt$2(x0 * x0 + x1 * x1 + x2 * x2);
          x0 *= len;
          x1 *= len;
          x2 *= len;
          const y0 = z1 * x2 - z2 * x1;
          const y1 = z2 * x0 - z0 * x2;
          const y2 = z0 * x1 - z1 * x0;
          out.m00 = x0;
          out.m01 = y0;
          out.m02 = z0;
          out.m03 = 0;
          out.m04 = x1;
          out.m05 = y1;
          out.m06 = z1;
          out.m07 = 0;
          out.m08 = x2;
          out.m09 = y2;
          out.m10 = z2;
          out.m11 = 0;
          out.m12 = -(x0 * eyex + x1 * eyey + x2 * eyez);
          out.m13 = -(y0 * eyex + y1 * eyey + y2 * eyez);
          out.m14 = -(z0 * eyex + z1 * eyey + z2 * eyez);
          out.m15 = 1;
          return out;
        }
        static inverseTranspose(out, a) {
          const a00 = a.m00;
          const a01 = a.m01;
          const a02 = a.m02;
          const a03 = a.m03;
          const a10 = a.m04;
          const a11 = a.m05;
          const a12 = a.m06;
          const a13 = a.m07;
          const a20 = a.m08;
          const a21 = a.m09;
          const a22 = a.m10;
          const a23 = a.m11;
          const a30 = a.m12;
          const a31 = a.m13;
          const a32 = a.m14;
          const a33 = a.m15;
          const b00 = a00 * a11 - a01 * a10;
          const b01 = a00 * a12 - a02 * a10;
          const b02 = a00 * a13 - a03 * a10;
          const b03 = a01 * a12 - a02 * a11;
          const b04 = a01 * a13 - a03 * a11;
          const b05 = a02 * a13 - a03 * a12;
          const b06 = a20 * a31 - a21 * a30;
          const b07 = a20 * a32 - a22 * a30;
          const b08 = a20 * a33 - a23 * a30;
          const b09 = a21 * a32 - a22 * a31;
          const b10 = a21 * a33 - a23 * a31;
          const b11 = a22 * a33 - a23 * a32;
          let det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
          if (!det) {
            return null;
          }
          det = 1.0 / det;
          out.m00 = (a11 * b11 - a12 * b10 + a13 * b09) * det;
          out.m01 = (a12 * b08 - a10 * b11 - a13 * b07) * det;
          out.m02 = (a10 * b10 - a11 * b08 + a13 * b06) * det;
          out.m03 = 0;
          out.m04 = (a02 * b10 - a01 * b11 - a03 * b09) * det;
          out.m05 = (a00 * b11 - a02 * b08 + a03 * b07) * det;
          out.m06 = (a01 * b08 - a00 * b10 - a03 * b06) * det;
          out.m07 = 0;
          out.m08 = (a31 * b05 - a32 * b04 + a33 * b03) * det;
          out.m09 = (a32 * b02 - a30 * b05 - a33 * b01) * det;
          out.m10 = (a30 * b04 - a31 * b02 + a33 * b00) * det;
          out.m11 = 0;
          out.m12 = 0;
          out.m13 = 0;
          out.m14 = 0;
          out.m15 = 1;
          return out;
        }
        static toArray(out, m, ofs = 0) {
          out[ofs + 0] = m.m00;
          out[ofs + 1] = m.m01;
          out[ofs + 2] = m.m02;
          out[ofs + 3] = m.m03;
          out[ofs + 4] = m.m04;
          out[ofs + 5] = m.m05;
          out[ofs + 6] = m.m06;
          out[ofs + 7] = m.m07;
          out[ofs + 8] = m.m08;
          out[ofs + 9] = m.m09;
          out[ofs + 10] = m.m10;
          out[ofs + 11] = m.m11;
          out[ofs + 12] = m.m12;
          out[ofs + 13] = m.m13;
          out[ofs + 14] = m.m14;
          out[ofs + 15] = m.m15;
          return out;
        }
        static fromArray(out, arr, ofs = 0) {
          out.m00 = arr[ofs + 0];
          out.m01 = arr[ofs + 1];
          out.m02 = arr[ofs + 2];
          out.m03 = arr[ofs + 3];
          out.m04 = arr[ofs + 4];
          out.m05 = arr[ofs + 5];
          out.m06 = arr[ofs + 6];
          out.m07 = arr[ofs + 7];
          out.m08 = arr[ofs + 8];
          out.m09 = arr[ofs + 9];
          out.m10 = arr[ofs + 10];
          out.m11 = arr[ofs + 11];
          out.m12 = arr[ofs + 12];
          out.m13 = arr[ofs + 13];
          out.m14 = arr[ofs + 14];
          out.m15 = arr[ofs + 15];
          return out;
        }
        static add(out, a, b) {
          out.m00 = a.m00 + b.m00;
          out.m01 = a.m01 + b.m01;
          out.m02 = a.m02 + b.m02;
          out.m03 = a.m03 + b.m03;
          out.m04 = a.m04 + b.m04;
          out.m05 = a.m05 + b.m05;
          out.m06 = a.m06 + b.m06;
          out.m07 = a.m07 + b.m07;
          out.m08 = a.m08 + b.m08;
          out.m09 = a.m09 + b.m09;
          out.m10 = a.m10 + b.m10;
          out.m11 = a.m11 + b.m11;
          out.m12 = a.m12 + b.m12;
          out.m13 = a.m13 + b.m13;
          out.m14 = a.m14 + b.m14;
          out.m15 = a.m15 + b.m15;
          return out;
        }
        static subtract(out, a, b) {
          out.m00 = a.m00 - b.m00;
          out.m01 = a.m01 - b.m01;
          out.m02 = a.m02 - b.m02;
          out.m03 = a.m03 - b.m03;
          out.m04 = a.m04 - b.m04;
          out.m05 = a.m05 - b.m05;
          out.m06 = a.m06 - b.m06;
          out.m07 = a.m07 - b.m07;
          out.m08 = a.m08 - b.m08;
          out.m09 = a.m09 - b.m09;
          out.m10 = a.m10 - b.m10;
          out.m11 = a.m11 - b.m11;
          out.m12 = a.m12 - b.m12;
          out.m13 = a.m13 - b.m13;
          out.m14 = a.m14 - b.m14;
          out.m15 = a.m15 - b.m15;
          return out;
        }
        static multiplyScalar(out, a, b) {
          out.m00 = a.m00 * b;
          out.m01 = a.m01 * b;
          out.m02 = a.m02 * b;
          out.m03 = a.m03 * b;
          out.m04 = a.m04 * b;
          out.m05 = a.m05 * b;
          out.m06 = a.m06 * b;
          out.m07 = a.m07 * b;
          out.m08 = a.m08 * b;
          out.m09 = a.m09 * b;
          out.m10 = a.m10 * b;
          out.m11 = a.m11 * b;
          out.m12 = a.m12 * b;
          out.m13 = a.m13 * b;
          out.m14 = a.m14 * b;
          out.m15 = a.m15 * b;
          return out;
        }
        static multiplyScalarAndAdd(out, a, b, scale) {
          out.m00 = a.m00 + b.m00 * scale;
          out.m01 = a.m01 + b.m01 * scale;
          out.m02 = a.m02 + b.m02 * scale;
          out.m03 = a.m03 + b.m03 * scale;
          out.m04 = a.m04 + b.m04 * scale;
          out.m05 = a.m05 + b.m05 * scale;
          out.m06 = a.m06 + b.m06 * scale;
          out.m07 = a.m07 + b.m07 * scale;
          out.m08 = a.m08 + b.m08 * scale;
          out.m09 = a.m09 + b.m09 * scale;
          out.m10 = a.m10 + b.m10 * scale;
          out.m11 = a.m11 + b.m11 * scale;
          out.m12 = a.m12 + b.m12 * scale;
          out.m13 = a.m13 + b.m13 * scale;
          out.m14 = a.m14 + b.m14 * scale;
          out.m15 = a.m15 + b.m15 * scale;
          return out;
        }
        static strictEquals(a, b) {
          return a.m00 === b.m00 && a.m01 === b.m01 && a.m02 === b.m02 && a.m03 === b.m03 && a.m04 === b.m04 && a.m05 === b.m05 && a.m06 === b.m06 && a.m07 === b.m07 && a.m08 === b.m08 && a.m09 === b.m09 && a.m10 === b.m10 && a.m11 === b.m11 && a.m12 === b.m12 && a.m13 === b.m13 && a.m14 === b.m14 && a.m15 === b.m15;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          return abs$2(a.m00 - b.m00) <= epsilon * max$6(1.0, abs$2(a.m00), abs$2(b.m00)) && abs$2(a.m01 - b.m01) <= epsilon * max$6(1.0, abs$2(a.m01), abs$2(b.m01)) && abs$2(a.m02 - b.m02) <= epsilon * max$6(1.0, abs$2(a.m02), abs$2(b.m02)) && abs$2(a.m03 - b.m03) <= epsilon * max$6(1.0, abs$2(a.m03), abs$2(b.m03)) && abs$2(a.m04 - b.m04) <= epsilon * max$6(1.0, abs$2(a.m04), abs$2(b.m04)) && abs$2(a.m05 - b.m05) <= epsilon * max$6(1.0, abs$2(a.m05), abs$2(b.m05)) && abs$2(a.m06 - b.m06) <= epsilon * max$6(1.0, abs$2(a.m06), abs$2(b.m06)) && abs$2(a.m07 - b.m07) <= epsilon * max$6(1.0, abs$2(a.m07), abs$2(b.m07)) && abs$2(a.m08 - b.m08) <= epsilon * max$6(1.0, abs$2(a.m08), abs$2(b.m08)) && abs$2(a.m09 - b.m09) <= epsilon * max$6(1.0, abs$2(a.m09), abs$2(b.m09)) && abs$2(a.m10 - b.m10) <= epsilon * max$6(1.0, abs$2(a.m10), abs$2(b.m10)) && abs$2(a.m11 - b.m11) <= epsilon * max$6(1.0, abs$2(a.m11), abs$2(b.m11)) && abs$2(a.m12 - b.m12) <= epsilon * max$6(1.0, abs$2(a.m12), abs$2(b.m12)) && abs$2(a.m13 - b.m13) <= epsilon * max$6(1.0, abs$2(a.m13), abs$2(b.m13)) && abs$2(a.m14 - b.m14) <= epsilon * max$6(1.0, abs$2(a.m14), abs$2(b.m14)) && abs$2(a.m15 - b.m15) <= epsilon * max$6(1.0, abs$2(a.m15), abs$2(b.m15));
        }
        constructor(m00 = 1, m01 = 0, m02 = 0, m03 = 0, m04 = 0, m05 = 1, m06 = 0, m07 = 0, m08 = 0, m09 = 0, m10 = 1, m11 = 0, m12 = 0, m13 = 0, m14 = 0, m15 = 1) {
          super();
          const self = this;
          if (typeof m00 === 'object') {
            self.m00 = m00.m00;
            this.m01 = m00.m01;
            this.m02 = m00.m02;
            this.m03 = m00.m03;
            self.m04 = m00.m04;
            this.m05 = m00.m05;
            this.m06 = m00.m06;
            this.m07 = m00.m07;
            self.m08 = m00.m08;
            this.m09 = m00.m09;
            this.m10 = m00.m10;
            this.m11 = m00.m11;
            self.m12 = m00.m12;
            this.m13 = m00.m13;
            this.m14 = m00.m14;
            this.m15 = m00.m15;
          } else {
            self.m00 = m00;
            this.m01 = m01;
            this.m02 = m02;
            this.m03 = m03;
            self.m04 = m04;
            this.m05 = m05;
            this.m06 = m06;
            this.m07 = m07;
            self.m08 = m08;
            this.m09 = m09;
            this.m10 = m10;
            this.m11 = m11;
            self.m12 = m12;
            this.m13 = m13;
            this.m14 = m14;
            this.m15 = m15;
          }
        }
        clone() {
          return new Mat4(this.m00, this.m01, this.m02, this.m03, this.m04, this.m05, this.m06, this.m07, this.m08, this.m09, this.m10, this.m11, this.m12, this.m13, this.m14, this.m15);
        }
        set(m00 = 1, m01 = 0, m02 = 0, m03 = 0, m04 = 0, m05 = 1, m06 = 0, m07 = 0, m08 = 0, m09 = 0, m10 = 1, m11 = 0, m12 = 0, m13 = 0, m14 = 0, m15 = 1) {
          const self = this;
          if (typeof m00 === 'object') {
            self.m01 = m00.m01;
            self.m02 = m00.m02;
            self.m03 = m00.m03;
            self.m04 = m00.m04;
            self.m05 = m00.m05;
            self.m06 = m00.m06;
            self.m07 = m00.m07;
            self.m08 = m00.m08;
            self.m09 = m00.m09;
            self.m10 = m00.m10;
            self.m11 = m00.m11;
            self.m12 = m00.m12;
            self.m13 = m00.m13;
            self.m14 = m00.m14;
            self.m15 = m00.m15;
            self.m00 = m00.m00;
          } else {
            self.m01 = m01;
            self.m02 = m02;
            self.m03 = m03;
            self.m04 = m04;
            self.m05 = m05;
            self.m06 = m06;
            self.m07 = m07;
            self.m08 = m08;
            self.m09 = m09;
            self.m10 = m10;
            self.m11 = m11;
            self.m12 = m12;
            self.m13 = m13;
            self.m14 = m14;
            self.m15 = m15;
            self.m00 = m00;
          }
          return self;
        }
        equals(other, epsilon = EPSILON$2) {
          const inf = Infinity;
          const self = this;
          const m00 = self.m00;
          const m01 = self.m01;
          const m02 = self.m02;
          const m03 = self.m03;
          const m04 = self.m04;
          const m05 = self.m05;
          const m06 = self.m06;
          const m07 = self.m07;
          const m08 = self.m08;
          const m09 = self.m09;
          const m10 = self.m10;
          const m11 = self.m11;
          const m12 = self.m12;
          const m13 = self.m13;
          const m14 = self.m14;
          const m15 = self.m15;
          const hasInf = abs$2(m00) === inf || abs$2(m01) === inf || abs$2(m02) === inf || abs$2(m03) === inf || abs$2(m04) === inf || abs$2(m05) === inf || abs$2(m06) === inf || abs$2(m07) === inf || abs$2(m08) === inf || abs$2(m09) === inf || abs$2(m10) === inf || abs$2(m11) === inf || abs$2(m12) === inf || abs$2(m13) === inf || abs$2(m14) === inf || abs$2(m15) === inf;
          return !hasInf && abs$2(m00 - other.m00) <= epsilon * max$6(1.0, abs$2(m00), abs$2(other.m00)) && abs$2(m01 - other.m01) <= epsilon * max$6(1.0, abs$2(m01), abs$2(other.m01)) && abs$2(m02 - other.m02) <= epsilon * max$6(1.0, abs$2(m02), abs$2(other.m02)) && abs$2(m03 - other.m03) <= epsilon * max$6(1.0, abs$2(m03), abs$2(other.m03)) && abs$2(m04 - other.m04) <= epsilon * max$6(1.0, abs$2(m04), abs$2(other.m04)) && abs$2(m05 - other.m05) <= epsilon * max$6(1.0, abs$2(m05), abs$2(other.m05)) && abs$2(m06 - other.m06) <= epsilon * max$6(1.0, abs$2(m06), abs$2(other.m06)) && abs$2(m07 - other.m07) <= epsilon * max$6(1.0, abs$2(m07), abs$2(other.m07)) && abs$2(m08 - other.m08) <= epsilon * max$6(1.0, abs$2(m08), abs$2(other.m08)) && abs$2(m09 - other.m09) <= epsilon * max$6(1.0, abs$2(m09), abs$2(other.m09)) && abs$2(m10 - other.m10) <= epsilon * max$6(1.0, abs$2(m10), abs$2(other.m10)) && abs$2(m11 - other.m11) <= epsilon * max$6(1.0, abs$2(m11), abs$2(other.m11)) && abs$2(m12 - other.m12) <= epsilon * max$6(1.0, abs$2(m12), abs$2(other.m12)) && abs$2(m13 - other.m13) <= epsilon * max$6(1.0, abs$2(m13), abs$2(other.m13)) && abs$2(m14 - other.m14) <= epsilon * max$6(1.0, abs$2(m14), abs$2(other.m14)) && abs$2(m15 - other.m15) <= epsilon * max$6(1.0, abs$2(m15), abs$2(other.m15));
        }
        strictEquals(other) {
          const self = this;
          return self.m00 === other.m00 && self.m01 === other.m01 && self.m02 === other.m02 && self.m03 === other.m03 && self.m04 === other.m04 && self.m05 === other.m05 && self.m06 === other.m06 && self.m07 === other.m07 && self.m08 === other.m08 && self.m09 === other.m09 && self.m10 === other.m10 && self.m11 === other.m11 && self.m12 === other.m12 && self.m13 === other.m13 && self.m14 === other.m14 && self.m15 === other.m15;
        }
        toString() {
          return `[\n${this.m00}, ${this.m01}, ${this.m02}, ${this.m03},\n${this.m04}, ${this.m05}, ${this.m06}, ${this.m07},\n${this.m08}, ${this.m09}, ${this.m10}, ${this.m11},\n${this.m12}, ${this.m13}, ${this.m14}, ${this.m15}\n` + ']';
        }
        identity() {
          return Mat4.identity(this);
        }
        zero() {
          return Mat4.zero(this);
        }
        transpose() {
          const self = this;
          const a01 = self.m01;
          const a02 = self.m02;
          const a03 = self.m03;
          const a12 = self.m06;
          const a13 = self.m07;
          const a23 = self.m11;
          self.m01 = self.m04;
          self.m02 = self.m08;
          self.m03 = self.m12;
          self.m04 = a01;
          self.m06 = self.m09;
          self.m07 = self.m13;
          self.m08 = a02;
          self.m09 = a12;
          self.m11 = self.m14;
          self.m12 = a03;
          self.m13 = a13;
          self.m14 = a23;
          return self;
        }
        invert() {
          const self = this;
          const a00 = self.m00;
          const a01 = self.m01;
          const a02 = self.m02;
          const a03 = self.m03;
          const a10 = self.m04;
          const a11 = self.m05;
          const a12 = self.m06;
          const a13 = self.m07;
          const a20 = self.m08;
          const a21 = self.m09;
          const a22 = self.m10;
          const a23 = self.m11;
          const a30 = self.m12;
          const a31 = self.m13;
          const a32 = self.m14;
          const a33 = self.m15;
          const b00 = a00 * a11 - a01 * a10;
          const b01 = a00 * a12 - a02 * a10;
          const b02 = a00 * a13 - a03 * a10;
          const b03 = a01 * a12 - a02 * a11;
          const b04 = a01 * a13 - a03 * a11;
          const b05 = a02 * a13 - a03 * a12;
          const b06 = a20 * a31 - a21 * a30;
          const b07 = a20 * a32 - a22 * a30;
          const b08 = a20 * a33 - a23 * a30;
          const b09 = a21 * a32 - a22 * a31;
          const b10 = a21 * a33 - a23 * a31;
          const b11 = a22 * a33 - a23 * a32;
          let det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
          if (det === 0) {
            self.set(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
            return self;
          }
          det = 1.0 / det;
          self.m00 = (a11 * b11 - a12 * b10 + a13 * b09) * det;
          self.m01 = (a02 * b10 - a01 * b11 - a03 * b09) * det;
          self.m02 = (a31 * b05 - a32 * b04 + a33 * b03) * det;
          self.m03 = (a22 * b04 - a21 * b05 - a23 * b03) * det;
          self.m04 = (a12 * b08 - a10 * b11 - a13 * b07) * det;
          self.m05 = (a00 * b11 - a02 * b08 + a03 * b07) * det;
          self.m06 = (a32 * b02 - a30 * b05 - a33 * b01) * det;
          self.m07 = (a20 * b05 - a22 * b02 + a23 * b01) * det;
          self.m08 = (a10 * b10 - a11 * b08 + a13 * b06) * det;
          self.m09 = (a01 * b08 - a00 * b10 - a03 * b06) * det;
          self.m10 = (a30 * b04 - a31 * b02 + a33 * b00) * det;
          self.m11 = (a21 * b02 - a20 * b04 - a23 * b00) * det;
          self.m12 = (a11 * b07 - a10 * b09 - a12 * b06) * det;
          self.m13 = (a00 * b09 - a01 * b07 + a02 * b06) * det;
          self.m14 = (a31 * b01 - a30 * b03 - a32 * b00) * det;
          self.m15 = (a20 * b03 - a21 * b01 + a22 * b00) * det;
          return self;
        }
        determinant() {
          const self = this;
          const a00 = self.m00;
          const a01 = self.m01;
          const a02 = self.m02;
          const a03 = self.m03;
          const a10 = self.m04;
          const a11 = self.m05;
          const a12 = self.m06;
          const a13 = self.m07;
          const a20 = self.m08;
          const a21 = self.m09;
          const a22 = self.m10;
          const a23 = self.m11;
          const a30 = self.m12;
          const a31 = self.m13;
          const a32 = self.m14;
          const a33 = self.m15;
          const b00 = a00 * a11 - a01 * a10;
          const b01 = a00 * a12 - a02 * a10;
          const b02 = a00 * a13 - a03 * a10;
          const b03 = a01 * a12 - a02 * a11;
          const b04 = a01 * a13 - a03 * a11;
          const b05 = a02 * a13 - a03 * a12;
          const b06 = a20 * a31 - a21 * a30;
          const b07 = a20 * a32 - a22 * a30;
          const b08 = a20 * a33 - a23 * a30;
          const b09 = a21 * a32 - a22 * a31;
          const b10 = a21 * a33 - a23 * a31;
          const b11 = a22 * a33 - a23 * a32;
          return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
        }
        add(mat) {
          const self = this;
          self.m00 += mat.m00;
          self.m01 += mat.m01;
          self.m02 += mat.m02;
          self.m03 += mat.m03;
          self.m04 += mat.m04;
          self.m05 += mat.m05;
          self.m06 += mat.m06;
          self.m07 += mat.m07;
          self.m08 += mat.m08;
          self.m09 += mat.m09;
          self.m10 += mat.m10;
          self.m11 += mat.m11;
          self.m12 += mat.m12;
          self.m13 += mat.m13;
          self.m14 += mat.m14;
          self.m15 += mat.m15;
          return self;
        }
        subtract(mat) {
          const self = this;
          self.m00 -= mat.m00;
          self.m01 -= mat.m01;
          self.m02 -= mat.m02;
          self.m03 -= mat.m03;
          self.m04 -= mat.m04;
          self.m05 -= mat.m05;
          self.m06 -= mat.m06;
          self.m07 -= mat.m07;
          self.m08 -= mat.m08;
          self.m09 -= mat.m09;
          self.m10 -= mat.m10;
          self.m11 -= mat.m11;
          self.m12 -= mat.m12;
          self.m13 -= mat.m13;
          self.m14 -= mat.m14;
          self.m15 -= mat.m15;
          return self;
        }
        multiply(mat) {
          return Mat4.multiply(this, this, mat);
        }
        multiplyScalar(scalar) {
          const self = this;
          self.m00 *= scalar;
          self.m01 *= scalar;
          self.m02 *= scalar;
          self.m03 *= scalar;
          self.m04 *= scalar;
          self.m05 *= scalar;
          self.m06 *= scalar;
          self.m07 *= scalar;
          self.m08 *= scalar;
          self.m09 *= scalar;
          self.m10 *= scalar;
          self.m11 *= scalar;
          self.m12 *= scalar;
          self.m13 *= scalar;
          self.m14 *= scalar;
          self.m15 *= scalar;
          return self;
        }
        translate(vec) {
          this.m12 += vec.x;
          this.m13 += vec.y;
          this.m14 += vec.z;
          return this;
        }
        transform(vec) {
          const {
            x,
            y,
            z
          } = vec;
          const self = this;
          const a00 = self.m00;
          const a01 = self.m01;
          const a02 = self.m02;
          const a03 = self.m03;
          const a10 = self.m04;
          const a11 = self.m05;
          const a12 = self.m06;
          const a13 = self.m07;
          const a20 = self.m08;
          const a21 = self.m09;
          const a22 = self.m10;
          const a23 = self.m11;
          self.m12 = a00 * x + a10 * y + a20 * z + self.m12;
          self.m13 = a01 * x + a11 * y + a21 * z + self.m13;
          self.m14 = a02 * x + a12 * y + a22 * z + self.m14;
          self.m15 = a03 * x + a13 * y + a23 * z + self.m15;
          return self;
        }
        scale(vec) {
          const {
            x,
            y,
            z
          } = vec;
          const self = this;
          self.m00 *= x;
          self.m01 *= x;
          self.m02 *= x;
          self.m03 *= x;
          self.m04 *= y;
          self.m05 *= y;
          self.m06 *= y;
          self.m07 *= y;
          self.m08 *= z;
          self.m09 *= z;
          self.m10 *= z;
          self.m11 *= z;
          return self;
        }
        rotate(rad, axis) {
          let x = axis.x;
          let y = axis.y;
          let z = axis.z;
          let len = sqrt$2(x * x + y * y + z * z);
          if (abs$2(len) < EPSILON$2) {
            return null;
          }
          len = 1 / len;
          x *= len;
          y *= len;
          z *= len;
          const s = sin$3(rad);
          const c = cos$4(rad);
          const t = 1 - c;
          const self = this;
          const a00 = self.m00;
          const a01 = self.m01;
          const a02 = self.m02;
          const a03 = self.m03;
          const a10 = self.m04;
          const a11 = self.m05;
          const a12 = self.m06;
          const a13 = self.m07;
          const a20 = self.m08;
          const a21 = self.m09;
          const a22 = self.m10;
          const a23 = self.m11;
          const b00 = x * x * t + c;
          const b01 = y * x * t + z * s;
          const b02 = z * x * t - y * s;
          const b10 = x * y * t - z * s;
          const b11 = y * y * t + c;
          const b12 = z * y * t + x * s;
          const b20 = x * z * t + y * s;
          const b21 = y * z * t - x * s;
          const b22 = z * z * t + c;
          self.m00 = a00 * b00 + a10 * b01 + a20 * b02;
          self.m01 = a01 * b00 + a11 * b01 + a21 * b02;
          self.m02 = a02 * b00 + a12 * b01 + a22 * b02;
          self.m03 = a03 * b00 + a13 * b01 + a23 * b02;
          self.m04 = a00 * b10 + a10 * b11 + a20 * b12;
          self.m05 = a01 * b10 + a11 * b11 + a21 * b12;
          self.m06 = a02 * b10 + a12 * b11 + a22 * b12;
          self.m07 = a03 * b10 + a13 * b11 + a23 * b12;
          self.m08 = a00 * b20 + a10 * b21 + a20 * b22;
          self.m09 = a01 * b20 + a11 * b21 + a21 * b22;
          self.m10 = a02 * b20 + a12 * b21 + a22 * b22;
          self.m11 = a03 * b20 + a13 * b21 + a23 * b22;
          return self;
        }
        getTranslation(out) {
          out.x = this.m12;
          out.y = this.m13;
          out.z = this.m14;
          return out;
        }
        getScale(out) {
          const self = this;
          const m00 = m3_1.m00 = self.m00;
          const m01 = m3_1.m01 = self.m01;
          const m02 = m3_1.m02 = self.m02;
          const m04 = m3_1.m03 = self.m04;
          const m05 = m3_1.m04 = self.m05;
          const m06 = m3_1.m05 = self.m06;
          const m08 = m3_1.m06 = self.m08;
          const m09 = m3_1.m07 = self.m09;
          const m10 = m3_1.m08 = self.m10;
          out.x = sqrt$2(m00 * m00 + m01 * m01 + m02 * m02);
          out.y = sqrt$2(m04 * m04 + m05 * m05 + m06 * m06);
          out.z = sqrt$2(m08 * m08 + m09 * m09 + m10 * m10);
          if (Mat3.determinant(m3_1) < 0) {
            out.x *= -1;
          }
          return out;
        }
        getRotation(out) {
          const self = this;
          const sx = Vec3.set(v3_1$1, self.m00, self.m01, self.m02).length();
          const sy = Vec3.set(v3_1$1, self.m04, self.m05, self.m06).length();
          const sz = Vec3.set(v3_1$1, self.m08, self.m09, self.m10).length();
          m3_1.m00 = self.m00 / sx;
          m3_1.m01 = self.m01 / sx;
          m3_1.m02 = self.m02 / sx;
          m3_1.m03 = self.m04 / sy;
          m3_1.m04 = self.m05 / sy;
          m3_1.m05 = self.m06 / sy;
          m3_1.m06 = self.m08 / sz;
          m3_1.m07 = self.m09 / sz;
          m3_1.m08 = self.m10 / sz;
          const det = Mat3.determinant(m3_1);
          if (det < 0) {
            m3_1.m00 *= -1;
            m3_1.m01 *= -1;
            m3_1.m02 *= -1;
          }
          return Quat.fromMat3(out, m3_1);
        }
        fromRTS(q, v, s) {
          return Mat4.fromSRT(this, q, v, s);
        }
        fromSRT(q, v, s) {
          return Mat4.fromSRT(this, q, v, s);
        }
        fromQuat(q) {
          return Mat4.fromQuat(this, q);
        }
      } exports("Mat4", Mat4);
      _class$2t = Mat4;
      Mat4.IDENTITY = Object.freeze(new _class$2t());
      const v3_1$1 = new Vec3();
      const m3_1 = new Mat3();
      CCClass.fastDefine('cc.Mat4', Mat4, {
        m00: 1,
        m01: 0,
        m02: 0,
        m03: 0,
        m04: 0,
        m05: 1,
        m06: 0,
        m07: 0,
        m08: 0,
        m09: 0,
        m10: 1,
        m11: 0,
        m12: 0,
        m13: 0,
        m14: 0,
        m15: 1
      });
      legacyCC.Mat4 = Mat4;
      function mat4(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
        return new Mat4(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
      }
      legacyCC.mat4 = mat4;

      var _class$2s;
      const abs$1 = Math.abs;
      const max$5 = Math.max;
      const min$4 = Math.min;
      const PI$2 = Math.PI;
      const acos$2 = Math.acos;
      const sin$2 = Math.sin;
      const cos$3 = Math.cos;
      const sqrt$1 = Math.sqrt;
      const atan2$1 = Math.atan2;
      const ceil$2 = Math.ceil;
      const floor = Math.floor;
      const round = Math.round;
      class Vec2 extends ValueType {
        static clone(a) {
          return new Vec2(a.x, a.y);
        }
        static copy(out, a) {
          out.x = a.x;
          out.y = a.y;
          return out;
        }
        static set(out, x, y) {
          out.x = x;
          out.y = y;
          return out;
        }
        static add(out, a, b) {
          out.x = a.x + b.x;
          out.y = a.y + b.y;
          return out;
        }
        static subtract(out, a, b) {
          out.x = a.x - b.x;
          out.y = a.y - b.y;
          return out;
        }
        static multiply(out, a, b) {
          out.x = a.x * b.x;
          out.y = a.y * b.y;
          return out;
        }
        static divide(out, a, b) {
          out.x = a.x / b.x;
          out.y = a.y / b.y;
          return out;
        }
        static ceil(out, a) {
          out.x = ceil$2(a.x);
          out.y = ceil$2(a.y);
          return out;
        }
        static floor(out, a) {
          out.x = floor(a.x);
          out.y = floor(a.y);
          return out;
        }
        static min(out, a, b) {
          out.x = min$4(a.x, b.x);
          out.y = min$4(a.y, b.y);
          return out;
        }
        static max(out, a, b) {
          out.x = max$5(a.x, b.x);
          out.y = max$5(a.y, b.y);
          return out;
        }
        static round(out, a) {
          out.x = round(a.x);
          out.y = round(a.y);
          return out;
        }
        static multiplyScalar(out, a, b) {
          out.x = a.x * b;
          out.y = a.y * b;
          return out;
        }
        static scaleAndAdd(out, a, b, scale) {
          out.x = a.x + b.x * scale;
          out.y = a.y + b.y * scale;
          return out;
        }
        static distance(a, b) {
          const x = b.x - a.x;
          const y = b.y - a.y;
          return sqrt$1(x * x + y * y);
        }
        static squaredDistance(a, b) {
          const x = b.x - a.x;
          const y = b.y - a.y;
          return x * x + y * y;
        }
        static len(a) {
          const x = a.x;
          const y = a.y;
          return sqrt$1(x * x + y * y);
        }
        static lengthSqr(a) {
          const x = a.x;
          const y = a.y;
          return x * x + y * y;
        }
        static negate(out, a) {
          out.x = -a.x;
          out.y = -a.y;
          return out;
        }
        static inverse(out, a) {
          out.x = 1.0 / a.x;
          out.y = 1.0 / a.y;
          return out;
        }
        static inverseSafe(out, a) {
          const x = a.x;
          const y = a.y;
          if (abs$1(x) < EPSILON$2) {
            out.x = 0;
          } else {
            out.x = 1.0 / x;
          }
          if (abs$1(y) < EPSILON$2) {
            out.y = 0;
          } else {
            out.y = 1.0 / y;
          }
          return out;
        }
        static normalize(out, a) {
          const x = a.x;
          const y = a.y;
          let len = x * x + y * y;
          if (len > 0) {
            len = 1 / sqrt$1(len);
            out.x = x * len;
            out.y = y * len;
          } else {
            out.x = 0;
            out.y = 0;
          }
          return out;
        }
        static dot(a, b) {
          return a.x * b.x + a.y * b.y;
        }
        static cross(out, a, b) {
          if (out instanceof Vec3) {
            out.x = out.y = 0;
            out.z = a.x * b.y - a.y * b.x;
            return out;
          } else {
            return out.x * a.y - out.y * a.x;
          }
        }
        static lerp(out, a, b, t) {
          const x = a.x;
          const y = a.y;
          out.x = x + t * (b.x - x);
          out.y = y + t * (b.y - y);
          return out;
        }
        static random(out, scale) {
          scale = scale || 1.0;
          const r = random() * 2.0 * PI$2;
          out.x = cos$3(r) * scale;
          out.y = sin$2(r) * scale;
          return out;
        }
        static transformMat3(out, a, m) {
          const x = a.x;
          const y = a.y;
          out.x = m.m00 * x + m.m03 * y + m.m06;
          out.y = m.m01 * x + m.m04 * y + m.m07;
          return out;
        }
        static transformMat4(out, a, m) {
          const x = a.x;
          const y = a.y;
          out.x = m.m00 * x + m.m04 * y + m.m12;
          out.y = m.m01 * x + m.m05 * y + m.m13;
          return out;
        }
        static str(a) {
          return `Vec2(${a.x}, ${a.y})`;
        }
        static toArray(out, v, ofs = 0) {
          out[ofs + 0] = v.x;
          out[ofs + 1] = v.y;
          return out;
        }
        static fromArray(out, arr, ofs = 0) {
          out.x = arr[ofs + 0];
          out.y = arr[ofs + 1];
          return out;
        }
        static strictEquals(a, b) {
          return a.x === b.x && a.y === b.y;
        }
        static equals(a, b, epsilon = EPSILON$2) {
          return abs$1(a.x - b.x) <= epsilon * max$5(1.0, abs$1(a.x), abs$1(b.x)) && abs$1(a.y - b.y) <= epsilon * max$5(1.0, abs$1(a.y), abs$1(b.y));
        }
        static angle(a, b) {
          const magSqr1 = a.x * a.x + a.y * a.y;
          const magSqr2 = b.x * b.x + b.y * b.y;
          if (magSqr1 === 0 || magSqr2 === 0) {
            return 0.0;
          }
          const dot = a.x * b.x + a.y * b.y;
          let cosine = dot / sqrt$1(magSqr1 * magSqr2);
          cosine = clamp$1(cosine, -1.0, 1.0);
          return acos$2(cosine);
        }
        constructor(x, y) {
          super();
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
          } else {
            this.x = x || 0;
            this.y = y || 0;
          }
        }
        clone() {
          return new Vec2(this.x, this.y);
        }
        set(x, y) {
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
          } else {
            this.x = x || 0;
            this.y = y || 0;
          }
          return this;
        }
        equals(other, epsilon = EPSILON$2) {
          return Vec2.equals(this, other, epsilon);
        }
        equals2f(x, y, epsilon = EPSILON$2) {
          return abs$1(this.x - x) <= epsilon * max$5(1.0, abs$1(this.x), abs$1(x)) && abs$1(this.y - y) <= epsilon * max$5(1.0, abs$1(this.y), abs$1(y));
        }
        strictEquals(other) {
          return other && this.x === other.x && this.y === other.y;
        }
        strictEquals2f(x, y) {
          return this.x === x && this.y === y;
        }
        toString() {
          return `(${this.x.toFixed(2)}, ${this.y.toFixed(2)})`;
        }
        lerp(to, ratio) {
          const x = this.x;
          const y = this.y;
          this.x = x + ratio * (to.x - x);
          this.y = y + ratio * (to.y - y);
          return this;
        }
        clampf(minInclusive, maxInclusive) {
          this.x = clamp$1(this.x, minInclusive.x, maxInclusive.x);
          this.y = clamp$1(this.y, minInclusive.y, maxInclusive.y);
          return this;
        }
        add(other) {
          this.x += other.x;
          this.y += other.y;
          return this;
        }
        add2f(x, y) {
          this.x += x;
          this.y += y;
          return this;
        }
        subtract(other) {
          this.x -= other.x;
          this.y -= other.y;
          return this;
        }
        subtract2f(x, y) {
          this.x -= x;
          this.y -= y;
          return this;
        }
        multiplyScalar(scalar) {
          if (typeof scalar === 'object') {
            warnID(16359);
          }
          this.x *= scalar;
          this.y *= scalar;
          return this;
        }
        multiply(other) {
          if (typeof other !== 'object') {
            warnID(16360);
          }
          this.x *= other.x;
          this.y *= other.y;
          return this;
        }
        multiply2f(x, y) {
          this.x *= x;
          this.y *= y;
          return this;
        }
        divide(other) {
          this.x /= other.x;
          this.y /= other.y;
          return this;
        }
        divide2f(x, y) {
          this.x /= x;
          this.y /= y;
          return this;
        }
        negative() {
          this.x = -this.x;
          this.y = -this.y;
          return this;
        }
        dot(other) {
          return this.x * other.x + this.y * other.y;
        }
        cross(other) {
          return this.x * other.y - this.y * other.x;
        }
        length() {
          return sqrt$1(this.x * this.x + this.y * this.y);
        }
        lengthSqr() {
          return this.x * this.x + this.y * this.y;
        }
        normalize() {
          const self = this;
          const x = self.x;
          const y = self.y;
          let len = x * x + y * y;
          if (len > 0) {
            len = 1 / sqrt$1(len);
            self.x *= len;
            self.y *= len;
          }
          return self;
        }
        angle(other) {
          const magSqr1 = this.lengthSqr();
          const magSqr2 = other.lengthSqr();
          if (magSqr1 === 0 || magSqr2 === 0) {
            return 0.0;
          }
          const dot = this.dot(other);
          let cosine = dot / sqrt$1(magSqr1 * magSqr2);
          cosine = clamp$1(cosine, -1.0, 1.0);
          return acos$2(cosine);
        }
        signAngle(other) {
          const cross = this.cross(other);
          const dot = this.dot(other);
          return atan2$1(cross, dot);
        }
        rotate(radians) {
          const x = this.x;
          const y = this.y;
          const s = sin$2(radians);
          const c = cos$3(radians);
          this.x = c * x - s * y;
          this.y = s * x + c * y;
          return this;
        }
        project(other) {
          const scalar = this.dot(other) / other.dot(other);
          this.x = other.x * scalar;
          this.y = other.y * scalar;
          return this;
        }
        transformMat4(matrix) {
          const x = this.x;
          const y = this.y;
          this.x = matrix.m00 * x + matrix.m04 * y + matrix.m12;
          this.y = matrix.m01 * x + matrix.m05 * y + matrix.m13;
          return this;
        }
        toVec3() {
          return new Vec3(this.x, this.y, 0);
        }
      } exports("Vec2", Vec2);
      _class$2s = Vec2;
      Vec2.ZERO = Object.freeze(new _class$2s(0, 0));
      Vec2.ONE = Object.freeze(new _class$2s(1, 1));
      Vec2.NEG_ONE = Object.freeze(new _class$2s(-1, -1));
      Vec2.UNIT_X = Object.freeze(new _class$2s(1, 0));
      Vec2.UNIT_Y = Object.freeze(new _class$2s(0, 1));
      CCClass.fastDefine('cc.Vec2', Vec2, {
        x: 0,
        y: 0
      });
      legacyCC.Vec2 = Vec2;
      function v2$1(x, y) {
        return new Vec2(x, y);
      }
      legacyCC.v2 = v2$1;

      replaceProperty(Vec2, 'Vec2', [{
        name: 'sub',
        newName: 'subtract',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'div',
        newName: 'divide',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'dist',
        newName: 'distance',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'sqrDist',
        newName: 'squaredDistance',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'mag',
        newName: 'len',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'sqrMag',
        newName: 'lengthSqr',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Vec2,
        targetName: 'Vec2'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Vec2,
        targetName: 'Vec2'
      }]);
      replaceProperty(Vec2.prototype, 'Vec2', [{
        name: 'mag',
        newName: 'length',
        target: Vec2.prototype,
        targetName: 'Vec2'
      }, {
        name: 'magSqr',
        newName: 'lengthSqr',
        target: Vec2.prototype,
        targetName: 'Vec2'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Vec2.prototype,
        targetName: 'Vec2'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Vec2.prototype,
        targetName: 'Vec2'
      }]);
      replaceProperty(Vec3, 'Vec3', [{
        name: 'sub',
        newName: 'subtract',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'div',
        newName: 'divide',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'dist',
        newName: 'distance',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'sqrDist',
        newName: 'squaredDistance',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'mag',
        newName: 'len',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'sqrMag',
        newName: 'lengthSqr',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Vec3,
        targetName: 'Vec3'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Vec3,
        targetName: 'Vec3'
      }]);
      replaceProperty(Vec3.prototype, 'Vec3', [{
        name: 'mag',
        newName: 'length',
        target: Vec3.prototype,
        targetName: 'Vec3'
      }, {
        name: 'magSqr',
        newName: 'lengthSqr',
        target: Vec3.prototype,
        targetName: 'Vec3'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Vec3.prototype,
        targetName: 'Vec3'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Vec3.prototype,
        targetName: 'Vec3'
      }]);
      replaceProperty(Vec4, 'Vec4', [{
        name: 'sub',
        newName: 'subtract',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'div',
        newName: 'divide',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'dist',
        newName: 'distance',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'sqrDist',
        newName: 'squaredDistance',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'mag',
        newName: 'len',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'sqrMag',
        newName: 'lengthSqr',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Vec4,
        targetName: 'Vec4'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Vec4,
        targetName: 'Vec4'
      }]);
      replaceProperty(Vec4.prototype, 'Vec4', [{
        name: 'mag',
        newName: 'length',
        target: Vec4.prototype,
        targetName: 'Vec4'
      }, {
        name: 'magSqr',
        newName: 'lengthSqr',
        target: Vec4.prototype,
        targetName: 'Vec4'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Vec4.prototype,
        targetName: 'Vec4'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Vec4.prototype,
        targetName: 'Vec4'
      }]);
      replaceProperty(Quat, 'Quat', [{
        name: 'mag',
        newName: 'len',
        target: Quat,
        targetName: 'Quat'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Quat,
        targetName: 'Quat'
      }, {
        name: 'sqrMag',
        newName: 'lengthSqr',
        target: Quat,
        targetName: 'Quat'
      }, {
        name: 'scale',
        newName: 'multiplyScalar',
        target: Quat,
        targetName: 'Quat'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Quat,
        targetName: 'Quat'
      }]);
      replaceProperty(Quat.prototype, 'Quat', [{
        name: 'scale',
        newName: 'multiplyScalar',
        target: Quat.prototype,
        targetName: 'Quat'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Quat.prototype,
        targetName: 'Quat'
      }]);
      replaceProperty(Color$1, 'Color', [{
        name: 'sub',
        newName: 'subtract',
        target: Color$1,
        targetName: 'Color'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Color$1,
        targetName: 'Color'
      }, {
        name: 'div',
        newName: 'divide',
        target: Color$1,
        targetName: 'Color'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Color$1,
        targetName: 'Color'
      }, {
        name: 'fromHex',
        newName: 'fromHEX',
        customFunction(...args) {
          const arg1 = args[1].toString(16);
          return legacyCC.Color.fromHEX(args[0], arg1);
        }
      }]);
      replaceProperty(Mat3, 'Mat3', [{
        name: 'sub',
        newName: 'subtract',
        target: Mat3,
        targetName: 'Mat3'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Mat3,
        targetName: 'Mat3'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Mat3,
        targetName: 'Mat3'
      }, {
        name: 'transfrom',
        newName: 'transform',
        target: Mat3,
        targetName: 'Mat3'
      }]);
      replaceProperty(Mat3.prototype, 'Mat3', [{
        name: 'sub',
        newName: 'subtract',
        target: Mat3.prototype,
        targetName: 'Mat3'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Mat3.prototype,
        targetName: 'Mat3'
      }, {
        name: 'mulScalar',
        newName: 'multiplyScalar',
        target: Mat3.prototype,
        targetName: 'Mat3'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Mat3.prototype,
        targetName: 'Mat3'
      }]);
      replaceProperty(Mat4, 'Mat4', [{
        name: 'sub',
        newName: 'subtract',
        target: Mat4,
        targetName: 'Mat4'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Mat4,
        targetName: 'Mat4'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Mat4,
        targetName: 'Mat4'
      }]);
      replaceProperty(Mat4.prototype, 'Mat4', [{
        name: 'sub',
        newName: 'subtract',
        target: Mat4.prototype,
        targetName: 'Mat4'
      }, {
        name: 'mul',
        newName: 'multiply',
        target: Mat4.prototype,
        targetName: 'Mat4'
      }, {
        name: 'mulScalar',
        newName: 'multiplyScalar',
        target: Mat4.prototype,
        targetName: 'Mat4'
      }, {
        name: 'exactEquals',
        newName: 'strictEquals',
        target: Mat4.prototype,
        targetName: 'Mat4'
      }]);

      {
        const defineAttr = (proto, name, offset) => {
          Object.defineProperty(proto, name, {
            configurable: true,
            enumerable: true,
            get() {
              return this._data()[offset];
            },
            set(v) {
              this._data()[offset] = v;
            }
          });
        };
        const extendType = (proto, parentProto, typ) => {
          proto._data = function _data() {
            if (!this.__data) {
              this.__data = new Float32Array(this.underlyingData());
            }
            return this.__data;
          };
          Object.setPrototypeOf(proto, parentProto);
          Object.defineProperty(proto, 'type', {
            configurable: true,
            enumerable: true,
            writable: false,
            value: typ
          });
        };
        const inheritCCClass = (ctor, parentCtor) => {
          for (const attrName of ['__cid__', '__classname__']) {
            Object.defineProperty(ctor.prototype, attrName, {
              value: parentCtor.prototype[attrName],
              writable: false,
              enumerable: false,
              configurable: true
            });
          }
          for (const staticKey of ['__attrs__', '__props__', '__values__']) {
            ctor[staticKey] = parentCtor[staticKey];
          }
        };
        extendType(jsb.Mat4.prototype, Mat4.prototype, 5);
        for (let i = 0; i < 16; i++) {
          const numb = `0${i}`;
          defineAttr(jsb.Mat4.prototype, `m${numb.substring(numb.length - 2)}`, i);
        }
        for (let i = 0; i < 9; i++) {
          const numb = `0${i}`;
          defineAttr(jsb.Mat3.prototype, `m${numb.substring(numb.length - 2)}`, i);
        }
        extendType(jsb.Mat3.prototype, Mat3.prototype, 4);
        defineAttr(jsb.Vec2.prototype, 'x', 0);
        defineAttr(jsb.Vec2.prototype, 'y', 1);
        extendType(jsb.Vec2.prototype, Vec2.prototype, 0);
        defineAttr(jsb.Vec3.prototype, 'x', 0);
        defineAttr(jsb.Vec3.prototype, 'y', 1);
        defineAttr(jsb.Vec3.prototype, 'z', 2);
        extendType(jsb.Vec3.prototype, Vec3.prototype, 1);
        defineAttr(jsb.Vec4.prototype, 'x', 0);
        defineAttr(jsb.Vec4.prototype, 'y', 1);
        defineAttr(jsb.Vec4.prototype, 'z', 2);
        defineAttr(jsb.Vec4.prototype, 'w', 3);
        extendType(jsb.Vec4.prototype, Vec4.prototype, 2);
        defineAttr(jsb.Quat.prototype, 'x', 0);
        defineAttr(jsb.Quat.prototype, 'y', 1);
        defineAttr(jsb.Quat.prototype, 'z', 2);
        defineAttr(jsb.Quat.prototype, 'w', 3);
        extendType(jsb.Quat.prototype, Quat.prototype, 3);
        Object.setPrototypeOf(jsb.Color.prototype, Color$1.prototype);
        Object.defineProperty(jsb.Color.prototype, 'type', {
          configurable: true,
          enumerable: true,
          writable: false,
          value: 8
        });
        inheritCCClass(jsb.Vec4, Vec4);
        inheritCCClass(jsb.Vec3, Vec3);
        inheritCCClass(jsb.Vec2, Vec2);
        inheritCCClass(jsb.Mat4, Mat4);
        inheritCCClass(jsb.Mat3, Mat3);
        inheritCCClass(jsb.Color, Color$1);
        inheritCCClass(jsb.Quat, Quat);
      }

      class AffineTransform {
        static identity() {
          return new AffineTransform();
        }
        static clone(affineTransform) {
          return new AffineTransform(affineTransform.a, affineTransform.b, affineTransform.c, affineTransform.d, affineTransform.tx, affineTransform.ty);
        }
        static concat(out, t1, t2) {
          const a = t1.a;
          const b = t1.b;
          const c = t1.c;
          const d = t1.d;
          const tx = t1.tx;
          const ty = t1.ty;
          out.a = a * t2.a + b * t2.c;
          out.b = a * t2.b + b * t2.d;
          out.c = c * t2.a + d * t2.c;
          out.d = c * t2.b + d * t2.d;
          out.tx = tx * t2.a + ty * t2.c + t2.tx;
          out.ty = tx * t2.b + ty * t2.d + t2.ty;
        }
        static invert(out, t) {
          const determinant = 1 / (t.a * t.d - t.b * t.c);
          out.a = determinant * t.d;
          out.b = -determinant * t.b;
          out.c = -determinant * t.c;
          out.d = determinant * t.a;
          out.tx = determinant * (t.c * t.ty - t.d * t.tx);
          out.ty = determinant * (t.b * t.tx - t.a * t.ty);
        }
        static fromMat4(out, mat) {
          out.a = mat.m00;
          out.b = mat.m01;
          out.c = mat.m04;
          out.d = mat.m05;
          out.tx = mat.m12;
          out.ty = mat.m13;
        }
        static transformVec2(out, point, transOrY, t) {
          let x;
          let y;
          if (!t) {
            t = transOrY;
            x = point.x;
            y = point.y;
          } else {
            x = point;
            y = transOrY;
          }
          out.x = t.a * x + t.c * y + t.tx;
          out.y = t.b * x + t.d * y + t.ty;
        }
        static transformSize(out, size, t) {
          out.width = t.a * size.width + t.c * size.height;
          out.height = t.b * size.width + t.d * size.height;
        }
        static transformRect(out, rect, t) {
          const or = rect.x + rect.width;
          const ot = rect.y + rect.height;
          const lbx = t.a * rect.x + t.c * rect.y + t.tx;
          const lby = t.b * rect.x + t.d * rect.y + t.ty;
          const rbx = t.a * or + t.c * rect.y + t.tx;
          const rby = t.b * or + t.d * rect.y + t.ty;
          const ltx = t.a * rect.x + t.c * ot + t.tx;
          const lty = t.b * rect.x + t.d * ot + t.ty;
          const rtx = t.a * or + t.c * ot + t.tx;
          const rty = t.b * or + t.d * ot + t.ty;
          const minX = Math.min(lbx, rbx, ltx, rtx);
          const maxX = Math.max(lbx, rbx, ltx, rtx);
          const minY = Math.min(lby, rby, lty, rty);
          const maxY = Math.max(lby, rby, lty, rty);
          out.x = minX;
          out.y = minY;
          out.width = maxX - minX;
          out.height = maxY - minY;
        }
        static transformObb(out_bl, out_tl, out_tr, out_br, rect, anAffineTransform, flipY = true) {
          const tx = anAffineTransform.a * rect.x + anAffineTransform.c * rect.y + anAffineTransform.tx;
          const ty = anAffineTransform.b * rect.x + anAffineTransform.d * rect.y + anAffineTransform.ty;
          const xa = anAffineTransform.a * rect.width;
          const xb = anAffineTransform.b * rect.width;
          const yc = anAffineTransform.c * rect.height;
          const yd = anAffineTransform.d * rect.height;
          if (flipY) {
            out_tl.x = tx;
            out_tl.y = ty;
            out_tr.x = xa + tx;
            out_tr.y = xb + ty;
            out_bl.x = yc + tx;
            out_bl.y = yd + ty;
            out_br.x = xa + yc + tx;
            out_br.y = xb + yd + ty;
          } else {
            out_bl.x = tx;
            out_bl.y = ty;
            out_br.x = xa + tx;
            out_br.y = xb + ty;
            out_tl.x = yc + tx;
            out_tl.y = yd + ty;
            out_tr.x = xa + yc + tx;
            out_tr.y = xb + yd + ty;
          }
        }
        constructor(a = 1, b = 0, c = 0, d = 1, tx = 0, ty = 0) {
          this.a = a;
          this.b = b;
          this.c = c;
          this.d = d;
          this.tx = tx;
          this.ty = ty;
        }
      } exports("AffineTransform", AffineTransform);
      legacyCC.AffineTransform = AffineTransform;

      var _class$2r;
      let Size$1 = class Size extends ValueType {
        static lerp(out, from, to, ratio) {
          out.width = from.width + (to.width - from.width) * ratio;
          out.height = from.height + (to.height - from.height) * ratio;
          return out;
        }
        static equals(a, b) {
          return a.width === b.width && a.height === b.height;
        }
        set x(val) {
          this.width = val;
        }
        get x() {
          return this.width;
        }
        set y(val) {
          this.height = val;
        }
        get y() {
          return this.height;
        }
        constructor(width, height) {
          super();
          if (typeof width === 'object') {
            this.width = width.width;
            this.height = width.height;
          } else {
            this.width = width || 0;
            this.height = height || 0;
          }
        }
        clone() {
          return new Size(this.width, this.height);
        }
        set(width, height) {
          if (typeof width === 'object') {
            this.height = width.height;
            this.width = width.width;
          } else {
            this.width = width || 0;
            this.height = height || 0;
          }
          return this;
        }
        equals(other) {
          return this.width === other.width && this.height === other.height;
        }
        lerp(to, ratio) {
          this.width += (to.width - this.width) * ratio;
          this.height += (to.height - this.height) * ratio;
          return this;
        }
        toString() {
          return `(${this.width.toFixed(2)}, ${this.height.toFixed(2)})`;
        }
      }; exports("Size", Size$1);
      _class$2r = Size$1;
      Size$1.ZERO = Object.freeze(new _class$2r(0, 0));
      Size$1.ONE = Object.freeze(new _class$2r(1, 1));
      CCClass.fastDefine('cc.Size', Size$1, {
        width: 0,
        height: 0
      });
      function size(width = 0, height = 0) {
        return new Size$1(width, height);
      }
      legacyCC.size = size;
      legacyCC.Size = Size$1;

      const max$4 = Math.max;
      const min$3 = Math.min;
      let Rect$1 = class Rect extends ValueType {
        static fromMinMax(out, v1, v2) {
          const minX = min$3(v1.x, v2.x);
          const minY = min$3(v1.y, v2.y);
          const maxX = max$4(v1.x, v2.x);
          const maxY = max$4(v1.y, v2.y);
          out.x = minX;
          out.y = minY;
          out.width = maxX - minX;
          out.height = maxY - minY;
          return out;
        }
        static lerp(out, from, to, ratio) {
          const x = from.x;
          const y = from.y;
          const w = from.width;
          const h = from.height;
          out.x = x + (to.x - x) * ratio;
          out.y = y + (to.y - y) * ratio;
          out.width = w + (to.width - w) * ratio;
          out.height = h + (to.height - h) * ratio;
          return out;
        }
        static intersection(out, one, other) {
          const axMin = one.x;
          const ayMin = one.y;
          const axMax = one.x + one.width;
          const ayMax = one.y + one.height;
          const bxMin = other.x;
          const byMin = other.y;
          const bxMax = other.x + other.width;
          const byMax = other.y + other.height;
          out.x = max$4(axMin, bxMin);
          out.y = max$4(ayMin, byMin);
          out.width = min$3(axMax, bxMax) - out.x;
          out.height = min$3(ayMax, byMax) - out.y;
          return out;
        }
        static union(out, one, other) {
          const x = one.x;
          const y = one.y;
          const w = one.width;
          const h = one.height;
          const bx = other.x;
          const by = other.y;
          const bw = other.width;
          const bh = other.height;
          out.x = min$3(x, bx);
          out.y = min$3(y, by);
          out.width = max$4(x + w, bx + bw) - out.x;
          out.height = max$4(y + h, by + bh) - out.y;
          return out;
        }
        static equals(a, b) {
          return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;
        }
        get xMin() {
          return this.x;
        }
        set xMin(value) {
          this.width += this.x - value;
          this.x = value;
        }
        get yMin() {
          return this.y;
        }
        set yMin(value) {
          this.height += this.y - value;
          this.y = value;
        }
        get xMax() {
          return this.x + this.width;
        }
        set xMax(value) {
          this.width = value - this.x;
        }
        get yMax() {
          return this.y + this.height;
        }
        set yMax(value) {
          this.height = value - this.y;
        }
        get center() {
          return new Vec2(this.x + this.width * 0.5, this.y + this.height * 0.5);
        }
        set center(value) {
          this.x = value.x - this.width * 0.5;
          this.y = value.y - this.height * 0.5;
        }
        get origin() {
          return new Vec2(this.x, this.y);
        }
        set origin(value) {
          this.x = value.x;
          this.y = value.y;
        }
        get size() {
          return new Size$1(this.width, this.height);
        }
        set size(value) {
          this.width = value.width;
          this.height = value.height;
        }
        set z(val) {
          this.width = val;
        }
        get z() {
          return this.width;
        }
        set w(val) {
          this.height = val;
        }
        get w() {
          return this.height;
        }
        constructor(x, y, width, height) {
          super();
          if (typeof x === 'object') {
            this.x = x.x;
            this.y = x.y;
            this.width = x.width;
            this.height = x.height;
          } else {
            this.x = x || 0;
            this.y = y || 0;
            this.width = width || 0;
            this.height = height || 0;
          }
        }
        clone() {
          return new Rect(this.x, this.y, this.width, this.height);
        }
        set(x, y, width, height) {
          const self = this;
          if (typeof x === 'object') {
            self.x = x.x;
            self.y = x.y;
            self.width = x.width;
            self.height = x.height;
          } else {
            self.x = x || 0;
            self.y = y || 0;
            self.width = width || 0;
            self.height = height || 0;
          }
          return self;
        }
        equals(other) {
          const self = this;
          return self.x === other.x && self.y === other.y && self.width === other.width && self.height === other.height;
        }
        lerp(to, ratio) {
          const self = this;
          const x = self.x;
          const y = self.y;
          const w = self.width;
          const h = self.height;
          self.x = x + (to.x - x) * ratio;
          self.y = y + (to.y - y) * ratio;
          self.width = w + (to.width - w) * ratio;
          self.height = h + (to.height - h) * ratio;
          return self;
        }
        toString() {
          const self = this;
          return `(${self.x.toFixed(2)}, ${self.y.toFixed(2)}, ${self.width.toFixed(2)}, ${self.height.toFixed(2)})`;
        }
        intersects(other) {
          const self = this;
          const maxax = self.x + self.width;
          const maxay = self.y + self.height;
          const maxbx = other.x + other.width;
          const maxby = other.y + other.height;
          return !(maxax < other.x || maxbx < self.x || maxay < other.y || maxby < self.y);
        }
        contains(point) {
          const self = this;
          return self.x <= point.x && self.x + self.width >= point.x && self.y <= point.y && self.y + self.height >= point.y;
        }
        containsRect(other) {
          const self = this;
          return self.x <= other.x && self.x + self.width >= other.x + other.width && self.y <= other.y && self.y + self.height >= other.y + other.height;
        }
        transformMat4(mat) {
          const self = this;
          const ol = self.x;
          const ob = self.y;
          const or = ol + self.width;
          const ot = ob + self.height;
          const lbx = mat.m00 * ol + mat.m04 * ob + mat.m12;
          const lby = mat.m01 * ol + mat.m05 * ob + mat.m13;
          const rbx = mat.m00 * or + mat.m04 * ob + mat.m12;
          const rby = mat.m01 * or + mat.m05 * ob + mat.m13;
          const ltx = mat.m00 * ol + mat.m04 * ot + mat.m12;
          const lty = mat.m01 * ol + mat.m05 * ot + mat.m13;
          const rtx = mat.m00 * or + mat.m04 * ot + mat.m12;
          const rty = mat.m01 * or + mat.m05 * ot + mat.m13;
          const minX = min$3(lbx, rbx, ltx, rtx);
          const maxX = max$4(lbx, rbx, ltx, rtx);
          const minY = min$3(lby, rby, lty, rty);
          const maxY = max$4(lby, rby, lty, rty);
          self.x = minX;
          self.y = minY;
          self.width = maxX - minX;
          self.height = maxY - minY;
          return self;
        }
        transformMat4ToPoints(mat, out_lb, out_lt, out_rt, out_rb) {
          const self = this;
          const ol = self.x;
          const ob = self.y;
          const or = ol + self.width;
          const ot = ob + self.height;
          out_lb.x = mat.m00 * ol + mat.m04 * ob + mat.m12;
          out_lb.y = mat.m01 * ol + mat.m05 * ob + mat.m13;
          out_rb.x = mat.m00 * or + mat.m04 * ob + mat.m12;
          out_rb.y = mat.m01 * or + mat.m05 * ob + mat.m13;
          out_lt.x = mat.m00 * ol + mat.m04 * ot + mat.m12;
          out_lt.y = mat.m01 * ol + mat.m05 * ot + mat.m13;
          out_rt.x = mat.m00 * or + mat.m04 * ot + mat.m12;
          out_rt.y = mat.m01 * or + mat.m05 * ot + mat.m13;
        }
      }; exports("Rect", Rect$1);
      CCClass.fastDefine('cc.Rect', Rect$1, {
        x: 0,
        y: 0,
        width: 0,
        height: 0
      });
      legacyCC.Rect = Rect$1;
      function rect(x = 0, y = 0, width = 0, height = 0) {
        return new Rect$1(x, y, width, height);
      }
      legacyCC.rect = rect;

      const MATH_FLOAT_ARRAY = exports("MATH_FLOAT_ARRAY", Float32Array );
      class MathBase extends ValueType {
        static createFloatArray(size) {
          return new MATH_FLOAT_ARRAY(size);
        }
        get array() {
          return this._array;
        }
      } exports("MathBase", MathBase);

      var math = /*#__PURE__*/Object.freeze({
        __proto__: null,
        AffineTransform: AffineTransform,
        Color: Color$1,
        EPSILON: EPSILON$2,
        HALF_PI: HALF_PI,
        MATH_FLOAT_ARRAY: MATH_FLOAT_ARRAY,
        Mat3: Mat3,
        Mat4: Mat4,
        MathBase: MathBase,
        Quat: Quat,
        Rect: Rect$1,
        Size: Size$1,
        TWO_PI: TWO_PI,
        Vec2: Vec2,
        Vec3: Vec3,
        Vec4: Vec4,
        absMax: absMax,
        absMaxComponent: absMaxComponent,
        approx: approx,
        bits: bits,
        clamp: clamp$1,
        clamp01: clamp01,
        color: color,
        enumerableProps: enumerableProps,
        equals: equals$2,
        floatToHalf: floatToHalf,
        halfToFloat: halfToFloat,
        inverseLerp: inverseLerp,
        lerp: lerp,
        mat4: mat4,
        nextPow2: nextPow2,
        pingPong: pingPong,
        preTransforms: preTransforms,
        pseudoRandom: pseudoRandom,
        pseudoRandomRange: pseudoRandomRange,
        pseudoRandomRangeInt: pseudoRandomRangeInt,
        quat: quat,
        random: random,
        randomRange: randomRange,
        randomRangeInt: randomRangeInt,
        rect: rect,
        repeat: repeat$2,
        setRandGenerator: setRandGenerator,
        size: size,
        toDegree: toDegree,
        toRadian: toRadian,
        v2: v2$1,
        v3: v3,
        v4: v4
      });
      exports("math", math);

      const X = new Vec3();
      const Y = new Vec3();
      const Z = new Vec3();
      const d = new Vec3();
      const min$2 = new Vec3();
      const max$3 = new Vec3();
      const u = new Array(3);
      const e = new Array(3);
      function point_plane(point, plane_) {
        return Vec3.dot(plane_.n, point) - plane_.d;
      }
      function pt_point_plane(out, point, plane_) {
        const t = point_plane(point, plane_);
        return Vec3.subtract(out, point, Vec3.multiplyScalar(out, plane_.n, t));
      }
      function pt_point_aabb(out, point, aabb_) {
        Vec3.copy(out, point);
        Vec3.subtract(min$2, aabb_.center, aabb_.halfExtents);
        Vec3.add(max$3, aabb_.center, aabb_.halfExtents);
        out.x = out.x < min$2.x ? min$2.x : out.x;
        out.y = out.y < min$2.y ? min$2.y : out.y;
        out.z = out.z < min$2.z ? min$2.z : out.z;
        out.x = out.x > max$3.x ? max$3.x : out.x;
        out.y = out.y > max$3.y ? max$3.y : out.y;
        out.z = out.z > max$3.z ? max$3.z : out.z;
        return out;
      }
      function pt_point_obb(out, point, obb_) {
        Vec3.set(X, obb_.orientation.m00, obb_.orientation.m01, obb_.orientation.m02);
        Vec3.set(Y, obb_.orientation.m03, obb_.orientation.m04, obb_.orientation.m05);
        Vec3.set(Z, obb_.orientation.m06, obb_.orientation.m07, obb_.orientation.m08);
        u[0] = X;
        u[1] = Y;
        u[2] = Z;
        e[0] = obb_.halfExtents.x;
        e[1] = obb_.halfExtents.y;
        e[2] = obb_.halfExtents.z;
        Vec3.subtract(d, point, obb_.center);
        Vec3.set(out, obb_.center.x, obb_.center.y, obb_.center.z);
        for (let i = 0; i < 3; i++) {
          let dist = Vec3.dot(d, u[i]);
          if (dist > e[i]) {
            dist = e[i];
          }
          if (dist < -e[i]) {
            dist = -e[i];
          }
          out.x += dist * u[i].x;
          out.y += dist * u[i].y;
          out.z += dist * u[i].z;
        }
        return out;
      }
      function pt_point_line(out, point, linePointA, linePointB) {
        Vec3.subtract(X, linePointA, linePointB);
        const dir = X.clone();
        const dirSquaredLength = Vec3.lengthSqr(dir);
        if (dirSquaredLength === 0) {
          Vec3.copy(out, linePointA);
        } else {
          Vec3.subtract(X, point, linePointA);
          const t = Vec3.dot(X, dir) / dirSquaredLength;
          if (t < 0) {
            Vec3.copy(out, linePointA);
          } else if (t > 1) {
            Vec3.copy(out, linePointB);
          } else {
            Vec3.scaleAndAdd(out, linePointA, dir, t);
          }
        }
      }

      var distance = /*#__PURE__*/Object.freeze({
        __proto__: null,
        point_plane: point_plane,
        pt_point_aabb: pt_point_aabb,
        pt_point_line: pt_point_line,
        pt_point_obb: pt_point_obb,
        pt_point_plane: pt_point_plane
      });

      class Line {
        static create(sx, sy, sz, ex, ey, ez) {
          return new Line(sx, sy, sz, ex, ey, ez);
        }
        static clone(a) {
          return new Line(a.s.x, a.s.y, a.s.z, a.e.x, a.e.y, a.e.z);
        }
        static copy(out, a) {
          Vec3.copy(out.s, a.s);
          Vec3.copy(out.e, a.e);
          return out;
        }
        static fromPoints(out, start, end) {
          Vec3.copy(out.s, start);
          Vec3.copy(out.e, end);
          return out;
        }
        static set(out, sx, sy, sz, ex, ey, ez) {
          out.s.x = sx;
          out.s.y = sy;
          out.s.z = sz;
          out.e.x = ex;
          out.e.y = ey;
          out.e.z = ez;
          return out;
        }
        static len(a) {
          return Vec3.distance(a.s, a.e);
        }
        get type() {
          return this._type;
        }
        constructor(sx = 0, sy = 0, sz = 0, ex = 0, ey = 0, ez = -1) {
          this.s = void 0;
          this.e = void 0;
          this._type = void 0;
          this._type = 2;
          this.s = new Vec3(sx, sy, sz);
          this.e = new Vec3(ex, ey, ez);
        }
        length() {
          return Vec3.distance(this.s, this.e);
        }
      }

      class Ray {
        static create(ox = 0, oy = 0, oz = 0, dx = 0, dy = 0, dz = 1) {
          return new Ray(ox, oy, oz, dx, dy, dz);
        }
        static clone(a) {
          return new Ray(a.o.x, a.o.y, a.o.z, a.d.x, a.d.y, a.d.z);
        }
        static copy(out, a) {
          Vec3.copy(out.o, a.o);
          Vec3.copy(out.d, a.d);
          return out;
        }
        static fromPoints(out, origin, target) {
          Vec3.copy(out.o, origin);
          Vec3.normalize(out.d, Vec3.subtract(out.d, target, origin));
          return out;
        }
        static set(out, ox, oy, oz, dx, dy, dz) {
          out.o.x = ox;
          out.o.y = oy;
          out.o.z = oz;
          out.d.x = dx;
          out.d.y = dy;
          out.d.z = dz;
          return out;
        }
        get type() {
          return this._type;
        }
        constructor(ox = 0, oy = 0, oz = 0, dx = 0, dy = 0, dz = -1) {
          this._type = 1;
          this.o = new Vec3(ox, oy, oz);
          this.d = new Vec3(dx, dy, dz);
        }
        computeHit(out, distance) {
          Vec3.normalize(out, this.d);
          Vec3.scaleAndAdd(out, this.o, out, distance);
        }
      }

      const _v3_tmp$2 = new Vec3();
      const _offset = new Vec3();
      const _min = new Vec3();
      const _max = new Vec3();
      function maxComponent(v) {
        return Math.max(Math.max(v.x, v.y), v.z);
      }
      class Sphere {
        static create(cx, cy, cz, r) {
          return new Sphere(cx, cy, cz, r);
        }
        static clone(p) {
          return new Sphere(p.center.x, p.center.y, p.center.z, p.radius);
        }
        static copy(out, p) {
          Vec3.copy(out.center, p.center);
          out.radius = p.radius;
          return out;
        }
        static fromPoints(out, minPos, maxPos) {
          Vec3.multiplyScalar(out.center, Vec3.add(_v3_tmp$2, minPos, maxPos), 0.5);
          out.radius = Vec3.subtract(_v3_tmp$2, maxPos, minPos).length() * 0.5;
          return out;
        }
        static set(out, cx, cy, cz, r) {
          out.center.x = cx;
          out.center.y = cy;
          out.center.z = cz;
          out.radius = r;
          return out;
        }
        get center() {
          return this._center;
        }
        set center(val) {
          this._center = val;
        }
        get radius() {
          return this._radius;
        }
        set radius(val) {
          this._radius = val;
        }
        get type() {
          return this._type;
        }
        constructor(cx = 0, cy = 0, cz = 0, r = 1) {
          this._type = 4;
          this._center = new Vec3(cx, cy, cz);
          this._radius = r;
        }
        destroy() {}
        clone() {
          return Sphere.clone(this);
        }
        copy(a) {
          return Sphere.copy(this, a);
        }
        getBoundary(minPos, maxPos) {
          Vec3.set(minPos, this.center.x - this.radius, this.center.y - this.radius, this.center.z - this.radius);
          Vec3.set(maxPos, this.center.x + this.radius, this.center.y + this.radius, this.center.z + this.radius);
        }
        transform(m, pos, rot, scale, out) {
          Vec3.transformMat4(out.center, this.center, m);
          out.radius = this.radius * maxComponent(scale);
        }
        translateAndRotate(m, rot, out) {
          Vec3.transformMat4(out.center, this.center, m);
        }
        setScale(scale, out) {
          out.radius = this.radius * maxComponent(scale);
        }
        mergePoint(point) {
          if (this.radius < 0.0) {
            this.center.set(point);
            this.radius = 0.0;
          }
          Vec3.subtract(_offset, point, this.center);
          const dist = _offset.length();
          if (dist > this.radius) {
            const half = (dist - this.radius) * 0.5;
            this.radius += half;
            Vec3.multiplyScalar(_offset, _offset, half / dist);
            Vec3.add(this.center, this.center, _offset);
          }
        }
        mergePoints(points) {
          const length = points.length;
          if (length < 1) return;
          this.radius = -1.0;
          for (let i = 0; i < length; i++) {
            this.mergePoint(points[i]);
          }
        }
        mergeAABB(a) {
          a.getBoundary(_min, _max);
          this.mergePoint(_min);
          this.mergePoint(_max);
        }
      }

      const rayPlane = function () {
        return function (ray, plane) {
          const denom = Vec3.dot(ray.d, plane.n);
          if (Math.abs(denom) < Number.EPSILON) {
            return 0;
          }
          const d = point_plane(ray.o, plane);
          const t = -d / denom;
          if (t < 0) {
            return 0;
          }
          return t;
        };
      }();
      const rayTriangle = function () {
        const ab = new Vec3(0, 0, 0);
        const ac = new Vec3(0, 0, 0);
        const pvec = new Vec3(0, 0, 0);
        const tvec = new Vec3(0, 0, 0);
        const qvec = new Vec3(0, 0, 0);
        return function (ray, triangle, doubleSided) {
          Vec3.subtract(ab, triangle.b, triangle.a);
          Vec3.subtract(ac, triangle.c, triangle.a);
          Vec3.cross(pvec, ray.d, ac);
          const det = Vec3.dot(ab, pvec);
          if (det < Number.EPSILON && (!doubleSided || det > -Number.EPSILON)) {
            return 0;
          }
          const inv_det = 1 / det;
          Vec3.subtract(tvec, ray.o, triangle.a);
          const u = Vec3.dot(tvec, pvec) * inv_det;
          if (u < 0 || u > 1) {
            return 0;
          }
          Vec3.cross(qvec, tvec, ab);
          const v = Vec3.dot(ray.d, qvec) * inv_det;
          if (v < 0 || u + v > 1) {
            return 0;
          }
          const t = Vec3.dot(ac, qvec) * inv_det;
          return t < 0 ? 0 : t;
        };
      }();
      const raySphere = function () {
        const e = new Vec3(0, 0, 0);
        return function (ray, sphere) {
          const r = sphere.radius;
          const c = sphere.center;
          const o = ray.o;
          const d = ray.d;
          const rSq = r * r;
          Vec3.subtract(e, c, o);
          const eSq = e.lengthSqr();
          const aLength = Vec3.dot(e, d);
          const fSq = rSq - (eSq - aLength * aLength);
          if (fSq < 0) {
            return 0;
          }
          const f = Math.sqrt(fSq);
          const t = eSq < rSq ? aLength + f : aLength - f;
          if (t < 0) {
            return 0;
          }
          return t;
        };
      }();
      const rayAABB = function () {
        const min = new Vec3();
        const max = new Vec3();
        return function (ray, aabb) {
          Vec3.subtract(min, aabb.center, aabb.halfExtents);
          Vec3.add(max, aabb.center, aabb.halfExtents);
          return rayAABB2$1(ray, min, max);
        };
      }();
      function rayAABB2$1(ray, min, max) {
        const o = ray.o;
        const d = ray.d;
        const ix = 1 / d.x;
        const iy = 1 / d.y;
        const iz = 1 / d.z;
        const t1 = (min.x - o.x) * ix;
        const t2 = (max.x - o.x) * ix;
        const t3 = (min.y - o.y) * iy;
        const t4 = (max.y - o.y) * iy;
        const t5 = (min.z - o.z) * iz;
        const t6 = (max.z - o.z) * iz;
        const tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        const tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        if (tmax < 0 || tmin > tmax) {
          return 0;
        }
        return tmin > 0 ? tmin : tmax;
      }
      const rayOBB = function () {
        let center = new Vec3();
        let o = new Vec3();
        let d = new Vec3();
        const X = new Vec3();
        const Y = new Vec3();
        const Z = new Vec3();
        const p = new Vec3();
        const size = new Array(3);
        const f = new Array(3);
        const e = new Array(3);
        const t = new Array(6);
        return function (ray, obb) {
          size[0] = obb.halfExtents.x;
          size[1] = obb.halfExtents.y;
          size[2] = obb.halfExtents.z;
          center = obb.center;
          o = ray.o;
          d = ray.d;
          Vec3.set(X, obb.orientation.m00, obb.orientation.m01, obb.orientation.m02);
          Vec3.set(Y, obb.orientation.m03, obb.orientation.m04, obb.orientation.m05);
          Vec3.set(Z, obb.orientation.m06, obb.orientation.m07, obb.orientation.m08);
          Vec3.subtract(p, center, o);
          f[0] = Vec3.dot(X, d);
          f[1] = Vec3.dot(Y, d);
          f[2] = Vec3.dot(Z, d);
          e[0] = Vec3.dot(X, p);
          e[1] = Vec3.dot(Y, p);
          e[2] = Vec3.dot(Z, p);
          for (let i = 0; i < 3; ++i) {
            if (f[i] === 0) {
              if (-e[i] - size[i] > 0 || -e[i] + size[i] < 0) {
                return 0;
              }
              f[i] = 0.0000001;
            }
            t[i * 2 + 0] = (e[i] + size[i]) / f[i];
            t[i * 2 + 1] = (e[i] - size[i]) / f[i];
          }
          const tmin = Math.max(Math.max(Math.min(t[0], t[1]), Math.min(t[2], t[3])), Math.min(t[4], t[5]));
          const tmax = Math.min(Math.min(Math.max(t[0], t[1]), Math.max(t[2], t[3])), Math.max(t[4], t[5]));
          if (tmax < 0 || tmin > tmax) {
            return 0;
          }
          return tmin > 0 ? tmin : tmax;
        };
      }();
      const rayCapsule = function () {
        const v3_0 = new Vec3();
        const v3_1 = new Vec3();
        const v3_2 = new Vec3();
        const v3_3 = new Vec3();
        const v3_4 = new Vec3();
        const v3_5 = new Vec3();
        const v3_6 = new Vec3();
        const sphere_0 = new Sphere();
        return function (ray, capsule) {
          const A = capsule.ellipseCenter0;
          const B = capsule.ellipseCenter1;
          const BA = Vec3.subtract(v3_1, B, A);
          if (BA.length() < EPSILON$2) {
            sphere_0.radius = capsule.radius;
            sphere_0.center.set(capsule.ellipseCenter0);
            return intersect.raySphere(ray, sphere_0);
          }
          const O = ray.o;
          const OA = Vec3.subtract(v3_2, O, A);
          const vRayNorm = Vec3.normalize(v3_0, ray.d);
          const VxBA = Vec3.cross(v3_3, vRayNorm, BA);
          const a = VxBA.lengthSqr();
          if (a === 0) {
            sphere_0.radius = capsule.radius;
            const BO = Vec3.subtract(v3_4, B, O);
            if (OA.lengthSqr() < BO.lengthSqr()) {
              sphere_0.center.set(A);
            } else {
              sphere_0.center.set(B);
            }
            return intersect.raySphere(ray, sphere_0);
          }
          const OAxBA = Vec3.cross(v3_4, OA, BA);
          const ab2 = BA.lengthSqr();
          const b = 2 * Vec3.dot(VxBA, OAxBA);
          const radiusSqr = capsule.radius * capsule.radius;
          const c = OAxBA.lengthSqr() - radiusSqr * ab2;
          const d = b * b - 4 * a * c;
          if (d < 0) {
            return 0;
          }
          const t = (-b - Math.sqrt(d)) / (2 * a);
          if (t < 0) {
            sphere_0.radius = capsule.radius;
            const BO = Vec3.subtract(v3_5, B, O);
            if (OA.lengthSqr() < BO.lengthSqr()) {
              sphere_0.center.set(capsule.ellipseCenter0);
            } else {
              sphere_0.center.set(capsule.ellipseCenter1);
            }
            return intersect.raySphere(ray, sphere_0);
          } else {
            const iPos = Vec3.scaleAndAdd(v3_5, ray.o, vRayNorm, t);
            const iPosLen = Vec3.subtract(v3_6, iPos, A);
            const tLimit = Vec3.dot(iPosLen, BA) / ab2;
            if (tLimit >= 0 && tLimit <= 1) {
              return t;
            } else if (tLimit < 0) {
              sphere_0.radius = capsule.radius;
              sphere_0.center.set(capsule.ellipseCenter0);
              return intersect.raySphere(ray, sphere_0);
            } else if (tLimit > 1) {
              sphere_0.radius = capsule.radius;
              sphere_0.center.set(capsule.ellipseCenter1);
              return intersect.raySphere(ray, sphere_0);
            } else {
              return 0;
            }
          }
        };
      }();
      const linePlane = function () {
        const ab = new Vec3(0, 0, 0);
        return function (line, plane) {
          Vec3.subtract(ab, line.e, line.s);
          const t = -point_plane(line.s, plane) / Vec3.dot(ab, plane.n);
          if (t < 0 || t > 1) {
            return 0;
          }
          return t;
        };
      }();
      const lineTriangle = function () {
        const ab = new Vec3(0, 0, 0);
        const ac = new Vec3(0, 0, 0);
        const qp = new Vec3(0, 0, 0);
        const ap = new Vec3(0, 0, 0);
        const n = new Vec3(0, 0, 0);
        const e = new Vec3(0, 0, 0);
        return function (line, triangle, outPt) {
          Vec3.subtract(ab, triangle.b, triangle.a);
          Vec3.subtract(ac, triangle.c, triangle.a);
          Vec3.subtract(qp, line.s, line.e);
          Vec3.cross(n, ab, ac);
          const det = Vec3.dot(qp, n);
          if (det <= 0.0) {
            return 0;
          }
          Vec3.subtract(ap, line.s, triangle.a);
          const t = Vec3.dot(ap, n);
          if (t < 0 || t > det) {
            return 0;
          }
          Vec3.cross(e, qp, ap);
          let v = Vec3.dot(ac, e);
          if (v < 0 || v > det) {
            return 0;
          }
          let w = -Vec3.dot(ab, e);
          if (w < 0.0 || v + w > det) {
            return 0;
          }
          if (outPt) {
            const invDet = 1.0 / det;
            v *= invDet;
            w *= invDet;
            const u = 1.0 - v - w;
            Vec3.set(outPt, triangle.a.x * u + triangle.b.x * v + triangle.c.x * w, triangle.a.y * u + triangle.b.y * v + triangle.c.y * w, triangle.a.z * u + triangle.b.z * v + triangle.c.z * w);
          }
          return 1;
        };
      }();
      const r_t = new Ray();
      function lineAABB(line, aabb) {
        r_t.o.set(line.s);
        Vec3.subtract(r_t.d, line.e, line.s);
        r_t.d.normalize();
        const min = rayAABB(r_t, aabb);
        const len = line.length();
        if (min <= len) {
          return min;
        } else {
          return 0;
        }
      }
      function lineOBB(line, obb) {
        r_t.o.set(line.s);
        Vec3.subtract(r_t.d, line.e, line.s);
        r_t.d.normalize();
        const min = rayOBB(r_t, obb);
        const len = line.length();
        if (min <= len) {
          return min;
        } else {
          return 0;
        }
      }
      function lineSphere(line, sphere) {
        r_t.o.set(line.s);
        Vec3.subtract(r_t.d, line.e, line.s);
        r_t.d.normalize();
        const min = raySphere(r_t, sphere);
        const len = line.length();
        if (min <= len) {
          return min;
        } else {
          return 0;
        }
      }
      const aabbWithAABB = function () {
        const aMin = new Vec3();
        const aMax = new Vec3();
        const bMin = new Vec3();
        const bMax = new Vec3();
        return function (aabb1, aabb2) {
          Vec3.subtract(aMin, aabb1.center, aabb1.halfExtents);
          Vec3.add(aMax, aabb1.center, aabb1.halfExtents);
          Vec3.subtract(bMin, aabb2.center, aabb2.halfExtents);
          Vec3.add(bMax, aabb2.center, aabb2.halfExtents);
          return aMin.x <= bMax.x && aMax.x >= bMin.x && aMin.y <= bMax.y && aMax.y >= bMin.y && aMin.z <= bMax.z && aMax.z >= bMin.z;
        };
      }();
      function getAABBVertices(min, max, out) {
        Vec3.set(out[0], min.x, max.y, max.z);
        Vec3.set(out[1], min.x, max.y, min.z);
        Vec3.set(out[2], min.x, min.y, max.z);
        Vec3.set(out[3], min.x, min.y, min.z);
        Vec3.set(out[4], max.x, max.y, max.z);
        Vec3.set(out[5], max.x, max.y, min.z);
        Vec3.set(out[6], max.x, min.y, max.z);
        Vec3.set(out[7], max.x, min.y, min.z);
      }
      function getOBBVertices(c, e, a1, a2, a3, out) {
        Vec3.set(out[0], c.x + a1.x * e.x + a2.x * e.y + a3.x * e.z, c.y + a1.y * e.x + a2.y * e.y + a3.y * e.z, c.z + a1.z * e.x + a2.z * e.y + a3.z * e.z);
        Vec3.set(out[1], c.x - a1.x * e.x + a2.x * e.y + a3.x * e.z, c.y - a1.y * e.x + a2.y * e.y + a3.y * e.z, c.z - a1.z * e.x + a2.z * e.y + a3.z * e.z);
        Vec3.set(out[2], c.x + a1.x * e.x - a2.x * e.y + a3.x * e.z, c.y + a1.y * e.x - a2.y * e.y + a3.y * e.z, c.z + a1.z * e.x - a2.z * e.y + a3.z * e.z);
        Vec3.set(out[3], c.x + a1.x * e.x + a2.x * e.y - a3.x * e.z, c.y + a1.y * e.x + a2.y * e.y - a3.y * e.z, c.z + a1.z * e.x + a2.z * e.y - a3.z * e.z);
        Vec3.set(out[4], c.x - a1.x * e.x - a2.x * e.y - a3.x * e.z, c.y - a1.y * e.x - a2.y * e.y - a3.y * e.z, c.z - a1.z * e.x - a2.z * e.y - a3.z * e.z);
        Vec3.set(out[5], c.x + a1.x * e.x - a2.x * e.y - a3.x * e.z, c.y + a1.y * e.x - a2.y * e.y - a3.y * e.z, c.z + a1.z * e.x - a2.z * e.y - a3.z * e.z);
        Vec3.set(out[6], c.x - a1.x * e.x + a2.x * e.y - a3.x * e.z, c.y - a1.y * e.x + a2.y * e.y - a3.y * e.z, c.z - a1.z * e.x + a2.z * e.y - a3.z * e.z);
        Vec3.set(out[7], c.x - a1.x * e.x - a2.x * e.y + a3.x * e.z, c.y - a1.y * e.x - a2.y * e.y + a3.y * e.z, c.z - a1.z * e.x - a2.z * e.y + a3.z * e.z);
      }
      function getInterval(vertices, axis) {
        let min = Vec3.dot(axis, vertices[0]);
        let max = min;
        for (let i = 1; i < 8; ++i) {
          const projection = Vec3.dot(axis, vertices[i]);
          min = projection < min ? projection : min;
          max = projection > max ? projection : max;
        }
        return [min, max];
      }
      const aabbWithOBB = function () {
        const test = new Array(15);
        for (let i = 0; i < 15; i++) {
          test[i] = new Vec3(0, 0, 0);
        }
        const vertices = new Array(8);
        const vertices2 = new Array(8);
        for (let i = 0; i < 8; i++) {
          vertices[i] = new Vec3(0, 0, 0);
          vertices2[i] = new Vec3(0, 0, 0);
        }
        const min = new Vec3();
        const max = new Vec3();
        return function (aabb, obb) {
          Vec3.set(test[0], 1, 0, 0);
          Vec3.set(test[1], 0, 1, 0);
          Vec3.set(test[2], 0, 0, 1);
          Vec3.set(test[3], obb.orientation.m00, obb.orientation.m01, obb.orientation.m02);
          Vec3.set(test[4], obb.orientation.m03, obb.orientation.m04, obb.orientation.m05);
          Vec3.set(test[5], obb.orientation.m06, obb.orientation.m07, obb.orientation.m08);
          for (let i = 0; i < 3; ++i) {
            Vec3.cross(test[6 + i * 3 + 0], test[i], test[3]);
            Vec3.cross(test[6 + i * 3 + 1], test[i], test[4]);
            Vec3.cross(test[6 + i * 3 + 1], test[i], test[5]);
          }
          Vec3.subtract(min, aabb.center, aabb.halfExtents);
          Vec3.add(max, aabb.center, aabb.halfExtents);
          getAABBVertices(min, max, vertices);
          getOBBVertices(obb.center, obb.halfExtents, test[3], test[4], test[5], vertices2);
          for (let j = 0; j < 15; ++j) {
            const a = getInterval(vertices, test[j]);
            const b = getInterval(vertices2, test[j]);
            if (b[0] > a[1] || a[0] > b[1]) {
              return 0;
            }
          }
          return 1;
        };
      }();
      const aabbPlane = function (aabb, plane) {
        const r = aabb.halfExtents.x * Math.abs(plane.n.x) + aabb.halfExtents.y * Math.abs(plane.n.y) + aabb.halfExtents.z * Math.abs(plane.n.z);
        const dot = Vec3.dot(plane.n, aabb.center);
        if (dot + r < plane.d) {
          return -1;
        } else if (dot - r > plane.d) {
          return 0;
        }
        return 1;
      };
      const aabbFrustum = function (aabb, frustum) {
        for (let i = 0; i < frustum.planes.length; i++) {
          if (aabbPlane(aabb, frustum.planes[i]) === -1) {
            return 0;
          }
        }
        return 1;
      };
      const aabbFrustumCompletelyInside = function (aabb, frustum) {
        for (let i = 0; i < frustum.planes.length; i++) {
          if (aabbPlane(aabb, frustum.planes[i]) !== 0) {
            return 0;
          }
        }
        return 1;
      };
      const aabbFrustumAccurate = function () {
        const tmp = new Array(8);
        let out1 = 0;
        let out2 = 0;
        for (let i = 0; i < tmp.length; i++) {
          tmp[i] = new Vec3(0, 0, 0);
        }
        return function (aabb, frustum) {
          let result = 0;
          let intersects = false;
          for (let i = 0; i < frustum.planes.length; i++) {
            result = aabbPlane(aabb, frustum.planes[i]);
            if (result === -1) return 0;else if (result === 1) {
              intersects = true;
            }
          }
          if (!intersects) {
            return 1;
          }
          for (let i = 0; i < frustum.vertices.length; i++) {
            Vec3.subtract(tmp[i], frustum.vertices[i], aabb.center);
          }
          out1 = 0, out2 = 0;
          for (let i = 0; i < frustum.vertices.length; i++) {
            if (tmp[i].x > aabb.halfExtents.x) {
              out1++;
            } else if (tmp[i].x < -aabb.halfExtents.x) {
              out2++;
            }
          }
          if (out1 === frustum.vertices.length || out2 === frustum.vertices.length) {
            return 0;
          }
          out1 = 0;
          out2 = 0;
          for (let i = 0; i < frustum.vertices.length; i++) {
            if (tmp[i].y > aabb.halfExtents.y) {
              out1++;
            } else if (tmp[i].y < -aabb.halfExtents.y) {
              out2++;
            }
          }
          if (out1 === frustum.vertices.length || out2 === frustum.vertices.length) {
            return 0;
          }
          out1 = 0;
          out2 = 0;
          for (let i = 0; i < frustum.vertices.length; i++) {
            if (tmp[i].z > aabb.halfExtents.z) {
              out1++;
            } else if (tmp[i].z < -aabb.halfExtents.z) {
              out2++;
            }
          }
          if (out1 === frustum.vertices.length || out2 === frustum.vertices.length) {
            return 0;
          }
          return 1;
        };
      }();
      const obbPoint = function () {
        const tmp = new Vec3(0, 0, 0);
        const m3 = new Mat3();
        const lessThan = function (a, b) {
          return Math.abs(a.x) < b.x && Math.abs(a.y) < b.y && Math.abs(a.z) < b.z;
        };
        return function (obb, point) {
          Vec3.subtract(tmp, point, obb.center);
          Vec3.transformMat3(tmp, tmp, Mat3.transpose(m3, obb.orientation));
          return lessThan(tmp, obb.halfExtents);
        };
      }();
      const obbPlane = function () {
        const absDot = function (n, x, y, z) {
          return Math.abs(n.x * x + n.y * y + n.z * z);
        };
        return function (obb, plane) {
          const r = obb.halfExtents.x * absDot(plane.n, obb.orientation.m00, obb.orientation.m01, obb.orientation.m02) + obb.halfExtents.y * absDot(plane.n, obb.orientation.m03, obb.orientation.m04, obb.orientation.m05) + obb.halfExtents.z * absDot(plane.n, obb.orientation.m06, obb.orientation.m07, obb.orientation.m08);
          const dot = Vec3.dot(plane.n, obb.center);
          if (dot + r < plane.d) {
            return -1;
          } else if (dot - r > plane.d) {
            return 0;
          }
          return 1;
        };
      }();
      const obbFrustum = function (obb, frustum) {
        for (let i = 0; i < frustum.planes.length; i++) {
          if (obbPlane(obb, frustum.planes[i]) === -1) {
            return 0;
          }
        }
        return 1;
      };
      const obbFrustumAccurate = function () {
        const tmp = new Array(8);
        let dist = 0;
        let out1 = 0;
        let out2 = 0;
        for (let i = 0; i < tmp.length; i++) {
          tmp[i] = new Vec3(0, 0, 0);
        }
        const dot = function (n, x, y, z) {
          return n.x * x + n.y * y + n.z * z;
        };
        return function (obb, frustum) {
          let result = 0;
          let intersects = false;
          for (let i = 0; i < frustum.planes.length; i++) {
            result = obbPlane(obb, frustum.planes[i]);
            if (result === -1) return 0;else if (result === 1) {
              intersects = true;
            }
          }
          if (!intersects) {
            return 1;
          }
          for (let i = 0; i < frustum.vertices.length; i++) {
            Vec3.subtract(tmp[i], frustum.vertices[i], obb.center);
          }
          out1 = 0, out2 = 0;
          for (let i = 0; i < frustum.vertices.length; i++) {
            dist = dot(tmp[i], obb.orientation.m00, obb.orientation.m01, obb.orientation.m02);
            if (dist > obb.halfExtents.x) {
              out1++;
            } else if (dist < -obb.halfExtents.x) {
              out2++;
            }
          }
          if (out1 === frustum.vertices.length || out2 === frustum.vertices.length) {
            return 0;
          }
          out1 = 0;
          out2 = 0;
          for (let i = 0; i < frustum.vertices.length; i++) {
            dist = dot(tmp[i], obb.orientation.m03, obb.orientation.m04, obb.orientation.m05);
            if (dist > obb.halfExtents.y) {
              out1++;
            } else if (dist < -obb.halfExtents.y) {
              out2++;
            }
          }
          if (out1 === frustum.vertices.length || out2 === frustum.vertices.length) {
            return 0;
          }
          out1 = 0;
          out2 = 0;
          for (let i = 0; i < frustum.vertices.length; i++) {
            dist = dot(tmp[i], obb.orientation.m06, obb.orientation.m07, obb.orientation.m08);
            if (dist > obb.halfExtents.z) {
              out1++;
            } else if (dist < -obb.halfExtents.z) {
              out2++;
            }
          }
          if (out1 === frustum.vertices.length || out2 === frustum.vertices.length) {
            return 0;
          }
          return 1;
        };
      }();
      const obbWithOBB = function () {
        const test = new Array(15);
        for (let i = 0; i < 15; i++) {
          test[i] = new Vec3(0, 0, 0);
        }
        const vertices = new Array(8);
        const vertices2 = new Array(8);
        for (let i = 0; i < 8; i++) {
          vertices[i] = new Vec3(0, 0, 0);
          vertices2[i] = new Vec3(0, 0, 0);
        }
        return function (obb1, obb2) {
          Vec3.set(test[0], obb1.orientation.m00, obb1.orientation.m01, obb1.orientation.m02);
          Vec3.set(test[1], obb1.orientation.m03, obb1.orientation.m04, obb1.orientation.m05);
          Vec3.set(test[2], obb1.orientation.m06, obb1.orientation.m07, obb1.orientation.m08);
          Vec3.set(test[3], obb2.orientation.m00, obb2.orientation.m01, obb2.orientation.m02);
          Vec3.set(test[4], obb2.orientation.m03, obb2.orientation.m04, obb2.orientation.m05);
          Vec3.set(test[5], obb2.orientation.m06, obb2.orientation.m07, obb2.orientation.m08);
          for (let i = 0; i < 3; ++i) {
            Vec3.cross(test[6 + i * 3 + 0], test[i], test[3]);
            Vec3.cross(test[6 + i * 3 + 1], test[i], test[4]);
            Vec3.cross(test[6 + i * 3 + 2], test[i], test[5]);
          }
          getOBBVertices(obb1.center, obb1.halfExtents, test[0], test[1], test[2], vertices);
          getOBBVertices(obb2.center, obb2.halfExtents, test[3], test[4], test[5], vertices2);
          for (let i = 0; i < 15; ++i) {
            const a = getInterval(vertices, test[i]);
            const b = getInterval(vertices2, test[i]);
            if (b[0] > a[1] || a[0] > b[1]) {
              return 0;
            }
          }
          return 1;
        };
      }();
      const obbCapsule = function () {
        const sphere_0 = new Sphere();
        const v3_0 = new Vec3();
        const v3_1 = new Vec3();
        const v3_2 = new Vec3();
        const v3_verts8 = new Array(8);
        for (let i = 0; i < 8; i++) {
          v3_verts8[i] = new Vec3();
        }
        const v3_axis8 = new Array(8);
        for (let i = 0; i < 8; i++) {
          v3_axis8[i] = new Vec3();
        }
        return function (obb, capsule) {
          const h = Vec3.squaredDistance(capsule.ellipseCenter0, capsule.ellipseCenter1);
          if (h === 0) {
            sphere_0.radius = capsule.radius;
            sphere_0.center.set(capsule.ellipseCenter0);
            return intersect.sphereOBB(sphere_0, obb);
          } else {
            v3_0.x = obb.orientation.m00;
            v3_0.y = obb.orientation.m01;
            v3_0.z = obb.orientation.m02;
            v3_1.x = obb.orientation.m03;
            v3_1.y = obb.orientation.m04;
            v3_1.z = obb.orientation.m05;
            v3_2.x = obb.orientation.m06;
            v3_2.y = obb.orientation.m07;
            v3_2.z = obb.orientation.m08;
            getOBBVertices(obb.center, obb.halfExtents, v3_0, v3_1, v3_2, v3_verts8);
            const axes = v3_axis8;
            const a0 = Vec3.copy(axes[0], v3_0);
            const a1 = Vec3.copy(axes[1], v3_1);
            const a2 = Vec3.copy(axes[2], v3_2);
            const C = Vec3.subtract(axes[3], capsule.center, obb.center);
            C.normalize();
            const B = Vec3.subtract(axes[4], capsule.ellipseCenter0, capsule.ellipseCenter1);
            B.normalize();
            Vec3.cross(axes[5], a0, B);
            Vec3.cross(axes[6], a1, B);
            Vec3.cross(axes[7], a2, B);
            for (let i = 0; i < 8; ++i) {
              const a = getInterval(v3_verts8, axes[i]);
              const d0 = Vec3.dot(axes[i], capsule.ellipseCenter0);
              const d1 = Vec3.dot(axes[i], capsule.ellipseCenter1);
              const max_d = Math.max(d0, d1);
              const min_d = Math.min(d0, d1);
              const d_min = min_d - capsule.radius;
              const d_max = max_d + capsule.radius;
              if (d_min > a[1] || a[0] > d_max) {
                return 0;
              }
            }
            return 1;
          }
        };
      }();
      const spherePlane = function (sphere, plane) {
        const dot = Vec3.dot(plane.n, sphere.center);
        const r = sphere.radius * plane.n.length();
        if (dot + r < plane.d) {
          return -1;
        } else if (dot - r > plane.d) {
          return 0;
        }
        return 1;
      };
      const sphereFrustum = function (sphere, frustum) {
        for (let i = 0; i < frustum.planes.length; i++) {
          if (spherePlane(sphere, frustum.planes[i]) === -1) {
            return 0;
          }
        }
        return 1;
      };
      const sphereFrustumAccurate = function () {
        const pt = new Vec3(0, 0, 0);
        const map = [1, -1, 1, -1, 1, -1];
        return function (sphere, frustum) {
          for (let i = 0; i < 6; i++) {
            const plane = frustum.planes[i];
            const r = sphere.radius;
            const c = sphere.center;
            const n = plane.n;
            const d = plane.d;
            const dot = Vec3.dot(n, c);
            if (dot + r < d) return 0;else if (dot - r > d) {
              continue;
            }
            Vec3.add(pt, c, Vec3.multiplyScalar(pt, n, r));
            for (let j = 0; j < 6; j++) {
              if (j === i || j === i + map[i]) {
                continue;
              }
              const test = frustum.planes[j];
              if (Vec3.dot(test.n, pt) < test.d) {
                return 0;
              }
            }
          }
          return 1;
        };
      }();
      const sphereWithSphere = function (sphere0, sphere1) {
        const r = sphere0.radius + sphere1.radius;
        return Vec3.squaredDistance(sphere0.center, sphere1.center) < r * r;
      };
      const sphereAABB = function () {
        const pt = new Vec3();
        return function (sphere, aabb) {
          pt_point_aabb(pt, sphere.center, aabb);
          return Vec3.squaredDistance(sphere.center, pt) < sphere.radius * sphere.radius;
        };
      }();
      const sphereOBB = function () {
        const pt = new Vec3();
        return function (sphere, obb) {
          pt_point_obb(pt, sphere.center, obb);
          return Vec3.squaredDistance(sphere.center, pt) < sphere.radius * sphere.radius;
        };
      }();
      const sphereCapsule = function () {
        const v3_0 = new Vec3();
        const v3_1 = new Vec3();
        return function (sphere, capsule) {
          const r = sphere.radius + capsule.radius;
          const squaredR = r * r;
          const h = Vec3.squaredDistance(capsule.ellipseCenter0, capsule.ellipseCenter1);
          if (h === 0) {
            return Vec3.squaredDistance(sphere.center, capsule.center) < squaredR;
          } else {
            Vec3.subtract(v3_0, sphere.center, capsule.ellipseCenter0);
            Vec3.subtract(v3_1, capsule.ellipseCenter1, capsule.ellipseCenter0);
            const t = Vec3.dot(v3_0, v3_1) / h;
            if (t < 0) {
              return Vec3.squaredDistance(sphere.center, capsule.ellipseCenter0) < squaredR;
            } else if (t > 1) {
              return Vec3.squaredDistance(sphere.center, capsule.ellipseCenter1) < squaredR;
            } else {
              Vec3.scaleAndAdd(v3_0, capsule.ellipseCenter0, v3_1, t);
              return Vec3.squaredDistance(sphere.center, v3_0) < squaredR;
            }
          }
        };
      }();
      const capsuleWithCapsule = function () {
        const v3_0 = new Vec3();
        const v3_1 = new Vec3();
        const v3_2 = new Vec3();
        const v3_3 = new Vec3();
        const v3_4 = new Vec3();
        const v3_5 = new Vec3();
        return function capsuleWithCapsule(capsuleA, capsuleB) {
          const u = Vec3.subtract(v3_0, capsuleA.ellipseCenter1, capsuleA.ellipseCenter0);
          const v = Vec3.subtract(v3_1, capsuleB.ellipseCenter1, capsuleB.ellipseCenter0);
          const w = Vec3.subtract(v3_2, capsuleA.ellipseCenter0, capsuleB.ellipseCenter0);
          const a = Vec3.dot(u, u);
          const b = Vec3.dot(u, v);
          const c = Vec3.dot(v, v);
          const d = Vec3.dot(u, w);
          const e = Vec3.dot(v, w);
          const D = a * c - b * b;
          let sN;
          let sD = D;
          let tN;
          let tD = D;
          if (D < EPSILON$2) {
            sN = 0.0;
            sD = 1.0;
            tN = e;
            tD = c;
          } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0) {
              sN = 0.0;
              tN = e;
              tD = c;
            } else if (sN > sD) {
              sN = sD;
              tN = e + b;
              tD = c;
            }
          }
          if (tN < 0.0) {
            tN = 0.0;
            if (-d < 0.0) {
              sN = 0.0;
            } else if (-d > a) {
              sN = sD;
            } else {
              sN = -d;
              sD = a;
            }
          } else if (tN > tD) {
            tN = tD;
            if (-d + b < 0.0) {
              sN = 0;
            } else if (-d + b > a) {
              sN = sD;
            } else {
              sN = -d + b;
              sD = a;
            }
          }
          const sc = Math.abs(sN) < EPSILON$2 ? 0.0 : sN / sD;
          const tc = Math.abs(tN) < EPSILON$2 ? 0.0 : tN / tD;
          const dP = v3_3;
          dP.set(w);
          dP.add(Vec3.multiplyScalar(v3_4, u, sc));
          dP.subtract(Vec3.multiplyScalar(v3_5, v, tc));
          const radius = capsuleA.radius + capsuleB.radius;
          return dP.lengthSqr() < radius * radius;
        };
      }();
      const intersect = {
        raySphere,
        rayAABB,
        rayOBB,
        rayPlane,
        rayTriangle,
        rayCapsule,
        raySubMesh: null,
        rayMesh: null,
        rayModel: null,
        lineSphere,
        lineAABB,
        lineOBB,
        linePlane,
        lineTriangle,
        sphereWithSphere,
        sphereAABB,
        sphereOBB,
        spherePlane,
        sphereFrustum,
        sphereFrustumAccurate,
        sphereCapsule,
        aabbWithAABB,
        aabbWithOBB,
        aabbPlane,
        aabbFrustum,
        aabbFrustumAccurate,
        obbWithOBB,
        obbPlane,
        obbFrustum,
        obbFrustumAccurate,
        obbPoint,
        obbCapsule,
        aabbFrustumCompletelyInside,
        capsuleWithCapsule,
        resolve(g1, g2, outPt = null) {
          const type1 = g1._type;
          const type2 = g2._type;
          const resolver = this[type1 | type2];
          return type1 < type2 ? resolver(g1, g2, outPt) : resolver(g2, g1, outPt);
        }
      };
      intersect[1 | 4] = raySphere;
      intersect[1 | 8] = rayAABB;
      intersect[1 | 16] = rayOBB;
      intersect[1 | 32] = rayPlane;
      intersect[1 | 64] = rayTriangle;
      intersect[1 | 512] = rayCapsule;
      intersect[2 | 4] = lineSphere;
      intersect[2 | 8] = lineAABB;
      intersect[2 | 16] = lineOBB;
      intersect[2 | 32] = linePlane;
      intersect[2 | 64] = lineTriangle;
      intersect[4] = sphereWithSphere;
      intersect[4 | 8] = sphereAABB;
      intersect[4 | 16] = sphereOBB;
      intersect[4 | 32] = spherePlane;
      intersect[4 | 128] = sphereFrustum;
      intersect[4 | 256] = sphereFrustumAccurate;
      intersect[4 | 512] = sphereCapsule;
      intersect[8] = aabbWithAABB;
      intersect[8 | 16] = aabbWithOBB;
      intersect[8 | 32] = aabbPlane;
      intersect[8 | 128] = aabbFrustum;
      intersect[8 | 256] = aabbFrustumAccurate;
      intersect[16] = obbWithOBB;
      intersect[16 | 32] = obbPlane;
      intersect[16 | 128] = obbFrustum;
      intersect[16 | 256] = obbFrustumAccurate;
      intersect[16 | 512] = obbCapsule;
      intersect[512] = capsuleWithCapsule;

      replaceProperty(Line.prototype, 'line', [{
        name: 'mag',
        newName: 'len'
      }, {
        name: 'magnitude',
        newName: 'len'
      }]);
      removeProperty(intersect, 'intersect', [{
        name: 'line_quad'
      }]);

      const v1 = new Vec3(0, 0, 0);
      const v2 = new Vec3(0, 0, 0);
      const temp_mat = mat4();
      const temp_vec4 = v4();
      class Plane {
        static create(nx, ny, nz, d) {
          return new Plane(nx, ny, nz, d);
        }
        static clone(p) {
          return new Plane(p.n.x, p.n.y, p.n.z, p.d);
        }
        static copy(out, p) {
          Vec3.copy(out.n, p.n);
          out.d = p.d;
          return out;
        }
        static fromPoints(out, a, b, c) {
          Vec3.subtract(v1, b, a);
          Vec3.subtract(v2, c, a);
          Vec3.normalize(out.n, Vec3.cross(out.n, v1, v2));
          out.d = Vec3.dot(out.n, a);
          return out;
        }
        static set(out, nx, ny, nz, d) {
          out.n.x = nx;
          out.n.y = ny;
          out.n.z = nz;
          out.d = d;
          return out;
        }
        static fromNormalAndPoint(out, normal, point) {
          Vec3.copy(out.n, normal);
          out.d = Vec3.dot(normal, point);
          return out;
        }
        static normalize(out, a) {
          const len = a.n.length();
          Vec3.normalize(out.n, a.n);
          if (len > 0) {
            out.d = a.d / len;
          }
          return out;
        }
        get type() {
          return this._type;
        }
        set x(val) {
          this.n.x = val;
        }
        get x() {
          return this.n.x;
        }
        set y(val) {
          this.n.y = val;
        }
        get y() {
          return this.n.y;
        }
        set z(val) {
          this.n.z = val;
        }
        get z() {
          return this.n.z;
        }
        set w(val) {
          this.d = val;
        }
        get w() {
          return this.d;
        }
        constructor(nx = 0, ny = 1, nz = 0, d = 0) {
          this._type = 32;
          this.n = new Vec3(nx, ny, nz);
          this.d = d;
        }
        transform(mat) {
          Mat4.invert(temp_mat, mat);
          Mat4.transpose(temp_mat, temp_mat);
          Vec4.set(temp_vec4, this.n.x, this.n.y, this.n.z, -this.d);
          Vec4.transformMat4(temp_vec4, temp_vec4, temp_mat);
          Vec3.set(this.n, temp_vec4.x, temp_vec4.y, temp_vec4.z);
          this.d = -temp_vec4.w;
        }
      }

      class Triangle {
        static create(ax = 1, ay = 0, az = 0, bx = 0, by = 0, bz = 0, cx = 0, cy = 0, cz = 1) {
          return new Triangle(ax, ay, az, bx, by, bz, cx, cy, cz);
        }
        static clone(t) {
          return new Triangle(t.a.x, t.a.y, t.a.z, t.b.x, t.b.y, t.b.z, t.c.x, t.c.y, t.c.z);
        }
        static copy(out, t) {
          Vec3.copy(out.a, t.a);
          Vec3.copy(out.b, t.b);
          Vec3.copy(out.c, t.c);
          return out;
        }
        static fromPoints(out, a, b, c) {
          Vec3.copy(out.a, a);
          Vec3.copy(out.b, b);
          Vec3.copy(out.c, c);
          return out;
        }
        static set(out, ax, ay, az, bx, by, bz, cx, cy, cz) {
          out.a.x = ax;
          out.a.y = ay;
          out.a.z = az;
          out.b.x = bx;
          out.b.y = by;
          out.b.z = bz;
          out.c.x = cx;
          out.c.y = cy;
          out.c.z = cz;
          return out;
        }
        get type() {
          return this._type;
        }
        constructor(ax = 0, ay = 0, az = 0, bx = 1, by = 0, bz = 0, cx = 0, cy = 1, cz = 0) {
          this._type = 64;
          this.a = new Vec3(ax, ay, az);
          this.b = new Vec3(bx, by, bz);
          this.c = new Vec3(cx, cy, cz);
        }
      }

      deprecateModuleExportedName({
        replaceProperty: {
          since: '3.6.0',
          removed: false
        },
        removeProperty: {
          since: '3.6.0',
          removed: false
        },
        markAsWarning: {
          since: '3.6.0',
          removed: false
        },
        setDefaultLogTimes: {
          since: '3.6.0',
          removed: false
        }
      });

      class ScalableContainer {
        constructor() {
          this._poolHandle = -1;
          scalableContainerManager.addContainer(this);
        }
        destroy() {
          scalableContainerManager.removeContainer(this);
        }
      }
      class ScalableContainerManager {
        constructor() {
          this._pools = [];
          this._lastShrinkPassed = 0;
          this.shrinkTimeSpan = 5;
        }
        addContainer(pool) {
          if (pool._poolHandle !== -1) return;
          pool._poolHandle = this._pools.length;
          this._pools.push(pool);
        }
        removeContainer(pool) {
          if (pool._poolHandle === -1) return;
          this._pools[this._pools.length - 1]._poolHandle = pool._poolHandle;
          fastRemoveAt$2(this._pools, pool._poolHandle);
          pool._poolHandle = -1;
        }
        tryShrink() {
          for (let i = 0; i < this._pools.length; i++) {
            this._pools[i].tryShrink();
          }
        }
        update(dt) {
          this._lastShrinkPassed += dt;
          if (this._lastShrinkPassed > this.shrinkTimeSpan) {
            this.tryShrink();
            this._lastShrinkPassed -= this.shrinkTimeSpan;
          }
        }
      }
      const scalableContainerManager = new ScalableContainerManager();

      class Pool extends ScalableContainer {
        constructor(ctor, elementsPerBatch, dtor, shrinkThreshold) {
          super();
          this._freePool = [];
          this._ctor = ctor;
          this._dtor = dtor || null;
          this._elementsPerBatch = Math.max(elementsPerBatch, 1);
          this._shrinkThreshold = shrinkThreshold ? max$b(shrinkThreshold, 1) : this._elementsPerBatch;
          this._nextAvail = this._elementsPerBatch - 1;
          for (let i = 0; i < this._elementsPerBatch; ++i) {
            this._freePool.push(ctor());
          }
        }
        alloc() {
          if (this._nextAvail < 0) {
            this._freePool.length = this._elementsPerBatch;
            for (let i = 0; i < this._elementsPerBatch; i++) {
              this._freePool[i] = this._ctor();
            }
            this._nextAvail = this._elementsPerBatch - 1;
          }
          return this._freePool[this._nextAvail--];
        }
        free(obj) {
          this._freePool[++this._nextAvail] = obj;
        }
        freeArray(objs) {
          this._freePool.length = this._nextAvail + 1;
          Array.prototype.push.apply(this._freePool, objs);
          this._nextAvail += objs.length;
        }
        tryShrink() {
          const freeObjectNumber = this._nextAvail + 1;
          if (freeObjectNumber <= this._shrinkThreshold) {
            return;
          }
          let objectNumberToShrink = 0;
          if (freeObjectNumber >> 1 >= this._shrinkThreshold) {
            objectNumberToShrink = freeObjectNumber >> 1;
          } else {
            objectNumberToShrink = Math.floor((freeObjectNumber - this._shrinkThreshold + 1) / 2);
          }
          if (this._dtor) {
            for (let i = this._nextAvail - objectNumberToShrink + 1; i <= this._nextAvail; ++i) {
              this._dtor(this._freePool[i]);
            }
          }
          this._nextAvail -= objectNumberToShrink;
          this._freePool.length = this._nextAvail + 1;
        }
        destroy() {
          const dtor = arguments.length > 0 ? arguments[0] : null;
          if (dtor) {
            warnID(14100);
          }
          const readDtor = dtor || this._dtor;
          if (readDtor) {
            for (let i = 0; i <= this._nextAvail; i++) {
              readDtor(this._freePool[i]);
            }
          }
          this._freePool.length = 0;
          this._nextAvail = -1;
          super.destroy();
        }
      } exports("Pool", Pool);

      class RecyclePool extends ScalableContainer {
        constructor(fn, size, dtor) {
          super();
          this._count = 0;
          this._fn = fn;
          this._dtor = dtor || null;
          this._data = new Array(size);
          this._initSize = size;
          for (let i = 0; i < size; ++i) {
            this._data[i] = fn();
          }
        }
        get length() {
          return this._count;
        }
        get data() {
          return this._data;
        }
        reset() {
          this._count = 0;
        }
        resize(size) {
          if (size > this._data.length) {
            for (let i = this._data.length; i < size; ++i) {
              this._data[i] = this._fn();
            }
          }
        }
        add() {
          if (this._count >= this._data.length) {
            this.resize(this._data.length << 1);
          }
          return this._data[this._count++];
        }
        destroy() {
          if (this._dtor) {
            for (let i = 0; i < this._data.length; i++) {
              this._dtor(this._data[i]);
            }
          }
          this._data.length = 0;
          this._count = 0;
          super.destroy();
        }
        tryShrink() {
          if (this._data.length >> 2 > this._count) {
            const length = Math.max(this._initSize, this._data.length >> 1);
            if (this._dtor) {
              for (let i = length; i < this._data.length; i++) {
                this._dtor(this._data[i]);
              }
            }
            this._data.length = length;
          }
        }
        removeAt(idx) {
          if (idx >= this._count) {
            return;
          }
          const last = this._count - 1;
          const tmp = this._data[idx];
          this._data[idx] = this._data[last];
          this._data[last] = tmp;
          this._count -= 1;
        }
      } exports("RecyclePool", RecyclePool);

      class CachedArray extends ScalableContainer {
        constructor(length, compareFn) {
          super();
          this.length = 0;
          this._initSize = 0;
          this.array = new Array(length);
          this._initSize = length;
          this._compareFn = compareFn;
        }
        push(item) {
          this.array[this.length++] = item;
        }
        pop() {
          return this.array[--this.length];
        }
        get(idx) {
          return this.array[idx];
        }
        clear() {
          this.length = 0;
        }
        destroy() {
          this.length = 0;
          this.array.length = 0;
          super.destroy();
        }
        tryShrink() {
          if (this.array.length >> 2 > this.length) {
            this.array.length = Math.max(this._initSize, this.array.length >> 1);
          }
        }
        sort() {
          this.array.length = this.length;
          this.array.sort(this._compareFn);
        }
        concat(array) {
          for (let i = 0; i < array.length; ++i) {
            this.array[this.length++] = array[i];
          }
        }
        fastRemove(idx) {
          if (idx >= this.length || idx < 0) {
            return;
          }
          const last = --this.length;
          this.array[idx] = this.array[last];
        }
        indexOf(val) {
          for (let i = 0, len = this.length; i < len; ++i) {
            if (this.array[i] === val) {
              return i;
            }
          }
          return -1;
        }
      } exports("CachedArray", CachedArray);

      var index$4 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CachedArray: CachedArray,
        Pool: Pool,
        RecyclePool: RecyclePool
      });
      exports("memop", index$4);

      const editorExtrasTag = exports("editorExtrasTag", '__editorExtras__');

      const Destroyed$2 = 1 << 0;
      const ToDestroy = 1 << 2;
      const DontSave$1 = 1 << 3;
      const EditorOnly = 1 << 4;
      const Dirty = 1 << 5;
      const DontDestroy = 1 << 6;
      const Destroying$1 = 1 << 7;
      const Deactivating$1 = 1 << 8;
      const LockedInEditor = 1 << 9;
      const HideInHierarchy$1 = 1 << 10;
      const IsOnEnableCalled$2 = 1 << 11;
      const IsEditorOnEnableCalled = 1 << 12;
      const IsPreloadStarted$1 = 1 << 13;
      const IsOnLoadCalled$2 = 1 << 14;
      const IsOnLoadStarted$1 = 1 << 15;
      const IsStartCalled$1 = 1 << 16;
      const IsRotationLocked = 1 << 17;
      const IsScaleLocked = 1 << 18;
      const IsAnchorLocked = 1 << 19;
      const IsSizeLocked = 1 << 20;
      const IsPositionLocked = 1 << 21;
      const PersistentMask$2 = ~(ToDestroy | Dirty | Destroying$1 | DontDestroy | Deactivating$1 | IsPreloadStarted$1 | IsOnLoadStarted$1 | IsOnLoadCalled$2 | IsStartCalled$1 | IsOnEnableCalled$2 | IsEditorOnEnableCalled | IsRotationLocked | IsScaleLocked | IsAnchorLocked | IsSizeLocked | IsPositionLocked);
      const AllHideMasks = DontSave$1 | EditorOnly | LockedInEditor | HideInHierarchy$1;
      const objectsToDestroy = [];
      function compileDestruct(obj, ctor) {
        const shouldSkipId = obj instanceof legacyCC.Node || obj instanceof legacyCC.Component;
        const idToSkip = shouldSkipId ? '_id' : null;
        let key;
        const propsToReset = {};
        for (key in obj) {
          if (obj.hasOwnProperty(key)) {
            if (key === idToSkip) {
              continue;
            }
            switch (typeof obj[key]) {
              case 'string':
                propsToReset[key] = '';
                break;
              case 'object':
              case 'function':
                propsToReset[key] = null;
                break;
            }
          }
        }
        if (CCClass._isCCClass(ctor)) {
          const attrs = legacyCC.Class.Attr.getClassAttrs(ctor);
          const propList = ctor.__props__;
          for (let i = 0; i < propList.length; i++) {
            key = propList[i];
            const attrKey = `${key}`;
            if (attrKey in attrs) {
              if (shouldSkipId && key === '_id') {
                continue;
              }
              switch (typeof attrs[attrKey]) {
                case 'string':
                  propsToReset[key] = '';
                  break;
                case 'object':
                case 'function':
                  propsToReset[key] = null;
                  break;
                case 'undefined':
                  propsToReset[key] = undefined;
                  break;
              }
            }
          }
        }
        {
          let func = '';
          for (key in propsToReset) {
            let statement;
            if (CCClass.IDENTIFIER_RE.test(key)) {
              statement = `o.${key}=`;
            } else {
              statement = `o[${CCClass.escapeForJS(key)}]=`;
            }
            let val = propsToReset[key];
            if (val === '') {
              val = '""';
            }
            func += `${statement + val};\n`;
          }
          return Function('o', func);
        }
      }
      class CCObject {
        static _deferredDestroy() {
          const deleteCount = objectsToDestroy.length;
          for (let i = 0; i < deleteCount; ++i) {
            const obj = objectsToDestroy[i];
            if (!(obj._objFlags & Destroyed$2)) {
              obj._destroyImmediate();
            }
          }
          if (deleteCount === objectsToDestroy.length) {
            objectsToDestroy.length = 0;
          } else {
            objectsToDestroy.splice(0, deleteCount);
          }
        }
        constructor(name = '') {
          this._objFlags = 0;
          this._name = name;
        }
        get name() {
          return this._name;
        }
        set name(value) {
          this._name = value;
        }
        set hideFlags(hideFlags) {
          const flags = hideFlags & CCObject.Flags.AllHideMasks;
          this._objFlags = this._objFlags & ~CCObject.Flags.AllHideMasks | flags;
        }
        get hideFlags() {
          return this._objFlags & CCObject.Flags.AllHideMasks;
        }
        get isValid() {
          return !(this._objFlags & Destroyed$2);
        }
        destroy() {
          if (this._objFlags & Destroyed$2) {
            warnID(5000);
            return false;
          }
          if (this._objFlags & ToDestroy) {
            return false;
          }
          this._objFlags |= ToDestroy;
          objectsToDestroy.push(this);
          {
            this._destroy();
          }
          return true;
        }
        _destruct() {
          const ctor = this.constructor;
          let destruct;
          if (Object.prototype.hasOwnProperty.call(ctor, '__destruct__')) {
            destruct = ctor.__destruct__;
          } else {
            destruct = compileDestruct(this, ctor);
            value(ctor, '__destruct__', destruct, true);
          }
          destruct(this);
        }
        _destroyImmediate() {
          var _onPreDestroy, _ref;
          if (this._objFlags & Destroyed$2) {
            errorID(5000);
            return;
          }
          (_onPreDestroy = (_ref = this)._onPreDestroy) === null || _onPreDestroy === void 0 ? void 0 : _onPreDestroy.call(_ref);
          {
            if (this.destruct) {
              this.destruct();
            }
            this._destruct();
          }
          this._objFlags |= Destroyed$2;
        }
      } exports("CCObject", CCObject);
      const prototype = CCObject.prototype;
      prototype._deserialize = null;
      {
        CCClass.fastDefine('cc.Object', CCObject, {
          _name: '',
          _objFlags: 0
        });
      }
      value(CCObject, 'Flags', {
        Destroyed: Destroyed$2,
        DontSave: DontSave$1,
        EditorOnly,
        Dirty,
        DontDestroy,
        PersistentMask: PersistentMask$2,
        Destroying: Destroying$1,
        Deactivating: Deactivating$1,
        LockedInEditor,
        HideInHierarchy: HideInHierarchy$1,
        AllHideMasks,
        IsPreloadStarted: IsPreloadStarted$1,
        IsOnLoadStarted: IsOnLoadStarted$1,
        IsOnLoadCalled: IsOnLoadCalled$2,
        IsOnEnableCalled: IsOnEnableCalled$2,
        IsStartCalled: IsStartCalled$1,
        IsEditorOnEnableCalled,
        IsPositionLocked,
        IsRotationLocked,
        IsScaleLocked,
        IsAnchorLocked,
        IsSizeLocked
      });
      function isCCObject(object) {
        return object instanceof CCObject;
      }
      function isValid(value, strictMode) {
        if (typeof value === 'object') {
          return !!value && !(value._objFlags & (strictMode ? Destroyed$2 | ToDestroy : Destroyed$2));
        } else {
          return typeof value !== 'undefined';
        }
      }
      legacyCC.isValid = isValid;
      {
        copyAllProperties(CCObject, jsb.CCObject, ['prototype', 'length', 'name']);
        copyAllProperties(CCObject.prototype, jsb.CCObject.prototype, ['constructor', 'name', 'hideFlags', 'isValid']);
        exports("CCObject", CCObject = jsb.CCObject);
      }
      legacyCC.Object = CCObject;

      const fastRemoveAt$1 = fastRemoveAt$2;
      function empty() {}
      class CallbackInfo {
        constructor() {
          this.callback = empty;
          this.target = undefined;
          this.once = false;
        }
        set(callback, target, once) {
          this.callback = callback || empty;
          this.target = target;
          this.once = !!once;
        }
        reset() {
          this.target = undefined;
          this.callback = empty;
          this.once = false;
        }
        check() {
          if (isCCObject(this.target) && !isValid(this.target, true)) {
            return false;
          } else {
            return true;
          }
        }
      }
      const callbackInfoPool = new Pool(() => new CallbackInfo(), 32);
      class CallbackList {
        constructor() {
          this.callbackInfos = [];
          this.isInvoking = false;
          this.containCanceled = false;
        }
        removeByCallback(cb) {
          for (let i = 0; i < this.callbackInfos.length; ++i) {
            const info = this.callbackInfos[i];
            if (info && info.callback === cb) {
              info.reset();
              callbackInfoPool.free(info);
              fastRemoveAt$1(this.callbackInfos, i);
              --i;
            }
          }
        }
        removeByTarget(target) {
          for (let i = 0; i < this.callbackInfos.length; ++i) {
            const info = this.callbackInfos[i];
            if (info && info.target === target) {
              info.reset();
              callbackInfoPool.free(info);
              fastRemoveAt$1(this.callbackInfos, i);
              --i;
            }
          }
        }
        cancel(index) {
          const info = this.callbackInfos[index];
          if (info) {
            info.reset();
            if (this.isInvoking) {
              this.callbackInfos[index] = null;
            } else {
              fastRemoveAt$1(this.callbackInfos, index);
            }
            callbackInfoPool.free(info);
          }
          this.containCanceled = true;
        }
        cancelAll() {
          for (let i = 0; i < this.callbackInfos.length; i++) {
            const info = this.callbackInfos[i];
            if (info) {
              info.reset();
              callbackInfoPool.free(info);
              this.callbackInfos[i] = null;
            }
          }
          this.containCanceled = true;
        }
        purgeCanceled() {
          for (let i = this.callbackInfos.length - 1; i >= 0; --i) {
            const info = this.callbackInfos[i];
            if (!info) {
              fastRemoveAt$1(this.callbackInfos, i);
            }
          }
          this.containCanceled = false;
        }
        clear() {
          this.cancelAll();
          this.callbackInfos.length = 0;
          this.isInvoking = false;
          this.containCanceled = false;
        }
      }
      const MAX_SIZE$1 = 16;
      const callbackListPool = new Pool(() => new CallbackList(), MAX_SIZE$1);
      class CallbacksInvoker {
        constructor() {
          this._callbackTable = createMap(true);
          this._offCallback = void 0;
        }
        on(key, callback, target, once) {
          if (!this.hasEventListener(key, callback, target)) {
            let list = this._callbackTable[key];
            if (!list) {
              list = this._callbackTable[key] = callbackListPool.alloc();
            }
            const info = callbackInfoPool.alloc();
            info.set(callback, target, once);
            list.callbackInfos.push(info);
          }
          return callback;
        }
        hasEventListener(key, callback, target) {
          const list = this._callbackTable && this._callbackTable[key];
          if (!list) {
            return false;
          }
          const infos = list.callbackInfos;
          if (!callback) {
            if (list.isInvoking) {
              for (let i = 0; i < infos.length; ++i) {
                if (infos[i]) {
                  return true;
                }
              }
              return false;
            } else {
              return infos.length > 0;
            }
          }
          for (let i = 0; i < infos.length; ++i) {
            const info = infos[i];
            if (info && info.check() && info.callback === callback && info.target === target) {
              return true;
            }
          }
          return false;
        }
        removeAll(keyOrTarget) {
          const type = typeof keyOrTarget;
          if (type === 'string' || type === 'number') {
            const list = this._callbackTable && this._callbackTable[keyOrTarget];
            if (list) {
              if (list.isInvoking) {
                list.cancelAll();
              } else {
                list.clear();
                callbackListPool.free(list);
                delete this._callbackTable[keyOrTarget];
              }
            }
          } else if (keyOrTarget) {
            for (const key in this._callbackTable) {
              const list = this._callbackTable[key];
              if (list.isInvoking) {
                const infos = list.callbackInfos;
                for (let i = 0; i < infos.length; ++i) {
                  const info = infos[i];
                  if (info && info.target === keyOrTarget) {
                    list.cancel(i);
                  }
                }
              } else {
                list.removeByTarget(keyOrTarget);
              }
            }
          }
        }
        off(key, callback, target) {
          var _this$_offCallback;
          const list = this._callbackTable && this._callbackTable[key];
          if (list) {
            const infos = list.callbackInfos;
            if (callback) {
              for (let i = 0; i < infos.length; ++i) {
                const info = infos[i];
                if (info && info.callback === callback && info.target === target) {
                  list.cancel(i);
                  break;
                }
              }
            } else {
              this.removeAll(key);
            }
          }
          (_this$_offCallback = this._offCallback) === null || _this$_offCallback === void 0 ? void 0 : _this$_offCallback.call(this);
        }
        emit(key, arg0, arg1, arg2, arg3, arg4) {
          const list = this._callbackTable && this._callbackTable[key];
          if (list) {
            const rootInvoker = !list.isInvoking;
            list.isInvoking = true;
            const infos = list.callbackInfos;
            for (let i = 0, len = infos.length; i < len; ++i) {
              const info = infos[i];
              if (info) {
                const callback = info.callback;
                const target = info.target;
                if (info.once) {
                  this.off(key, callback, target);
                }
                if (!info.check()) {
                  this.off(key, callback, target);
                } else if (target) {
                  callback.call(target, arg0, arg1, arg2, arg3, arg4);
                } else {
                  callback(arg0, arg1, arg2, arg3, arg4);
                }
              }
            }
            if (rootInvoker) {
              list.isInvoking = false;
              if (list.containCanceled) {
                list.purgeCanceled();
              }
            }
          }
        }
        clear() {
          for (const key in this._callbackTable) {
            const list = this._callbackTable[key];
            if (list) {
              list.clear();
              callbackListPool.free(list);
              delete this._callbackTable[key];
            }
          }
        }
        _registerOffCallback(cb) {
          this._offCallback = cb;
        }
      } exports("CallbacksInvoker", CallbacksInvoker);

      function Eventify(base) {
        class Eventified extends base {
          constructor(...args) {
            super(...args);
            this._callbackTable = createMap(true);
          }
          once(type, callback, target) {
            return this.on(type, callback, target, true);
          }
          targetOff(typeOrTarget) {
            this.removeAll(typeOrTarget);
          }
        }
        const callbacksInvokerPrototype = CallbacksInvoker.prototype;
        const propertyKeys = Object.getOwnPropertyNames(callbacksInvokerPrototype).concat(Object.getOwnPropertySymbols(callbacksInvokerPrototype));
        for (let iPropertyKey = 0; iPropertyKey < propertyKeys.length; ++iPropertyKey) {
          const propertyKey = propertyKeys[iPropertyKey];
          if (!(propertyKey in Eventified.prototype)) {
            const propertyDescriptor = Object.getOwnPropertyDescriptor(callbacksInvokerPrototype, propertyKey);
            if (propertyDescriptor) {
              Object.defineProperty(Eventified.prototype, propertyKey, propertyDescriptor);
            }
          }
        }
        return Eventified;
      }

      let Empty$1 = class Empty {};
      const EventTarget = exports("EventTarget", Eventify(Empty$1));
      legacyCC.EventTarget = EventTarget;

      class AsyncDelegate {
        constructor() {
          this._delegates = [];
        }
        add(callback) {
          if (!this._delegates.includes(callback)) {
            this._delegates.push(callback);
          }
        }
        hasListener(callback) {
          return this._delegates.includes(callback);
        }
        remove(callback) {
          fastRemove(this._delegates, callback);
        }
        dispatch(...args) {
          return Promise.all(this._delegates.map(func => func(...arguments)).filter(Boolean));
        }
      } exports("AsyncDelegate", AsyncDelegate);

      let BrowserType;
      (function (BrowserType) {
        BrowserType["UNKNOWN"] = "unknown";
        BrowserType["WECHAT"] = "wechat";
        BrowserType["ANDROID"] = "androidbrowser";
        BrowserType["IE"] = "ie";
        BrowserType["EDGE"] = "edge";
        BrowserType["QQ"] = "qqbrowser";
        BrowserType["MOBILE_QQ"] = "mqqbrowser";
        BrowserType["UC"] = "ucbrowser";
        BrowserType["UCBS"] = "ucbs";
        BrowserType["BROWSER_360"] = "360browser";
        BrowserType["BAIDU_APP"] = "baiduboxapp";
        BrowserType["BAIDU"] = "baidubrowser";
        BrowserType["MAXTHON"] = "maxthon";
        BrowserType["OPERA"] = "opera";
        BrowserType["OUPENG"] = "oupeng";
        BrowserType["MIUI"] = "miuibrowser";
        BrowserType["FIREFOX"] = "firefox";
        BrowserType["SAFARI"] = "safari";
        BrowserType["CHROME"] = "chrome";
        BrowserType["LIEBAO"] = "liebao";
        BrowserType["QZONE"] = "qzone";
        BrowserType["SOUGOU"] = "sogou";
        BrowserType["HUAWEI"] = "huawei";
      })(BrowserType || (BrowserType = {}));

      let Language;
      (function (Language) {
        Language["UNKNOWN"] = "unknown";
        Language["ENGLISH"] = "en";
        Language["CHINESE"] = "zh";
        Language["FRENCH"] = "fr";
        Language["ITALIAN"] = "it";
        Language["GERMAN"] = "de";
        Language["SPANISH"] = "es";
        Language["DUTCH"] = "du";
        Language["RUSSIAN"] = "ru";
        Language["KOREAN"] = "ko";
        Language["JAPANESE"] = "ja";
        Language["HUNGARIAN"] = "hu";
        Language["PORTUGUESE"] = "pt";
        Language["ARABIC"] = "ar";
        Language["NORWEGIAN"] = "no";
        Language["POLISH"] = "pl";
        Language["TURKISH"] = "tr";
        Language["UKRAINIAN"] = "uk";
        Language["ROMANIAN"] = "ro";
        Language["BULGARIAN"] = "bg";
        Language["HINDI"] = "hi";
      })(Language || (Language = {}));

      let NetworkType;
      (function (NetworkType) {
        NetworkType[NetworkType["NONE"] = 0] = "NONE";
        NetworkType[NetworkType["LAN"] = 1] = "LAN";
        NetworkType[NetworkType["WWAN"] = 2] = "WWAN";
      })(NetworkType || (NetworkType = {}));

      let OS;
      (function (OS) {
        OS["UNKNOWN"] = "Unknown";
        OS["IOS"] = "iOS";
        OS["ANDROID"] = "Android";
        OS["WINDOWS"] = "Windows";
        OS["LINUX"] = "Linux";
        OS["OSX"] = "OS X";
        OS["OHOS"] = "OHOS";
        OS["OPENHARMONY"] = "OpenHarmony";
      })(OS || (OS = {}));

      let Platform;
      (function (Platform) {
        Platform["UNKNOWN"] = "UNKNOWN";
        Platform["EDITOR_PAGE"] = "EDITOR_PAGE";
        Platform["EDITOR_CORE"] = "EDITOR_CORE";
        Platform["MOBILE_BROWSER"] = "MOBILE_BROWSER";
        Platform["DESKTOP_BROWSER"] = "DESKTOP_BROWSER";
        Platform["WIN32"] = "WIN32";
        Platform["ANDROID"] = "ANDROID";
        Platform["IOS"] = "IOS";
        Platform["MACOS"] = "MACOS";
        Platform["OHOS"] = "OHOS";
        Platform["OPENHARMONY"] = "OPENHARMONY";
        Platform["WECHAT_GAME"] = "WECHAT_GAME";
        Platform["WECHAT_MINI_PROGRAM"] = "WECHAT_MINI_PROGRAM";
        Platform["BAIDU_MINI_GAME"] = "BAIDU_MINI_GAME";
        Platform["XIAOMI_QUICK_GAME"] = "XIAOMI_QUICK_GAME";
        Platform["ALIPAY_MINI_GAME"] = "ALIPAY_MINI_GAME";
        Platform["TAOBAO_CREATIVE_APP"] = "TAOBAO_CREATIVE_APP";
        Platform["TAOBAO_MINI_GAME"] = "TAOBAO_MINI_GAME";
        Platform["BYTEDANCE_MINI_GAME"] = "BYTEDANCE_MINI_GAME";
        Platform["OPPO_MINI_GAME"] = "OPPO_MINI_GAME";
        Platform["VIVO_MINI_GAME"] = "VIVO_MINI_GAME";
        Platform["HUAWEI_QUICK_GAME"] = "HUAWEI_QUICK_GAME";
        Platform["COCOSPLAY"] = "COCOSPLAY";
        Platform["LINKSURE_MINI_GAME"] = "LINKSURE_MINI_GAME";
        Platform["QTT_MINI_GAME"] = "QTT_MINI_GAME";
        Platform["MIGU_MINI_GAME"] = "MIGU_MINI_GAME";
      })(Platform || (Platform = {}));

      let Feature$1;
      (function (Feature) {
        Feature["WEBP"] = "WEBP";
        Feature["IMAGE_BITMAP"] = "IMAGE_BITMAP";
        Feature["WEB_VIEW"] = "WEB_VIEW";
        Feature["VIDEO_PLAYER"] = "VIDEO_PLAYER";
        Feature["SAFE_AREA"] = "SAFE_AREA";
        Feature["HPE"] = "HPE";
        Feature["INPUT_TOUCH"] = "INPUT_TOUCH";
        Feature["EVENT_KEYBOARD"] = "EVENT_KEYBOARD";
        Feature["EVENT_MOUSE"] = "EVENT_MOUSE";
        Feature["EVENT_TOUCH"] = "EVENT_TOUCH";
        Feature["EVENT_ACCELEROMETER"] = "EVENT_ACCELEROMETER";
        Feature["EVENT_GAMEPAD"] = "EVENT_GAMEPAD";
        Feature["EVENT_HANDLE"] = "EVENT_HANDLE";
        Feature["EVENT_HMD"] = "EVENT_HMD";
        Feature["EVENT_HANDHELD"] = "EVENT_HANDHELD";
        Feature["WASM"] = "WASM";
      })(Feature$1 || (Feature$1 = {}));

      const networkTypeMap = {
        0: NetworkType.NONE,
        1: NetworkType.LAN,
        2: NetworkType.WWAN
      };
      const platformMap = {
        0: Platform.WIN32,
        2: Platform.MACOS,
        3: Platform.ANDROID,
        4: Platform.IOS,
        5: Platform.IOS,
        6: Platform.OHOS,
        7: Platform.OPENHARMONY
      };
      class SystemInfo extends EventTarget {
        get networkType() {
          return networkTypeMap[jsb.device.getNetworkType()];
        }
        constructor() {
          super();
          this._initPromise = [];
          this.isNative = true;
          this.isBrowser = false;
          this.platform = platformMap[__getPlatform()];
          this.isMobile = this.platform === Platform.ANDROID || this.platform === Platform.IOS || this.platform === Platform.OHOS || this.platform === Platform.OPENHARMONY;
          this.isLittleEndian = (() => {
            const buffer = new ArrayBuffer(2);
            new DataView(buffer).setInt16(0, 256, true);
            return new Int16Array(buffer)[0] === 256;
          })();
          const currLanguage = __getCurrentLanguageCode();
          this.nativeLanguage = currLanguage ? currLanguage.toLowerCase() : Language.UNKNOWN;
          this.language = __getCurrentLanguage();
          this.os = __getOS();
          this.osVersion = __getOSVersion();
          this.osMainVersion = parseInt(this.osVersion);
          this.browserType = BrowserType.UNKNOWN;
          this.browserVersion = '';
          this.isXR = typeof xr !== 'undefined' && typeof xr.XrEntry !== 'undefined';
          const isHPE = typeof __supportHPE === 'function' ? __supportHPE() : false;
          this._featureMap = {
            [Feature$1.WEBP]: true,
            [Feature$1.IMAGE_BITMAP]: false,
            [Feature$1.WEB_VIEW]: this.isMobile,
            [Feature$1.VIDEO_PLAYER]: this.isMobile,
            [Feature$1.SAFE_AREA]: this.isMobile,
            [Feature$1.HPE]: isHPE,
            [Feature$1.INPUT_TOUCH]: this.isMobile,
            [Feature$1.EVENT_KEYBOARD]: true,
            [Feature$1.EVENT_MOUSE]: isHPE || !this.isMobile,
            [Feature$1.EVENT_TOUCH]: true,
            [Feature$1.EVENT_ACCELEROMETER]: this.isMobile,
            [Feature$1.EVENT_GAMEPAD]: true,
            [Feature$1.EVENT_HANDLE]: this.isXR,
            [Feature$1.EVENT_HMD]: this.isXR,
            [Feature$1.EVENT_HANDHELD]: typeof xr !== 'undefined' && typeof xr.ARModule !== 'undefined',
            [Feature$1.WASM]: !OPEN_HARMONY
          };
          this._registerEvent();
        }
        _registerEvent() {
          jsb.onPause = () => {
            this.emit('hide');
          };
          jsb.onResume = () => {
            this.emit('show');
          };
          jsb.onClose = () => {
            this.emit('close');
          };
        }
        _setFeature(feature, value) {
          return this._featureMap[feature] = value;
        }
        init() {
          return Promise.all(this._initPromise);
        }
        hasFeature(feature) {
          return this._featureMap[feature];
        }
        getBatteryLevel() {
          return jsb.device.getBatteryLevel();
        }
        triggerGC() {
          jsb.garbageCollect();
        }
        openURL(url) {
          jsb.openURL(url);
        }
        now() {
          if (Date.now) {
            return Date.now();
          }
          return +new Date();
        }
        restartJSVM() {
          __restartVM();
        }
        close() {
          __close();
        }
        exit() {
          __exit();
        }
      }
      const systemInfo = new SystemInfo();

      const EXTNAME_RE = /(\.[^\.\/\?\\]*)(\?.*)?$/;
      const DIRNAME_RE = /((.*)(\/|\\|\\\\))?(.*?\..*$)?/;
      const NORMALIZE_RE = /[^\.\/]+\/\.\.\//;
      function join(...segments) {
        let result = '';
        for (const segment of segments) {
          result = (result + (result === '' ? '' : '/') + segment).replace(/(\/|\\\\)$/, '');
        }
        return result;
      }
      function extname(path) {
        const temp = EXTNAME_RE.exec(path);
        return temp ? temp[1] : '';
      }
      function mainFileName(fileName) {
        if (fileName) {
          const idx = fileName.lastIndexOf('.');
          if (idx !== -1) {
            return fileName.substring(0, idx);
          }
        }
        return fileName;
      }
      function basename(path, extName) {
        const index = path.indexOf('?');
        if (index > 0) {
          path = path.substring(0, index);
        }
        const reg = /(\/|\\)([^\/\\]+)$/g;
        const result = reg.exec(path.replace(/(\/|\\)$/, ''));
        if (!result) {
          return path;
        }
        const baseName = result[2];
        if (extName && path.substring(path.length - extName.length).toLowerCase() === extName.toLowerCase()) {
          return baseName.substring(0, baseName.length - extName.length);
        }
        return baseName;
      }
      function dirname(path) {
        const temp = DIRNAME_RE.exec(path);
        return temp ? temp[2] : '';
      }
      function changeExtname(path, extName) {
        extName = extName || '';
        let index = path.indexOf('?');
        let tempStr = '';
        if (index > 0) {
          tempStr = path.substring(index);
          path = path.substring(0, index);
        }
        index = path.lastIndexOf('.');
        if (index < 0) {
          return path + extName + tempStr;
        }
        return path.substring(0, index) + extName + tempStr;
      }
      function changeBasename(path, newBaseName, keepExt) {
        if (newBaseName.indexOf('.') === 0) {
          return changeExtname(path, newBaseName);
        }
        let index = path.indexOf('?');
        let tempStr = '';
        const ext = keepExt ? extname(path) : '';
        if (index > 0) {
          tempStr = path.substring(index);
          path = path.substring(0, index);
        }
        index = path.lastIndexOf('/');
        index = index <= 0 ? 0 : index + 1;
        return path.substring(0, index) + newBaseName + ext + tempStr;
      }
      function _normalize(url) {
        let oldUrl = url = String(url);
        do {
          oldUrl = url;
          url = url.replace(NORMALIZE_RE, '');
        } while (oldUrl.length !== url.length);
        return url;
      }
      function stripSep(path) {
        return path.replace(/[\/\\]$/, '');
      }
      function getSeperator() {
        return systemInfo.os === OS.WINDOWS ? '\\' : '/';
      }

      var path = /*#__PURE__*/Object.freeze({
        __proto__: null,
        _normalize: _normalize,
        basename: basename,
        changeBasename: changeBasename,
        changeExtname: changeExtname,
        dirname: dirname,
        extname: extname,
        getSeperator: getSeperator,
        join: join,
        mainFileName: mainFileName,
        stripSep: stripSep
      });
      exports("path", path);

      const _vec3 = new Vec3();
      function WorldNode3DToLocalNodeUI(mainCamera, wpos, uiNode, out) {
        if (!out) {
          out = new Vec3();
        }
        mainCamera.convertToUINode(wpos, uiNode, out);
        const pos = uiNode.position;
        out.add(pos);
        return out;
      }
      function WorldNode3DToWorldNodeUI(mainCamera, wpos, out) {
        if (!out) {
          out = new Vec3();
        }
        mainCamera.worldToScreen(wpos, out);
        out.x /= legacyCC.view.getScaleX();
        out.y /= legacyCC.view.getScaleY();
        return out;
      }
      const convertUtils = exports("convertUtils", {
        WorldNode3DToLocalNodeUI,
        WorldNode3DToWorldNodeUI
      });
      legacyCC.pipelineUtils = convertUtils;
      replaceProperty(legacyCC.pipelineUtils, 'cc.pipelineUtils', [{
        name: 'WorldNode3DToLocalNodeUI',
        newName: 'convertToUINode',
        targetName: 'cc.Camera.prototype',
        customFunction(...args) {
          const camera = args[0];
          const out = args[3] || _vec3;
          camera.convertToUINode(args[1], args[2], out);
          out.add(args[2].position);
          return args[3] || out.clone();
        }
      }]);

      const orientationMap$1 = {
        0: Orientation$1.PORTRAIT,
        '-90': Orientation$1.LANDSCAPE_LEFT,
        90: Orientation$1.LANDSCAPE_RIGHT,
        180: Orientation$1.PORTRAIT_UPSIDE_DOWN
      };
      class ScreenAdapter extends EventTarget {
        get supportFullScreen() {
          return false;
        }
        get isFullScreen() {
          return false;
        }
        get devicePixelRatio() {
          return jsb.device.getDevicePixelRatio() || 1;
        }
        get windowSize() {
          const dpr = this.devicePixelRatio;
          const width = jsb.window.innerWidth;
          const height = jsb.window.innerHeight;
          const roundWidth = Math.round(width);
          const roundHeight = Math.round(height);
          return new Size$1(roundWidth * dpr, roundHeight * dpr);
        }
        set windowSize(size) {
          warn('Setting window size is not supported yet.');
        }
        get resolution() {
          const windowSize = this.windowSize;
          const resolutionScale = this.resolutionScale;
          return new Size$1(windowSize.width * resolutionScale, windowSize.height * resolutionScale);
        }
        get resolutionScale() {
          return this._resolutionScale;
        }
        set resolutionScale(v) {
          var _this$_cbToUpdateFram;
          if (v === this._resolutionScale) {
            return;
          }
          this._resolutionScale = v;
          (_this$_cbToUpdateFram = this._cbToUpdateFrameBuffer) === null || _this$_cbToUpdateFram === void 0 ? void 0 : _this$_cbToUpdateFram.call(this);
        }
        get orientation() {
          return orientationMap$1[jsb.device.getDeviceOrientation()];
        }
        set orientation(value) {
          warnID(1221);
        }
        get safeAreaEdge() {
          const nativeSafeArea = jsb.device.getSafeAreaEdge();
          const dpr = this.devicePixelRatio;
          const topEdge = nativeSafeArea.x * dpr;
          const bottomEdge = nativeSafeArea.z * dpr;
          const leftEdge = nativeSafeArea.y * dpr;
          const rightEdge = nativeSafeArea.w * dpr;
          return {
            top: topEdge,
            bottom: bottomEdge,
            left: leftEdge,
            right: rightEdge
          };
        }
        get isProportionalToFrame() {
          return this._isProportionalToFrame;
        }
        set isProportionalToFrame(v) {}
        constructor() {
          super();
          this.isFrameRotated = false;
          this.handleResizeEvent = true;
          this._cbToUpdateFrameBuffer = void 0;
          this._resolutionScale = 1;
          this._isProportionalToFrame = false;
          this._registerEvent();
        }
        init(options, cbToRebuildFrameBuffer) {
          this._cbToUpdateFrameBuffer = cbToRebuildFrameBuffer;
          {
            this._cbToUpdateFrameBuffer();
          }
        }
        requestFullScreen() {
          return Promise.reject(new Error('request fullscreen has not been supported yet on this platform.'));
        }
        exitFullScreen() {
          return Promise.reject(new Error('exit fullscreen has not been supported yet on this platform.'));
        }
        _registerEvent() {
          jsb.onResize = event => {
            if (event.width === 0 || event.height === 0) return;
            window.resize(event.width / this.devicePixelRatio, event.height / this.devicePixelRatio);
            this.emit('window-resize', event.width, event.height, event.windowId);
          };
          jsb.onOrientationChanged = event => {
            this.emit('orientation-change', this.orientation);
          };
        }
      }
      const screenAdapter = new ScreenAdapter();

      class Screen {
        init() {
          var _settings$querySettin, _settings$querySettin2;
          const exactFitScreen = (_settings$querySettin = settings.querySettings("screen", 'exactFitScreen')) !== null && _settings$querySettin !== void 0 ? _settings$querySettin : true;
          const orientation = (_settings$querySettin2 = settings.querySettings("screen", 'orientation')) !== null && _settings$querySettin2 !== void 0 ? _settings$querySettin2 : 'auto';
          const isHeadlessMode = settings.querySettings("rendering", 'renderMode') === 3;
          screenAdapter.init({
            exactFitScreen,
            configOrientation: orientation,
            isHeadlessMode
          }, () => {
            var _director$root;
            const director = legacyCC.director;
            if (!((_director$root = director.root) !== null && _director$root !== void 0 && _director$root.pipeline)) {
              warnID(1220);
              return;
            }
            director.root.pipeline.shadingScale = screenAdapter.resolutionScale;
          });
        }
        get devicePixelRatio() {
          return screenAdapter.devicePixelRatio;
        }
        get windowSize() {
          return screenAdapter.windowSize;
        }
        set windowSize(size) {
          screenAdapter.windowSize = size;
        }
        get resolution() {
          return screenAdapter.resolution;
        }
        get supportsFullScreen() {
          return screenAdapter.supportFullScreen;
        }
        fullScreen() {
          return screenAdapter.isFullScreen;
        }
        requestFullScreen(element, onFullScreenChange, onFullScreenError) {
          if (arguments.length > 0) {
            warnID(1400, 'screen.requestFullScreen(element, onFullScreenChange?, onFullScreenError?)', 'screen.requestFullScreen(): Promise');
          }
          return screenAdapter.requestFullScreen().then(() => {
            onFullScreenChange === null || onFullScreenChange === void 0 ? void 0 : onFullScreenChange.call(document);
          }).catch(err => {
            error(err);
            onFullScreenError === null || onFullScreenError === void 0 ? void 0 : onFullScreenError.call(document);
          });
        }
        exitFullScreen() {
          return screenAdapter.exitFullScreen();
        }
        autoFullScreen(element, onFullScreenChange) {
          var _this$requestFullScre;
          (_this$requestFullScre = this.requestFullScreen(element, onFullScreenChange)) === null || _this$requestFullScre === void 0 ? void 0 : _this$requestFullScre.catch(e => {
            warn(e);
          });
        }
        disableAutoFullScreen(element) {}
        on(type, callback, target) {
          screenAdapter.on(type, callback, target);
        }
        once(type, callback, target) {
          screenAdapter.once(type, callback, target);
        }
        off(type, callback, target) {
          screenAdapter.off(type, callback, target);
        }
      }
      const screen = exports("screen", new Screen());
      legacyCC.screen = screen;

      const sys = exports("sys", {
        Feature: Feature$1,
        hasFeature(feature) {
          return systemInfo.hasFeature(feature);
        },
        NetworkType,
        Language,
        OS,
        Platform,
        BrowserType,
        isNative: systemInfo.isNative,
        isBrowser: systemInfo.isBrowser,
        isMobile: systemInfo.isMobile,
        isLittleEndian: systemInfo.isLittleEndian,
        platform: systemInfo.platform,
        language: systemInfo.language,
        languageCode: systemInfo.nativeLanguage,
        os: systemInfo.os,
        osVersion: systemInfo.osVersion,
        osMainVersion: systemInfo.osMainVersion,
        browserType: systemInfo.browserType,
        browserVersion: systemInfo.browserVersion,
        isXR: systemInfo.isXR,
        windowPixelResolution: screen.windowSize,
        capabilities: {
          canvas: true,
          opengl: true,
          webp: systemInfo.hasFeature(Feature$1.WEBP),
          imageBitmap: systemInfo.hasFeature(Feature$1.IMAGE_BITMAP),
          touches: systemInfo.hasFeature(Feature$1.INPUT_TOUCH),
          mouse: systemInfo.hasFeature(Feature$1.EVENT_MOUSE),
          keyboard: systemInfo.hasFeature(Feature$1.EVENT_KEYBOARD),
          accelerometer: systemInfo.hasFeature(Feature$1.EVENT_ACCELEROMETER)
        },
        localStorage: {},
        getNetworkType() {
          return systemInfo.networkType;
        },
        getBatteryLevel() {
          return systemInfo.getBatteryLevel();
        },
        garbageCollect() {
          systemInfo.triggerGC();
        },
        isObjectValid(obj) {
          if (obj === null || obj === undefined) {
            return false;
          }
          return true;
        },
        __isWebIOS14OrIPadOS14Env: false,
        dump() {
          let str = '';
          str += `isMobile : ${this.isMobile}\r\n`;
          str += `language : ${this.language}\r\n`;
          str += `browserType : ${this.browserType}\r\n`;
          str += `browserVersion : ${this.browserVersion}\r\n`;
          str += `supports webp: ${sys.hasFeature(Feature$1.WEBP)}\r\n`;
          str += `supports bitmap: ${sys.hasFeature(Feature$1.IMAGE_BITMAP)}\r\n`;
          str += `supports touches: ${sys.hasFeature(Feature$1.INPUT_TOUCH)}\r\n`;
          str += `supports mouse: ${sys.hasFeature(Feature$1.EVENT_MOUSE)}\r\n`;
          str += `supports keyboard: ${sys.hasFeature(Feature$1.EVENT_KEYBOARD)}\r\n`;
          str += `supports accelerometer: ${sys.hasFeature(Feature$1.EVENT_ACCELEROMETER)}\r\n`;
          str += `os : ${this.os}\r\n`;
          str += `osVersion : ${this.osVersion}\r\n`;
          str += `platform : ${this.platform}\r\n`;
          str += `Using ${legacyCC.game.renderType === legacyCC.game.RENDER_TYPE_WEBGL ? 'WEBGL' : 'CANVAS'} renderer.\r\n`;
          log(str);
        },
        openURL(url) {
          systemInfo.openURL(url);
        },
        init() {
          return Promise.resolve().then(() => systemInfo.init()).then(() => {
            try {
              let localStorage = sys.localStorage = window.localStorage;
              localStorage.setItem('storage', '');
              localStorage.removeItem('storage');
              localStorage = null;
            } catch (e) {
              const warn = function warn(...args) {
                warnID(5200);
              };
              this.localStorage = {
                getItem: warn,
                setItem: warn,
                clear: warn,
                removeItem: warn,
                key: warn,
                length: 0
              };
            }
            {
              this.__isWebIOS14OrIPadOS14Env = (sys.os === OS.IOS || sys.os === OS.OSX) && systemInfo.isBrowser && /(OS 14)|(Version\/14)/.test(window.navigator.userAgent);
            }
          });
        },
        now() {
          return systemInfo.now();
        },
        restartVM() {
          systemInfo.restartJSVM();
        },
        getSafeAreaRect(symmetric = true) {
          const locView = legacyCC.view;
          const edge = screenAdapter.safeAreaEdge;
          if (symmetric) {
            if (screenAdapter.orientation === macro.ORIENTATION_PORTRAIT) {
              if (edge.top < edge.bottom) {
                edge.top = edge.bottom;
              } else {
                edge.bottom = edge.top;
              }
            } else if (edge.left < edge.right) {
              edge.left = edge.right;
            } else {
              edge.right = edge.left;
            }
          }
          const windowSize = screenAdapter.windowSize;
          const leftBottom = new Vec2(edge.left, edge.bottom);
          const rightTop = new Vec2(windowSize.width - edge.right, windowSize.height - edge.top);
          locView._convertToUISpace(leftBottom);
          locView._convertToUISpace(rightTop);
          const x = leftBottom.x;
          const y = leftBottom.y;
          const width = rightTop.x - leftBottom.x;
          const height = rightTop.y - leftBottom.y;
          return new Rect$1(x, y, width, height);
        }
      });
      legacyCC.sys = sys;

      markAsWarning(legacyCC, 'cc', [{
        name: 'winSize',
        suggest: 'please use view.getVisibleSize() instead.'
      }]);
      markAsWarning(sys, 'sys', [{
        name: 'capabilities',
        suggest: 'please use sys.hasFeature() method instead.'
      }]);
      replaceProperty(sys, 'sys', ['UNKNOWN', 'ENGLISH', 'CHINESE', 'FRENCH', 'ITALIAN', 'GERMAN', 'SPANISH', 'DUTCH', 'RUSSIAN', 'KOREAN', 'JAPANESE', 'HUNGARIAN', 'PORTUGUESE', 'ARABIC', 'NORWEGIAN', 'POLISH', 'TURKISH', 'UKRAINIAN', 'ROMANIAN', 'BULGARIAN'].map(item => ({
        name: `LANGUAGE_${item}`,
        newName: item,
        target: sys.Language,
        targetName: 'sys.Language'
      })));
      replaceProperty(sys, 'sys', ['UNKNOWN', 'IOS', 'ANDROID', 'WINDOWS', 'LINUX', 'OSX'].map(item => ({
        name: `OS_${item}`,
        newName: item,
        target: sys.OS,
        targetName: 'sys.OS'
      })));
      replaceProperty(sys, 'sys', ['UNKNOWN', 'WECHAT', 'ANDROID', 'IE', 'EDGE', 'QQ', 'MOBILE_QQ', 'UC', 'UCBS', 'BAIDU_APP', 'BAIDU', 'MAXTHON', 'OPERA', 'OUPENG', 'MIUI', 'FIREFOX', 'SAFARI', 'CHROME', 'LIEBAO', 'QZONE', 'SOUGOU', 'HUAWEI'].map(item => ({
        name: `BROWSER_TYPE_${item}`,
        newName: item,
        target: sys.BrowserType,
        targetName: 'sys.BrowserType'
      })));
      replaceProperty(sys, 'sys', [{
        name: 'BROWSER_TYPE_360',
        newName: 'BROWSER_360',
        target: sys.BrowserType,
        targetName: 'sys.BrowserType'
      }]);
      replaceProperty(sys, 'sys', ['UNKNOWN', 'EDITOR_PAGE', 'EDITOR_CORE', 'MOBILE_BROWSER', 'DESKTOP_BROWSER', 'WIN32', 'MACOS', 'IOS', 'ANDROID', 'OHOS', 'WECHAT_GAME', 'BAIDU_MINI_GAME', 'XIAOMI_QUICK_GAME', 'ALIPAY_MINI_GAME', 'BYTEDANCE_MINI_GAME', 'OPPO_MINI_GAME', 'VIVO_MINI_GAME', 'HUAWEI_QUICK_GAME', 'COCOSPLAY', 'LINKSURE_MINI_GAME', 'QTT_MINI_GAME'].map(item => ({
        name: item,
        target: sys.Platform,
        targetName: 'sys.Platform'
      })));
      replaceProperty(sys, 'sys', [{
        name: 'IPHONE',
        newName: 'IOS',
        target: sys.Platform,
        targetName: 'sys.Platform'
      }, {
        name: 'IPAD',
        newName: 'IOS',
        target: sys.Platform,
        targetName: 'sys.Platform'
      }]);
      removeProperty(sys, 'sys', ['LINUX', 'BLACKBERRY', 'NACL', 'EMSCRIPTEN', 'TIZEN', 'WINRT', 'WP8', 'QQ_PLAY', 'FB_PLAYABLE_ADS'].map(item => ({
        name: item
      })));
      replaceProperty(sys, 'sys', [{
        name: 'windowPixelResolution',
        target: screen,
        targetName: 'screen',
        newName: 'windowSize'
      }]);
      markAsWarning(screen, 'screen', [{
        name: 'autoFullScreen',
        suggest: 'please use screen.requestFullScreen() instead.'
      }, {
        name: 'disableAutoFullScreen'
      }]);

      const visibleRect = exports("visibleRect", {
        topLeft: legacyCC.v2(0, 0),
        topRight: legacyCC.v2(0, 0),
        top: legacyCC.v2(0, 0),
        bottomLeft: legacyCC.v2(0, 0),
        bottomRight: legacyCC.v2(0, 0),
        bottom: legacyCC.v2(0, 0),
        center: legacyCC.v2(0, 0),
        left: legacyCC.v2(0, 0),
        right: legacyCC.v2(0, 0),
        width: 0,
        height: 0,
        init(visibleRect_) {
          const w = this.width = visibleRect_.width;
          const h = this.height = visibleRect_.height;
          const l = visibleRect_.x;
          const b = visibleRect_.y;
          const t = b + h;
          const r = l + w;
          this.topLeft.x = l;
          this.topLeft.y = t;
          this.topRight.x = r;
          this.topRight.y = t;
          this.top.x = l + w / 2;
          this.top.y = t;
          this.bottomLeft.x = l;
          this.bottomLeft.y = b;
          this.bottomRight.x = r;
          this.bottomRight.y = b;
          this.bottom.x = l + w / 2;
          this.bottom.y = b;
          this.center.x = l + w / 2;
          this.center.y = b + h / 2;
          this.left.x = l;
          this.left.y = b + h / 2;
          this.right.x = r;
          this.right.y = b + h / 2;
        }
      });
      legacyCC.visibleRect = visibleRect;

      const _v3_tmp$1 = new Vec3();
      const _v3_tmp2$1 = new Vec3();
      const _v3_tmp3 = new Vec3();
      const _v3_tmp4 = new Vec3();
      const _m3_tmp$1 = new Mat3();
      const transform_extent_m4 = (out, extent, m4) => {
        _m3_tmp$1.m00 = Math.abs(m4.m00);
        _m3_tmp$1.m01 = Math.abs(m4.m01);
        _m3_tmp$1.m02 = Math.abs(m4.m02);
        _m3_tmp$1.m03 = Math.abs(m4.m04);
        _m3_tmp$1.m04 = Math.abs(m4.m05);
        _m3_tmp$1.m05 = Math.abs(m4.m06);
        _m3_tmp$1.m06 = Math.abs(m4.m08);
        _m3_tmp$1.m07 = Math.abs(m4.m09);
        _m3_tmp$1.m08 = Math.abs(m4.m10);
        Vec3.transformMat3(out, extent, _m3_tmp$1);
      };
      class AABB {
        static create(px, py, pz, hw, hh, hl) {
          return new AABB(px, py, pz, hw, hh, hl);
        }
        static clone(a) {
          {
            warn('The static method AABB.clone has been deprecated. Please use the corresponding instance method instead.');
          }
          return new AABB(a.center.x, a.center.y, a.center.z, a.halfExtents.x, a.halfExtents.y, a.halfExtents.z);
        }
        static copy(out, a) {
          {
            warn('The static method AABB.copy has been deprecated. Please use the corresponding instance method instead.');
          }
          Vec3.copy(out.center, a.center);
          Vec3.copy(out.halfExtents, a.halfExtents);
          return out;
        }
        static fromPoints(out, minPos, maxPos) {
          Vec3.add(_v3_tmp$1, maxPos, minPos);
          Vec3.subtract(_v3_tmp2$1, maxPos, minPos);
          Vec3.multiplyScalar(out.center, _v3_tmp$1, 0.5);
          Vec3.multiplyScalar(out.halfExtents, _v3_tmp2$1, 0.5);
          return out;
        }
        static set(out, px, py, pz, hw, hh, hl) {
          out.center.set(px, py, pz);
          out.halfExtents.set(hw, hh, hl);
          return out;
        }
        static merge(out, a, b) {
          Vec3.subtract(_v3_tmp$1, a.center, a.halfExtents);
          Vec3.subtract(_v3_tmp2$1, b.center, b.halfExtents);
          Vec3.add(_v3_tmp3, a.center, a.halfExtents);
          Vec3.add(_v3_tmp4, b.center, b.halfExtents);
          Vec3.max(_v3_tmp4, _v3_tmp3, _v3_tmp4);
          Vec3.min(_v3_tmp3, _v3_tmp$1, _v3_tmp2$1);
          return AABB.fromPoints(out, _v3_tmp3, _v3_tmp4);
        }
        static toBoundingSphere(out, a) {
          out.center.set(a.center);
          out.radius = a.halfExtents.length();
          return out;
        }
        static transform(out, a, matrix) {
          Vec3.transformMat4(out.center, a.center, matrix);
          transform_extent_m4(out.halfExtents, a.halfExtents, matrix);
          return out;
        }
        get type() {
          return this._type;
        }
        constructor(px = 0, py = 0, pz = 0, hw = 1, hh = 1, hl = 1) {
          this.center = void 0;
          this.halfExtents = void 0;
          this._type = void 0;
          this._type = 8;
          this.center = new Vec3(px, py, pz);
          this.halfExtents = new Vec3(hw, hh, hl);
        }
        getBoundary(minPos, maxPos) {
          Vec3.subtract(minPos, this.center, this.halfExtents);
          Vec3.add(maxPos, this.center, this.halfExtents);
        }
        transform(m, pos, rot, scale, out) {
          Vec3.transformMat4(out.center, this.center, m);
          transform_extent_m4(out.halfExtents, this.halfExtents, m);
        }
        clone() {
          const center = this.center;
          const halfExtents = this.halfExtents;
          return new AABB(center.x, center.y, center.z, halfExtents.x, halfExtents.y, halfExtents.z);
        }
        copy(a) {
          Vec3.copy(this.center, a.center);
          Vec3.copy(this.halfExtents, a.halfExtents);
          return this;
        }
        mergePoint(point) {
          this.getBoundary(_v3_tmp$1, _v3_tmp2$1);
          if (point.x < _v3_tmp$1.x) {
            _v3_tmp$1.x = point.x;
          }
          if (point.y < _v3_tmp$1.y) {
            _v3_tmp$1.y = point.y;
          }
          if (point.z < _v3_tmp$1.z) {
            _v3_tmp$1.z = point.z;
          }
          if (point.x > _v3_tmp2$1.x) {
            _v3_tmp2$1.x = point.x;
          }
          if (point.y > _v3_tmp2$1.y) {
            _v3_tmp2$1.y = point.y;
          }
          if (point.z > _v3_tmp2$1.z) {
            _v3_tmp2$1.z = point.z;
          }
          Vec3.add(_v3_tmp3, _v3_tmp$1, _v3_tmp2$1);
          this.center.set(Vec3.multiplyScalar(_v3_tmp3, _v3_tmp3, 0.5));
          this.halfExtents.set(_v3_tmp2$1.x - _v3_tmp3.x, _v3_tmp2$1.y - _v3_tmp3.y, _v3_tmp2$1.z - _v3_tmp3.z);
        }
        mergePoints(points) {
          if (points.length < 1) {
            return;
          }
          for (let i = 0; i < points.length; i++) {
            this.mergePoint(points[i]);
          }
        }
        mergeFrustum(frustum) {
          this.mergePoints(frustum.vertices);
        }
      }

      class Capsule {
        get type() {
          return this._type;
        }
        constructor(radius = 0.5, halfHeight = 0.5, axis = 1) {
          this._type = void 0;
          this.radius = void 0;
          this.halfHeight = void 0;
          this.axis = void 0;
          this.center = void 0;
          this.rotation = void 0;
          this.ellipseCenter0 = void 0;
          this.ellipseCenter1 = void 0;
          this._type = 512;
          this.radius = radius;
          this.halfHeight = halfHeight;
          this.axis = axis;
          this.center = new Vec3();
          this.rotation = new Quat();
          this.ellipseCenter0 = new Vec3(0, halfHeight, 0);
          this.ellipseCenter1 = new Vec3(0, -halfHeight, 0);
          this.updateCache();
        }
        transform(m, pos, rot, scale, out) {
          const ws = scale;
          const s = absMaxComponent(ws);
          out.radius = this.radius * Math.abs(s);
          const halfTotalWorldHeight = (this.halfHeight + this.radius) * Math.abs(ws.y);
          let halfWorldHeight = halfTotalWorldHeight - out.radius;
          if (halfWorldHeight < 0) halfWorldHeight = 0;
          out.halfHeight = halfWorldHeight;
          Vec3.transformMat4(out.center, this.center, m);
          Quat.multiply(out.rotation, this.rotation, rot);
          out.updateCache();
        }
        updateCache() {
          this.updateLocalCenter();
          Vec3.transformQuat(this.ellipseCenter0, this.ellipseCenter0, this.rotation);
          Vec3.transformQuat(this.ellipseCenter1, this.ellipseCenter1, this.rotation);
          this.ellipseCenter0.add(this.center);
          this.ellipseCenter1.add(this.center);
        }
        updateLocalCenter() {
          const halfHeight = this.halfHeight;
          const axis = this.axis;
          switch (axis) {
            case 0:
              this.ellipseCenter0.set(halfHeight, 0, 0);
              this.ellipseCenter1.set(-halfHeight, 0, 0);
              break;
            case 1:
              this.ellipseCenter0.set(0, halfHeight, 0);
              this.ellipseCenter1.set(0, -halfHeight, 0);
              break;
            case 2:
              this.ellipseCenter0.set(0, 0, halfHeight);
              this.ellipseCenter1.set(0, 0, -halfHeight);
              break;
          }
        }
      }

      const _v = new Array(8);
      _v[0] = v3(1, 1, 1);
      _v[1] = v3(-1, 1, 1);
      _v[2] = v3(-1, -1, 1);
      _v[3] = v3(1, -1, 1);
      _v[4] = v3(1, 1, -1);
      _v[5] = v3(-1, 1, -1);
      _v[6] = v3(-1, -1, -1);
      _v[7] = v3(1, -1, -1);
      const _nearTemp = v3();
      const _farTemp = v3();
      const _temp_v3 = v3();
      class Frustum {
        static createOrthographic(out, width, height, near, far, transform) {
          const halfWidth = width / 2;
          const halfHeight = height / 2;
          Vec3.set(_temp_v3, halfWidth, halfHeight, -near);
          Vec3.transformMat4(out.vertices[0], _temp_v3, transform);
          Vec3.set(_temp_v3, -halfWidth, halfHeight, -near);
          Vec3.transformMat4(out.vertices[1], _temp_v3, transform);
          Vec3.set(_temp_v3, -halfWidth, -halfHeight, -near);
          Vec3.transformMat4(out.vertices[2], _temp_v3, transform);
          Vec3.set(_temp_v3, halfWidth, -halfHeight, -near);
          Vec3.transformMat4(out.vertices[3], _temp_v3, transform);
          Vec3.set(_temp_v3, halfWidth, halfHeight, -far);
          Vec3.transformMat4(out.vertices[4], _temp_v3, transform);
          Vec3.set(_temp_v3, -halfWidth, halfHeight, -far);
          Vec3.transformMat4(out.vertices[5], _temp_v3, transform);
          Vec3.set(_temp_v3, -halfWidth, -halfHeight, -far);
          Vec3.transformMat4(out.vertices[6], _temp_v3, transform);
          Vec3.set(_temp_v3, halfWidth, -halfHeight, -far);
          Vec3.transformMat4(out.vertices[7], _temp_v3, transform);
          out.updatePlanes();
        }
        static createOrtho(out, width, height, near, far, transform) {
          return Frustum.createOrthographic(out, width, height, near, far, transform);
        }
        static createPerspective(out, aspect, fov, near, far, transform) {
          const h = Math.tan(fov * 0.5);
          const w = h * aspect;
          _nearTemp.set(near * w, near * h, near);
          _farTemp.set(far * w, far * h, far);
          const vertexes = out.vertices;
          _temp_v3.set(_nearTemp.x, _nearTemp.y, -_nearTemp.z);
          Vec3.transformMat4(vertexes[0], _temp_v3, transform);
          _temp_v3.set(-_nearTemp.x, _nearTemp.y, -_nearTemp.z);
          Vec3.transformMat4(vertexes[1], _temp_v3, transform);
          _temp_v3.set(-_nearTemp.x, -_nearTemp.y, -_nearTemp.z);
          Vec3.transformMat4(vertexes[2], _temp_v3, transform);
          _temp_v3.set(_nearTemp.x, -_nearTemp.y, -_nearTemp.z);
          Vec3.transformMat4(vertexes[3], _temp_v3, transform);
          _temp_v3.set(_farTemp.x, _farTemp.y, -_farTemp.z);
          Vec3.transformMat4(vertexes[4], _temp_v3, transform);
          _temp_v3.set(-_farTemp.x, _farTemp.y, -_farTemp.z);
          Vec3.transformMat4(vertexes[5], _temp_v3, transform);
          _temp_v3.set(-_farTemp.x, -_farTemp.y, -_farTemp.z);
          Vec3.transformMat4(vertexes[6], _temp_v3, transform);
          _temp_v3.set(_farTemp.x, -_farTemp.y, -_farTemp.z);
          Vec3.transformMat4(vertexes[7], _temp_v3, transform);
          out.updatePlanes();
        }
        static createFromAABB(out, aabb) {
          const vec3_min = new Vec3();
          const vec3_max = new Vec3();
          Vec3.subtract(vec3_min, aabb.center, aabb.halfExtents);
          Vec3.add(vec3_max, aabb.center, aabb.halfExtents);
          out.vertices[0].set(vec3_max.x, vec3_max.y, -vec3_min.z);
          out.vertices[1].set(vec3_min.x, vec3_max.y, -vec3_min.z);
          out.vertices[2].set(vec3_min.x, vec3_min.y, -vec3_min.z);
          out.vertices[3].set(vec3_max.x, vec3_min.y, -vec3_min.z);
          out.vertices[4].set(vec3_max.x, vec3_max.y, -vec3_max.z);
          out.vertices[5].set(vec3_min.x, vec3_max.y, -vec3_max.z);
          out.vertices[6].set(vec3_min.x, vec3_min.y, -vec3_max.z);
          out.vertices[7].set(vec3_max.x, vec3_min.y, -vec3_max.z);
          out.updatePlanes();
          return out;
        }
        split(start, end, aspect, fov, m) {
          return Frustum.createPerspective(this, aspect, fov, start, end, m);
        }
        static create() {
          return new Frustum();
        }
        static clone(f) {
          return Frustum.copy(new Frustum(), f);
        }
        static copy(out, f) {
          out._type = f.type;
          for (let i = 0; i < 6; ++i) {
            Plane.copy(out.planes[i], f.planes[i]);
          }
          for (let i = 0; i < 8; ++i) {
            Vec3.copy(out.vertices[i], f.vertices[i]);
          }
          return out;
        }
        set accurate(b) {
          this._type = b ? 256 : 128;
        }
        get type() {
          return this._type;
        }
        constructor() {
          this.planes = void 0;
          this.vertices = void 0;
          this._type = void 0;
          this._type = 128;
          this.planes = new Array(6);
          for (let i = 0; i < 6; ++i) {
            this.planes[i] = Plane.create(0, 0, 0, 0);
          }
          this.vertices = new Array(8);
          for (let i = 0; i < 8; ++i) {
            this.vertices[i] = new Vec3();
          }
        }
        update(m, inv) {
          Vec3.set(this.planes[0].n, m.m03 + m.m00, m.m07 + m.m04, m.m11 + m.m08);
          this.planes[0].d = -(m.m15 + m.m12);
          Vec3.set(this.planes[1].n, m.m03 - m.m00, m.m07 - m.m04, m.m11 - m.m08);
          this.planes[1].d = -(m.m15 - m.m12);
          Vec3.set(this.planes[2].n, m.m03 + m.m01, m.m07 + m.m05, m.m11 + m.m09);
          this.planes[2].d = -(m.m15 + m.m13);
          Vec3.set(this.planes[3].n, m.m03 - m.m01, m.m07 - m.m05, m.m11 - m.m09);
          this.planes[3].d = -(m.m15 - m.m13);
          Vec3.set(this.planes[4].n, m.m03 + m.m02, m.m07 + m.m06, m.m11 + m.m10);
          this.planes[4].d = -(m.m15 + m.m14);
          Vec3.set(this.planes[5].n, m.m03 - m.m02, m.m07 - m.m06, m.m11 - m.m10);
          this.planes[5].d = -(m.m15 - m.m14);
          for (let i = 0; i < 6; i++) {
            const pl = this.planes[i];
            const invDist = 1 / pl.n.length();
            Vec3.multiplyScalar(pl.n, pl.n, invDist);
            pl.d *= invDist;
          }
          for (let i = 0; i < 8; i++) {
            Vec3.transformMat4(this.vertices[i], _v[i], inv);
          }
        }
        transform(mat) {
          for (let i = 0; i < 8; i++) {
            Vec3.transformMat4(this.vertices[i], this.vertices[i], mat);
          }
          this.updatePlanes();
        }
        zero() {
          for (let i = 0; i < 8; i++) {
            this.vertices[i].set(0.0, 0.0, 0.0);
          }
          for (let i = 0; i < 6; i++) {
            Plane.set(this.planes[i], 0, 0, 0, 0);
          }
        }
        updatePlanes() {
          Plane.fromPoints(this.planes[0], this.vertices[1], this.vertices[6], this.vertices[5]);
          Plane.fromPoints(this.planes[1], this.vertices[3], this.vertices[4], this.vertices[7]);
          Plane.fromPoints(this.planes[2], this.vertices[6], this.vertices[3], this.vertices[7]);
          Plane.fromPoints(this.planes[3], this.vertices[0], this.vertices[5], this.vertices[4]);
          Plane.fromPoints(this.planes[4], this.vertices[2], this.vertices[0], this.vertices[3]);
          Plane.fromPoints(this.planes[5], this.vertices[7], this.vertices[5], this.vertices[6]);
        }
      }

      function cacheProperty(ctor, property) {
        const propDesc = Object.getOwnPropertyDescriptor(ctor.prototype, property);
        const propCacheKey = `_$cache_${property}`;
        const propRealKey = `_$_${property}`;
        Object.defineProperty(ctor.prototype, propRealKey, propDesc);
        Object.defineProperty(ctor.prototype, property, {
          get() {
            if (this[propCacheKey] === undefined) {
              this[propCacheKey] = this[propRealKey];
            }
            return this[propCacheKey];
          },
          set(value) {
            this[propRealKey] = value;
          },
          configurable: true,
          enumerable: true
        });
      }
      function cacheUnderlyingData(ctor) {
        ctor.prototype._arraybuffer = function () {
          if (!this.__data) {
            this.__data = this.underlyingData();
          }
          return this.__data;
        };
      }
      const defineAttrFloat = (kls, attr) => {
        const desc = kls.__nativeFields__[attr];
        const cacheKey = `_$_${attr}`;
        assert(desc.fieldSize === 4, `field ${attr} size ${desc.fieldSize}`);
        Object.defineProperty(kls.prototype, desc.fieldName, {
          configurable: true,
          enumerable: true,
          get() {
            if (this[cacheKey] === undefined) {
              this[cacheKey] = new Float32Array(this._arraybuffer(), desc.fieldOffset, 1);
            }
            return this[cacheKey][0];
          },
          set(v) {
            if (this[cacheKey] === undefined) {
              this[cacheKey] = new Float32Array(this._arraybuffer(), desc.fieldOffset, 1);
            }
            this[cacheKey][0] = v;
          }
        });
      };
      const defineAttrInt = (kls, attr) => {
        const desc = kls.__nativeFields__[attr];
        if (!desc) {
          console.error(`attr ${attr} not defined in class ${kls.toString()}`);
        }
        const cacheKey = `_$_${attr}`;
        assert(desc.fieldSize === 4, `field ${attr} size ${desc.fieldSize}`);
        Object.defineProperty(kls.prototype, desc.fieldName, {
          configurable: true,
          enumerable: true,
          get() {
            if (this[cacheKey] === undefined) {
              this[cacheKey] = new Int32Array(this._arraybuffer(), desc.fieldOffset, 1);
            }
            return this[cacheKey][0];
          },
          set(v) {
            if (this[cacheKey] === undefined) {
              this[cacheKey] = new Int32Array(this._arraybuffer(), desc.fieldOffset, 1);
            }
            this[cacheKey][0] = v;
          }
        });
      };
      {
        cacheProperty(ns.Line, 's');
        cacheProperty(ns.Line, 'e');
        Object.setPrototypeOf(ns.Line.prototype, Line.prototype);
        cacheUnderlyingData(ns.Plane);
        cacheProperty(ns.Plane, 'n');
        defineAttrFloat(ns.Plane, 'd');
        Object.setPrototypeOf(ns.Plane.prototype, Plane.prototype);
        cacheUnderlyingData(ns.Ray);
        cacheProperty(ns.Ray, 'o');
        cacheProperty(ns.Ray, 'd');
        Object.setPrototypeOf(ns.Ray.prototype, Ray.prototype);
        cacheUnderlyingData(ns.Triangle);
        cacheProperty(ns.Triangle, 'a');
        cacheProperty(ns.Triangle, 'b');
        cacheProperty(ns.Triangle, 'c');
        Object.setPrototypeOf(ns.Triangle.prototype, Triangle.prototype);
        cacheUnderlyingData(ns.Sphere);
        cacheProperty(ns.Sphere, '_center');
        defineAttrFloat(ns.Sphere, '_radius');
        Object.setPrototypeOf(ns.Sphere.prototype, Sphere.prototype);
        cacheUnderlyingData(ns.AABB);
        cacheProperty(ns.AABB, 'center');
        cacheProperty(ns.AABB, 'halfExtents');
        Object.setPrototypeOf(ns.AABB.prototype, AABB.prototype);
        cacheUnderlyingData(ns.Capsule);
        defineAttrFloat(ns.Capsule, 'radius');
        defineAttrFloat(ns.Capsule, 'halfHeight');
        defineAttrInt(ns.Capsule, 'axis');
        cacheProperty(ns.Capsule, 'center');
        cacheProperty(ns.Capsule, 'rotation');
        cacheProperty(ns.Capsule, 'ellipseCenter0');
        cacheProperty(ns.Capsule, 'ellipseCenter1');
        Object.setPrototypeOf(ns.Capsule.prototype, Capsule.prototype);
        cacheProperty(ns.Frustum, 'vertices');
        cacheProperty(ns.Frustum, 'planes');
        Object.setPrototypeOf(ns.Frustum.prototype, Frustum.prototype);
        const descOf_type = Object.getOwnPropertyDescriptor(ns.ShapeBase.prototype, '_type');
        for (const kls of [ns.Line, ns.Plane, ns.Ray, ns.Triangle, ns.Sphere, ns.AABB, ns.Capsule, ns.Frustum]) {
          Object.defineProperty(kls.prototype, '_type', descOf_type);
        }
      }

      const ShapeType = {
        "SHAPE_RAY": 1,
        "SHAPE_LINE": 2,
        "SHAPE_SPHERE": 4,
        "SHAPE_AABB": 8,
        "SHAPE_OBB": 16,
        "SHAPE_PLANE": 32,
        "SHAPE_TRIANGLE": 64,
        "SHAPE_FRUSTUM": 128,
        "SHAPE_FRUSTUM_ACCURATE": 256,
        "SHAPE_CAPSULE": 512,
        "SHAPE_SPLINE": 1024
      };

      const _v3_tmp = new Vec3();
      const _v3_tmp2 = new Vec3();
      const _m3_tmp = new Mat3();
      const transform_extent_m3 = (out, extent, m3) => {
        _m3_tmp.m00 = Math.abs(m3.m00);
        _m3_tmp.m01 = Math.abs(m3.m01);
        _m3_tmp.m02 = Math.abs(m3.m02);
        _m3_tmp.m03 = Math.abs(m3.m03);
        _m3_tmp.m04 = Math.abs(m3.m04);
        _m3_tmp.m05 = Math.abs(m3.m05);
        _m3_tmp.m06 = Math.abs(m3.m06);
        _m3_tmp.m07 = Math.abs(m3.m07);
        _m3_tmp.m08 = Math.abs(m3.m08);
        Vec3.transformMat3(out, extent, _m3_tmp);
      };
      class OBB {
        static create(cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3) {
          return new OBB(cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3);
        }
        static clone(a) {
          return new OBB(a.center.x, a.center.y, a.center.z, a.halfExtents.x, a.halfExtents.y, a.halfExtents.z, a.orientation.m00, a.orientation.m01, a.orientation.m02, a.orientation.m03, a.orientation.m04, a.orientation.m05, a.orientation.m06, a.orientation.m07, a.orientation.m08);
        }
        static copy(out, a) {
          Vec3.copy(out.center, a.center);
          Vec3.copy(out.halfExtents, a.halfExtents);
          Mat3.copy(out.orientation, a.orientation);
          return out;
        }
        static fromPoints(out, minPos, maxPos) {
          Vec3.multiplyScalar(out.center, Vec3.add(_v3_tmp, minPos, maxPos), 0.5);
          Vec3.multiplyScalar(out.halfExtents, Vec3.subtract(_v3_tmp2, maxPos, minPos), 0.5);
          Mat3.identity(out.orientation);
          return out;
        }
        static set(out, cx, cy, cz, hw, hh, hl, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3) {
          Vec3.set(out.center, cx, cy, cz);
          Vec3.set(out.halfExtents, hw, hh, hl);
          Mat3.set(out.orientation, ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3);
          return out;
        }
        get type() {
          return this._type;
        }
        constructor(cx = 0, cy = 0, cz = 0, hw = 1, hh = 1, hl = 1, ox_1 = 1, ox_2 = 0, ox_3 = 0, oy_1 = 0, oy_2 = 1, oy_3 = 0, oz_1 = 0, oz_2 = 0, oz_3 = 1) {
          this.center = void 0;
          this.halfExtents = void 0;
          this.orientation = void 0;
          this._type = void 0;
          this._type = 16;
          this.center = new Vec3(cx, cy, cz);
          this.halfExtents = new Vec3(hw, hh, hl);
          this.orientation = new Mat3(ox_1, ox_2, ox_3, oy_1, oy_2, oy_3, oz_1, oz_2, oz_3);
        }
        getBoundary(minPos, maxPos) {
          transform_extent_m3(_v3_tmp, this.halfExtents, this.orientation);
          Vec3.subtract(minPos, this.center, _v3_tmp);
          Vec3.add(maxPos, this.center, _v3_tmp);
        }
        transform(m, pos, rot, scale, out) {
          Vec3.transformMat4(out.center, this.center, m);
          Mat3.fromQuat(out.orientation, rot);
          Vec3.multiply(out.halfExtents, this.halfExtents, scale);
        }
        translateAndRotate(m, rot, out) {
          Vec3.transformMat4(out.center, this.center, m);
          Mat3.fromQuat(out.orientation, rot);
        }
        setScale(scale, out) {
          Vec3.multiply(out.halfExtents, this.halfExtents, scale);
        }
      }

      function binarySearch(array, value) {
        return binarySearchEpsilon(array, value, 0);
      }
      function binarySearchEpsilon(array, value, EPSILON = 1e-6) {
        let low = 0;
        let high = array.length - 1;
        let middle = high >>> 1;
        for (; low <= high; middle = low + high >>> 1) {
          const test = array[middle];
          if (test > value + EPSILON) {
            high = middle - 1;
          } else if (test < value - EPSILON) {
            low = middle + 1;
          } else {
            return middle;
          }
        }
        return ~low;
      }
      function binarySearchBy(array, value, lessThan) {
        let low = 0;
        let high = array.length - 1;
        let middle = high >>> 1;
        for (; low <= high; middle = low + high >>> 1) {
          const test = array[middle];
          if (lessThan(test, value) < 0) {
            high = middle - 1;
          } else if (lessThan(test, value) > 0) {
            low = middle + 1;
          } else {
            return middle;
          }
        }
        return ~low;
      }

      let _Symbol$iterator$1;
      _Symbol$iterator$1 = Symbol.iterator;
      class KeyframeCurve {
        constructor() {
          this._times = [];
          this._values = [];
        }
        get keyFramesCount() {
          return this._times.length;
        }
        get rangeMin() {
          return this._times[0];
        }
        get rangeMax() {
          return this._times[this._values.length - 1];
        }
        [_Symbol$iterator$1]() {
          let index = 0;
          return {
            next: () => {
              if (index >= this._times.length) {
                return {
                  done: true,
                  value: undefined
                };
              } else {
                const value = [this._times[index], this._values[index]];
                ++index;
                return {
                  done: false,
                  value
                };
              }
            }
          };
        }
        keyframes() {
          return this;
        }
        times() {
          return this._times;
        }
        values() {
          return this._values;
        }
        getKeyframeTime(index) {
          return this._times[index];
        }
        getKeyframeValue(index) {
          return this._values[index];
        }
        addKeyFrame(time, keyframeValue) {
          return this._insertNewKeyframe(time, keyframeValue);
        }
        removeKeyframe(index) {
          this._times.splice(index, 1);
          this._values.splice(index, 1);
        }
        indexOfKeyframe(time) {
          return binarySearchEpsilon(this._times, time);
        }
        updateTime(index, time) {
          const value = this._values[index];
          this.removeKeyframe(index);
          this._insertNewKeyframe(time, value);
        }
        assignSorted(times, values) {
          if (values !== undefined) {
            assertIsTrue(Array.isArray(times));
            this.setKeyframes(times.slice(), values.slice());
          } else {
            const keyframes = Array.from(times);
            this.setKeyframes(keyframes.map(([time]) => time), keyframes.map(([, value]) => value));
          }
        }
        clear() {
          this._times.length = 0;
          this._values.length = 0;
        }
        searchKeyframe(time) {
          return binarySearchEpsilon(this._times, time);
        }
        setKeyframes(times, values) {
          assertIsTrue(times.length === values.length);
          assertIsTrue(isSorted(times));
          this._times = times;
          this._values = values;
        }
        _insertNewKeyframe(time, value) {
          const times = this._times;
          const values = this._values;
          const nFrames = times.length;
          const index = binarySearchEpsilon(times, time);
          if (index >= 0) {
            return index;
          }
          const iNext = ~index;
          if (iNext === 0) {
            times.unshift(time);
            values.unshift(value);
          } else if (iNext === nFrames) {
            times.push(time);
            values.push(value);
          } else {
            assertIsTrue(nFrames > 1);
            times.splice(iNext - 1, 0, time);
            values.splice(iNext - 1, 0, value);
          }
          return iNext;
        }
      }
      CCClass.fastDefine('cc.KeyframeCurve', KeyframeCurve, {
        _times: [],
        _values: []
      });
      function isSorted(values) {
        return values.every((value, index, array) => index === 0 || value > array[index - 1] || approx(value, array[index - 1], 1e-6));
      }

      const RealInterpolationMode = exports("RealInterpolationMode", {
        "LINEAR": 0,
        "CONSTANT": 1,
        "CUBIC": 2
      });
      const ExtrapolationMode = exports("ExtrapolationMode", {
        "LINEAR": 0,
        "CLAMP": 1,
        "LOOP": 2,
        "PING_PONG": 3
      });
      const TangentWeightMode = exports("TangentWeightMode", {
        "NONE": 0,
        "LEFT": 1,
        "RIGHT": 2,
        "BOTH": 3
      });

      function solveCubic(coeff0, coeff1, coeff2, coeff3, solutions) {
        const a = coeff2 / coeff3;
        const b = coeff1 / coeff3;
        const c = coeff0 / coeff3;
        const sqrA = a * a;
        const p = 1.0 / 3.0 * (-1.0 / 3 * sqrA + b);
        const q = 1.0 / 2.0 * (2.0 / 27.0 * a * sqrA - 1.0 / 3 * a * b + c);
        const cubicP = p * p * p;
        const d = q * q + cubicP;
        let nSolutions = 0;
        if (isZero(d)) {
          if (isZero(q)) {
            solutions[0] = 0;
            return 1;
          } else {
            const u = Math.cbrt(-q);
            solutions[0] = 2 * u;
            solutions[1] = -u;
            return 2;
          }
        } else if (d < 0) {
          const phi = 1.0 / 3 * Math.acos(-q / Math.sqrt(-cubicP));
          const t = 2 * Math.sqrt(-p);
          solutions[0] = t * Math.cos(phi);
          solutions[1] = -t * Math.cos(phi + Math.PI / 3);
          solutions[2] = -t * Math.cos(phi - Math.PI / 3);
          nSolutions = 3;
        } else {
          const sqrtD = Math.sqrt(d);
          const u = Math.cbrt(sqrtD - q);
          const v = -Math.cbrt(sqrtD + q);
          solutions[0] = u + v;
          nSolutions = 1;
        }
        const sub = 1.0 / 3 * a;
        for (let i = 0; i < nSolutions; ++i) {
          solutions[i] -= sub;
        }
        return nSolutions;
      }
      const EQN_EPS = 1e-9;
      function isZero(x) {
        return x > -EQN_EPS && x < EQN_EPS;
      }

      function applyDecoratedInitializer(target, property, decorators, initializer) {
        return decorators.slice().reverse().reduce(function (decoratedInitializer, decorator) {
          return decorator(target, property, decoratedInitializer) || decoratedInitializer;
        }, initializer);
      }

      const emptyDecorator = () => {};
      const emptyDecoratorFn = () => emptyDecorator;
      const emptySmartClassDecorator = makeSmartClassDecorator(() => {});
      function makeSmartClassDecorator(decorate) {
        return proxyFn;
        function proxyFn(target) {
          if (typeof target === 'function') {
            return decorate(target);
          } else {
            return function (constructor) {
              return decorate(constructor, target);
            };
          }
        }
      }
      function writeEditorClassProperty(constructor, propertyName, value) {
        const cache = getClassCache(constructor);
        if (cache) {
          const proto = getSubDict(cache, 'proto');
          getSubDict(proto, 'editor')[propertyName] = value;
        }
      }
      function makeEditorClassDecoratorFn(propertyName) {
        return value => constructor => {
          writeEditorClassProperty(constructor, propertyName, value);
        };
      }
      const CACHE_KEY = '__ccclassCache__';
      function getClassCache(ctor, decoratorName) {
        return getSubDict(ctor, CACHE_KEY);
      }
      function getSubDict(obj, key) {
        return obj[key] || (obj[key] = {});
      }

      const ccclass$H = makeSmartClassDecorator((constructor, name) => {
        let base = getSuper(constructor);
        if (base === Object) {
          base = null;
        }
        const proto = {
          name,
          extends: base,
          ctor: constructor
        };
        const cache = constructor[CACHE_KEY];
        if (cache) {
          const decoratedProto = cache.proto;
          if (decoratedProto) {
            mixin(proto, decoratedProto);
          }
          constructor[CACHE_KEY] = undefined;
        }
        const res = CCClass(proto);
        return res;
      });

      const requireComponent = makeEditorClassDecoratorFn('requireComponent');
      const executionOrder$1 = makeEditorClassDecoratorFn('executionOrder');
      const disallowMultiple$1 = emptySmartClassDecorator;

      function property(target, propertyKey, descriptorOrInitializer) {
        let options = null;
        function normalized(target, propertyKey, descriptorOrInitializer) {
          const classStash = getOrCreateClassStash(target);
          const propertyStash = getOrCreateEmptyPropertyStash(target, propertyKey);
          const classConstructor = target.constructor;
          mergePropertyOptions(classStash, propertyStash, classConstructor, propertyKey, options, descriptorOrInitializer);
        }
        if (target === undefined) {
          return property({
            type: undefined
          });
        } else if (typeof propertyKey === 'undefined') {
          options = target;
          return normalized;
        } else {
          normalized(target, propertyKey, descriptorOrInitializer);
          return undefined;
        }
      }
      function getDefaultFromInitializer(initializer) {
        let value;
        try {
          value = initializer();
        } catch (e) {
          return initializer;
        }
        if (typeof value !== 'object' || value === null) {
          return value;
        } else {
          return initializer;
        }
      }
      function extractActualDefaultValues(classConstructor) {
        let dummyObj;
        try {
          dummyObj = new classConstructor();
        } catch (e) {
          return {};
        }
        return dummyObj;
      }
      function getOrCreateClassStash(target) {
        const cache = getClassCache(target.constructor);
        return cache;
      }
      function getOrCreateEmptyPropertyStash(target, propertyKey) {
        var _ref, _properties$_ref;
        const classStash = getClassCache(target.constructor);
        const ccclassProto = getSubDict(classStash, 'proto');
        const properties = getSubDict(ccclassProto, 'properties');
        const propertyStash = (_properties$_ref = properties[_ref = propertyKey]) !== null && _properties$_ref !== void 0 ? _properties$_ref : properties[_ref] = {};
        return propertyStash;
      }
      function getOrCreatePropertyStash(target, propertyKey, descriptorOrInitializer) {
        var _ref2, _properties$_ref2;
        const classStash = getClassCache(target.constructor);
        const ccclassProto = getSubDict(classStash, 'proto');
        const properties = getSubDict(ccclassProto, 'properties');
        const propertyStash = (_properties$_ref2 = properties[_ref2 = propertyKey]) !== null && _properties$_ref2 !== void 0 ? _properties$_ref2 : properties[_ref2] = {};
        propertyStash.__internalFlags |= 1;
        if (descriptorOrInitializer && typeof descriptorOrInitializer !== 'function' && (descriptorOrInitializer.get || descriptorOrInitializer.set)) {
          if (descriptorOrInitializer.get) {
            propertyStash.get = descriptorOrInitializer.get;
          }
          if (descriptorOrInitializer.set) {
            propertyStash.set = descriptorOrInitializer.set;
          }
        } else {
          setDefaultValue(classStash, propertyStash, target.constructor, propertyKey, descriptorOrInitializer);
        }
        return propertyStash;
      }
      function mergePropertyOptions(cache, propertyStash, ctor, propertyKey, options, descriptorOrInitializer) {
        let fullOptions;
        const isGetset = descriptorOrInitializer && typeof descriptorOrInitializer !== 'function' && (descriptorOrInitializer.get || descriptorOrInitializer.set);
        if (options) {
          fullOptions = getFullFormOfProperty(options, isGetset);
        }
        const propertyRecord = mixin(propertyStash, fullOptions || options || {});
        if (isGetset) {
          if (descriptorOrInitializer.get) {
            propertyRecord.get = descriptorOrInitializer.get;
          }
          if (descriptorOrInitializer.set) {
            propertyRecord.set = descriptorOrInitializer.set;
          }
        } else {
          setDefaultValue(cache, propertyRecord, ctor, propertyKey, descriptorOrInitializer);
        }
      }
      function setDefaultValue(classStash, propertyStash, classConstructor, propertyKey, descriptorOrInitializer) {
        if (descriptorOrInitializer !== undefined) {
          if (typeof descriptorOrInitializer === 'function') {
            propertyStash.default = getDefaultFromInitializer(descriptorOrInitializer);
          } else if (descriptorOrInitializer === null) ; else if (descriptorOrInitializer.initializer) {
            propertyStash.default = getDefaultFromInitializer(descriptorOrInitializer.initializer);
          }
        } else {
          const actualDefaultValues = classStash.default || (classStash.default = extractActualDefaultValues(classConstructor));
          if (actualDefaultValues.hasOwnProperty(propertyKey)) {
            propertyStash.default = actualDefaultValues[propertyKey];
          }
        }
      }

      const sMetadataTag = Symbol('cc:SerializationMetadata');
      function getSerializationMetadata(constructor) {
        return constructor[sMetadataTag];
      }
      function getOrCreateSerializationMetadata(constructor) {
        var _ref, _ref$sMetadataTag;
        return (_ref$sMetadataTag = (_ref = constructor)[sMetadataTag]) !== null && _ref$sMetadataTag !== void 0 ? _ref$sMetadataTag : _ref[sMetadataTag] = {};
      }

      const serializable$l = exports("serializable", (target, propertyKey, descriptorOrInitializer) => {
        const propertyStash = getOrCreatePropertyStash(target, propertyKey, descriptorOrInitializer);
        setImplicitSerializable(propertyStash);
      });
      function formerlySerializedAs$2(name) {
        return (target, propertyKey, descriptorOrInitializer) => {
          const propertyStash = getOrCreatePropertyStash(target, propertyKey, descriptorOrInitializer);
          propertyStash.formerlySerializedAs = name;
          setImplicitSerializable(propertyStash);
        };
      }
      const editorOnly = (target, propertyKey, descriptorOrInitializer) => {
        const propertyStash = getOrCreatePropertyStash(target, propertyKey, descriptorOrInitializer);
        propertyStash.editorOnly = true;
        setImplicitSerializable(propertyStash);
      };
      function setImplicitSerializable(propertyStash) {
        propertyStash.__internalFlags |= 4;
      }
      const uniquelyReferenced = emptyDecorator ;

      const executeInEditMode$2 = emptySmartClassDecorator;
      const menu$f = emptyDecoratorFn;
      const playOnFocus = emptySmartClassDecorator;
      const inspector = emptyDecoratorFn;
      const icon = emptyDecoratorFn;
      const help$3 = emptyDecoratorFn;
      const editable$5 = exports("editable", emptyDecorator );
      const visible$3 = exports("visible", emptyDecoratorFn );
      const readOnly = emptyDecorator ;
      const displayName$2 = exports("displayName", emptyDecoratorFn );
      const tooltip$1 = exports("tooltip", emptyDecoratorFn );
      const range = exports("range", emptyDecoratorFn );
      const rangeMin = emptyDecoratorFn ;
      const rangeStep = exports("rangeStep", emptyDecoratorFn );
      const slide = exports("slide", emptyDecorator );
      const displayOrder$2 = exports("displayOrder", emptyDecoratorFn );
      const disallowAnimation$1 = exports("disallowAnimation", emptyDecorator );

      const integer = type$a(CCInteger);
      const float = type$a(CCFloat);
      const boolean = type$a(CCBoolean);
      const string = type$a(CCString);
      function type$a(type) {
        return property({
          type
        });
      }

      const override$1 = exports("override", (target, propertyKey, descriptorOrInitializer) => {
        const propertyStash = getOrCreatePropertyStash(target, propertyKey, descriptorOrInitializer);
        propertyStash.override = true;
      });

      class Empty {}
      const EditorExtendable = exports("EditorExtendable", editorExtendableInternal());
      assertIsTrue(editorExtrasTag === '__editorExtras__', 'editorExtrasTag needs to be updated.');
      function editorExtendableInternal(Base, className) {
        {
          return Empty;
        }
      }

      var _decorator = /*#__PURE__*/Object.freeze({
        __proto__: null,
        boolean: boolean,
        ccclass: ccclass$H,
        disallowAnimation: disallowAnimation$1,
        disallowMultiple: disallowMultiple$1,
        displayName: displayName$2,
        displayOrder: displayOrder$2,
        editable: editable$5,
        executeInEditMode: executeInEditMode$2,
        executionOrder: executionOrder$1,
        float: float,
        formerlySerializedAs: formerlySerializedAs$2,
        help: help$3,
        icon: icon,
        inspector: inspector,
        integer: integer,
        menu: menu$f,
        override: override$1,
        playOnFocus: playOnFocus,
        property: property,
        range: range,
        rangeStep: rangeStep,
        requireComponent: requireComponent,
        serializable: serializable$l,
        slide: slide,
        string: string,
        tooltip: tooltip$1,
        type: type$a,
        uniquelyReferenced: uniquelyReferenced,
        visible: visible$3
      });
      exports("_decorator", _decorator);

      var _dec$2q, _class$2q, _class2$21, _initializer$1U, _initializer2$1r, _initializer3$13, _initializer4$W, _class3$F;
      const StorageUnit = {
        "Uint8": 0,
        "Uint16": 1,
        "Uint32": 2,
        "Int8": 3,
        "Int16": 4,
        "Int32": 5,
        "Float32": 6,
        "Float64": 7
      };
      const ElementType = {
        "Scalar": 0,
        "Vec2": 1,
        "Vec3": 2,
        "Vec4": 3,
        "Quat": 4,
        "Mat4": 5
      };
      const elementTypeBits = 3;
      function combineStorageUnitElementType(unit, elementType) {
        return (elementType << elementTypeBits) + unit;
      }
      function extractStorageUnitElementType(combined) {
        return {
          storageUnit: ~(-1 << elementTypeBits) & combined,
          elementType: combined >> elementTypeBits
        };
      }
      let CompactValueTypeArray = exports("CompactValueTypeArray", (_dec$2q = ccclass$H('cc.CompactValueTypeArray'), _dec$2q(_class$2q = (_class2$21 = (_class3$F = class CompactValueTypeArray {
        constructor() {
          this._byteOffset = _initializer$1U && _initializer$1U();
          this._unitCount = _initializer2$1r && _initializer2$1r();
          this._unitElement = _initializer3$13 && _initializer3$13();
          this._length = _initializer4$W && _initializer4$W();
        }
        static lengthFor(values, elementType, unit) {
          const elementTraits = getElementTraits(elementType);
          return elementTraits.requiredUnits * values.length * getStorageConstructor(unit).BYTES_PER_ELEMENT;
        }
        static compress(values, elementType, unit, arrayBuffer, byteOffset, presumedByteOffset) {
          const elementTraits = getElementTraits(elementType);
          const storageConstructor = getStorageConstructor(unit);
          const unitCount = elementTraits.requiredUnits * values.length;
          const storage = new storageConstructor(arrayBuffer, byteOffset, unitCount);
          for (let i = 0; i < values.length; ++i) {
            elementTraits.compress(storage, i, values[i]);
          }
          const result = new CompactValueTypeArray();
          result._unitElement = combineStorageUnitElementType(unit, elementType);
          result._byteOffset = presumedByteOffset;
          result._unitCount = unitCount;
          result._length = values.length;
          return result;
        }
        decompress(arrayBuffer) {
          const {
            storageUnit,
            elementType
          } = extractStorageUnitElementType(this._unitElement);
          const elementTraits = getElementTraits(elementType);
          const storageConstructor = getStorageConstructor(storageUnit);
          const storage = new storageConstructor(arrayBuffer, this._byteOffset, this._unitCount);
          const result = new Array(this._length);
          for (let i = 0; i < this._length; ++i) {
            result[i] = elementTraits.decompress(storage, i);
          }
          return result;
        }
      }, _class3$F.StorageUnit = StorageUnit, _class3$F.ElementType = ElementType, _class3$F), (_initializer$1U = applyDecoratedInitializer(_class2$21.prototype, "_byteOffset", [serializable$l], function () {
        return 0;
      }), _initializer2$1r = applyDecoratedInitializer(_class2$21.prototype, "_unitCount", [serializable$l], function () {
        return 0;
      }), _initializer3$13 = applyDecoratedInitializer(_class2$21.prototype, "_unitElement", [serializable$l], function () {
        return combineStorageUnitElementType(0, 0);
      }), _initializer4$W = applyDecoratedInitializer(_class2$21.prototype, "_length", [serializable$l], function () {
        return 0;
      })), _class2$21)) || _class$2q));
      function getElementTraits(elementType) {
        return BuiltinElementTypeTraits[elementType];
      }
      function getStorageConstructor(unit) {
        switch (unit) {
          case 0:
            return Uint8Array;
          case 1:
            return Uint16Array;
          case 2:
            return Uint32Array;
          case 3:
            return Int8Array;
          case 4:
            return Int16Array;
          case 5:
            return Int32Array;
          case 6:
            return Float32Array;
          case 7:
            return Float64Array;
        }
      }
      const BuiltinElementTypeTraits = {
        [0]: {
          requiredUnits: 1,
          compress(storage, index, value) {
            storage[index] = value;
          },
          decompress(storage, index) {
            return storage[index];
          }
        },
        [1]: {
          requiredUnits: 2,
          compress(storage, index, value) {
            storage[index * 2] = value.x;
            storage[index * 2 + 1] = value.y;
          },
          decompress(storage, index) {
            return new Vec3(storage[index * 2], storage[index * 2 + 1]);
          }
        },
        [2]: {
          requiredUnits: 3,
          compress(storage, index, value) {
            storage[index * 3] = value.x;
            storage[index * 3 + 1] = value.y;
            storage[index * 3 + 2] = value.z;
          },
          decompress(storage, index) {
            return new Vec3(storage[index * 3], storage[index * 3 + 1], storage[index * 3 + 2]);
          }
        },
        [3]: {
          requiredUnits: 4,
          compress(storage, index, value) {
            storage[index * 4] = value.x;
            storage[index * 4 + 1] = value.y;
            storage[index * 4 + 2] = value.z;
            storage[index * 4 + 3] = value.w;
          },
          decompress(storage, index) {
            return new Vec4(storage[index * 4], storage[index * 4 + 1], storage[index * 4 + 2], storage[index * 4 + 3]);
          }
        },
        [4]: {
          requiredUnits: 4,
          compress(storage, index, value) {
            storage[index * 4] = value.x;
            storage[index * 4 + 1] = value.y;
            storage[index * 4 + 2] = value.z;
            storage[index * 4 + 3] = value.w;
          },
          decompress(storage, index) {
            return new Quat(storage[index * 4], storage[index * 4 + 1], storage[index * 4 + 2], storage[index * 4 + 3]);
          }
        },
        [5]: {
          requiredUnits: 16,
          compress(storage, index, value) {
            Mat4.toArray(storage, value, index * 16);
          },
          decompress(storage, index) {
            return Mat4.fromArray(new Mat4(), storage, index * 16);
          }
        }
      };

      const serializeTag = exports("serializeTag", Symbol('[[Serialize]]'));
      const deserializeTag = exports("deserializeTag", Symbol('[[Deserialize]]'));

      legacyCC._decorator = _decorator;

      function constant() {
        return 0;
      }
      function linear(k) {
        return k;
      }
      function quadIn(k) {
        return k * k;
      }
      function quadOut(k) {
        return k * (2 - k);
      }
      function quadInOut(k) {
        k *= 2;
        if (k < 1) {
          return 0.5 * k * k;
        }
        return -0.5 * (--k * (k - 2) - 1);
      }
      function cubicIn(k) {
        return k * k * k;
      }
      function cubicOut(k) {
        return --k * k * k + 1;
      }
      function cubicInOut(k) {
        k *= 2;
        if (k < 1) {
          return 0.5 * k * k * k;
        }
        return 0.5 * ((k -= 2) * k * k + 2);
      }
      function quartIn(k) {
        return k * k * k * k;
      }
      function quartOut(k) {
        return 1 - --k * k * k * k;
      }
      function quartInOut(k) {
        k *= 2;
        if (k < 1) {
          return 0.5 * k * k * k * k;
        }
        return -0.5 * ((k -= 2) * k * k * k - 2);
      }
      function quintIn(k) {
        return k * k * k * k * k;
      }
      function quintOut(k) {
        return --k * k * k * k * k + 1;
      }
      function quintInOut(k) {
        k *= 2;
        if (k < 1) {
          return 0.5 * k * k * k * k * k;
        }
        return 0.5 * ((k -= 2) * k * k * k * k + 2);
      }
      function sineIn(k) {
        if (k === 1) {
          return 1;
        }
        return 1 - Math.cos(k * Math.PI / 2);
      }
      function sineOut(k) {
        return Math.sin(k * Math.PI / 2);
      }
      function sineInOut(k) {
        return 0.5 * (1 - Math.cos(Math.PI * k));
      }
      function expoIn(k) {
        return k === 0 ? 0 : 1024 ** (k - 1);
      }
      function expoOut(k) {
        return k === 1 ? 1 : 1 - 2 ** (-10 * k);
      }
      function expoInOut(k) {
        if (k === 0) {
          return 0;
        }
        if (k === 1) {
          return 1;
        }
        k *= 2;
        if (k < 1) {
          return 0.5 * 1024 ** (k - 1);
        }
        return 0.5 * (-(2 ** (-10 * (k - 1))) + 2);
      }
      function circIn(k) {
        return 1 - Math.sqrt(1 - k * k);
      }
      function circOut(k) {
        return Math.sqrt(1 - --k * k);
      }
      function circInOut(k) {
        k *= 2;
        if (k < 1) {
          return -0.5 * (Math.sqrt(1 - k * k) - 1);
        }
        return 0.5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
      }
      function elasticIn(k) {
        let s;
        let a = 0.1;
        const p = 0.4;
        if (k === 0) {
          return 0;
        }
        if (k === 1) {
          return 1;
        }
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else {
          s = p * Math.asin(1 / a) / (2 * Math.PI);
        }
        return -(a * 2 ** (10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
      }
      function elasticOut(k) {
        let s;
        let a = 0.1;
        const p = 0.4;
        if (k === 0) {
          return 0;
        }
        if (k === 1) {
          return 1;
        }
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else {
          s = p * Math.asin(1 / a) / (2 * Math.PI);
        }
        return a * 2 ** (-10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1;
      }
      function elasticInOut(k) {
        let s;
        let a = 0.1;
        const p = 0.4;
        if (k === 0) {
          return 0;
        }
        if (k === 1) {
          return 1;
        }
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else {
          s = p * Math.asin(1 / a) / (2 * Math.PI);
        }
        k *= 2;
        if (k < 1) {
          return -0.5 * (a * 2 ** (10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p));
        }
        return a * 2 ** (-10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * 0.5 + 1;
      }
      function backIn(k) {
        if (k === 1) {
          return 1;
        }
        const s = 1.70158;
        return k * k * ((s + 1) * k - s);
      }
      function backOut(k) {
        if (k === 0) {
          return 0;
        }
        const s = 1.70158;
        return --k * k * ((s + 1) * k + s) + 1;
      }
      function backInOut(k) {
        const s = 1.70158 * 1.525;
        k *= 2;
        if (k < 1) {
          return 0.5 * (k * k * ((s + 1) * k - s));
        }
        return 0.5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
      }
      function bounceIn(k) {
        return 1 - bounceOut(1 - k);
      }
      function bounceOut(k) {
        if (k < 1 / 2.75) {
          return 7.5625 * k * k;
        } else if (k < 2 / 2.75) {
          return 7.5625 * (k -= 1.5 / 2.75) * k + 0.75;
        } else if (k < 2.5 / 2.75) {
          return 7.5625 * (k -= 2.25 / 2.75) * k + 0.9375;
        } else {
          return 7.5625 * (k -= 2.625 / 2.75) * k + 0.984375;
        }
      }
      function bounceInOut(k) {
        if (k < 0.5) {
          return bounceIn(k * 2) * 0.5;
        }
        return bounceOut(k * 2 - 1) * 0.5 + 0.5;
      }
      function smooth(k) {
        if (k <= 0) {
          return 0;
        }
        if (k >= 1) {
          return 1;
        }
        return k * k * (3 - 2 * k);
      }
      function fade(k) {
        if (k <= 0) {
          return 0;
        }
        if (k >= 1) {
          return 1;
        }
        return k * k * k * (k * (k * 6 - 15) + 10);
      }
      const quadOutIn = _makeOutIn(quadIn, quadOut);
      const cubicOutIn = _makeOutIn(cubicIn, cubicOut);
      const quartOutIn = _makeOutIn(quartIn, quartOut);
      const quintOutIn = _makeOutIn(quintIn, quintOut);
      const sineOutIn = _makeOutIn(sineIn, sineOut);
      const expoOutIn = _makeOutIn(expoIn, expoOut);
      const circOutIn = _makeOutIn(circIn, circOut);
      const elasticOutIn = _makeOutIn(elasticIn, elasticOut);
      const backOutIn = _makeOutIn(backIn, backOut);
      const bounceOutIn = _makeOutIn(bounceIn, bounceOut);
      function _makeOutIn(fnIn, fnOut) {
        return k => {
          if (k < 0.5) {
            return fnOut(k * 2) / 2;
          }
          return fnIn(2 * k - 1) / 2 + 0.5;
        };
      }

      var easing = /*#__PURE__*/Object.freeze({
        __proto__: null,
        backIn: backIn,
        backInOut: backInOut,
        backOut: backOut,
        backOutIn: backOutIn,
        bounceIn: bounceIn,
        bounceInOut: bounceInOut,
        bounceOut: bounceOut,
        bounceOutIn: bounceOutIn,
        circIn: circIn,
        circInOut: circInOut,
        circOut: circOut,
        circOutIn: circOutIn,
        constant: constant,
        cubicIn: cubicIn,
        cubicInOut: cubicInOut,
        cubicOut: cubicOut,
        cubicOutIn: cubicOutIn,
        elasticIn: elasticIn,
        elasticInOut: elasticInOut,
        elasticOut: elasticOut,
        elasticOutIn: elasticOutIn,
        expoIn: expoIn,
        expoInOut: expoInOut,
        expoOut: expoOut,
        expoOutIn: expoOutIn,
        fade: fade,
        linear: linear,
        quadIn: quadIn,
        quadInOut: quadInOut,
        quadOut: quadOut,
        quadOutIn: quadOutIn,
        quartIn: quartIn,
        quartInOut: quartInOut,
        quartOut: quartOut,
        quartOutIn: quartOutIn,
        quintIn: quintIn,
        quintInOut: quintInOut,
        quintOut: quintOut,
        quintOutIn: quintOutIn,
        sineIn: sineIn,
        sineInOut: sineInOut,
        sineOut: sineOut,
        sineOutIn: sineOutIn,
        smooth: smooth
      });
      exports("easing", easing);

      const EasingMethod = exports("EasingMethod", {
        "LINEAR": 0,
        "CONSTANT": 1,
        "QUAD_IN": 2,
        "QUAD_OUT": 3,
        "QUAD_IN_OUT": 4,
        "QUAD_OUT_IN": 5,
        "CUBIC_IN": 6,
        "CUBIC_OUT": 7,
        "CUBIC_IN_OUT": 8,
        "CUBIC_OUT_IN": 9,
        "QUART_IN": 10,
        "QUART_OUT": 11,
        "QUART_IN_OUT": 12,
        "QUART_OUT_IN": 13,
        "QUINT_IN": 14,
        "QUINT_OUT": 15,
        "QUINT_IN_OUT": 16,
        "QUINT_OUT_IN": 17,
        "SINE_IN": 18,
        "SINE_OUT": 19,
        "SINE_IN_OUT": 20,
        "SINE_OUT_IN": 21,
        "EXPO_IN": 22,
        "EXPO_OUT": 23,
        "EXPO_IN_OUT": 24,
        "EXPO_OUT_IN": 25,
        "CIRC_IN": 26,
        "CIRC_OUT": 27,
        "CIRC_IN_OUT": 28,
        "CIRC_OUT_IN": 29,
        "ELASTIC_IN": 30,
        "ELASTIC_OUT": 31,
        "ELASTIC_IN_OUT": 32,
        "ELASTIC_OUT_IN": 33,
        "BACK_IN": 34,
        "BACK_OUT": 35,
        "BACK_IN_OUT": 36,
        "BACK_OUT_IN": 37,
        "BOUNCE_IN": 38,
        "BOUNCE_OUT": 39,
        "BOUNCE_IN_OUT": 40,
        "BOUNCE_OUT_IN": 41,
        "SMOOTH": 42,
        "FADE": 43
      });
      const easingMethodFnMap = {
        [1]: constant,
        [0]: linear,
        [2]: quadIn,
        [3]: quadOut,
        [4]: quadInOut,
        [5]: quadOutIn,
        [6]: cubicIn,
        [7]: cubicOut,
        [8]: cubicInOut,
        [9]: cubicOutIn,
        [10]: quartIn,
        [11]: quartOut,
        [12]: quartInOut,
        [13]: quartOutIn,
        [14]: quintIn,
        [15]: quintOut,
        [16]: quintInOut,
        [17]: quintOutIn,
        [18]: sineIn,
        [19]: sineOut,
        [20]: sineInOut,
        [21]: sineOutIn,
        [22]: expoIn,
        [23]: expoOut,
        [24]: expoInOut,
        [25]: expoOutIn,
        [26]: circIn,
        [27]: circOut,
        [28]: circInOut,
        [29]: circOutIn,
        [30]: elasticIn,
        [31]: elasticOut,
        [32]: elasticInOut,
        [33]: elasticOutIn,
        [34]: backIn,
        [35]: backOut,
        [36]: backInOut,
        [37]: backOutIn,
        [38]: bounceIn,
        [39]: bounceOut,
        [40]: bounceInOut,
        [41]: bounceOutIn,
        [42]: smooth,
        [43]: fade
      };
      function getEasingFn(easingMethod) {
        assertIsTrue(easingMethod in easingMethodFnMap);
        return easingMethodFnMap[easingMethod];
      }

      const REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_START = 0;
      const REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_MASK = 0xFF << REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_START;
      const REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START = 8;
      const REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_MASK = 0xFF << REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START;
      const REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_START = 16;
      const REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_MASK = 0xFF << REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_START;
      assertIsTrue(REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START === REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_START + popCount(REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_MASK));
      assertIsTrue(REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_START === REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START + popCount(REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_MASK));
      const REAL_KEYFRAME_VALUE_DEFAULT_FLAGS = 0 << REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_START | 0 << REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START | 0 << REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_START;
      class RealKeyframeValue extends EditorExtendable {
        constructor() {
          super();
          this.value = 0.0;
          this.rightTangent = 0.0;
          this.rightTangentWeight = 0.0;
          this.leftTangent = 0.0;
          this.leftTangentWeight = 0.0;
          this._flags = REAL_KEYFRAME_VALUE_DEFAULT_FLAGS;
        }
        get interpolationMode() {
          return (this._flags & REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_MASK) >> REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_START;
        }
        set interpolationMode(value) {
          this._flags &= ~REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_MASK;
          this._flags |= value << REAL_KEYFRAME_VALUE_FLAGS_INTERPOLATION_MODE_START;
        }
        get tangentWeightMode() {
          return (this._flags & REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_MASK) >> REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START;
        }
        set tangentWeightMode(value) {
          this._flags &= ~REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_MASK;
          this._flags |= value << REAL_KEYFRAME_VALUE_FLAGS_TANGENT_WEIGHT_MODE_START;
        }
        get easingMethod() {
          return (this._flags & REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_MASK) >> REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_START;
        }
        set easingMethod(value) {
          this._flags &= ~REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_MASK;
          this._flags |= value << REAL_KEYFRAME_VALUE_FLAGS_EASING_METHOD_START;
        }
      }
      CCClass.fastDefine('cc.RealKeyframeValue', RealKeyframeValue, {
        interpolationMode: 0,
        tangentWeightMode: 0,
        value: 0.0,
        rightTangent: 0.0,
        rightTangentWeight: 0.0,
        leftTangent: 0.0,
        leftTangentWeight: 0.0,
        easingMethod: 0,
        [editorExtrasTag]: undefined
      });
      CCClass.Attr.setClassAttr(RealKeyframeValue, editorExtrasTag, 'editorOnly', true);
      getOrCreateSerializationMetadata(RealKeyframeValue).uniquelyReferenced = true;
      function createRealKeyframeValue(params) {
        const realKeyframeValue = new RealKeyframeValue();
        if (typeof params === 'number') {
          realKeyframeValue.value = params;
        } else {
          const {
            interpolationMode,
            tangentWeightMode,
            value,
            rightTangent,
            rightTangentWeight,
            leftTangent,
            leftTangentWeight,
            easingMethod,
            [editorExtrasTag]: editorExtras
          } = params;
          realKeyframeValue.value = value !== null && value !== void 0 ? value : realKeyframeValue.value;
          realKeyframeValue.rightTangent = rightTangent !== null && rightTangent !== void 0 ? rightTangent : realKeyframeValue.rightTangent;
          realKeyframeValue.rightTangentWeight = rightTangentWeight !== null && rightTangentWeight !== void 0 ? rightTangentWeight : realKeyframeValue.rightTangentWeight;
          realKeyframeValue.leftTangent = leftTangent !== null && leftTangent !== void 0 ? leftTangent : realKeyframeValue.leftTangent;
          realKeyframeValue.leftTangentWeight = leftTangentWeight !== null && leftTangentWeight !== void 0 ? leftTangentWeight : realKeyframeValue.leftTangentWeight;
          realKeyframeValue.interpolationMode = interpolationMode !== null && interpolationMode !== void 0 ? interpolationMode : realKeyframeValue.interpolationMode;
          realKeyframeValue.tangentWeightMode = tangentWeightMode !== null && tangentWeightMode !== void 0 ? tangentWeightMode : realKeyframeValue.tangentWeightMode;
          realKeyframeValue.easingMethod = easingMethod !== null && easingMethod !== void 0 ? easingMethod : realKeyframeValue.easingMethod;
          if (editorExtras) {
            realKeyframeValue[editorExtrasTag] = editorExtras;
          }
        }
        return realKeyframeValue;
      }
      class RealCurve extends KeyframeCurve {
        constructor() {
          super();
          this.preExtrapolation = 1;
          this.postExtrapolation = 1;
        }
        evaluate(time) {
          const {
            _times: times,
            _values: values
          } = this;
          const nFrames = times.length;
          if (nFrames === 0) {
            return 0.0;
          }
          const firstTime = times[0];
          const lastTime = times[nFrames - 1];
          if (time < firstTime) {
            const {
              preExtrapolation
            } = this;
            const preValue = values[0];
            if (preExtrapolation === 1 || nFrames < 2) {
              return preValue.value;
            }
            switch (preExtrapolation) {
              case 0:
                return linearTrend(firstTime, values[0].value, times[1], values[1].value, time);
              case 2:
                time = wrapRepeat(time, firstTime, lastTime);
                break;
              case 3:
                time = wrapPingPong(time, firstTime, lastTime);
                break;
              default:
                return preValue.value;
            }
          } else if (time > lastTime) {
            const {
              postExtrapolation
            } = this;
            const preFrame = values[nFrames - 1];
            if (postExtrapolation === 1 || nFrames < 2) {
              return preFrame.value;
            }
            switch (postExtrapolation) {
              case 0:
                return linearTrend(lastTime, preFrame.value, times[nFrames - 2], values[nFrames - 2].value, time);
              case 2:
                time = wrapRepeat(time, firstTime, lastTime);
                break;
              case 3:
                time = wrapPingPong(time, firstTime, lastTime);
                break;
              default:
                return preFrame.value;
            }
          }
          const index = binarySearchEpsilon(times, time);
          if (index >= 0) {
            return values[index].value;
          }
          const iNext = ~index;
          {
            assertIsTrue(iNext !== 0 && iNext !== nFrames && nFrames > 1);
          }
          const iPre = iNext - 1;
          const preTime = times[iPre];
          const preValue = values[iPre];
          const nextTime = times[iNext];
          const nextValue = values[iNext];
          {
            assertIsTrue(nextTime > time && time > preTime);
          }
          const dt = nextTime - preTime;
          const ratio = (time - preTime) / dt;
          return evalBetweenTwoKeyFrames(preTime, preValue, nextTime, nextValue, ratio);
        }
        addKeyFrame(time, value) {
          return super.addKeyFrame(time, createRealKeyframeValue(value));
        }
        assignSorted(times, values) {
          if (values !== undefined) {
            assertIsTrue(Array.isArray(times));
            this.setKeyframes(times.slice(), values.map(value => createRealKeyframeValue(value)));
          } else {
            const keyframes = Array.from(times);
            this.setKeyframes(keyframes.map(([time]) => time), keyframes.map(([, value]) => createRealKeyframeValue(value)));
          }
        }
        isConstant(tolerance) {
          if (this._values.length <= 1) {
            return true;
          }
          const firstVal = this._values[0].value;
          return this._values.every(frame => approx(frame.value, firstVal, tolerance));
        }
        [serializeTag](output, context) {
          if (!context.toCCON) {
            output.writeThis();
            return;
          }
          const {
            _times: times,
            _values: keyframeValues
          } = this;
          const nKeyframes = times.length;
          const dataSize = 0 + OVERFLOW_BYTES + OVERFLOW_BYTES + FRAME_COUNT_BYTES$1 + TIME_BYTES$1 * nKeyframes + REAL_KEY_FRAME_VALUE_MAX_SIZE * nKeyframes;
          const dataView = new DataView(new ArrayBuffer(dataSize));
          let currentOffset = 0;
          dataView.setUint8(currentOffset, this.preExtrapolation);
          currentOffset += OVERFLOW_BYTES;
          dataView.setUint8(currentOffset, this.postExtrapolation);
          currentOffset += OVERFLOW_BYTES;
          dataView.setUint32(currentOffset, nKeyframes, true);
          currentOffset += FRAME_COUNT_BYTES$1;
          times.forEach((time, index) => dataView.setFloat32(currentOffset + TIME_BYTES$1 * index, time, true));
          currentOffset += TIME_BYTES$1 * nKeyframes;
          for (const keyframeValue of keyframeValues) {
            currentOffset = saveRealKeyFrameValue(dataView, keyframeValue, currentOffset);
          }
          const bytes = new Uint8Array(dataView.buffer, 0, currentOffset);
          output.writeProperty('bytes', bytes);
          const keyframeValueEditorExtras = keyframeValues.map(keyframeValue => keyframeValue[editorExtrasTag]);
          if (keyframeValueEditorExtras.some(extras => extras !== undefined)) {
            output.writeProperty(`keyframeValueEditorExtras`, keyframeValueEditorExtras);
          }
        }
        [deserializeTag](input, context) {
          if (!context.fromCCON) {
            input.readThis();
            return;
          }
          const bytes = input.readProperty('bytes');
          const dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
          let currentOffset = 0;
          this.preExtrapolation = dataView.getUint8(currentOffset);
          currentOffset += OVERFLOW_BYTES;
          this.postExtrapolation = dataView.getUint8(currentOffset);
          currentOffset += OVERFLOW_BYTES;
          const nKeyframes = dataView.getUint32(currentOffset, true);
          currentOffset += FRAME_COUNT_BYTES$1;
          const times = Array.from({
            length: nKeyframes
          }, (_, index) => dataView.getFloat32(currentOffset + TIME_BYTES$1 * index, true));
          currentOffset += TIME_BYTES$1 * nKeyframes;
          const keyframeValues = new Array(nKeyframes);
          for (let iKeyFrame = 0; iKeyFrame < nKeyframes; ++iKeyFrame) {
            const keyframeValue = createRealKeyframeValue({});
            currentOffset = loadRealKeyFrameValue(dataView, keyframeValue, currentOffset);
            keyframeValues[iKeyFrame] = keyframeValue;
          }
          assertIsTrue(currentOffset === bytes.byteLength);
          const keyframeValueEditorExtras = input.readProperty(`keyframeValueEditorExtras`);
          if (keyframeValueEditorExtras) {
            assertIsTrue(keyframeValueEditorExtras.length === nKeyframes);
            keyframeValueEditorExtras.forEach((extras, index) => keyframeValues[index][editorExtrasTag] = extras);
          }
          this._times = times;
          this._values = keyframeValues;
        }
      } exports("RealCurve", RealCurve);
      CCClass.fastDefine('cc.RealCurve', RealCurve, {
        _times: [],
        _values: [],
        preExtrapolation: 1,
        postExtrapolation: 1
      });
      const FLAGS_EASING_METHOD_BITS_START = 8;
      const FLAG_EASING_METHOD_MASK = 0xFF << FLAGS_EASING_METHOD_BITS_START;
      const OVERFLOW_BYTES = 1;
      const FRAME_COUNT_BYTES$1 = 4;
      const TIME_BYTES$1 = 4;
      const KEY_FRAME_VALUE_FLAGS_BYTES = 4;
      const VALUE_BYTES$1 = 4;
      const INTERPOLATION_MODE_BYTES$1 = 1;
      const TANGENT_WEIGHT_MODE_BYTES = 1;
      const LEFT_TANGENT_BYTES = 4;
      const LEFT_TANGENT_WEIGHT_BYTES = 4;
      const RIGHT_TANGENT_BYTES = 4;
      const RIGHT_TANGENT_WEIGHT_BYTES = 4;
      const {
        interpolationMode: DEFAULT_INTERPOLATION_MODE,
        tangentWeightMode: DEFAULT_TANGENT_WEIGHT_MODE,
        leftTangent: DEFAULT_LEFT_TANGENT,
        leftTangentWeight: DEFAULT_LEFT_TANGENT_WEIGHT,
        rightTangent: DEFAULT_RIGHT_TANGENT,
        rightTangentWeight: DEFAULT_RIGHT_TANGENT_WEIGHT
      } = createRealKeyframeValue({});
      const REAL_KEY_FRAME_VALUE_MAX_SIZE = KEY_FRAME_VALUE_FLAGS_BYTES + VALUE_BYTES$1 + INTERPOLATION_MODE_BYTES$1 + TANGENT_WEIGHT_MODE_BYTES + LEFT_TANGENT_BYTES + LEFT_TANGENT_WEIGHT_BYTES + RIGHT_TANGENT_BYTES + RIGHT_TANGENT_WEIGHT_BYTES + 0;
      function saveRealKeyFrameValue(dataView, keyframeValue, offset) {
        let flags = 0;
        let currentOffset = offset;
        const pFlags = currentOffset;
        currentOffset += KEY_FRAME_VALUE_FLAGS_BYTES;
        const {
          value,
          interpolationMode,
          tangentWeightMode,
          rightTangent,
          rightTangentWeight,
          leftTangent,
          leftTangentWeight,
          easingMethod
        } = keyframeValue;
        dataView.setFloat32(currentOffset, value, true);
        currentOffset += VALUE_BYTES$1;
        if (interpolationMode !== DEFAULT_INTERPOLATION_MODE) {
          flags |= 2;
          dataView.setUint8(currentOffset, interpolationMode);
          currentOffset += INTERPOLATION_MODE_BYTES$1;
        }
        if (tangentWeightMode !== DEFAULT_TANGENT_WEIGHT_MODE) {
          flags |= 4;
          dataView.setUint8(currentOffset, tangentWeightMode);
          currentOffset += TANGENT_WEIGHT_MODE_BYTES;
        }
        if (leftTangent !== DEFAULT_LEFT_TANGENT) {
          flags |= 8;
          dataView.setFloat32(currentOffset, leftTangent, true);
          currentOffset += LEFT_TANGENT_BYTES;
        }
        if (leftTangentWeight !== DEFAULT_LEFT_TANGENT_WEIGHT) {
          flags |= 16;
          dataView.setFloat32(currentOffset, leftTangentWeight, true);
          currentOffset += LEFT_TANGENT_WEIGHT_BYTES;
        }
        if (rightTangent !== DEFAULT_RIGHT_TANGENT) {
          flags |= 32;
          dataView.setFloat32(currentOffset, rightTangent, true);
          currentOffset += RIGHT_TANGENT_BYTES;
        }
        if (rightTangentWeight !== DEFAULT_RIGHT_TANGENT_WEIGHT) {
          flags |= 64;
          dataView.setFloat32(currentOffset, rightTangentWeight, true);
          currentOffset += RIGHT_TANGENT_WEIGHT_BYTES;
        }
        flags |= easingMethod << FLAGS_EASING_METHOD_BITS_START;
        dataView.setUint32(pFlags, flags, true);
        return currentOffset;
      }
      function loadRealKeyFrameValue(dataView, keyframeValue, offset) {
        let currentOffset = offset;
        const flags = dataView.getUint32(currentOffset, true);
        currentOffset += KEY_FRAME_VALUE_FLAGS_BYTES;
        keyframeValue.value = dataView.getFloat32(currentOffset, true);
        currentOffset += VALUE_BYTES$1;
        if (flags & 2) {
          keyframeValue.interpolationMode = dataView.getUint8(currentOffset);
          currentOffset += INTERPOLATION_MODE_BYTES$1;
        }
        if (flags & 4) {
          keyframeValue.tangentWeightMode = dataView.getUint8(currentOffset);
          currentOffset += TANGENT_WEIGHT_MODE_BYTES;
        }
        if (flags & 8) {
          keyframeValue.leftTangent = dataView.getFloat32(currentOffset, true);
          currentOffset += LEFT_TANGENT_BYTES;
        }
        if (flags & 16) {
          keyframeValue.leftTangentWeight = dataView.getFloat32(currentOffset, true);
          currentOffset += LEFT_TANGENT_WEIGHT_BYTES;
        }
        if (flags & 32) {
          keyframeValue.rightTangent = dataView.getFloat32(currentOffset, true);
          currentOffset += RIGHT_TANGENT_BYTES;
        }
        if (flags & 64) {
          keyframeValue.rightTangentWeight = dataView.getFloat32(currentOffset, true);
          currentOffset += RIGHT_TANGENT_WEIGHT_BYTES;
        }
        const easingMethod = (flags & FLAG_EASING_METHOD_MASK) >> FLAGS_EASING_METHOD_BITS_START;
        keyframeValue.easingMethod = easingMethod;
        return currentOffset;
      }
      function wrapRepeat(time, prevTime, nextTime) {
        return prevTime + repeat$2(time - prevTime, nextTime - prevTime);
      }
      function wrapPingPong(time, prevTime, nextTime) {
        return prevTime + pingPong(time - prevTime, nextTime - prevTime);
      }
      function linearTrend(prevTime, prevValue, nextTime, nextValue, time) {
        const slope = (nextValue - prevValue) / (nextTime - prevTime);
        return prevValue + (time - prevTime) * slope;
      }
      function evalBetweenTwoKeyFrames(prevTime, prevValue, nextTime, nextValue, ratio) {
        const dt = nextTime - prevTime;
        switch (prevValue.interpolationMode) {
          default:
          case 1:
            return prevValue.value;
          case 0:
            {
              const transformedRatio = prevValue.easingMethod === 0 ? ratio : getEasingFn(prevValue.easingMethod)(ratio);
              return lerp(prevValue.value, nextValue.value, transformedRatio);
            }
          case 2:
            {
              const ONE_THIRD = 1.0 / 3.0;
              const {
                rightTangent: prevTangent,
                rightTangentWeight: prevTangentWeightSpecified
              } = prevValue;
              const prevTangentWeightEnabled = isRightTangentWeightEnabled(prevValue.tangentWeightMode);
              const {
                leftTangent: nextTangent,
                leftTangentWeight: nextTangentWeightSpecified
              } = nextValue;
              const nextTangentWeightEnabled = isLeftTangentWeightEnabled(nextValue.tangentWeightMode);
              if (!prevTangentWeightEnabled && !nextTangentWeightEnabled) {
                const p1 = prevValue.value + ONE_THIRD * prevTangent * dt;
                const p2 = nextValue.value - ONE_THIRD * nextTangent * dt;
                return bezierInterpolate(prevValue.value, p1, p2, nextValue.value, ratio);
              } else {
                let prevTangentWeight = 0.0;
                if (prevTangentWeightEnabled) {
                  prevTangentWeight = prevTangentWeightSpecified;
                } else {
                  const x = dt;
                  const y = dt * prevTangent;
                  prevTangentWeight = Math.sqrt(x * x + y * y) * ONE_THIRD;
                }
                const angle0 = Math.atan(prevTangent);
                const tx0 = Math.cos(angle0) * prevTangentWeight + prevTime;
                const ty0 = Math.sin(angle0) * prevTangentWeight + prevValue.value;
                let nextTangentWeight = 0.0;
                if (nextTangentWeightEnabled) {
                  nextTangentWeight = nextTangentWeightSpecified;
                } else {
                  const x = dt;
                  const y = dt * nextTangent;
                  nextTangentWeight = Math.sqrt(x * x + y * y) * ONE_THIRD;
                }
                const angle1 = Math.atan(nextTangent);
                const tx1 = -Math.cos(angle1) * nextTangentWeight + nextTime;
                const ty1 = -Math.sin(angle1) * nextTangentWeight + nextValue.value;
                const dx = dt;
                const u0x = (tx0 - prevTime) / dx;
                const u1x = (tx1 - prevTime) / dx;
                const u0y = ty0;
                const u1y = ty1;
                const coeff0 = 0.0;
                const coeff1 = 3.0 * u0x;
                const coeff2 = 3.0 * u1x - 6.0 * u0x;
                const coeff3 = 3.0 * (u0x - u1x) + 1.0;
                const solutions = [0.0, 0.0, 0.0];
                const nSolutions = solveCubic(coeff0 - ratio, coeff1, coeff2, coeff3, solutions);
                const param = getParamFromCubicSolution(solutions, nSolutions, ratio);
                const y = bezierInterpolate(prevValue.value, u0y, u1y, nextValue.value, param);
                return y;
              }
            }
        }
      }
      function isLeftTangentWeightEnabled(tangentWeightMode) {
        return (tangentWeightMode & 1) !== 0;
      }
      function isRightTangentWeightEnabled(tangentWeightMode) {
        return (tangentWeightMode & 2) !== 0;
      }
      function bezierInterpolate(p0, p1, p2, p3, t) {
        const u = 1 - t;
        const coeff0 = u * u * u;
        const coeff1 = 3 * u * u * t;
        const coeff2 = 3 * u * t * t;
        const coeff3 = t * t * t;
        return coeff0 * p0 + coeff1 * p1 + coeff2 * p2 + coeff3 * p3;
      }
      function getParamFromCubicSolution(solutions, solutionsCount, x) {
        let param = x;
        if (solutionsCount === 1) {
          param = solutions[0];
        } else {
          param = -Infinity;
          for (let iSolution = 0; iSolution < solutionsCount; ++iSolution) {
            const solution = solutions[iSolution];
            if (solution >= 0.0 && solution <= 1.0) {
              if (solution > param) {
                param = solution;
              }
            }
          }
          if (param === -Infinity) {
            param = 0.0;
          }
        }
        return param;
      }

      function bezier$1(C1, C2, C3, C4, t) {
        const t1 = 1 - t;
        return t1 * (t1 * (C1 + (C2 * 3 - C1) * t) + C3 * 3 * t * t) + C4 * t * t * t;
      }
      legacyCC.bezier = bezier$1;
      const cos$2 = Math.cos;
      const acos$1 = Math.acos;
      const max$2 = Math.max;
      const pi = Math.PI;
      const tau = 2 * pi;
      const sqrt = Math.sqrt;
      function crt(v) {
        if (v < 0) {
          return -Math.pow(-v, 1 / 3);
        } else {
          return Math.pow(v, 1 / 3);
        }
      }
      function cardano(curve, x) {
        const pa = x - 0;
        const pb = x - curve[0];
        const pc = x - curve[2];
        const pd = x - 1;
        const pa3 = pa * 3;
        const pb3 = pb * 3;
        const pc3 = pc * 3;
        const d = -pa + pb3 - pc3 + pd;
        const rd = 1 / d;
        const r3 = 1 / 3;
        const a = (pa3 - 6 * pb + pc3) * rd;
        const a3 = a * r3;
        const b = (-pa3 + pb3) * rd;
        const c = pa * rd;
        const p = (3 * b - a * a) * r3;
        const p3 = p * r3;
        const q = (2 * a * a * a - 9 * a * b + 27 * c) / 27;
        const q2 = q / 2;
        const discriminant = q2 * q2 + p3 * p3 * p3;
        let u1;
        let v1;
        let x1;
        let x2;
        let x3;
        if (discriminant < 0) {
          const mp3 = -p * r3;
          const mp33 = mp3 * mp3 * mp3;
          const r = sqrt(mp33);
          const t = -q / (2 * r);
          const cosphi = t < -1 ? -1 : t > 1 ? 1 : t;
          const phi = acos$1(cosphi);
          const crtr = crt(r);
          const t1 = 2 * crtr;
          x1 = t1 * cos$2(phi * r3) - a3;
          x2 = t1 * cos$2((phi + tau) * r3) - a3;
          x3 = t1 * cos$2((phi + 2 * tau) * r3) - a3;
          if (x1 >= 0 && x1 <= 1) {
            if (x2 >= 0 && x2 <= 1) {
              if (x3 >= 0 && x3 <= 1) {
                return max$2(x1, x2, x3);
              } else {
                return max$2(x1, x2);
              }
            } else if (x3 >= 0 && x3 <= 1) {
              return max$2(x1, x3);
            } else {
              return x1;
            }
          } else if (x2 >= 0 && x2 <= 1) {
            if (x3 >= 0 && x3 <= 1) {
              return max$2(x2, x3);
            } else {
              return x2;
            }
          } else {
            return x3;
          }
        } else if (discriminant === 0) {
          u1 = q2 < 0 ? crt(-q2) : -crt(q2);
          x1 = 2 * u1 - a3;
          x2 = -u1 - a3;
          if (x1 >= 0 && x1 <= 1) {
            if (x2 >= 0 && x2 <= 1) {
              return max$2(x1, x2);
            } else {
              return x1;
            }
          } else {
            return x2;
          }
        } else {
          const sd = sqrt(discriminant);
          u1 = crt(-q2 + sd);
          v1 = crt(q2 + sd);
          x1 = u1 - v1 - a3;
          return x1;
        }
      }
      function bezierByTime(controlPoints, x) {
        const percent = cardano(controlPoints, x);
        const p1y = controlPoints[1];
        const p2y = controlPoints[3];
        return ((1 - percent) * (p1y + (p2y - p1y) * percent) * 3 + percent * percent) * percent;
      }
      legacyCC.bezierByTime = bezierByTime;

      var _dec$2p, _class$2p, _class2$20, _initializer$1T, _initializer2$1q, _initializer3$12, _dec2$1C, _class4$r, _class5$p, _initializer4$V, _initializer5$H;
      const QuatInterpolationMode = exports("QuatInterpolationMode", {
        "SLERP": 0,
        "CONSTANT": 1
      });
      let QuatKeyframeValue = (_dec$2p = ccclass$H('cc.QuatKeyframeValue'), _dec$2p(_class$2p = uniquelyReferenced(_class$2p = (_class2$20 = class QuatKeyframeValue {
        constructor({
          value,
          interpolationMode,
          easingMethod
        } = {}) {
          this.interpolationMode = _initializer$1T && _initializer$1T();
          this.value = _initializer2$1q && _initializer2$1q();
          this.easingMethod = _initializer3$12 && _initializer3$12();
          this.value = value ? Quat.clone(value) : this.value;
          this.interpolationMode = interpolationMode !== null && interpolationMode !== void 0 ? interpolationMode : this.interpolationMode;
          this.easingMethod = easingMethod !== null && easingMethod !== void 0 ? easingMethod : this.easingMethod;
        }
      }, (_initializer$1T = applyDecoratedInitializer(_class2$20.prototype, "interpolationMode", [serializable$l], function () {
        return 0;
      }), _initializer2$1q = applyDecoratedInitializer(_class2$20.prototype, "value", [serializable$l], function () {
        return Quat.clone(Quat.IDENTITY);
      }), _initializer3$12 = applyDecoratedInitializer(_class2$20.prototype, "easingMethod", [serializable$l], function () {
        return 0;
      })), _class2$20)) || _class$2p) || _class$2p);
      function createQuatKeyframeValue(params) {
        return new QuatKeyframeValue(params);
      }
      let QuatCurve = exports("QuatCurve", (_dec2$1C = ccclass$H('cc.QuatCurve'), _dec2$1C(_class4$r = (_class5$p = class QuatCurve extends KeyframeCurve {
        constructor() {
          super();
          this.preExtrapolation = _initializer4$V && _initializer4$V();
          this.postExtrapolation = _initializer5$H && _initializer5$H();
        }
        evaluate(time, quat) {
          var _quat;
          (_quat = quat) !== null && _quat !== void 0 ? _quat : quat = new Quat();
          const {
            _times: times,
            _values: values,
            postExtrapolation,
            preExtrapolation
          } = this;
          const nFrames = times.length;
          if (nFrames === 0) {
            return quat;
          }
          const firstTime = times[0];
          const lastTime = times[nFrames - 1];
          if (time < firstTime) {
            const preValue = values[0];
            switch (preExtrapolation) {
              case 2:
                time = firstTime + repeat$2(time - firstTime, lastTime - firstTime);
                break;
              case 3:
                time = firstTime + pingPong(time - firstTime, lastTime - firstTime);
                break;
              case 1:
              default:
                return Quat.copy(quat, preValue.value);
            }
          } else if (time > lastTime) {
            const preValue = values[nFrames - 1];
            switch (postExtrapolation) {
              case 2:
                time = firstTime + repeat$2(time - firstTime, lastTime - firstTime);
                break;
              case 3:
                time = firstTime + pingPong(time - firstTime, lastTime - firstTime);
                break;
              case 1:
              default:
                return Quat.copy(quat, preValue.value);
            }
          }
          const index = binarySearchEpsilon(times, time);
          if (index >= 0) {
            return Quat.copy(quat, values[index].value);
          }
          const iNext = ~index;
          assertIsTrue(iNext !== 0 && iNext !== nFrames && nFrames > 1);
          const iPre = iNext - 1;
          const preTime = times[iPre];
          const preValue = values[iPre];
          const nextTime = times[iNext];
          const nextValue = values[iNext];
          assertIsTrue(nextTime > time && time > preTime);
          const dt = nextTime - preTime;
          const ratio = (time - preTime) / dt;
          switch (preValue.interpolationMode) {
            default:
            case 1:
              return Quat.copy(quat, preValue.value);
            case 0:
              {
                const {
                  easingMethod
                } = preValue;
                const transformedRatio = easingMethod === 0 ? ratio : Array.isArray(easingMethod) ? bezierByTime(easingMethod, ratio) : getEasingFn(easingMethod)(ratio);
                return Quat.slerp(quat, preValue.value, nextValue.value, transformedRatio);
              }
          }
        }
        addKeyFrame(time, value) {
          const keyframeValue = new QuatKeyframeValue(value);
          return super.addKeyFrame(time, keyframeValue);
        }
        assignSorted(times, values) {
          if (values !== undefined) {
            assertIsTrue(Array.isArray(times));
            this.setKeyframes(times.slice(), values.map(value => createQuatKeyframeValue(value)));
          } else {
            const keyframes = Array.from(times);
            this.setKeyframes(keyframes.map(([time]) => time), keyframes.map(([, value]) => createQuatKeyframeValue(value)));
          }
        }
        [serializeTag](output, context) {
          if (!context.toCCON) {
            output.writeThis();
            return;
          }
          const {
            _times: times,
            _values: keyframeValues
          } = this;
          let interpolationModeRepeated = true;
          keyframeValues.forEach((keyframeValue, _index, [firstKeyframeValue]) => {
            if (interpolationModeRepeated && keyframeValue.interpolationMode !== firstKeyframeValue.interpolationMode) {
              interpolationModeRepeated = false;
            }
          });
          const nKeyframes = times.length;
          const nFrames = nKeyframes;
          const interpolationModesSize = INTERPOLATION_MODE_BYTES * (interpolationModeRepeated ? 1 : nFrames);
          const easingMethodsSize = keyframeValues.reduce((result, {
            easingMethod
          }) => result += Array.isArray(easingMethod) ? EASING_METHOD_BYTES + EASING_METHOD_BEZIER_COMPONENT_BYTES * 4 : EASING_METHOD_BYTES, 0);
          let dataSize = 0;
          dataSize += FLAGS_BYTES + FRAME_COUNT_BYTES + TIME_BYTES * nFrames + VALUE_BYTES * 4 * nFrames + easingMethodsSize + interpolationModesSize + 0;
          const dataView = new DataView(new ArrayBuffer(dataSize));
          let P = 0;
          let flags = 0;
          if (interpolationModeRepeated) {
            flags |= 1;
          }
          dataView.setUint32(P, flags, true);
          P += FLAGS_BYTES;
          dataView.setUint32(P, nFrames, true);
          P += FRAME_COUNT_BYTES;
          times.forEach((time, index) => dataView.setFloat32(P + TIME_BYTES * index, time, true));
          P += TIME_BYTES * nFrames;
          keyframeValues.forEach(({
            value: {
              x,
              y,
              z,
              w
            }
          }, index) => {
            const pQuat = P + VALUE_BYTES * 4 * index;
            dataView.setFloat32(pQuat + VALUE_BYTES * 0, x, true);
            dataView.setFloat32(pQuat + VALUE_BYTES * 1, y, true);
            dataView.setFloat32(pQuat + VALUE_BYTES * 2, z, true);
            dataView.setFloat32(pQuat + VALUE_BYTES * 3, w, true);
          });
          P += VALUE_BYTES * 4 * nFrames;
          keyframeValues.forEach(({
            easingMethod
          }, index) => {
            if (!Array.isArray(easingMethod)) {
              dataView.setUint8(P, easingMethod);
              ++P;
            } else {
              dataView.setUint8(P, EASING_METHOD_BEZIER_TAG);
              ++P;
              dataView.setFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 0, easingMethod[0], true);
              dataView.setFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 1, easingMethod[1], true);
              dataView.setFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 2, easingMethod[2], true);
              dataView.setFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 3, easingMethod[3], true);
              P += EASING_METHOD_BEZIER_COMPONENT_BYTES * 4;
            }
          });
          const INTERPOLATION_MODES_START = P;
          P += interpolationModesSize;
          let pInterpolationMode = INTERPOLATION_MODES_START;
          keyframeValues.forEach(({
            interpolationMode
          }) => {
            dataView.setUint8(pInterpolationMode, interpolationMode);
            if (!interpolationModeRepeated) {
              pInterpolationMode += INTERPOLATION_MODE_BYTES;
            }
          });
          const bytes = new Uint8Array(dataView.buffer);
          output.writeProperty('bytes', bytes);
        }
        [deserializeTag](input, context) {
          if (!context.fromCCON) {
            input.readThis();
            return;
          }
          const bytes = input.readProperty('bytes');
          const dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
          let P = 0;
          const flags = dataView.getUint32(P, true);
          P += FLAGS_BYTES;
          const interpolationModeRepeated = flags & 1;
          const nFrames = dataView.getUint32(P, true);
          P += FRAME_COUNT_BYTES;
          const times = Array.from({
            length: nFrames
          }, (_, index) => dataView.getFloat32(P + TIME_BYTES * index, true));
          P += TIME_BYTES * nFrames;
          const P_VALUES = P;
          P += VALUE_BYTES * 4 * nFrames;
          const keyframeValues = Array.from({
            length: nFrames
          }, (_, index) => {
            const pQuat = P_VALUES + VALUE_BYTES * 4 * index;
            const x = dataView.getFloat32(pQuat + VALUE_BYTES * 0, true);
            const y = dataView.getFloat32(pQuat + VALUE_BYTES * 1, true);
            const z = dataView.getFloat32(pQuat + VALUE_BYTES * 2, true);
            const w = dataView.getFloat32(pQuat + VALUE_BYTES * 3, true);
            const easingMethod = dataView.getUint8(P);
            ++P;
            const keyframeValue = createQuatKeyframeValue({
              value: {
                x,
                y,
                z,
                w
              }
            });
            if (easingMethod !== EASING_METHOD_BEZIER_TAG) {
              keyframeValue.easingMethod = easingMethod;
            } else {
              keyframeValue.easingMethod = [dataView.getFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 0, true), dataView.getFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 1, true), dataView.getFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 2, true), dataView.getFloat32(P + EASING_METHOD_BEZIER_COMPONENT_BYTES * 3, true)];
              P += EASING_METHOD_BEZIER_COMPONENT_BYTES * 4;
            }
            return keyframeValue;
          });
          if (interpolationModeRepeated) {
            const interpolationMode = dataView.getUint8(P);
            ++P;
            for (let iKeyframe = 0; iKeyframe < nFrames; ++iKeyframe) {
              keyframeValues[iKeyframe].interpolationMode = interpolationMode;
            }
          } else {
            for (let iKeyframe = 0; iKeyframe < nFrames; ++iKeyframe) {
              const interpolationMode = dataView.getUint8(P + iKeyframe);
              keyframeValues[iKeyframe].interpolationMode = interpolationMode;
            }
            P += nFrames;
          }
          this._times = times;
          this._values = keyframeValues;
        }
      }, (_initializer4$V = applyDecoratedInitializer(_class5$p.prototype, "preExtrapolation", [serializable$l], function () {
        return 1;
      }), _initializer5$H = applyDecoratedInitializer(_class5$p.prototype, "postExtrapolation", [serializable$l], function () {
        return 1;
      })), _class5$p)) || _class4$r));
      const FLAGS_BYTES = 1;
      const FRAME_COUNT_BYTES = 4;
      const TIME_BYTES = 4;
      const VALUE_BYTES = 4;
      const INTERPOLATION_MODE_BYTES = 1;
      const EASING_METHOD_BYTES = 1;
      const EASING_METHOD_BEZIER_TAG = 255;
      const EASING_METHOD_BEZIER_COMPONENT_BYTES = 4;

      var _dec$2o, _class$2o;
      let ObjectCurve = exports("ObjectCurve", (_dec$2o = ccclass$H('cc.ObjectCurve'), _dec$2o(_class$2o = class ObjectCurve extends KeyframeCurve {
        evaluate(time) {
          const iSearch = this.searchKeyframe(time);
          if (iSearch >= 0) {
            return this._values[iSearch];
          }
          const iPrev = clamp$1(~iSearch - 1, 0, this._values.length - 1);
          return this._values[iPrev];
        }
      }) || _class$2o));

      const Mode$1 = Enum({
        Blend: 0,
        Fixed: 1
      });
      class ColorKey {
        constructor() {
          this.color = Color$1.WHITE.clone();
          this.time = 0;
        }
      } exports("ColorKey", ColorKey);
      CCClass.fastDefine('cc.ColorKey', ColorKey, {
        color: Color$1.WHITE.clone(),
        time: 0
      });
      CCClass.Attr.setClassAttr(ColorKey, 'color', 'visible', true);
      CCClass.Attr.setClassAttr(ColorKey, 'time', 'visible', true);
      class AlphaKey {
        constructor() {
          this.alpha = 1;
          this.time = 0;
        }
      } exports("AlphaKey", AlphaKey);
      CCClass.fastDefine('cc.AlphaKey', AlphaKey, {
        alpha: 1,
        time: 0
      });
      CCClass.Attr.setClassAttr(AlphaKey, 'alpha', 'visible', true);
      CCClass.Attr.setClassAttr(AlphaKey, 'time', 'visible', true);
      class Gradient {
        constructor() {
          this.colorKeys = [];
          this.alphaKeys = [];
          this.mode = Mode$1.Blend;
        }
        setKeys(colorKeys, alphaKeys) {
          this.colorKeys = colorKeys;
          this.alphaKeys = alphaKeys;
        }
        sortKeys() {
          if (this.colorKeys.length > 1) {
            this.colorKeys.sort((a, b) => a.time - b.time);
          }
          if (this.alphaKeys.length > 1) {
            this.alphaKeys.sort((a, b) => a.time - b.time);
          }
        }
        evaluate(time) {
          return this.evaluateFast(new Color$1(), time);
        }
        evaluateFast(out, time) {
          this.getRGB(out, time);
          out.a = this.getAlpha(time);
          return out;
        }
        randomColor() {
          return this.getRandomColor(new Color$1());
        }
        getRandomColor(out) {
          const c = this.colorKeys[Math.trunc(random() * this.colorKeys.length)];
          const a = this.alphaKeys[Math.trunc(random() * this.alphaKeys.length)];
          out.set(c.color);
          out.a = a.alpha;
          return out;
        }
        getRGB(out, time) {
          const colorKeys = this.colorKeys;
          const length = colorKeys.length;
          if (length > 1) {
            time = repeat$2(time, 1.0 + EPSILON$2);
            for (let i = 1; i < length; ++i) {
              const preTime = colorKeys[i - 1].time;
              const curTime = colorKeys[i].time;
              if (time >= preTime && time < curTime) {
                if (this.mode === Mode$1.Fixed) {
                  Color$1.copy(out, colorKeys[i].color);
                  return out;
                }
                const factor = (time - preTime) / (curTime - preTime);
                Color$1.lerp(out, colorKeys[i - 1].color, colorKeys[i].color, factor);
                return out;
              }
            }
            const lastIndex = length - 1;
            if (approx(time, colorKeys[lastIndex].time, EPSILON$2)) {
              Color$1.copy(out, colorKeys[lastIndex].color);
            } else if (time < colorKeys[0].time) {
              Color$1.lerp(out, Color$1.BLACK, colorKeys[0].color, time / colorKeys[0].time);
            } else if (time > colorKeys[lastIndex].time) {
              Color$1.lerp(out, colorKeys[lastIndex].color, Color$1.BLACK, (time - colorKeys[lastIndex].time) / (1 - colorKeys[lastIndex].time));
            }
          } else if (length === 1) {
            Color$1.copy(out, colorKeys[0].color);
          } else {
            Color$1.copy(out, Color$1.WHITE);
          }
          return out;
        }
        getAlpha(time) {
          const basicAlpha = 0;
          const alphaKeys = this.alphaKeys;
          const length = alphaKeys.length;
          if (length > 1) {
            time = repeat$2(time, 1.0 + EPSILON$2);
            for (let i = 1; i < length; ++i) {
              const preTime = alphaKeys[i - 1].time;
              const curTime = alphaKeys[i].time;
              if (time >= preTime && time < curTime) {
                if (this.mode === Mode$1.Fixed) {
                  return alphaKeys[i].alpha;
                }
                const factor = (time - preTime) / (curTime - preTime);
                return lerp(alphaKeys[i - 1].alpha, alphaKeys[i].alpha, factor);
              }
            }
            const lastIndex = length - 1;
            if (approx(time, alphaKeys[lastIndex].time, EPSILON$2)) {
              return alphaKeys[lastIndex].alpha;
            } else if (time < alphaKeys[0].time) {
              return lerp(basicAlpha, alphaKeys[0].alpha, time / alphaKeys[0].time);
            } else if (time > alphaKeys[lastIndex].time) {
              return lerp(alphaKeys[lastIndex].alpha, basicAlpha, (time - alphaKeys[lastIndex].time) / (1 - alphaKeys[lastIndex].time));
            }
            return 255;
          } else if (length === 1) {
            return alphaKeys[0].alpha;
          } else {
            return 255;
          }
        }
      } exports("Gradient", Gradient);
      Gradient.Mode = Mode$1;
      CCClass.fastDefine('cc.Gradient', Gradient, {
        colorKeys: [],
        alphaKeys: [],
        mode: Mode$1.Blend
      });
      CCClass.Attr.setClassAttr(Gradient, 'colorKeys', 'visible', true);
      CCClass.Attr.setClassAttr(Gradient, 'alphaKeys', 'visible', true);
      CCClass.Attr.setClassAttr(Gradient, 'mode', 'visible', true);

      const LOOK_FORWARD = 3;
      class Keyframe {
        constructor() {
          this.time = 0;
          this.value = 0;
          this.inTangent = 0;
          this.outTangent = 0;
        }
      }
      CCClass.fastDefine('cc.Keyframe', Keyframe, {
        time: 0,
        value: 0,
        inTangent: 0,
        outTangent: 0
      });
      class OptimizedKey {
        constructor() {
          this.index = void 0;
          this.time = void 0;
          this.endTime = void 0;
          this.coefficient = void 0;
          this.index = -1;
          this.time = 0;
          this.endTime = 0;
          this.coefficient = new Float32Array(4);
        }
        evaluate(T) {
          const t = T - this.time;
          return evalOptCurve(t, this.coefficient);
        }
      }
      function evalOptCurve(t, coefs) {
        return t * (t * (t * coefs[0] + coefs[1]) + coefs[2]) + coefs[3];
      }
      class AnimationCurve {
        get _internalCurve() {
          return this._curve;
        }
        get keyFrames() {
          return Array.from(this._curve.keyframes()).map(([time, value]) => {
            const legacyKeyframe = new Keyframe();
            legacyKeyframe.time = time;
            legacyKeyframe.value = value.value;
            legacyKeyframe.inTangent = value.leftTangent;
            legacyKeyframe.outTangent = value.rightTangent;
            return legacyKeyframe;
          });
        }
        set keyFrames(value) {
          this._curve.assignSorted(value.map(legacyCurve => [legacyCurve.time, {
            interpolationMode: 2,
            value: legacyCurve.value,
            leftTangent: legacyCurve.inTangent,
            rightTangent: legacyCurve.outTangent
          }]));
        }
        get preWrapMode() {
          return toLegacyWrapMode(this._curve.preExtrapolation);
        }
        set preWrapMode(value) {
          this._curve.preExtrapolation = fromLegacyWrapMode(value);
        }
        get postWrapMode() {
          return toLegacyWrapMode(this._curve.postExtrapolation);
        }
        set postWrapMode(value) {
          this._curve.postExtrapolation = fromLegacyWrapMode(value);
        }
        constructor(keyFrames = null) {
          this._curve = void 0;
          this.cachedKey = void 0;
          if (keyFrames instanceof RealCurve) {
            this._curve = keyFrames;
          } else {
            const curve = new RealCurve();
            this._curve = curve;
            curve.preExtrapolation = 2;
            curve.postExtrapolation = 1;
            if (!keyFrames) {
              curve.assignSorted([[0.0, {
                interpolationMode: 2,
                value: 1.0
              }], [1.0, {
                interpolationMode: 2,
                value: 1.0
              }]]);
            } else {
              curve.assignSorted(keyFrames.map(legacyKeyframe => [legacyKeyframe.time, {
                interpolationMode: 2,
                value: legacyKeyframe.value,
                leftTangent: legacyKeyframe.inTangent,
                rightTangent: legacyKeyframe.outTangent
              }]));
            }
          }
          this.cachedKey = new OptimizedKey();
        }
        addKey(keyFrame) {
          if (!keyFrame) {
            this._curve.clear();
          } else {
            this._curve.addKeyFrame(keyFrame.time, {
              interpolationMode: 2,
              value: keyFrame.value,
              leftTangent: keyFrame.inTangent,
              rightTangent: keyFrame.outTangent
            });
          }
        }
        evaluate_slow(time) {
          return this._curve.evaluate(time);
        }
        evaluate(time) {
          const {
            cachedKey,
            _curve: curve
          } = this;
          const nKeyframes = curve.keyFramesCount;
          const lastKeyframeIndex = nKeyframes - 1;
          let wrappedTime = time;
          const extrapolationMode = time < 0 ? curve.preExtrapolation : curve.postExtrapolation;
          const startTime = curve.getKeyframeTime(0);
          const endTime = curve.getKeyframeTime(lastKeyframeIndex);
          switch (extrapolationMode) {
            case 2:
              wrappedTime = repeat$2(time - startTime, endTime - startTime) + startTime;
              break;
            case 3:
              wrappedTime = pingPong(time - startTime, endTime - startTime) + startTime;
              break;
            case 1:
            default:
              wrappedTime = clamp$1(time, startTime, endTime);
              break;
          }
          if (wrappedTime >= cachedKey.time && wrappedTime < cachedKey.endTime) {
            return cachedKey.evaluate(wrappedTime);
          }
          const leftIndex = this.findIndex(cachedKey, wrappedTime);
          const rightIndex = Math.min(leftIndex + 1, lastKeyframeIndex);
          this.calcOptimizedKey(cachedKey, leftIndex, rightIndex);
          return cachedKey.evaluate(wrappedTime);
        }
        calcOptimizedKey(optKey, leftIndex, rightIndex) {
          const lhsTime = this._curve.getKeyframeTime(leftIndex);
          const rhsTime = this._curve.getKeyframeTime(rightIndex);
          const {
            value: lhsValue,
            leftTangent: lhsOutTangent
          } = this._curve.getKeyframeValue(leftIndex);
          const {
            value: rhsValue,
            rightTangent: rhsInTangent
          } = this._curve.getKeyframeValue(rightIndex);
          optKey.index = leftIndex;
          optKey.time = lhsTime;
          optKey.endTime = rhsTime;
          const dx = rhsTime - lhsTime;
          const dy = rhsValue - lhsValue;
          const length = 1 / (dx * dx);
          const d1 = lhsOutTangent * dx;
          const d2 = rhsInTangent * dx;
          optKey.coefficient[0] = (d1 + d2 - dy - dy) * length / dx;
          optKey.coefficient[1] = (dy + dy + dy - d1 - d1 - d2) * length;
          optKey.coefficient[2] = lhsOutTangent;
          optKey.coefficient[3] = lhsValue;
        }
        findIndex(optKey, t) {
          const {
            _curve: curve
          } = this;
          const nKeyframes = curve.keyFramesCount;
          const cachedIndex = optKey.index;
          if (cachedIndex !== -1) {
            const cachedTime = curve.getKeyframeTime(cachedIndex);
            if (t > cachedTime) {
              for (let i = 0; i < LOOK_FORWARD; i++) {
                const currIndex = cachedIndex + i;
                if (currIndex + 1 < nKeyframes && curve.getKeyframeTime(currIndex + 1) > t) {
                  return currIndex;
                }
              }
            } else {
              for (let i = 0; i < LOOK_FORWARD; i++) {
                const currIndex = cachedIndex - i;
                if (currIndex >= 0 && curve.getKeyframeTime(currIndex - 1) <= t) {
                  return currIndex - 1;
                }
              }
            }
          }
          let left = 0;
          let right = nKeyframes;
          let mid;
          while (right - left > 1) {
            mid = Math.floor((left + right) / 2);
            if (curve.getKeyframeTime(mid) >= t) {
              right = mid;
            } else {
              left = mid;
            }
          }
          return left;
        }
      }
      AnimationCurve.defaultKF = [{
        time: 0,
        value: 1,
        inTangent: 0,
        outTangent: 0
      }, {
        time: 1,
        value: 1,
        inTangent: 0,
        outTangent: 0
      }];
      CCClass.fastDefine('cc.AnimationCurve', AnimationCurve, {
        _curve: null
      });
      const WrapModeMask = {
        "Default": 0,
        "Normal": 1,
        "Loop": 2,
        "ShouldWrap": 4,
        "Clamp": 8,
        "PingPong": 22,
        "Reverse": 36
      };
      function fromLegacyWrapMode(legacyWrapMode) {
        switch (legacyWrapMode) {
          default:
          case 0:
          case 1:
          case 8:
            return 1;
          case 22:
            return 3;
          case 2:
            return 2;
        }
      }
      function toLegacyWrapMode(extrapolationMode) {
        switch (extrapolationMode) {
          default:
          case 0:
          case 1:
            return 8;
          case 3:
            return 22;
          case 2:
            return 2;
        }
      }
      function constructLegacyCurveAndConvert() {
        const curve = new RealCurve();
        curve.assignSorted([[0.0, {
          interpolationMode: 2,
          value: 1.0
        }], [1.0, {
          interpolationMode: 2,
          value: 1.0
        }]]);
        return curve;
      }

      const SplineMode = {
        "LINEAR": 0,
        "BEZIER": 1,
        "CATMULL_ROM": 2
      };
      const SPLINE_WHOLE_INDEX = 0xffffffff;
      const _v0 = new Vec3();
      const _v1 = new Vec3();
      const _v2 = new Vec3();
      const _v3 = new Vec3();
      class Spline {
        constructor(mode = 2, knots = []) {
          this._type = void 0;
          this._knots = [];
          this._type = 1024;
          this._mode = mode;
          for (let i = 0; i < knots.length; i++) {
            this._knots[i] = new Vec3(knots[i]);
          }
        }
        static create(mode, knots = []) {
          return new Spline(mode, knots);
        }
        static clone(s) {
          return new Spline(s.mode, s.knots);
        }
        static copy(out, s) {
          out._mode = s.mode;
          out._knots.length = 0;
          const knots = s.knots;
          const length = knots.length;
          for (let i = 0; i < length; i++) {
            out._knots[i] = new Vec3(knots[i]);
          }
          return out;
        }
        get type() {
          return this._type;
        }
        get mode() {
          return this._mode;
        }
        get knots() {
          return this._knots;
        }
        setModeAndKnots(mode, knots) {
          this._mode = mode;
          this._knots.length = 0;
          for (let i = 0; i < knots.length; i++) {
            this._knots[i] = new Vec3(knots[i]);
          }
        }
        clearKnots() {
          this._knots.length = 0;
        }
        getKnotCount() {
          return this._knots.length;
        }
        addKnot(knot) {
          this._knots.push(new Vec3(knot));
        }
        insertKnot(index, knot) {
          const item = new Vec3(knot);
          if (index >= this._knots.length) {
            this._knots.push(item);
            return;
          }
          this._knots.splice(index, 0, item);
        }
        removeKnot(index) {
          assertsArrayIndex(this._knots, index);
          this._knots.splice(index, 1);
        }
        setKnot(index, knot) {
          assertsArrayIndex(this._knots, index);
          this._knots[index].set(knot);
        }
        getKnot(index) {
          assertsArrayIndex(this._knots, index);
          return this._knots[index];
        }
        getPoint(t, index = SPLINE_WHOLE_INDEX) {
          t = clamp$1(t, 0.0, 1.0);
          const segments = this.getSegments();
          if (segments === 0) {
            return new Vec3();
          }
          if (index === SPLINE_WHOLE_INDEX) {
            const deltaT = 1.0 / segments;
            index = Math.floor(t / deltaT);
            t = t % deltaT / deltaT;
          }
          const knots = this._knots;
          if (index >= segments) {
            return new Vec3(knots[knots.length - 1]);
          }
          switch (this._mode) {
            case 0:
              return Spline.calcLinear(knots[index], knots[index + 1], t);
            case 1:
              {
                const start = index * 4;
                return Spline.calcBezier(knots[start], knots[start + 1], knots[start + 2], knots[start + 3], t);
              }
            case 2:
              {
                const v0 = index > 0 ? knots[index - 1] : knots[index];
                const v3 = index + 2 < knots.length ? knots[index + 2] : knots[index + 1];
                return Spline.calcCatmullRom(v0, knots[index], knots[index + 1], v3, t);
              }
            default:
              return new Vec3();
          }
        }
        getPoints(num, index = SPLINE_WHOLE_INDEX) {
          if (num === 0) {
            return [];
          }
          if (num === 1) {
            const point = this.getPoint(0.0, index);
            return [point];
          }
          const points = [];
          const deltaT = 1.0 / (num - 1.0);
          for (let i = 0; i < num; i++) {
            const t = i * deltaT;
            const point = this.getPoint(t, index);
            points.push(point);
          }
          return points;
        }
        getSegments() {
          const count = this._knots.length;
          switch (this._mode) {
            case 0:
            case 2:
              if (count < 2) {
                warnID(14300);
                return 0;
              }
              return count - 1;
            case 1:
              if (count < 4 || count % 4 !== 0) {
                warnID(14301);
                return 0;
              }
              return count / 4;
            default:
              assertID(false, 16407);
              return 0;
          }
        }
        static calcLinear(v0, v1, t) {
          const result = new Vec3();
          Vec3.multiplyScalar(_v0, v0, 1.0 - t);
          Vec3.multiplyScalar(_v1, v1, t);
          Vec3.add(result, _v0, _v1);
          return result;
        }
        static calcBezier(v0, v1, v2, v3, t) {
          const result = new Vec3();
          const s = 1.0 - t;
          Vec3.multiplyScalar(_v0, v0, s * s * s);
          Vec3.multiplyScalar(_v1, v1, 3.0 * t * s * s);
          Vec3.multiplyScalar(_v2, v2, 3.0 * t * t * s);
          Vec3.multiplyScalar(_v3, v3, t * t * t);
          Vec3.add(_v0, _v0, _v1);
          Vec3.add(_v2, _v2, _v3);
          Vec3.add(result, _v0, _v2);
          return result;
        }
        static calcCatmullRom(v0, v1, v2, v3, t) {
          const result = new Vec3();
          const t2 = t * t;
          const t3 = t2 * t;
          Vec3.multiplyScalar(_v0, v0, -0.5 * t3 + t2 - 0.5 * t);
          Vec3.multiplyScalar(_v1, v1, 1.5 * t3 - 2.5 * t2 + 1.0);
          Vec3.multiplyScalar(_v2, v2, -1.5 * t3 + 2.0 * t2 + 0.5 * t);
          Vec3.multiplyScalar(_v3, v3, 0.5 * t3 - 0.5 * t2);
          Vec3.add(_v0, _v0, _v1);
          Vec3.add(_v2, _v2, _v3);
          Vec3.add(result, _v0, _v2);
          return result;
        }
      }

      const ERaycastMode = {
        "ALL": 0,
        "CLOSEST": 1,
        "ANY": 2
      };

      replaceProperty(intersect, 'intersect', [{
        name: 'ray_aabb',
        newName: 'rayAABB'
      }, {
        name: 'ray_plane',
        newName: 'rayPlane'
      }, {
        name: 'ray_triangle',
        newName: 'rayTriangle'
      }, {
        name: 'ray_sphere',
        newName: 'raySphere'
      }, {
        name: 'ray_obb',
        newName: 'rayOBB'
      }, {
        name: 'ray_capsule',
        newName: 'rayCapsule'
      }, {
        name: 'ray_subMesh',
        newName: 'raySubMesh'
      }, {
        name: 'ray_mesh',
        newName: 'rayMesh'
      }, {
        name: 'ray_model',
        newName: 'rayModel'
      }, {
        name: 'line_plane',
        newName: 'linePlane'
      }, {
        name: 'line_triangle',
        newName: 'lineTriangle'
      }, {
        name: 'line_aabb',
        newName: 'lineAABB'
      }, {
        name: 'line_obb',
        newName: 'lineOBB'
      }, {
        name: 'line_sphere',
        newName: 'lineSphere'
      }, {
        name: 'aabb_aabb',
        newName: 'aabbWithAABB'
      }, {
        name: 'aabb_obb',
        newName: 'aabbWithOBB'
      }, {
        name: 'aabb_plane',
        newName: 'aabbPlane'
      }, {
        name: 'aabb_frustum',
        newName: 'aabbFrustum'
      }, {
        name: 'aabbFrustum_accurate',
        newName: 'aabbFrustumAccurate'
      }, {
        name: 'obb_point',
        newName: 'obbPoint'
      }, {
        name: 'obb_plane',
        newName: 'obbPlane'
      }, {
        name: 'obb_frustum',
        newName: 'obbFrustum'
      }, {
        name: 'obbFrustum_accurate',
        newName: 'obbFrustumAccurate'
      }, {
        name: 'obb_obb',
        newName: 'obbWithOBB'
      }, {
        name: 'obb_capsule',
        newName: 'obbCapsule'
      }, {
        name: 'sphere_plane',
        newName: 'spherePlane'
      }, {
        name: 'sphere_frustum',
        newName: 'sphereFrustum'
      }, {
        name: 'sphereFrustum_accurate',
        newName: 'sphereFrustumAccurate'
      }, {
        name: 'sphere_sphere',
        newName: 'sphereWithSphere'
      }, {
        name: 'sphere_aabb',
        newName: 'sphereAABB'
      }, {
        name: 'sphere_obb',
        newName: 'sphereOBB'
      }, {
        name: 'sphere_capsule',
        newName: 'sphereCapsule'
      }, {
        name: 'capsule_capsule',
        newName: 'capsuleWithCapsule'
      }]);
      function deprecatedClassMessage(oldClassName, newClassName) {
        warn(`${oldClassName} is deprecated, please use ${newClassName} instead.`);
      }
      class line extends Line {
        constructor() {
          super();
          deprecatedClassMessage('line', 'Line');
        }
      }
      class plane extends Plane {
        constructor() {
          super();
          deprecatedClassMessage('plane', 'Plane');
        }
      }
      class ray extends Ray {
        constructor() {
          super();
          deprecatedClassMessage('ray', 'Ray');
        }
      }
      class triangle extends Triangle {
        constructor() {
          super();
          deprecatedClassMessage('triangle', 'Triangle');
        }
      }
      class sphere extends Sphere {
        constructor() {
          super();
          deprecatedClassMessage('sphere', 'Sphere');
        }
      }
      class aabb extends AABB {
        constructor() {
          super();
          deprecatedClassMessage('aabb', 'AABB');
        }
      }
      class obb extends OBB {
        constructor() {
          super();
          deprecatedClassMessage('obb', 'OBB');
        }
      }
      class capsule extends Capsule {
        constructor() {
          super();
          deprecatedClassMessage('capsule', 'Capsule');
        }
      }
      class frustum extends Frustum {
        constructor() {
          super();
          deprecatedClassMessage('frustum', 'Frustum');
        }
      }

      var geometry = /*#__PURE__*/Object.freeze({
        __proto__: null,
        AABB: AABB,
        AnimationCurve: AnimationCurve,
        Capsule: Capsule,
        ERaycastMode: ERaycastMode,
        Frustum: Frustum,
        Keyframe: Keyframe,
        Line: Line,
        OBB: OBB,
        OptimizedKey: OptimizedKey,
        Plane: Plane,
        Ray: Ray,
        Sphere: Sphere,
        Spline: Spline,
        SplineMode: SplineMode,
        Triangle: Triangle,
        WrapModeMask: WrapModeMask,
        aabb: aabb,
        capsule: capsule,
        constructLegacyCurveAndConvert: constructLegacyCurveAndConvert,
        distance: distance,
        enums: ShapeType,
        evalOptCurve: evalOptCurve,
        frustum: frustum,
        intersect: intersect,
        line: line,
        obb: obb,
        plane: plane,
        ray: ray,
        sphere: sphere,
        triangle: triangle
      });
      exports("geometry", geometry);

      class System {
        constructor() {
          this._id = '';
          this._priority = 0;
          this._executeInEditMode = false;
        }
        set priority(value) {
          this._priority = value;
        }
        get priority() {
          return this._priority;
        }
        set id(id) {
          this._id = id;
        }
        get id() {
          return this._id;
        }
        static sortByPriority(a, b) {
          if (a._priority < b._priority) {
            return 1;
          } else if (a._priority > b.priority) {
            return -1;
          } else {
            return 0;
          }
        }
        init() {}
        update(dt) {}
        postUpdate(dt) {}
        destroy() {}
      } exports("System", System);
      System.Priority = Enum({
        LOW: 0,
        MEDIUM: 100,
        HIGH: 200,
        SCHEDULER: 1 << 31 >>> 0
      });

      const MAX_POOL_SIZE$1 = 20;
      const idGenerator$1 = new IDGenerator('Scheduler');
      class ListEntry {
        static get(target, priority, paused, markedForDeletion) {
          let result = ListEntry._listEntries.pop();
          if (result) {
            result.target = target;
            result.priority = priority;
            result.paused = paused;
            result.markedForDeletion = markedForDeletion;
          } else {
            result = new ListEntry(target, priority, paused, markedForDeletion);
          }
          return result;
        }
        static put(entry) {
          if (ListEntry._listEntries.length < MAX_POOL_SIZE$1) {
            entry.target = null;
            ListEntry._listEntries.push(entry);
          }
        }
        constructor(target, priority, paused, markedForDeletion) {
          this.target = void 0;
          this.priority = void 0;
          this.paused = void 0;
          this.markedForDeletion = void 0;
          this.target = target;
          this.priority = priority;
          this.paused = paused;
          this.markedForDeletion = markedForDeletion;
        }
      }
      ListEntry._listEntries = [];
      class HashUpdateEntry {
        static get(list, entry, target, callback) {
          let result = HashUpdateEntry._hashUpdateEntries.pop();
          if (result) {
            result.list = list;
            result.entry = entry;
            result.target = target;
            result.callback = callback;
          } else {
            result = new HashUpdateEntry(list, entry, target, callback);
          }
          return result;
        }
        static put(entry) {
          if (HashUpdateEntry._hashUpdateEntries.length < MAX_POOL_SIZE$1) {
            entry.list = entry.entry = entry.target = entry.callback = null;
            HashUpdateEntry._hashUpdateEntries.push(entry);
          }
        }
        constructor(list, entry, target, callback) {
          this.list = void 0;
          this.entry = void 0;
          this.target = void 0;
          this.callback = void 0;
          this.list = list;
          this.entry = entry;
          this.target = target;
          this.callback = callback;
        }
      }
      HashUpdateEntry._hashUpdateEntries = [];
      class HashTimerEntry {
        static get(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
          let result = HashTimerEntry._hashTimerEntries.pop();
          if (result) {
            result.timers = timers;
            result.target = target;
            result.timerIndex = timerIndex;
            result.currentTimer = currentTimer;
            result.currentTimerSalvaged = currentTimerSalvaged;
            result.paused = paused;
          } else {
            result = new HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused);
          }
          return result;
        }
        static put(entry) {
          if (HashTimerEntry._hashTimerEntries.length < MAX_POOL_SIZE$1) {
            entry.timers = entry.target = entry.currentTimer = null;
            HashTimerEntry._hashTimerEntries.push(entry);
          }
        }
        constructor(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
          this.timers = void 0;
          this.target = void 0;
          this.timerIndex = void 0;
          this.currentTimer = void 0;
          this.currentTimerSalvaged = void 0;
          this.paused = void 0;
          this.timers = timers;
          this.target = target;
          this.timerIndex = timerIndex;
          this.currentTimer = currentTimer;
          this.currentTimerSalvaged = currentTimerSalvaged;
          this.paused = paused;
        }
      }
      HashTimerEntry._hashTimerEntries = [];
      class CallbackTimer {
        static get() {
          return CallbackTimer._timers.pop() || new CallbackTimer();
        }
        static put(timer) {
          if (CallbackTimer._timers.length < MAX_POOL_SIZE$1 && !timer._lock) {
            timer._scheduler = timer._target = timer._callback = null;
            CallbackTimer._timers.push(timer);
          }
        }
        constructor() {
          this._lock = void 0;
          this._scheduler = void 0;
          this._elapsed = void 0;
          this._runForever = void 0;
          this._useDelay = void 0;
          this._timesExecuted = void 0;
          this._repeat = void 0;
          this._delay = void 0;
          this._interval = void 0;
          this._target = void 0;
          this._callback = void 0;
          this._lock = false;
          this._scheduler = null;
          this._elapsed = -1;
          this._runForever = false;
          this._useDelay = false;
          this._timesExecuted = 0;
          this._repeat = 0;
          this._delay = 0;
          this._interval = 0;
          this._target = null;
        }
        initWithCallback(scheduler, callback, target, seconds, repeat, delay) {
          this._lock = false;
          this._scheduler = scheduler;
          this._target = target;
          this._callback = callback;
          this._timesExecuted = 0;
          this._elapsed = -1;
          this._interval = seconds;
          this._delay = delay;
          this._useDelay = this._delay > 0;
          this._repeat = repeat;
          this._runForever = this._repeat === legacyCC.macro.REPEAT_FOREVER;
          return true;
        }
        getInterval() {
          return this._interval;
        }
        setInterval(interval) {
          this._interval = interval;
        }
        update(dt) {
          if (this._elapsed === -1) {
            this._elapsed = 0;
            this._timesExecuted = 0;
          } else {
            this._elapsed += dt;
            if (this._runForever && !this._useDelay) {
              if (this._elapsed >= this._interval) {
                this.trigger();
                this._elapsed = 0;
              }
            } else {
              if (this._useDelay) {
                if (this._elapsed >= this._delay) {
                  this.trigger();
                  this._elapsed -= this._delay;
                  this._timesExecuted += 1;
                  this._useDelay = false;
                }
              } else if (this._elapsed >= this._interval) {
                this.trigger();
                this._elapsed = 0;
                this._timesExecuted += 1;
              }
              if (this._callback && !this._runForever && this._timesExecuted > this._repeat) {
                this.cancel();
              }
            }
          }
        }
        getCallback() {
          return this._callback;
        }
        trigger() {
          if (this._target && this._callback) {
            this._lock = true;
            this._callback.call(this._target, this._elapsed);
            this._lock = false;
          }
        }
        cancel() {
          if (this._scheduler && this._callback && this._target) {
            this._scheduler.unscheduleForTimer(this, this._target);
          }
        }
      }
      CallbackTimer._timers = [];
      class Scheduler extends System {
        static enableForTarget(target) {
          let found = false;
          if (target.uuid) {
            found = true;
          } else if (target.id) {
            found = true;
          }
          if (!found) {
            target.id = idGenerator$1.getNewId();
          }
        }
        constructor() {
          super();
          this._timeScale = void 0;
          this._updatesNegList = void 0;
          this._updates0List = void 0;
          this._updatesPosList = void 0;
          this._hashForUpdates = void 0;
          this._hashForTimers = void 0;
          this._currentTarget = void 0;
          this._currentTargetSalvaged = void 0;
          this._updateHashLocked = void 0;
          this._arrayForTimers = void 0;
          this._timeScale = 1.0;
          this._updatesNegList = [];
          this._updates0List = [];
          this._updatesPosList = [];
          this._hashForUpdates = createMap(true);
          this._hashForTimers = createMap(true);
          this._currentTarget = null;
          this._currentTargetSalvaged = false;
          this._updateHashLocked = false;
          this._arrayForTimers = [];
        }
        setTimeScale(timeScale) {
          this._timeScale = timeScale;
        }
        getTimeScale() {
          return this._timeScale;
        }
        update(dt) {
          this._updateHashLocked = true;
          if (this._timeScale !== 1) {
            dt *= this._timeScale;
          }
          let i;
          let list;
          let len;
          let entry;
          for (i = 0, list = this._updatesNegList, len = list.length; i < len; i++) {
            entry = list[i];
            if (!entry.paused && !entry.markedForDeletion && entry.target) {
              var _entry$target$update, _entry$target;
              (_entry$target$update = (_entry$target = entry.target).update) === null || _entry$target$update === void 0 ? void 0 : _entry$target$update.call(_entry$target, dt);
            }
          }
          for (i = 0, list = this._updates0List, len = list.length; i < len; i++) {
            entry = list[i];
            if (!entry.paused && !entry.markedForDeletion && entry.target) {
              var _entry$target$update2, _entry$target2;
              (_entry$target$update2 = (_entry$target2 = entry.target).update) === null || _entry$target$update2 === void 0 ? void 0 : _entry$target$update2.call(_entry$target2, dt);
            }
          }
          for (i = 0, list = this._updatesPosList, len = list.length; i < len; i++) {
            entry = list[i];
            if (!entry.paused && !entry.markedForDeletion && entry.target) {
              var _entry$target$update3, _entry$target3;
              (_entry$target$update3 = (_entry$target3 = entry.target).update) === null || _entry$target$update3 === void 0 ? void 0 : _entry$target$update3.call(_entry$target3, dt);
            }
          }
          let elt;
          const arr = this._arrayForTimers;
          for (i = 0; i < arr.length; i++) {
            var _this$_currentTarget$;
            elt = arr[i];
            this._currentTarget = elt;
            this._currentTargetSalvaged = false;
            if (!elt.paused && elt.timers) {
              for (elt.timerIndex = 0; elt.timerIndex < elt.timers.length; ++elt.timerIndex) {
                elt.currentTimer = elt.timers[elt.timerIndex];
                elt.currentTimerSalvaged = false;
                elt.currentTimer.update(dt);
                elt.currentTimer = null;
              }
            }
            if (this._currentTargetSalvaged && ((_this$_currentTarget$ = this._currentTarget.timers) === null || _this$_currentTarget$ === void 0 ? void 0 : _this$_currentTarget$.length) === 0) {
              this._removeHashElement(this._currentTarget);
              --i;
            }
          }
          for (i = 0, list = this._updatesNegList; i < list.length;) {
            entry = list[i];
            if (entry.markedForDeletion) {
              this._removeUpdateFromHash(entry);
            } else {
              i++;
            }
          }
          for (i = 0, list = this._updates0List; i < list.length;) {
            entry = list[i];
            if (entry.markedForDeletion) {
              this._removeUpdateFromHash(entry);
            } else {
              i++;
            }
          }
          for (i = 0, list = this._updatesPosList; i < list.length;) {
            entry = list[i];
            if (entry.markedForDeletion) {
              this._removeUpdateFromHash(entry);
            } else {
              i++;
            }
          }
          this._updateHashLocked = false;
          this._currentTarget = null;
        }
        schedule(callbackTmp, targetTmp, interval, repeat, delay, paused) {
          var _repeat, _delay;
          let callback;
          let target;
          if (typeof callbackTmp !== 'function') {
            warnID(1514);
            callback = targetTmp;
            target = callbackTmp;
          } else {
            callback = callbackTmp;
            target = targetTmp;
          }
          if (arguments.length === 3 || arguments.length === 4 || arguments.length === 5) {
            paused = !!repeat;
            repeat = legacyCC.macro.REPEAT_FOREVER;
            delay = 0;
          }
          assertID(Boolean(target), 1502);
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          let element = this._hashForTimers[targetId];
          if (!element) {
            element = HashTimerEntry.get(null, target, 0, null, false, Boolean(paused));
            this._arrayForTimers.push(element);
            this._hashForTimers[targetId] = element;
          } else if (element.paused !== paused) {
            warnID(1511);
          }
          let timer;
          let i;
          if (element.timers == null) {
            element.timers = [];
          } else {
            for (i = 0; i < element.timers.length; ++i) {
              timer = element.timers[i];
              if (timer && callback === timer.getCallback()) {
                logID(1507, timer.getInterval(), interval);
                timer.setInterval(interval);
                return;
              }
            }
          }
          timer = CallbackTimer.get();
          timer.initWithCallback(this, callback, target, interval, (_repeat = repeat) !== null && _repeat !== void 0 ? _repeat : 0, (_delay = delay) !== null && _delay !== void 0 ? _delay : 0);
          element.timers.push(timer);
          if (this._currentTarget === element && this._currentTargetSalvaged) {
            this._currentTargetSalvaged = false;
          }
        }
        scheduleUpdate(target, priority, paused) {
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          const hashElement = this._hashForUpdates[targetId];
          if (hashElement && hashElement.entry) {
            if (hashElement.entry.priority !== priority) {
              if (this._updateHashLocked) {
                logID(1506);
                hashElement.entry.markedForDeletion = false;
                hashElement.entry.paused = paused;
                return;
              } else {
                this.unscheduleUpdate(target);
              }
            } else {
              hashElement.entry.markedForDeletion = false;
              hashElement.entry.paused = paused;
              return;
            }
          }
          const listElement = ListEntry.get(target, priority, paused, false);
          let ppList;
          if (priority === 0) {
            ppList = this._updates0List;
            this._appendIn(ppList, listElement);
          } else {
            ppList = priority < 0 ? this._updatesNegList : this._updatesPosList;
            this._priorityIn(ppList, listElement, priority);
          }
          this._hashForUpdates[targetId] = HashUpdateEntry.get(ppList, listElement, target, null);
        }
        unschedule(callback, target) {
          if (!target || !callback) {
            return;
          }
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          const element = this._hashForTimers[targetId];
          if (element) {
            const timers = element.timers;
            if (!timers) {
              return;
            }
            for (let i = 0, li = timers.length; i < li; i++) {
              const timer = timers[i];
              if (callback === timer.getCallback()) {
                if (timer === element.currentTimer && !element.currentTimerSalvaged) {
                  element.currentTimerSalvaged = true;
                }
                timers.splice(i, 1);
                CallbackTimer.put(timer);
                if (element.timerIndex >= i) {
                  element.timerIndex--;
                }
                if (timers.length === 0) {
                  if (this._currentTarget === element) {
                    this._currentTargetSalvaged = true;
                  } else {
                    this._removeHashElement(element);
                  }
                }
                return;
              }
            }
          }
        }
        unscheduleForTimer(timerToUnschedule, target) {
          const targetId = target.uuid || target.id;
          const element = this._hashForTimers[targetId];
          const timers = element.timers;
          if (!timers || timers.length === 0) {
            return;
          }
          for (let i = timers.length - 1; i >= 0; i--) {
            const timer = timers[i];
            if (timer === timerToUnschedule) {
              timers.splice(i, 1);
              CallbackTimer.put(timer);
              if (element.timerIndex >= i) {
                element.timerIndex--;
              }
              if (timers.length === 0) {
                this._currentTargetSalvaged = true;
              }
              return;
            }
          }
        }
        unscheduleUpdate(target) {
          if (!target) {
            return;
          }
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          const element = this._hashForUpdates[targetId];
          if (element !== null && element !== void 0 && element.entry) {
            if (this._updateHashLocked) {
              element.entry.markedForDeletion = true;
            } else {
              this._removeUpdateFromHash(element.entry);
            }
          }
        }
        unscheduleAllForTarget(target) {
          if (!target) {
            return;
          }
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          const element = this._hashForTimers[targetId];
          if (element !== null && element !== void 0 && element.timers) {
            const timers = element.timers;
            if (element.currentTimer && timers.indexOf(element.currentTimer) > -1 && !element.currentTimerSalvaged) {
              element.currentTimerSalvaged = true;
            }
            for (let i = 0, l = timers.length; i < l; i++) {
              CallbackTimer.put(timers[i]);
            }
            timers.length = 0;
            if (this._currentTarget === element) {
              this._currentTargetSalvaged = true;
            } else {
              this._removeHashElement(element);
            }
          }
          this.unscheduleUpdate(target);
        }
        unscheduleAll() {
          this.unscheduleAllWithMinPriority(System.Priority.SCHEDULER);
        }
        unscheduleAllWithMinPriority(minPriority) {
          let i;
          let element;
          const arr = this._arrayForTimers;
          for (i = arr.length - 1; i >= 0; i--) {
            element = arr[i];
            if (element.target) {
              this.unscheduleAllForTarget(element.target);
            }
          }
          let entry;
          let temp_length = 0;
          if (minPriority < 0) {
            for (i = 0; i < this._updatesNegList.length;) {
              var _entry;
              temp_length = this._updatesNegList.length;
              entry = this._updatesNegList[i];
              if ((_entry = entry) !== null && _entry !== void 0 && _entry.target && entry.priority >= minPriority) {
                this.unscheduleUpdate(entry.target);
              }
              if (temp_length === this._updatesNegList.length) {
                i++;
              }
            }
          }
          if (minPriority <= 0) {
            for (i = 0; i < this._updates0List.length;) {
              var _entry2;
              temp_length = this._updates0List.length;
              entry = this._updates0List[i];
              if ((_entry2 = entry) !== null && _entry2 !== void 0 && _entry2.target) {
                this.unscheduleUpdate(entry.target);
              }
              if (temp_length === this._updates0List.length) {
                i++;
              }
            }
          }
          for (i = 0; i < this._updatesPosList.length;) {
            var _entry3;
            temp_length = this._updatesPosList.length;
            entry = this._updatesPosList[i];
            if ((_entry3 = entry) !== null && _entry3 !== void 0 && _entry3.target && entry.priority >= minPriority) {
              this.unscheduleUpdate(entry.target);
            }
            if (temp_length === this._updatesPosList.length) {
              i++;
            }
          }
        }
        isScheduled(callback, target) {
          assertID(Boolean(callback), 1508);
          assertID(Boolean(target), 1509);
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return false;
          }
          const element = this._hashForTimers[targetId];
          if (!element) {
            return false;
          }
          if (element.timers == null) {
            return false;
          } else {
            const timers = element.timers;
            for (let i = 0; i < timers.length; ++i) {
              const timer = timers[i];
              if (callback === timer.getCallback()) {
                return true;
              }
            }
            return false;
          }
        }
        pauseAllTargets() {
          return this.pauseAllTargetsWithMinPriority(System.Priority.SCHEDULER);
        }
        pauseAllTargetsWithMinPriority(minPriority) {
          const idsWithSelectors = [];
          let element;
          const locArrayForTimers = this._arrayForTimers;
          let i;
          let li;
          for (i = 0, li = locArrayForTimers.length; i < li; i++) {
            var _element;
            element = locArrayForTimers[i];
            if ((_element = element) !== null && _element !== void 0 && _element.target) {
              element.paused = true;
              idsWithSelectors.push(element.target);
            }
          }
          let entry;
          if (minPriority < 0) {
            for (i = 0; i < this._updatesNegList.length; i++) {
              var _entry4;
              entry = this._updatesNegList[i];
              if ((_entry4 = entry) !== null && _entry4 !== void 0 && _entry4.target) {
                if (entry.priority >= minPriority) {
                  entry.paused = true;
                  idsWithSelectors.push(entry.target);
                }
              }
            }
          }
          if (minPriority <= 0) {
            for (i = 0; i < this._updates0List.length; i++) {
              var _entry5;
              entry = this._updates0List[i];
              if ((_entry5 = entry) !== null && _entry5 !== void 0 && _entry5.target) {
                entry.paused = true;
                idsWithSelectors.push(entry.target);
              }
            }
          }
          for (i = 0; i < this._updatesPosList.length; i++) {
            var _entry6;
            entry = this._updatesPosList[i];
            if ((_entry6 = entry) !== null && _entry6 !== void 0 && _entry6.target) {
              if (entry.priority >= minPriority) {
                entry.paused = true;
                idsWithSelectors.push(entry.target);
              }
            }
          }
          return idsWithSelectors;
        }
        resumeTargets(targetsToResume) {
          if (!targetsToResume) {
            return;
          }
          for (let i = 0; i < targetsToResume.length; i++) {
            this.resumeTarget(targetsToResume[i]);
          }
        }
        pauseTarget(target) {
          assertID(Boolean(target), 1503);
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          const element = this._hashForTimers[targetId];
          if (element) {
            element.paused = true;
          }
          const elementUpdate = this._hashForUpdates[targetId];
          if (elementUpdate !== null && elementUpdate !== void 0 && elementUpdate.entry) {
            elementUpdate.entry.paused = true;
          }
        }
        resumeTarget(target) {
          assertID(Boolean(target), 1504);
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return;
          }
          const element = this._hashForTimers[targetId];
          if (element) {
            element.paused = false;
          }
          const elementUpdate = this._hashForUpdates[targetId];
          if (elementUpdate !== null && elementUpdate !== void 0 && elementUpdate.entry) {
            elementUpdate.entry.paused = false;
          }
        }
        isTargetPaused(target) {
          assertID(Boolean(target), 1505);
          const targetId = target.uuid || target.id;
          if (!targetId) {
            errorID(1510);
            return false;
          }
          const element = this._hashForTimers[targetId];
          if (element) {
            return element.paused;
          }
          const elementUpdate = this._hashForUpdates[targetId];
          if (elementUpdate !== null && elementUpdate !== void 0 && elementUpdate.entry) {
            return elementUpdate.entry.paused;
          }
          return false;
        }
        _removeHashElement(element) {
          if (!element.target) {
            return;
          }
          const targetId = element.target.uuid || element.target.id;
          if (typeof targetId === 'undefined') {
            return;
          }
          delete this._hashForTimers[targetId];
          const arr = this._arrayForTimers;
          for (let i = 0, l = arr.length; i < l; i++) {
            if (arr[i] === element) {
              arr.splice(i, 1);
              break;
            }
          }
          HashTimerEntry.put(element);
        }
        _removeUpdateFromHash(entry) {
          if (!entry.target) {
            return;
          }
          const targetId = entry.target.uuid || entry.target.id;
          if (typeof targetId === 'undefined') {
            return;
          }
          const element = this._hashForUpdates[targetId];
          if (element) {
            const list = element.list;
            const listEntry = element.entry;
            if (list) {
              for (let i = 0, l = list.length; i < l; i++) {
                if (list[i] === listEntry) {
                  list.splice(i, 1);
                  break;
                }
              }
            }
            delete this._hashForUpdates[targetId];
            if (listEntry) {
              ListEntry.put(listEntry);
            }
            HashUpdateEntry.put(element);
          }
        }
        _priorityIn(ppList, listElement, priority) {
          for (let i = 0; i < ppList.length; i++) {
            if (priority < ppList[i].priority) {
              ppList.splice(i, 0, listElement);
              return;
            }
          }
          ppList.push(listElement);
        }
        _appendIn(ppList, listElement) {
          ppList.push(listElement);
        }
      } exports("Scheduler", Scheduler);
      Scheduler.ID = 'scheduler';
      legacyCC.Scheduler = Scheduler;

      const vmath = {};
      replaceProperty(vmath, 'vmath', [{
        name: 'vec2',
        newName: 'Vec2',
        target: math,
        targetName: 'math'
      }, {
        name: 'vec3',
        newName: 'Vec3',
        target: math,
        targetName: 'math'
      }, {
        name: 'vec4',
        newName: 'Vec4',
        target: math,
        targetName: 'math'
      }, {
        name: 'quat',
        newName: 'Quat',
        target: math,
        targetName: 'math'
      }, {
        name: 'mat3',
        newName: 'Mat3',
        target: math,
        targetName: 'math'
      }, {
        name: 'mat4',
        newName: 'Mat4',
        target: math,
        targetName: 'math'
      }, {
        name: 'color4',
        newName: 'Color',
        target: math,
        targetName: 'math'
      }, {
        name: 'rect',
        newName: 'Rect',
        target: math,
        targetName: 'math'
      }, {
        name: 'approx',
        newName: 'approx',
        target: math,
        targetName: 'math'
      }, {
        name: 'EPSILON',
        newName: 'EPSILON',
        target: math,
        targetName: 'math'
      }, {
        name: 'equals',
        newName: 'equals',
        target: math,
        targetName: 'math'
      }, {
        name: 'clamp',
        newName: 'clamp',
        target: math,
        targetName: 'math'
      }, {
        name: 'clamp01',
        newName: 'clamp01',
        target: math,
        targetName: 'math'
      }, {
        name: 'lerp',
        newName: 'lerp',
        target: math,
        targetName: 'math'
      }, {
        name: 'toRadian',
        newName: 'toRadian',
        target: math,
        targetName: 'math'
      }, {
        name: 'toDegree',
        newName: 'toDegree',
        target: math,
        targetName: 'math'
      }, {
        name: 'random',
        newName: 'random',
        target: math,
        targetName: 'math'
      }, {
        name: 'randomRange',
        newName: 'randomRange',
        target: math,
        targetName: 'math'
      }, {
        name: 'randomRangeInt',
        newName: 'randomRangeInt',
        target: math,
        targetName: 'math'
      }, {
        name: 'pseudoRandom',
        newName: 'pseudoRandom',
        target: math,
        targetName: 'math'
      }, {
        name: 'pseudoRandomRangeInt',
        newName: 'pseudoRandomRangeInt',
        target: math,
        targetName: 'math'
      }, {
        name: 'nextPow2',
        newName: 'nextPow2',
        target: math,
        targetName: 'math'
      }, {
        name: 'repeat',
        newName: 'repeat',
        target: math,
        targetName: 'math'
      }, {
        name: 'pingPong',
        newName: 'pingPong',
        target: math,
        targetName: 'math'
      }, {
        name: 'inverseLerp',
        newName: 'inverseLerp',
        target: math,
        targetName: 'math'
      }]);
      legacyCC.vmath = vmath;
      replaceProperty(Scheduler.prototype, 'Scheduler.prototype', [{
        name: 'enableForTarget',
        newName: 'enableForTarget',
        target: Scheduler,
        targetName: 'Scheduler'
      }]);
      replaceProperty(Scheduler, 'Scheduler', [{
        name: 'PRIORITY_SYSTEM',
        newName: 'System.Priority.SCHEDULER',
        customGetter() {
          return System.Priority.SCHEDULER;
        }
      }]);
      removeProperty(Scheduler, 'Scheduler', [{
        name: 'PRIORITY_NON_SYSTEM',
        suggest: 'Use enum` System.Priority` instead'
      }]);

      markAsWarning(js$1, 'js', [{
        name: 'js',
        suggest: `'js.js' is deprecated since v3.7.0, please access 'js' directly instead.`
      }]);

      const getUint8ForString = String.prototype.charCodeAt;
      function getUint8ForArray(idx) {
        return this[idx];
      }
      function murmurhash2_32_gc(input, seed) {
        let l = input.length;
        let h = seed ^ l;
        let i = 0;
        const getUint8 = typeof input === 'string' ? getUint8ForString : getUint8ForArray;
        while (l >= 4) {
          let k = getUint8.call(input, i) & 0xff | (getUint8.call(input, ++i) & 0xff) << 8 | (getUint8.call(input, ++i) & 0xff) << 16 | (getUint8.call(input, ++i) & 0xff) << 24;
          k = (k & 0xffff) * 0x5bd1e995 + (((k >>> 16) * 0x5bd1e995 & 0xffff) << 16);
          k ^= k >>> 24;
          k = (k & 0xffff) * 0x5bd1e995 + (((k >>> 16) * 0x5bd1e995 & 0xffff) << 16);
          h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16) ^ k;
          l -= 4;
          ++i;
        }
        switch (l) {
          case 3:
            h ^= (getUint8.call(input, i + 2) & 0xff) << 16;
          case 2:
            h ^= (getUint8.call(input, i + 1) & 0xff) << 8;
          case 1:
            h ^= getUint8.call(input, i) & 0xff;
            h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16);
            break;
        }
        h ^= h >>> 13;
        h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16);
        h ^= h >>> 15;
        return h >>> 0;
      }

      legacyCC.easing = easing;

      function syncNodeValues(node) {
        const lpos = node._lpos;
        node.setPositionForJS(lpos.x, lpos.y, lpos.z);
        const lscale = node._lscale;
        node.setScaleForJS(lscale.x, lscale.y, lscale.z);
        const lrot = node._lrot;
        node.setRotationForJS(lrot.x, lrot.y, lrot.z, lrot.w);
        const euler = node._euler;
        node.setRotationFromEulerForJS(euler.x, euler.y, euler.z);
      }
      function updateChildrenForDeserialize(node) {
        if (!node) {
          return;
        }
        const children = node.children;
        if (!children) {
          return;
        }
        const len = children.length;
        if (!len) {
          return;
        }
        node._setChildren(children);
        for (let i = 0; i < len; ++i) {
          const child = children[i];
          updateChildrenForDeserialize(child);
        }
      }
      function ExtraEventMethods() {}
      ExtraEventMethods.prototype.once = function once(type, callback, target) {
        return this.on(type, callback, target, true);
      };
      ExtraEventMethods.prototype.targetOff = function targetOff(typeOrTarget) {
        this.removeAll(typeOrTarget);
      };

      var jsbUtils = /*#__PURE__*/Object.freeze({
        __proto__: null,
        ExtraEventMethods: ExtraEventMethods,
        syncNodeValues: syncNodeValues,
        updateChildrenForDeserialize: updateChildrenForDeserialize
      });
      exports("jsbUtils", jsbUtils);

      function shift(array, first, last) {
        assertsArrayIndex(array, first);
        assertsArrayIndex(array, last);
        if (first === last) {
          return array;
        }
        const element = array[first];
        if (first < last) {
          for (let iElement = first + 1; iElement <= last; ++iElement) {
            array[iElement - 1] = array[iElement];
          }
        } else {
          for (let iElement = first; iElement !== last; --iElement) {
            array[iElement] = array[iElement - 1];
          }
        }
        array[last] = element;
        return array;
      }

      class GarbageCollectionManager {
        constructor() {
          this._finalizationRegistry = null;
          this._gcObjects = new WeakMap();
        }
        registerGCObject(gcObject) {
          {
            return gcObject;
          }
        }
        init() {}
        finalizationRegistryCallback(token) {
          const gcObject = this._gcObjects.get(token);
          if (gcObject) {
            this._gcObjects.delete(token);
            gcObject.destroy();
          }
          this._finalizationRegistry.unregister(token);
        }
        destroy() {}
      }
      const garbageCollectionManager = exports("garbageCollectionManager", new GarbageCollectionManager());

      class GCObject {
        constructor() {
          return garbageCollectionManager.registerGCObject(this);
        }
        destroy() {}
      } exports("GCObject", GCObject);

      function deepFlatten(strList, array) {
        for (const item of array) {
          if (Array.isArray(item)) {
            deepFlatten(strList, item);
          } else {
            strList.push(item);
          }
        }
      }
      function flattenCodeArray(array) {
        const separator = '';
        const strList = [];
        deepFlatten(strList, array);
        return strList.join(separator);
      }

      function applyMixins(derivedCtor, baseCtors) {
        baseCtors.forEach(baseCtor => {
          Object.getOwnPropertyNames(baseCtor.prototype).forEach(name => {
            if (name !== 'constructor') {
              Object.defineProperty(derivedCtor.prototype, name, Object.getOwnPropertyDescriptor(baseCtor.prototype, name));
            }
          });
        });
      }

      legacyCC.math = math;
      legacyCC.geometry = geometry;

      const deepCopy = (target, source, Ctor) => {
        for (let i = 0; i < source.length; ++i) {
          if (target.length <= i) target.push(new Ctor());
          target[i].copy(source[i]);
        }
        target.length = source.length;
      };
      const ObjectType = {
        "UNKNOWN": 0,
        "SWAPCHAIN": 1,
        "BUFFER": 2,
        "TEXTURE": 3,
        "RENDER_PASS": 4,
        "FRAMEBUFFER": 5,
        "SAMPLER": 6,
        "SHADER": 7,
        "DESCRIPTOR_SET_LAYOUT": 8,
        "PIPELINE_LAYOUT": 9,
        "PIPELINE_STATE": 10,
        "DESCRIPTOR_SET": 11,
        "INPUT_ASSEMBLER": 12,
        "COMMAND_BUFFER": 13,
        "QUEUE": 14,
        "QUERY_POOL": 15,
        "GLOBAL_BARRIER": 16,
        "TEXTURE_BARRIER": 17,
        "BUFFER_BARRIER": 18,
        "COUNT": 19
      };
      const Status = {
        "UNREADY": 0,
        "FAILED": 1,
        "SUCCESS": 2
      };
      const API = {
        "UNKNOWN": 0,
        "GLES2": 1,
        "GLES3": 2,
        "METAL": 3,
        "VULKAN": 4,
        "NVN": 5,
        "WEBGL": 6,
        "WEBGL2": 7,
        "WEBGPU": 8
      };
      const SurfaceTransform = {
        "IDENTITY": 0,
        "ROTATE_90": 1,
        "ROTATE_180": 2,
        "ROTATE_270": 3
      };
      const Feature = {
        "ELEMENT_INDEX_UINT": 0,
        "INSTANCED_ARRAYS": 1,
        "MULTIPLE_RENDER_TARGETS": 2,
        "BLEND_MINMAX": 3,
        "COMPUTE_SHADER": 4,
        "INPUT_ATTACHMENT_BENEFIT": 5,
        "SUBPASS_COLOR_INPUT": 6,
        "SUBPASS_DEPTH_STENCIL_INPUT": 7,
        "RASTERIZATION_ORDER_NOCOHERENT": 8,
        "MULTI_SAMPLE_RESOLVE_DEPTH_STENCIL": 9,
        "COUNT": 10
      };
      const Format = {
        "UNKNOWN": 0,
        "A8": 1,
        "L8": 2,
        "LA8": 3,
        "R8": 4,
        "R8SN": 5,
        "R8UI": 6,
        "R8I": 7,
        "R16F": 8,
        "R16UI": 9,
        "R16I": 10,
        "R32F": 11,
        "R32UI": 12,
        "R32I": 13,
        "RG8": 14,
        "RG8SN": 15,
        "RG8UI": 16,
        "RG8I": 17,
        "RG16F": 18,
        "RG16UI": 19,
        "RG16I": 20,
        "RG32F": 21,
        "RG32UI": 22,
        "RG32I": 23,
        "RGB8": 24,
        "SRGB8": 25,
        "RGB8SN": 26,
        "RGB8UI": 27,
        "RGB8I": 28,
        "RGB16F": 29,
        "RGB16UI": 30,
        "RGB16I": 31,
        "RGB32F": 32,
        "RGB32UI": 33,
        "RGB32I": 34,
        "RGBA8": 35,
        "BGRA8": 36,
        "SRGB8_A8": 37,
        "RGBA8SN": 38,
        "RGBA8UI": 39,
        "RGBA8I": 40,
        "RGBA16F": 41,
        "RGBA16UI": 42,
        "RGBA16I": 43,
        "RGBA32F": 44,
        "RGBA32UI": 45,
        "RGBA32I": 46,
        "R5G6B5": 47,
        "R11G11B10F": 48,
        "RGB5A1": 49,
        "RGBA4": 50,
        "RGB10A2": 51,
        "RGB10A2UI": 52,
        "RGB9E5": 53,
        "DEPTH": 54,
        "DEPTH_STENCIL": 55,
        "BC1": 56,
        "BC1_ALPHA": 57,
        "BC1_SRGB": 58,
        "BC1_SRGB_ALPHA": 59,
        "BC2": 60,
        "BC2_SRGB": 61,
        "BC3": 62,
        "BC3_SRGB": 63,
        "BC4": 64,
        "BC4_SNORM": 65,
        "BC5": 66,
        "BC5_SNORM": 67,
        "BC6H_UF16": 68,
        "BC6H_SF16": 69,
        "BC7": 70,
        "BC7_SRGB": 71,
        "ETC_RGB8": 72,
        "ETC2_RGB8": 73,
        "ETC2_SRGB8": 74,
        "ETC2_RGB8_A1": 75,
        "ETC2_SRGB8_A1": 76,
        "ETC2_RGBA8": 77,
        "ETC2_SRGB8_A8": 78,
        "EAC_R11": 79,
        "EAC_R11SN": 80,
        "EAC_RG11": 81,
        "EAC_RG11SN": 82,
        "PVRTC_RGB2": 83,
        "PVRTC_RGBA2": 84,
        "PVRTC_RGB4": 85,
        "PVRTC_RGBA4": 86,
        "PVRTC2_2BPP": 87,
        "PVRTC2_4BPP": 88,
        "ASTC_RGBA_4X4": 89,
        "ASTC_RGBA_5X4": 90,
        "ASTC_RGBA_5X5": 91,
        "ASTC_RGBA_6X5": 92,
        "ASTC_RGBA_6X6": 93,
        "ASTC_RGBA_8X5": 94,
        "ASTC_RGBA_8X6": 95,
        "ASTC_RGBA_8X8": 96,
        "ASTC_RGBA_10X5": 97,
        "ASTC_RGBA_10X6": 98,
        "ASTC_RGBA_10X8": 99,
        "ASTC_RGBA_10X10": 100,
        "ASTC_RGBA_12X10": 101,
        "ASTC_RGBA_12X12": 102,
        "ASTC_SRGBA_4X4": 103,
        "ASTC_SRGBA_5X4": 104,
        "ASTC_SRGBA_5X5": 105,
        "ASTC_SRGBA_6X5": 106,
        "ASTC_SRGBA_6X6": 107,
        "ASTC_SRGBA_8X5": 108,
        "ASTC_SRGBA_8X6": 109,
        "ASTC_SRGBA_8X8": 110,
        "ASTC_SRGBA_10X5": 111,
        "ASTC_SRGBA_10X6": 112,
        "ASTC_SRGBA_10X8": 113,
        "ASTC_SRGBA_10X10": 114,
        "ASTC_SRGBA_12X10": 115,
        "ASTC_SRGBA_12X12": 116,
        "COUNT": 117
      };
      const FormatType = {
        "NONE": 0,
        "UNORM": 1,
        "SNORM": 2,
        "UINT": 3,
        "INT": 4,
        "UFLOAT": 5,
        "FLOAT": 6
      };
      const Type = {
        "UNKNOWN": 0,
        "BOOL": 1,
        "BOOL2": 2,
        "BOOL3": 3,
        "BOOL4": 4,
        "INT": 5,
        "INT2": 6,
        "INT3": 7,
        "INT4": 8,
        "UINT": 9,
        "UINT2": 10,
        "UINT3": 11,
        "UINT4": 12,
        "FLOAT": 13,
        "FLOAT2": 14,
        "FLOAT3": 15,
        "FLOAT4": 16,
        "MAT2": 17,
        "MAT2X3": 18,
        "MAT2X4": 19,
        "MAT3X2": 20,
        "MAT3": 21,
        "MAT3X4": 22,
        "MAT4X2": 23,
        "MAT4X3": 24,
        "MAT4": 25,
        "SAMPLER1D": 26,
        "SAMPLER1D_ARRAY": 27,
        "SAMPLER2D": 28,
        "SAMPLER2D_ARRAY": 29,
        "SAMPLER3D": 30,
        "SAMPLER_CUBE": 31,
        "SAMPLER": 32,
        "TEXTURE1D": 33,
        "TEXTURE1D_ARRAY": 34,
        "TEXTURE2D": 35,
        "TEXTURE2D_ARRAY": 36,
        "TEXTURE3D": 37,
        "TEXTURE_CUBE": 38,
        "IMAGE1D": 39,
        "IMAGE1D_ARRAY": 40,
        "IMAGE2D": 41,
        "IMAGE2D_ARRAY": 42,
        "IMAGE3D": 43,
        "IMAGE_CUBE": 44,
        "SUBPASS_INPUT": 45,
        "COUNT": 46
      };
      const BufferUsageBit = {
        "NONE": 0,
        "TRANSFER_SRC": 1,
        "TRANSFER_DST": 2,
        "INDEX": 4,
        "VERTEX": 8,
        "UNIFORM": 16,
        "STORAGE": 32,
        "INDIRECT": 64
      };
      const BufferFlagBit = {
        "NONE": 0,
        "ENABLE_STAGING_WRITE": 1
      };
      const MemoryAccessBit = {
        "NONE": 0,
        "READ_ONLY": 1,
        "WRITE_ONLY": 2,
        "READ_WRITE": 3
      };
      const MemoryUsageBit = {
        "NONE": 0,
        "DEVICE": 1,
        "HOST": 2
      };
      const TextureType = {
        "TEX1D": 0,
        "TEX2D": 1,
        "TEX3D": 2,
        "CUBE": 3,
        "TEX1D_ARRAY": 4,
        "TEX2D_ARRAY": 5
      };
      const TextureUsageBit = {
        "NONE": 0,
        "TRANSFER_SRC": 1,
        "TRANSFER_DST": 2,
        "SAMPLED": 4,
        "STORAGE": 8,
        "COLOR_ATTACHMENT": 16,
        "DEPTH_STENCIL_ATTACHMENT": 32,
        "INPUT_ATTACHMENT": 64,
        "SHADING_RATE": 128
      };
      const TextureFlagBit = {
        "NONE": 0,
        "GEN_MIPMAP": 1,
        "GENERAL_LAYOUT": 2,
        "EXTERNAL_OES": 4,
        "EXTERNAL_NORMAL": 8,
        "LAZILY_ALLOCATED": 16,
        "MUTABLE_VIEW_FORMAT": 64,
        "MUTABLE_STORAGE": 128
      };
      const FormatFeatureBit = {
        "NONE": 0,
        "RENDER_TARGET": 1,
        "SAMPLED_TEXTURE": 2,
        "LINEAR_FILTER": 4,
        "STORAGE_TEXTURE": 8,
        "VERTEX_ATTRIBUTE": 16,
        "SHADING_RATE": 32
      };
      const SampleCount = {
        "X1": 1,
        "X2": 2,
        "X4": 4,
        "X8": 8,
        "X16": 16,
        "X32": 32,
        "X64": 64
      };
      const VsyncMode = {
        "OFF": 0,
        "ON": 1,
        "RELAXED": 2,
        "MAILBOX": 3,
        "HALF": 4
      };
      const Filter = {
        "NONE": 0,
        "POINT": 1,
        "LINEAR": 2,
        "ANISOTROPIC": 3
      };
      const Address = {
        "WRAP": 0,
        "MIRROR": 1,
        "CLAMP": 2,
        "BORDER": 3
      };
      const ComparisonFunc = {
        "NEVER": 0,
        "LESS": 1,
        "EQUAL": 2,
        "LESS_EQUAL": 3,
        "GREATER": 4,
        "NOT_EQUAL": 5,
        "GREATER_EQUAL": 6,
        "ALWAYS": 7
      };
      const StencilOp = {
        "ZERO": 0,
        "KEEP": 1,
        "REPLACE": 2,
        "INCR": 3,
        "DECR": 4,
        "INVERT": 5,
        "INCR_WRAP": 6,
        "DECR_WRAP": 7
      };
      const BlendFactor = {
        "ZERO": 0,
        "ONE": 1,
        "SRC_ALPHA": 2,
        "DST_ALPHA": 3,
        "ONE_MINUS_SRC_ALPHA": 4,
        "ONE_MINUS_DST_ALPHA": 5,
        "SRC_COLOR": 6,
        "DST_COLOR": 7,
        "ONE_MINUS_SRC_COLOR": 8,
        "ONE_MINUS_DST_COLOR": 9,
        "SRC_ALPHA_SATURATE": 10,
        "CONSTANT_COLOR": 11,
        "ONE_MINUS_CONSTANT_COLOR": 12,
        "CONSTANT_ALPHA": 13,
        "ONE_MINUS_CONSTANT_ALPHA": 14
      };
      const BlendOp = {
        "ADD": 0,
        "SUB": 1,
        "REV_SUB": 2,
        "MIN": 3,
        "MAX": 4
      };
      const ColorMask = {
        "NONE": 0,
        "R": 1,
        "G": 2,
        "B": 4,
        "A": 8,
        "ALL": 15
      };
      const ShaderStageFlagBit = {
        "NONE": 0,
        "VERTEX": 1,
        "CONTROL": 2,
        "EVALUATION": 4,
        "GEOMETRY": 8,
        "FRAGMENT": 16,
        "COMPUTE": 32,
        "ALL": 63
      };
      const LoadOp = {
        "LOAD": 0,
        "CLEAR": 1,
        "DISCARD": 2
      };
      const StoreOp = {
        "STORE": 0,
        "DISCARD": 1
      };
      const AccessFlagBit = {
        "NONE": 0,
        "INDIRECT_BUFFER": 1,
        "INDEX_BUFFER": 2,
        "VERTEX_BUFFER": 4,
        "VERTEX_SHADER_READ_UNIFORM_BUFFER": 8,
        "VERTEX_SHADER_READ_TEXTURE": 16,
        "VERTEX_SHADER_READ_OTHER": 32,
        "FRAGMENT_SHADER_READ_UNIFORM_BUFFER": 64,
        "FRAGMENT_SHADER_READ_TEXTURE": 128,
        "FRAGMENT_SHADER_READ_COLOR_INPUT_ATTACHMENT": 256,
        "FRAGMENT_SHADER_READ_DEPTH_STENCIL_INPUT_ATTACHMENT": 512,
        "FRAGMENT_SHADER_READ_OTHER": 1024,
        "COLOR_ATTACHMENT_READ": 2048,
        "DEPTH_STENCIL_ATTACHMENT_READ": 4096,
        "COMPUTE_SHADER_READ_UNIFORM_BUFFER": 8192,
        "COMPUTE_SHADER_READ_TEXTURE": 16384,
        "COMPUTE_SHADER_READ_OTHER": 32768,
        "TRANSFER_READ": 65536,
        "HOST_READ": 131072,
        "PRESENT": 262144,
        "VERTEX_SHADER_WRITE": 524288,
        "FRAGMENT_SHADER_WRITE": 1048576,
        "COLOR_ATTACHMENT_WRITE": 2097152,
        "DEPTH_STENCIL_ATTACHMENT_WRITE": 4194304,
        "COMPUTE_SHADER_WRITE": 8388608,
        "TRANSFER_WRITE": 16777216,
        "HOST_PREINITIALIZED": 33554432,
        "HOST_WRITE": 67108864,
        "SHADING_RATE": 134217728
      };
      const ResolveMode = {
        "NONE": 0,
        "SAMPLE_ZERO": 1,
        "AVERAGE": 2,
        "MIN": 3,
        "MAX": 4
      };
      const PipelineBindPoint = {
        "GRAPHICS": 0,
        "COMPUTE": 1,
        "RAY_TRACING": 2
      };
      const PrimitiveMode = {
        "POINT_LIST": 0,
        "LINE_LIST": 1,
        "LINE_STRIP": 2,
        "LINE_LOOP": 3,
        "LINE_LIST_ADJACENCY": 4,
        "LINE_STRIP_ADJACENCY": 5,
        "ISO_LINE_LIST": 6,
        "TRIANGLE_LIST": 7,
        "TRIANGLE_STRIP": 8,
        "TRIANGLE_FAN": 9,
        "TRIANGLE_LIST_ADJACENCY": 10,
        "TRIANGLE_STRIP_ADJACENCY": 11,
        "TRIANGLE_PATCH_ADJACENCY": 12,
        "QUAD_PATCH_LIST": 13
      };
      const PolygonMode = {
        "FILL": 0,
        "POINT": 1,
        "LINE": 2
      };
      const ShadeModel = {
        "GOURAND": 0,
        "FLAT": 1
      };
      const CullMode = {
        "NONE": 0,
        "FRONT": 1,
        "BACK": 2
      };
      const DynamicStateFlagBit = {
        "NONE": 0,
        "LINE_WIDTH": 1,
        "DEPTH_BIAS": 2,
        "BLEND_CONSTANTS": 4,
        "DEPTH_BOUNDS": 8,
        "STENCIL_WRITE_MASK": 16,
        "STENCIL_COMPARE_MASK": 32
      };
      const StencilFace = {
        "FRONT": 1,
        "BACK": 2,
        "ALL": 3
      };
      const DescriptorType = {
        "UNKNOWN": 0,
        "UNIFORM_BUFFER": 1,
        "DYNAMIC_UNIFORM_BUFFER": 2,
        "STORAGE_BUFFER": 4,
        "DYNAMIC_STORAGE_BUFFER": 8,
        "SAMPLER_TEXTURE": 16,
        "SAMPLER": 32,
        "TEXTURE": 64,
        "STORAGE_IMAGE": 128,
        "INPUT_ATTACHMENT": 256
      };
      const QueueType = {
        "GRAPHICS": 0,
        "COMPUTE": 1,
        "TRANSFER": 2
      };
      const QueryType = {
        "OCCLUSION": 0,
        "PIPELINE_STATISTICS": 1,
        "TIMESTAMP": 2
      };
      const CommandBufferType = {
        "PRIMARY": 0,
        "SECONDARY": 1
      };
      const ClearFlagBit = {
        "NONE": 0,
        "COLOR": 1,
        "DEPTH": 2,
        "STENCIL": 4,
        "DEPTH_STENCIL": 6,
        "ALL": 7
      };
      const BarrierType = {
        "FULL": 0,
        "SPLIT_BEGIN": 1,
        "SPLIT_END": 2
      };
      const PassType = {
        "RASTER": 0,
        "COMPUTE": 1,
        "COPY": 2,
        "MOVE": 3,
        "RAYTRACE": 4,
        "PRESENT": 5
      };
      class Size {
        constructor(x = 0, y = 0, z = 0) {
          this.x = x;
          this.y = y;
          this.z = z;
        }
        copy(info) {
          this.x = info.x;
          this.y = info.y;
          this.z = info.z;
          return this;
        }
      }
      class DeviceCaps {
        constructor(maxVertexAttributes = 0, maxVertexUniformVectors = 0, maxFragmentUniformVectors = 0, maxTextureUnits = 0, maxImageUnits = 0, maxVertexTextureUnits = 0, maxColorRenderTargets = 0, maxShaderStorageBufferBindings = 0, maxShaderStorageBlockSize = 0, maxUniformBufferBindings = 0, maxUniformBlockSize = 0, maxTextureSize = 0, maxCubeMapTextureSize = 0, maxArrayTextureLayers = 0, max3DTextureSize = 0, uboOffsetAlignment = 1, maxComputeSharedMemorySize = 0, maxComputeWorkGroupInvocations = 0, maxComputeWorkGroupSize = new Size(), maxComputeWorkGroupCount = new Size(), supportQuery = false, supportVariableRateShading = false, supportSubPassShading = false, clipSpaceMinZ = -1, screenSpaceSignY = 1, clipSpaceSignY = 1) {
          this.maxVertexAttributes = maxVertexAttributes;
          this.maxVertexUniformVectors = maxVertexUniformVectors;
          this.maxFragmentUniformVectors = maxFragmentUniformVectors;
          this.maxTextureUnits = maxTextureUnits;
          this.maxImageUnits = maxImageUnits;
          this.maxVertexTextureUnits = maxVertexTextureUnits;
          this.maxColorRenderTargets = maxColorRenderTargets;
          this.maxShaderStorageBufferBindings = maxShaderStorageBufferBindings;
          this.maxShaderStorageBlockSize = maxShaderStorageBlockSize;
          this.maxUniformBufferBindings = maxUniformBufferBindings;
          this.maxUniformBlockSize = maxUniformBlockSize;
          this.maxTextureSize = maxTextureSize;
          this.maxCubeMapTextureSize = maxCubeMapTextureSize;
          this.maxArrayTextureLayers = maxArrayTextureLayers;
          this.max3DTextureSize = max3DTextureSize;
          this.uboOffsetAlignment = uboOffsetAlignment;
          this.maxComputeSharedMemorySize = maxComputeSharedMemorySize;
          this.maxComputeWorkGroupInvocations = maxComputeWorkGroupInvocations;
          this.maxComputeWorkGroupSize = maxComputeWorkGroupSize;
          this.maxComputeWorkGroupCount = maxComputeWorkGroupCount;
          this.supportQuery = supportQuery;
          this.supportVariableRateShading = supportVariableRateShading;
          this.supportSubPassShading = supportSubPassShading;
          this.clipSpaceMinZ = clipSpaceMinZ;
          this.screenSpaceSignY = screenSpaceSignY;
          this.clipSpaceSignY = clipSpaceSignY;
        }
        copy(info) {
          this.maxVertexAttributes = info.maxVertexAttributes;
          this.maxVertexUniformVectors = info.maxVertexUniformVectors;
          this.maxFragmentUniformVectors = info.maxFragmentUniformVectors;
          this.maxTextureUnits = info.maxTextureUnits;
          this.maxImageUnits = info.maxImageUnits;
          this.maxVertexTextureUnits = info.maxVertexTextureUnits;
          this.maxColorRenderTargets = info.maxColorRenderTargets;
          this.maxShaderStorageBufferBindings = info.maxShaderStorageBufferBindings;
          this.maxShaderStorageBlockSize = info.maxShaderStorageBlockSize;
          this.maxUniformBufferBindings = info.maxUniformBufferBindings;
          this.maxUniformBlockSize = info.maxUniformBlockSize;
          this.maxTextureSize = info.maxTextureSize;
          this.maxCubeMapTextureSize = info.maxCubeMapTextureSize;
          this.maxArrayTextureLayers = info.maxArrayTextureLayers;
          this.max3DTextureSize = info.max3DTextureSize;
          this.uboOffsetAlignment = info.uboOffsetAlignment;
          this.maxComputeSharedMemorySize = info.maxComputeSharedMemorySize;
          this.maxComputeWorkGroupInvocations = info.maxComputeWorkGroupInvocations;
          this.maxComputeWorkGroupSize.copy(info.maxComputeWorkGroupSize);
          this.maxComputeWorkGroupCount.copy(info.maxComputeWorkGroupCount);
          this.supportQuery = info.supportQuery;
          this.supportVariableRateShading = info.supportVariableRateShading;
          this.supportSubPassShading = info.supportSubPassShading;
          this.clipSpaceMinZ = info.clipSpaceMinZ;
          this.screenSpaceSignY = info.screenSpaceSignY;
          this.clipSpaceSignY = info.clipSpaceSignY;
          return this;
        }
      }
      class DeviceOptions {
        constructor(enableBarrierDeduce = true) {
          this.enableBarrierDeduce = enableBarrierDeduce;
        }
        copy(info) {
          this.enableBarrierDeduce = info.enableBarrierDeduce;
          return this;
        }
      }
      class Offset {
        constructor(x = 0, y = 0, z = 0) {
          this.x = x;
          this.y = y;
          this.z = z;
        }
        copy(info) {
          this.x = info.x;
          this.y = info.y;
          this.z = info.z;
          return this;
        }
      }
      class Rect {
        constructor(x = 0, y = 0, width = 0, height = 0) {
          this.x = x;
          this.y = y;
          this.width = width;
          this.height = height;
        }
        copy(info) {
          this.x = info.x;
          this.y = info.y;
          this.width = info.width;
          this.height = info.height;
          return this;
        }
      }
      class Extent {
        constructor(width = 0, height = 0, depth = 1) {
          this.width = width;
          this.height = height;
          this.depth = depth;
        }
        copy(info) {
          this.width = info.width;
          this.height = info.height;
          this.depth = info.depth;
          return this;
        }
      }
      class TextureSubresLayers {
        constructor(mipLevel = 0, baseArrayLayer = 0, layerCount = 1) {
          this.mipLevel = mipLevel;
          this.baseArrayLayer = baseArrayLayer;
          this.layerCount = layerCount;
        }
        copy(info) {
          this.mipLevel = info.mipLevel;
          this.baseArrayLayer = info.baseArrayLayer;
          this.layerCount = info.layerCount;
          return this;
        }
      }
      class TextureSubresRange {
        constructor(baseMipLevel = 0, levelCount = 1, baseArrayLayer = 0, layerCount = 1) {
          this.baseMipLevel = baseMipLevel;
          this.levelCount = levelCount;
          this.baseArrayLayer = baseArrayLayer;
          this.layerCount = layerCount;
        }
        copy(info) {
          this.baseMipLevel = info.baseMipLevel;
          this.levelCount = info.levelCount;
          this.baseArrayLayer = info.baseArrayLayer;
          this.layerCount = info.layerCount;
          return this;
        }
      }
      class TextureCopy {
        constructor(srcSubres = new TextureSubresLayers(), srcOffset = new Offset(), dstSubres = new TextureSubresLayers(), dstOffset = new Offset(), extent = new Extent()) {
          this.srcSubres = srcSubres;
          this.srcOffset = srcOffset;
          this.dstSubres = dstSubres;
          this.dstOffset = dstOffset;
          this.extent = extent;
        }
        copy(info) {
          this.srcSubres.copy(info.srcSubres);
          this.srcOffset.copy(info.srcOffset);
          this.dstSubres.copy(info.dstSubres);
          this.dstOffset.copy(info.dstOffset);
          this.extent.copy(info.extent);
          return this;
        }
      }
      class TextureBlit {
        constructor(srcSubres = new TextureSubresLayers(), srcOffset = new Offset(), srcExtent = new Extent(), dstSubres = new TextureSubresLayers(), dstOffset = new Offset(), dstExtent = new Extent()) {
          this.srcSubres = srcSubres;
          this.srcOffset = srcOffset;
          this.srcExtent = srcExtent;
          this.dstSubres = dstSubres;
          this.dstOffset = dstOffset;
          this.dstExtent = dstExtent;
        }
        copy(info) {
          this.srcSubres.copy(info.srcSubres);
          this.srcOffset.copy(info.srcOffset);
          this.srcExtent.copy(info.srcExtent);
          this.dstSubres.copy(info.dstSubres);
          this.dstOffset.copy(info.dstOffset);
          this.dstExtent.copy(info.dstExtent);
          return this;
        }
      }
      class BufferTextureCopy {
        constructor(buffOffset = 0, buffStride = 0, buffTexHeight = 0, texOffset = new Offset(), texExtent = new Extent(), texSubres = new TextureSubresLayers()) {
          this.buffOffset = buffOffset;
          this.buffStride = buffStride;
          this.buffTexHeight = buffTexHeight;
          this.texOffset = texOffset;
          this.texExtent = texExtent;
          this.texSubres = texSubres;
        }
        copy(info) {
          this.buffOffset = info.buffOffset;
          this.buffStride = info.buffStride;
          this.buffTexHeight = info.buffTexHeight;
          this.texOffset.copy(info.texOffset);
          this.texExtent.copy(info.texExtent);
          this.texSubres.copy(info.texSubres);
          return this;
        }
      }
      class Viewport {
        constructor(left = 0, top = 0, width = 0, height = 0, minDepth = 0, maxDepth = 1) {
          this.left = left;
          this.top = top;
          this.width = width;
          this.height = height;
          this.minDepth = minDepth;
          this.maxDepth = maxDepth;
        }
        copy(info) {
          this.left = info.left;
          this.top = info.top;
          this.width = info.width;
          this.height = info.height;
          this.minDepth = info.minDepth;
          this.maxDepth = info.maxDepth;
          return this;
        }
        reset() {
          this.left = 0;
          this.top = 0;
          this.width = 0;
          this.height = 0;
          this.minDepth = 0;
          this.maxDepth = 1;
        }
      }
      class Color {
        constructor(x = 0, y = 0, z = 0, w = 0) {
          this.x = x;
          this.y = y;
          this.z = z;
          this.w = w;
        }
        copy(info) {
          this.x = info.x;
          this.y = info.y;
          this.z = info.z;
          this.w = info.w;
          return this;
        }
        set(x, y, z, w) {
          this.x = x;
          this.y = y;
          this.z = z;
          this.w = w;
          return this;
        }
        reset() {
          this.x = 0;
          this.y = 0;
          this.z = 0;
          this.w = 0;
        }
      }
      class MarkerInfo {
        constructor(name = '', color = new Color()) {
          this.name = name;
          this.color = color;
        }
        copy(info) {
          this.name = info.name;
          this.color.copy(info.color);
          return this;
        }
      }
      class BindingMappingInfo {
        constructor(maxBlockCounts = [0], maxSamplerTextureCounts = [0], maxSamplerCounts = [0], maxTextureCounts = [0], maxBufferCounts = [0], maxImageCounts = [0], maxSubpassInputCounts = [0], setIndices = [0]) {
          this.maxBlockCounts = maxBlockCounts;
          this.maxSamplerTextureCounts = maxSamplerTextureCounts;
          this.maxSamplerCounts = maxSamplerCounts;
          this.maxTextureCounts = maxTextureCounts;
          this.maxBufferCounts = maxBufferCounts;
          this.maxImageCounts = maxImageCounts;
          this.maxSubpassInputCounts = maxSubpassInputCounts;
          this.setIndices = setIndices;
        }
        copy(info) {
          this.maxBlockCounts = info.maxBlockCounts.slice();
          this.maxSamplerTextureCounts = info.maxSamplerTextureCounts.slice();
          this.maxSamplerCounts = info.maxSamplerCounts.slice();
          this.maxTextureCounts = info.maxTextureCounts.slice();
          this.maxBufferCounts = info.maxBufferCounts.slice();
          this.maxImageCounts = info.maxImageCounts.slice();
          this.maxSubpassInputCounts = info.maxSubpassInputCounts.slice();
          this.setIndices = info.setIndices.slice();
          return this;
        }
      }
      class SwapchainInfo {
        constructor(windowId = 0, windowHandle = null, vsyncMode = 1, width = 0, height = 0) {
          this.windowId = windowId;
          this.windowHandle = windowHandle;
          this.vsyncMode = vsyncMode;
          this.width = width;
          this.height = height;
        }
        copy(info) {
          this.windowId = info.windowId;
          this.windowHandle = info.windowHandle;
          this.vsyncMode = info.vsyncMode;
          this.width = info.width;
          this.height = info.height;
          return this;
        }
      }
      class DeviceInfo {
        constructor(bindingMappingInfo = new BindingMappingInfo()) {
          this.bindingMappingInfo = bindingMappingInfo;
        }
        copy(info) {
          this.bindingMappingInfo.copy(info.bindingMappingInfo);
          return this;
        }
      }
      class BufferInfo {
        constructor(usage = 0, memUsage = 0, size = 0, stride = 1, flags = 0) {
          this.usage = usage;
          this.memUsage = memUsage;
          this.size = size;
          this.stride = stride;
          this.flags = flags;
        }
        copy(info) {
          this.usage = info.usage;
          this.memUsage = info.memUsage;
          this.size = info.size;
          this.stride = info.stride;
          this.flags = info.flags;
          return this;
        }
      }
      class BufferViewInfo {
        constructor(buffer = null, offset = 0, range = 0) {
          this.buffer = buffer;
          this.offset = offset;
          this.range = range;
        }
        copy(info) {
          this.buffer = info.buffer;
          this.offset = info.offset;
          this.range = info.range;
          return this;
        }
      }
      class DrawInfo {
        constructor(vertexCount = 0, firstVertex = 0, indexCount = 0, firstIndex = 0, vertexOffset = 0, instanceCount = 0, firstInstance = 0) {
          this.vertexCount = vertexCount;
          this.firstVertex = firstVertex;
          this.indexCount = indexCount;
          this.firstIndex = firstIndex;
          this.vertexOffset = vertexOffset;
          this.instanceCount = instanceCount;
          this.firstInstance = firstInstance;
        }
        copy(info) {
          this.vertexCount = info.vertexCount;
          this.firstVertex = info.firstVertex;
          this.indexCount = info.indexCount;
          this.firstIndex = info.firstIndex;
          this.vertexOffset = info.vertexOffset;
          this.instanceCount = info.instanceCount;
          this.firstInstance = info.firstInstance;
          return this;
        }
      }
      class DispatchInfo {
        constructor(groupCountX = 0, groupCountY = 0, groupCountZ = 0, indirectBuffer = null, indirectOffset = 0) {
          this.groupCountX = groupCountX;
          this.groupCountY = groupCountY;
          this.groupCountZ = groupCountZ;
          this.indirectBuffer = indirectBuffer;
          this.indirectOffset = indirectOffset;
        }
        copy(info) {
          this.groupCountX = info.groupCountX;
          this.groupCountY = info.groupCountY;
          this.groupCountZ = info.groupCountZ;
          this.indirectBuffer = info.indirectBuffer;
          this.indirectOffset = info.indirectOffset;
          return this;
        }
      }
      class IndirectBuffer {
        constructor(drawInfos = []) {
          this.drawInfos = drawInfos;
        }
        copy(info) {
          deepCopy(this.drawInfos, info.drawInfos, DrawInfo);
          return this;
        }
      }
      class TextureInfo {
        constructor(type = 1, usage = 0, format = 0, width = 0, height = 0, flags = 0, layerCount = 1, levelCount = 1, samples = 1, depth = 1, externalRes = 0) {
          this.type = type;
          this.usage = usage;
          this.format = format;
          this.width = width;
          this.height = height;
          this.flags = flags;
          this.layerCount = layerCount;
          this.levelCount = levelCount;
          this.samples = samples;
          this.depth = depth;
          this.externalRes = externalRes;
        }
        copy(info) {
          this.type = info.type;
          this.usage = info.usage;
          this.format = info.format;
          this.width = info.width;
          this.height = info.height;
          this.flags = info.flags;
          this.layerCount = info.layerCount;
          this.levelCount = info.levelCount;
          this.samples = info.samples;
          this.depth = info.depth;
          this.externalRes = info.externalRes;
          return this;
        }
      }
      class TextureViewInfo {
        constructor(texture = null, type = 1, format = 0, baseLevel = 0, levelCount = 1, baseLayer = 0, layerCount = 1, basePlane = 0, planeCount = 1) {
          this.texture = texture;
          this.type = type;
          this.format = format;
          this.baseLevel = baseLevel;
          this.levelCount = levelCount;
          this.baseLayer = baseLayer;
          this.layerCount = layerCount;
          this.basePlane = basePlane;
          this.planeCount = planeCount;
        }
        copy(info) {
          this.texture = info.texture;
          this.type = info.type;
          this.format = info.format;
          this.baseLevel = info.baseLevel;
          this.levelCount = info.levelCount;
          this.baseLayer = info.baseLayer;
          this.layerCount = info.layerCount;
          this.basePlane = info.basePlane;
          this.planeCount = info.planeCount;
          return this;
        }
      }
      class SamplerInfo {
        constructor(minFilter = 2, magFilter = 2, mipFilter = 0, addressU = 0, addressV = 0, addressW = 0, maxAnisotropy = 0, cmpFunc = 7) {
          this.minFilter = minFilter;
          this.magFilter = magFilter;
          this.mipFilter = mipFilter;
          this.addressU = addressU;
          this.addressV = addressV;
          this.addressW = addressW;
          this.maxAnisotropy = maxAnisotropy;
          this.cmpFunc = cmpFunc;
        }
        copy(info) {
          this.minFilter = info.minFilter;
          this.magFilter = info.magFilter;
          this.mipFilter = info.mipFilter;
          this.addressU = info.addressU;
          this.addressV = info.addressV;
          this.addressW = info.addressW;
          this.maxAnisotropy = info.maxAnisotropy;
          this.cmpFunc = info.cmpFunc;
          return this;
        }
      }
      class Uniform {
        constructor(name = '', type = 0, count = 0) {
          this.name = name;
          this.type = type;
          this.count = count;
        }
        copy(info) {
          this.name = info.name;
          this.type = info.type;
          this.count = info.count;
          return this;
        }
      }
      class UniformBlock {
        constructor(set = 0, binding = 0, name = '', members = [], count = 0, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.members = members;
          this.count = count;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          deepCopy(this.members, info.members, Uniform);
          this.count = info.count;
          this.flattened = info.flattened;
          return this;
        }
      }
      class UniformSamplerTexture {
        constructor(set = 0, binding = 0, name = '', type = 0, count = 0, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.type = type;
          this.count = count;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          this.type = info.type;
          this.count = info.count;
          this.flattened = info.flattened;
          return this;
        }
      }
      class UniformSampler {
        constructor(set = 0, binding = 0, name = '', count = 0, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.count = count;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          this.count = info.count;
          this.flattened = info.flattened;
          return this;
        }
      }
      class UniformTexture {
        constructor(set = 0, binding = 0, name = '', type = 0, count = 0, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.type = type;
          this.count = count;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          this.type = info.type;
          this.count = info.count;
          this.flattened = info.flattened;
          return this;
        }
      }
      class UniformStorageImage {
        constructor(set = 0, binding = 0, name = '', type = 0, count = 0, memoryAccess = 3, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.type = type;
          this.count = count;
          this.memoryAccess = memoryAccess;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          this.type = info.type;
          this.count = info.count;
          this.memoryAccess = info.memoryAccess;
          this.flattened = info.flattened;
          return this;
        }
      }
      class UniformStorageBuffer {
        constructor(set = 0, binding = 0, name = '', count = 0, memoryAccess = 3, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.count = count;
          this.memoryAccess = memoryAccess;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          this.count = info.count;
          this.memoryAccess = info.memoryAccess;
          this.flattened = info.flattened;
          return this;
        }
      }
      class UniformInputAttachment {
        constructor(set = 0, binding = 0, name = '', count = 0, flattened = 0) {
          this.set = set;
          this.binding = binding;
          this.name = name;
          this.count = count;
          this.flattened = flattened;
        }
        copy(info) {
          this.set = info.set;
          this.binding = info.binding;
          this.name = info.name;
          this.count = info.count;
          this.flattened = info.flattened;
          return this;
        }
      }
      class ShaderStage {
        constructor(stage = 0, source = '') {
          this.stage = stage;
          this.source = source;
        }
        copy(info) {
          this.stage = info.stage;
          this.source = info.source;
          return this;
        }
      }
      class Attribute {
        constructor(name = '', format = 0, isNormalized = false, stream = 0, isInstanced = false, location = 0) {
          this.name = name;
          this.format = format;
          this.isNormalized = isNormalized;
          this.stream = stream;
          this.isInstanced = isInstanced;
          this.location = location;
        }
        copy(info) {
          this.name = info.name;
          this.format = info.format;
          this.isNormalized = info.isNormalized;
          this.stream = info.stream;
          this.isInstanced = info.isInstanced;
          this.location = info.location;
          return this;
        }
      }
      class ShaderInfo {
        constructor(name = '', stages = [], attributes = [], blocks = [], buffers = [], samplerTextures = [], samplers = [], textures = [], images = [], subpassInputs = [], hash = 0xFFFFFFFF) {
          this.name = name;
          this.stages = stages;
          this.attributes = attributes;
          this.blocks = blocks;
          this.buffers = buffers;
          this.samplerTextures = samplerTextures;
          this.samplers = samplers;
          this.textures = textures;
          this.images = images;
          this.subpassInputs = subpassInputs;
          this.hash = hash;
        }
        copy(info) {
          this.name = info.name;
          deepCopy(this.stages, info.stages, ShaderStage);
          deepCopy(this.attributes, info.attributes, Attribute);
          deepCopy(this.blocks, info.blocks, UniformBlock);
          deepCopy(this.buffers, info.buffers, UniformStorageBuffer);
          deepCopy(this.samplerTextures, info.samplerTextures, UniformSamplerTexture);
          deepCopy(this.samplers, info.samplers, UniformSampler);
          deepCopy(this.textures, info.textures, UniformTexture);
          deepCopy(this.images, info.images, UniformStorageImage);
          deepCopy(this.subpassInputs, info.subpassInputs, UniformInputAttachment);
          this.hash = info.hash;
          return this;
        }
      }
      class InputAssemblerInfo {
        constructor(attributes = [], vertexBuffers = [], indexBuffer = null, indirectBuffer = null) {
          this.attributes = attributes;
          this.vertexBuffers = vertexBuffers;
          this.indexBuffer = indexBuffer;
          this.indirectBuffer = indirectBuffer;
        }
        copy(info) {
          deepCopy(this.attributes, info.attributes, Attribute);
          this.vertexBuffers = info.vertexBuffers.slice();
          this.indexBuffer = info.indexBuffer;
          this.indirectBuffer = info.indirectBuffer;
          return this;
        }
      }
      class ColorAttachment {
        constructor(format = 0, sampleCount = 1, loadOp = 1, storeOp = 0, barrier = null) {
          this.format = format;
          this.sampleCount = sampleCount;
          this.loadOp = loadOp;
          this.storeOp = storeOp;
          this.barrier = barrier;
        }
        copy(info) {
          this.format = info.format;
          this.sampleCount = info.sampleCount;
          this.loadOp = info.loadOp;
          this.storeOp = info.storeOp;
          this.barrier = info.barrier;
          return this;
        }
      }
      class DepthStencilAttachment {
        constructor(format = 0, sampleCount = 1, depthLoadOp = 1, depthStoreOp = 0, stencilLoadOp = 1, stencilStoreOp = 0, barrier = null) {
          this.format = format;
          this.sampleCount = sampleCount;
          this.depthLoadOp = depthLoadOp;
          this.depthStoreOp = depthStoreOp;
          this.stencilLoadOp = stencilLoadOp;
          this.stencilStoreOp = stencilStoreOp;
          this.barrier = barrier;
        }
        copy(info) {
          this.format = info.format;
          this.sampleCount = info.sampleCount;
          this.depthLoadOp = info.depthLoadOp;
          this.depthStoreOp = info.depthStoreOp;
          this.stencilLoadOp = info.stencilLoadOp;
          this.stencilStoreOp = info.stencilStoreOp;
          this.barrier = info.barrier;
          return this;
        }
      }
      class SubpassInfo {
        constructor(inputs = [], colors = [], resolves = [], preserves = [], depthStencil = -1, depthStencilResolve = -1, shadingRate = -1, depthResolveMode = 0, stencilResolveMode = 0) {
          this.inputs = inputs;
          this.colors = colors;
          this.resolves = resolves;
          this.preserves = preserves;
          this.depthStencil = depthStencil;
          this.depthStencilResolve = depthStencilResolve;
          this.shadingRate = shadingRate;
          this.depthResolveMode = depthResolveMode;
          this.stencilResolveMode = stencilResolveMode;
        }
        copy(info) {
          this.inputs = info.inputs.slice();
          this.colors = info.colors.slice();
          this.resolves = info.resolves.slice();
          this.preserves = info.preserves.slice();
          this.depthStencil = info.depthStencil;
          this.depthStencilResolve = info.depthStencilResolve;
          this.shadingRate = info.shadingRate;
          this.depthResolveMode = info.depthResolveMode;
          this.stencilResolveMode = info.stencilResolveMode;
          return this;
        }
      }
      class SubpassDependency {
        constructor(srcSubpass = 0, dstSubpass = 0, generalBarrier = null, prevAccesses = 0, nextAccesses = 0) {
          this.srcSubpass = srcSubpass;
          this.dstSubpass = dstSubpass;
          this.generalBarrier = generalBarrier;
          this.prevAccesses = prevAccesses;
          this.nextAccesses = nextAccesses;
        }
        copy(info) {
          this.srcSubpass = info.srcSubpass;
          this.dstSubpass = info.dstSubpass;
          this.generalBarrier = info.generalBarrier;
          this.prevAccesses = info.prevAccesses;
          this.nextAccesses = info.nextAccesses;
          return this;
        }
      }
      class RenderPassInfo {
        constructor(colorAttachments = [], depthStencilAttachment = new DepthStencilAttachment(), depthStencilResolveAttachment = new DepthStencilAttachment(), subpasses = [], dependencies = []) {
          this.colorAttachments = colorAttachments;
          this.depthStencilAttachment = depthStencilAttachment;
          this.depthStencilResolveAttachment = depthStencilResolveAttachment;
          this.subpasses = subpasses;
          this.dependencies = dependencies;
        }
        copy(info) {
          deepCopy(this.colorAttachments, info.colorAttachments, ColorAttachment);
          this.depthStencilAttachment.copy(info.depthStencilAttachment);
          this.depthStencilResolveAttachment.copy(info.depthStencilResolveAttachment);
          deepCopy(this.subpasses, info.subpasses, SubpassInfo);
          deepCopy(this.dependencies, info.dependencies, SubpassDependency);
          return this;
        }
      }
      class ResourceRange {
        constructor(width = 0, height = 0, depthOrArraySize = 0, firstSlice = 0, numSlices = 0, mipLevel = 0, levelCount = 0, basePlane = 0, planeCount = 0) {
          this.width = width;
          this.height = height;
          this.depthOrArraySize = depthOrArraySize;
          this.firstSlice = firstSlice;
          this.numSlices = numSlices;
          this.mipLevel = mipLevel;
          this.levelCount = levelCount;
          this.basePlane = basePlane;
          this.planeCount = planeCount;
        }
        copy(info) {
          this.width = info.width;
          this.height = info.height;
          this.depthOrArraySize = info.depthOrArraySize;
          this.firstSlice = info.firstSlice;
          this.numSlices = info.numSlices;
          this.mipLevel = info.mipLevel;
          this.levelCount = info.levelCount;
          this.basePlane = info.basePlane;
          this.planeCount = info.planeCount;
          return this;
        }
      }
      class GeneralBarrierInfo {
        constructor(prevAccesses = 0, nextAccesses = 0, type = 0) {
          this.prevAccesses = prevAccesses;
          this.nextAccesses = nextAccesses;
          this.type = type;
        }
        copy(info) {
          this.prevAccesses = info.prevAccesses;
          this.nextAccesses = info.nextAccesses;
          this.type = info.type;
          return this;
        }
      }
      class TextureBarrierInfo {
        constructor(prevAccesses = 0, nextAccesses = 0, type = 0, range = new ResourceRange(), discardContents = false, srcQueue = null, dstQueue = null) {
          this.prevAccesses = prevAccesses;
          this.nextAccesses = nextAccesses;
          this.type = type;
          this.range = range;
          this.discardContents = discardContents;
          this.srcQueue = srcQueue;
          this.dstQueue = dstQueue;
        }
        copy(info) {
          this.prevAccesses = info.prevAccesses;
          this.nextAccesses = info.nextAccesses;
          this.type = info.type;
          this.range.copy(info.range);
          this.discardContents = info.discardContents;
          this.srcQueue = info.srcQueue;
          this.dstQueue = info.dstQueue;
          return this;
        }
      }
      class BufferBarrierInfo {
        constructor(prevAccesses = 0, nextAccesses = 0, type = 0, offset = 0, size = 0, discardContents = false, srcQueue = null, dstQueue = null) {
          this.prevAccesses = prevAccesses;
          this.nextAccesses = nextAccesses;
          this.type = type;
          this.offset = offset;
          this.size = size;
          this.discardContents = discardContents;
          this.srcQueue = srcQueue;
          this.dstQueue = dstQueue;
        }
        copy(info) {
          this.prevAccesses = info.prevAccesses;
          this.nextAccesses = info.nextAccesses;
          this.type = info.type;
          this.offset = info.offset;
          this.size = info.size;
          this.discardContents = info.discardContents;
          this.srcQueue = info.srcQueue;
          this.dstQueue = info.dstQueue;
          return this;
        }
      }
      class FramebufferInfo {
        constructor(renderPass = null, colorTextures = [], depthStencilTexture = null, depthStencilResolveTexture = null) {
          this.renderPass = renderPass;
          this.colorTextures = colorTextures;
          this.depthStencilTexture = depthStencilTexture;
          this.depthStencilResolveTexture = depthStencilResolveTexture;
        }
        copy(info) {
          this.renderPass = info.renderPass;
          this.colorTextures = info.colorTextures.slice();
          this.depthStencilTexture = info.depthStencilTexture;
          this.depthStencilResolveTexture = info.depthStencilResolveTexture;
          return this;
        }
      }
      class DescriptorSetLayoutBinding {
        constructor(binding = -1, descriptorType = 0, count = 0, stageFlags = 0, immutableSamplers = []) {
          this.binding = binding;
          this.descriptorType = descriptorType;
          this.count = count;
          this.stageFlags = stageFlags;
          this.immutableSamplers = immutableSamplers;
        }
        copy(info) {
          this.binding = info.binding;
          this.descriptorType = info.descriptorType;
          this.count = info.count;
          this.stageFlags = info.stageFlags;
          this.immutableSamplers = info.immutableSamplers.slice();
          return this;
        }
      }
      class DescriptorSetLayoutInfo {
        constructor(bindings = []) {
          this.bindings = bindings;
        }
        copy(info) {
          deepCopy(this.bindings, info.bindings, DescriptorSetLayoutBinding);
          return this;
        }
      }
      class DescriptorSetInfo {
        constructor(layout = null) {
          this.layout = layout;
        }
        copy(info) {
          this.layout = info.layout;
          return this;
        }
      }
      class PipelineLayoutInfo {
        constructor(setLayouts = []) {
          this.setLayouts = setLayouts;
        }
        copy(info) {
          this.setLayouts = info.setLayouts.slice();
          return this;
        }
      }
      class InputState {
        constructor(attributes = []) {
          this.attributes = attributes;
        }
        copy(info) {
          deepCopy(this.attributes, info.attributes, Attribute);
          return this;
        }
      }
      class CommandBufferInfo {
        constructor(queue = null, type = 0) {
          this.queue = queue;
          this.type = type;
        }
        copy(info) {
          this.queue = info.queue;
          this.type = info.type;
          return this;
        }
      }
      class QueueInfo {
        constructor(type = 0) {
          this.type = type;
        }
        copy(info) {
          this.type = info.type;
          return this;
        }
      }
      class QueryPoolInfo {
        constructor(type = 0, maxQueryObjects = 32767, forceWait = true) {
          this.type = type;
          this.maxQueryObjects = maxQueryObjects;
          this.forceWait = forceWait;
        }
        copy(info) {
          this.type = info.type;
          this.maxQueryObjects = info.maxQueryObjects;
          this.forceWait = info.forceWait;
          return this;
        }
      }
      class FormatInfo {
        constructor(name = '', size = 0, count = 0, type = 0, hasAlpha = false, hasDepth = false, hasStencil = false, isCompressed = false) {
          this.name = name;
          this.size = size;
          this.count = count;
          this.type = type;
          this.hasAlpha = hasAlpha;
          this.hasDepth = hasDepth;
          this.hasStencil = hasStencil;
          this.isCompressed = isCompressed;
        }
        copy(info) {
          this.name = info.name;
          this.size = info.size;
          this.count = info.count;
          this.type = info.type;
          this.hasAlpha = info.hasAlpha;
          this.hasDepth = info.hasDepth;
          this.hasStencil = info.hasStencil;
          this.isCompressed = info.isCompressed;
          return this;
        }
      }
      class MemoryStatus {
        constructor(bufferSize = 0, textureSize = 0) {
          this.bufferSize = bufferSize;
          this.textureSize = textureSize;
        }
        copy(info) {
          this.bufferSize = info.bufferSize;
          this.textureSize = info.textureSize;
          return this;
        }
      }
      class DynamicStencilStates {
        constructor(writeMask = 0, compareMask = 0, reference = 0) {
          this.writeMask = writeMask;
          this.compareMask = compareMask;
          this.reference = reference;
        }
        copy(info) {
          this.writeMask = info.writeMask;
          this.compareMask = info.compareMask;
          this.reference = info.reference;
          return this;
        }
      }
      class DynamicStates {
        constructor(viewport = new Viewport(), scissor = new Rect(), blendConstant = new Color(), lineWidth = 1, depthBiasConstant = 0, depthBiasClamp = 0, depthBiasSlope = 0, depthMinBounds = 0, depthMaxBounds = 0, stencilStatesFront = new DynamicStencilStates(), stencilStatesBack = new DynamicStencilStates()) {
          this.viewport = viewport;
          this.scissor = scissor;
          this.blendConstant = blendConstant;
          this.lineWidth = lineWidth;
          this.depthBiasConstant = depthBiasConstant;
          this.depthBiasClamp = depthBiasClamp;
          this.depthBiasSlope = depthBiasSlope;
          this.depthMinBounds = depthMinBounds;
          this.depthMaxBounds = depthMaxBounds;
          this.stencilStatesFront = stencilStatesFront;
          this.stencilStatesBack = stencilStatesBack;
        }
        copy(info) {
          this.viewport.copy(info.viewport);
          this.scissor.copy(info.scissor);
          this.blendConstant.copy(info.blendConstant);
          this.lineWidth = info.lineWidth;
          this.depthBiasConstant = info.depthBiasConstant;
          this.depthBiasClamp = info.depthBiasClamp;
          this.depthBiasSlope = info.depthBiasSlope;
          this.depthMinBounds = info.depthMinBounds;
          this.depthMaxBounds = info.depthMaxBounds;
          this.stencilStatesFront.copy(info.stencilStatesFront);
          this.stencilStatesBack.copy(info.stencilStatesBack);
          return this;
        }
      }
      class GFXObject extends GCObject {
        get objectType() {
          return this._objectType;
        }
        get objectID() {
          return this._objectID;
        }
        get typedID() {
          return this._typedID;
        }
        constructor(objectType) {
          super();
          this._objectType = 0;
          this._objectID = 0;
          this._typedID = 0;
          this._objectType = objectType;
          this._objectID = GFXObject._idTable[0]++;
          this._typedID = GFXObject._idTable[objectType]++;
        }
      }
      GFXObject._idTable = Array(19).fill(1 << 16);
      const AttributeName = {
        "ATTR_POSITION": "a_position",
        "ATTR_NORMAL": "a_normal",
        "ATTR_TANGENT": "a_tangent",
        "ATTR_BITANGENT": "a_bitangent",
        "ATTR_WEIGHTS": "a_weights",
        "ATTR_JOINTS": "a_joints",
        "ATTR_COLOR": "a_color",
        "ATTR_COLOR1": "a_color1",
        "ATTR_COLOR2": "a_color2",
        "ATTR_TEX_COORD": "a_texCoord",
        "ATTR_TEX_COORD1": "a_texCoord1",
        "ATTR_TEX_COORD2": "a_texCoord2",
        "ATTR_TEX_COORD3": "a_texCoord3",
        "ATTR_TEX_COORD4": "a_texCoord4",
        "ATTR_TEX_COORD5": "a_texCoord5",
        "ATTR_TEX_COORD6": "a_texCoord6",
        "ATTR_TEX_COORD7": "a_texCoord7",
        "ATTR_TEX_COORD8": "a_texCoord8",
        "ATTR_BATCH_ID": "a_batch_id",
        "ATTR_BATCH_UV": "a_batch_uv"
      };
      const FormatInfos = Object.freeze([new FormatInfo('UNKNOWN', 0, 0, 0, false, false, false, false), new FormatInfo('A8', 1, 1, 1, true, false, false, false), new FormatInfo('L8', 1, 1, 1, false, false, false, false), new FormatInfo('LA8', 1, 2, 1, true, false, false, false), new FormatInfo('R8', 1, 1, 1, false, false, false, false), new FormatInfo('R8SN', 1, 1, 2, false, false, false, false), new FormatInfo('R8UI', 1, 1, 3, false, false, false, false), new FormatInfo('R8I', 1, 1, 4, false, false, false, false), new FormatInfo('R16F', 2, 1, 6, false, false, false, false), new FormatInfo('R16UI', 2, 1, 3, false, false, false, false), new FormatInfo('R16I', 2, 1, 4, false, false, false, false), new FormatInfo('R32F', 4, 1, 6, false, false, false, false), new FormatInfo('R32UI', 4, 1, 3, false, false, false, false), new FormatInfo('R32I', 4, 1, 4, false, false, false, false), new FormatInfo('RG8', 2, 2, 1, false, false, false, false), new FormatInfo('RG8SN', 2, 2, 2, false, false, false, false), new FormatInfo('RG8UI', 2, 2, 3, false, false, false, false), new FormatInfo('RG8I', 2, 2, 4, false, false, false, false), new FormatInfo('RG16F', 4, 2, 6, false, false, false, false), new FormatInfo('RG16UI', 4, 2, 3, false, false, false, false), new FormatInfo('RG16I', 4, 2, 4, false, false, false, false), new FormatInfo('RG32F', 8, 2, 6, false, false, false, false), new FormatInfo('RG32UI', 8, 2, 3, false, false, false, false), new FormatInfo('RG32I', 8, 2, 4, false, false, false, false), new FormatInfo('RGB8', 3, 3, 1, false, false, false, false), new FormatInfo('SRGB8', 3, 3, 1, false, false, false, false), new FormatInfo('RGB8SN', 3, 3, 2, false, false, false, false), new FormatInfo('RGB8UI', 3, 3, 3, false, false, false, false), new FormatInfo('RGB8I', 3, 3, 4, false, false, false, false), new FormatInfo('RGB16F', 6, 3, 6, false, false, false, false), new FormatInfo('RGB16UI', 6, 3, 3, false, false, false, false), new FormatInfo('RGB16I', 6, 3, 4, false, false, false, false), new FormatInfo('RGB32F', 12, 3, 6, false, false, false, false), new FormatInfo('RGB32UI', 12, 3, 3, false, false, false, false), new FormatInfo('RGB32I', 12, 3, 4, false, false, false, false), new FormatInfo('RGBA8', 4, 4, 1, true, false, false, false), new FormatInfo('BGRA8', 4, 4, 1, true, false, false, false), new FormatInfo('SRGB8_A8', 4, 4, 1, true, false, false, false), new FormatInfo('RGBA8SN', 4, 4, 2, true, false, false, false), new FormatInfo('RGBA8UI', 4, 4, 3, true, false, false, false), new FormatInfo('RGBA8I', 4, 4, 4, true, false, false, false), new FormatInfo('RGBA16F', 8, 4, 6, true, false, false, false), new FormatInfo('RGBA16UI', 8, 4, 3, true, false, false, false), new FormatInfo('RGBA16I', 8, 4, 4, true, false, false, false), new FormatInfo('RGBA32F', 16, 4, 6, true, false, false, false), new FormatInfo('RGBA32UI', 16, 4, 3, true, false, false, false), new FormatInfo('RGBA32I', 16, 4, 4, true, false, false, false), new FormatInfo('R5G6B5', 2, 3, 1, false, false, false, false), new FormatInfo('R11G11B10F', 4, 3, 6, false, false, false, false), new FormatInfo('RGB5A1', 2, 4, 1, true, false, false, false), new FormatInfo('RGBA4', 2, 4, 1, true, false, false, false), new FormatInfo('RGB10A2', 2, 4, 1, true, false, false, false), new FormatInfo('RGB10A2UI', 2, 4, 3, true, false, false, false), new FormatInfo('RGB9E5', 2, 4, 6, true, false, false, false), new FormatInfo('DEPTH', 4, 1, 6, false, true, false, false), new FormatInfo('DEPTH_STENCIL', 5, 2, 6, false, true, true, false), new FormatInfo('BC1', 1, 3, 1, false, false, false, true), new FormatInfo('BC1_ALPHA', 1, 4, 1, true, false, false, true), new FormatInfo('BC1_SRGB', 1, 3, 1, false, false, false, true), new FormatInfo('BC1_SRGB_ALPHA', 1, 4, 1, true, false, false, true), new FormatInfo('BC2', 1, 4, 1, true, false, false, true), new FormatInfo('BC2_SRGB', 1, 4, 1, true, false, false, true), new FormatInfo('BC3', 1, 4, 1, true, false, false, true), new FormatInfo('BC3_SRGB', 1, 4, 1, true, false, false, true), new FormatInfo('BC4', 1, 1, 1, false, false, false, true), new FormatInfo('BC4_SNORM', 1, 1, 2, false, false, false, true), new FormatInfo('BC5', 1, 2, 1, false, false, false, true), new FormatInfo('BC5_SNORM', 1, 2, 2, false, false, false, true), new FormatInfo('BC6H_UF16', 1, 3, 5, false, false, false, true), new FormatInfo('BC6H_SF16', 1, 3, 6, false, false, false, true), new FormatInfo('BC7', 1, 4, 1, true, false, false, true), new FormatInfo('BC7_SRGB', 1, 4, 1, true, false, false, true), new FormatInfo('ETC_RGB8', 1, 3, 1, false, false, false, true), new FormatInfo('ETC2_RGB8', 1, 3, 1, false, false, false, true), new FormatInfo('ETC2_SRGB8', 1, 3, 1, false, false, false, true), new FormatInfo('ETC2_RGB8_A1', 1, 4, 1, true, false, false, true), new FormatInfo('ETC2_SRGB8_A1', 1, 4, 1, true, false, false, true), new FormatInfo('ETC2_RGBA8', 2, 4, 1, true, false, false, true), new FormatInfo('ETC2_SRGB8_A8', 2, 4, 1, true, false, false, true), new FormatInfo('EAC_R11', 1, 1, 1, false, false, false, true), new FormatInfo('EAC_R11SN', 1, 1, 2, false, false, false, true), new FormatInfo('EAC_RG11', 2, 2, 1, false, false, false, true), new FormatInfo('EAC_RG11SN', 2, 2, 2, false, false, false, true), new FormatInfo('PVRTC_RGB2', 2, 3, 1, false, false, false, true), new FormatInfo('PVRTC_RGBA2', 2, 4, 1, true, false, false, true), new FormatInfo('PVRTC_RGB4', 2, 3, 1, false, false, false, true), new FormatInfo('PVRTC_RGBA4', 2, 4, 1, true, false, false, true), new FormatInfo('PVRTC2_2BPP', 2, 4, 1, true, false, false, true), new FormatInfo('PVRTC2_4BPP', 2, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_4x4', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_5x4', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_5x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_6x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_6x6', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_8x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_8x6', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_8x8', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_10x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_10x6', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_10x8', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_10x10', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_12x10', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_RGBA_12x12', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_4x4', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_5x4', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_5x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_6x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_6x6', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_8x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_8x6', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_8x8', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_10x5', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_10x6', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_10x8', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_10x10', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_12x10', 1, 4, 1, true, false, false, true), new FormatInfo('ASTC_SRGBA_12x12', 1, 4, 1, true, false, false, true)]);
      const DESCRIPTOR_BUFFER_TYPE = 1 | 2 | 4 | 8;
      const DESCRIPTOR_SAMPLER_TYPE = 16 | 32 | 64 | 128 | 256;
      const DESCRIPTOR_DYNAMIC_TYPE = 8 | 2;
      const DRAW_INFO_SIZE = 28;
      function IsPowerOf2(x) {
        return x > 0 && (x & x - 1) === 0;
      }
      const ceil$1 = Math.ceil;
      function FormatSize(format, width, height, depth) {
        if (!FormatInfos[format].isCompressed) {
          return width * height * depth * FormatInfos[format].size;
        } else {
          switch (format) {
            case 56:
            case 57:
            case 58:
            case 59:
              return ceil$1(width / 4) * ceil$1(height / 4) * 8 * depth;
            case 60:
            case 61:
            case 62:
            case 63:
            case 64:
            case 65:
            case 69:
            case 68:
            case 70:
            case 71:
              return ceil$1(width / 4) * ceil$1(height / 4) * 16 * depth;
            case 66:
            case 67:
              return ceil$1(width / 4) * ceil$1(height / 4) * 32 * depth;
            case 72:
            case 73:
            case 74:
            case 75:
            case 79:
            case 80:
              return ceil$1(width / 4) * ceil$1(height / 4) * 8 * depth;
            case 77:
            case 76:
            case 81:
            case 82:
              return ceil$1(width / 4) * ceil$1(height / 4) * 16 * depth;
            case 83:
            case 84:
            case 87:
              return ceil$1(width / 8) * ceil$1(height / 4) * 8 * depth;
            case 85:
            case 86:
            case 88:
              return ceil$1(width / 4) * ceil$1(height / 4) * 8 * depth;
            case 89:
            case 103:
              return ceil$1(width / 4) * ceil$1(height / 4) * 16 * depth;
            case 90:
            case 104:
              return ceil$1(width / 5) * ceil$1(height / 4) * 16 * depth;
            case 91:
            case 105:
              return ceil$1(width / 5) * ceil$1(height / 5) * 16 * depth;
            case 92:
            case 106:
              return ceil$1(width / 6) * ceil$1(height / 5) * 16 * depth;
            case 93:
            case 107:
              return ceil$1(width / 6) * ceil$1(height / 6) * 16 * depth;
            case 94:
            case 108:
              return ceil$1(width / 8) * ceil$1(height / 5) * 16 * depth;
            case 95:
            case 109:
              return ceil$1(width / 8) * ceil$1(height / 6) * 16 * depth;
            case 96:
            case 110:
              return ceil$1(width / 8) * ceil$1(height / 8) * 16 * depth;
            case 97:
            case 111:
              return ceil$1(width / 10) * ceil$1(height / 5) * 16 * depth;
            case 98:
            case 112:
              return ceil$1(width / 10) * ceil$1(height / 6) * 16 * depth;
            case 99:
            case 113:
              return ceil$1(width / 10) * ceil$1(height / 8) * 16 * depth;
            case 100:
            case 114:
              return ceil$1(width / 10) * ceil$1(height / 10) * 16 * depth;
            case 101:
            case 115:
              return ceil$1(width / 12) * ceil$1(height / 10) * 16 * depth;
            case 102:
            case 116:
              return ceil$1(width / 12) * ceil$1(height / 12) * 16 * depth;
            default:
              {
                return 0;
              }
          }
        }
      }
      function FormatSurfaceSize(format, width, height, depth, mips) {
        let size = 0;
        for (let i = 0; i < mips; ++i) {
          size += FormatSize(format, width, height, depth);
          width = Math.max(width >> 1, 1);
          height = Math.max(height >> 1, 1);
        }
        return size;
      }
      const _type2size = [0, 4, 8, 12, 16, 4, 8, 12, 16, 4, 8, 12, 16, 4, 8, 12, 16, 16, 24, 32, 24, 36, 48, 32, 48, 64, 4, 4, 4, 4, 4, 4];
      function GetTypeSize(type) {
        return _type2size[type] || 0;
      }
      function getTypedArrayConstructor(info) {
        if (info.isCompressed) {
          return Uint8Array;
        }
        const stride = info.size / info.count;
        switch (info.type) {
          case 1:
          case 3:
            {
              switch (stride) {
                case 1:
                  return Uint8Array;
                case 2:
                  return Uint16Array;
                case 4:
                  return Uint32Array;
                default:
                  return Uint8Array;
              }
            }
          case 2:
          case 4:
            {
              switch (stride) {
                case 1:
                  return Int8Array;
                case 2:
                  return Int16Array;
                case 4:
                  return Int32Array;
                default:
                  return Int8Array;
              }
            }
          case 6:
            {
              switch (stride) {
                case 2:
                  return Uint16Array;
                case 4:
                  return Float32Array;
                default:
                  return Float32Array;
              }
            }
        }
        return Float32Array;
      }
      function formatAlignment(format) {
        switch (format) {
          case 56:
          case 57:
          case 58:
          case 59:
          case 60:
          case 61:
          case 62:
          case 63:
          case 64:
          case 65:
          case 69:
          case 68:
          case 70:
          case 71:
          case 66:
          case 67:
          case 72:
          case 73:
          case 74:
          case 75:
          case 79:
          case 80:
          case 77:
          case 76:
          case 81:
          case 82:
            return {
              width: 4,
              height: 4
            };
          case 83:
          case 84:
          case 87:
            return {
              width: 8,
              height: 4
            };
          case 85:
          case 86:
          case 88:
            return {
              width: 4,
              height: 4
            };
          case 89:
          case 103:
            return {
              width: 4,
              height: 4
            };
          case 90:
          case 104:
            return {
              width: 5,
              height: 4
            };
          case 91:
          case 105:
            return {
              width: 5,
              height: 5
            };
          case 92:
          case 106:
            return {
              width: 6,
              height: 5
            };
          case 93:
          case 107:
            return {
              width: 6,
              height: 6
            };
          case 94:
          case 108:
            return {
              width: 8,
              height: 5
            };
          case 95:
          case 109:
            return {
              width: 8,
              height: 6
            };
          case 96:
          case 110:
            return {
              width: 8,
              height: 8
            };
          case 97:
          case 111:
            return {
              width: 10,
              height: 5
            };
          case 98:
          case 112:
            return {
              width: 10,
              height: 6
            };
          case 99:
          case 113:
            return {
              width: 10,
              height: 8
            };
          case 100:
          case 114:
            return {
              width: 10,
              height: 10
            };
          case 101:
          case 115:
            return {
              width: 12,
              height: 10
            };
          case 102:
          case 116:
            return {
              width: 12,
              height: 12
            };
          default:
            return {
              width: 1,
              height: 1
            };
        }
      }
      function alignTo(size, alignment) {
        return ceil$1(size / alignment) * alignment;
      }

      var defines = /*#__PURE__*/Object.freeze({
        __proto__: null,
        API: API,
        AccessFlagBit: AccessFlagBit,
        Address: Address,
        Attribute: Attribute,
        AttributeName: AttributeName,
        BarrierType: BarrierType,
        BindingMappingInfo: BindingMappingInfo,
        BlendFactor: BlendFactor,
        BlendOp: BlendOp,
        BufferBarrierInfo: BufferBarrierInfo,
        BufferFlagBit: BufferFlagBit,
        BufferInfo: BufferInfo,
        BufferTextureCopy: BufferTextureCopy,
        BufferUsageBit: BufferUsageBit,
        BufferViewInfo: BufferViewInfo,
        ClearFlagBit: ClearFlagBit,
        Color: Color,
        ColorAttachment: ColorAttachment,
        ColorMask: ColorMask,
        CommandBufferInfo: CommandBufferInfo,
        CommandBufferType: CommandBufferType,
        ComparisonFunc: ComparisonFunc,
        CullMode: CullMode,
        DESCRIPTOR_BUFFER_TYPE: DESCRIPTOR_BUFFER_TYPE,
        DESCRIPTOR_DYNAMIC_TYPE: DESCRIPTOR_DYNAMIC_TYPE,
        DESCRIPTOR_SAMPLER_TYPE: DESCRIPTOR_SAMPLER_TYPE,
        DRAW_INFO_SIZE: DRAW_INFO_SIZE,
        DepthStencilAttachment: DepthStencilAttachment,
        DescriptorSetInfo: DescriptorSetInfo,
        DescriptorSetLayoutBinding: DescriptorSetLayoutBinding,
        DescriptorSetLayoutInfo: DescriptorSetLayoutInfo,
        DescriptorType: DescriptorType,
        DeviceCaps: DeviceCaps,
        DeviceInfo: DeviceInfo,
        DeviceOptions: DeviceOptions,
        DispatchInfo: DispatchInfo,
        DrawInfo: DrawInfo,
        DynamicStateFlagBit: DynamicStateFlagBit,
        DynamicStates: DynamicStates,
        DynamicStencilStates: DynamicStencilStates,
        Extent: Extent,
        Feature: Feature,
        Filter: Filter,
        Format: Format,
        FormatFeatureBit: FormatFeatureBit,
        FormatInfo: FormatInfo,
        FormatInfos: FormatInfos,
        FormatSize: FormatSize,
        FormatSurfaceSize: FormatSurfaceSize,
        FormatType: FormatType,
        FramebufferInfo: FramebufferInfo,
        GFXObject: GFXObject,
        GeneralBarrierInfo: GeneralBarrierInfo,
        GetTypeSize: GetTypeSize,
        IndirectBuffer: IndirectBuffer,
        InputAssemblerInfo: InputAssemblerInfo,
        InputState: InputState,
        IsPowerOf2: IsPowerOf2,
        LoadOp: LoadOp,
        MarkerInfo: MarkerInfo,
        MemoryAccessBit: MemoryAccessBit,
        MemoryStatus: MemoryStatus,
        MemoryUsageBit: MemoryUsageBit,
        ObjectType: ObjectType,
        Offset: Offset,
        PassType: PassType,
        PipelineBindPoint: PipelineBindPoint,
        PipelineLayoutInfo: PipelineLayoutInfo,
        PolygonMode: PolygonMode,
        PrimitiveMode: PrimitiveMode,
        QueryPoolInfo: QueryPoolInfo,
        QueryType: QueryType,
        QueueInfo: QueueInfo,
        QueueType: QueueType,
        Rect: Rect,
        RenderPassInfo: RenderPassInfo,
        ResolveMode: ResolveMode,
        ResourceRange: ResourceRange,
        SampleCount: SampleCount,
        SamplerInfo: SamplerInfo,
        ShadeModel: ShadeModel,
        ShaderInfo: ShaderInfo,
        ShaderStage: ShaderStage,
        ShaderStageFlagBit: ShaderStageFlagBit,
        Size: Size,
        Status: Status,
        StencilFace: StencilFace,
        StencilOp: StencilOp,
        StoreOp: StoreOp,
        SubpassDependency: SubpassDependency,
        SubpassInfo: SubpassInfo,
        SurfaceTransform: SurfaceTransform,
        SwapchainInfo: SwapchainInfo,
        TextureBarrierInfo: TextureBarrierInfo,
        TextureBlit: TextureBlit,
        TextureCopy: TextureCopy,
        TextureFlagBit: TextureFlagBit,
        TextureInfo: TextureInfo,
        TextureSubresLayers: TextureSubresLayers,
        TextureSubresRange: TextureSubresRange,
        TextureType: TextureType,
        TextureUsageBit: TextureUsageBit,
        TextureViewInfo: TextureViewInfo,
        Type: Type,
        Uniform: Uniform,
        UniformBlock: UniformBlock,
        UniformInputAttachment: UniformInputAttachment,
        UniformSampler: UniformSampler,
        UniformSamplerTexture: UniformSamplerTexture,
        UniformStorageBuffer: UniformStorageBuffer,
        UniformStorageImage: UniformStorageImage,
        UniformTexture: UniformTexture,
        Viewport: Viewport,
        VsyncMode: VsyncMode,
        alignTo: alignTo,
        formatAlignment: formatAlignment,
        getTypedArrayConstructor: getTypedArrayConstructor
      });

      function watchArrayElementsField(self, list, eleField, cachedFieldName, callback) {
        for (let i = 0, l = list.length; i < l; i++) {
          let ele = list[i];
          let originField = ele[eleField][cachedFieldName] || ele[eleField];
          ele[eleField] = new Proxy(originField, {
            get: (originTarget, key) => {
              if (key === cachedFieldName) {
                return originTarget;
              }
              return Reflect.get(originTarget, key);
            },
            set: (originTarget, prop, value) => {
              Reflect.set(originTarget, prop, value);
              callback(self, i, originTarget, prop, value);
              return true;
            }
          });
        }
      }
      class RasterizerState {
        constructor(isDiscard = false, polygonMode = 0, shadeModel = 0, cullMode = 2, isFrontFaceCCW = true, depthBiasEnabled = false, depthBias = 0, depthBiasClamp = 0.0, depthBiasSlop = 0.0, isDepthClip = true, isMultisample = false, lineWidth = 1.0) {
          this._nativeObj = void 0;
          this._isDiscard = false;
          this._polygonMode = 0;
          this._shadeModel = 0;
          this._cullMode = 2;
          this._isFrontFaceCCW = true;
          this._depthBiasEnabled = false;
          this._depthBias = 0;
          this._depthBiasClamp = 0.0;
          this._depthBiasSlop = 0.0;
          this._isDepthClip = true;
          this._isMultisample = false;
          this._lineWidth = 1.0;
          this._nativeObj = new gfx.RasterizerState();
          this.assignProperties(isDiscard, polygonMode, shadeModel, cullMode, isFrontFaceCCW, depthBiasEnabled, depthBias, depthBiasClamp, depthBiasSlop, isDepthClip, isMultisample, lineWidth);
        }
        get native() {
          return this._nativeObj;
        }
        get isDiscard() {
          return this._isDiscard;
        }
        set isDiscard(val) {
          this._isDiscard = val;
          this._nativeObj.isDiscard = val;
        }
        get polygonMode() {
          return this._polygonMode;
        }
        set polygonMode(val) {
          this._polygonMode = val;
          this._nativeObj.polygonMode = val;
        }
        get shadeModel() {
          return this._shadeModel;
        }
        set shadeModel(val) {
          this._shadeModel = val;
          this._nativeObj.shadeModel = val;
        }
        get cullMode() {
          return this._cullMode;
        }
        set cullMode(val) {
          this._cullMode = val;
          this._nativeObj.cullMode = val;
        }
        get isFrontFaceCCW() {
          return this._isFrontFaceCCW;
        }
        set isFrontFaceCCW(val) {
          this._isFrontFaceCCW = val;
          this._nativeObj.isFrontFaceCCW = val;
        }
        get depthBiasEnabled() {
          return this._depthBiasEnabled;
        }
        set depthBiasEnabled(val) {
          this._depthBiasEnabled = val;
          this._nativeObj.depthBiasEnabled = val;
        }
        get depthBias() {
          return this._depthBias;
        }
        set depthBias(val) {
          this._depthBias = val;
          this._nativeObj.depthBias = val;
        }
        get depthBiasClamp() {
          return this._depthBiasClamp;
        }
        set depthBiasClamp(val) {
          this._depthBiasClamp = val;
          this._nativeObj.depthBiasClamp = val;
        }
        get depthBiasSlop() {
          return this._depthBiasSlop;
        }
        set depthBiasSlop(val) {
          this._depthBiasSlop = val;
          this._nativeObj.depthBiasSlop = val;
        }
        get isDepthClip() {
          return this._isDepthClip;
        }
        set isDepthClip(val) {
          this._isDepthClip = val;
          this._nativeObj.isDepthClip = val;
        }
        get isMultisample() {
          return this._isMultisample;
        }
        set isMultisample(val) {
          this._isMultisample = val;
          this._nativeObj.isMultisample = val;
        }
        get lineWidth() {
          return this._lineWidth;
        }
        set lineWidth(val) {
          this._lineWidth = val;
          this._nativeObj.lineWidth = val;
        }
        reset() {
          this.assignProperties(false, 0, 0, 2, true, false, 0, 0.0, 0.0, true, false, 1.0);
        }
        assign(rs) {
          if (!rs) return;
          this.assignProperties(rs.isDiscard, rs.polygonMode, rs.shadeModel, rs.cullMode, rs.isFrontFaceCCW, rs.depthBiasEnabled, rs.depthBias, rs.depthBiasClamp, rs.depthBiasSlop, rs.isDepthClip, rs.isMultisample, rs.lineWidth);
        }
        destroy() {
          this._nativeObj = null;
        }
        assignProperties(isDiscard, polygonMode, shadeModel, cullMode, isFrontFaceCCW, depthBiasEnabled, depthBias, depthBiasClamp, depthBiasSlop, isDepthClip, isMultisample, lineWidth) {
          if (isDiscard !== undefined) this.isDiscard = isDiscard;
          if (polygonMode !== undefined) this.polygonMode = polygonMode;
          if (shadeModel !== undefined) this.shadeModel = shadeModel;
          if (cullMode !== undefined) this.cullMode = cullMode;
          if (isFrontFaceCCW !== undefined) this.isFrontFaceCCW = isFrontFaceCCW;
          if (depthBiasEnabled !== undefined) this.depthBiasEnabled = depthBiasEnabled;
          if (depthBias !== undefined) this.depthBias = depthBias;
          if (depthBiasClamp !== undefined) this.depthBiasClamp = depthBiasClamp;
          if (depthBiasSlop !== undefined) this.depthBiasSlop = depthBiasSlop;
          if (isDepthClip !== undefined) this.isDepthClip = isDepthClip;
          if (isMultisample !== undefined) this.isMultisample = isMultisample;
          if (lineWidth !== undefined) this.lineWidth = lineWidth;
        }
      }
      class DepthStencilState {
        constructor(depthTest = true, depthWrite = true, depthFunc = 1, stencilTestFront = false, stencilFuncFront = 7, stencilReadMaskFront = 0xffff, stencilWriteMaskFront = 0xffff, stencilFailOpFront = 1, stencilZFailOpFront = 1, stencilPassOpFront = 1, stencilRefFront = 1, stencilTestBack = false, stencilFuncBack = 7, stencilReadMaskBack = 0xffff, stencilWriteMaskBack = 0xffff, stencilFailOpBack = 1, stencilZFailOpBack = 1, stencilPassOpBack = 1, stencilRefBack = 1) {
          this._nativeObj = void 0;
          this._depthTest = true;
          this._depthWrite = true;
          this._depthFunc = 1;
          this._stencilTestFront = false;
          this._stencilFuncFront = 7;
          this._stencilReadMaskFront = 0xffff;
          this._stencilWriteMaskFront = 0xffff;
          this._stencilFailOpFront = 1;
          this._stencilZFailOpFront = 1;
          this._stencilPassOpFront = 1;
          this._stencilRefFront = 1;
          this._stencilTestBack = false;
          this._stencilFuncBack = 7;
          this._stencilReadMaskBack = 0xffff;
          this._stencilWriteMaskBack = 0xffff;
          this._stencilFailOpBack = 1;
          this._stencilZFailOpBack = 1;
          this._stencilPassOpBack = 1;
          this._stencilRefBack = 1;
          this._nativeObj = new gfx.DepthStencilState();
          this.assignProperties(depthTest, depthWrite, depthFunc, stencilTestFront, stencilFuncFront, stencilReadMaskFront, stencilWriteMaskFront, stencilFailOpFront, stencilZFailOpFront, stencilPassOpFront, stencilRefFront, stencilTestBack, stencilFuncBack, stencilReadMaskBack, stencilWriteMaskBack, stencilFailOpBack, stencilZFailOpBack, stencilPassOpBack, stencilRefBack);
        }
        get native() {
          return this._nativeObj;
        }
        get depthTest() {
          return this._depthTest;
        }
        set depthTest(val) {
          this._depthTest = val;
          this._nativeObj.depthTest = val;
        }
        get depthWrite() {
          return this._depthWrite;
        }
        set depthWrite(val) {
          this._depthWrite = val;
          this._nativeObj.depthWrite = val;
        }
        get depthFunc() {
          return this._depthFunc;
        }
        set depthFunc(val) {
          this._depthFunc = val;
          this._nativeObj.depthFunc = val;
        }
        get stencilTestFront() {
          return this._stencilTestFront;
        }
        set stencilTestFront(val) {
          this._stencilTestFront = val;
          this._nativeObj.stencilTestFront = val;
        }
        get stencilFuncFront() {
          return this._stencilFuncFront;
        }
        set stencilFuncFront(val) {
          this._stencilFuncFront = val;
          this._nativeObj.stencilFuncFront = val;
        }
        get stencilReadMaskFront() {
          return this._stencilReadMaskFront;
        }
        set stencilReadMaskFront(val) {
          this._stencilReadMaskFront = val;
          this._nativeObj.stencilReadMaskFront = val;
        }
        get stencilWriteMaskFront() {
          return this._stencilWriteMaskFront;
        }
        set stencilWriteMaskFront(val) {
          this._stencilWriteMaskFront = val;
          this._nativeObj.stencilWriteMaskFront = val;
        }
        get stencilFailOpFront() {
          return this._stencilFailOpFront;
        }
        set stencilFailOpFront(val) {
          this._stencilFailOpFront = val;
          this._nativeObj.stencilFailOpFront = val;
        }
        get stencilZFailOpFront() {
          return this._stencilZFailOpFront;
        }
        set stencilZFailOpFront(val) {
          this._stencilZFailOpFront = val;
          this._nativeObj.stencilZFailOpFront = val;
        }
        get stencilPassOpFront() {
          return this._stencilPassOpFront;
        }
        set stencilPassOpFront(val) {
          this._stencilPassOpFront = val;
          this._nativeObj.stencilPassOpFront = val;
        }
        get stencilRefFront() {
          return this._stencilRefFront;
        }
        set stencilRefFront(val) {
          this._stencilRefFront = val;
          this._nativeObj.stencilRefFront = val;
        }
        get stencilTestBack() {
          return this._stencilTestBack;
        }
        set stencilTestBack(val) {
          this._stencilTestBack = val;
          this._nativeObj.stencilTestBack = val;
        }
        get stencilFuncBack() {
          return this._stencilFuncBack;
        }
        set stencilFuncBack(val) {
          this._stencilFuncBack = val;
          this._nativeObj.stencilFuncBack = val;
        }
        get stencilReadMaskBack() {
          return this._stencilReadMaskBack;
        }
        set stencilReadMaskBack(val) {
          this._stencilReadMaskBack = val;
          this._nativeObj.stencilReadMaskBack = val;
        }
        get stencilWriteMaskBack() {
          return this._stencilWriteMaskBack;
        }
        set stencilWriteMaskBack(val) {
          this._stencilWriteMaskBack = val;
          this._nativeObj.stencilWriteMaskBack = val;
        }
        get stencilFailOpBack() {
          return this._stencilFailOpBack;
        }
        set stencilFailOpBack(val) {
          this._stencilFailOpBack = val;
          this._nativeObj.stencilFailOpBack = val;
        }
        get stencilZFailOpBack() {
          return this._stencilZFailOpBack;
        }
        set stencilZFailOpBack(val) {
          this._stencilZFailOpBack = val;
          this._nativeObj.stencilZFailOpBack = val;
        }
        get stencilPassOpBack() {
          return this._stencilPassOpBack;
        }
        set stencilPassOpBack(val) {
          this._stencilPassOpBack = val;
          this._nativeObj.stencilPassOpBack = val;
        }
        get stencilRefBack() {
          return this._stencilRefBack;
        }
        set stencilRefBack(val) {
          this._stencilRefBack = val;
          this._nativeObj.stencilRefBack = val;
        }
        reset() {
          this.assignProperties(true, true, 1, false, 7, 0xffff, 0xffff, 1, 1, 1, 1, false, 7, 0xffff, 0xffff, 1, 1, 1, 1);
        }
        assign(dss) {
          if (!dss) return;
          this.assignProperties(dss.depthTest, dss.depthWrite, dss.depthFunc, dss.stencilTestFront, dss.stencilFuncFront, dss.stencilReadMaskFront, dss.stencilWriteMaskFront, dss.stencilFailOpFront, dss.stencilZFailOpFront, dss.stencilPassOpFront, dss.stencilRefFront, dss.stencilTestBack, dss.stencilFuncBack, dss.stencilReadMaskBack, dss.stencilWriteMaskBack, dss.stencilFailOpBack, dss.stencilZFailOpBack, dss.stencilPassOpBack, dss.stencilRefBack);
        }
        destroy() {
          this._nativeObj = null;
        }
        assignProperties(depthTest, depthWrite, depthFunc, stencilTestFront, stencilFuncFront, stencilReadMaskFront, stencilWriteMaskFront, stencilFailOpFront, stencilZFailOpFront, stencilPassOpFront, stencilRefFront, stencilTestBack, stencilFuncBack, stencilReadMaskBack, stencilWriteMaskBack, stencilFailOpBack, stencilZFailOpBack, stencilPassOpBack, stencilRefBack) {
          if (depthTest !== undefined) this.depthTest = depthTest;
          if (depthWrite !== undefined) this.depthWrite = depthWrite;
          if (depthFunc !== undefined) this.depthFunc = depthFunc;
          if (stencilTestFront !== undefined) this.stencilTestFront = stencilTestFront;
          if (stencilFuncFront !== undefined) this.stencilFuncFront = stencilFuncFront;
          if (stencilReadMaskFront !== undefined) this.stencilReadMaskFront = stencilReadMaskFront;
          if (stencilWriteMaskFront !== undefined) this.stencilWriteMaskFront = stencilWriteMaskFront;
          if (stencilFailOpFront !== undefined) this.stencilFailOpFront = stencilFailOpFront;
          if (stencilZFailOpFront !== undefined) this.stencilZFailOpFront = stencilZFailOpFront;
          if (stencilPassOpFront !== undefined) this.stencilPassOpFront = stencilPassOpFront;
          if (stencilRefFront !== undefined) this.stencilRefFront = stencilRefFront;
          if (stencilTestBack !== undefined) this.stencilTestBack = stencilTestBack;
          if (stencilFuncBack !== undefined) this.stencilFuncBack = stencilFuncBack;
          if (stencilReadMaskBack !== undefined) this.stencilReadMaskBack = stencilReadMaskBack;
          if (stencilWriteMaskBack !== undefined) this.stencilWriteMaskBack = stencilWriteMaskBack;
          if (stencilFailOpBack !== undefined) this.stencilFailOpBack = stencilFailOpBack;
          if (stencilZFailOpBack !== undefined) this.stencilZFailOpBack = stencilZFailOpBack;
          if (stencilPassOpBack !== undefined) this.stencilPassOpBack = stencilPassOpBack;
          if (stencilRefBack !== undefined) this.stencilRefBack = stencilRefBack;
        }
      }
      class BlendTarget {
        get native() {
          return this._nativeObj;
        }
        constructor(blend = false, blendSrc = 1, blendDst = 0, blendEq = 0, blendSrcAlpha = 1, blendDstAlpha = 0, blendAlphaEq = 0, blendColorMask = 15) {
          this._nativeObj = void 0;
          this._blend = false;
          this._blendSrc = 1;
          this._blendDst = 0;
          this._blendEq = 0;
          this._blendSrcAlpha = 1;
          this._blendDstAlpha = 0;
          this._blendAlphaEq = 0;
          this._blendColorMask = 15;
          this._nativeObj = new gfx.BlendTarget();
          this.assignProperties(blend, blendSrc, blendDst, blendEq, blendSrcAlpha, blendDstAlpha, blendAlphaEq, blendColorMask);
        }
        get blend() {
          return this._blend;
        }
        set blend(val) {
          this._blend = val;
          this._nativeObj.blend = val;
        }
        get blendSrc() {
          return this._blendSrc;
        }
        set blendSrc(val) {
          this._blendSrc = val;
          this._nativeObj.blendSrc = val;
        }
        get blendDst() {
          return this._blendDst;
        }
        set blendDst(val) {
          this._blendDst = val;
          this._nativeObj.blendDst = val;
        }
        get blendEq() {
          return this._blendEq;
        }
        set blendEq(val) {
          this._blendEq = val;
          this._nativeObj.blendEq = val;
        }
        get blendSrcAlpha() {
          return this._blendSrcAlpha;
        }
        set blendSrcAlpha(val) {
          this._blendSrcAlpha = val;
          this._nativeObj.blendSrcAlpha = val;
        }
        get blendDstAlpha() {
          return this._blendDstAlpha;
        }
        set blendDstAlpha(val) {
          this._blendDstAlpha = val;
          this._nativeObj.blendDstAlpha = val;
        }
        get blendAlphaEq() {
          return this._blendAlphaEq;
        }
        set blendAlphaEq(val) {
          this._blendAlphaEq = val;
          this._nativeObj.blendAlphaEq = val;
        }
        get blendColorMask() {
          return this._blendColorMask;
        }
        set blendColorMask(val) {
          this._blendColorMask = val;
          this._nativeObj.blendColorMask = val;
        }
        reset() {
          this.assignProperties(false, 1, 0, 0, 1, 0, 0, 15);
        }
        destroy() {
          this._nativeObj = null;
        }
        assign(target) {
          if (!target) return;
          this.assignProperties(target.blend, target.blendSrc, target.blendDst, target.blendEq, target.blendSrcAlpha, target.blendDstAlpha, target.blendAlphaEq, target.blendColorMask);
        }
        assignProperties(blend, blendSrc, blendDst, blendEq, blendSrcAlpha, blendDstAlpha, blendAlphaEq, blendColorMask) {
          if (blend !== undefined) this.blend = blend;
          if (blendSrc !== undefined) this.blendSrc = blendSrc;
          if (blendDst !== undefined) this.blendDst = blendDst;
          if (blendEq !== undefined) this.blendEq = blendEq;
          if (blendSrcAlpha !== undefined) this.blendSrcAlpha = blendSrcAlpha;
          if (blendDstAlpha !== undefined) this.blendDstAlpha = blendDstAlpha;
          if (blendAlphaEq !== undefined) this.blendAlphaEq = blendAlphaEq;
          if (blendColorMask !== undefined) this.blendColorMask = blendColorMask;
        }
      }
      class BlendState {
        _setTargets(targets) {
          this.targets = targets;
          const CACHED_FIELD_NAME = `$__nativeObj`;
          this._syncTargetsToNativeObj(CACHED_FIELD_NAME);
          watchArrayElementsField(this, this.targets, "_nativeObj", CACHED_FIELD_NAME, (self, _idx, _originTarget, _prop, _value) => {
            self._syncTargetsToNativeObj(CACHED_FIELD_NAME);
          });
        }
        _syncTargetsToNativeObj(cachedFieldName) {
          const nativeTars = this.targets.map(target => {
            return target.native[cachedFieldName] || target.native;
          });
          this._nativeObj.targets = nativeTars;
        }
        get native() {
          return this._nativeObj;
        }
        constructor(isA2C = false, isIndepend = false, blendColor = new Color(), targets = [new BlendTarget()]) {
          this.targets = void 0;
          this._blendColor = void 0;
          this._nativeObj = void 0;
          this._isA2C = false;
          this._isIndepend = false;
          this._nativeObj = new gfx.BlendState();
          this._setTargets(targets);
          this.blendColor = blendColor;
          this.isA2C = isA2C;
          this.isIndepend = isIndepend;
        }
        get isA2C() {
          return this._isA2C;
        }
        set isA2C(val) {
          this._isA2C = val;
          this._nativeObj.isA2C = val;
        }
        get isIndepend() {
          return this._isIndepend;
        }
        set isIndepend(val) {
          this._isIndepend = val;
          this._nativeObj.isIndepend = val;
        }
        get blendColor() {
          return this._blendColor;
        }
        set blendColor(color) {
          this._blendColor = color;
          this._nativeObj.blendColor = color;
        }
        setTarget(index, target) {
          let tg = this.targets[index];
          if (!tg) {
            tg = this.targets[index] = new BlendTarget();
          }
          tg.assign(target);
          this._setTargets(this.targets);
        }
        reset() {
          this.isA2C = false;
          this.isIndepend = false;
          this.blendColor = new Color(0, 0, 0, 0);
          const targets = this.targets;
          for (let i = 1, len = targets.length; i < len; ++i) {
            targets[i].destroy();
          }
          targets.length = 1;
          targets[0].reset();
          this._setTargets(targets);
        }
        destroy() {
          for (let i = 0, len = this.targets.length; i < len; ++i) {
            this.targets[i].destroy();
          }
          this.targets = null;
          this._nativeObj = null;
        }
      }

      gfx.PipelineState;
      const PipelineStateInfo = gfx.PipelineStateInfo;

      const LegacyRenderMode = {
        "AUTO": 0,
        "CANVAS": 1,
        "WEBGL": 2,
        "HEADLESS": 3,
        "WEBGPU": 4
      };
      const RenderType = {
        "UNKNOWN": -1,
        "CANVAS": 0,
        "WEBGL": 1,
        "WEBGPU": 2,
        "OPENGL": 3,
        "HEADLESS": 4
      };
      class DeviceManager {
        constructor() {
          this.initialized = false;
          this._gfxDevice = void 0;
          this._canvas = null;
          this._swapchain = void 0;
          this._renderType = -1;
          this._deviceInitialized = false;
        }
        get gfxDevice() {
          return this._gfxDevice;
        }
        get swapchain() {
          return this._swapchain;
        }
        _tryInitializeWebGPUDevice(DeviceConstructor, info) {
          if (this._deviceInitialized) {
            return Promise.resolve(true);
          }
          if (DeviceConstructor) {
            this._gfxDevice = new DeviceConstructor();
            return new Promise((resolve, reject) => {
              this._gfxDevice.initialize(info).then(val => {
                this._deviceInitialized = val;
                resolve(val);
              }).catch(err => {
                reject(err);
              });
            });
          }
          return Promise.resolve(false);
        }
        _tryInitializeDeviceSync(DeviceConstructor, info) {
          if (this._deviceInitialized) {
            return true;
          }
          if (DeviceConstructor) {
            this._gfxDevice = new DeviceConstructor();
            this._deviceInitialized = this._gfxDevice.initialize(info);
          }
          return this._deviceInitialized;
        }
        init(canvas, bindingMappingInfo) {
          if (this.initialized) {
            return true;
          }
          const renderMode = settings.querySettings(Settings.Category.RENDERING, 'renderMode');
          this._canvas = canvas;
          if (this._canvas) {
            this._canvas.oncontextmenu = () => false;
          }
          this._renderType = this._determineRenderType(renderMode);
          this._deviceInitialized = false;
          const deviceInfo = new DeviceInfo(bindingMappingInfo);
          if (this._renderType === 1 || this._renderType === 2) {
            if (globalThis.gfx) {
              this._gfxDevice = gfx.DeviceManager.create(deviceInfo);
            } else {
              let useWebGL2 = !!globalThis.WebGL2RenderingContext;
              globalThis.navigator.userAgent.toLowerCase();
              if (sys.browserType === BrowserType.UC) {
                useWebGL2 = false;
              }
              if (this._renderType === 2 && cclegacy.WebGPUDevice) {
                return new Promise((resolve, reject) => {
                  this._tryInitializeWebGPUDevice(cclegacy.WebGPUDevice, deviceInfo).then(val => {
                    this._initSwapchain();
                    resolve(val);
                  }).catch(err => {
                    reject(err);
                  });
                });
              }
              if (useWebGL2 && cclegacy.WebGL2Device) {
                this._tryInitializeDeviceSync(cclegacy.WebGL2Device, deviceInfo);
              }
              if (cclegacy.WebGLDevice) {
                this._tryInitializeDeviceSync(cclegacy.WebGLDevice, deviceInfo);
              }
              if (cclegacy.EmptyDevice) {
                this._tryInitializeDeviceSync(cclegacy.EmptyDevice, deviceInfo);
              }
              this._initSwapchain();
            }
          } else if (this._renderType === 4 && cclegacy.EmptyDevice) {
            this._tryInitializeDeviceSync(cclegacy.EmptyDevice, deviceInfo);
            this._initSwapchain();
          }
          if (!this._gfxDevice) {
            errorID(16337);
            this._renderType = -1;
            return false;
          }
          return true;
        }
        _initSwapchain() {
          const swapchainInfo = new SwapchainInfo(1, this._canvas);
          const windowSize = screen.windowSize;
          swapchainInfo.width = windowSize.width;
          swapchainInfo.height = windowSize.height;
          this._swapchain = this._gfxDevice.createSwapchain(swapchainInfo);
        }
        _supportWebGPU() {
          return 'gpu' in globalThis.navigator;
        }
        _determineRenderType(renderMode) {
          if (typeof renderMode !== 'number' || renderMode > 4 || renderMode < 0) {
            renderMode = 0;
          }
          let renderType = 0;
          let supportRender = false;
          if (renderMode === 1) {
            renderType = 0;
            supportRender = true;
          } else if (renderMode === 0 || renderMode === 4) {
            renderType = this._supportWebGPU() && !EDITOR ? 2 : 1;
            supportRender = true;
          } else if (renderMode === 2) {
            renderType = 1;
            supportRender = true;
          } else if (renderMode === 3) {
            renderType = 4;
            supportRender = true;
          }
          if (!supportRender) {
            throw new Error(getError(3820, renderMode));
          }
          return renderType;
        }
      }
      const deviceManager = new DeviceManager();

      const polyfills = {
        GFXDevice: true,
        GFXBuffer: true,
        GFXTexture: true,
        GFXSampler: true,
        GFXShader: true,
        GFXInputAssembler: true,
        GFXRenderPass: true,
        GFXFramebuffer: true,
        GFXPipelineState: true,
        GFXCommandBuffer: true,
        GFXQueue: true,
        GFXObjectType: true,
        GFXObject: false,
        GFXAttributeName: true,
        GFXType: true,
        GFXFormat: true,
        GFXBufferUsageBit: true,
        GFXMemoryUsageBit: true,
        GFXBufferFlagBit: true,
        GFXBufferAccessBit: 'MemoryAccessBit',
        GFXPrimitiveMode: true,
        GFXPolygonMode: true,
        GFXShadeModel: true,
        GFXCullMode: true,
        GFXComparisonFunc: true,
        GFXStencilOp: true,
        GFXBlendOp: true,
        GFXBlendFactor: true,
        GFXColorMask: true,
        GFXFilter: true,
        GFXAddress: true,
        GFXTextureType: true,
        GFXTextureUsageBit: true,
        GFXSampleCount: true,
        GFXTextureFlagBit: true,
        GFXShaderStageFlagBit: true,
        GFXDescriptorType: true,
        GFXCommandBufferType: true,
        GFXLoadOp: true,
        GFXStoreOp: true,
        GFXPipelineBindPoint: true,
        GFXDynamicStateFlagBit: true,
        GFXStencilFace: true,
        GFXQueueType: true,
        GFXRect: true,
        GFXViewport: true,
        GFXColor: true,
        GFXClearFlag: true,
        GFXOffset: true,
        GFXExtent: true,
        GFXTextureSubres: 'TextureSubresLayers',
        GFXTextureCopy: true,
        GFXBufferTextureCopy: true,
        GFXFormatType: true,
        GFXFormatInfo: true,
        GFXMemoryStatus: true,
        GFXFormatInfos: true,
        GFXFormatSize: true,
        GFXFormatSurfaceSize: true,
        GFXGetTypeSize: true,
        getTypedArrayConstructor: false
      };
      for (const name in polyfills) {
        let newName = polyfills[name];
        if (newName === true) {
          newName = name.slice(3);
        } else if (newName === false) {
          newName = name;
        }
        replaceProperty(cclegacy, 'cc', [{
          name,
          newName,
          target: cclegacy.gfx,
          targetName: 'cc.gfx'
        }]);
      }
      removeProperty(cclegacy, 'cc', [{
        name: 'GFX_MAX_VERTEX_ATTRIBUTES'
      }, {
        name: 'GFX_MAX_TEXTURE_UNITS'
      }, {
        name: 'GFX_MAX_ATTACHMENTS'
      }, {
        name: 'GFX_MAX_BUFFER_BINDINGS'
      }, {
        name: 'GFXTextureLayout'
      }]);

      const DescriptorSet = gfx.DescriptorSet;
      const Buffer = gfx.Buffer;
      const CommandBuffer = gfx.CommandBuffer;
      const Device = gfx.Device;
      const Swapchain = gfx.Swapchain;
      const Framebuffer = gfx.Framebuffer;
      const InputAssembler = gfx.InputAssembler;
      const DescriptorSetLayout = gfx.DescriptorSetLayout;
      const PipelineLayout = gfx.PipelineLayout;
      const PipelineState = gfx.PipelineState;
      const Queue = gfx.Queue;
      const RenderPass = gfx.RenderPass;
      const Shader = gfx.Shader;
      const Texture = gfx.Texture;
      const Sampler = gfx.Sampler;
      const GeneralBarrier = gfx.GeneralBarrier;
      const TextureBarrier = gfx.TextureBarrier;
      const polyfillCC = Object.assign({}, defines);
      polyfillCC.GFXObject = gfx.GFXObject;
      polyfillCC.Device = gfx.Device;
      polyfillCC.Swapchain = gfx.Swapchain;
      polyfillCC.Buffer = gfx.Buffer;
      polyfillCC.Texture = gfx.Texture;
      polyfillCC.Sampler = gfx.Sampler;
      polyfillCC.Shader = gfx.Shader;
      polyfillCC.InputAssembler = gfx.InputAssembler;
      polyfillCC.RenderPass = gfx.RenderPass;
      polyfillCC.Framebuffer = gfx.Framebuffer;
      polyfillCC.DescriptorSet = gfx.DescriptorSet;
      polyfillCC.DescriptorSetLayout = gfx.DescriptorSetLayout;
      polyfillCC.PipelineLayout = gfx.PipelineLayout;
      polyfillCC.PipelineState = gfx.PipelineState;
      polyfillCC.CommandBuffer = gfx.CommandBuffer;
      polyfillCC.Queue = gfx.Queue;
      polyfillCC.GeneralBarrier = gfx.GeneralBarrier;
      polyfillCC.TextureBarrier = gfx.TextureBarrier;
      cclegacy.gfx = polyfillCC;
      polyfillCC.BlendTarget = BlendTarget;
      polyfillCC.BlendState = BlendState;
      polyfillCC.RasterizerState = RasterizerState;
      polyfillCC.DepthStencilState = DepthStencilState;
      polyfillCC.PipelineStateInfo = PipelineStateInfo;

      var index$3 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        API: API,
        AccessFlagBit: AccessFlagBit,
        Address: Address,
        Attribute: Attribute,
        AttributeName: AttributeName,
        BarrierType: BarrierType,
        BindingMappingInfo: BindingMappingInfo,
        BlendFactor: BlendFactor,
        BlendOp: BlendOp,
        BlendState: BlendState,
        BlendTarget: BlendTarget,
        Buffer: Buffer,
        BufferBarrierInfo: BufferBarrierInfo,
        BufferFlagBit: BufferFlagBit,
        BufferInfo: BufferInfo,
        BufferTextureCopy: BufferTextureCopy,
        BufferUsageBit: BufferUsageBit,
        BufferViewInfo: BufferViewInfo,
        ClearFlagBit: ClearFlagBit,
        Color: Color,
        ColorAttachment: ColorAttachment,
        ColorMask: ColorMask,
        CommandBuffer: CommandBuffer,
        CommandBufferInfo: CommandBufferInfo,
        CommandBufferType: CommandBufferType,
        ComparisonFunc: ComparisonFunc,
        CullMode: CullMode,
        DESCRIPTOR_BUFFER_TYPE: DESCRIPTOR_BUFFER_TYPE,
        DESCRIPTOR_DYNAMIC_TYPE: DESCRIPTOR_DYNAMIC_TYPE,
        DESCRIPTOR_SAMPLER_TYPE: DESCRIPTOR_SAMPLER_TYPE,
        DRAW_INFO_SIZE: DRAW_INFO_SIZE,
        DepthStencilAttachment: DepthStencilAttachment,
        DepthStencilState: DepthStencilState,
        DescriptorSet: DescriptorSet,
        DescriptorSetInfo: DescriptorSetInfo,
        DescriptorSetLayout: DescriptorSetLayout,
        DescriptorSetLayoutBinding: DescriptorSetLayoutBinding,
        DescriptorSetLayoutInfo: DescriptorSetLayoutInfo,
        DescriptorType: DescriptorType,
        Device: Device,
        DeviceCaps: DeviceCaps,
        DeviceInfo: DeviceInfo,
        DeviceManager: DeviceManager,
        DeviceOptions: DeviceOptions,
        DispatchInfo: DispatchInfo,
        DrawInfo: DrawInfo,
        DynamicStateFlagBit: DynamicStateFlagBit,
        DynamicStates: DynamicStates,
        DynamicStencilStates: DynamicStencilStates,
        Extent: Extent,
        Feature: Feature,
        Filter: Filter,
        Format: Format,
        FormatFeatureBit: FormatFeatureBit,
        FormatInfo: FormatInfo,
        FormatInfos: FormatInfos,
        FormatSize: FormatSize,
        FormatSurfaceSize: FormatSurfaceSize,
        FormatType: FormatType,
        Framebuffer: Framebuffer,
        FramebufferInfo: FramebufferInfo,
        GFXObject: GFXObject,
        GeneralBarrier: GeneralBarrier,
        GeneralBarrierInfo: GeneralBarrierInfo,
        GetTypeSize: GetTypeSize,
        IndirectBuffer: IndirectBuffer,
        InputAssembler: InputAssembler,
        InputAssemblerInfo: InputAssemblerInfo,
        InputState: InputState,
        IsPowerOf2: IsPowerOf2,
        LegacyRenderMode: LegacyRenderMode,
        LoadOp: LoadOp,
        MarkerInfo: MarkerInfo,
        MemoryAccessBit: MemoryAccessBit,
        MemoryStatus: MemoryStatus,
        MemoryUsageBit: MemoryUsageBit,
        ObjectType: ObjectType,
        Offset: Offset,
        PassType: PassType,
        PipelineBindPoint: PipelineBindPoint,
        PipelineLayout: PipelineLayout,
        PipelineLayoutInfo: PipelineLayoutInfo,
        PipelineState: PipelineState,
        PipelineStateInfo: PipelineStateInfo,
        PolygonMode: PolygonMode,
        PrimitiveMode: PrimitiveMode,
        QueryPoolInfo: QueryPoolInfo,
        QueryType: QueryType,
        Queue: Queue,
        QueueInfo: QueueInfo,
        QueueType: QueueType,
        RasterizerState: RasterizerState,
        Rect: Rect,
        RenderPass: RenderPass,
        RenderPassInfo: RenderPassInfo,
        RenderType: RenderType,
        ResolveMode: ResolveMode,
        ResourceRange: ResourceRange,
        SampleCount: SampleCount,
        Sampler: Sampler,
        SamplerInfo: SamplerInfo,
        ShadeModel: ShadeModel,
        Shader: Shader,
        ShaderInfo: ShaderInfo,
        ShaderStage: ShaderStage,
        ShaderStageFlagBit: ShaderStageFlagBit,
        Size: Size,
        Status: Status,
        StencilFace: StencilFace,
        StencilOp: StencilOp,
        StoreOp: StoreOp,
        SubpassDependency: SubpassDependency,
        SubpassInfo: SubpassInfo,
        SurfaceTransform: SurfaceTransform,
        Swapchain: Swapchain,
        SwapchainInfo: SwapchainInfo,
        Texture: Texture,
        TextureBarrier: TextureBarrier,
        TextureBarrierInfo: TextureBarrierInfo,
        TextureBlit: TextureBlit,
        TextureCopy: TextureCopy,
        TextureFlagBit: TextureFlagBit,
        TextureInfo: TextureInfo,
        TextureSubresLayers: TextureSubresLayers,
        TextureSubresRange: TextureSubresRange,
        TextureType: TextureType,
        TextureUsageBit: TextureUsageBit,
        TextureViewInfo: TextureViewInfo,
        Type: Type,
        Uniform: Uniform,
        UniformBlock: UniformBlock,
        UniformInputAttachment: UniformInputAttachment,
        UniformSampler: UniformSampler,
        UniformSamplerTexture: UniformSamplerTexture,
        UniformStorageBuffer: UniformStorageBuffer,
        UniformStorageImage: UniformStorageImage,
        UniformTexture: UniformTexture,
        Viewport: Viewport,
        VsyncMode: VsyncMode,
        alignTo: alignTo,
        deviceManager: deviceManager,
        formatAlignment: formatAlignment,
        getTypedArrayConstructor: getTypedArrayConstructor
      });
      exports("gfx", index$3);

      const _col$1 = new Vec4();
      function fillMeshVertices3D(node, renderer, renderData, color) {
        const chunk = renderData.chunk;
        const dataList = renderData.data;
        const vData = chunk.vb;
        const vertexCount = renderData.vertexCount;
        const m = node.worldMatrix;
        const m00 = m.m00;
        const m01 = m.m01;
        const m02 = m.m02;
        const m03 = m.m03;
        const m04 = m.m04;
        const m05 = m.m05;
        const m06 = m.m06;
        const m07 = m.m07;
        const m12 = m.m12;
        const m13 = m.m13;
        const m14 = m.m14;
        const m15 = m.m15;
        _col$1.set(color.r / 255, color.g / 255, color.b / 255, color.a / 255);
        let vertexOffset = 0;
        for (let i = 0; i < vertexCount; ++i) {
          const vert = dataList[i];
          const x = vert.x;
          const y = vert.y;
          let rhw = m03 * x + m07 * y + m15;
          rhw = rhw ? 1 / rhw : 1;
          vData[vertexOffset + 0] = (m00 * x + m04 * y + m12) * rhw;
          vData[vertexOffset + 1] = (m01 * x + m05 * y + m13) * rhw;
          vData[vertexOffset + 2] = (m02 * x + m06 * y + m14) * rhw;
          Vec4.toArray(vData, _col$1, vertexOffset + 5);
          vertexOffset += 9;
        }
        chunk.bufferId;
        const vid = chunk.vertexOffset;
        const meshBuffer = chunk.meshBuffer;
        const ib = chunk.meshBuffer.iData;
        let indexOffset = meshBuffer.indexOffset;
        for (let i = 0, count = vertexCount / 4; i < count; i++) {
          const start = vid + i * 4;
          ib[indexOffset++] = start;
          ib[indexOffset++] = start + 1;
          ib[indexOffset++] = start + 2;
          ib[indexOffset++] = start + 1;
          ib[indexOffset++] = start + 3;
          ib[indexOffset++] = start + 2;
        }
        meshBuffer.indexOffset += renderData.indexCount;
        meshBuffer.setDirty();
      }
      function updateOpacity(renderData, opacity) {
        const vfmt = renderData.vertexFormat;
        const vb = renderData.chunk.vb;
        let attr;
        let format;
        let stride;
        let offset = 0;
        for (let i = 0; i < vfmt.length; ++i) {
          attr = vfmt[i];
          format = FormatInfos[attr.format];
          if (format.hasAlpha) {
            stride = renderData.floatStride;
            if (format.size / format.count === 1) {
              const alpha = ~~clamp$1(Math.round(opacity * 255), 0, 255);
              for (let color = offset; color < vb.length; color += stride) {
                vb[color] = (vb[color] & 0xffffff00 | alpha) >>> 0;
              }
            } else if (format.size / format.count === 4) {
              for (let alpha = offset + 3; alpha < vb.length; alpha += stride) {
                vb[alpha] = opacity;
              }
            }
          }
          offset += format.size >> 2;
        }
      }

      const minigame = {};

      class Cache {
        get map() {
          return this._map;
        }
        constructor(map) {
          this._map = null;
          this._count = 0;
          if (map) {
            this._map = map;
            this._count = Object.keys(map).length;
          } else {
            this._map = createMap(true);
            this._count = 0;
          }
        }
        add(key, val) {
          if (!(key in this._map)) {
            this._count++;
          }
          return this._map[key] = val;
        }
        get(key) {
          return this._map[key];
        }
        has(key) {
          return key in this._map;
        }
        remove(key) {
          const out = this._map[key];
          if (key in this._map) {
            delete this._map[key];
            this._count--;
          }
          return out;
        }
        clear() {
          if (this._count !== 0) {
            this._map = createMap(true);
            this._count = 0;
          }
        }
        forEach(func) {
          for (const key in this._map) {
            func(this._map[key], key);
          }
        }
        find(predicate) {
          for (const key in this._map) {
            if (predicate(this._map[key], key)) {
              return this._map[key];
            }
          }
          return null;
        }
        get count() {
          return this._count;
        }
        destroy() {
          this._map = null;
        }
      }

      class Pipeline {
        constructor(name, funcs) {
          this.id = Pipeline._pipelineId++;
          this.name = '';
          this.pipes = [];
          this.name = name;
          for (let i = 0, l = funcs.length; i < l; i++) {
            this.pipes.push(funcs[i]);
          }
        }
        insert(func, index) {
          if (index > this.pipes.length) {
            warnID(4921);
            return this;
          }
          this.pipes.splice(index, 0, func);
          return this;
        }
        append(func) {
          this.pipes.push(func);
          return this;
        }
        remove(index) {
          this.pipes.splice(index, 1);
          return this;
        }
        sync(task) {
          const pipes = this.pipes;
          if (pipes.length === 0) {
            return null;
          }
          task.isFinished = false;
          for (let i = 0, l = pipes.length; i < l;) {
            const pipe = pipes[i];
            const result = pipe(task);
            if (result) {
              task.isFinished = true;
              return result;
            }
            i++;
            if (i !== l) {
              task.input = task.output;
              task.output = null;
            }
          }
          task.isFinished = true;
          return task.output;
        }
        async(task) {
          const pipes = this.pipes;
          if (pipes.length === 0) {
            return;
          }
          task.isFinished = false;
          this._flow(0, task);
        }
        _flow(index, task) {
          const pipe = this.pipes[index];
          pipe(task, result => {
            if (result) {
              task.isFinished = true;
              task.dispatch('complete', result);
            } else {
              index++;
              if (index < this.pipes.length) {
                task.input = task.output;
                task.output = null;
                this._flow(index, task);
              } else {
                task.isFinished = true;
                task.dispatch('complete', result, task.output);
              }
            }
          });
        }
      }
      Pipeline._pipelineId = 0;

      const assets = new Cache();
      const files = new Cache();
      const parsed = new Cache();
      const bundles = new Cache();
      const pipeline = new Pipeline('normal load', []);
      const fetchPipeline = new Pipeline('fetch', []);
      const transformPipeline = new Pipeline('transform url', []);
      const references = null;
      const assetsOverrideMap = new Map();
      const presets = {
        default: {
          priority: 0
        },
        preload: {
          maxConcurrency: 6,
          maxRequestsPerFrame: 2,
          priority: -1
        },
        scene: {
          maxConcurrency: 20,
          maxRequestsPerFrame: 20,
          priority: 1
        },
        bundle: {
          maxConcurrency: 20,
          maxRequestsPerFrame: 20,
          priority: 2
        },
        remote: {
          maxRetryCount: 4
        }
      };
      const BuiltinBundleName = {
        "INTERNAL": "internal",
        "RESOURCES": "resources",
        "MAIN": "main",
        "START_SCENE": "start-scene"
      };

      class Task {
        static create(options) {
          let out;
          if (Task._deadPool.length !== 0) {
            out = Task._deadPool.pop();
            out.set(options);
          } else {
            out = new Task(options);
          }
          return out;
        }
        get isFinish() {
          return this.isFinished;
        }
        set isFinish(val) {
          this.isFinished = val;
        }
        constructor(options) {
          this.id = Task._taskId++;
          this.onComplete = null;
          this.onProgress = null;
          this.onError = null;
          this.source = null;
          this.output = null;
          this.input = null;
          this.progress = null;
          this.options = null;
          this.isFinished = true;
          this.set(options);
        }
        set(options = Object.create(null)) {
          this.onComplete = options.onComplete || null;
          this.onProgress = options.onProgress || null;
          this.onError = options.onError || null;
          this.source = this.input = options.input;
          this.output = null;
          this.progress = options.progress;
          this.options = options.options || Object.create(null);
        }
        dispatch(event, param1, param2, param3, param4) {
          switch (event) {
            case 'complete':
              if (this.onComplete) {
                this.onComplete(param1, param2);
              }
              break;
            case 'progress':
              if (this.onProgress) {
                this.onProgress(param1, param2, param3, param4);
              }
              break;
            case 'error':
              if (this.onError) {
                this.onError(param1, param2, param3, param4);
              }
              break;
            default:
              {
                const str = `on${event[0].toUpperCase()}${event.substr(1)}`;
                if (typeof this[str] === 'function') {
                  this[str](param1, param2, param3, param4);
                }
                break;
              }
          }
        }
        recycle() {
          if (Task._deadPool.length === Task.MAX_DEAD_NUM) {
            return;
          }
          this.onComplete = null;
          this.onProgress = null;
          this.onError = null;
          this.source = this.output = this.input = null;
          this.progress = null;
          this.options = null;
          Task._deadPool.push(this);
        }
      }
      Task.MAX_DEAD_NUM = 500;
      Task._taskId = 0;
      Task._deadPool = [];

      const separator = '@';
      const HexChars = '0123456789abcdef'.split('');
      const _t = ['', '', '', ''];
      const UuidTemplate = _t.concat(_t, '-', _t, '-', _t, '-', _t, '-', _t, _t, _t);
      const Indices = UuidTemplate.map((x, i) => x === '-' ? NaN : i).filter(Number.isFinite);
      function decodeUuid(base64) {
        const strs = base64.split(separator);
        const uuid = strs[0];
        if (uuid.length !== 22) {
          return base64;
        }
        UuidTemplate[0] = base64[0];
        UuidTemplate[1] = base64[1];
        for (let i = 2, j = 2; i < 22; i += 2) {
          const lhs = BASE64_VALUES$1[base64.charCodeAt(i)];
          const rhs = BASE64_VALUES$1[base64.charCodeAt(i + 1)];
          UuidTemplate[Indices[j++]] = HexChars[lhs >> 2];
          UuidTemplate[Indices[j++]] = HexChars[(lhs & 3) << 2 | rhs >> 4];
          UuidTemplate[Indices[j++]] = HexChars[rhs & 0xF];
        }
        return base64.replace(uuid, UuidTemplate.join(''));
      }

      const _uuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-@]{8,}).*/;
      function getUuidFromURL(url) {
        const matches = _uuidRegex.exec(url);
        if (matches) {
          return matches[1];
        }
        return '';
      }
      function getUrlWithUuid(uuid, options) {
        options = options || Object.create(null);
        options.__isNative__ = options.isNative;
        if (options.nativeExt) {
          options.ext = options.nativeExt;
        }
        const bundle = bundles.find(b => !!b.getAssetInfo(uuid));
        if (bundle) {
          options.bundle = bundle.name;
        }
        return transform(uuid, options);
      }
      function isScene(asset) {
        return !!asset && (asset instanceof cclegacy.SceneAsset || asset instanceof cclegacy.Scene);
      }
      function normalize(url) {
        if (url) {
          if (url.charCodeAt(0) === 46 && url.charCodeAt(1) === 47) {
            url = url.slice(2);
          } else if (url.charCodeAt(0) === 47) {
            url = url.slice(1);
          }
        }
        return url;
      }
      function transform(input, options) {
        const subTask = Task.create({
          input,
          options
        });
        const urls = [];
        try {
          const result = transformPipeline.sync(subTask);
          for (const requestItem of result) {
            const url = requestItem.url;
            requestItem.recycle();
            urls.push(url);
          }
        } catch (e) {
          for (const item of subTask.output) {
            item.recycle();
          }
          error(e.message, e.stack);
        }
        subTask.recycle();
        return urls.length > 1 ? urls : urls[0];
      }

      var helper = /*#__PURE__*/Object.freeze({
        __proto__: null,
        decodeUuid: decodeUuid,
        getUrlWithUuid: getUrlWithUuid,
        getUuidFromURL: getUuidFromURL,
        isScene: isScene,
        normalize: normalize,
        transform: transform
      });

      const defaultExec = (cb, decorator, attr) => {
        cb();
      };
      function patch_BloomStage(ctx, apply = defaultExec) {
        const {
          BloomStage,
          Material
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(BloomStage.prototype, '_bloomMaterial', () => {
            return null;
          });
        }, 'displayOrder', '_bloomMaterial');
        apply(() => {
          serializable$l(BloomStage.prototype, '_bloomMaterial', () => {
            return null;
          });
        }, 'serializable', '_bloomMaterial');
        apply(() => {
          type$a(Material)(BloomStage.prototype, '_bloomMaterial', () => {
            return null;
          });
        }, 'type', '_bloomMaterial');
        apply(() => {
          ccclass$H('BloomStage')(BloomStage);
        }, 'ccclass', null);
      }
      function patch_cc_AmbientInfo(ctx, apply = defaultExec) {
        const {
          AmbientInfo,
          legacyCC,
          CCFloat,
          Vec4,
          Ambient
        } = {
          ...ctx
        };
        const skyLightingColorDescriptor = Object.getOwnPropertyDescriptor(AmbientInfo.prototype, 'skyLightingColor');
        const skyIllumDescriptor = Object.getOwnPropertyDescriptor(AmbientInfo.prototype, 'skyIllum');
        const groundLightingColorDescriptor = Object.getOwnPropertyDescriptor(AmbientInfo.prototype, 'groundLightingColor');
        apply(() => {
          tooltip$1()(AmbientInfo.prototype, 'skyLightingColor', skyLightingColorDescriptor);
        }, 'tooltip', 'skyLightingColor');
        apply(() => {
          editable$5(AmbientInfo.prototype);
        }, 'editable', 'skyLightingColor');
        apply(() => {
          visible$3()(AmbientInfo.prototype, 'skyLightingColor', skyLightingColorDescriptor);
        }, 'visible', 'skyLightingColor');
        apply(() => {
          range()(AmbientInfo.prototype, 'skyIllum', skyIllumDescriptor);
        }, 'range', 'skyIllum');
        apply(() => {
          tooltip$1()(AmbientInfo.prototype, 'skyIllum', skyIllumDescriptor);
        }, 'tooltip', 'skyIllum');
        apply(() => {
          type$a(CCFloat)(AmbientInfo.prototype, 'skyIllum', skyIllumDescriptor);
        }, 'type', 'skyIllum');
        apply(() => {
          editable$5(AmbientInfo.prototype);
        }, 'editable', 'skyIllum');
        apply(() => {
          tooltip$1()(AmbientInfo.prototype, 'groundLightingColor', groundLightingColorDescriptor);
        }, 'tooltip', 'groundLightingColor');
        apply(() => {
          editable$5(AmbientInfo.prototype);
        }, 'editable', 'groundLightingColor');
        apply(() => {
          visible$3()(AmbientInfo.prototype, 'groundLightingColor', groundLightingColorDescriptor);
        }, 'visible', 'groundLightingColor');
        apply(() => {
          formerlySerializedAs$2('_skyColor')(AmbientInfo.prototype, '_skyColorHDR', () => {
            return new Vec4(0.2, 0.5, 0.8, 1.0);
          });
        }, 'formerlySerializedAs', '_skyColorHDR');
        apply(() => {
          serializable$l(AmbientInfo.prototype, '_skyColorHDR', () => {
            return new Vec4(0.2, 0.5, 0.8, 1.0);
          });
        }, 'serializable', '_skyColorHDR');
        apply(() => {
          formerlySerializedAs$2('_skyIllum')(AmbientInfo.prototype, '_skyIllumHDR', () => {
            return Ambient.SKY_ILLUM;
          });
        }, 'formerlySerializedAs', '_skyIllumHDR');
        apply(() => {
          serializable$l(AmbientInfo.prototype, '_skyIllumHDR', () => {
            return Ambient.SKY_ILLUM;
          });
        }, 'serializable', '_skyIllumHDR');
        apply(() => {
          formerlySerializedAs$2('_groundAlbedo')(AmbientInfo.prototype, '_groundAlbedoHDR', () => {
            return new Vec4(0.2, 0.2, 0.2, 1.0);
          });
        }, 'formerlySerializedAs', '_groundAlbedoHDR');
        apply(() => {
          serializable$l(AmbientInfo.prototype, '_groundAlbedoHDR', () => {
            return new Vec4(0.2, 0.2, 0.2, 1.0);
          });
        }, 'serializable', '_groundAlbedoHDR');
        apply(() => {
          serializable$l(AmbientInfo.prototype, '_skyColorLDR', () => {
            return new Vec4(0.2, 0.5, 0.8, 1.0);
          });
        }, 'serializable', '_skyColorLDR');
        apply(() => {
          serializable$l(AmbientInfo.prototype, '_skyIllumLDR', () => {
            return Ambient.SKY_ILLUM;
          });
        }, 'serializable', '_skyIllumLDR');
        apply(() => {
          serializable$l(AmbientInfo.prototype, '_groundAlbedoLDR', () => {
            return new Vec4(0.2, 0.2, 0.2, 1.0);
          });
        }, 'serializable', '_groundAlbedoLDR');
        apply(() => {
          ccclass$H('cc.AmbientInfo')(AmbientInfo);
        }, 'ccclass', null);
      }
      function patch_cc_Asset(ctx, apply = defaultExec) {
        const {
          Asset
        } = {
          ...ctx
        };
        const _nativeAssetDescriptor = Object.getOwnPropertyDescriptor(Asset.prototype, '_nativeAsset');
        apply(() => {
          serializable$l(Asset.prototype, '_native', () => {
            return '';
          });
        }, 'serializable', '_native');
        apply(() => {
          property(Asset.prototype, '_nativeAsset', _nativeAssetDescriptor);
        }, 'property', '_nativeAsset');
        apply(() => {
          ccclass$H('cc.Asset')(Asset);
        }, 'ccclass', null);
      }
      function patch_cc_BufferAsset(ctx, apply = defaultExec) {
        const {
          BufferAsset
        } = {
          ...ctx
        };
        const _nativeAssetDescriptor = Object.getOwnPropertyDescriptor(BufferAsset.prototype, '_nativeAsset');
        apply(() => {
          override$1(BufferAsset.prototype, '_nativeAsset', _nativeAssetDescriptor);
        }, 'override', '_nativeAsset');
        apply(() => {
          ccclass$H('cc.BufferAsset')(BufferAsset);
        }, 'ccclass', null);
      }
      function patch_cc_CircumSphere(ctx, apply = defaultExec) {
        const {
          CircumSphere,
          Vec3
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(CircumSphere.prototype, 'center', () => {
            return new Vec3(0, 0, 0);
          });
        }, 'serializable', 'center');
        apply(() => {
          serializable$l(CircumSphere.prototype, 'radiusSquared', () => {
            return 0.0;
          });
        }, 'serializable', 'radiusSquared');
        apply(() => {
          ccclass$H('cc.CircumSphere')(CircumSphere);
        }, 'ccclass', null);
      }
      function patch_cc_EffectAsset(ctx, apply = defaultExec) {
        const {
          EffectAsset
        } = {
          ...ctx
        };
        apply(() => {
          editable$5(EffectAsset.prototype);
        }, 'editable', 'techniques');
        apply(() => {
          serializable$l(EffectAsset.prototype, 'techniques', () => {
            return [];
          });
        }, 'serializable', 'techniques');
        apply(() => {
          editable$5(EffectAsset.prototype);
        }, 'editable', 'shaders');
        apply(() => {
          serializable$l(EffectAsset.prototype, 'shaders', () => {
            return [];
          });
        }, 'serializable', 'shaders');
        apply(() => {
          editable$5(EffectAsset.prototype);
        }, 'editable', 'combinations');
        apply(() => {
          serializable$l(EffectAsset.prototype, 'combinations', () => {
            return [];
          });
        }, 'serializable', 'combinations');
        apply(() => {
          editorOnly(EffectAsset.prototype, 'hideInEditor', () => {
            return false;
          });
        }, 'editorOnly', 'hideInEditor');
        apply(() => {
          serializable$l(EffectAsset.prototype, 'hideInEditor', () => {
            return false;
          });
        }, 'serializable', 'hideInEditor');
        apply(() => {
          ccclass$H('cc.EffectAsset')(EffectAsset);
        }, 'ccclass', null);
      }
      function patch_cc_FogInfo(ctx, apply = defaultExec) {
        const {
          FogInfo,
          FogType,
          CCFloat,
          Color
        } = {
          ...ctx
        };
        const enabledDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'enabled');
        const accurateDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'accurate');
        const fogColorDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogColor');
        const typeDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'type');
        const fogDensityDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogDensity');
        const fogStartDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogStart');
        const fogEndDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogEnd');
        const fogAttenDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogAtten');
        const fogTopDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogTop');
        const fogRangeDescriptor = Object.getOwnPropertyDescriptor(FogInfo.prototype, 'fogRange');
        apply(() => {
          displayOrder$2()(FogInfo.prototype, 'enabled', enabledDescriptor);
        }, 'displayOrder', 'enabled');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'enabled', enabledDescriptor);
        }, 'tooltip', 'enabled');
        apply(() => {
          editable$5(FogInfo.prototype);
        }, 'editable', 'enabled');
        apply(() => {
          displayOrder$2()(FogInfo.prototype, 'accurate', accurateDescriptor);
        }, 'displayOrder', 'accurate');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'accurate', accurateDescriptor);
        }, 'tooltip', 'accurate');
        apply(() => {
          editable$5(FogInfo.prototype);
        }, 'editable', 'accurate');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogColor', fogColorDescriptor);
        }, 'tooltip', 'fogColor');
        apply(() => {
          editable$5(FogInfo.prototype);
        }, 'editable', 'fogColor');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'type', typeDescriptor);
        }, 'tooltip', 'type');
        apply(() => {
          displayOrder$2()(FogInfo.prototype, 'type', typeDescriptor);
        }, 'displayOrder', 'type');
        apply(() => {
          type$a(FogType)(FogInfo.prototype, 'type', typeDescriptor);
        }, 'type', 'type');
        apply(() => {
          editable$5(FogInfo.prototype);
        }, 'editable', 'type');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogDensity', fogDensityDescriptor);
        }, 'tooltip', 'fogDensity');
        apply(() => {
          slide(FogInfo.prototype);
        }, 'slide', 'fogDensity');
        apply(() => {
          range()(FogInfo.prototype, 'fogDensity', fogDensityDescriptor);
        }, 'range', 'fogDensity');
        apply(() => {
          type$a(CCFloat)(FogInfo.prototype, 'fogDensity', fogDensityDescriptor);
        }, 'type', 'fogDensity');
        apply(() => {
          visible$3()(FogInfo.prototype, 'fogDensity', fogDensityDescriptor);
        }, 'visible', 'fogDensity');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogStart', fogStartDescriptor);
        }, 'tooltip', 'fogStart');
        apply(() => {
          rangeStep()(FogInfo.prototype, 'fogStart', fogStartDescriptor);
        }, 'rangeStep', 'fogStart');
        apply(() => {
          type$a(CCFloat)(FogInfo.prototype, 'fogStart', fogStartDescriptor);
        }, 'type', 'fogStart');
        apply(() => {
          visible$3()(FogInfo.prototype, 'fogStart', fogStartDescriptor);
        }, 'visible', 'fogStart');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogEnd', fogEndDescriptor);
        }, 'tooltip', 'fogEnd');
        apply(() => {
          rangeStep()(FogInfo.prototype, 'fogEnd', fogEndDescriptor);
        }, 'rangeStep', 'fogEnd');
        apply(() => {
          type$a(CCFloat)(FogInfo.prototype, 'fogEnd', fogEndDescriptor);
        }, 'type', 'fogEnd');
        apply(() => {
          visible$3()(FogInfo.prototype, 'fogEnd', fogEndDescriptor);
        }, 'visible', 'fogEnd');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogAtten', fogAttenDescriptor);
        }, 'tooltip', 'fogAtten');
        apply(() => {
          rangeStep()(FogInfo.prototype, 'fogAtten', fogAttenDescriptor);
        }, 'rangeStep', 'fogAtten');
        apply(() => {
          rangeMin()(FogInfo.prototype, 'fogAtten', fogAttenDescriptor);
        }, 'rangeMin', 'fogAtten');
        apply(() => {
          type$a(CCFloat)(FogInfo.prototype, 'fogAtten', fogAttenDescriptor);
        }, 'type', 'fogAtten');
        apply(() => {
          visible$3()(FogInfo.prototype, 'fogAtten', fogAttenDescriptor);
        }, 'visible', 'fogAtten');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogTop', fogTopDescriptor);
        }, 'tooltip', 'fogTop');
        apply(() => {
          rangeStep()(FogInfo.prototype, 'fogTop', fogTopDescriptor);
        }, 'rangeStep', 'fogTop');
        apply(() => {
          type$a(CCFloat)(FogInfo.prototype, 'fogTop', fogTopDescriptor);
        }, 'type', 'fogTop');
        apply(() => {
          visible$3()(FogInfo.prototype, 'fogTop', fogTopDescriptor);
        }, 'visible', 'fogTop');
        apply(() => {
          tooltip$1()(FogInfo.prototype, 'fogRange', fogRangeDescriptor);
        }, 'tooltip', 'fogRange');
        apply(() => {
          rangeStep()(FogInfo.prototype, 'fogRange', fogRangeDescriptor);
        }, 'rangeStep', 'fogRange');
        apply(() => {
          type$a(CCFloat)(FogInfo.prototype, 'fogRange', fogRangeDescriptor);
        }, 'type', 'fogRange');
        apply(() => {
          visible$3()(FogInfo.prototype, 'fogRange', fogRangeDescriptor);
        }, 'visible', 'fogRange');
        apply(() => {
          serializable$l(FogInfo.prototype, '_type', () => {
            return FogType.LINEAR;
          });
        }, 'serializable', '_type');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogColor', () => {
            return new Color('#C8C8C8');
          });
        }, 'serializable', '_fogColor');
        apply(() => {
          serializable$l(FogInfo.prototype, '_enabled', () => {
            return false;
          });
        }, 'serializable', '_enabled');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogDensity', () => {
            return 0.3;
          });
        }, 'serializable', '_fogDensity');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogStart', () => {
            return 0.5;
          });
        }, 'serializable', '_fogStart');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogEnd', () => {
            return 300;
          });
        }, 'serializable', '_fogEnd');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogAtten', () => {
            return 5;
          });
        }, 'serializable', '_fogAtten');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogTop', () => {
            return 1.5;
          });
        }, 'serializable', '_fogTop');
        apply(() => {
          serializable$l(FogInfo.prototype, '_fogRange', () => {
            return 1.2;
          });
        }, 'serializable', '_fogRange');
        apply(() => {
          serializable$l(FogInfo.prototype, '_accurate', () => {
            return false;
          });
        }, 'serializable', '_accurate');
        apply(() => {
          ccclass$H('cc.FogInfo')(FogInfo);
        }, 'ccclass', null);
      }
      function patch_cc_ImageAsset(ctx, apply = defaultExec) {
        const {
          ImageAsset
        } = {
          ...ctx
        };
        const _nativeAssetDescriptor = Object.getOwnPropertyDescriptor(ImageAsset.prototype, '_nativeAsset');
        apply(() => {
          override$1(ImageAsset.prototype, '_nativeAsset', _nativeAssetDescriptor);
        }, 'override', '_nativeAsset');
        apply(() => {
          ccclass$H('cc.ImageAsset')(ImageAsset);
        }, 'ccclass', null);
      }
      function patch_cc_LightProbeInfo(ctx, apply = defaultExec) {
        const {
          LightProbeInfo,
          CCFloat,
          CCInteger
        } = {
          ...ctx
        };
        const giScaleDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'giScale');
        const giSamplesDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'giSamples');
        const bouncesDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'bounces');
        const reduceRingingDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'reduceRinging');
        const showWireframeDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'showWireframe');
        const showConvexDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'showConvex');
        const lightProbeSphereVolumeDescriptor = Object.getOwnPropertyDescriptor(LightProbeInfo.prototype, 'lightProbeSphereVolume');
        apply(() => {
          displayName$2()(LightProbeInfo.prototype, 'giScale', giScaleDescriptor);
        }, 'displayName', 'giScale');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'giScale', giScaleDescriptor);
        }, 'tooltip', 'giScale');
        apply(() => {
          type$a(CCFloat)(LightProbeInfo.prototype, 'giScale', giScaleDescriptor);
        }, 'type', 'giScale');
        apply(() => {
          range()(LightProbeInfo.prototype, 'giScale', giScaleDescriptor);
        }, 'range', 'giScale');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'giScale');
        apply(() => {
          displayName$2()(LightProbeInfo.prototype, 'giSamples', giSamplesDescriptor);
        }, 'displayName', 'giSamples');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'giSamples', giSamplesDescriptor);
        }, 'tooltip', 'giSamples');
        apply(() => {
          type$a(CCInteger)(LightProbeInfo.prototype, 'giSamples', giSamplesDescriptor);
        }, 'type', 'giSamples');
        apply(() => {
          range()(LightProbeInfo.prototype, 'giSamples', giSamplesDescriptor);
        }, 'range', 'giSamples');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'giSamples');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'bounces', bouncesDescriptor);
        }, 'tooltip', 'bounces');
        apply(() => {
          type$a(CCInteger)(LightProbeInfo.prototype, 'bounces', bouncesDescriptor);
        }, 'type', 'bounces');
        apply(() => {
          range()(LightProbeInfo.prototype, 'bounces', bouncesDescriptor);
        }, 'range', 'bounces');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'bounces');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'reduceRinging', reduceRingingDescriptor);
        }, 'tooltip', 'reduceRinging');
        apply(() => {
          type$a(CCFloat)(LightProbeInfo.prototype, 'reduceRinging', reduceRingingDescriptor);
        }, 'type', 'reduceRinging');
        apply(() => {
          slide(LightProbeInfo.prototype);
        }, 'slide', 'reduceRinging');
        apply(() => {
          range()(LightProbeInfo.prototype, 'reduceRinging', reduceRingingDescriptor);
        }, 'range', 'reduceRinging');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'reduceRinging');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'showWireframe', showWireframeDescriptor);
        }, 'tooltip', 'showWireframe');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'showWireframe');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'showConvex', showConvexDescriptor);
        }, 'tooltip', 'showConvex');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'showConvex');
        apply(() => {
          tooltip$1()(LightProbeInfo.prototype, 'lightProbeSphereVolume', lightProbeSphereVolumeDescriptor);
        }, 'tooltip', 'lightProbeSphereVolume');
        apply(() => {
          type$a(CCFloat)(LightProbeInfo.prototype, 'lightProbeSphereVolume', lightProbeSphereVolumeDescriptor);
        }, 'type', 'lightProbeSphereVolume');
        apply(() => {
          range()(LightProbeInfo.prototype, 'lightProbeSphereVolume', lightProbeSphereVolumeDescriptor);
        }, 'range', 'lightProbeSphereVolume');
        apply(() => {
          editable$5(LightProbeInfo.prototype);
        }, 'editable', 'lightProbeSphereVolume');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_giScale', () => {
            return 1.0;
          });
        }, 'serializable', '_giScale');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_giSamples', () => {
            return 1024;
          });
        }, 'serializable', '_giSamples');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_bounces', () => {
            return 2;
          });
        }, 'serializable', '_bounces');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_reduceRinging', () => {
            return 0.0;
          });
        }, 'serializable', '_reduceRinging');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_showProbe', () => {
            return true;
          });
        }, 'serializable', '_showProbe');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_showWireframe', () => {
            return true;
          });
        }, 'serializable', '_showWireframe');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_showConvex', () => {
            return false;
          });
        }, 'serializable', '_showConvex');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_data', () => {
            return null;
          });
        }, 'serializable', '_data');
        apply(() => {
          serializable$l(LightProbeInfo.prototype, '_lightProbeSphereVolume', () => {
            return 1.0;
          });
        }, 'serializable', '_lightProbeSphereVolume');
        apply(() => {
          ccclass$H('cc.LightProbeInfo')(LightProbeInfo);
        }, 'ccclass', null);
      }
      function patch_cc_LightProbesData(ctx, apply = defaultExec) {
        const {
          LightProbesData,
          Vertex,
          Tetrahedron
        } = {
          ...ctx
        };
        apply(() => {
          type$a([Vertex])(LightProbesData.prototype, '_probes', () => {
            return [];
          });
        }, 'type', '_probes');
        apply(() => {
          serializable$l(LightProbesData.prototype, '_probes', () => {
            return [];
          });
        }, 'serializable', '_probes');
        apply(() => {
          type$a([Tetrahedron])(LightProbesData.prototype, '_tetrahedrons', () => {
            return [];
          });
        }, 'type', '_tetrahedrons');
        apply(() => {
          serializable$l(LightProbesData.prototype, '_tetrahedrons', () => {
            return [];
          });
        }, 'serializable', '_tetrahedrons');
        apply(() => {
          ccclass$H('cc.LightProbesData')(LightProbesData);
        }, 'ccclass', null);
      }
      function patch_cc_Material(ctx, apply = defaultExec) {
        const {
          Material,
          EffectAsset
        } = {
          ...ctx
        };
        apply(() => {
          type$a(EffectAsset)(Material.prototype, '_effectAsset', () => {
            return null;
          });
        }, 'type', '_effectAsset');
        apply(() => {
          serializable$l(Material.prototype, '_techIdx', () => {
            return 0;
          });
        }, 'serializable', '_techIdx');
        apply(() => {
          serializable$l(Material.prototype, '_defines', () => {
            return [];
          });
        }, 'serializable', '_defines');
        apply(() => {
          serializable$l(Material.prototype, '_states', () => {
            return [];
          });
        }, 'serializable', '_states');
        apply(() => {
          serializable$l(Material.prototype, '_props', () => {
            return [];
          });
        }, 'serializable', '_props');
        apply(() => {
          ccclass$H('cc.Material')(Material);
        }, 'ccclass', null);
      }
      function patch_cc_Mesh(ctx, apply = defaultExec) {
        const {
          Mesh
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(Mesh.prototype, '_struct', () => {
            return {
              vertexBundles: [],
              primitives: []
            };
          });
        }, 'serializable', '_struct');
        apply(() => {
          serializable$l(Mesh.prototype, '_hash', () => {
            return 0;
          });
        }, 'serializable', '_hash');
        apply(() => {
          serializable$l(Mesh.prototype, '_allowDataAccess', () => {
            return true;
          });
        }, 'serializable', '_allowDataAccess');
        apply(() => {
          ccclass$H('cc.Mesh')(Mesh);
        }, 'ccclass', null);
      }
      function patch_cc_Node(ctx, apply = defaultExec) {
        const {
          Node,
          Vec3,
          Quat,
          MobilityMode,
          Layers
        } = {
          ...ctx
        };
        const _persistNodeDescriptor = Object.getOwnPropertyDescriptor(Node.prototype, '_persistNode');
        Object.getOwnPropertyDescriptor(Node.prototype, 'name');
        Object.getOwnPropertyDescriptor(Node.prototype, 'children');
        Object.getOwnPropertyDescriptor(Node.prototype, 'active');
        Object.getOwnPropertyDescriptor(Node.prototype, 'activeInHierarchy');
        Object.getOwnPropertyDescriptor(Node.prototype, 'parent');
        const eulerAnglesDescriptor = Object.getOwnPropertyDescriptor(Node.prototype, 'eulerAngles');
        Object.getOwnPropertyDescriptor(Node.prototype, 'angle');
        const mobilityDescriptor = Object.getOwnPropertyDescriptor(Node.prototype, 'mobility');
        Object.getOwnPropertyDescriptor(Node.prototype, 'layer');
        apply(() => {
          property(Node.prototype, '_persistNode', _persistNodeDescriptor);
        }, 'property', '_persistNode');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'name');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'children');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'active');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'activeInHierarchy');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'parent');
        apply(() => {
          serializable$l(Node.prototype, '_parent', () => {
            return null;
          });
        }, 'serializable', '_parent');
        apply(() => {
          serializable$l(Node.prototype, '_children', () => {
            return [];
          });
        }, 'serializable', '_children');
        apply(() => {
          serializable$l(Node.prototype, '_active', () => {
            return true;
          });
        }, 'serializable', '_active');
        apply(() => {
          serializable$l(Node.prototype, '_components', () => {
            return [];
          });
        }, 'serializable', '_components');
        apply(() => {
          serializable$l(Node.prototype, '_prefab', () => {
            return null;
          });
        }, 'serializable', '_prefab');
        apply(() => {
          serializable$l(Node.prototype, '_lpos', () => {
            return new Vec3();
          });
        }, 'serializable', '_lpos');
        apply(() => {
          serializable$l(Node.prototype, '_lrot', () => {
            return new Quat();
          });
        }, 'serializable', '_lrot');
        apply(() => {
          serializable$l(Node.prototype, '_lscale', () => {
            return new Vec3(1, 1, 1);
          });
        }, 'serializable', '_lscale');
        apply(() => {
          serializable$l(Node.prototype, '_mobility', () => {
            return MobilityMode.Static;
          });
        }, 'serializable', '_mobility');
        apply(() => {
          serializable$l(Node.prototype, '_layer', () => {
            return Layers.Enum.DEFAULT;
          });
        }, 'serializable', '_layer');
        apply(() => {
          serializable$l(Node.prototype, '_euler', () => {
            return new Vec3();
          });
        }, 'serializable', '_euler');
        apply(() => {
          type$a(Vec3)(Node.prototype, 'eulerAngles', eulerAnglesDescriptor);
        }, 'type', 'eulerAngles');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'angle');
        apply(() => {
          type$a(MobilityMode)(Node.prototype, 'mobility', mobilityDescriptor);
        }, 'type', 'mobility');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'mobility');
        apply(() => {
          editable$5(Node.prototype);
        }, 'editable', 'layer');
        apply(() => {
          ccclass$H('cc.Node')(Node);
        }, 'ccclass', null);
      }
      function patch_cc_OctreeInfo(ctx, apply = defaultExec) {
        const {
          OctreeInfo,
          CCInteger,
          Vec3,
          DEFAULT_WORLD_MIN_POS,
          DEFAULT_WORLD_MAX_POS,
          DEFAULT_OCTREE_DEPTH
        } = {
          ...ctx
        };
        const enabledDescriptor = Object.getOwnPropertyDescriptor(OctreeInfo.prototype, 'enabled');
        const minPosDescriptor = Object.getOwnPropertyDescriptor(OctreeInfo.prototype, 'minPos');
        const maxPosDescriptor = Object.getOwnPropertyDescriptor(OctreeInfo.prototype, 'maxPos');
        const depthDescriptor = Object.getOwnPropertyDescriptor(OctreeInfo.prototype, 'depth');
        apply(() => {
          tooltip$1()(OctreeInfo.prototype, 'enabled', enabledDescriptor);
        }, 'tooltip', 'enabled');
        apply(() => {
          editable$5(OctreeInfo.prototype);
        }, 'editable', 'enabled');
        apply(() => {
          displayName$2()(OctreeInfo.prototype, 'minPos', minPosDescriptor);
        }, 'displayName', 'minPos');
        apply(() => {
          tooltip$1()(OctreeInfo.prototype, 'minPos', minPosDescriptor);
        }, 'tooltip', 'minPos');
        apply(() => {
          editable$5(OctreeInfo.prototype);
        }, 'editable', 'minPos');
        apply(() => {
          displayName$2()(OctreeInfo.prototype, 'maxPos', maxPosDescriptor);
        }, 'displayName', 'maxPos');
        apply(() => {
          tooltip$1()(OctreeInfo.prototype, 'maxPos', maxPosDescriptor);
        }, 'tooltip', 'maxPos');
        apply(() => {
          editable$5(OctreeInfo.prototype);
        }, 'editable', 'maxPos');
        apply(() => {
          tooltip$1()(OctreeInfo.prototype, 'depth', depthDescriptor);
        }, 'tooltip', 'depth');
        apply(() => {
          type$a(CCInteger)(OctreeInfo.prototype, 'depth', depthDescriptor);
        }, 'type', 'depth');
        apply(() => {
          slide(OctreeInfo.prototype);
        }, 'slide', 'depth');
        apply(() => {
          range()(OctreeInfo.prototype, 'depth', depthDescriptor);
        }, 'range', 'depth');
        apply(() => {
          editable$5(OctreeInfo.prototype);
        }, 'editable', 'depth');
        apply(() => {
          serializable$l(OctreeInfo.prototype, '_enabled', () => {
            return false;
          });
        }, 'serializable', '_enabled');
        apply(() => {
          serializable$l(OctreeInfo.prototype, '_minPos', () => {
            return new Vec3(DEFAULT_WORLD_MIN_POS);
          });
        }, 'serializable', '_minPos');
        apply(() => {
          serializable$l(OctreeInfo.prototype, '_maxPos', () => {
            return new Vec3(DEFAULT_WORLD_MAX_POS);
          });
        }, 'serializable', '_maxPos');
        apply(() => {
          serializable$l(OctreeInfo.prototype, '_depth', () => {
            return DEFAULT_OCTREE_DEPTH;
          });
        }, 'serializable', '_depth');
        apply(() => {
          ccclass$H('cc.OctreeInfo')(OctreeInfo);
        }, 'ccclass', null);
      }
      function patch_cc_PostSettingsInfo(ctx, apply = defaultExec) {
        const {
          PostSettingsInfo,
          ToneMappingType
        } = {
          ...ctx
        };
        const toneMappingTypeDescriptor = Object.getOwnPropertyDescriptor(PostSettingsInfo.prototype, 'toneMappingType');
        apply(() => {
          tooltip$1()(PostSettingsInfo.prototype, 'toneMappingType', toneMappingTypeDescriptor);
        }, 'tooltip', 'toneMappingType');
        apply(() => {
          type$a(ToneMappingType)(PostSettingsInfo.prototype, 'toneMappingType', toneMappingTypeDescriptor);
        }, 'type', 'toneMappingType');
        apply(() => {
          editable$5(PostSettingsInfo.prototype);
        }, 'editable', 'toneMappingType');
        apply(() => {
          serializable$l(PostSettingsInfo.prototype, '_toneMappingType', () => {
            return ToneMappingType.DEFAULT;
          });
        }, 'serializable', '_toneMappingType');
        apply(() => {
          ccclass$H('cc.PostSettingsInfo')(PostSettingsInfo);
        }, 'ccclass', null);
      }
      function patch_cc_RenderPipeline(ctx, apply = defaultExec) {
        const {
          RenderPipeline,
          RenderFlow
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(RenderPipeline.prototype, '_tag', () => {
            return 0;
          });
        }, 'serializable', '_tag');
        apply(() => {
          displayOrder$2()(RenderPipeline.prototype, '_tag', () => {
            return 0;
          });
        }, 'displayOrder', '_tag');
        apply(() => {
          serializable$l(RenderPipeline.prototype, '_flows', () => {
            return [];
          });
        }, 'serializable', '_flows');
        apply(() => {
          type$a([RenderFlow])(RenderPipeline.prototype, '_flows', () => {
            return [];
          });
        }, 'type', '_flows');
        apply(() => {
          displayOrder$2()(RenderPipeline.prototype, '_flows', () => {
            return [];
          });
        }, 'displayOrder', '_flows');
        apply(() => {
          ccclass$H('cc.RenderPipeline')(RenderPipeline);
        }, 'ccclass', null);
      }
      function patch_cc_RenderTexture(ctx, apply = defaultExec) {
        const {
          RenderTexture
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('cc.RenderTexture')(RenderTexture);
        }, 'ccclass', null);
      }
      function patch_cc_Scene(ctx, apply = defaultExec) {
        const {
          Scene,
          SceneGlobals
        } = {
          ...ctx
        };
        Object.getOwnPropertyDescriptor(Scene.prototype, 'globals');
        apply(() => {
          editable$5(Scene.prototype);
        }, 'editable', 'globals');
        apply(() => {
          editable$5(Scene.prototype);
        }, 'editable', 'autoReleaseAssets');
        apply(() => {
          serializable$l(Scene.prototype, 'autoReleaseAssets', () => {
            return false;
          });
        }, 'serializable', 'autoReleaseAssets');
        apply(() => {
          serializable$l(Scene.prototype, '_globals', () => {
            return new SceneGlobals();
          });
        }, 'serializable', '_globals');
        apply(() => {
          ccclass$H('cc.Scene')(Scene);
        }, 'ccclass', null);
      }
      function patch_cc_SceneAsset(ctx, apply = defaultExec) {
        const {
          SceneAsset
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(SceneAsset.prototype, 'scene', () => {
            return null;
          });
        }, 'serializable', 'scene');
        apply(() => {
          editable$5(SceneAsset.prototype);
        }, 'editable', 'scene');
        apply(() => {
          ccclass$H('cc.SceneAsset')(SceneAsset);
        }, 'ccclass', null);
      }
      function patch_cc_SceneGlobals(ctx, apply = defaultExec) {
        const {
          SceneGlobals,
          AmbientInfo,
          ShadowsInfo,
          SkyboxInfo,
          FogInfo,
          OctreeInfo,
          SkinInfo,
          LightProbeInfo,
          PostSettingsInfo
        } = {
          ...ctx
        };
        const skyboxDescriptor = Object.getOwnPropertyDescriptor(SceneGlobals.prototype, 'skybox');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'ambient');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'ambient', () => {
            return new AmbientInfo();
          });
        }, 'serializable', 'ambient');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'shadows');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'shadows', () => {
            return new ShadowsInfo();
          });
        }, 'serializable', 'shadows');
        apply(() => {
          serializable$l(SceneGlobals.prototype, '_skybox', () => {
            return new SkyboxInfo();
          });
        }, 'serializable', '_skybox');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'fog', () => {
            return new FogInfo();
          });
        }, 'serializable', 'fog');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'fog');
        apply(() => {
          type$a(SkyboxInfo)(SceneGlobals.prototype, 'skybox', skyboxDescriptor);
        }, 'type', 'skybox');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'skybox');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'octree', () => {
            return new OctreeInfo();
          });
        }, 'serializable', 'octree');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'octree');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'skin', () => {
            return new SkinInfo();
          });
        }, 'serializable', 'skin');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'skin');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'lightProbeInfo', () => {
            return new LightProbeInfo();
          });
        }, 'serializable', 'lightProbeInfo');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'lightProbeInfo');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'postSettings', () => {
            return new PostSettingsInfo();
          });
        }, 'serializable', 'postSettings');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'postSettings');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'bakedWithStationaryMainLight', () => {
            return false;
          });
        }, 'serializable', 'bakedWithStationaryMainLight');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'bakedWithStationaryMainLight');
        apply(() => {
          serializable$l(SceneGlobals.prototype, 'bakedWithHighpLightmap', () => {
            return false;
          });
        }, 'serializable', 'bakedWithHighpLightmap');
        apply(() => {
          editable$5(SceneGlobals.prototype);
        }, 'editable', 'bakedWithHighpLightmap');
        apply(() => {
          ccclass$H('cc.SceneGlobals')(SceneGlobals);
        }, 'ccclass', null);
      }
      function patch_cc_ShadowsInfo(ctx, apply = defaultExec) {
        const {
          ShadowsInfo,
          ShadowType,
          CCFloat,
          CCInteger,
          ShadowSize,
          Vec3,
          Color,
          Vec2
        } = {
          ...ctx
        };
        const enabledDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'enabled');
        const typeDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'type');
        const shadowColorDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'shadowColor');
        const planeDirectionDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'planeDirection');
        const planeHeightDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'planeHeight');
        const planeBiasDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'planeBias');
        const maxReceivedDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'maxReceived');
        const shadowMapSizeDescriptor = Object.getOwnPropertyDescriptor(ShadowsInfo.prototype, 'shadowMapSize');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'enabled', enabledDescriptor);
        }, 'tooltip', 'enabled');
        apply(() => {
          editable$5(ShadowsInfo.prototype);
        }, 'editable', 'enabled');
        apply(() => {
          type$a(ShadowType)(ShadowsInfo.prototype, 'type', typeDescriptor);
        }, 'type', 'type');
        apply(() => {
          editable$5(ShadowsInfo.prototype);
        }, 'editable', 'type');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'type', typeDescriptor);
        }, 'tooltip', 'type');
        apply(() => {
          visible$3()(ShadowsInfo.prototype, 'shadowColor', shadowColorDescriptor);
        }, 'visible', 'shadowColor');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'shadowColor', shadowColorDescriptor);
        }, 'tooltip', 'shadowColor');
        apply(() => {
          visible$3()(ShadowsInfo.prototype, 'planeDirection', planeDirectionDescriptor);
        }, 'visible', 'planeDirection');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'planeDirection', planeDirectionDescriptor);
        }, 'tooltip', 'planeDirection');
        apply(() => {
          visible$3()(ShadowsInfo.prototype, 'planeHeight', planeHeightDescriptor);
        }, 'visible', 'planeHeight');
        apply(() => {
          type$a(CCFloat)(ShadowsInfo.prototype, 'planeHeight', planeHeightDescriptor);
        }, 'type', 'planeHeight');
        apply(() => {
          editable$5(ShadowsInfo.prototype);
        }, 'editable', 'planeHeight');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'planeHeight', planeHeightDescriptor);
        }, 'tooltip', 'planeHeight');
        apply(() => {
          visible$3()(ShadowsInfo.prototype, 'planeBias', planeBiasDescriptor);
        }, 'visible', 'planeBias');
        apply(() => {
          type$a(CCFloat)(ShadowsInfo.prototype, 'planeBias', planeBiasDescriptor);
        }, 'type', 'planeBias');
        apply(() => {
          editable$5(ShadowsInfo.prototype);
        }, 'editable', 'planeBias');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'planeBias', planeBiasDescriptor);
        }, 'tooltip', 'planeBias');
        apply(() => {
          visible$3()(ShadowsInfo.prototype, 'maxReceived', maxReceivedDescriptor);
        }, 'visible', 'maxReceived');
        apply(() => {
          type$a(CCInteger)(ShadowsInfo.prototype, 'maxReceived', maxReceivedDescriptor);
        }, 'type', 'maxReceived');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'maxReceived', maxReceivedDescriptor);
        }, 'tooltip', 'maxReceived');
        apply(() => {
          visible$3()(ShadowsInfo.prototype, 'shadowMapSize', shadowMapSizeDescriptor);
        }, 'visible', 'shadowMapSize');
        apply(() => {
          type$a(ShadowSize)(ShadowsInfo.prototype, 'shadowMapSize', shadowMapSizeDescriptor);
        }, 'type', 'shadowMapSize');
        apply(() => {
          tooltip$1()(ShadowsInfo.prototype, 'shadowMapSize', shadowMapSizeDescriptor);
        }, 'tooltip', 'shadowMapSize');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_enabled', () => {
            return false;
          });
        }, 'serializable', '_enabled');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_type', () => {
            return ShadowType.Planar;
          });
        }, 'serializable', '_type');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_normal', () => {
            return new Vec3(0, 1, 0);
          });
        }, 'serializable', '_normal');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_distance', () => {
            return 0;
          });
        }, 'serializable', '_distance');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_planeBias', () => {
            return 1.0;
          });
        }, 'serializable', '_planeBias');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_shadowColor', () => {
            return new Color(0, 0, 0, 76);
          });
        }, 'serializable', '_shadowColor');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_maxReceived', () => {
            return 4;
          });
        }, 'serializable', '_maxReceived');
        apply(() => {
          serializable$l(ShadowsInfo.prototype, '_size', () => {
            return new Vec2(1024, 1024);
          });
        }, 'serializable', '_size');
        apply(() => {
          ccclass$H('cc.ShadowsInfo')(ShadowsInfo);
        }, 'ccclass', null);
      }
      function patch_cc_SimpleTexture(ctx, apply = defaultExec) {
        const {
          SimpleTexture
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('cc.SimpleTexture')(SimpleTexture);
        }, 'ccclass', null);
      }
      function patch_cc_Skeleton(ctx, apply = defaultExec) {
        const {
          Skeleton,
          CCString,
          Mat4
        } = {
          ...ctx
        };
        apply(() => {
          type$a([CCString])(Skeleton.prototype, '_joints', () => {
            return [];
          });
        }, 'type', '_joints');
        apply(() => {
          type$a([Mat4])(Skeleton.prototype, '_bindposes', () => {
            return [];
          });
        }, 'type', '_bindposes');
        apply(() => {
          serializable$l(Skeleton.prototype, '_hash', () => {
            return 0;
          });
        }, 'serializable', '_hash');
        apply(() => {
          ccclass$H('cc.Skeleton')(Skeleton);
        }, 'ccclass', null);
      }
      function patch_cc_SkinInfo(ctx, apply = defaultExec) {
        const {
          SkinInfo,
          CCFloat
        } = {
          ...ctx
        };
        const enabledDescriptor = Object.getOwnPropertyDescriptor(SkinInfo.prototype, 'enabled');
        const blurRadiusDescriptor = Object.getOwnPropertyDescriptor(SkinInfo.prototype, 'blurRadius');
        const sssIntensityDescriptor = Object.getOwnPropertyDescriptor(SkinInfo.prototype, 'sssIntensity');
        apply(() => {
          tooltip$1()(SkinInfo.prototype, 'enabled', enabledDescriptor);
        }, 'tooltip', 'enabled');
        apply(() => {
          readOnly(SkinInfo.prototype);
        }, 'readOnly', 'enabled');
        apply(() => {
          editable$5(SkinInfo.prototype);
        }, 'editable', 'enabled');
        apply(() => {
          tooltip$1()(SkinInfo.prototype, 'blurRadius', blurRadiusDescriptor);
        }, 'tooltip', 'blurRadius');
        apply(() => {
          type$a(CCFloat)(SkinInfo.prototype, 'blurRadius', blurRadiusDescriptor);
        }, 'type', 'blurRadius');
        apply(() => {
          slide(SkinInfo.prototype);
        }, 'slide', 'blurRadius');
        apply(() => {
          range()(SkinInfo.prototype, 'blurRadius', blurRadiusDescriptor);
        }, 'range', 'blurRadius');
        apply(() => {
          editable$5(SkinInfo.prototype);
        }, 'editable', 'blurRadius');
        apply(() => {
          visible$3()(SkinInfo.prototype, 'blurRadius', blurRadiusDescriptor);
        }, 'visible', 'blurRadius');
        apply(() => {
          tooltip$1()(SkinInfo.prototype, 'sssIntensity', sssIntensityDescriptor);
        }, 'tooltip', 'sssIntensity');
        apply(() => {
          type$a(CCFloat)(SkinInfo.prototype, 'sssIntensity', sssIntensityDescriptor);
        }, 'type', 'sssIntensity');
        apply(() => {
          slide(SkinInfo.prototype);
        }, 'slide', 'sssIntensity');
        apply(() => {
          range()(SkinInfo.prototype, 'sssIntensity', sssIntensityDescriptor);
        }, 'range', 'sssIntensity');
        apply(() => {
          editable$5(SkinInfo.prototype);
        }, 'editable', 'sssIntensity');
        apply(() => {
          serializable$l(SkinInfo.prototype, '_enabled', () => {
            return true;
          });
        }, 'serializable', '_enabled');
        apply(() => {
          serializable$l(SkinInfo.prototype, '_blurRadius', () => {
            return 0.01;
          });
        }, 'serializable', '_blurRadius');
        apply(() => {
          serializable$l(SkinInfo.prototype, '_sssIntensity', () => {
            return 3.0;
          });
        }, 'serializable', '_sssIntensity');
        apply(() => {
          ccclass$H('cc.SkinInfo')(SkinInfo);
        }, 'ccclass', null);
      }
      function patch_cc_SkyboxInfo(ctx, apply = defaultExec) {
        const {
          SkyboxInfo,
          EnvironmentLightingType,
          TextureCube,
          CCFloat,
          Material
        } = {
          ...ctx
        };
        const enabledDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'enabled');
        const envLightingTypeDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'envLightingType');
        const useHDRDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'useHDR');
        const envmapDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'envmap');
        const rotationAngleDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'rotationAngle');
        const diffuseMapDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'diffuseMap');
        const reflectionMapDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'reflectionMap');
        const skyboxMaterialDescriptor = Object.getOwnPropertyDescriptor(SkyboxInfo.prototype, 'skyboxMaterial');
        apply(() => {
          tooltip$1()(SkyboxInfo.prototype, 'enabled', enabledDescriptor);
        }, 'tooltip', 'enabled');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'enabled');
        apply(() => {
          tooltip$1()(SkyboxInfo.prototype, 'envLightingType', envLightingTypeDescriptor);
        }, 'tooltip', 'envLightingType');
        apply(() => {
          type$a(EnvironmentLightingType)(SkyboxInfo.prototype, 'envLightingType', envLightingTypeDescriptor);
        }, 'type', 'envLightingType');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'envLightingType');
        apply(() => {
          tooltip$1()(SkyboxInfo.prototype, 'useHDR', useHDRDescriptor);
        }, 'tooltip', 'useHDR');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'useHDR');
        apply(() => {
          tooltip$1()(SkyboxInfo.prototype, 'envmap', envmapDescriptor);
        }, 'tooltip', 'envmap');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, 'envmap', envmapDescriptor);
        }, 'type', 'envmap');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'envmap');
        apply(() => {
          tooltip$1()(SkyboxInfo.prototype, 'rotationAngle', rotationAngleDescriptor);
        }, 'tooltip', 'rotationAngle');
        apply(() => {
          slide(SkyboxInfo.prototype);
        }, 'slide', 'rotationAngle');
        apply(() => {
          range()(SkyboxInfo.prototype, 'rotationAngle', rotationAngleDescriptor);
        }, 'range', 'rotationAngle');
        apply(() => {
          type$a(CCFloat)(SkyboxInfo.prototype, 'rotationAngle', rotationAngleDescriptor);
        }, 'type', 'rotationAngle');
        apply(() => {
          displayOrder$2()(SkyboxInfo.prototype, 'diffuseMap', diffuseMapDescriptor);
        }, 'displayOrder', 'diffuseMap');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, 'diffuseMap', diffuseMapDescriptor);
        }, 'type', 'diffuseMap');
        apply(() => {
          readOnly(SkyboxInfo.prototype);
        }, 'readOnly', 'diffuseMap');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'diffuseMap');
        apply(() => {
          visible$3()(SkyboxInfo.prototype, 'diffuseMap', diffuseMapDescriptor);
        }, 'visible', 'diffuseMap');
        apply(() => {
          displayOrder$2()(SkyboxInfo.prototype, 'reflectionMap', reflectionMapDescriptor);
        }, 'displayOrder', 'reflectionMap');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, 'reflectionMap', reflectionMapDescriptor);
        }, 'type', 'reflectionMap');
        apply(() => {
          readOnly(SkyboxInfo.prototype);
        }, 'readOnly', 'reflectionMap');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'reflectionMap');
        apply(() => {
          visible$3()(SkyboxInfo.prototype, 'reflectionMap', reflectionMapDescriptor);
        }, 'visible', 'reflectionMap');
        apply(() => {
          tooltip$1()(SkyboxInfo.prototype, 'skyboxMaterial', skyboxMaterialDescriptor);
        }, 'tooltip', 'skyboxMaterial');
        apply(() => {
          type$a(Material)(SkyboxInfo.prototype, 'skyboxMaterial', skyboxMaterialDescriptor);
        }, 'type', 'skyboxMaterial');
        apply(() => {
          editable$5(SkyboxInfo.prototype);
        }, 'editable', 'skyboxMaterial');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_envLightingType', () => {
            return 0;
          });
        }, 'serializable', '_envLightingType');
        apply(() => {
          formerlySerializedAs$2('_envmap')(SkyboxInfo.prototype, '_envmapHDR', () => {
            return null;
          });
        }, 'formerlySerializedAs', '_envmapHDR');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, '_envmapHDR', () => {
            return null;
          });
        }, 'type', '_envmapHDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_envmapHDR', () => {
            return null;
          });
        }, 'serializable', '_envmapHDR');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, '_envmapLDR', () => {
            return null;
          });
        }, 'type', '_envmapLDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_envmapLDR', () => {
            return null;
          });
        }, 'serializable', '_envmapLDR');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, '_diffuseMapHDR', () => {
            return null;
          });
        }, 'type', '_diffuseMapHDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_diffuseMapHDR', () => {
            return null;
          });
        }, 'serializable', '_diffuseMapHDR');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, '_diffuseMapLDR', () => {
            return null;
          });
        }, 'type', '_diffuseMapLDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_diffuseMapLDR', () => {
            return null;
          });
        }, 'serializable', '_diffuseMapLDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_enabled', () => {
            return false;
          });
        }, 'serializable', '_enabled');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_useHDR', () => {
            return true;
          });
        }, 'serializable', '_useHDR');
        apply(() => {
          type$a(Material)(SkyboxInfo.prototype, '_editableMaterial', () => {
            return null;
          });
        }, 'type', '_editableMaterial');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_editableMaterial', () => {
            return null;
          });
        }, 'serializable', '_editableMaterial');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, '_reflectionHDR', () => {
            return null;
          });
        }, 'type', '_reflectionHDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_reflectionHDR', () => {
            return null;
          });
        }, 'serializable', '_reflectionHDR');
        apply(() => {
          type$a(TextureCube)(SkyboxInfo.prototype, '_reflectionLDR', () => {
            return null;
          });
        }, 'type', '_reflectionLDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_reflectionLDR', () => {
            return null;
          });
        }, 'serializable', '_reflectionLDR');
        apply(() => {
          serializable$l(SkyboxInfo.prototype, '_rotationAngle', () => {
            return 0;
          });
        }, 'serializable', '_rotationAngle');
        apply(() => {
          ccclass$H('cc.SkyboxInfo')(SkyboxInfo);
        }, 'ccclass', null);
      }
      function patch_cc_Tetrahedron(ctx, apply = defaultExec) {
        const {
          Tetrahedron,
          Mat3,
          Vec3,
          CircumSphere
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'invalid', () => {
            return false;
          });
        }, 'serializable', 'invalid');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'vertex0', () => {
            return -1;
          });
        }, 'serializable', 'vertex0');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'vertex1', () => {
            return -1;
          });
        }, 'serializable', 'vertex1');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'vertex2', () => {
            return -1;
          });
        }, 'serializable', 'vertex2');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'vertex3', () => {
            return -1;
          });
        }, 'serializable', 'vertex3');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'neighbours', () => {
            return [-1, -1, -1, -1];
          });
        }, 'serializable', 'neighbours');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'matrix', () => {
            return new Mat3();
          });
        }, 'serializable', 'matrix');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'offset', () => {
            return new Vec3(0.0, 0.0, 0.0);
          });
        }, 'serializable', 'offset');
        apply(() => {
          serializable$l(Tetrahedron.prototype, 'sphere', () => {
            return new CircumSphere();
          });
        }, 'serializable', 'sphere');
        apply(() => {
          ccclass$H('cc.Tetrahedron')(Tetrahedron);
        }, 'ccclass', null);
      }
      function patch_cc_Texture2D(ctx, apply = defaultExec) {
        const {
          Texture2D,
          ImageAsset
        } = {
          ...ctx
        };
        apply(() => {
          type$a([ImageAsset])(Texture2D.prototype, '_mipmaps', () => {
            return [];
          });
        }, 'type', '_mipmaps');
        apply(() => {
          ccclass$H('cc.Texture2D')(Texture2D);
        }, 'ccclass', null);
      }
      function patch_cc_TextureBase(ctx, apply = defaultExec) {
        const {
          TextureBase,
          PixelFormat,
          Filter,
          WrapMode
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(TextureBase.prototype, '_format', () => {
            return 35;
          });
        }, 'serializable', '_format');
        apply(() => {
          serializable$l(TextureBase.prototype, '_minFilter', () => {
            return 2;
          });
        }, 'serializable', '_minFilter');
        apply(() => {
          serializable$l(TextureBase.prototype, '_magFilter', () => {
            return 2;
          });
        }, 'serializable', '_magFilter');
        apply(() => {
          serializable$l(TextureBase.prototype, '_mipFilter', () => {
            return 0;
          });
        }, 'serializable', '_mipFilter');
        apply(() => {
          serializable$l(TextureBase.prototype, '_wrapS', () => {
            return 0;
          });
        }, 'serializable', '_wrapS');
        apply(() => {
          serializable$l(TextureBase.prototype, '_wrapT', () => {
            return 0;
          });
        }, 'serializable', '_wrapT');
        apply(() => {
          serializable$l(TextureBase.prototype, '_wrapR', () => {
            return 0;
          });
        }, 'serializable', '_wrapR');
        apply(() => {
          serializable$l(TextureBase.prototype, '_anisotropy', () => {
            return 0;
          });
        }, 'serializable', '_anisotropy');
        apply(() => {
          ccclass$H('cc.TextureBase')(TextureBase);
        }, 'ccclass', null);
      }
      function patch_cc_TextureCube(ctx, apply = defaultExec) {
        const {
          TextureCube,
          MipmapMode
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(TextureCube.prototype, 'isRGBE', () => {
            return false;
          });
        }, 'serializable', 'isRGBE');
        apply(() => {
          serializable$l(TextureCube.prototype, '_mipmapAtlas', () => {
            return null;
          });
        }, 'serializable', '_mipmapAtlas');
        apply(() => {
          serializable$l(TextureCube.prototype, '_mipmapMode', () => {
            return 0;
          });
        }, 'serializable', '_mipmapMode');
        apply(() => {
          serializable$l(TextureCube.prototype, '_mipmaps', () => {
            return [];
          });
        }, 'serializable', '_mipmaps');
        apply(() => {
          ccclass$H('cc.TextureCube')(TextureCube);
        }, 'ccclass', null);
      }
      function patch_cc_Vertex(ctx, apply = defaultExec) {
        const {
          Vertex,
          Vec3
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(Vertex.prototype, 'position', () => {
            return new Vec3(0, 0, 0);
          });
        }, 'serializable', 'position');
        apply(() => {
          serializable$l(Vertex.prototype, 'normal', () => {
            return new Vec3(0, 0, 0);
          });
        }, 'serializable', 'normal');
        apply(() => {
          serializable$l(Vertex.prototype, 'coefficients', () => {
            return [];
          });
        }, 'serializable', 'coefficients');
        apply(() => {
          ccclass$H('cc.Vertex')(Vertex);
        }, 'ccclass', null);
      }
      function patch_DeferredPipeline(ctx, apply = defaultExec) {
        const {
          DeferredPipeline,
          RenderTextureConfig
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(DeferredPipeline.prototype, 'renderTextures', () => {
            return [];
          });
        }, 'displayOrder', 'renderTextures');
        apply(() => {
          serializable$l(DeferredPipeline.prototype, 'renderTextures', () => {
            return [];
          });
        }, 'serializable', 'renderTextures');
        apply(() => {
          type$a([RenderTextureConfig])(DeferredPipeline.prototype, 'renderTextures', () => {
            return [];
          });
        }, 'type', 'renderTextures');
        apply(() => {
          ccclass$H('DeferredPipeline')(DeferredPipeline);
        }, 'ccclass', null);
      }
      function patch_ForwardFlow(ctx, apply = defaultExec) {
        const {
          ForwardFlow
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('ForwardFlow')(ForwardFlow);
        }, 'ccclass', null);
      }
      function patch_ForwardPipeline(ctx, apply = defaultExec) {
        const {
          ForwardPipeline,
          RenderTextureConfig
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(ForwardPipeline.prototype, 'renderTextures', () => {
            return [];
          });
        }, 'displayOrder', 'renderTextures');
        apply(() => {
          serializable$l(ForwardPipeline.prototype, 'renderTextures', () => {
            return [];
          });
        }, 'serializable', 'renderTextures');
        apply(() => {
          type$a([RenderTextureConfig])(ForwardPipeline.prototype, 'renderTextures', () => {
            return [];
          });
        }, 'type', 'renderTextures');
        apply(() => {
          ccclass$H('ForwardPipeline')(ForwardPipeline);
        }, 'ccclass', null);
      }
      function patch_ForwardStage(ctx, apply = defaultExec) {
        const {
          ForwardStage,
          RenderQueueDesc
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(ForwardStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'displayOrder', 'renderQueues');
        apply(() => {
          serializable$l(ForwardStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'serializable', 'renderQueues');
        apply(() => {
          type$a([RenderQueueDesc])(ForwardStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'type', 'renderQueues');
        apply(() => {
          ccclass$H('ForwardStage')(ForwardStage);
        }, 'ccclass', null);
      }
      function patch_GbufferStage(ctx, apply = defaultExec) {
        const {
          GbufferStage,
          RenderQueueDesc
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(GbufferStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'displayOrder', 'renderQueues');
        apply(() => {
          serializable$l(GbufferStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'serializable', 'renderQueues');
        apply(() => {
          type$a([RenderQueueDesc])(GbufferStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'type', 'renderQueues');
        apply(() => {
          ccclass$H('GbufferStage')(GbufferStage);
        }, 'ccclass', null);
      }
      function patch_LightingStage(ctx, apply = defaultExec) {
        const {
          LightingStage,
          Material,
          RenderQueueDesc
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(LightingStage.prototype, '_deferredMaterial', () => {
            return null;
          });
        }, 'displayOrder', '_deferredMaterial');
        apply(() => {
          serializable$l(LightingStage.prototype, '_deferredMaterial', () => {
            return null;
          });
        }, 'serializable', '_deferredMaterial');
        apply(() => {
          type$a(Material)(LightingStage.prototype, '_deferredMaterial', () => {
            return null;
          });
        }, 'type', '_deferredMaterial');
        apply(() => {
          displayOrder$2()(LightingStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'displayOrder', 'renderQueues');
        apply(() => {
          serializable$l(LightingStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'serializable', 'renderQueues');
        apply(() => {
          type$a([RenderQueueDesc])(LightingStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'type', 'renderQueues');
        apply(() => {
          ccclass$H('LightingStage')(LightingStage);
        }, 'ccclass', null);
      }
      function patch_MainFlow(ctx, apply = defaultExec) {
        const {
          MainFlow
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('MainFlow')(MainFlow);
        }, 'ccclass', null);
      }
      function patch_PostProcessStage(ctx, apply = defaultExec) {
        const {
          PostProcessStage,
          Material,
          RenderQueueDesc
        } = {
          ...ctx
        };
        apply(() => {
          displayOrder$2()(PostProcessStage.prototype, '_postProcessMaterial', () => {
            return null;
          });
        }, 'displayOrder', '_postProcessMaterial');
        apply(() => {
          serializable$l(PostProcessStage.prototype, '_postProcessMaterial', () => {
            return null;
          });
        }, 'serializable', '_postProcessMaterial');
        apply(() => {
          type$a(Material)(PostProcessStage.prototype, '_postProcessMaterial', () => {
            return null;
          });
        }, 'type', '_postProcessMaterial');
        apply(() => {
          displayOrder$2()(PostProcessStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'displayOrder', 'renderQueues');
        apply(() => {
          serializable$l(PostProcessStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'serializable', 'renderQueues');
        apply(() => {
          type$a([RenderQueueDesc])(PostProcessStage.prototype, 'renderQueues', () => {
            return [];
          });
        }, 'type', 'renderQueues');
        apply(() => {
          ccclass$H('PostProcessStage')(PostProcessStage);
        }, 'ccclass', null);
      }
      function patch_ReflectionProbeFlow(ctx, apply = defaultExec) {
        const {
          ReflectionProbeFlow
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('ReflectionProbeFlow')(ReflectionProbeFlow);
        }, 'ccclass', null);
      }
      function patch_ReflectionProbeStage(ctx, apply = defaultExec) {
        const {
          ReflectionProbeStage
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('ReflectionProbeStage')(ReflectionProbeStage);
        }, 'ccclass', null);
      }
      function patch_RenderFlow(ctx, apply = defaultExec) {
        const {
          RenderFlow,
          RenderStage
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(RenderFlow.prototype, '_name', () => {
            return '';
          });
        }, 'serializable', '_name');
        apply(() => {
          displayOrder$2()(RenderFlow.prototype, '_name', () => {
            return '';
          });
        }, 'displayOrder', '_name');
        apply(() => {
          serializable$l(RenderFlow.prototype, '_priority', () => {
            return 0;
          });
        }, 'serializable', '_priority');
        apply(() => {
          displayOrder$2()(RenderFlow.prototype, '_priority', () => {
            return 0;
          });
        }, 'displayOrder', '_priority');
        apply(() => {
          serializable$l(RenderFlow.prototype, '_tag', () => {
            return 0;
          });
        }, 'serializable', '_tag');
        apply(() => {
          displayOrder$2()(RenderFlow.prototype, '_tag', () => {
            return 0;
          });
        }, 'displayOrder', '_tag');
        apply(() => {
          serializable$l(RenderFlow.prototype, '_stages', () => {
            return [];
          });
        }, 'serializable', '_stages');
        apply(() => {
          type$a([RenderStage])(RenderFlow.prototype, '_stages', () => {
            return [];
          });
        }, 'type', '_stages');
        apply(() => {
          displayOrder$2()(RenderFlow.prototype, '_stages', () => {
            return [];
          });
        }, 'displayOrder', '_stages');
        apply(() => {
          ccclass$H('RenderFlow')(RenderFlow);
        }, 'ccclass', null);
      }
      function patch_RenderQueueDesc(ctx, apply = defaultExec) {
        const {
          RenderQueueDesc,
          RenderQueueSortMode,
          CCString
        } = {
          ...ctx
        };
        apply(() => {
          editable$5(RenderQueueDesc.prototype);
        }, 'editable', 'isTransparent');
        apply(() => {
          serializable$l(RenderQueueDesc.prototype, 'isTransparent', () => {
            return false;
          });
        }, 'serializable', 'isTransparent');
        apply(() => {
          type$a(RenderQueueSortMode)(RenderQueueDesc.prototype, 'sortMode', () => {
            return 0;
          });
        }, 'type', 'sortMode');
        apply(() => {
          type$a([CCString])(RenderQueueDesc.prototype, 'stages', () => {
            return [];
          });
        }, 'type', 'stages');
        apply(() => {
          ccclass$H('RenderQueueDesc')(RenderQueueDesc);
        }, 'ccclass', null);
      }
      function patch_RenderStage(ctx, apply = defaultExec) {
        const {
          RenderStage
        } = {
          ...ctx
        };
        apply(() => {
          serializable$l(RenderStage.prototype, '_name', () => {
            return '';
          });
        }, 'serializable', '_name');
        apply(() => {
          displayOrder$2()(RenderStage.prototype, '_name', () => {
            return '';
          });
        }, 'displayOrder', '_name');
        apply(() => {
          serializable$l(RenderStage.prototype, '_priority', () => {
            return 0;
          });
        }, 'serializable', '_priority');
        apply(() => {
          displayOrder$2()(RenderStage.prototype, '_priority', () => {
            return 0;
          });
        }, 'displayOrder', '_priority');
        apply(() => {
          serializable$l(RenderStage.prototype, '_tag', () => {
            return 0;
          });
        }, 'serializable', '_tag');
        apply(() => {
          displayOrder$2()(RenderStage.prototype, '_tag', () => {
            return 0;
          });
        }, 'displayOrder', '_tag');
        apply(() => {
          ccclass$H('RenderStage')(RenderStage);
        }, 'ccclass', null);
      }
      function patch_ShadowFlow(ctx, apply = defaultExec) {
        const {
          ShadowFlow
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('ShadowFlow')(ShadowFlow);
        }, 'ccclass', null);
      }
      function patch_ShadowStage(ctx, apply = defaultExec) {
        const {
          ShadowStage
        } = {
          ...ctx
        };
        apply(() => {
          ccclass$H('ShadowStage')(ShadowStage);
        }, 'ccclass', null);
      }

      applyMixins(jsb.Asset, [CallbacksInvoker, ExtraEventMethods]);
      const assetProto = jsb.Asset.prototype;
      assetProto._ctor = function () {
        this.loaded = true;
        this._ref = 0;
        this.__nativeRefs = {};
        this.__jsb_ref_id = undefined;
        this._iN$t = null;
        this.__editorExtras__ = {
          editorOnly: true
        };
        this._callbackTable = createMap(true);
        this._file = null;
      };
      Object.defineProperty(assetProto, '_nativeAsset', {
        get() {
          return this._file;
        },
        set(obj) {
          this._file = obj;
        }
      });
      Object.defineProperty(assetProto, 'nativeUrl', {
        get() {
          if (!this._nativeUrl) {
            if (!this._native) return '';
            const name = this._native;
            if (name.charCodeAt(0) === 47) {
              return name.slice(1);
            }
            if (name.charCodeAt(0) === 46) {
              this._nativeUrl = getUrlWithUuid(this._uuid, {
                nativeExt: name,
                isNative: true
              });
            } else {
              this._nativeUrl = getUrlWithUuid(this._uuid, {
                __nativeName__: name,
                nativeExt: extname(name),
                isNative: true
              });
            }
          }
          return this._nativeUrl;
        }
      });
      Object.defineProperty(assetProto, 'refCount', {
        configurable: true,
        enumerable: true,
        get() {
          return this._ref;
        }
      });
      assetProto.addRef = function () {
        this._ref++;
        this.addAssetRef();
        return this;
      };
      assetProto.decRef = function (autoRelease = true) {
        this.decAssetRef();
        if (this._ref > 0) {
          this._ref--;
        }
        if (autoRelease) {
          cclegacy.assetManager.getReleaseManager().tryRelease(this);
        }
        return this;
      };
      assetProto.toString = function () {
        return this.nativeUrl;
      };
      assetProto.createNode = null;
      const Asset = exports("Asset", jsb.Asset);
      cclegacy.Asset = jsb.Asset;
      patch_cc_Asset({
        Asset
      });

      const ImageAsset$1 = exports("ImageAsset", jsb.ImageAsset);
      const jsbWindow$1 = jsb.window;
      const extnames = ['.png', '.jpg', '.jpeg', '.bmp', '.webp', '.pvr', '.pkm', '.astc'];
      function isImageBitmap(imageSource) {
        return !!(sys.hasFeature(sys.Feature.IMAGE_BITMAP) && imageSource instanceof ImageBitmap);
      }
      function isNativeImage(imageSource) {
        if (imageSource._compressed === true) {
          return false;
        }
        return imageSource instanceof jsbWindow$1.HTMLImageElement || imageSource instanceof jsbWindow$1.HTMLCanvasElement || isImageBitmap(imageSource);
      }
      const imageAssetProto = ImageAsset$1.prototype;
      imageAssetProto._ctor = function (nativeAsset) {
        jsb.Asset.prototype._ctor.apply(this, arguments);
        this._width = 0;
        this._height = 0;
        this._nativeData = {
          _data: null,
          width: 0,
          height: 0,
          format: 0,
          _compressed: false,
          mipmapLevelDataSize: []
        };
        if (nativeAsset !== undefined) {
          this.reset(nativeAsset);
        }
      };
      Object.defineProperty(imageAssetProto, '_nativeAsset', {
        configurable: true,
        enumerable: true,
        get() {
          return this._nativeData;
        },
        set(value) {
          if (!(value instanceof jsbWindow$1.HTMLElement) && !isImageBitmap(value)) {
            value.format = value.format || this.format;
          }
          this.reset(value);
        }
      });
      Object.defineProperty(imageAssetProto, 'data', {
        configurable: true,
        enumerable: true,
        get() {
          if (this._nativeData && isNativeImage(this._nativeData)) {
            return this._nativeData;
          }
          return this._nativeData && this._nativeData._data;
        }
      });
      imageAssetProto._setRawAsset = function (filename, inLibrary = true) {
        if (inLibrary !== false) {
          this._native = filename || '';
        } else {
          this._native = `/${filename}`;
        }
      };
      imageAssetProto.reset = function (data) {
        this._nativeData = data;
        if (!(data instanceof jsbWindow$1.HTMLElement)) {
          if (data.format !== undefined) {
            this.format = data.format;
          }
        }
        this._syncDataToNative();
      };
      const superDestroy = jsb.Asset.prototype.destroy;
      imageAssetProto.destroy = function () {
        if (this.data && this.data instanceof jsbWindow$1.HTMLImageElement) {
          this.data.src = '';
          this._setRawAsset('');
          this.data.destroy();
        } else if (isImageBitmap(this.data)) {
          this.data.close && this.data.close();
        }
        return superDestroy.call(this);
      };
      Object.defineProperty(imageAssetProto, 'width', {
        configurable: true,
        enumerable: true,
        get() {
          return this._nativeData.width || this._width;
        }
      });
      Object.defineProperty(imageAssetProto, 'height', {
        configurable: true,
        enumerable: true,
        get() {
          return this._nativeData.height || this._height;
        }
      });
      imageAssetProto._syncDataToNative = function () {
        const data = this._nativeData;
        this._width = data.width;
        this._height = data.height;
        this.setWidth(this._width);
        this.setHeight(this._height);
        this.url = this.nativeUrl;
        if (data instanceof jsbWindow$1.HTMLCanvasElement) {
          this.setData(data._data.data);
        } else if (data instanceof jsbWindow$1.HTMLImageElement) {
          this.setData(data._data);
          if (data._mipmapLevelDataSize) {
            this.setMipmapLevelDataSize(data._mipmapLevelDataSize);
          }
        } else {
          if (!this._nativeData._data) {
            console.error(`[ImageAsset] setData bad argument ${this._nativeData}`);
            return;
          }
          this.setData(this._nativeData._data);
          if (this._nativeData.mipmapLevelDataSize) {
            this.setMipmapLevelDataSize(this._nativeData.mipmapLevelDataSize);
          }
        }
      };
      imageAssetProto._serialize = function () {
      };
      imageAssetProto._deserialize = function (data) {
        let fmtStr = '';
        if (typeof data === 'string') {
          fmtStr = data;
        } else {
          this._width = data.w;
          this._height = data.h;
          fmtStr = data.fmt;
        }
        const device = deviceManager.gfxDevice;
        const extensionIDs = fmtStr.split('_');
        let preferedExtensionIndex = Number.MAX_VALUE;
        let format = this.format;
        let ext = '';
        const SupportTextureFormats = macro.SUPPORT_TEXTURE_FORMATS;
        for (const extensionID of extensionIDs) {
          const extFormat = extensionID.split('@');
          const i = parseInt(extFormat[0], undefined);
          const tmpExt = extnames[i] || extFormat[0];
          const index = SupportTextureFormats.indexOf(tmpExt);
          if (index !== -1 && index < preferedExtensionIndex) {
            const fmt = extFormat[1] ? parseInt(extFormat[1]) : this.format;
            if (tmpExt === '.astc' && (!device || !(device.getFormatFeatures(89) & 2))) {
              continue;
            } else if (tmpExt === '.pvr' && (!device || !(device.getFormatFeatures(86) & 2))) {
              continue;
            } else if ((fmt === 72 || fmt === 1026) && (!device || !(device.getFormatFeatures(72) & 2))) {
              continue;
            } else if ((fmt === 73 || fmt === 77) && (!device || !(device.getFormatFeatures(73) & 2))) {
              continue;
            } else if (tmpExt === '.webp' && !sys.hasFeature(sys.Feature.WEBP)) {
              continue;
            }
            preferedExtensionIndex = index;
            ext = tmpExt;
            format = fmt;
          }
        }
        if (ext) {
          this._setRawAsset(ext);
          this.format = format;
        } else {
          warnID(3121);
        }
      };
      cclegacy.ImageAsset = jsb.ImageAsset;
      patch_cc_ImageAsset({
        ImageAsset: ImageAsset$1
      });

      const PixelFormat = {
        "RGB565": 47,
        "RGB5A1": 49,
        "RGBA4444": 50,
        "RGB888": 24,
        "RGB32F": 32,
        "RGBA8888": 35,
        "BGRA8888": 36,
        "RGBA32F": 44,
        "A8": 1,
        "I8": 2,
        "AI8": 3,
        "RGB_PVRTC_2BPPV1": 83,
        "RGBA_PVRTC_2BPPV1": 84,
        "RGB_A_PVRTC_2BPPV1": 1024,
        "RGB_PVRTC_4BPPV1": 85,
        "RGBA_PVRTC_4BPPV1": 86,
        "RGB_A_PVRTC_4BPPV1": 1025,
        "RGB_ETC1": 72,
        "RGBA_ETC1": 1026,
        "RGB_ETC2": 73,
        "RGBA_ETC2": 77,
        "RGBA_ASTC_4x4": 89,
        "RGBA_ASTC_5x4": 90,
        "RGBA_ASTC_5x5": 91,
        "RGBA_ASTC_6x5": 92,
        "RGBA_ASTC_6x6": 93,
        "RGBA_ASTC_8x5": 94,
        "RGBA_ASTC_8x6": 95,
        "RGBA_ASTC_8x8": 96,
        "RGBA_ASTC_10x5": 97,
        "RGBA_ASTC_10x6": 98,
        "RGBA_ASTC_10x8": 99,
        "RGBA_ASTC_10x10": 100,
        "RGBA_ASTC_12x10": 101,
        "RGBA_ASTC_12x12": 102
      };
      const WrapMode$1 = {
        "REPEAT": 0,
        "CLAMP_TO_EDGE": 2,
        "MIRRORED_REPEAT": 1,
        "CLAMP_TO_BORDER": 3
      };
      const TextureFilter = {
        "NONE": 0,
        "LINEAR": 2,
        "NEAREST": 1
      };

      var _dec$2n, _class$2n, _dec2$1B, _class2$1$, _dec3$17, _class3$E;
      let Script = exports("Script", (_dec$2n = ccclass$H('cc.Script'), _dec$2n(_class$2n = class Script extends Asset {}) || _class$2n));
      cclegacy._Script = Script;
      let JavaScript = exports("JavaScript", (_dec2$1B = ccclass$H('cc.JavaScript'), _dec2$1B(_class2$1$ = class JavaScript extends Script {}) || _class2$1$));
      cclegacy._JavaScript = JavaScript;
      let TypeScript = exports("TypeScript", (_dec3$17 = ccclass$H('cc.TypeScript'), _dec3$17(_class3$E = class TypeScript extends Script {}) || _class3$E));
      cclegacy._TypeScript = TypeScript;

      var _dec$2m, _class$2m, _class2$1_, _initializer$1S, _initializer2$1p, _initializer3$11, _initializer4$U, _initializer5$G;
      let EventHandler = exports("EventHandler", (_dec$2m = ccclass$H('cc.ClickEvent'), _dec$2m(_class$2m = (_class2$1_ = class EventHandler {
        constructor() {
          this.target = _initializer$1S && _initializer$1S();
          this.component = _initializer2$1p && _initializer2$1p();
          this._componentId = _initializer3$11 && _initializer3$11();
          this.handler = _initializer4$U && _initializer4$U();
          this.customEventData = _initializer5$G && _initializer5$G();
        }
        get _componentName() {
          this._genCompIdIfNeeded();
          return this._compId2Name(this._componentId);
        }
        set _componentName(value) {
          this._componentId = this._compName2Id(value);
        }
        static emitEvents(events, ...args) {
          for (let i = 0, l = events.length; i < l; i++) {
            const event = events[i];
            if (!(event instanceof EventHandler)) {
              continue;
            }
            event.emit(args);
          }
        }
        emit(params) {
          const target = this.target;
          if (!legacyCC.isValid(target)) {
            return;
          }
          this._genCompIdIfNeeded();
          const compType = legacyCC.js.getClassById(this._componentId);
          const comp = target.getComponent(compType);
          if (!legacyCC.isValid(comp)) {
            return;
          }
          const handler = comp[this.handler];
          if (typeof handler !== 'function') {
            return;
          }
          if (this.customEventData != null && this.customEventData !== '') {
            params = params.slice();
            params.push(this.customEventData);
          }
          handler.apply(comp, params);
        }
        _compName2Id(compName) {
          const comp = legacyCC.js.getClassByName(compName);
          return legacyCC.js.getClassId(comp);
        }
        _compId2Name(compId) {
          const comp = legacyCC.js.getClassById(compId);
          return legacyCC.js.getClassName(comp);
        }
        _genCompIdIfNeeded() {
          if (!this._componentId) {
            this._componentName = this.component;
            this.component = '';
          }
        }
      }, (_initializer$1S = applyDecoratedInitializer(_class2$1_.prototype, "target", [serializable$l], function () {
        return null;
      }), _initializer2$1p = applyDecoratedInitializer(_class2$1_.prototype, "component", [serializable$l], function () {
        return '';
      }), _initializer3$11 = applyDecoratedInitializer(_class2$1_.prototype, "_componentId", [serializable$l], function () {
        return '';
      }), _initializer4$U = applyDecoratedInitializer(_class2$1_.prototype, "handler", [serializable$l], function () {
        return '';
      }), _initializer5$G = applyDecoratedInitializer(_class2$1_.prototype, "customEventData", [serializable$l], function () {
        return '';
      })), _class2$1_)) || _class$2m));

      var _dec$2l, _dec2$1A, _class$2l, _class2$1Z, _initializer$1R, _initializer2$1o, _initializer3$10, _class3$D;
      const idGenerator = new IDGenerator('Comp');
      const IsOnLoadCalled$1 = CCObject.Flags.IsOnLoadCalled;
      const NullNode = null;
      let Component = exports("Component", (_dec$2l = ccclass$H('cc.Component'), _dec2$1A = type$a(Script), _dec$2l(_class$2l = (_class2$1Z = (_class3$D = class Component extends CCObject {
        constructor() {
          super();
          this.node = _initializer$1R && _initializer$1R();
          this._enabled = _initializer2$1o && _initializer2$1o();
          this.__prefab = _initializer3$10 && _initializer3$10();
          this._sceneGetter = null;
          this._id = idGenerator.getNewId();
        }
        get name() {
          if (this._name) {
            return this._name;
          }
          let className = getClassName(this);
          const trimLeft = className.lastIndexOf('.');
          if (trimLeft >= 0) {
            className = className.slice(trimLeft + 1);
          }
          if (this.node) {
            return `${this.node.name}<${className}>`;
          } else {
            return className;
          }
        }
        set name(value) {
          this._name = value;
        }
        get uuid() {
          return this._id;
        }
        get __scriptAsset() {
          return null;
        }
        get enabled() {
          return this._enabled;
        }
        set enabled(value) {
          if (this._enabled !== value) {
            this._enabled = value;
            if (this.node.activeInHierarchy) {
              const compScheduler = legacyCC.director._compScheduler;
              if (value) {
                compScheduler.enableComp(this);
              } else {
                compScheduler.disableComp(this);
              }
            }
          }
        }
        get enabledInHierarchy() {
          return this._enabled && this.node && this.node.activeInHierarchy;
        }
        get _isOnLoadCalled() {
          return this._objFlags & IsOnLoadCalled$1;
        }
        _getRenderScene() {
          if (this._sceneGetter) {
            return this._sceneGetter();
          }
          return this.node.scene.renderScene;
        }
        addComponent(typeOrClassName) {
          return this.node.addComponent(typeOrClassName);
        }
        getComponent(typeOrClassName) {
          return this.node.getComponent(typeOrClassName);
        }
        getComponents(typeOrClassName) {
          return this.node.getComponents(typeOrClassName);
        }
        getComponentInChildren(typeOrClassName) {
          return this.node.getComponentInChildren(typeOrClassName);
        }
        getComponentsInChildren(typeOrClassName) {
          return this.node.getComponentsInChildren(typeOrClassName);
        }
        destroy() {
          if (super.destroy()) {
            if (this._enabled && this.node.activeInHierarchy) {
              legacyCC.director._compScheduler.disableComp(this);
            }
            return true;
          }
          return false;
        }
        _onPreDestroy() {
          this.unscheduleAllCallbacks();
          legacyCC.director._nodeActivator.destroyComp(this);
          this.node._removeComponent(this);
        }
        _instantiate(cloned) {
          if (!cloned) {
            cloned = legacyCC.instantiate._clone(this, this);
          }
          if (cloned) {
            cloned.node = NullNode;
          }
          return cloned;
        }
        schedule(callback, interval = 0, repeat = legacyCC.macro.REPEAT_FOREVER, delay = 0) {
          assertID(Boolean(callback), 1619);
          interval = interval || 0;
          assertID(interval >= 0, 1620);
          repeat = Number.isNaN(repeat) ? legacyCC.macro.REPEAT_FOREVER : repeat;
          delay = delay || 0;
          const scheduler = legacyCC.director.getScheduler();
          const paused = scheduler.isTargetPaused(this);
          scheduler.schedule(callback, this, interval, repeat, delay, paused);
        }
        scheduleOnce(callback, delay = 0) {
          this.schedule(callback, 0, 0, delay);
        }
        unschedule(callback_fn) {
          if (!callback_fn) {
            return;
          }
          legacyCC.director.getScheduler().unschedule(callback_fn, this);
        }
        unscheduleAllCallbacks() {
          legacyCC.director.getScheduler().unscheduleAllForTarget(this);
        }
        get internalUpdate() {
          return this.update;
        }
        get internalLateUpdate() {
          return this.lateUpdate;
        }
        get internalPreload() {
          return this.__preload;
        }
        get internalOnLoad() {
          return this.onLoad;
        }
        get internalStart() {
          return this.start;
        }
        get internalOnEnable() {
          return this.onEnable;
        }
        get internalOnDisable() {
          return this.onDisable;
        }
        get internalOnDestroy() {
          return this.onDestroy;
        }
      }, _class3$D.EventHandler = EventHandler, _class3$D._executionOrder = 0, _class3$D._requireComponent = null, _class3$D.system = null, _class3$D), (_applyDecoratedDescriptor(_class2$1Z.prototype, "__scriptAsset", [_dec2$1A], Object.getOwnPropertyDescriptor(_class2$1Z.prototype, "__scriptAsset"), _class2$1Z.prototype), _initializer$1R = applyDecoratedInitializer(_class2$1Z.prototype, "node", [serializable$l], function () {
        return NullNode;
      }), _initializer2$1o = applyDecoratedInitializer(_class2$1Z.prototype, "_enabled", [serializable$l], function () {
        return true;
      }), _initializer3$10 = applyDecoratedInitializer(_class2$1Z.prototype, "__prefab", [serializable$l], function () {
        return null;
      })), _class2$1Z)) || _class$2l));
      value(Component, '_registerEditorProps', (cls, props) => {
        let reqComp = props.requireComponent;
        if (reqComp) {
          if (Array.isArray(reqComp)) {
            reqComp = reqComp.filter(Boolean);
          }
          cls._requireComponent = reqComp;
        }
        const order = props.executionOrder;
        if (order && typeof order === 'number') {
          cls._executionOrder = order;
        }
      });
      legacyCC.Component = Component;

      var _dec$2k, _class$2k, _class2$1Y, _initializer$1Q;
      let MissingScript = exports("MissingScript", (_dec$2k = ccclass$H('cc.MissingScript'), _dec$2k(_class$2k = (_class2$1Y = class MissingScript extends Component {
        static safeFindClass(id) {
          const cls = getClassById(id);
          if (cls) {
            return cls;
          }
          cclegacy.deserialize.reportMissingClass(id);
          return undefined;
        }
        constructor() {
          super();
          this._$erialized = _initializer$1Q && _initializer$1Q();
        }
        onLoad() {
          warnID(4600, this.node.name);
        }
      }, (_initializer$1Q = applyDecoratedInitializer(_class2$1Y.prototype, "_$erialized", [serializable$l, editorOnly], function () {
        return null;
      })), _class2$1Y)) || _class$2k));
      cclegacy._MissingScript = MissingScript;
      try {
        const props = MissingScript.__values__;
        if (props.length === 0 || props[props.length - 1] !== '_$erialized') {
          errorID(16338);
          errorID(16339, props.join(', '));
        }
      } catch (e) {
        errorID(16340, `${e}`);
      }

      const VERSION = 1;
      const MAGIC = 0x4E4F4343;
      const CHUNK_ALIGN_AS = 8;
      class CCON {
        constructor(document, chunks) {
          this._document = document;
          this._chunks = chunks;
        }
        get document() {
          return this._document;
        }
        get chunks() {
          return this._chunks;
        }
      }
      function parseCCONJson(json) {
        const cconPreface = json;
        return {
          chunks: cconPreface.chunks,
          document: cconPreface.document
        };
      }
      function decodeCCONBinary(bytes) {
        if (bytes.length < 16) {
          throw new InvalidCCONError(getError(13102));
        }
        const dataView = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);
        const magic = dataView.getUint32(0, true);
        if (magic !== MAGIC) {
          throw new InvalidCCONError(getError(13100));
        }
        const version = dataView.getUint32(4, true);
        if (version !== VERSION) {
          throw new InvalidCCONError(getError(13101, version));
        }
        const dataByteLength = dataView.getUint32(8, true);
        if (dataByteLength !== dataView.byteLength) {
          throw new InvalidCCONError(getError(13102));
        }
        let chunksStart = 12;
        const jsonDataLength = dataView.getUint32(chunksStart, true);
        chunksStart += 4;
        const jsonData = new Uint8Array(dataView.buffer, chunksStart + dataView.byteOffset, jsonDataLength);
        chunksStart += jsonDataLength;
        const jsonString = decodeJson(jsonData);
        let json;
        try {
          json = JSON.parse(jsonString);
        } catch (err) {
          throw new InvalidCCONError(err);
        }
        const chunks = [];
        while (chunksStart < dataView.byteLength) {
          if (chunksStart % CHUNK_ALIGN_AS !== 0) {
            const padding = CHUNK_ALIGN_AS - chunksStart % CHUNK_ALIGN_AS;
            chunksStart += padding;
          }
          const chunkDataLength = dataView.getUint32(chunksStart, true);
          chunksStart += 4;
          chunks.push(new Uint8Array(dataView.buffer, chunksStart + dataView.byteOffset, chunkDataLength));
          chunksStart += chunkDataLength;
        }
        if (chunksStart !== dataView.byteLength) {
          throw new InvalidCCONError(getError(13102));
        }
        return new CCON(json, chunks);
      }
      function decodeJson(data) {
        if (typeof TextDecoder !== 'undefined') {
          return new TextDecoder().decode(data);
        } else if ('Buffer' in globalThis) {
          const {
            Buffer
          } = globalThis;
          return Buffer.from(data.buffer, data.byteOffset, data.byteLength).toString();
        } else {
          throw new Error(getError(13104));
        }
      }
      class InvalidCCONError extends Error {}
      cclegacy.internal.parseCCONJson = parseCCONJson;
      cclegacy.internal.decodeCCONBinary = decodeCCONBinary;
      cclegacy.internal.CCON = CCON;

      function compileObjectTypeJit(sources, defaultValue, accessorToSet, propNameLiteralToSet, assumeHavePropIfIsValue) {
        if (defaultValue instanceof cclegacy.ValueType) {
          if (!assumeHavePropIfIsValue) {
            sources.push('if(prop){');
          }
          const ctorCode = getClassName(defaultValue);
          sources.push(`s._deserializeFastDefinedObject(o${accessorToSet},prop,${ctorCode});`);
          if (!assumeHavePropIfIsValue) {
            sources.push(`}else o${accessorToSet}=null;`);
          }
        } else {
          sources.push(`
if (prop) {
    s._deserializeAndAssignField(o, prop, ${propNameLiteralToSet});
} else {
    o${accessorToSet}=null;
}
`);
        }
      }
      const compileDeserialize = compileDeserializeJIT ;
      const DELIMITER = CCClass.Attr.DELIMETER;
      const POSTFIX_TYPE = `${DELIMITER}type`;
      const POSTFIX_DEFAULT = `${DELIMITER}default`;
      const POSTFIX_FORMERLY_SERIALIZED_AS = `${DELIMITER}formerlySerializedAs`;
      function compileDeserializeJIT(self, klass) {
        const attrs = CCClass.Attr.getClassAttrs(klass);
        const props = klass.__values__;
        const sources = ['var prop;'];
        const fastMode = canBeDeserializedInFastMode(klass);
        for (let p = 0; p < props.length; p++) {
          const propName = props[p];
          let accessorToSet;
          let propNameLiteralToSet;
          if (CCClass.IDENTIFIER_RE.test(propName)) {
            propNameLiteralToSet = `"${propName}"`;
            accessorToSet = `.${propName}`;
          } else {
            propNameLiteralToSet = CCClass.escapeForJS(propName);
            accessorToSet = `[${propNameLiteralToSet}]`;
          }
          let accessorToGet = accessorToSet;
          if (attrs[propName + POSTFIX_FORMERLY_SERIALIZED_AS]) {
            const propNameToRead = attrs[propName + POSTFIX_FORMERLY_SERIALIZED_AS];
            if (CCClass.IDENTIFIER_RE.test(propNameToRead)) {
              accessorToGet = `.${propNameToRead}`;
            } else {
              accessorToGet = `[${CCClass.escapeForJS(propNameToRead)}]`;
            }
          }
          sources.push(`prop=d${accessorToGet};`);
          sources.push(`if(typeof ${'(prop)' }!=="undefined"){`);
          const defaultValue = CCClass.getDefault(attrs[propName + POSTFIX_DEFAULT]);
          const userType = attrs[propName + POSTFIX_TYPE];
          if (fastMode && (defaultValue !== undefined || userType)) {
            const isPrimitiveTypeInFastMode = isPrimitivePropertyByDefaultOrType(defaultValue, userType);
            if (isPrimitiveTypeInFastMode) {
              sources.push(`o${accessorToSet}=prop;`);
            } else {
              compileObjectTypeJit(sources, defaultValue, accessorToSet, propNameLiteralToSet, true);
            }
          } else {
            sources.push(`${`if(typeof ${'(prop)' }!=="object"){` + 'o'}${accessorToSet}=prop;` + `}else{`);
            compileObjectTypeJit(sources, defaultValue, accessorToSet, propNameLiteralToSet, false);
            sources.push('}');
          }
          sources.push('}');
        }
        if (isChildClassOf(klass, cclegacy.Node) || isChildClassOf(klass, cclegacy.Component)) {
          {
            sources.push('d._id&&(o._id=d._id);');
          }
        }
        if (props[props.length - 1] === '_$erialized') {
          sources.push('o._$erialized=JSON.parse(JSON.stringify(d));');
          sources.push('s._fillPlainObject(o._$erialized,d);');
        }
        return Function('s', 'o', 'd', 'k', sources.join(''));
      }
      function canBeDeserializedInFastMode(klass) {
        return BUILTIN_CLASSID_RE.test(getClassId(klass));
      }
      function isPrimitivePropertyByDefaultOrType(defaultValue, userType) {
        if (defaultValue === undefined) {
          return userType instanceof CCClass.Attr.PrimitiveType || userType === ENUM_TAG || userType === BITMASK_TAG;
        } else {
          const defaultType = typeof defaultValue;
          return defaultType === 'string' || defaultType === 'number' || defaultType === 'boolean';
        }
      }
      class DeserializerPool extends Pool$1 {
        constructor() {
          super(deserializer => {
            deserializer.clear();
          }, 1);
        }
      }
      DeserializerPool.prototype.get = function (details, classFinder, reportMissingClass, customEnv, ignoreEditorOnly) {
        const cache = this._get();
        if (cache) {
          cache.reset(details, classFinder, reportMissingClass, customEnv, ignoreEditorOnly);
          return cache;
        } else {
          return new _Deserializer(details, classFinder, reportMissingClass, customEnv, ignoreEditorOnly);
        }
      };
      class _Deserializer {
        get ignoreEditorOnly() {
          return this._ignoreEditorOnly;
        }
        constructor(result, classFinder, reportMissingClass, customEnv, ignoreEditorOnly) {
          this.deserializedList = [];
          this.deserializedData = null;
          this.result = result;
          this.customEnv = customEnv;
          this._classFinder = classFinder;
          this._reportMissingClass = reportMissingClass;
          this._onDereferenced = classFinder === null || classFinder === void 0 ? void 0 : classFinder.onDereferenced;
        }
        reset(result, classFinder, reportMissingClass, customEnv, ignoreEditorOnly) {
          this.result = result;
          this.customEnv = customEnv;
          this._classFinder = classFinder;
          this._reportMissingClass = reportMissingClass;
          this._onDereferenced = classFinder === null || classFinder === void 0 ? void 0 : classFinder.onDereferenced;
        }
        clear() {
          this.result = null;
          this.customEnv = null;
          this.deserializedList.length = 0;
          this.deserializedData = null;
          this._classFinder = null;
          this._reportMissingClass = null;
          this._onDereferenced = null;
        }
        deserialize(serializedData) {
          let fromCCON = false;
          let jsonObj;
          if (serializedData instanceof CCON) {
            fromCCON = true;
            jsonObj = serializedData.document;
            if (serializedData.chunks.length > 0) {
              assertIsTrue(serializedData.chunks.length === 1);
              this._mainBinChunk = serializedData.chunks[0];
            }
          } else {
            jsonObj = serializedData;
          }
          this._serializedData = jsonObj;
          this._context = {
            fromCCON
          };
          const serializedRootObject = Array.isArray(jsonObj) ? jsonObj[0] : jsonObj;
          {
            this.deserializedData = this._deserializeObject(serializedRootObject, 0);
          }
          this._serializedData = undefined;
          this._mainBinChunk = undefined;
          this._context = undefined;
          return this.deserializedData;
        }
        _deserializeObject(serialized, globalIndex, owner, propName) {
          switch (serialized.__type__) {
            case 'TypedArray':
              return this._deserializeTypedArrayView(serialized);
            case 'TypedArrayRef':
              return this._deserializeTypedArrayViewRef(serialized);
            default:
              if (serialized.__type__) {
                return this._deserializeTypeTaggedObject(serialized, globalIndex, owner, propName);
              } else if (!Array.isArray(serialized)) {
                return this._deserializePlainObject(serialized);
              } else {
                return this._deserializeArray(serialized);
              }
          }
        }
        _deserializeTypedArrayView(value) {
          return globalThis[value.ctor].from(value.array);
        }
        _deserializeTypedArrayViewRef(value) {
          const {
            offset,
            length,
            ctor: constructorName
          } = value;
          const obj = new globalThis[constructorName](this._mainBinChunk.buffer, this._mainBinChunk.byteOffset + offset, length);
          return obj;
        }
        _deserializeArray(value) {
          const obj = new Array(value.length);
          let prop;
          for (let i = 0; i < value.length; i++) {
            prop = value[i];
            if (typeof prop === 'object' && prop) {
              const isAssetType = this._deserializeAndAssignField(obj, prop, `${i}`);
              if (isAssetType) {
                obj[i] = null;
              }
            } else {
              obj[i] = prop;
            }
          }
          return obj;
        }
        _deserializePlainObject(value) {
          const obj = {};
          this._fillPlainObject(obj, value);
          return obj;
        }
        _deserializeTypeTaggedObject(value, globalIndex, owner, propName) {
          const type = value.__type__;
          const klass = this._classFinder(type, value, owner, propName);
          if (!klass) {
            const notReported = this._classFinder === getClassById;
            if (notReported) {
              this._reportMissingClass(type);
            }
            return null;
          }
          const createObject = constructor => {
            const obj = new constructor();
            if (globalIndex >= 0) {
              this.deserializedList[globalIndex] = obj;
            }
            return obj;
          };
          {
            const obj = createObject(klass);
            this._deserializeInto(value, obj, klass);
            return obj;
          }
        }
        _deserializeInto(value, object, constructor, skipCustomized = false) {
          if (!skipCustomized && object[deserializeTag]) {
            this._runCustomizedDeserialize(value, object, constructor);
            return;
          }
          if (object._deserialize) {
            object._deserialize(value.content, this);
            return;
          }
          if (cclegacy.Class._isCCClass(constructor)) {
            this._deserializeFireClass(object, value, constructor);
          } else {
            this._deserializeFastDefinedObject(object, value, constructor);
          }
        }
        _runCustomizedDeserialize(value, object, constructor) {
          const serializationInput = {
            readProperty: name => {
              const serializedField = value[name];
              if (typeof serializedField !== 'object' || !serializedField) {
                return serializedField;
              } else {
                return this._deserializeObjectField(serializedField);
              }
            },
            readThis: () => {
              this._deserializeInto(value, object, constructor, true);
            },
            readSuper: () => {
              const superConstructor = getSuper(constructor);
              if (superConstructor) {
                this._deserializeInto(value, object, superConstructor);
              }
            }
          };
          object[deserializeTag](serializationInput, this._context);
        }
        _deserializeFireClass(obj, serialized, klass) {
          let deserialize;
          if (klass.hasOwnProperty('__deserialize__')) {
            deserialize = klass.__deserialize__;
          } else {
            deserialize = compileDeserialize(this, klass);
            try {
              if (klass === MissingScript) {
                const props = klass.__values__;
                if (props.length === 0 || props[props.length - 1] !== '_$erialized') {
                  errorID(16341);
                  errorID(16342, props.join(', '));
                }
                const rawDeserialize = deserialize;
                deserialize = function (deserializer, object, deserialized, constructor) {
                  rawDeserialize(deserializer, object, deserialized, constructor);
                  if (!object._$erialized) {
                    errorID(16343, JSON.stringify(deserialized));
                  }
                };
              }
            } catch (e) {
              errorID(16344, `${e}`);
            }
            value(klass, '__deserialize__', deserialize, true);
          }
          deserialize(this, obj, serialized, klass);
        }
        _deserializeAndAssignField(obj, serializedField, propName) {
          const id = serializedField.__id__;
          if (typeof id === 'number') {
            const field = this.deserializedList[id];
            if (field) {
              obj[propName] = field;
            } else {
              var _this$_onDereferenced;
              const source = this._serializedData[id];
              {
                obj[propName] = this._deserializeObject(source, id, undefined, propName);
              }
              (_this$_onDereferenced = this._onDereferenced) === null || _this$_onDereferenced === void 0 ? void 0 : _this$_onDereferenced.call(this, this.deserializedList, id, obj, propName);
            }
          } else {
            const uuid = serializedField.__uuid__;
            if (uuid) {
              const expectedType = serializedField.__expectedType__;
              this.result.push(obj, propName, uuid, expectedType);
            } else {
              obj[propName] = this._deserializeObject(serializedField, -1);
            }
          }
          return false;
        }
        _deserializeObjectField(serializedField) {
          const id = serializedField.__id__;
          if (typeof id === 'number') {
            const field = this.deserializedList[id];
            if (field) {
              return field;
            } else {
              const source = this._serializedData[id];
              const field = this._deserializeObject(source, id, undefined, undefined);
              return field;
            }
          } else {
            const uuid = serializedField.__uuid__;
            if (uuid) {
              serializedField.__expectedType__;
              throw new Error(`Asset reference field serialization is currently not supported in custom serialization.`);
            } else {
              return this._deserializeObject(serializedField, -1);
            }
          }
        }
        _fillPlainObject(instance, serialized) {
          for (const propName in serialized) {
            if (!serialized.hasOwnProperty(propName)) {
              continue;
            }
            const prop = serialized[propName];
            if (typeof prop !== 'object') {
              if (propName !== '__type__') {
                instance[propName] = prop;
              }
            } else if (prop) {
              const isAssetType = this._deserializeAndAssignField(instance, prop, propName);
              if (isAssetType) {
                instance[propName] = null;
              }
            } else {
              instance[propName] = null;
            }
          }
        }
        _deserializeFastDefinedObject(instance, serialized, klass) {
          if (klass === cclegacy.Vec2) {
            instance.x = serialized.x || 0;
            instance.y = serialized.y || 0;
            return;
          } else if (klass === cclegacy.Vec3) {
            instance.x = serialized.x || 0;
            instance.y = serialized.y || 0;
            instance.z = serialized.z || 0;
            return;
          } else if (klass === cclegacy.Color) {
            instance.r = serialized.r || 0;
            instance.g = serialized.g || 0;
            instance.b = serialized.b || 0;
            const a = serialized.a;
            instance.a = a === undefined ? 255 : a;
            return;
          } else if (klass === cclegacy.Size) {
            instance.width = serialized.width || 0;
            instance.height = serialized.height || 0;
            return;
          }
          const attrs = CCClass.Attr.getClassAttrs(klass);
          const props = klass.__values__;
          if (!props) {
            error(`Unable to deserialize ${getClassName(klass)}. ` + 'For non-CCClass types, they can only be marked as serializable by `CCClass.fastDefine`.');
          }
          for (let i = 0; i < props.length; i++) {
            const propName = props[i];
            let value = serialized[propName];
            const exists = value !== undefined || serialized.hasOwnProperty(propName);
            if (!exists) {
              value = CCClass.getDefault(attrs[propName + POSTFIX_DEFAULT]);
            }
            if (typeof value !== 'object') {
              instance[propName] = value;
            } else if (value) {
              this._deserializeAndAssignField(instance, value, propName);
            } else {
              instance[propName] = null;
            }
          }
        }
      }
      _Deserializer.pool = new DeserializerPool();
      function deserializeDynamic(data, details, options) {
        var _options$reportMissin;
        options = options || {};
        const classFinder = options.classFinder || getClassById;
        const createAssetRefs = options.createAssetRefs || sys.platform === Platform.EDITOR_CORE;
        const customEnv = options.customEnv;
        const ignoreEditorOnly = options.ignoreEditorOnly;
        const reportMissingClass = (_options$reportMissin = options.reportMissingClass) !== null && _options$reportMissin !== void 0 ? _options$reportMissin : cclegacy.deserialize.reportMissingClass;
        details.init();
        const deserializer = _Deserializer.pool.get(details, classFinder, reportMissingClass, customEnv, ignoreEditorOnly);
        cclegacy.game._isCloning = true;
        const res = deserializer.deserialize(data);
        cclegacy.game._isCloning = false;
        _Deserializer.pool.put(deserializer);
        if (createAssetRefs) {
          details.assignAssetsBy((uuid, options) => EditorExtends.serialize.asAsset(uuid, options.type));
        }
        return res;
      }

      function reportMissingClass(id) {
        {
          errorID(5302, id);
        }
      }

      const constructorMap = [Vec2, Vec3, Vec4, Quat, Color$1, Size$1, Rect$1, Mat4];
      function vec4LikeSetter(obj, data) {
        obj.x = data[1];
        obj.y = data[2];
        obj.z = data[3];
        obj.w = data[4];
      }
      const setterMap = [(obj, data) => {
        obj.x = data[1];
        obj.y = data[2];
      }, (obj, data) => {
        obj.x = data[1];
        obj.y = data[2];
        obj.z = data[3];
      }, vec4LikeSetter, vec4LikeSetter, (obj, data) => {
        Color$1.fromUint32(obj, data[1]);
      }, (obj, data) => {
        obj.width = data[1];
        obj.height = data[2];
      }, (obj, data) => {
        obj.x = data[1];
        obj.y = data[2];
        obj.width = data[3];
        obj.height = data[4];
      }, (obj, data) => {
        Mat4.fromArray(obj, data, 1);
      }];
      function deserializeBuiltinValueType(data, owner, key, value) {
        const typeIndex = value[0];
        assertIsTrue(typeIndex >= 0 && typeIndex < constructorMap.length);
        const object = new constructorMap[typeIndex]();
        const setter = setterMap[typeIndex];
        setter(object, value);
        owner[key] = object;
      }
      function deserializeBuiltinValueTypeInto(data, owner, key, value) {
        const typeIndex = value[0];
        assertIsTrue(typeIndex >= 0 && typeIndex < constructorMap.length);
        {
          const tmp = owner[key];
          const setter = setterMap[typeIndex];
          setter(tmp, value);
          owner[key] = tmp;
        }
      }

      const SUPPORT_MIN_FORMAT_VERSION = 1;
      const EMPTY_PLACEHOLDER = 0;
      const CLASS_TYPE = 0;
      const CLASS_KEYS = 1;
      const CLASS_PROP_TYPE_OFFSET = 2;
      const MASK_CLASS = 0;
      const OBJ_DATA_MASK = 0;
      const CUSTOM_OBJ_DATA_CLASS = 0;
      const CUSTOM_OBJ_DATA_CONTENT = 1;
      const DICT_JSON_LAYOUT = 0;
      const ARRAY_ITEM_VALUES = 0;
      const PACKED_SECTIONS = 5;
      class Details {
        constructor() {
          this.uuidObjList = null;
          this.uuidPropList = null;
          this.uuidList = null;
          this.uuidTypeList = [];
        }
        init(data) {
          if (data) {
            this.uuidObjList = data[8];
            this.uuidPropList = data[9];
            this.uuidList = data[10];
          } else {
            const used = this.uuidList;
            if (!used) {
              this.uuidList = [];
              this.uuidObjList = [];
              this.uuidPropList = [];
              this.uuidTypeList = [];
            }
          }
        }
        reset() {
          {
            const used = this.uuidList;
            if (used) {
              this.uuidList.length = 0;
              this.uuidObjList.length = 0;
              this.uuidPropList.length = 0;
              this.uuidTypeList.length = 0;
            }
          }
        }
        push(obj, propName, uuid, type) {
          this.uuidObjList.push(obj);
          this.uuidPropList.push(propName);
          this.uuidList.push(uuid);
          this.uuidTypeList.push(type || '');
        }
      } exports("Details", Details);
      Details.pool = new Pool$1(obj => {
        obj.reset();
      }, 5);
      Details.pool.get = function () {
        return this._get() || new Details();
      };
      function dereference(refs, instances, strings) {
        const dataLength = refs.length - 1;
        let i = 0;
        const instanceOffset = refs[dataLength] * 3;
        for (; i < instanceOffset; i += 3) {
          const owner = refs[i];
          const target = instances[refs[i + 2]];
          const keyIndex = refs[i + 1];
          if (keyIndex >= 0) {
            owner[strings[keyIndex]] = target;
          } else {
            owner[~keyIndex] = target;
          }
        }
        for (; i < dataLength; i += 3) {
          const owner = instances[refs[i]];
          const target = instances[refs[i + 2]];
          const keyIndex = refs[i + 1];
          if (keyIndex >= 0) {
            owner[strings[keyIndex]] = target;
          } else {
            owner[~keyIndex] = target;
          }
        }
      }
      function deserializeCCObject(data, objectData) {
        const mask = data[4][objectData[OBJ_DATA_MASK]];
        const clazz = mask[MASK_CLASS];
        const ctor = clazz[CLASS_TYPE];
        const obj = new ctor();
        const keys = clazz[CLASS_KEYS];
        const classTypeOffset = clazz[CLASS_PROP_TYPE_OFFSET];
        const maskTypeOffset = mask[mask.length - 1];
        let i = MASK_CLASS + 1;
        for (; i < maskTypeOffset; ++i) {
          const key = keys[mask[i]];
          obj[key] = objectData[i];
        }
        for (; i < objectData.length; ++i) {
          const key = keys[mask[i]];
          const type = clazz[mask[i] + classTypeOffset];
          const op = ASSIGNMENTS[type];
          op(data, obj, key, objectData[i]);
        }
        return obj;
      }
      function deserializeCustomCCObject(data, ctor, value) {
        const obj = new ctor();
        if (obj._deserialize) {
          obj._deserialize(value, data[0]);
        } else {
          errorID(5303, getClassName(ctor));
        }
        return obj;
      }
      function assignSimple(data, owner, key, value) {
        owner[key] = value;
      }
      function assignInstanceRef(data, owner, key, value) {
        if (value >= 0) {
          owner[key] = data[5][value];
        } else {
          data[7][~value * 3] = owner;
        }
      }
      function genArrayParser(parser) {
        return (data, owner, key, value) => {
          for (let i = 0; i < value.length; ++i) {
            parser(data, value, i, value[i]);
          }
          owner[key] = value;
        };
      }
      function parseAssetRefByInnerObj(data, owner, key, value) {
        owner[key] = null;
        data[8][value] = owner;
      }
      function parseClass(data, owner, key, value) {
        owner[key] = deserializeCCObject(data, value);
      }
      function parseCustomClass(data, owner, key, value) {
        const ctor = data[3][value[CUSTOM_OBJ_DATA_CLASS]];
        owner[key] = deserializeCustomCCObject(data, ctor, value[CUSTOM_OBJ_DATA_CONTENT]);
      }
      function parseTRS(data, owner, key, value) {
        const typedArray = owner[key];
        typedArray.set(value);
      }
      function parseDict(data, owner, key, value) {
        const dict = value[DICT_JSON_LAYOUT];
        owner[key] = dict;
        for (let i = DICT_JSON_LAYOUT + 1; i < value.length; i += 3) {
          const subKey = value[i];
          const subType = value[i + 1];
          const subValue = value[i + 2];
          const op = ASSIGNMENTS[subType];
          op(data, dict, subKey, subValue);
        }
      }
      function parseArray(data, owner, key, value) {
        const array = value[ARRAY_ITEM_VALUES];
        for (let i = 0; i < array.length; ++i) {
          const subValue = array[i];
          const type = value[i + 1];
          if (type !== 0) {
            const op = ASSIGNMENTS[type];
            op(data, array, i, subValue);
          }
        }
        owner[key] = array;
      }
      const ASSIGNMENTS = new Array(13);
      ASSIGNMENTS[0] = assignSimple;
      ASSIGNMENTS[1] = assignInstanceRef;
      ASSIGNMENTS[2] = genArrayParser(assignInstanceRef);
      ASSIGNMENTS[3] = genArrayParser(parseAssetRefByInnerObj);
      ASSIGNMENTS[4] = parseClass;
      ASSIGNMENTS[5] = deserializeBuiltinValueTypeInto;
      ASSIGNMENTS[6] = parseAssetRefByInnerObj;
      ASSIGNMENTS[7] = parseTRS;
      ASSIGNMENTS[8] = deserializeBuiltinValueType;
      ASSIGNMENTS[9] = genArrayParser(parseClass);
      ASSIGNMENTS[10] = parseCustomClass;
      ASSIGNMENTS[11] = parseDict;
      ASSIGNMENTS[12] = parseArray;
      function parseInstances(data) {
        const instances = data[5];
        const instanceTypes = data[6];
        const instanceTypesLen = instanceTypes === EMPTY_PLACEHOLDER ? 0 : instanceTypes.length;
        let rootIndex = instances[instances.length - 1];
        let normalObjectCount = instances.length - instanceTypesLen;
        if (typeof rootIndex !== 'number') {
          rootIndex = 0;
        } else {
          if (rootIndex < 0) {
            rootIndex = ~rootIndex;
          }
          --normalObjectCount;
        }
        let insIndex = 0;
        for (; insIndex < normalObjectCount; ++insIndex) {
          instances[insIndex] = deserializeCCObject(data, instances[insIndex]);
        }
        const classes = data[3];
        for (let typeIndex = 0; typeIndex < instanceTypesLen; ++typeIndex, ++insIndex) {
          let type = instanceTypes[typeIndex];
          const eachData = instances[insIndex];
          if (type >= 0) {
            const ctor = classes[type];
            instances[insIndex] = deserializeCustomCCObject(data, ctor, eachData);
          } else {
            type = ~type;
            const op = ASSIGNMENTS[type];
            op(data, instances, insIndex, eachData);
          }
        }
        return rootIndex;
      }
      function getMissingClass(hasCustomFinder, type, reportMissingClass) {
        if (!hasCustomFinder) {
          reportMissingClass(type);
        }
        return Object;
      }
      function doLookupClass(classFinder, type, container, index, silent, hasCustomFinder, reportMissingClass) {
        let klass = classFinder(type);
        if (!klass) {
          if (silent) {
            container[index] = ((c, i, t) => function proxy() {
              const actualClass = classFinder(t) || getMissingClass(hasCustomFinder, t, reportMissingClass);
              c[i] = actualClass;
              return new actualClass();
            })(container, index, type);
            return;
          } else {
            klass = getMissingClass(hasCustomFinder, type, reportMissingClass);
          }
        }
        container[index] = klass;
      }
      function lookupClasses(data, silent, customFinder, reportMissingClass) {
        const classFinder = customFinder || getClassById;
        const classes = data[3];
        for (let i = 0; i < classes.length; ++i) {
          const klassLayout = classes[i];
          if (typeof klassLayout !== 'string') {
            {
              if (typeof klassLayout[CLASS_TYPE] === 'function') {
                throw new Error('Can not deserialize the same JSON data again.');
              }
            }
            const type = klassLayout[CLASS_TYPE];
            doLookupClass(classFinder, type, klassLayout, CLASS_TYPE, silent, customFinder, reportMissingClass);
          } else {
            doLookupClass(classFinder, klassLayout, classes, i, silent, customFinder, reportMissingClass);
          }
        }
      }
      function cacheMasks(data) {
        const masks = data[4];
        if (masks) {
          const classes = data[3];
          for (let i = 0; i < masks.length; ++i) {
            const mask = masks[i];
            mask[MASK_CLASS] = classes[mask[MASK_CLASS]];
          }
        }
      }
      function parseResult(data) {
        const instances = data[5];
        const sharedStrings = data[2];
        const dependSharedUuids = data[1];
        const dependObjs = data[8];
        const dependKeys = data[9];
        const dependUuids = data[10];
        for (let i = 0; i < dependObjs.length; ++i) {
          const obj = dependObjs[i];
          if (typeof obj === 'number') {
            dependObjs[i] = instances[obj];
          }
          let key = dependKeys[i];
          if (typeof key === 'number') {
            if (key >= 0) {
              key = sharedStrings[key];
            } else {
              key = ~key;
            }
            dependKeys[i] = key;
          }
          const uuid = dependUuids[i];
          if (typeof uuid === 'number') {
            dependUuids[i] = dependSharedUuids[uuid];
          }
        }
      }
      function isCompiledJson(json) {
        if (Array.isArray(json)) {
          const version = json[0];
          return typeof version === 'number' || version instanceof FileInfo;
        } else {
          return false;
        }
      }
      function initializeDeserializationContext(data, details, options) {
        var _options;
        details.init(data);
        (_options = options) !== null && _options !== void 0 ? _options : options = {};
        let version = data[0];
        let preprocessed = false;
        if (typeof version === 'object') {
          preprocessed = version.preprocessed;
          version = version.version;
        }
        if (version < SUPPORT_MIN_FORMAT_VERSION) {
          throw new Error(getError(5304, version));
        }
        const context = options;
        context._version = version;
        context.result = details;
        data[0] = context;
        if (!preprocessed) {
          var _options$reportMissin;
          lookupClasses(data, false, options.classFinder, (_options$reportMissin = options.reportMissingClass) !== null && _options$reportMissin !== void 0 ? _options$reportMissin : deserialize.reportMissingClass);
          cacheMasks(data);
        }
      }
      function deserialize(data, details, options) {
        if (typeof data === 'string') {
          data = JSON.parse(data);
        }
        let isBorrowedDetails = false;
        if (!details) {
          const borrowedDetails = Details.pool.get();
          assertIsTrue(borrowedDetails, `Can not allocate deserialization details`);
          details = borrowedDetails;
          isBorrowedDetails = true;
        }
        let res;
        if (!isCompiledJson(data)) {
          res = deserializeDynamic(data, details, options);
        } else {
          initializeDeserializationContext(data, details, options);
          const runtimeData = data;
          cclegacy.game._isCloning = true;
          const instances = runtimeData[5];
          const rootIndex = parseInstances(runtimeData);
          cclegacy.game._isCloning = false;
          if (runtimeData[7]) {
            dereference(runtimeData[7], instances, runtimeData[2]);
          }
          parseResult(runtimeData);
          res = instances[rootIndex];
        }
        if (isBorrowedDetails) {
          Details.pool.put(details);
        }
        return res;
      }
      deserialize.Details = Details;
      deserialize.reportMissingClass = reportMissingClass;
      class FileInfo {
        constructor(version) {
          this.preprocessed = true;
          this.version = version;
        }
      }
      function unpackJSONs(data, classFinder, reportMissingClass) {
        if (data[0] < SUPPORT_MIN_FORMAT_VERSION) {
          throw new Error(getError(5304, data[0]));
        }
        lookupClasses(data, true, classFinder, deserialize.reportMissingClass);
        cacheMasks(data);
        const version = new FileInfo(data[0]);
        const sharedUuids = data[1];
        const sharedStrings = data[2];
        const sharedClasses = data[3];
        const sharedMasks = data[4];
        const sections = data[PACKED_SECTIONS];
        for (let i = 0; i < sections.length; ++i) {
          const section = sections[i];
          section.unshift(version, sharedUuids, sharedStrings, sharedClasses, sharedMasks);
        }
        return sections;
      }
      function packCustomObjData(type, data, hasNativeDep) {
        return [SUPPORT_MIN_FORMAT_VERSION, EMPTY_PLACEHOLDER, EMPTY_PLACEHOLDER, [type], EMPTY_PLACEHOLDER, hasNativeDep ? [data, ~0] : [data], [0], EMPTY_PLACEHOLDER, [], [], []];
      }
      function hasNativeDep(data) {
        const instances = data[5];
        const rootInfo = instances[instances.length - 1];
        if (typeof rootInfo !== 'number') {
          return false;
        } else {
          return rootInfo < 0;
        }
      }
      function getDependUuidList(json) {
        const sharedUuids = json[1];
        return json[10].map(index => sharedUuids[index]);
      }
      function parseUuidDependencies(serialized) {
        {
          return getDependUuidList(serialized);
        }
      }
      cclegacy.deserialize = deserialize;

      const dependMap = new WeakMap();
      const nativeDependMap = new WeakSet();
      const onLoadedInvokedMap = new WeakSet();

      function deserializeAsset(json, options) {
        let classFinder;
        {
          classFinder = MissingScript.safeFindClass;
        }
        const tdInfo = Details.pool.get();
        let asset;
        try {
          asset = deserialize(json, tdInfo, {
            classFinder,
            customEnv: options
          });
        } catch (e) {
          error(e);
          Details.pool.put(tdInfo);
          throw e;
        }
        asset._uuid = options.__uuid__ || '';
        const uuidList = tdInfo.uuidList;
        const objList = tdInfo.uuidObjList;
        const propList = tdInfo.uuidPropList;
        const typeList = tdInfo.uuidTypeList || [];
        const depends = [];
        for (let i = 0; i < uuidList.length; i++) {
          const dependUuid = uuidList[i];
          depends[i] = {
            uuid: decodeUuid(dependUuid),
            owner: objList[i],
            prop: propList[i],
            type: getClassById(typeList[i])
          };
        }
        dependMap.set(asset, depends);
        if (asset._native) {
          nativeDependMap.add(asset);
        }
        Details.pool.put(tdInfo);
        return asset;
      }

      class DependUtil {
        static get instance() {
          if (!this._instance) {
            this._instance = new DependUtil();
          }
          return this._instance;
        }
        constructor() {
          this._depends = new Cache();
        }
        init() {
          this._depends.clear();
        }
        getNativeDep(uuid) {
          const depend = this._depends.get(uuid);
          if (depend && depend.nativeDep) {
            return {
              ...depend.nativeDep
            };
          }
          return null;
        }
        getDeps(uuid) {
          if (this._depends.has(uuid)) {
            return this._depends.get(uuid).deps;
          }
          return [];
        }
        getDepsRecursively(uuid) {
          const exclude = Object.create(null);
          const depends = [];
          this._descend(uuid, exclude, depends);
          return depends;
        }
        remove(uuid) {
          this._depends.remove(uuid);
        }
        parse(uuid, json) {
          let out = null;
          if (Array.isArray(json) || json.__type__ || json instanceof CCON) {
            if (this._depends.has(uuid)) {
              return this._depends.get(uuid);
            }
            if (Array.isArray(json) && (!hasNativeDep(json))) {
              out = {
                deps: this._parseDepsFromJson(json)
              };
            } else {
              try {
                const asset = deserializeAsset(json, {
                  __uuid__: uuid
                });
                out = this._parseDepsFromAsset(asset);
                if (out.nativeDep) {
                  out.nativeDep.uuid = uuid;
                }
                parsed.add(`${uuid}@import`, asset);
              } catch (e) {
                files.remove(`${uuid}@import`);
                out = {
                  deps: []
                };
              }
            }
          } else {
            if (this._depends.has(uuid)) {
              out = this._depends.get(uuid);
              if (out.parsedFromExistAsset) {
                return out;
              }
            }
            out = this._parseDepsFromAsset(json);
          }
          this._depends.add(uuid, out);
          return out;
        }
        _parseDepsFromAsset(asset) {
          const out = {
            deps: [],
            parsedFromExistAsset: true
          };
          const deps = dependMap.get(asset);
          assertIsNonNullable(deps);
          for (let i = 0, l = deps.length; i < l; i++) {
            out.deps.push(deps[i].uuid);
          }
          if (nativeDependMap.has(asset)) {
            out.nativeDep = asset._nativeDep;
          }
          return out;
        }
        _parseDepsFromJson(json) {
          const depends = parseUuidDependencies(json);
          depends.forEach((uuid, index) => depends[index] = decodeUuid(uuid));
          return depends;
        }
        _descend(uuid, exclude, depends) {
          const deps = this.getDeps(uuid);
          for (let i = 0; i < deps.length; i++) {
            const depend = deps[i];
            if (!exclude[depend]) {
              exclude[depend] = true;
              depends.push(depend);
              this._descend(depend, exclude, depends);
            }
          }
        }
      }
      DependUtil._instance = void 0;
      var dependUtil = DependUtil.instance;

      const textureBaseProto$1 = jsb.TextureBase.prototype;
      textureBaseProto$1._serialize = function (ctxForExporting) {
        return '';
      };
      textureBaseProto$1._deserialize = function (serializedData, handle) {
        const data = serializedData;
        const fields = data.split(',');
        fields.unshift('');
        if (fields.length >= 5) {
          this.setFilters(parseInt(fields[1]), parseInt(fields[2]));
          this.setWrapMode(parseInt(fields[3]), parseInt(fields[4]));
        }
        if (fields.length >= 7) {
          this.setMipFilter(parseInt(fields[5]));
          this.setAnisotropy(parseInt(fields[6]));
        }
      };
      textureBaseProto$1._getGFXDevice = function () {
        return deviceManager.gfxDevice;
      };
      textureBaseProto$1._getGFXFormat = function () {
        return this._getGFXPixelFormat(this.format);
      };
      textureBaseProto$1._setGFXFormat = function (format) {
        this.format = format === undefined ? 35 : format;
      };
      textureBaseProto$1._getGFXPixelFormat = function (format) {
        if (format === 1026) {
          format = 72;
        } else if (format === 1025) {
          format = 85;
        } else if (format === 1024) {
          format = 83;
        }
        return format;
      };
      textureBaseProto$1.createNode = null;
      const TextureBase = jsb.TextureBase;
      TextureBase.Filter = TextureFilter;
      TextureBase.PixelFormat = PixelFormat;
      TextureBase.WrapMode = WrapMode$1;
      textureBaseProto$1._ctor = function () {
        jsb.Asset.prototype._ctor.apply(this, arguments);
        this._gfxSampler = null;
        this._samplerInfo = null;
        this._textureHash = 0;
        this._registerGFXSamplerUpdatedListener();
      };
      const oldGetGFXSampler = textureBaseProto$1.getGFXSampler;
      textureBaseProto$1.getGFXSampler = function () {
        if (!this._gfxSampler) {
          this._gfxSampler = oldGetGFXSampler.call(this);
        }
        return this._gfxSampler;
      };
      const oldGetHash = textureBaseProto$1.getHash;
      textureBaseProto$1.getHash = function () {
        if (this._textureHash === 0) {
          this._textureHash = oldGetHash.call(this);
        }
        return this._textureHash;
      };
      const oldGetSamplerInfo = textureBaseProto$1.getSamplerInfo;
      textureBaseProto$1.getSamplerInfo = function () {
        if (!this._samplerInfo) {
          this._samplerInfo = oldGetSamplerInfo.call(this);
        }
        return this._samplerInfo;
      };
      const oldDestroy$1 = textureBaseProto$1.destroy;
      textureBaseProto$1.destroy = function () {
        var _cclegacy$director$ro;
        if ((_cclegacy$director$ro = cclegacy.director.root) !== null && _cclegacy$director$ro !== void 0 && _cclegacy$director$ro.batcher2D) {
          cclegacy.director.root.batcher2D._releaseDescriptorSetCache(this.getGFXTexture(), this.getGFXSampler());
        }
        return oldDestroy$1.call(this);
      };
      textureBaseProto$1._onGFXSamplerUpdated = function (gfxSampler, samplerInfo) {
        this._gfxSampler = gfxSampler;
        this._samplerInfo = samplerInfo;
      };
      cclegacy.TextureBase = jsb.TextureBase;
      patch_cc_TextureBase({
        TextureBase,
        Filter: TextureFilter,
        WrapMode: WrapMode$1,
        PixelFormat
      });

      const SimpleTexture = jsb.SimpleTexture;
      const jsbWindow = jsb.window;
      SimpleTexture.Filter = TextureFilter;
      SimpleTexture.PixelFormat = PixelFormat;
      SimpleTexture.WrapMode = WrapMode$1;
      const simpleTextureProto = jsb.SimpleTexture.prototype;
      const oldUpdateDataFunc = simpleTextureProto.uploadData;
      simpleTextureProto.uploadData = function (source, level = 0, arrayIndex = 0) {
        let data;
        if (source instanceof jsbWindow.HTMLCanvasElement) {
          data = source.data;
        } else if (source instanceof jsbWindow.HTMLImageElement) {
          data = source._data;
        } else if (ArrayBuffer.isView(source)) {
          data = source.buffer;
        }
        oldUpdateDataFunc.call(this, data, level, arrayIndex);
      };
      simpleTextureProto._ctor = function () {
        jsb.TextureBase.prototype._ctor.apply(this, arguments);
        this._gfxTexture = null;
        this._registerListeners();
      };
      const oldGetGFXTexture = simpleTextureProto.getGFXTexture;
      simpleTextureProto.getGFXTexture = function () {
        if (!this._gfxTexture) {
          this._gfxTexture = oldGetGFXTexture.call(this);
        }
        return this._gfxTexture;
      };
      simpleTextureProto._onGFXTextureUpdated = function (gfxTexture) {
        this._gfxTexture = gfxTexture;
      };
      simpleTextureProto._onAfterAssignImage = function (image) {
        if (macro.CLEANUP_IMAGE_CACHE) {
          const deps = dependUtil.getDeps(this._uuid);
          const index = deps.indexOf(image._uuid);
          if (index !== -1) {
            fastRemoveAt$2(deps, index);
            image.decRef();
          }
        }
      };
      patch_cc_SimpleTexture({
        SimpleTexture
      });
      cclegacy.SimpleTexture = jsb.SimpleTexture;

      const texture2DProto = jsb.Texture2D.prototype;
      texture2DProto.createNode = null;
      const Texture2D$1 = exports("Texture2D", jsb.Texture2D);
      Texture2D$1.Filter = TextureFilter;
      Texture2D$1.PixelFormat = PixelFormat;
      Texture2D$1.WrapMode = WrapMode$1;
      texture2DProto._ctor = function () {
        SimpleTexture.prototype._ctor.apply(this, arguments);
        this._mipmaps = [];
      };
      texture2DProto._serialize = function (ctxForExporting) {
        return null;
      };
      texture2DProto._deserialize = function (serializedData, handle) {
        const data = serializedData;
        TextureBase.prototype._deserialize.call(this, data.base, undefined);
        this._mipmaps = new Array(data.mipmaps.length);
        for (let i = 0; i < data.mipmaps.length; ++i) {
          this._mipmaps[i] = new ImageAsset$1();
          if (!data.mipmaps[i]) {
            continue;
          }
          const mipmapUUID = data.mipmaps[i];
          handle.result.push(this._mipmaps, `${i}`, mipmapUUID, getClassId(ImageAsset$1));
        }
      };
      const oldOnLoaded$2 = texture2DProto.onLoaded;
      texture2DProto.onLoaded = function () {
        this.syncMipmapsForJS(this._mipmaps);
        oldOnLoaded$2.call(this);
      };
      Object.defineProperty(texture2DProto, 'image', {
        configurable: true,
        enumerable: true,
        get() {
          return this._mipmaps.length === 0 ? null : this._mipmaps[0];
        },
        set(value) {
          this.mipmaps = value ? [value] : [];
        }
      });
      Object.defineProperty(texture2DProto, 'mipmaps', {
        configurable: true,
        enumerable: true,
        get() {
          return this._mipmaps;
        },
        set(arr) {
          for (let i = 0, len = arr.length; i < len; ++i) {
            arr[i]._syncDataToNative();
          }
          this._mipmaps = arr;
          this.setMipmaps(arr);
        }
      });
      cclegacy.Texture2D = jsb.Texture2D;
      patch_cc_Texture2D({
        Texture2D: Texture2D$1,
        ImageAsset: ImageAsset$1
      });

      const space$1 = 2;
      class Atlas {
        constructor(width, height) {
          this._innerTextureInfos = {};
          this._innerSpriteFrames = [];
          this._count = 0;
          const texture = new DynamicAtlasTexture();
          texture.initWithSize(width, height);
          this._texture = texture;
          this._width = width;
          this._height = height;
          this._x = space$1;
          this._y = space$1;
          this._nextY = space$1;
        }
        insertSpriteFrame(spriteFrame) {
          const rect = spriteFrame.rect;
          const texture = spriteFrame.texture;
          const info = this._innerTextureInfos[texture.getId()];
          let sx = rect.x;
          let sy = rect.y;
          if (info) {
            sx += info.x;
            sy += info.y;
          } else {
            const width = texture.width;
            const height = texture.height;
            if (this._x + width + space$1 > this._width) {
              this._x = space$1;
              this._y = this._nextY;
            }
            if (this._y + height + space$1 > this._nextY) {
              this._nextY = this._y + height + space$1;
            }
            if (this._nextY > this._height) {
              return null;
            }
            if (cclegacy.internal.dynamicAtlasManager.textureBleeding) {
              if (width <= 8 || height <= 8) {
                this._texture.drawTextureAt(texture.image, this._x - 1, this._y - 1);
                this._texture.drawTextureAt(texture.image, this._x - 1, this._y + 1);
                this._texture.drawTextureAt(texture.image, this._x + 1, this._y - 1);
                this._texture.drawTextureAt(texture.image, this._x + 1, this._y + 1);
              }
              this._texture.drawTextureAt(texture.image, this._x - 1, this._y);
              this._texture.drawTextureAt(texture.image, this._x + 1, this._y);
              this._texture.drawTextureAt(texture.image, this._x, this._y - 1);
              this._texture.drawTextureAt(texture.image, this._x, this._y + 1);
            }
            this._texture.drawTextureAt(texture.image, this._x, this._y);
            this._innerTextureInfos[texture.getId()] = {
              x: this._x,
              y: this._y,
              texture
            };
            this._count++;
            sx += this._x;
            sy += this._y;
            this._x += width + space$1;
          }
          const frame = {
            x: sx,
            y: sy,
            texture: this._texture
          };
          this._innerSpriteFrames.push(spriteFrame);
          return frame;
        }
        removeSpriteFrame(spriteFrame) {
          fastRemove(this._innerSpriteFrames, spriteFrame);
        }
        deleteInnerTexture(texture) {
          if (texture && this._innerTextureInfos[texture.getId()]) {
            delete this._innerTextureInfos[texture.getId()];
            this._count--;
          }
        }
        isEmpty() {
          return this._count <= 0;
        }
        reset() {
          this._x = space$1;
          this._y = space$1;
          this._nextY = space$1;
          const frames = this._innerSpriteFrames;
          for (let i = 0, l = frames.length; i < l; i++) {
            const frame = frames[i];
            if (!frame.isValid) {
              continue;
            }
            frame._resetDynamicAtlasFrame();
          }
          this._innerSpriteFrames.length = 0;
          this._innerTextureInfos = {};
        }
        destroy() {
          this.reset();
          this._texture.destroy();
        }
      } exports("Atlas", Atlas);
      class DynamicAtlasTexture extends Texture2D$1 {
        initWithSize(width, height, format = 35) {
          this.reset({
            width,
            height,
            format
          });
        }
        drawTextureAt(image, x, y) {
          const gfxTexture = this.getGFXTexture();
          if (!image || !gfxTexture) {
            return;
          }
          const gfxDevice = this._getGFXDevice();
          if (!gfxDevice) {
            warnID(16363);
            return;
          }
          const region = new BufferTextureCopy();
          region.texOffset.x = x;
          region.texOffset.y = y;
          region.texExtent.width = image.width;
          region.texExtent.height = image.height;
          gfxDevice.copyTexImagesToTexture([image.data], gfxTexture, [region]);
        }
      }

      const SceneAsset = exports("SceneAsset", jsb.SceneAsset);
      cclegacy.SceneAsset = SceneAsset;
      const sceneAssetProto = SceneAsset.prototype;
      Object.defineProperty(sceneAssetProto, 'scene', {
        enumerable: true,
        configurable: true,
        get() {
          if (!this._scene) {
            this._scene = this.getScene();
          }
          return this._scene;
        },
        set(v) {
          this._scene = v;
          this.setScene(v);
        }
      });
      sceneAssetProto._ctor = function () {
        jsb.Asset.prototype._ctor.apply(this, arguments);
        this._scene = null;
      };
      patch_cc_SceneAsset({
        SceneAsset
      });

      deprecateModuleExportedName({
        SystemEventType: {
          newName: 'Input.EventType',
          since: '3.3.0',
          removed: false
        }
      });

      deprecateModuleExportedName({
        SystemEvent: {
          newName: 'Input',
          since: '3.4.0',
          removed: false
        },
        systemEvent: {
          newName: 'input',
          since: '3.4.0',
          removed: false
        }
      });

      class Event {
        constructor(type, bubbles) {
          this.target = null;
          this.currentTarget = null;
          this.eventPhase = 0;
          this.propagationStopped = false;
          this.propagationImmediateStopped = false;
          this.type = type;
          this.bubbles = !!bubbles;
        }
        unuse() {
          this.type = Event.NO_TYPE;
          this.target = null;
          this.currentTarget = null;
          this.eventPhase = Event.NONE;
          this.propagationStopped = false;
          this.propagationImmediateStopped = false;
        }
        reuse(type, bubbles) {
          this.type = type;
          this.bubbles = bubbles || false;
        }
        isStopped() {
          return this.propagationStopped || this.propagationImmediateStopped;
        }
        getCurrentTarget() {
          return this.currentTarget;
        }
        getType() {
          return this.type;
        }
      } exports("Event", Event);
      Event.NO_TYPE = 'no_type';
      Event.TOUCH = 'touch';
      Event.MOUSE = 'mouse';
      Event.KEYBOARD = 'keyboard';
      Event.ACCELERATION = 'acceleration';
      Event.NONE = 0;
      Event.CAPTURING_PHASE = 1;
      Event.AT_TARGET = 2;
      Event.BUBBLING_PHASE = 3;
      cclegacy.Event = Event;

      class EventAcceleration extends Event {
        constructor(acc, bubbles) {
          super("devicemotion", bubbles);
          this.acc = acc;
        }
      } exports("EventAcceleration", EventAcceleration);
      Event.EventAcceleration = EventAcceleration;

      class EventKeyboard extends Event {
        get isPressed() {
          return this._isPressed;
        }
        constructor(keyCode, eventType, bubbles) {
          if (typeof eventType === 'boolean') {
            const isPressed = eventType;
            eventType = isPressed ? "keydown" : "keyup";
          }
          super(eventType, bubbles);
          this.rawEvent = void 0;
          this._isPressed = eventType !== "keyup";
          if (typeof keyCode === 'number') {
            this.keyCode = keyCode;
          } else {
            this.keyCode = keyCode.keyCode;
            this.rawEvent = keyCode;
          }
          this.windowId = 0;
        }
      } exports("EventKeyboard", EventKeyboard);
      Event.EventKeyboard = EventKeyboard;

      class EventMouse extends Event {
        get eventType() {
          return this._eventType;
        }
        constructor(eventType, bubbles, prevLoc, windowId) {
          super(eventType, bubbles);
          this.movementX = 0;
          this.movementY = 0;
          this.windowId = 0;
          this.preventSwallow = false;
          this._button = EventMouse.BUTTON_MISSING;
          this._x = 0;
          this._y = 0;
          this._prevX = 0;
          this._prevY = 0;
          this._scrollX = 0;
          this._scrollY = 0;
          this._eventType = eventType;
          if (prevLoc) {
            this._prevX = prevLoc.x;
            this._prevY = prevLoc.y;
          }
          this.windowId = windowId !== null && windowId !== void 0 ? windowId : this.windowId;
        }
        setScrollData(scrollX, scrollY) {
          this._scrollX = scrollX;
          this._scrollY = scrollY;
        }
        getScrollX() {
          return this._scrollX;
        }
        getScrollY() {
          return this._scrollY;
        }
        setLocation(x, y) {
          this._x = x;
          this._y = y;
        }
        getLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          Vec2.set(out, this._x, this._y);
          return out;
        }
        getLocationInView(out) {
          if (!out) {
            out = new Vec2();
          }
          Vec2.set(out, this._x, cclegacy.view._designResolutionSize.height - this._y);
          return out;
        }
        getUILocation(out) {
          if (!out) {
            out = new Vec2();
          }
          Vec2.set(out, this._x, this._y);
          cclegacy.view._convertToUISpace(out);
          return out;
        }
        getPreviousLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          Vec2.set(out, this._prevX, this._prevY);
          return out;
        }
        getUIPreviousLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          Vec2.set(out, this._prevX, this._prevY);
          cclegacy.view._convertToUISpace(out);
          return out;
        }
        getDelta(out) {
          if (!out) {
            out = new Vec2();
          }
          Vec2.set(out, this._x - this._prevX, this._y - this._prevY);
          return out;
        }
        getDeltaX() {
          return this._x - this._prevX;
        }
        getDeltaY() {
          return this._y - this._prevY;
        }
        getUIDelta(out) {
          if (!out) {
            out = new Vec2();
          }
          const view = cclegacy.view;
          Vec2.set(out, (this._x - this._prevX) / view.getScaleX(), (this._y - this._prevY) / view.getScaleY());
          return out;
        }
        getUIDeltaX() {
          return (this._x - this._prevX) / cclegacy.view.getScaleX();
        }
        getUIDeltaY() {
          return (this._y - this._prevY) / cclegacy.view.getScaleY();
        }
        setButton(button) {
          this._button = button;
        }
        getButton() {
          return this._button;
        }
        getLocationX() {
          return this._x;
        }
        getLocationY() {
          return this._y;
        }
        getUILocationX() {
          const view = cclegacy.view;
          const viewport = view.getViewportRect();
          return (this._x - viewport.x) / view.getScaleX();
        }
        getUILocationY() {
          const view = cclegacy.view;
          const viewport = view.getViewportRect();
          return (this._y - viewport.y) / view.getScaleY();
        }
      } exports("EventMouse", EventMouse);
      EventMouse.BUTTON_MISSING = -1;
      EventMouse.BUTTON_LEFT = 0;
      EventMouse.BUTTON_RIGHT = 2;
      EventMouse.BUTTON_MIDDLE = 1;
      EventMouse.BUTTON_4 = 3;
      EventMouse.BUTTON_5 = 4;
      EventMouse.BUTTON_6 = 5;
      EventMouse.BUTTON_7 = 6;
      EventMouse.BUTTON_8 = 7;
      Event.EventMouse = EventMouse;

      const _vec2$2 = new Vec2();
      class EventTouch extends Event {
        constructor(changedTouches, bubbles, eventType, touches = []) {
          super(eventType, bubbles);
          this.touch = null;
          this.simulate = false;
          this.windowId = 0;
          this.preventSwallow = false;
          this._eventCode = eventType;
          this._touches = changedTouches || [];
          this._allTouches = touches;
        }
        getEventCode() {
          return this._eventCode;
        }
        getTouches() {
          return this._touches;
        }
        getAllTouches() {
          return this._allTouches;
        }
        setLocation(x, y) {
          if (this.touch) {
            this.touch.setTouchInfo(this.touch.getID(), x, y);
          }
        }
        getLocation(out) {
          return this.touch ? this.touch.getLocation(out) : new Vec2();
        }
        getUILocation(out) {
          return this.touch ? this.touch.getUILocation(out) : new Vec2();
        }
        getLocationInView(out) {
          return this.touch ? this.touch.getLocationInView(out) : new Vec2();
        }
        getPreviousLocation(out) {
          return this.touch ? this.touch.getPreviousLocation(out) : new Vec2();
        }
        getStartLocation(out) {
          return this.touch ? this.touch.getStartLocation(out) : new Vec2();
        }
        getUIStartLocation(out) {
          return this.touch ? this.touch.getUIStartLocation(out) : new Vec2();
        }
        getID() {
          return this.touch ? this.touch.getID() : null;
        }
        getDelta(out) {
          return this.touch ? this.touch.getDelta(out) : new Vec2();
        }
        getUIDelta(out) {
          return this.touch ? this.touch.getUIDelta(out) : new Vec2();
        }
        getDeltaX() {
          return this.touch ? this.touch.getDelta(_vec2$2).x : 0;
        }
        getDeltaY() {
          return this.touch ? this.touch.getDelta(_vec2$2).y : 0;
        }
        getLocationX() {
          return this.touch ? this.touch.getLocationX() : 0;
        }
        getLocationY() {
          return this.touch ? this.touch.getLocationY() : 0;
        }
      } exports("EventTouch", EventTouch);
      EventTouch.MAX_TOUCHES = 5;
      Event.EventTouch = EventTouch;

      class EventGamepad extends Event {
        constructor(type, gamepad) {
          super(type, false);
          this.gamepad = gamepad;
        }
      } exports("EventGamepad", EventGamepad);

      class EventHandle extends Event {
        constructor(eventType, handleInputDevice) {
          super(eventType, false);
          this.handleInputDevice = handleInputDevice;
        }
      } exports("EventHandle", EventHandle);

      class EventHMD extends Event {
        constructor(eventType, hmdInputDevice) {
          super(eventType, false);
          this.hmdInputDevice = hmdInputDevice;
        }
      } exports("EventHMD", EventHMD);

      class EventHandheld extends Event {
        constructor(eventType, handheldInputDevice) {
          super(eventType, false);
          this.handheldInputDevice = handheldInputDevice;
        }
      } exports("EventHandheld", EventHandheld);

      class Acceleration {
        constructor(x = 0, y = 0, z = 0, timestamp = 0) {
          this.x = x;
          this.y = y;
          this.z = z;
          this.timestamp = timestamp;
        }
      } exports("Acceleration", Acceleration);

      const SystemEventType = exports("SystemEventType", {
        "TOUCH_START": "touch-start",
        "TOUCH_MOVE": "touch-move",
        "TOUCH_END": "touch-end",
        "TOUCH_CANCEL": "touch-cancel",
        "MOUSE_DOWN": "mouse-down",
        "MOUSE_MOVE": "mouse-move",
        "MOUSE_UP": "mouse-up",
        "MOUSE_WHEEL": "mouse-wheel",
        "MOUSE_ENTER": "mouse-enter",
        "MOUSE_LEAVE": "mouse-leave",
        "KEY_DOWN": "keydown",
        "KEY_UP": "keyup",
        "DEVICEMOTION": "devicemotion",
        "TRANSFORM_CHANGED": "transform-changed",
        "SCENE_CHANGED_FOR_PERSISTS": "scene-changed-for-persists",
        "SIZE_CHANGED": "size-changed",
        "ANCHOR_CHANGED": "anchor-changed",
        "COLOR_CHANGED": "color-changed",
        "CHILD_ADDED": "child-added",
        "CHILD_REMOVED": "child-removed",
        "PARENT_CHANGED": "parent-changed",
        "NODE_DESTROYED": "node-destroyed",
        "LAYER_CHANGED": "layer-changed",
        "SIBLING_ORDER_CHANGED": "sibling-order-changed"
      });
      const InputEventType = {
        "TOUCH_START": "touch-start",
        "TOUCH_MOVE": "touch-move",
        "TOUCH_END": "touch-end",
        "TOUCH_CANCEL": "touch-cancel",
        "MOUSE_DOWN": "mouse-down",
        "MOUSE_MOVE": "mouse-move",
        "MOUSE_UP": "mouse-up",
        "MOUSE_LEAVE": "mouse-leave-window",
        "MOUSE_ENTER": "mouse-enter-window",
        "MOUSE_WHEEL": "mouse-wheel",
        "KEY_DOWN": "keydown",
        "KEY_PRESSING": "key-pressing",
        "KEY_UP": "keyup",
        "DEVICEMOTION": "devicemotion",
        "GAMEPAD_INPUT": "gamepad-input",
        "GAMEPAD_CHANGE": "gamepad-change",
        "HANDLE_INPUT": "handle-input",
        "HANDLE_POSE_INPUT": "handle-pose-input",
        "HMD_POSE_INPUT": "hmd-pose-input",
        "HANDHELD_POSE_INPUT": "handheld-pose-input"
      };
      cclegacy.SystemEventType = SystemEventType;

      const KeyCode = exports("KeyCode", {
        "NONE": 0,
        "MOBILE_BACK": 6,
        "BACKSPACE": 8,
        "TAB": 9,
        "ENTER": 13,
        "SHIFT_LEFT": 16,
        "CTRL_LEFT": 17,
        "ALT_LEFT": 18,
        "PAUSE": 19,
        "CAPS_LOCK": 20,
        "ESCAPE": 27,
        "SPACE": 32,
        "PAGE_UP": 33,
        "PAGE_DOWN": 34,
        "END": 35,
        "HOME": 36,
        "ARROW_LEFT": 37,
        "ARROW_UP": 38,
        "ARROW_RIGHT": 39,
        "ARROW_DOWN": 40,
        "INSERT": 45,
        "DELETE": 46,
        "DIGIT_0": 48,
        "DIGIT_1": 49,
        "DIGIT_2": 50,
        "DIGIT_3": 51,
        "DIGIT_4": 52,
        "DIGIT_5": 53,
        "DIGIT_6": 54,
        "DIGIT_7": 55,
        "DIGIT_8": 56,
        "DIGIT_9": 57,
        "KEY_A": 65,
        "KEY_B": 66,
        "KEY_C": 67,
        "KEY_D": 68,
        "KEY_E": 69,
        "KEY_F": 70,
        "KEY_G": 71,
        "KEY_H": 72,
        "KEY_I": 73,
        "KEY_J": 74,
        "KEY_K": 75,
        "KEY_L": 76,
        "KEY_M": 77,
        "KEY_N": 78,
        "KEY_O": 79,
        "KEY_P": 80,
        "KEY_Q": 81,
        "KEY_R": 82,
        "KEY_S": 83,
        "KEY_T": 84,
        "KEY_U": 85,
        "KEY_V": 86,
        "KEY_W": 87,
        "KEY_X": 88,
        "KEY_Y": 89,
        "KEY_Z": 90,
        "NUM_0": 96,
        "NUM_1": 97,
        "NUM_2": 98,
        "NUM_3": 99,
        "NUM_4": 100,
        "NUM_5": 101,
        "NUM_6": 102,
        "NUM_7": 103,
        "NUM_8": 104,
        "NUM_9": 105,
        "NUM_MULTIPLY": 106,
        "NUM_PLUS": 107,
        "NUM_SUBTRACT": 109,
        "NUM_DECIMAL": 110,
        "NUM_DIVIDE": 111,
        "F1": 112,
        "F2": 113,
        "F3": 114,
        "F4": 115,
        "F5": 116,
        "F6": 117,
        "F7": 118,
        "F8": 119,
        "F9": 120,
        "F10": 121,
        "F11": 122,
        "F12": 123,
        "NUM_LOCK": 144,
        "SCROLL_LOCK": 145,
        "SEMICOLON": 186,
        "EQUAL": 187,
        "COMMA": 188,
        "DASH": 189,
        "PERIOD": 190,
        "SLASH": 191,
        "BACK_QUOTE": 192,
        "BRACKET_LEFT": 219,
        "BACKSLASH": 220,
        "BRACKET_RIGHT": 221,
        "QUOTE": 222,
        "SHIFT_RIGHT": 2000,
        "CTRL_RIGHT": 2001,
        "ALT_RIGHT": 2002,
        "NUM_ENTER": 2003
      });

      const _vec2$1 = new Vec2();
      class Touch {
        get lastModified() {
          return this._lastModified;
        }
        constructor(x, y, id = 0) {
          this._point = new Vec2();
          this._prevPoint = new Vec2();
          this._lastModified = 0;
          this._id = 0;
          this._startPoint = new Vec2();
          this._startPointCaptured = false;
          this.setTouchInfo(id, x, y);
        }
        getLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._point.x, this._point.y);
          return out;
        }
        getLocationX() {
          return this._point.x;
        }
        getLocationY() {
          return this._point.y;
        }
        getUILocation(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._point.x, this._point.y);
          cclegacy.view._convertToUISpace(out);
          return out;
        }
        getUILocationX() {
          const view = cclegacy.view;
          const viewport = view.getViewportRect();
          return (this._point.x - viewport.x) / view.getScaleX();
        }
        getUILocationY() {
          const view = cclegacy.view;
          const viewport = view.getViewportRect();
          return (this._point.y - viewport.y) / view.getScaleY();
        }
        getPreviousLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._prevPoint.x, this._prevPoint.y);
          return out;
        }
        getUIPreviousLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._prevPoint.x, this._prevPoint.y);
          cclegacy.view._convertToUISpace(out);
          return out;
        }
        getStartLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._startPoint.x, this._startPoint.y);
          return out;
        }
        getUIStartLocation(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._startPoint.x, this._startPoint.y);
          cclegacy.view._convertToUISpace(out);
          return out;
        }
        getDelta(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._point);
          out.subtract(this._prevPoint);
          return out;
        }
        getUIDelta(out) {
          if (!out) {
            out = new Vec2();
          }
          _vec2$1.set(this._point);
          _vec2$1.subtract(this._prevPoint);
          const view = cclegacy.view;
          out.set(view.getScaleX(), view.getScaleY());
          Vec2.divide(out, _vec2$1, out);
          return out;
        }
        getLocationInView(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._point.x, cclegacy.view._designResolutionSize.height - this._point.y);
          return out;
        }
        getPreviousLocationInView(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._prevPoint.x, cclegacy.view._designResolutionSize.height - this._prevPoint.y);
          return out;
        }
        getStartLocationInView(out) {
          if (!out) {
            out = new Vec2();
          }
          out.set(this._startPoint.x, cclegacy.view._designResolutionSize.height - this._startPoint.y);
          return out;
        }
        getID() {
          return this._id;
        }
        setTouchInfo(id = 0, x = 0, y = 0) {
          this._prevPoint = this._point;
          this._point = new Vec2(x || 0, y || 0);
          this._id = id;
          if (!this._startPointCaptured) {
            this._startPoint = new Vec2(this._point);
            this._startPointCaptured = true;
          }
        }
        setPoint(x, y) {
          if (typeof x === 'object') {
            this._point.x = x.x;
            this._point.y = x.y;
          } else {
            this._point.x = x || 0;
            this._point.y = y || 0;
          }
          this._lastModified = cclegacy.game.frameStartTime;
        }
        setPrevPoint(x, y) {
          if (typeof x === 'object') {
            this._prevPoint = new Vec2(x.x, x.y);
          } else {
            this._prevPoint = new Vec2(x || 0, y || 0);
          }
          this._lastModified = cclegacy.game.frameStartTime;
        }
        clone() {
          const touchID = this.getID();
          this.getStartLocation(_vec2$1);
          const clonedTouch = new Touch(_vec2$1.x, _vec2$1.y, touchID);
          this.getLocation(_vec2$1);
          clonedTouch.setPoint(_vec2$1.x, _vec2$1.y);
          this.getPreviousLocation(_vec2$1);
          clonedTouch.setPrevPoint(_vec2$1);
          return clonedTouch;
        }
      } exports("Touch", Touch);
      cclegacy.Touch = Touch;

      class AccelerometerInputSource {
        constructor() {
          this._intervalInSeconds = 0.2;
          this._intervalId = void 0;
          this._isEnabled = false;
          this._eventTarget = new EventTarget();
          this._didAccelerateFunc = this._didAccelerate.bind(this);
        }
        _didAccelerate() {
          const deviceMotionValue = jsb.device.getDeviceMotionValue();
          let x = deviceMotionValue[3] * 0.1;
          let y = deviceMotionValue[4] * 0.1;
          const z = deviceMotionValue[5] * 0.1;
          const orientation = screenAdapter.orientation;
          const tmpX = x;
          if (orientation === Orientation$1.LANDSCAPE_RIGHT) {
            x = -y;
            y = tmpX;
          } else if (orientation === Orientation$1.LANDSCAPE_LEFT) {
            x = y;
            y = -tmpX;
          } else if (orientation === Orientation$1.PORTRAIT_UPSIDE_DOWN) {
            x = -x;
            y = -y;
          }
          if (systemInfo.os === OS.ANDROID || systemInfo.os === OS.OHOS || systemInfo.os === OS.OPENHARMONY) {
            x = -x;
            y = -y;
          }
          const timestamp = performance.now();
          const acceleration = new Acceleration(x, y, z, timestamp);
          const eventAcceleration = new EventAcceleration(acceleration);
          this._eventTarget.emit("devicemotion", eventAcceleration);
        }
        start() {
          if (this._intervalId) {
            clearInterval(this._intervalId);
          }
          this._intervalId = setInterval(this._didAccelerateFunc, this._intervalInSeconds * 1000);
          jsb.device.setAccelerometerInterval(this._intervalInSeconds);
          jsb.device.setAccelerometerEnabled(true);
          this._isEnabled = true;
        }
        stop() {
          if (this._intervalId) {
            clearInterval(this._intervalId);
            this._intervalId = undefined;
          }
          jsb.device.setAccelerometerEnabled(false);
          this._isEnabled = false;
        }
        setInterval(intervalInMileseconds) {
          this._intervalInSeconds = intervalInMileseconds / 1000;
          jsb.device.setAccelerometerInterval(this._intervalInSeconds);
          if (this._isEnabled) {
            jsb.device.setAccelerometerEnabled(false);
            jsb.device.setAccelerometerEnabled(true);
          }
        }
        on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
      }

      class InputSource {}
      class InputSourceAxis1D extends InputSource {
        getValue() {
          throw new Error('Method not implemented.');
        }
      }
      class InputSourceAxis2D extends InputSource {
        getValue() {
          throw new Error('Method not implemented.');
        }
      }
      class InputSourceAxis3D extends InputSource {
        getValue() {
          throw new Error('Method not implemented.');
        }
      }
      class InputSourceQuat extends InputSource {
        getValue() {
          throw new Error('Method not implemented.');
        }
      }
      class CompositeInputSourceAxis1D extends InputSourceAxis1D {
        constructor(options) {
          super();
          this.positive = options.positive;
          this.negative = options.negative;
        }
        getValue() {
          const positiveValue = this.positive.getValue();
          const negativeValue = this.negative.getValue();
          if (Math.abs(positiveValue) > Math.abs(negativeValue)) {
            return positiveValue;
          }
          return -negativeValue;
        }
      }
      class CompositeInputSourceAxis2D extends InputSourceAxis2D {
        constructor(options) {
          super();
          this.up = options.up;
          this.down = options.down;
          this.left = options.left;
          this.right = options.right;
          this.xAxis = new CompositeInputSourceAxis1D({
            positive: this.right,
            negative: this.left
          });
          this.yAxis = new CompositeInputSourceAxis1D({
            positive: this.up,
            negative: this.down
          });
        }
        getValue() {
          return new Vec2(this.xAxis.getValue(), this.yAxis.getValue());
        }
      }
      class InputSourceButton extends InputSourceAxis1D {
        getValue() {
          return super.getValue();
        }
      }
      class InputSourceDpad extends CompositeInputSourceAxis2D {}
      class InputSourceStick extends CompositeInputSourceAxis2D {}
      class InputSourceOrientation extends InputSourceQuat {
        getValue() {
          return super.getValue();
        }
      }
      class InputSourcePosition extends InputSourceAxis3D {
        getValue() {
          return super.getValue();
        }
      }
      class InputSourceTouch extends InputSourceAxis1D {
        getValue() {
          return super.getValue();
        }
      }

      var Button$2;
      (function (Button) {
        Button[Button["BUTTON_SOUTH"] = 0] = "BUTTON_SOUTH";
        Button[Button["BUTTON_EAST"] = 1] = "BUTTON_EAST";
        Button[Button["BUTTON_WEST"] = 2] = "BUTTON_WEST";
        Button[Button["BUTTON_NORTH"] = 3] = "BUTTON_NORTH";
        Button[Button["NS_MINUS"] = 4] = "NS_MINUS";
        Button[Button["NS_PLUS"] = 5] = "NS_PLUS";
        Button[Button["BUTTON_L1"] = 6] = "BUTTON_L1";
        Button[Button["BUTTON_L2"] = 7] = "BUTTON_L2";
        Button[Button["BUTTON_L3"] = 8] = "BUTTON_L3";
        Button[Button["BUTTON_R1"] = 9] = "BUTTON_R1";
        Button[Button["BUTTON_R2"] = 10] = "BUTTON_R2";
        Button[Button["BUTTON_R3"] = 11] = "BUTTON_R3";
        Button[Button["DPAD_UP"] = 12] = "DPAD_UP";
        Button[Button["DPAD_DOWN"] = 13] = "DPAD_DOWN";
        Button[Button["DPAD_LEFT"] = 14] = "DPAD_LEFT";
        Button[Button["DPAD_RIGHT"] = 15] = "DPAD_RIGHT";
        Button[Button["LEFT_STICK_UP"] = 16] = "LEFT_STICK_UP";
        Button[Button["LEFT_STICK_DOWN"] = 17] = "LEFT_STICK_DOWN";
        Button[Button["LEFT_STICK_LEFT"] = 18] = "LEFT_STICK_LEFT";
        Button[Button["LEFT_STICK_RIGHT"] = 19] = "LEFT_STICK_RIGHT";
        Button[Button["RIGHT_STICK_UP"] = 20] = "RIGHT_STICK_UP";
        Button[Button["RIGHT_STICK_DOWN"] = 21] = "RIGHT_STICK_DOWN";
        Button[Button["RIGHT_STICK_LEFT"] = 22] = "RIGHT_STICK_LEFT";
        Button[Button["RIGHT_STICK_RIGHT"] = 23] = "RIGHT_STICK_RIGHT";
        Button[Button["ROKID_MENU"] = 24] = "ROKID_MENU";
        Button[Button["ROKID_START"] = 25] = "ROKID_START";
      })(Button$2 || (Button$2 = {}));
      const _nativeButtonMap$1 = {
        1: Button$2.BUTTON_EAST,
        2: Button$2.BUTTON_SOUTH,
        3: Button$2.BUTTON_NORTH,
        4: Button$2.BUTTON_WEST,
        5: Button$2.BUTTON_L1,
        6: Button$2.BUTTON_R1,
        7: Button$2.NS_MINUS,
        8: Button$2.NS_PLUS,
        9: Button$2.BUTTON_L3,
        10: Button$2.BUTTON_R3,
        11: Button$2.ROKID_MENU,
        12: Button$2.ROKID_START
      };
      class GamepadInputDevice {
        get buttonNorth() {
          return this._buttonNorth;
        }
        get buttonEast() {
          return this._buttonEast;
        }
        get buttonWest() {
          return this._buttonWest;
        }
        get buttonSouth() {
          return this._buttonSouth;
        }
        get buttonL1() {
          return this._buttonL1;
        }
        get buttonL2() {
          return this._buttonL2;
        }
        get buttonL3() {
          return this._buttonL3;
        }
        get buttonR1() {
          return this._buttonR1;
        }
        get buttonR2() {
          return this._buttonR2;
        }
        get buttonR3() {
          return this._buttonR3;
        }
        get buttonShare() {
          return this._buttonShare;
        }
        get buttonOptions() {
          return this._buttonOptions;
        }
        get dpad() {
          return this._dpad;
        }
        get leftStick() {
          return this._leftStick;
        }
        get rightStick() {
          return this._rightStick;
        }
        get buttonStart() {
          return this._buttonStart;
        }
        get gripLeft() {
          return this._gripLeft;
        }
        get gripRight() {
          return this._gripRight;
        }
        get handLeftPosition() {
          return this._handLeftPosition;
        }
        get handLeftOrientation() {
          return this._handLeftOrientation;
        }
        get handRightPosition() {
          return this._handRightPosition;
        }
        get handRightOrientation() {
          return this._handRightOrientation;
        }
        get aimLeftPosition() {
          return this._aimLeftPosition;
        }
        get aimLeftOrientation() {
          return this._aimLeftOrientation;
        }
        get aimRightPosition() {
          return this._aimRightPosition;
        }
        get aimRightOrientation() {
          return this._aimRightOrientation;
        }
        get deviceId() {
          return this._deviceId;
        }
        get connected() {
          return this._connected;
        }
        constructor(deviceId) {
          this._deviceId = -1;
          this._connected = false;
          this._nativeButtonState = {
            [Button$2.BUTTON_SOUTH]: 0,
            [Button$2.BUTTON_EAST]: 0,
            [Button$2.BUTTON_WEST]: 0,
            [Button$2.BUTTON_NORTH]: 0,
            [Button$2.NS_MINUS]: 0,
            [Button$2.NS_PLUS]: 0,
            [Button$2.BUTTON_L1]: 0,
            [Button$2.BUTTON_L2]: 0,
            [Button$2.BUTTON_L3]: 0,
            [Button$2.BUTTON_R1]: 0,
            [Button$2.BUTTON_R2]: 0,
            [Button$2.BUTTON_R3]: 0,
            [Button$2.DPAD_UP]: 0,
            [Button$2.DPAD_DOWN]: 0,
            [Button$2.DPAD_LEFT]: 0,
            [Button$2.DPAD_RIGHT]: 0,
            [Button$2.LEFT_STICK_UP]: 0,
            [Button$2.LEFT_STICK_DOWN]: 0,
            [Button$2.LEFT_STICK_LEFT]: 0,
            [Button$2.LEFT_STICK_RIGHT]: 0,
            [Button$2.RIGHT_STICK_UP]: 0,
            [Button$2.RIGHT_STICK_DOWN]: 0,
            [Button$2.RIGHT_STICK_LEFT]: 0,
            [Button$2.RIGHT_STICK_RIGHT]: 0,
            [Button$2.ROKID_MENU]: 0,
            [Button$2.ROKID_START]: 0
          };
          this._deviceId = deviceId;
          this._initInputSource();
        }
        static _init() {
          if (!systemInfo.hasFeature(Feature$1.EVENT_GAMEPAD)) {
            return;
          }
          GamepadInputDevice._registerEvent();
        }
        static _on(eventType, cb, target) {
          GamepadInputDevice._eventTarget.on(eventType, cb, target);
        }
        static _removeInputDevice(id) {
          const removeIndex = GamepadInputDevice.all.findIndex(device => device.deviceId === id);
          if (removeIndex === -1) {
            return;
          }
          fastRemoveAt$2(GamepadInputDevice.all, removeIndex);
        }
        static _getInputDevice(id) {
          return GamepadInputDevice.all.find(device => device.deviceId === id);
        }
        static _createInputDevice(id, connected) {
          const device = new GamepadInputDevice(id);
          device._connected = connected;
          GamepadInputDevice.all.push(device);
          return device;
        }
        static _getOrCreateInputDevice(id, connected) {
          let device = GamepadInputDevice._getInputDevice(id);
          if (!device) {
            device = GamepadInputDevice._createInputDevice(id, connected);
          }
          device._connected = connected;
          return device;
        }
        static _registerEvent() {
          jsb.onControllerInput = infoList => {
            for (let i = 0; i < infoList.length; ++i) {
              const info = infoList[i];
              const device = GamepadInputDevice._getOrCreateInputDevice(info.id, true);
              device._updateNativeButtonState(info);
              GamepadInputDevice._eventTarget.emit("gamepad-input", new EventGamepad("gamepad-input", device));
            }
          };
          jsb.onControllerChange = controllerIds => {
            for (let i = 0; i < controllerIds.length; ++i) {
              const id = controllerIds[i];
              let device = GamepadInputDevice._getInputDevice(id);
              if (!device) {
                device = GamepadInputDevice._createInputDevice(id, true);
                GamepadInputDevice._eventTarget.emit("gamepad-change", new EventGamepad("gamepad-change", device));
              }
            }
            const allDevices = GamepadInputDevice.all;
            for (let i = 0; i < allDevices.length; ++i) {
              const device = allDevices[i];
              if (!controllerIds.includes(device.deviceId)) {
                GamepadInputDevice._removeInputDevice(device.deviceId);
                device._connected = false;
                GamepadInputDevice._eventTarget.emit("gamepad-change", new EventGamepad("gamepad-change", device));
              }
            }
          };
        }
        _axisToButtons(axisValue) {
          const value = Math.abs(axisValue);
          if (axisValue > 0) {
            return {
              negative: 0,
              positive: value
            };
          } else if (axisValue < 0) {
            return {
              negative: value,
              positive: 0
            };
          } else {
            return {
              negative: 0,
              positive: 0
            };
          }
        }
        _updateNativeButtonState(info) {
          const {
            buttonInfoList,
            axisInfoList
          } = info;
          for (let i = 0; i < buttonInfoList.length; ++i) {
            const buttonInfo = buttonInfoList[i];
            const button = _nativeButtonMap$1[buttonInfo.code];
            this._nativeButtonState[button] = buttonInfo.isPressed ? 1 : 0;
          }
          for (let i = 0; i < axisInfoList.length; ++i) {
            const axisInfo = axisInfoList[i];
            const {
              code,
              value
            } = axisInfo;
            let negativeButton;
            let positiveButton;
            let axisValue;
            switch (code) {
              case 1:
                negativeButton = Button$2.DPAD_LEFT;
                positiveButton = Button$2.DPAD_RIGHT;
                axisValue = this._axisToButtons(value);
                break;
              case 2:
                negativeButton = Button$2.DPAD_DOWN;
                positiveButton = Button$2.DPAD_UP;
                axisValue = this._axisToButtons(value);
                break;
              case 3:
                negativeButton = Button$2.LEFT_STICK_LEFT;
                positiveButton = Button$2.LEFT_STICK_RIGHT;
                axisValue = this._axisToButtons(value);
                break;
              case 4:
                negativeButton = Button$2.LEFT_STICK_DOWN;
                positiveButton = Button$2.LEFT_STICK_UP;
                axisValue = this._axisToButtons(value);
                break;
              case 5:
                negativeButton = Button$2.RIGHT_STICK_LEFT;
                positiveButton = Button$2.RIGHT_STICK_RIGHT;
                axisValue = this._axisToButtons(value);
                break;
              case 6:
                negativeButton = Button$2.RIGHT_STICK_DOWN;
                positiveButton = Button$2.RIGHT_STICK_UP;
                axisValue = this._axisToButtons(value);
                break;
              default:
                if (code === 7) {
                  this._nativeButtonState[Button$2.BUTTON_L2] = value;
                } else if (code === 8) {
                  this._nativeButtonState[Button$2.BUTTON_R2] = value;
                }
                break;
            }
            if (negativeButton && positiveButton && axisValue) {
              this._nativeButtonState[negativeButton] = axisValue.negative;
              this._nativeButtonState[positiveButton] = axisValue.positive;
            }
          }
        }
        _initInputSource() {
          this._buttonNorth = new InputSourceButton();
          this._buttonNorth.getValue = () => this._nativeButtonState[Button$2.BUTTON_NORTH];
          this._buttonEast = new InputSourceButton();
          this._buttonEast.getValue = () => this._nativeButtonState[Button$2.BUTTON_EAST];
          this._buttonWest = new InputSourceButton();
          this._buttonWest.getValue = () => this._nativeButtonState[Button$2.BUTTON_WEST];
          this._buttonSouth = new InputSourceButton();
          this._buttonSouth.getValue = () => this._nativeButtonState[Button$2.BUTTON_SOUTH];
          this._buttonL1 = new InputSourceButton();
          this._buttonL1.getValue = () => this._nativeButtonState[Button$2.BUTTON_L1];
          this._buttonL2 = new InputSourceButton();
          this._buttonL2.getValue = () => this._nativeButtonState[Button$2.BUTTON_L2];
          this._buttonL3 = new InputSourceButton();
          this._buttonL3.getValue = () => this._nativeButtonState[Button$2.BUTTON_L3];
          this._buttonR1 = new InputSourceButton();
          this._buttonR1.getValue = () => this._nativeButtonState[Button$2.BUTTON_R1];
          this._buttonR2 = new InputSourceButton();
          this._buttonR2.getValue = () => this._nativeButtonState[Button$2.BUTTON_R2];
          this._buttonR3 = new InputSourceButton();
          this._buttonR3.getValue = () => this._nativeButtonState[Button$2.BUTTON_R3];
          this._buttonShare = new InputSourceButton();
          this._buttonShare.getValue = () => this._nativeButtonState[Button$2.NS_MINUS];
          this._buttonOptions = new InputSourceButton();
          this._buttonOptions.getValue = () => this._nativeButtonState[Button$2.NS_PLUS] || this._nativeButtonState[Button$2.ROKID_MENU];
          const dpadUp = new InputSourceButton();
          dpadUp.getValue = () => this._nativeButtonState[Button$2.DPAD_UP];
          const dpadDown = new InputSourceButton();
          dpadDown.getValue = () => this._nativeButtonState[Button$2.DPAD_DOWN];
          const dpadLeft = new InputSourceButton();
          dpadLeft.getValue = () => this._nativeButtonState[Button$2.DPAD_LEFT];
          const dpadRight = new InputSourceButton();
          dpadRight.getValue = () => this._nativeButtonState[Button$2.DPAD_RIGHT];
          this._dpad = new InputSourceDpad({
            up: dpadUp,
            down: dpadDown,
            left: dpadLeft,
            right: dpadRight
          });
          const leftStickUp = new InputSourceButton();
          leftStickUp.getValue = () => this._nativeButtonState[Button$2.LEFT_STICK_UP];
          const leftStickDown = new InputSourceButton();
          leftStickDown.getValue = () => this._nativeButtonState[Button$2.LEFT_STICK_DOWN];
          const leftStickLeft = new InputSourceButton();
          leftStickLeft.getValue = () => this._nativeButtonState[Button$2.LEFT_STICK_LEFT];
          const leftStickRight = new InputSourceButton();
          leftStickRight.getValue = () => this._nativeButtonState[Button$2.LEFT_STICK_RIGHT];
          this._leftStick = new InputSourceStick({
            up: leftStickUp,
            down: leftStickDown,
            left: leftStickLeft,
            right: leftStickRight
          });
          const rightStickUp = new InputSourceButton();
          rightStickUp.getValue = () => this._nativeButtonState[Button$2.RIGHT_STICK_UP];
          const rightStickDown = new InputSourceButton();
          rightStickDown.getValue = () => this._nativeButtonState[Button$2.RIGHT_STICK_DOWN];
          const rightStickLeft = new InputSourceButton();
          rightStickLeft.getValue = () => this._nativeButtonState[Button$2.RIGHT_STICK_LEFT];
          const rightStickRight = new InputSourceButton();
          rightStickRight.getValue = () => this._nativeButtonState[Button$2.RIGHT_STICK_RIGHT];
          this._rightStick = new InputSourceStick({
            up: rightStickUp,
            down: rightStickDown,
            left: rightStickLeft,
            right: rightStickRight
          });
          this._buttonStart = new InputSourceButton();
          this._buttonStart.getValue = () => this._nativeButtonState[Button$2.ROKID_START];
          this._gripLeft = new InputSourceButton();
          this._gripLeft.getValue = () => 0;
          this._gripRight = new InputSourceButton();
          this._gripRight.getValue = () => 0;
          this._handLeftPosition = new InputSourcePosition();
          this._handLeftPosition.getValue = () => Vec3.ZERO;
          this._handLeftOrientation = new InputSourceOrientation();
          this._handLeftOrientation.getValue = () => Quat.IDENTITY;
          this._handRightPosition = new InputSourcePosition();
          this._handRightPosition.getValue = () => Vec3.ZERO;
          this._handRightOrientation = new InputSourceOrientation();
          this._handRightOrientation.getValue = () => Quat.IDENTITY;
          this._aimLeftPosition = new InputSourcePosition();
          this._aimLeftPosition.getValue = () => Vec3.ZERO;
          this._aimLeftOrientation = new InputSourceOrientation();
          this._aimLeftOrientation.getValue = () => Quat.IDENTITY;
          this._aimRightPosition = new InputSourcePosition();
          this._aimRightPosition.getValue = () => Vec3.ZERO;
          this._aimRightOrientation = new InputSourceOrientation();
          this._aimRightOrientation.getValue = () => Quat.IDENTITY;
        }
      }
      GamepadInputDevice.all = [];
      GamepadInputDevice.xr = null;
      GamepadInputDevice._eventTarget = new EventTarget();

      var Button$1;
      (function (Button) {
        Button[Button["BUTTON_EAST"] = 0] = "BUTTON_EAST";
        Button[Button["BUTTON_SOUTH"] = 1] = "BUTTON_SOUTH";
        Button[Button["BUTTON_WEST"] = 2] = "BUTTON_WEST";
        Button[Button["BUTTON_NORTH"] = 3] = "BUTTON_NORTH";
        Button[Button["BUTTON_TRIGGER_LEFT"] = 4] = "BUTTON_TRIGGER_LEFT";
        Button[Button["BUTTON_TRIGGER_RIGHT"] = 5] = "BUTTON_TRIGGER_RIGHT";
        Button[Button["TRIGGER_LEFT"] = 6] = "TRIGGER_LEFT";
        Button[Button["TRIGGER_RIGHT"] = 7] = "TRIGGER_RIGHT";
        Button[Button["GRIP_LEFT"] = 8] = "GRIP_LEFT";
        Button[Button["GRIP_RIGHT"] = 9] = "GRIP_RIGHT";
        Button[Button["BUTTON_LEFT_STICK"] = 10] = "BUTTON_LEFT_STICK";
        Button[Button["LEFT_STICK_UP"] = 11] = "LEFT_STICK_UP";
        Button[Button["LEFT_STICK_DOWN"] = 12] = "LEFT_STICK_DOWN";
        Button[Button["LEFT_STICK_LEFT"] = 13] = "LEFT_STICK_LEFT";
        Button[Button["LEFT_STICK_RIGHT"] = 14] = "LEFT_STICK_RIGHT";
        Button[Button["BUTTON_RIGHT_STICK"] = 15] = "BUTTON_RIGHT_STICK";
        Button[Button["RIGHT_STICK_UP"] = 16] = "RIGHT_STICK_UP";
        Button[Button["RIGHT_STICK_DOWN"] = 17] = "RIGHT_STICK_DOWN";
        Button[Button["RIGHT_STICK_LEFT"] = 18] = "RIGHT_STICK_LEFT";
        Button[Button["RIGHT_STICK_RIGHT"] = 19] = "RIGHT_STICK_RIGHT";
        Button[Button["ROKID_MENU"] = 20] = "ROKID_MENU";
        Button[Button["ROKID_START"] = 21] = "ROKID_START";
      })(Button$1 || (Button$1 = {}));
      var Pose$3;
      (function (Pose) {
        Pose[Pose["HAND_LEFT"] = 0] = "HAND_LEFT";
        Pose[Pose["HAND_RIGHT"] = 1] = "HAND_RIGHT";
        Pose[Pose["AIM_LEFT"] = 2] = "AIM_LEFT";
        Pose[Pose["AIM_RIGHT"] = 3] = "AIM_RIGHT";
      })(Pose$3 || (Pose$3 = {}));
      var StickKeyCode;
      (function (StickKeyCode) {
        StickKeyCode[StickKeyCode["UNDEFINE"] = 0] = "UNDEFINE";
        StickKeyCode[StickKeyCode["A"] = 1] = "A";
        StickKeyCode[StickKeyCode["B"] = 2] = "B";
        StickKeyCode[StickKeyCode["X"] = 3] = "X";
        StickKeyCode[StickKeyCode["Y"] = 4] = "Y";
        StickKeyCode[StickKeyCode["L1"] = 5] = "L1";
        StickKeyCode[StickKeyCode["R1"] = 6] = "R1";
        StickKeyCode[StickKeyCode["MINUS"] = 7] = "MINUS";
        StickKeyCode[StickKeyCode["PLUS"] = 8] = "PLUS";
        StickKeyCode[StickKeyCode["L3"] = 9] = "L3";
        StickKeyCode[StickKeyCode["R3"] = 10] = "R3";
        StickKeyCode[StickKeyCode["MENU"] = 11] = "MENU";
        StickKeyCode[StickKeyCode["START"] = 12] = "START";
        StickKeyCode[StickKeyCode["TRIGGER_LEFT"] = 13] = "TRIGGER_LEFT";
        StickKeyCode[StickKeyCode["TRIGGER_RIGHT"] = 14] = "TRIGGER_RIGHT";
      })(StickKeyCode || (StickKeyCode = {}));
      var StickAxisCode;
      (function (StickAxisCode) {
        StickAxisCode[StickAxisCode["UNDEFINE"] = 0] = "UNDEFINE";
        StickAxisCode[StickAxisCode["X"] = 1] = "X";
        StickAxisCode[StickAxisCode["Y"] = 2] = "Y";
        StickAxisCode[StickAxisCode["LEFT_STICK_X"] = 3] = "LEFT_STICK_X";
        StickAxisCode[StickAxisCode["LEFT_STICK_Y"] = 4] = "LEFT_STICK_Y";
        StickAxisCode[StickAxisCode["RIGHT_STICK_X"] = 5] = "RIGHT_STICK_X";
        StickAxisCode[StickAxisCode["RIGHT_STICK_Y"] = 6] = "RIGHT_STICK_Y";
        StickAxisCode[StickAxisCode["L2"] = 7] = "L2";
        StickAxisCode[StickAxisCode["R2"] = 8] = "R2";
        StickAxisCode[StickAxisCode["LEFT_GRIP"] = 9] = "LEFT_GRIP";
        StickAxisCode[StickAxisCode["RIGHT_GRIP"] = 10] = "RIGHT_GRIP";
      })(StickAxisCode || (StickAxisCode = {}));
      var StickTouchCode;
      (function (StickTouchCode) {
        StickTouchCode[StickTouchCode["UNDEFINE"] = 0] = "UNDEFINE";
        StickTouchCode[StickTouchCode["A"] = 1] = "A";
        StickTouchCode[StickTouchCode["B"] = 2] = "B";
        StickTouchCode[StickTouchCode["X"] = 3] = "X";
        StickTouchCode[StickTouchCode["Y"] = 4] = "Y";
        StickTouchCode[StickTouchCode["LEFT_TRIGGER"] = 5] = "LEFT_TRIGGER";
        StickTouchCode[StickTouchCode["RIGHT_TRIGGER"] = 6] = "RIGHT_TRIGGER";
        StickTouchCode[StickTouchCode["LEFT_THUMBSTICK"] = 7] = "LEFT_THUMBSTICK";
        StickTouchCode[StickTouchCode["RIGHT_THUMBSTICK"] = 8] = "RIGHT_THUMBSTICK";
      })(StickTouchCode || (StickTouchCode = {}));
      const _nativeButtonMap = {
        1: Button$1.BUTTON_EAST,
        2: Button$1.BUTTON_SOUTH,
        3: Button$1.BUTTON_NORTH,
        4: Button$1.BUTTON_WEST,
        9: Button$1.BUTTON_LEFT_STICK,
        10: Button$1.BUTTON_RIGHT_STICK,
        11: Button$1.ROKID_MENU,
        12: Button$1.ROKID_START,
        13: Button$1.BUTTON_TRIGGER_LEFT,
        14: Button$1.BUTTON_TRIGGER_RIGHT
      };
      class HandleInputDevice {
        get buttonNorth() {
          return this._buttonNorth;
        }
        get buttonEast() {
          return this._buttonEast;
        }
        get buttonWest() {
          return this._buttonWest;
        }
        get buttonSouth() {
          return this._buttonSouth;
        }
        get buttonTriggerLeft() {
          return this._buttonTriggerLeft;
        }
        get buttonTriggerRight() {
          return this._buttonTriggerRight;
        }
        get triggerLeft() {
          return this._triggerLeft;
        }
        get triggerRight() {
          return this._triggerRight;
        }
        get gripLeft() {
          return this._gripLeft;
        }
        get gripRight() {
          return this._gripRight;
        }
        get leftStick() {
          return this._leftStick;
        }
        get rightStick() {
          return this._rightStick;
        }
        get buttonLeftStick() {
          return this._buttonLeftStick;
        }
        get buttonRightStick() {
          return this._buttonRightStick;
        }
        get buttonOptions() {
          return this._buttonOptions;
        }
        get buttonStart() {
          return this._buttonStart;
        }
        get handLeftPosition() {
          return this._handLeftPosition;
        }
        get handLeftOrientation() {
          return this._handLeftOrientation;
        }
        get handRightPosition() {
          return this._handRightPosition;
        }
        get handRightOrientation() {
          return this._handRightOrientation;
        }
        get aimLeftPosition() {
          return this._aimLeftPosition;
        }
        get aimLeftOrientation() {
          return this._aimLeftOrientation;
        }
        get aimRightPosition() {
          return this._aimRightPosition;
        }
        get aimRightOrientation() {
          return this._aimRightOrientation;
        }
        get touchButtonA() {
          return this._touchButtonA;
        }
        get touchButtonB() {
          return this._touchButtonB;
        }
        get touchButtonX() {
          return this._touchButtonX;
        }
        get touchButtonY() {
          return this._touchButtonY;
        }
        get touchButtonTriggerLeft() {
          return this._touchButtonTriggerLeft;
        }
        get touchButtonTriggerRight() {
          return this._touchButtonTriggerRight;
        }
        get touchButtonThumbStickLeft() {
          return this._touchButtonThumbStickLeft;
        }
        get touchButtonThumbStickRight() {
          return this._touchButtonThumbStickRight;
        }
        constructor() {
          this._eventTarget = new EventTarget();
          this._nativeButtonState = {
            [Button$1.BUTTON_SOUTH]: 0,
            [Button$1.BUTTON_EAST]: 0,
            [Button$1.BUTTON_WEST]: 0,
            [Button$1.BUTTON_NORTH]: 0,
            [Button$1.BUTTON_TRIGGER_LEFT]: 0,
            [Button$1.BUTTON_TRIGGER_RIGHT]: 0,
            [Button$1.TRIGGER_LEFT]: 0,
            [Button$1.TRIGGER_RIGHT]: 0,
            [Button$1.GRIP_LEFT]: 0,
            [Button$1.GRIP_RIGHT]: 0,
            [Button$1.LEFT_STICK_UP]: 0,
            [Button$1.LEFT_STICK_DOWN]: 0,
            [Button$1.LEFT_STICK_LEFT]: 0,
            [Button$1.LEFT_STICK_RIGHT]: 0,
            [Button$1.RIGHT_STICK_UP]: 0,
            [Button$1.RIGHT_STICK_DOWN]: 0,
            [Button$1.RIGHT_STICK_LEFT]: 0,
            [Button$1.RIGHT_STICK_RIGHT]: 0,
            [Button$1.BUTTON_LEFT_STICK]: 0,
            [Button$1.BUTTON_RIGHT_STICK]: 0,
            [Button$1.ROKID_MENU]: 0,
            [Button$1.ROKID_START]: 0
          };
          this._nativeTouchState = {
            [StickTouchCode.UNDEFINE]: 0,
            [StickTouchCode.A]: 0,
            [StickTouchCode.B]: 0,
            [StickTouchCode.X]: 0,
            [StickTouchCode.Y]: 0,
            [StickTouchCode.LEFT_TRIGGER]: 0,
            [StickTouchCode.RIGHT_TRIGGER]: 0,
            [StickTouchCode.LEFT_THUMBSTICK]: 0,
            [StickTouchCode.RIGHT_THUMBSTICK]: 0
          };
          this._nativePoseState = {
            [Pose$3.HAND_LEFT]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            },
            [Pose$3.HAND_RIGHT]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            },
            [Pose$3.AIM_LEFT]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            },
            [Pose$3.AIM_RIGHT]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            }
          };
          this._initInputSource();
          this._registerEvent();
        }
        _registerEvent() {
          jsb.onHandleInput = infoList => {
            for (let i = 0; i < infoList.length; ++i) {
              const info = infoList[i];
              this._updateNativeButtonState(info);
              this._eventTarget.emit("handle-input", new EventHandle("handle-input", this));
            }
          };
          jsb.onHandlePoseInput = infoList => {
            for (let i = 0; i < infoList.length; ++i) {
              const info = infoList[i];
              this._updateNativePoseState(info);
            }
            this._eventTarget.emit("handle-pose-input", new EventHandle("handle-pose-input", this));
          };
        }
        _on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
        _axisToButtons(axisValue) {
          const value = Math.abs(axisValue);
          if (axisValue > 0) {
            return {
              negative: 0,
              positive: value
            };
          } else if (axisValue < 0) {
            return {
              negative: value,
              positive: 0
            };
          } else {
            return {
              negative: 0,
              positive: 0
            };
          }
        }
        _updateNativeButtonState(info) {
          const {
            buttonInfoList,
            axisInfoList,
            touchInfoList
          } = info;
          for (let i = 0; i < buttonInfoList.length; ++i) {
            const buttonInfo = buttonInfoList[i];
            const button = _nativeButtonMap[buttonInfo.code];
            this._nativeButtonState[button] = buttonInfo.isPressed ? 1 : 0;
          }
          for (let i = 0; i < axisInfoList.length; ++i) {
            const axisInfo = axisInfoList[i];
            const {
              code,
              value
            } = axisInfo;
            let negativeButton;
            let positiveButton;
            let axisValue;
            switch (code) {
              case StickAxisCode.LEFT_STICK_X:
                negativeButton = Button$1.LEFT_STICK_LEFT;
                positiveButton = Button$1.LEFT_STICK_RIGHT;
                axisValue = this._axisToButtons(value);
                break;
              case StickAxisCode.LEFT_STICK_Y:
                negativeButton = Button$1.LEFT_STICK_DOWN;
                positiveButton = Button$1.LEFT_STICK_UP;
                axisValue = this._axisToButtons(value);
                break;
              case StickAxisCode.RIGHT_STICK_X:
                negativeButton = Button$1.RIGHT_STICK_LEFT;
                positiveButton = Button$1.RIGHT_STICK_RIGHT;
                axisValue = this._axisToButtons(value);
                break;
              case StickAxisCode.RIGHT_STICK_Y:
                negativeButton = Button$1.RIGHT_STICK_DOWN;
                positiveButton = Button$1.RIGHT_STICK_UP;
                axisValue = this._axisToButtons(value);
                break;
              case StickAxisCode.L2:
                this._nativeButtonState[Button$1.TRIGGER_LEFT] = value;
                break;
              case StickAxisCode.R2:
                this._nativeButtonState[Button$1.TRIGGER_RIGHT] = value;
                break;
              case StickAxisCode.LEFT_GRIP:
                this._nativeButtonState[Button$1.GRIP_LEFT] = value;
                break;
              case StickAxisCode.RIGHT_GRIP:
                this._nativeButtonState[Button$1.GRIP_RIGHT] = value;
                break;
            }
            if (negativeButton && positiveButton && axisValue) {
              this._nativeButtonState[negativeButton] = axisValue.negative;
              this._nativeButtonState[positiveButton] = axisValue.positive;
            }
          }
          if (touchInfoList) {
            for (let i = 0; i < touchInfoList.length; ++i) {
              const touchInfo = touchInfoList[i];
              const {
                code,
                value
              } = touchInfo;
              switch (code) {
                case StickTouchCode.A:
                case StickTouchCode.B:
                case StickTouchCode.X:
                case StickTouchCode.Y:
                case StickTouchCode.LEFT_TRIGGER:
                case StickTouchCode.RIGHT_TRIGGER:
                case StickTouchCode.LEFT_THUMBSTICK:
                case StickTouchCode.RIGHT_THUMBSTICK:
                  this._nativeTouchState[code] = value;
                  break;
              }
            }
          }
        }
        _updateNativePoseState(info) {
          switch (info.code) {
            case 1:
              this._nativePoseState[Pose$3.HAND_LEFT] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
            case 2:
              this._nativePoseState[Pose$3.AIM_LEFT] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
            case 4:
              this._nativePoseState[Pose$3.HAND_RIGHT] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
            case 5:
              this._nativePoseState[Pose$3.AIM_RIGHT] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
          }
        }
        _initInputSource() {
          this._buttonNorth = new InputSourceButton();
          this._buttonNorth.getValue = () => this._nativeButtonState[Button$1.BUTTON_NORTH];
          this._buttonEast = new InputSourceButton();
          this._buttonEast.getValue = () => this._nativeButtonState[Button$1.BUTTON_EAST];
          this._buttonWest = new InputSourceButton();
          this._buttonWest.getValue = () => this._nativeButtonState[Button$1.BUTTON_WEST];
          this._buttonSouth = new InputSourceButton();
          this._buttonSouth.getValue = () => this._nativeButtonState[Button$1.BUTTON_SOUTH];
          this._buttonTriggerLeft = new InputSourceButton();
          this._buttonTriggerLeft.getValue = () => this._nativeButtonState[Button$1.BUTTON_TRIGGER_LEFT];
          this._buttonTriggerRight = new InputSourceButton();
          this._buttonTriggerRight.getValue = () => this._nativeButtonState[Button$1.BUTTON_TRIGGER_RIGHT];
          this._triggerLeft = new InputSourceButton();
          this._triggerLeft.getValue = () => this._nativeButtonState[Button$1.TRIGGER_LEFT];
          this._triggerRight = new InputSourceButton();
          this._triggerRight.getValue = () => this._nativeButtonState[Button$1.TRIGGER_RIGHT];
          this._gripLeft = new InputSourceButton();
          this._gripLeft.getValue = () => this._nativeButtonState[Button$1.GRIP_LEFT];
          this._gripRight = new InputSourceButton();
          this._gripRight.getValue = () => this._nativeButtonState[Button$1.GRIP_RIGHT];
          this._buttonLeftStick = new InputSourceButton();
          this._buttonLeftStick.getValue = () => this._nativeButtonState[Button$1.BUTTON_LEFT_STICK];
          const leftStickUp = new InputSourceButton();
          leftStickUp.getValue = () => this._nativeButtonState[Button$1.LEFT_STICK_UP];
          const leftStickDown = new InputSourceButton();
          leftStickDown.getValue = () => this._nativeButtonState[Button$1.LEFT_STICK_DOWN];
          const leftStickLeft = new InputSourceButton();
          leftStickLeft.getValue = () => this._nativeButtonState[Button$1.LEFT_STICK_LEFT];
          const leftStickRight = new InputSourceButton();
          leftStickRight.getValue = () => this._nativeButtonState[Button$1.LEFT_STICK_RIGHT];
          this._leftStick = new InputSourceStick({
            up: leftStickUp,
            down: leftStickDown,
            left: leftStickLeft,
            right: leftStickRight
          });
          this._buttonRightStick = new InputSourceButton();
          this._buttonRightStick.getValue = () => this._nativeButtonState[Button$1.BUTTON_RIGHT_STICK];
          const rightStickUp = new InputSourceButton();
          rightStickUp.getValue = () => this._nativeButtonState[Button$1.RIGHT_STICK_UP];
          const rightStickDown = new InputSourceButton();
          rightStickDown.getValue = () => this._nativeButtonState[Button$1.RIGHT_STICK_DOWN];
          const rightStickLeft = new InputSourceButton();
          rightStickLeft.getValue = () => this._nativeButtonState[Button$1.RIGHT_STICK_LEFT];
          const rightStickRight = new InputSourceButton();
          rightStickRight.getValue = () => this._nativeButtonState[Button$1.RIGHT_STICK_RIGHT];
          this._rightStick = new InputSourceStick({
            up: rightStickUp,
            down: rightStickDown,
            left: rightStickLeft,
            right: rightStickRight
          });
          this._buttonOptions = new InputSourceButton();
          this._buttonOptions.getValue = () => this._nativeButtonState[Button$1.ROKID_MENU];
          this._buttonStart = new InputSourceButton();
          this._buttonStart.getValue = () => this._nativeButtonState[Button$1.ROKID_START];
          this._handLeftPosition = new InputSourcePosition();
          this._handLeftPosition.getValue = () => this._nativePoseState[Pose$3.HAND_LEFT].position;
          this._handLeftOrientation = new InputSourceOrientation();
          this._handLeftOrientation.getValue = () => this._nativePoseState[Pose$3.HAND_LEFT].orientation;
          this._handRightPosition = new InputSourcePosition();
          this._handRightPosition.getValue = () => this._nativePoseState[Pose$3.HAND_RIGHT].position;
          this._handRightOrientation = new InputSourceOrientation();
          this._handRightOrientation.getValue = () => this._nativePoseState[Pose$3.HAND_RIGHT].orientation;
          this._aimLeftPosition = new InputSourcePosition();
          this._aimLeftPosition.getValue = () => this._nativePoseState[Pose$3.AIM_LEFT].position;
          this._aimLeftOrientation = new InputSourceOrientation();
          this._aimLeftOrientation.getValue = () => this._nativePoseState[Pose$3.AIM_LEFT].orientation;
          this._aimRightPosition = new InputSourcePosition();
          this._aimRightPosition.getValue = () => this._nativePoseState[Pose$3.AIM_RIGHT].position;
          this._aimRightOrientation = new InputSourceOrientation();
          this._aimRightOrientation.getValue = () => this._nativePoseState[Pose$3.AIM_RIGHT].orientation;
          this._touchButtonA = new InputSourceTouch();
          this._touchButtonA.getValue = () => this._nativeTouchState[StickTouchCode.A];
          this._touchButtonB = new InputSourceTouch();
          this._touchButtonB.getValue = () => this._nativeTouchState[StickTouchCode.B];
          this._touchButtonX = new InputSourceTouch();
          this._touchButtonX.getValue = () => this._nativeTouchState[StickTouchCode.X];
          this._touchButtonY = new InputSourceTouch();
          this._touchButtonY.getValue = () => this._nativeTouchState[StickTouchCode.Y];
          this._touchButtonTriggerLeft = new InputSourceTouch();
          this._touchButtonTriggerLeft.getValue = () => this._nativeTouchState[StickTouchCode.LEFT_TRIGGER];
          this._touchButtonTriggerRight = new InputSourceTouch();
          this._touchButtonTriggerRight.getValue = () => this._nativeTouchState[StickTouchCode.RIGHT_TRIGGER];
          this._touchButtonThumbStickLeft = new InputSourceTouch();
          this._touchButtonThumbStickLeft.getValue = () => this._nativeTouchState[StickTouchCode.LEFT_THUMBSTICK];
          this._touchButtonThumbStickRight = new InputSourceTouch();
          this._touchButtonThumbStickRight.getValue = () => this._nativeTouchState[StickTouchCode.RIGHT_THUMBSTICK];
        }
      }

      var Pose$2;
      (function (Pose) {
        Pose[Pose["VIEW_LEFT"] = 0] = "VIEW_LEFT";
        Pose[Pose["VIEW_RIGHT"] = 1] = "VIEW_RIGHT";
        Pose[Pose["HEAD_MIDDLE"] = 2] = "HEAD_MIDDLE";
      })(Pose$2 || (Pose$2 = {}));
      class HMDInputDevice {
        get viewLeftPosition() {
          return this._viewLeftPosition;
        }
        get viewLeftOrientation() {
          return this._viewLeftOrientation;
        }
        get viewRightPosition() {
          return this._viewRightPosition;
        }
        get viewRightOrientation() {
          return this._viewRightOrientation;
        }
        get headMiddlePosition() {
          return this._headMiddlePosition;
        }
        get headMiddleOrientation() {
          return this._headMiddleOrientation;
        }
        constructor() {
          this._eventTarget = new EventTarget();
          this._nativePoseState = {
            [Pose$2.VIEW_LEFT]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            },
            [Pose$2.VIEW_RIGHT]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            },
            [Pose$2.HEAD_MIDDLE]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            }
          };
          this._initInputSource();
          this._registerEvent();
        }
        _registerEvent() {
          jsb.onHMDPoseInput = infoList => {
            for (let i = 0; i < infoList.length; ++i) {
              const info = infoList[i];
              this._updateNativePoseState(info);
            }
            this._eventTarget.emit("hmd-pose-input", new EventHMD("hmd-pose-input", this));
          };
        }
        _on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
        _updateNativePoseState(info) {
          switch (info.code) {
            case 0:
              this._nativePoseState[Pose$2.VIEW_LEFT] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
            case 3:
              this._nativePoseState[Pose$2.VIEW_RIGHT] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
            case 6:
              this._nativePoseState[Pose$2.HEAD_MIDDLE] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
          }
        }
        _initInputSource() {
          this._viewLeftPosition = new InputSourcePosition();
          this._viewLeftPosition.getValue = () => this._nativePoseState[Pose$2.VIEW_LEFT].position;
          this._viewLeftOrientation = new InputSourceOrientation();
          this._viewLeftOrientation.getValue = () => this._nativePoseState[Pose$2.VIEW_LEFT].orientation;
          this._viewRightPosition = new InputSourcePosition();
          this._viewRightPosition.getValue = () => this._nativePoseState[Pose$2.VIEW_RIGHT].position;
          this._viewRightOrientation = new InputSourceOrientation();
          this._viewRightOrientation.getValue = () => this._nativePoseState[Pose$2.VIEW_RIGHT].orientation;
          this._headMiddlePosition = new InputSourcePosition();
          this._headMiddlePosition.getValue = () => this._nativePoseState[Pose$2.HEAD_MIDDLE].position;
          this._headMiddleOrientation = new InputSourceOrientation();
          this._headMiddleOrientation.getValue = () => this._nativePoseState[Pose$2.HEAD_MIDDLE].orientation;
        }
      }

      var Pose$1;
      (function (Pose) {
        Pose[Pose["AR_MOBILE"] = 0] = "AR_MOBILE";
      })(Pose$1 || (Pose$1 = {}));
      class HandheldInputDevice {
        get handheldPosition() {
          return this._handheldPosition;
        }
        get handheldOrientation() {
          return this._handheldOrientation;
        }
        constructor() {
          this._eventTarget = new EventTarget();
          this._nativePoseState = {
            [Pose$1.AR_MOBILE]: {
              position: Vec3.ZERO,
              orientation: Quat.IDENTITY
            }
          };
          this._initInputSource();
          this._registerEvent();
        }
        _registerEvent() {
          jsb.onHandheldPoseInput = infoList => {
            for (let i = 0; i < infoList.length; ++i) {
              const info = infoList[i];
              this._updateNativePoseState(info);
            }
            this._eventTarget.emit("handheld-pose-input", new EventHandheld("handheld-pose-input", this));
          };
        }
        _on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
        _updateNativePoseState(info) {
          switch (info.code) {
            case 7:
              this._nativePoseState[Pose$1.AR_MOBILE] = {
                position: new Vec3(info.x, info.y, info.z),
                orientation: new Quat(info.quaternionX, info.quaternionY, info.quaternionZ, info.quaternionW)
              };
              break;
          }
        }
        _initInputSource() {
          this._handheldPosition = new InputSourcePosition();
          this._handheldPosition.getValue = () => this._nativePoseState[Pose$1.AR_MOBILE].position;
          this._handheldOrientation = new InputSourceOrientation();
          this._handheldOrientation.getValue = () => this._nativePoseState[Pose$1.AR_MOBILE].orientation;
        }
      }

      const code2KeyCode = {
        Backspace: 8,
        Tab: 9,
        Enter: 13,
        ShiftLeft: 16,
        ControlLeft: 17,
        AltLeft: 18,
        ShiftRight: 2000,
        ControlRight: 2001,
        AltRight: 2002,
        Pause: 19,
        CapsLock: 20,
        Escape: 27,
        Space: 32,
        PageUp: 33,
        PageDown: 34,
        End: 35,
        Home: 36,
        ArrowLeft: 37,
        ArrowUp: 38,
        ArrowRight: 39,
        ArrowDown: 40,
        Insert: 45,
        Delete: 46,
        Digit0: 48,
        Digit1: 49,
        Digit2: 50,
        Digit3: 51,
        Digit4: 52,
        Digit5: 53,
        Digit6: 54,
        Digit7: 55,
        Digit8: 56,
        Digit9: 57,
        KeyA: 65,
        KeyB: 66,
        KeyC: 67,
        KeyD: 68,
        KeyE: 69,
        KeyF: 70,
        KeyG: 71,
        KeyH: 72,
        KeyI: 73,
        KeyJ: 74,
        KeyK: 75,
        KeyL: 76,
        KeyM: 77,
        KeyN: 78,
        KeyO: 79,
        KeyP: 80,
        KeyQ: 81,
        KeyR: 82,
        KeyS: 83,
        KeyT: 84,
        KeyU: 85,
        KeyV: 86,
        KeyW: 87,
        KeyX: 88,
        KeyY: 89,
        KeyZ: 90,
        Numpad0: 96,
        Numpad1: 97,
        Numpad2: 98,
        Numpad3: 99,
        Numpad4: 100,
        Numpad5: 101,
        Numpad6: 102,
        Numpad7: 103,
        Numpad8: 104,
        Numpad9: 105,
        NumpadMultiply: 106,
        NumpadAdd: 107,
        NumpadSubtract: 109,
        NumpadDecimal: 110,
        NumpadDivide: 111,
        NumpadEnter: 2003,
        F1: 112,
        F2: 113,
        F3: 114,
        F4: 115,
        F5: 116,
        F6: 117,
        F7: 118,
        F8: 119,
        F9: 120,
        F10: 121,
        F11: 122,
        F12: 123,
        NumLock: 144,
        ScrollLock: 145,
        Semicolon: 186,
        Equal: 187,
        Comma: 188,
        Minus: 189,
        Period: 190,
        Slash: 191,
        Backquote: 192,
        BracketLeft: 219,
        Backslash: 220,
        BracketRight: 221,
        Quote: 222
      };

      const nativeKeyCode2KeyCode = {
        12: 144,
        10048: 96,
        10049: 97,
        10050: 98,
        10051: 99,
        10052: 100,
        10053: 101,
        10054: 102,
        10055: 103,
        10056: 104,
        10057: 105,
        20013: 2003,
        20016: 2000,
        20017: 2001,
        20018: 2002
      };
      function getKeyCode(event) {
        if (event.code) {
          if (event.code in code2KeyCode) {
            return code2KeyCode[event.code];
          } else {
            console.error(`Can not find keyCode for code: ${event.code}`);
          }
        }
        return nativeKeyCode2KeyCode[event.keyCode] || event.keyCode;
      }
      class KeyboardInputSource {
        constructor() {
          this._eventTarget = new EventTarget();
          this._keyStateMap = {};
          this._handleKeyboardDown = void 0;
          this._handleKeyboardUp = void 0;
          this._handleKeyboardDown = event => {
            const keyCode = getKeyCode(event);
            if (!this._keyStateMap[keyCode]) {
              const eventKeyDown = this._getInputEvent(event, "keydown");
              this._eventTarget.emit("keydown", eventKeyDown);
            } else {
              const eventKeyPressing = this._getInputEvent(event, "key-pressing");
              this._eventTarget.emit("key-pressing", eventKeyPressing);
            }
            this._keyStateMap[keyCode] = true;
          };
          this._handleKeyboardUp = event => {
            const keyCode = getKeyCode(event);
            const eventKeyUp = this._getInputEvent(event, "keyup");
            this._keyStateMap[keyCode] = false;
            this._eventTarget.emit("keyup", eventKeyUp);
          };
          this._registerEvent();
        }
        dispatchKeyboardDownEvent(nativeKeyboardEvent) {
          this._handleKeyboardDown(nativeKeyboardEvent);
        }
        dispatchKeyboardUpEvent(nativeKeyboardEvent) {
          this._handleKeyboardUp(nativeKeyboardEvent);
        }
        _registerEvent() {
          jsb.onKeyDown = this._handleKeyboardDown;
          jsb.onKeyUp = this._handleKeyboardUp;
        }
        _getInputEvent(event, eventType) {
          const keyCode = getKeyCode(event);
          const eventKeyboard = new EventKeyboard(keyCode, eventType);
          eventKeyboard.windowId = event.windowId;
          return eventKeyboard;
        }
        on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
      }

      class MouseEventElement {
        constructor() {
          this.type = null;
          this.mouseEvent = {
            x: 0,
            y: 0,
            xDelta: 0,
            yDelta: 0,
            button: 0,
            windowId: 0,
            wheelDeltaX: 0,
            wheelDeltaY: 0
          };
        }
      }
      class MouseEventCache {
        constructor() {
          this._events = [];
          this._length = 0;
        }
        push(eventType, mouseEvent) {
          const events = this._events;
          const index = this._length;
          if (index >= events.length) {
            events.push(new MouseEventElement());
          }
          const e = events[index];
          e.type = eventType;
          const cachedEvent = e.mouseEvent;
          if (mouseEvent) {
            Object.assign(cachedEvent, mouseEvent);
          } else {
            cachedEvent.x = cachedEvent.y = cachedEvent.xDelta = cachedEvent.yDelta = 0;
            cachedEvent.button = cachedEvent.windowId = cachedEvent.wheelDeltaX = cachedEvent.wheelDeltaY = 0;
          }
          ++this._length;
        }
        clear() {
          this._length = 0;
        }
        forEach(cb) {
          for (let i = 0, len = this._length; i < len; ++i) {
            cb(this._events[i]);
          }
        }
      }
      class MouseInputSource {
        constructor() {
          this._eventTarget = new EventTarget();
          this._preMousePos = new Vec2();
          this._isPressed = false;
          this._windowManager = void 0;
          this._pointLocked = false;
          this._cache = new MouseEventCache();
          this._handleMouseDown = void 0;
          this._handleMouseMove = void 0;
          this._handleMouseUp = void 0;
          this._handleWindowLeave = void 0;
          this._handleWindowEnter = void 0;
          this._handleMouseWheel = void 0;
          this._handleMouseDown = this._createEventCacheCallback("mouse-down");
          this._handleMouseMove = this._createEventCacheCallback("mouse-move");
          this._handleMouseUp = this._createEventCacheCallback("mouse-up");
          this._handleWindowLeave = this._createEventCacheCallback("mouse-leave-window");
          this._handleWindowEnter = this._createEventCacheCallback("mouse-enter-window");
          this._handleMouseWheel = this._createEventCacheCallback("mouse-wheel");
          this._registerEvent();
          this._windowManager = jsb.ISystemWindowManager.getInstance();
        }
        dispatchMouseDownEvent(nativeMouseEvent) {
          this._handleMouseDown(nativeMouseEvent);
        }
        dispatchMouseMoveEvent(nativeMouseEvent) {
          this._handleMouseMove(nativeMouseEvent);
        }
        dispatchMouseUpEvent(nativeMouseEvent) {
          this._handleMouseUp(nativeMouseEvent);
        }
        dispatchScrollEvent(nativeMouseEvent) {
          this._handleMouseWheel(nativeMouseEvent);
        }
        _getLocation(event) {
          const window = this._windowManager.getWindow(event.windowId);
          const windowSize = window.getViewSize();
          const dpr = screenAdapter.devicePixelRatio;
          const x = event.x * dpr;
          const y = windowSize.height - event.y * dpr;
          return new Vec2(x, y);
        }
        _registerEvent() {
          jsb.onMouseDown = this._handleMouseDown;
          jsb.onMouseMove = this._handleMouseMove;
          jsb.onMouseUp = this._handleMouseUp;
          jsb.onMouseWheel = this._handleMouseWheel;
          jsb.onPointerlockChange = value => {
            this._pointLocked = value;
          };
          jsb.onWindowLeave = this._handleWindowLeave;
          jsb.onWindowEnter = this._handleWindowEnter;
        }
        _createEventCacheCallback(eventType) {
          return mouseEvent => {
            this._cache.push(eventType, mouseEvent);
          };
        }
        dispatchEventsInCache() {
          const cache = this._cache;
          cache.forEach(e => {
            switch (e.type) {
              case "mouse-leave-window":
                this._dispatchWindowLeave();
                break;
              case "mouse-enter-window":
                this._dispatchWindowEnter();
                break;
              case "mouse-wheel":
                this._dispatchMouseWheel(e.mouseEvent);
                break;
              default:
                this._dispatchEvent(e.type, e.mouseEvent);
                break;
            }
          });
          cache.clear();
        }
        _dispatchEvent(eventType, mouseEvent) {
          const location = this._getLocation(mouseEvent);
          let button = mouseEvent.button;
          switch (eventType) {
            case "mouse-down":
              this._isPressed = true;
              break;
            case "mouse-up":
              this._isPressed = false;
              break;
            case "mouse-move":
              if (!this._isPressed) {
                button = EventMouse.BUTTON_MISSING;
              }
              break;
          }
          const eventMouse = new EventMouse(eventType, false, this._preMousePos, mouseEvent.windowId);
          eventMouse.setLocation(location.x, location.y);
          eventMouse.setButton(button);
          const dpr = screenAdapter.devicePixelRatio;
          eventMouse.movementX = typeof mouseEvent.xDelta === 'undefined' ? 0 : mouseEvent.xDelta * dpr;
          eventMouse.movementY = typeof mouseEvent.yDelta === 'undefined' ? 0 : mouseEvent.yDelta * dpr;
          this._preMousePos.set(location.x, location.y);
          this._eventTarget.emit(eventType, eventMouse);
        }
        _dispatchMouseWheel(mouseEvent) {
          const eventType = "mouse-wheel";
          const location = this._getLocation(mouseEvent);
          const button = mouseEvent.button;
          const eventMouse = new EventMouse(eventType, false, this._preMousePos, mouseEvent.windowId);
          eventMouse.setLocation(location.x, location.y);
          eventMouse.setButton(button);
          eventMouse.movementX = location.x - this._preMousePos.x;
          eventMouse.movementY = this._preMousePos.y - location.y;
          const matchStandardFactor = 120;
          eventMouse.setScrollData(mouseEvent.wheelDeltaX * matchStandardFactor, mouseEvent.wheelDeltaY * matchStandardFactor);
          this._preMousePos.set(location.x, location.y);
          this._eventTarget.emit(eventType, eventMouse);
        }
        on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
        _dispatchWindowLeave() {
          const eventType = "mouse-leave-window";
          const eventMouse = new EventMouse(eventType, false);
          this._eventTarget.emit(eventType, eventMouse);
        }
        _dispatchWindowEnter() {
          const eventType = "mouse-enter-window";
          const eventMouse = new EventMouse(eventType, false);
          this._eventTarget.emit(eventType, eventMouse);
        }
      }

      const tempVec2$1 = new Vec2();
      class TouchManager {
        constructor() {
          this._touchMap = new Map();
          this._maxTouches = 8;
        }
        _createTouch(touchID, x, y) {
          if (this._touchMap.has(touchID)) {
            logID(2301);
            return undefined;
          }
          const checkResult = this._checkTouchMapSizeMoreThanMax(touchID);
          if (checkResult) {
            logID(2300);
            return undefined;
          }
          const touch = new Touch(x, y, touchID);
          this._touchMap.set(touchID, touch);
          this._updateTouch(touch, x, y);
          return touch;
        }
        releaseTouch(touchID) {
          if (!this._touchMap.has(touchID)) {
            return;
          }
          this._touchMap.delete(touchID);
        }
        getTouch(touchID) {
          return this._touchMap.get(touchID);
        }
        getOrCreateTouch(touchID, x, y) {
          let touch = this.getTouch(touchID);
          if (!touch) {
            touch = this._createTouch(touchID, x, y);
          } else {
            this._updateTouch(touch, x, y);
          }
          return touch;
        }
        getAllTouches() {
          const touches = [];
          this._touchMap.forEach(touch => {
            if (touch) {
              touches.push(touch);
            }
          });
          return touches;
        }
        getTouchCount() {
          return this._touchMap.size;
        }
        _updateTouch(touch, x, y) {
          touch.getLocation(tempVec2$1);
          touch.setPrevPoint(tempVec2$1);
          touch.setPoint(x, y);
        }
        _checkTouchMapSizeMoreThanMax(touchID) {
          if (this._touchMap.has(touchID)) {
            return false;
          }
          const maxSize = macro.ENABLE_MULTI_TOUCH ? this._maxTouches : 1;
          if (this._touchMap.size < maxSize) {
            return false;
          }
          const now = performance.now();
          this._touchMap.forEach(touch => {
            if (now - touch.lastModified > macro.TOUCH_TIMEOUT) {
              logID(2302, touch.getID());
              this.releaseTouch(touch.getID());
            }
          });
          return maxSize >= this._touchMap.size;
        }
      }
      const touchManager = new TouchManager();

      class TouchEventElement {
        constructor() {
          this.type = null;
          this.changedTouches = [];
          this.windowId = 0;
        }
      }
      class TouchEventCache {
        constructor() {
          this._events = [];
          this._length = 0;
        }
        push(eventType, changedTouches, windowId) {
          const events = this._events;
          const index = this._length;
          if (index >= events.length) {
            events.push(new TouchEventElement());
          }
          const e = events[index];
          const cachedTouches = e.changedTouches;
          e.type = eventType;
          cachedTouches.length = changedTouches.length;
          e.windowId = windowId;
          for (let i = 0, len = changedTouches.length; i < len; ++i) {
            const src = changedTouches[i];
            let dst = cachedTouches[i];
            if (!dst) {
              cachedTouches[i] = dst = {};
            }
            Object.assign(dst, src);
          }
          ++this._length;
        }
        clear() {
          this._length = 0;
        }
        forEach(cb) {
          for (let i = 0, len = this._length; i < len; ++i) {
            cb(this._events[i]);
          }
        }
      }
      class TouchInputSource {
        constructor() {
          this._eventTarget = new EventTarget();
          this._windowManager = void 0;
          this._cache = new TouchEventCache();
          this._registerEvent();
          this._windowManager = jsb.ISystemWindowManager.getInstance();
        }
        _registerEvent() {
          jsb.onTouchStart = this._createEventCacheCallback("touch-start");
          jsb.onTouchMove = this._createEventCacheCallback("touch-move");
          jsb.onTouchEnd = this._createEventCacheCallback("touch-end");
          jsb.onTouchCancel = this._createEventCacheCallback("touch-cancel");
        }
        _createEventCacheCallback(eventType) {
          return (changedTouches, windowId) => {
            this._cache.push(eventType, changedTouches, windowId);
          };
        }
        dispatchEventsInCache() {
          const cache = this._cache;
          cache.forEach(e => {
            this._dispatchEvent(e.type, e.changedTouches, e.windowId);
          });
          cache.clear();
        }
        _dispatchEvent(eventType, changedTouches, windowId) {
          const handleTouches = [];
          const length = changedTouches.length;
          const windowSize = this._windowManager.getWindow(windowId).getViewSize();
          for (let i = 0; i < length; ++i) {
            const changedTouch = changedTouches[i];
            const touchID = changedTouch.identifier;
            if (touchID === null) {
              continue;
            }
            const location = this._getLocation(changedTouch, windowSize);
            const touch = touchManager.getOrCreateTouch(touchID, location.x, location.y);
            if (!touch) {
              continue;
            }
            if (eventType === "touch-end" || eventType === "touch-cancel") {
              touchManager.releaseTouch(touchID);
            }
            handleTouches.push(touch);
          }
          if (handleTouches.length > 0) {
            const eventTouch = new EventTouch(handleTouches, false, eventType, touchManager.getAllTouches());
            eventTouch.windowId = windowId;
            this._eventTarget.emit(eventType, eventTouch);
          }
        }
        _getLocation(touch, windowSize) {
          const dpr = screenAdapter.devicePixelRatio;
          const x = touch.clientX * dpr;
          const y = windowSize.height - touch.clientY * dpr;
          return new Vec2(x, y);
        }
        on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
        }
      }

      class InputEventDispatcher {
        constructor(inputEventTarget) {
          this.priority = 0;
          this._inputEventTarget = inputEventTarget;
        }
        onThrowException() {}
        dispatchEvent(event) {
          this._inputEventTarget.emit(event.type, event);
          return true;
        }
      }
      const pointerEventTypeMap = {
        ["mouse-down"]: "touch-start",
        ["mouse-move"]: "touch-move",
        ["mouse-up"]: "touch-end"
      };
      class Input {
        constructor() {
          this._eventTarget = new EventTarget();
          this._touchInput = new TouchInputSource();
          this._mouseInput = new MouseInputSource();
          this._keyboardInput = new KeyboardInputSource();
          this._accelerometerInput = new AccelerometerInputSource();
          this._handleInput = new HandleInputDevice();
          this._hmdInput = new HMDInputDevice();
          this._handheldInput = new HandheldInputDevice();
          this._eventKeyboardList = [];
          this._eventAccelerationList = [];
          this._eventGamepadList = [];
          this._eventHandleList = [];
          this._eventHMDList = [];
          this._eventHandheldList = [];
          this._needSimulateTouchMoveEvent = false;
          this._eventDispatcherList = [];
          this._registerEvent();
          this._inputEventDispatcher = new InputEventDispatcher(this._eventTarget);
          this._registerEventDispatcher(this._inputEventDispatcher);
          GamepadInputDevice._init();
        }
        _dispatchMouseDownEvent(nativeMouseEvent) {
          var _this$_mouseInput$dis, _this$_mouseInput;
          (_this$_mouseInput$dis = (_this$_mouseInput = this._mouseInput).dispatchMouseDownEvent) === null || _this$_mouseInput$dis === void 0 ? void 0 : _this$_mouseInput$dis.call(_this$_mouseInput, nativeMouseEvent);
        }
        _dispatchMouseMoveEvent(nativeMouseEvent) {
          var _this$_mouseInput$dis2, _this$_mouseInput2;
          (_this$_mouseInput$dis2 = (_this$_mouseInput2 = this._mouseInput).dispatchMouseMoveEvent) === null || _this$_mouseInput$dis2 === void 0 ? void 0 : _this$_mouseInput$dis2.call(_this$_mouseInput2, nativeMouseEvent);
        }
        _dispatchMouseUpEvent(nativeMouseEvent) {
          var _this$_mouseInput$dis3, _this$_mouseInput3;
          (_this$_mouseInput$dis3 = (_this$_mouseInput3 = this._mouseInput).dispatchMouseUpEvent) === null || _this$_mouseInput$dis3 === void 0 ? void 0 : _this$_mouseInput$dis3.call(_this$_mouseInput3, nativeMouseEvent);
        }
        _dispatchMouseScrollEvent(nativeMouseEvent) {
          var _this$_mouseInput$dis4, _this$_mouseInput4;
          (_this$_mouseInput$dis4 = (_this$_mouseInput4 = this._mouseInput).dispatchScrollEvent) === null || _this$_mouseInput$dis4 === void 0 ? void 0 : _this$_mouseInput$dis4.call(_this$_mouseInput4, nativeMouseEvent);
        }
        _dispatchKeyboardDownEvent(nativeKeyboardEvent) {
          var _this$_keyboardInput$, _this$_keyboardInput;
          (_this$_keyboardInput$ = (_this$_keyboardInput = this._keyboardInput).dispatchKeyboardDownEvent) === null || _this$_keyboardInput$ === void 0 ? void 0 : _this$_keyboardInput$.call(_this$_keyboardInput, nativeKeyboardEvent);
        }
        _dispatchKeyboardUpEvent(nativeKeyboardEvent) {
          var _this$_keyboardInput$2, _this$_keyboardInput2;
          (_this$_keyboardInput$2 = (_this$_keyboardInput2 = this._keyboardInput).dispatchKeyboardUpEvent) === null || _this$_keyboardInput$2 === void 0 ? void 0 : _this$_keyboardInput$2.call(_this$_keyboardInput2, nativeKeyboardEvent);
        }
        on(eventType, callback, target) {
          this._eventTarget.on(eventType, callback, target);
          return callback;
        }
        once(eventType, callback, target) {
          this._eventTarget.once(eventType, callback, target);
          return callback;
        }
        off(eventType, callback, target) {
          this._eventTarget.off(eventType, callback, target);
        }
        getTouch(touchID) {
          return touchManager.getTouch(touchID);
        }
        getAllTouches() {
          return touchManager.getAllTouches();
        }
        getTouchCount() {
          return touchManager.getTouchCount();
        }
        setAccelerometerEnabled(isEnable) {
          if (isEnable) {
            this._accelerometerInput.start();
          } else {
            this._accelerometerInput.stop();
          }
        }
        setAccelerometerInterval(intervalInMileSeconds) {
          this._accelerometerInput.setInterval(intervalInMileSeconds);
        }
        _simulateEventTouch(eventMouse) {
          const eventType = pointerEventTypeMap[eventMouse.type];
          const touchID = 0;
          const touch = touchManager.getOrCreateTouch(touchID, eventMouse.getLocationX(), eventMouse.getLocationY());
          if (!touch) {
            return;
          }
          const changedTouches = [touch];
          const eventTouch = new EventTouch(changedTouches, false, eventType, eventType === "touch-end" ? [] : changedTouches);
          eventTouch.windowId = eventMouse.windowId;
          if (eventType === "touch-end") {
            touchManager.releaseTouch(touchID);
          }
          this._dispatchEventTouch(eventTouch);
        }
        _registerEventDispatcher(eventDispatcher) {
          this._eventDispatcherList.push(eventDispatcher);
          this._eventDispatcherList.sort((a, b) => b.priority - a.priority);
        }
        _emitEvent(event) {
          const length = this._eventDispatcherList.length;
          for (let i = 0; i < length; ++i) {
            const dispatcher = this._eventDispatcherList[i];
            try {
              if (!dispatcher.dispatchEvent(event)) {
                break;
              }
            } catch (e) {
              this._clearEvents();
              dispatcher.onThrowException();
              throw e;
            }
          }
        }
        _registerEvent() {
          if (sys.hasFeature(sys.Feature.INPUT_TOUCH)) {
            this._touchInput.on("touch-start", event => {
              this._dispatchEventTouch(event);
            });
            this._touchInput.on("touch-move", event => {
              this._dispatchEventTouch(event);
            });
            this._touchInput.on("touch-end", event => {
              this._dispatchEventTouch(event);
            });
            this._touchInput.on("touch-cancel", event => {
              this._dispatchEventTouch(event);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_MOUSE)) {
            this._mouseInput.on("mouse-down", event => {
              this._needSimulateTouchMoveEvent = true;
              this._simulateEventTouch(event);
              this._dispatchEventMouse(event);
            });
            this._mouseInput.on("mouse-move", event => {
              if (this._needSimulateTouchMoveEvent) {
                this._simulateEventTouch(event);
              }
              this._dispatchEventMouse(event);
            });
            this._mouseInput.on("mouse-up", event => {
              this._needSimulateTouchMoveEvent = false;
              this._simulateEventTouch(event);
              this._dispatchEventMouse(event);
            });
            this._mouseInput.on("mouse-wheel", event => {
              this._dispatchEventMouse(event);
            });
            this._mouseInput.on("mouse-leave-window", event => {
              this._dispatchEventMouse(event);
            });
            this._mouseInput.on("mouse-enter-window", event => {
              this._dispatchEventMouse(event);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_KEYBOARD)) {
            const eventKeyboardList = this._eventKeyboardList;
            this._keyboardInput.on("keydown", event => {
              this._dispatchOrPushEvent(event, eventKeyboardList);
            });
            this._keyboardInput.on("key-pressing", event => {
              this._dispatchOrPushEvent(event, eventKeyboardList);
            });
            this._keyboardInput.on("keyup", event => {
              this._dispatchOrPushEvent(event, eventKeyboardList);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_ACCELEROMETER)) {
            const eventAccelerationList = this._eventAccelerationList;
            this._accelerometerInput.on("devicemotion", event => {
              this._dispatchOrPushEvent(event, eventAccelerationList);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_GAMEPAD)) {
            const eventGamepadList = this._eventGamepadList;
            GamepadInputDevice._on("gamepad-change", event => {
              this._dispatchOrPushEvent(event, eventGamepadList);
            });
            GamepadInputDevice._on("gamepad-input", event => {
              this._dispatchOrPushEvent(event, eventGamepadList);
            });
            GamepadInputDevice._on("handle-pose-input", event => {
              this._dispatchOrPushEvent(event, eventGamepadList);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_HANDLE)) {
            const eventHandleList = this._eventHandleList;
            this._handleInput._on("handle-input", event => {
              this._dispatchOrPushEvent(event, eventHandleList);
            });
            this._handleInput._on("handle-pose-input", event => {
              this._dispatchOrPushEvent(event, eventHandleList);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_HMD)) {
            const eventHMDList = this._eventHMDList;
            this._hmdInput._on("hmd-pose-input", event => {
              this._dispatchOrPushEvent(event, eventHMDList);
            });
          }
          if (sys.hasFeature(sys.Feature.EVENT_HANDHELD)) {
            const eventHandheldList = this._eventHandheldList;
            this._handheldInput._on("handheld-pose-input", event => {
              this._dispatchOrPushEvent(event, eventHandheldList);
            });
          }
        }
        _clearEvents() {
          this._eventKeyboardList.length = 0;
          this._eventAccelerationList.length = 0;
          this._eventGamepadList.length = 0;
          this._eventHandleList.length = 0;
          this._eventHMDList.length = 0;
        }
        _dispatchOrPushEvent(event, eventList) {
          {
            eventList.push(event);
          }
        }
        _dispatchEventMouse(event) {
          this._emitEvent(event);
        }
        _dispatchEventTouch(eventTouch) {
          const touches = eventTouch.getTouches();
          const touchesLength = touches.length;
          for (let i = 0; i < touchesLength; ++i) {
            eventTouch.touch = touches[i];
            eventTouch.propagationStopped = eventTouch.propagationImmediateStopped = false;
            this._emitEvent(eventTouch);
          }
        }
        _frameDispatchEvents() {
          const eventHMDList = this._eventHMDList;
          for (let i = 0, length = eventHMDList.length; i < length; ++i) {
            const eventHMD = eventHMDList[i];
            this._emitEvent(eventHMD);
          }
          const eventHandheldList = this._eventHandheldList;
          for (let i = 0, length = eventHandheldList.length; i < length; ++i) {
            const eventHandheld = eventHandheldList[i];
            this._emitEvent(eventHandheld);
          }
          this._mouseInput.dispatchEventsInCache();
          this._touchInput.dispatchEventsInCache();
          const eventKeyboardList = this._eventKeyboardList;
          for (let i = 0, length = eventKeyboardList.length; i < length; ++i) {
            const eventKeyboard = eventKeyboardList[i];
            this._emitEvent(eventKeyboard);
          }
          const eventAccelerationList = this._eventAccelerationList;
          for (let i = 0, length = eventAccelerationList.length; i < length; ++i) {
            const eventAcceleration = eventAccelerationList[i];
            this._emitEvent(eventAcceleration);
          }
          const eventGamepadList = this._eventGamepadList;
          for (let i = 0, length = eventGamepadList.length; i < length; ++i) {
            const eventGamepad = eventGamepadList[i];
            this._emitEvent(eventGamepad);
          }
          const eventHandleList = this._eventHandleList;
          for (let i = 0, length = eventHandleList.length; i < length; ++i) {
            const eventHandle = eventHandleList[i];
            this._emitEvent(eventHandle);
          }
          this._clearEvents();
        }
      } exports("Input", Input);
      Input.EventType = InputEventType;
      const input$1 = exports("input", new Input());

      class SystemEvent extends EventTarget {
        constructor() {
          super();
          input$1.on("mouse-down", e => {
            this.emit("mouse-down", e);
          });
          input$1.on("mouse-move", e => {
            this.emit("mouse-move", e);
          });
          input$1.on("mouse-up", e => {
            this.emit("mouse-up", e);
          });
          input$1.on("mouse-wheel", e => {
            this.emit("mouse-wheel", e);
          });
          input$1.on("touch-start", e => {
            this.emit("touch-start", e.touch, e);
          });
          input$1.on("touch-move", e => {
            this.emit("touch-move", e.touch, e);
          });
          input$1.on("touch-end", e => {
            this.emit("touch-end", e.touch, e);
          });
          input$1.on("touch-cancel", e => {
            this.emit("touch-cancel", e.touch, e);
          });
          input$1.on("keydown", e => {
            this.emit("keydown", e);
          });
          input$1.on("key-pressing", e => {
            this.emit("keydown", e);
          });
          input$1.on("keyup", e => {
            this.emit("keyup", e);
          });
          input$1.on("devicemotion", e => {
            this.emit("devicemotion", e);
          });
        }
        setAccelerometerEnabled(isEnabled) {
          input$1.setAccelerometerEnabled(isEnabled);
        }
        setAccelerometerInterval(interval) {
          input$1.setAccelerometerInterval(interval);
        }
        on(type, callback, target, once) {
          super.on(type, callback, target, once);
          return callback;
        }
        off(type, callback, target) {
          super.off(type, callback, target);
        }
      } exports("SystemEvent", SystemEvent);
      SystemEvent.EventType = SystemEventType;
      cclegacy.SystemEvent = SystemEvent;
      const systemEvent = exports("systemEvent", new SystemEvent());
      cclegacy.systemEvent = systemEvent;

      replaceProperty(SystemEventType, 'Node.EventType', [{
        name: 'POSITION_PART',
        newName: 'TRANSFORM_CHANGED'
      }, {
        name: 'ROTATION_PART',
        newName: 'TRANSFORM_CHANGED'
      }, {
        name: 'SCALE_PART',
        newName: 'TRANSFORM_CHANGED'
      }]);
      replaceProperty(Event, 'Event', [{
        name: 'ACCELERATION',
        newName: 'DEVICEMOTION',
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      }]);
      markAsWarning(Event, 'Event', [{
        name: 'TOUCH',
        suggest: 'please use SystemEvent.EventType.TOUCH_START, SystemEvent.EventType.TOUCH_MOVE, SystemEvent.EventType.TOUCH_END and SystemEvent.EventType.TOUCH_CANCEL instead'
      }, {
        name: 'MOUSE',
        suggest: 'please use SystemEvent.EventType.MOUSE_DOWN, SystemEvent.EventType.MOUSE_MOVE, SystemEvent.EventType.MOUSE_UP, SystemEvent.EventType.MOUSE_WHEEL, Node.EventType.MOUSE_ENTER and Node.EventType.MOUSE_LEAVE instead'
      }, {
        name: 'KEYBOARD',
        suggest: 'please use SystemEvent.EventType.KEY_DOWN and SystemEvent.EventType.KEY_UP instead'
      }]);
      replaceProperty(EventMouse, 'EventMouse', ['DOWN', 'UP', 'MOVE'].map(item => ({
        name: item,
        newName: `MOUSE_${item}`,
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      })));
      replaceProperty(EventMouse, 'EventMouse', [{
        name: 'SCROLL',
        newName: 'MOUSE_WHEEL',
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      }]);
      markAsWarning(EventMouse.prototype, 'EventMouse.prototype', [{
        name: 'eventType',
        suggest: 'please use EventMouse.prototype.type instead'
      }]);
      replaceProperty(EventTouch, 'EventTouch', [{
        name: 'BEGAN',
        newName: 'TOUCH_START',
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      }]);
      replaceProperty(EventTouch, 'EventTouch', [{
        name: 'MOVED',
        newName: 'TOUCH_MOVE',
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      }]);
      replaceProperty(EventTouch, 'EventTouch', [{
        name: 'ENDED',
        newName: 'TOUCH_END',
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      }]);
      replaceProperty(EventTouch, 'EventTouch', [{
        name: 'CANCELLED',
        newName: 'TOUCH_CANCEL',
        target: SystemEvent.EventType,
        targetName: 'SystemEvent.EventType'
      }]);
      markAsWarning(EventTouch.prototype, 'EventTouch.prototype', [{
        name: 'getEventCode',
        suggest: 'please use EventTouch.prototype.type instead'
      }]);
      replaceProperty(EventTouch.prototype, 'EventTouch.prototype', [{
        name: 'getUILocationInView',
        newName: 'getLocationInView',
        target: EventTouch,
        targetName: 'EventTouch'
      }]);
      markAsWarning(macro.KEY, 'macro.KEY', ['back', 'menu', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '*', '+', '-', '/', ';', '=', ',', '.', '[', ']', 'dpadLeft', 'dpadRight', 'dpadUp', 'dpadDown', 'dpadCenter'].map(item => ({
        name: item
      })));
      markAsWarning(macro.KEY, 'macro.KEY', [{
        name: 'shift',
        suggest: 'please use 16 instead'
      }]);
      markAsWarning(macro.KEY, 'macro.KEY', [{
        name: 'ctrl',
        suggest: 'please use 17 instead'
      }]);
      markAsWarning(macro.KEY, 'macro.KEY', [{
        name: 'alt',
        suggest: 'please use 18 instead'
      }]);
      markAsWarning(macro, 'macro', [{
        name: 'KEY',
        suggest: 'please use KeyCode instead'
      }]);

      const PipelineEventType = exports("PipelineEventType", {
        "RENDER_FRAME_BEGIN": "render-frame-begin",
        "RENDER_FRAME_END": "render-frame-end",
        "RENDER_CAMERA_BEGIN": "render-camera-begin",
        "RENDER_CAMERA_END": "render-camera-end",
        "ATTACHMENT_SCALE_CAHNGED": "attachment-scale-changed"
      });
      class PipelineEventProcessor extends EventTarget {
        constructor() {
          super();
          this.eventTargetOn = super.on;
          this.eventTargetOnce = super.once;
        }
        on(type, callback, target, once) {
          return this.eventTargetOn(type, callback, target, once);
        }
        once(type, callback, target) {
          return this.eventTargetOnce(type, callback, target);
        }
      }

      const Root = exports("Root", jsb.Root);
      var LightType$1;
      (function (LightType) {
        LightType[LightType["DIRECTIONAL"] = 0] = "DIRECTIONAL";
        LightType[LightType["SPHERE"] = 1] = "SPHERE";
        LightType[LightType["SPOT"] = 2] = "SPOT";
        LightType[LightType["POINT"] = 3] = "POINT";
        LightType[LightType["RANGED_DIRECTIONAL"] = 4] = "RANGED_DIRECTIONAL";
        LightType[LightType["UNKNOWN"] = 5] = "UNKNOWN";
      })(LightType$1 || (LightType$1 = {}));
      const rootProto = Root.prototype;
      rootProto._createBatcher2D = function () {
        if (!this._batcher && legacyCC.internal.Batcher2D) {
          this._batcher = new legacyCC.internal.Batcher2D(this);
          if (!this._batcher.initialize()) {
            this._batcher = null;
            this.destroy();
            return;
          }
          this._batcher._nativeObj = this.getBatcher2D();
        }
      };
      Object.defineProperty(rootProto, 'batcher2D', {
        configurable: true,
        enumerable: true,
        get() {
          return this._batcher;
        }
      });
      Object.defineProperty(rootProto, 'dataPoolManager', {
        configurable: true,
        enumerable: true,
        get() {
          return this._dataPoolMgr;
        }
      });
      Object.defineProperty(rootProto, 'pipelineEvent', {
        configurable: true,
        enumerable: true,
        get() {
          return this._pipelineEvent;
        }
      });
      rootProto._ctor = function (device) {
        this._device = device;
        this._dataPoolMgr = legacyCC.internal.DataPoolManager && new legacyCC.internal.DataPoolManager(device);
        this._modelPools = new Map();
        this._lightPools = new Map();
        this._batcher = null;
        this._pipelineEvent = new PipelineEventProcessor();
        this._registerListeners();
      };
      rootProto.initialize = function (info) {
        var _this$_dataPoolMgr;
        this._initialize(deviceManager.swapchain);
        const customJointTextureLayouts = settings.querySettings(Settings.Category.ANIMATION, 'customJointTextureLayouts') || [];
        (_this$_dataPoolMgr = this._dataPoolMgr) === null || _this$_dataPoolMgr === void 0 ? void 0 : _this$_dataPoolMgr.jointTexturePool.registerCustomTextureLayouts(customJointTextureLayouts);
      };
      rootProto.createModel = function (ModelCtor) {
        let p = this._modelPools.get(ModelCtor);
        if (!p) {
          this._modelPools.set(ModelCtor, new Pool(() => new ModelCtor(), 10, obj => obj.destroy()));
          p = this._modelPools.get(ModelCtor);
        }
        const model = p.alloc();
        model.initialize();
        return model;
      };
      rootProto.destroyModel = function (m) {
        const p = this._modelPools.get(m.constructor);
        if (p) {
          p.free(m);
          if (m.scene) {
            m.scene.removeModel(m);
          }
        } else {
          warnID(1300, m.constructor.name);
        }
        m.destroy();
      };
      rootProto.createLight = function (LightCtor) {
        let l = this._lightPools.get(LightCtor);
        if (!l) {
          this._lightPools.set(LightCtor, new Pool(() => new LightCtor(), 4, obj => obj.destroy()));
          l = this._lightPools.get(LightCtor);
        }
        const light = l.alloc();
        light.initialize();
        return light;
      };
      rootProto.destroyLight = function (l) {
        if (l.scene) {
          switch (l.type) {
            case 0:
              l.scene.removeDirectionalLight(l);
              break;
            case 1:
              l.scene.removeSphereLight(l);
              break;
            case 2:
              l.scene.removeSpotLight(l);
              break;
            case 3:
              l.scene.removePointLight(l);
              break;
            case 4:
              l.scene.removeRangedDirLight(l);
              break;
          }
        }
        l.destroy();
      };
      rootProto.recycleLight = function (l) {
        const p = this._lightPools.get(l.constructor);
        if (p) {
          p.free(l);
          if (l.scene) {
            switch (l.type) {
              case 0:
                l.scene.removeDirectionalLight(l);
                break;
              case 1:
                l.scene.removeSphereLight(l);
                break;
              case 2:
                l.scene.removeSpotLight(l);
                break;
              case 3:
                l.scene.removePointLight(l);
                break;
              case 4:
                l.scene.removeRangedDirLight(l);
                break;
            }
          }
        }
      };
      rootProto._onDirectorBeforeCommit = function () {
        legacyCC.director.emit(legacyCC.Director.EVENT_BEFORE_COMMIT);
      };
      rootProto._onDirectorBeforeRender = function () {
        legacyCC.director.emit(legacyCC.Director.EVENT_BEFORE_RENDER);
      };
      rootProto._onDirectorAfterRender = function () {
        legacyCC.director.emit(legacyCC.Director.EVENT_AFTER_RENDER);
      };
      rootProto._onDirectorPipelineChanged = function () {
        const scene = legacyCC.director.getScene();
        if (scene) {
          scene._activate();
        }
      };
      const oldOnGlobalPipelineStateChanged = rootProto.onGlobalPipelineStateChanged;
      rootProto.onGlobalPipelineStateChanged = function () {
        oldOnGlobalPipelineStateChanged.call(this);
        const builder = legacyCC.rendering.getCustomPipeline(macro.CUSTOM_PIPELINE_NAME);
        if (builder) {
          if (typeof builder.onGlobalPipelineStateChanged === 'function') {
            builder.onGlobalPipelineStateChanged();
          }
          legacyCC.rendering.forceResizeAllWindows();
        }
      };
      const oldFrameMove = rootProto.frameMove;
      rootProto.frameMove = function (deltaTime) {
        oldFrameMove.call(this, deltaTime, legacyCC.director.getTotalFrames());
      };
      const oldSetPipeline = rootProto.setRenderPipeline;
      rootProto.setRenderPipeline = function (customPipeline) {
        let ppl;
        if (customPipeline) {
          legacyCC.rendering.createCustomPipeline();
          ppl = oldSetPipeline.call(this, null);
          log(`Using custom pipeline: ${macro.CUSTOM_PIPELINE_NAME}`);
        } else {
          if (cclegacy.legacy_rendering) {
            const pipeline = cclegacy.legacy_rendering.createDefaultPipeline();
            pipeline.init();
            ppl = oldSetPipeline.call(this, pipeline);
          } else {
            log(`No render pipeline: legacy-pipeline is not available`);
          }
        }
        this._createBatcher2D();
        return ppl;
      };
      rootProto.addBatch = function (batch) {
        console.error('The Draw Batch class is implemented differently in the native platform and does not support this interface.');
      };
      rootProto.removeBatch = function (batch) {
        console.error('The Draw Batch class is implemented differently in the native platform and does not support this interface.');
      };
      rootProto.removeBatches = function () {
        console.error('The Draw Batch class is implemented differently in the native platform and does not support this interface.');
      };

      const NodeEventType = exports("NodeEventType", {
        "TOUCH_START": "touch-start",
        "TOUCH_MOVE": "touch-move",
        "TOUCH_END": "touch-end",
        "TOUCH_CANCEL": "touch-cancel",
        "MOUSE_DOWN": "mouse-down",
        "MOUSE_MOVE": "mouse-move",
        "MOUSE_UP": "mouse-up",
        "MOUSE_WHEEL": "mouse-wheel",
        "MOUSE_ENTER": "mouse-enter",
        "MOUSE_LEAVE": "mouse-leave",
        "KEY_DOWN": "keydown",
        "KEY_UP": "keyup",
        "DEVICEMOTION": "devicemotion",
        "TRANSFORM_CHANGED": "transform-changed",
        "MOBILITY_CHANGED": "mobility-changed",
        "SCENE_CHANGED_FOR_PERSISTS": "scene-changed-for-persists",
        "SIZE_CHANGED": "size-changed",
        "ANCHOR_CHANGED": "anchor-changed",
        "COLOR_CHANGED": "color-changed",
        "CHILD_ADDED": "child-added",
        "CHILD_REMOVED": "child-removed",
        "PARENT_CHANGED": "parent-changed",
        "NODE_DESTROYED": "node-destroyed",
        "LAYER_CHANGED": "layer-changed",
        "SIBLING_ORDER_CHANGED": "sibling-order-changed",
        "CHILDREN_ORDER_CHANGED": "sibling-order-changed",
        "ACTIVE_IN_HIERARCHY_CHANGED": "active-in-hierarchy-changed",
        "COMPONENT_ADDED": "component-added",
        "COMPONENT_REMOVED": "component-removed",
        "LIGHT_PROBE_CHANGED": "light-probe-changed",
        "LIGHT_PROBE_BAKING_CHANGED": "light-probe-baking-changed",
        "ACTIVE_CHANGED": "active-changed"
      });

      class NodeUIProperties {
        get uiTransformComp() {
          if (!this._uiTransformComp) {
            this._uiTransformComp = this._node.getComponent('cc.UITransform');
          }
          return this._uiTransformComp;
        }
        set uiTransformComp(value) {
          this._uiTransformComp = value;
        }
        get uiComp() {
          return this._uiComp;
        }
        set uiComp(comp) {
          if (this._uiComp && comp) {
            warnID(12002);
            return;
          }
          this._uiComp = comp;
        }
        setOpacity(v) {
          this._opacity = v;
        }
        get opacity() {
          return this._opacity;
        }
        get localOpacity() {
          return this._localOpacity;
        }
        set localOpacity(val) {
          this._localOpacity = val;
          this.colorDirty = true;
        }
        constructor(node) {
          this._uiComp = null;
          this._opacity = 1;
          this._localOpacity = 1;
          this.colorDirty = true;
          this._uiTransformComp = null;
          this._node = node;
        }
        applyOpacity(effectOpacity) {
          this._opacity = this._localOpacity * effectOpacity;
        }
        static markOpacityTree(node, isDirty = true) {}
      }

      const NodeSpace = exports("NodeSpace", {
        "LOCAL": 0,
        "WORLD": 1
      });
      const TransformBit = exports("TransformBit", {
        "NONE": 0,
        "POSITION": 1,
        "ROTATION": 2,
        "SCALE": 4,
        "RS": 6,
        "TRS": 7,
        "TRS_MASK": -8
      });
      legacyCC.internal.TransformBit = TransformBit;
      const MobilityMode = exports("MobilityMode", Enum({
        Static: 0,
        Stationary: 1,
        Movable: 2
      }));

      const layerList = {
        NONE: 0,
        IGNORE_RAYCAST: 1 << 20,
        GIZMOS: 1 << 21,
        EDITOR: 1 << 22,
        UI_3D: 1 << 23,
        SCENE_GIZMO: 1 << 24,
        UI_2D: 1 << 25,
        PROFILER: 1 << 28,
        DEFAULT: 1 << 30,
        ALL: 0xffffffff
      };
      class Layers {
        static init() {
          const userLayers = settings.querySettings("engine", 'customLayers');
          if (!userLayers) return;
          for (let i = 0; i < userLayers.length; i++) {
            const layer = userLayers[i];
            Layers.addLayer(layer.name, layer.bit);
          }
        }
        static makeMaskInclude(includes) {
          let mask = 0;
          for (const inc of includes) {
            mask |= inc;
          }
          return mask;
        }
        static makeMaskExclude(excludes) {
          return ~Layers.makeMaskInclude(excludes);
        }
        static addLayer(name, bitNum) {
          if (bitNum === undefined) {
            warnID(16364);
            return;
          }
          if (bitNum > 19 || bitNum < 0) {
            warnID(16365);
            return;
          }
          const val = 1 << bitNum;
          assertIsTrue(!Layers.Enum[name], getError(2104, name));
          Layers.Enum[name] = val;
          value(Layers.Enum, String(val), name);
          Layers.BitMask[name] = val;
          value(Layers.BitMask, String(val), name);
          BitMask.update(Layers.BitMask);
          Enum.update(Layers.Enum);
        }
        static deleteLayer(bitNum) {
          if (bitNum > 19 || bitNum < 0) {
            warnID(16366);
            return;
          }
          const val = 1 << bitNum;
          delete Layers.Enum[Layers.Enum[val]];
          delete Layers.Enum[val];
          delete Layers.BitMask[Layers.BitMask[val]];
          delete Layers.BitMask[val];
          BitMask.update(Layers.BitMask);
          Enum.update(Layers.Enum);
        }
        static nameToLayer(name) {
          if (name === undefined) {
            warnID(16367);
            return -1;
          }
          return log2(Layers.Enum[name]);
        }
        static layerToName(bitNum) {
          if (bitNum > 31 || bitNum < 0) {
            warnID(16368);
            return '';
          }
          return Layers.Enum[1 << bitNum];
        }
      } exports("Layers", Layers);
      Layers.Enum = Enum(layerList);
      Layers.BitMask = BitMask({
        ...layerList
      });
      legacyCC.Layers = Layers;

      const _tempFloatArray = new Float32Array(jsb.createExternalArrayBuffer(20 * 4));
      const fillMat4WithTempFloatArray = function fillMat4WithTempFloatArray(out) {
        Mat4.set(out, _tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2], _tempFloatArray[3], _tempFloatArray[4], _tempFloatArray[5], _tempFloatArray[6], _tempFloatArray[7], _tempFloatArray[8], _tempFloatArray[9], _tempFloatArray[10], _tempFloatArray[11], _tempFloatArray[12], _tempFloatArray[13], _tempFloatArray[14], _tempFloatArray[15]);
      };

      CCObject.Flags.Destroying;
      !!legacyCC.GAME_VIEW;

      const reserveContentsForAllSyncablePrefabTag = Symbol('ReserveContentsForAllSyncablePrefab');
      const Node$1 = jsb.Node; exports({ Node: Node$1, BaseNode: Node$1 });
      legacyCC.Node = Node$1;
      const NodeCls = Node$1;
      NodeCls.reserveContentsForAllSyncablePrefabTag = reserveContentsForAllSyncablePrefabTag;
      NodeCls.EventType = NodeEventType;
      NodeCls.NodeSpace = NodeSpace;
      NodeCls.TransformDirtyBit = TransformBit;
      NodeCls.TransformBit = TransformBit;
      const TRANSFORMBIT_TRS = 7;
      const nodeProto = jsb.Node.prototype;
      const TRANSFORM_ON = 1 << 0;
      const ACTIVE_ON = 1 << 1;
      const Destroying = CCObject.Flags.Destroying;
      Node$1._setTempFloatArray(_tempFloatArray.buffer);
      function getConstructor(typeOrClassName) {
        if (!typeOrClassName) {
          return null;
        }
        if (typeof typeOrClassName === 'string') {
          return getClassByName(typeOrClassName);
        }
        return typeOrClassName;
      }
      nodeProto.attr = function (attrs) {
        mixin(this, attrs);
      };
      nodeProto.getComponent = function (typeOrClassName) {
        const constructor = getConstructor(typeOrClassName);
        if (constructor) {
          return NodeCls._findComponent(this, constructor);
        }
        return null;
      };
      nodeProto.getComponents = function (typeOrClassName) {
        const constructor = getConstructor(typeOrClassName);
        const components = [];
        if (constructor) {
          NodeCls._findComponents(this, constructor, components);
        }
        return components;
      };
      nodeProto.getComponentInChildren = function (typeOrClassName) {
        const constructor = getConstructor(typeOrClassName);
        if (constructor) {
          return NodeCls._findChildComponent(this._children, constructor);
        }
        return null;
      };
      nodeProto.getComponentsInChildren = function (typeOrClassName) {
        const constructor = getConstructor(typeOrClassName);
        const components = [];
        if (constructor) {
          NodeCls._findComponents(this, constructor, components);
          NodeCls._findChildComponents(this.children, constructor, components);
        }
        return components;
      };
      nodeProto.addComponent = function (typeOrClassName) {
        let constructor;
        if (typeof typeOrClassName === 'string') {
          constructor = getClassByName(typeOrClassName);
          if (!constructor) {
            if (legacyCC._RF.peek()) {
              errorID(3808, typeOrClassName);
            }
            throw TypeError(getError(3807, typeOrClassName));
          }
        } else {
          if (!typeOrClassName) {
            throw TypeError(getError(3804));
          }
          constructor = typeOrClassName;
        }
        if (typeof constructor !== 'function') {
          throw TypeError(getError(3809));
        }
        if (!isChildClassOf(constructor, Component)) {
          throw TypeError(getError(3810));
        }
        const reqComps = constructor._requireComponent;
        if (reqComps) {
          const tryAdd = c => {
            if (!this.getComponent(c)) {
              this.addComponent(c);
            }
          };
          if (Array.isArray(reqComps)) {
            reqComps.forEach(c => tryAdd(c));
          } else {
            tryAdd(reqComps);
          }
        }
        const component = new constructor();
        component.node = this;
        this._components.push(component);
        this.emit("component-added", component);
        if (this._activeInHierarchy) {
          legacyCC.director._nodeActivator.activateComp(component);
        }
        return component;
      };
      nodeProto.removeComponent = function (component) {
        if (!component) {
          errorID(3813);
          return;
        }
        let componentInstance = null;
        if (component instanceof Component) {
          componentInstance = component;
        } else {
          componentInstance = this.getComponent(component);
        }
        if (componentInstance) {
          componentInstance.destroy();
        }
      };
      const REGISTERED_EVENT_MASK_TRANSFORM_CHANGED = 1 << 0;
      const REGISTERED_EVENT_MASK_PARENT_CHANGED = 1 << 1;
      const REGISTERED_EVENT_MASK_MOBILITY_CHANGED = 1 << 2;
      const REGISTERED_EVENT_MASK_LAYER_CHANGED = 1 << 3;
      const REGISTERED_EVENT_MASK_SIBLING_ORDER_CHANGED = 1 << 4;
      const REGISTERED_EVENT_MASK_LIGHT_PROBE_BAKING_CHANGED = 1 << 5;
      nodeProto.on = function (type, callback, target, useCapture = false) {
        switch (type) {
          case "transform-changed":
            this._eventMask |= TRANSFORM_ON;
            if (!(this._registeredNodeEventTypeMask & REGISTERED_EVENT_MASK_TRANSFORM_CHANGED)) {
              this._registerOnTransformChanged();
              this._registeredNodeEventTypeMask |= REGISTERED_EVENT_MASK_TRANSFORM_CHANGED;
            }
            break;
          case "active-changed":
            this._eventMask |= ACTIVE_ON;
            break;
          case "parent-changed":
            if (!(this._registeredNodeEventTypeMask & REGISTERED_EVENT_MASK_PARENT_CHANGED)) {
              this._registerOnParentChanged();
              this._registeredNodeEventTypeMask |= REGISTERED_EVENT_MASK_PARENT_CHANGED;
            }
            break;
          case "mobility-changed":
            if (!(this._registeredNodeEventTypeMask & REGISTERED_EVENT_MASK_MOBILITY_CHANGED)) {
              this._registerOnMobilityChanged();
              this._registeredNodeEventTypeMask |= REGISTERED_EVENT_MASK_MOBILITY_CHANGED;
            }
            break;
          case "layer-changed":
            if (!(this._registeredNodeEventTypeMask & REGISTERED_EVENT_MASK_LAYER_CHANGED)) {
              this._registerOnLayerChanged();
              this._registeredNodeEventTypeMask |= REGISTERED_EVENT_MASK_LAYER_CHANGED;
            }
            break;
          case "sibling-order-changed":
            if (!(this._registeredNodeEventTypeMask & REGISTERED_EVENT_MASK_SIBLING_ORDER_CHANGED)) {
              this._registerOnSiblingOrderChanged();
              this._registeredNodeEventTypeMask |= REGISTERED_EVENT_MASK_SIBLING_ORDER_CHANGED;
            }
            break;
          case "light-probe-baking-changed":
            if (!(this._registeredNodeEventTypeMask & REGISTERED_EVENT_MASK_LIGHT_PROBE_BAKING_CHANGED)) {
              this._registerOnLightProbeBakingChanged();
              this._registeredNodeEventTypeMask |= REGISTERED_EVENT_MASK_LIGHT_PROBE_BAKING_CHANGED;
            }
            break;
        }
        this._eventProcessor.on(type, callback, target, useCapture);
      };
      nodeProto.off = function (type, callback, target, useCapture = false) {
        this._eventProcessor.off(type, callback, target, useCapture);
        const hasListeners = this._eventProcessor.hasEventListener(type);
        if (!hasListeners) {
          switch (type) {
            case "transform-changed":
              this._eventMask &= ~TRANSFORM_ON;
              break;
            case "active-changed":
              this._eventMask &= ~ACTIVE_ON;
              break;
          }
        }
      };
      nodeProto.once = function (type, callback, target, useCapture) {
        this._eventProcessor.once(type, callback, target, useCapture);
      };
      nodeProto.emit = function (type, arg0, arg1, arg2, arg3, arg4) {
        this._eventProcessor.emit(type, arg0, arg1, arg2, arg3, arg4);
      };
      nodeProto.dispatchEvent = function (event) {
        this._eventProcessor.dispatchEvent(event);
      };
      nodeProto.hasEventListener = function (type, callback, target) {
        return this._eventProcessor.hasEventListener(type, callback, target);
      };
      nodeProto.targetOff = function (target) {
        this._eventProcessor.targetOff(target);
        if (this._eventMask & TRANSFORM_ON && !this._eventProcessor.hasEventListener("transform-changed")) {
          this._eventMask &= ~TRANSFORM_ON;
        }
        if (this._eventMask & ACTIVE_ON && !this._eventProcessor.hasEventListener("active-changed")) {
          this._eventMask &= ~ACTIVE_ON;
        }
      };
      nodeProto.pauseSystemEvents = function pauseSystemEvents(recursive) {
        this._eventProcessor.setEnabled(false, recursive);
      };
      nodeProto.resumeSystemEvents = function resumeSystemEvents(recursive) {
        this._eventProcessor.setEnabled(true, recursive);
      };
      nodeProto.getWritableComponents = function () {
        return this._components;
      };
      nodeProto._setActiveInHierarchy = function (v) {
        return this._activeInHierarchy = v;
      };
      nodeProto._removeComponent = function (component) {
        if (!component) {
          errorID(3814);
          return;
        }
        if (!(this._objFlags & Destroying)) {
          const i = this._components.indexOf(component);
          if (i !== -1) {
            this._components.splice(i, 1);
            this.emit("component-removed", component);
          } else if (component.node !== this) {
            errorID(3815);
          }
        }
      };
      nodeProto._registerIfAttached = undefined ;
      nodeProto._onTransformChanged = function (transformType) {
        this.emit("transform-changed", transformType);
      };
      nodeProto._onParentChanged = function (oldParent) {
        this.emit("parent-changed", oldParent);
      };
      nodeProto._onReAttach = function () {
        this._eventProcessor.reattach();
      };
      nodeProto._onEditorAttached = function (attached) {
      };
      nodeProto._onRemovePersistRootNode = function () {
        legacyCC.game.removePersistRootNode(this);
      };
      nodeProto._onDestroyComponents = function () {
        this._eventProcessor.destroy();
        const comps = this._components;
        for (let i = 0; i < comps.length; ++i) {
          comps[i]._destroyImmediate();
        }
      };
      nodeProto._onMobilityChanged = function () {
        this.emit("mobility-changed");
      };
      nodeProto._onLayerChanged = function (layer) {
        this.emit("layer-changed", layer);
      };
      nodeProto._onChildRemoved = function (child) {
        const removeAt = this._children.indexOf(child);
        if (removeAt < 0) {
          errorID(1633);
          return;
        }
        this._children.splice(removeAt, 1);
        this.emit("child-removed", child);
      };
      nodeProto._onChildAdded = function (child) {
        this._children.push(child);
        this.emit("child-added", child);
      };
      const oldPreDestroy = nodeProto._onPreDestroy;
      nodeProto._onPreDestroy = function _onPreDestroy() {
        const ret = oldPreDestroy.call(this);
        this.emit("node-destroyed", this);
        this._eventProcessor.destroy();
        const children = this._children;
        for (let i = 0; i < children.length; ++i) {
          children[i]._destroyImmediate();
        }
        const comps = this._components;
        for (let i = 0; i < comps.length; ++i) {
          comps[i]._destroyImmediate();
        }
        return ret;
      };
      nodeProto.destroyAllChildren = function destroyAllChildren() {
        const children = this._children;
        for (let i = 0, len = children.length; i < len; ++i) {
          children[i].destroy();
        }
      };
      nodeProto._onSiblingOrderChanged = function () {
        this.emit("sibling-order-changed");
      };
      nodeProto._onActivateNode = function (shouldActiveNow) {
        legacyCC.director._nodeActivator.activateNode(this, shouldActiveNow);
      };
      nodeProto._onPostActivated = function (active) {
        if (this._eventMask & ACTIVE_ON) {
          this.emit("active-changed", this, active);
        }
        this._eventProcessor.setEnabled(active);
        if (active) {
          this.invalidateChildren(7);
          if (this._uiProps && this._uiProps.uiComp) {
            this._uiProps.uiComp.setNodeDirty();
            this._uiProps.uiComp.setTextureDirty();
            this._uiProps.uiComp.markForUpdateRenderData();
          }
        }
      };
      nodeProto._onLightProbeBakingChanged = function () {
        this.emit("light-probe-baking-changed");
      };
      NodeCls._findComponent = function (node, constructor) {
        const cls = constructor;
        const comps = node._components;
        if (cls._sealed) {
          for (let i = 0; i < comps.length; ++i) {
            const comp = comps[i];
            if (comp.constructor === constructor) {
              return comp;
            }
          }
        } else {
          for (let i = 0; i < comps.length; ++i) {
            const comp = comps[i];
            if (comp instanceof constructor) {
              return comp;
            }
          }
        }
        return null;
      };
      NodeCls._findComponents = function (node, constructor, components) {
        const cls = constructor;
        const comps = node._components;
        if (cls._sealed) {
          for (let i = 0; i < comps.length; ++i) {
            const comp = comps[i];
            if (comp.constructor === constructor) {
              components.push(comp);
            }
          }
        } else {
          for (let i = 0; i < comps.length; ++i) {
            const comp = comps[i];
            if (comp instanceof constructor) {
              components.push(comp);
            }
          }
        }
      };
      NodeCls._findChildComponent = function (children, constructor) {
        for (let i = 0; i < children.length; ++i) {
          const node = children[i];
          let comp = NodeCls._findComponent(node, constructor);
          if (comp) {
            return comp;
          }
          const childChildren = node.children;
          if (childChildren.length > 0) {
            comp = NodeCls._findChildComponent(childChildren, constructor);
            if (comp) {
              return comp;
            }
          }
        }
        return null;
      };
      NodeCls._findChildComponents = function (children, constructor, components) {
        for (let i = 0; i < children.length; ++i) {
          const node = children[i];
          NodeCls._findComponents(node, constructor, components);
          const childChildren = node.children;
          if (childChildren.length > 0) {
            NodeCls._findChildComponents(childChildren, constructor, components);
          }
        }
      };
      NodeCls.isNode = function (obj) {
        return obj instanceof jsb.Node && (obj.constructor === jsb.Node || !(obj instanceof legacyCC.Scene));
      };
      let _tempQuat = new Quat();
      nodeProto.setRTS = function setRTS(rot, pos, scale) {
        if (rot) {
          let val = _tempQuat;
          if (rot instanceof Quat) {
            val = rot;
          } else {
            Quat.fromEuler(val, rot.x, rot.y, rot.z);
          }
          _tempFloatArray[0] = 4;
          _tempFloatArray[1] = val.x;
          _tempFloatArray[2] = val.y;
          _tempFloatArray[3] = val.z;
          _tempFloatArray[4] = val.w;
          this._lrot.set(val.x, val.y, val.z, val.w);
        } else {
          _tempFloatArray[0] = 0;
        }
        if (pos) {
          _tempFloatArray[5] = 3;
          _tempFloatArray[6] = pos.x;
          _tempFloatArray[7] = pos.y;
          _tempFloatArray[8] = pos.z;
          this._lpos.set(pos.x, pos.y, pos.z);
        } else {
          _tempFloatArray[5] = 0;
        }
        if (scale) {
          _tempFloatArray[9] = 3;
          _tempFloatArray[10] = scale.x;
          _tempFloatArray[11] = scale.y;
          _tempFloatArray[12] = scale.z;
          this._lscale.set(scale.x, scale.y, scale.z);
        } else {
          _tempFloatArray[9] = 0;
        }
        this._setRTS();
      };
      nodeProto.getPosition = function getPosition(out) {
        if (out) {
          return Vec3.set(out, this._lpos.x, this._lpos.y, this._lpos.z);
        }
        return Vec3.copy(new Vec3(), this._lpos);
      };
      nodeProto.setPosition = function setPosition(val, y, z) {
        if (y === undefined && z === undefined) {
          _tempFloatArray[0] = 3;
          const pos = val;
          this._lpos.x = _tempFloatArray[1] = pos.x;
          this._lpos.y = _tempFloatArray[2] = pos.y;
          this._lpos.z = _tempFloatArray[3] = pos.z;
        } else if (z === undefined) {
          _tempFloatArray[0] = 2;
          this._lpos.x = _tempFloatArray[1] = val;
          this._lpos.y = _tempFloatArray[2] = y;
        } else {
          _tempFloatArray[0] = 3;
          this._lpos.x = _tempFloatArray[1] = val;
          this._lpos.y = _tempFloatArray[2] = y;
          this._lpos.z = _tempFloatArray[3] = z;
        }
        this._setPosition();
      };
      nodeProto.getRotation = function getRotation(out) {
        const lrot = this._lrot;
        if (out) {
          return Quat.set(out, lrot.x, lrot.y, lrot.z, lrot.w);
        }
        return Quat.copy(new Quat(), lrot);
      };
      nodeProto.setRotation = function setRotation(val, y, z, w) {
        if (y === undefined || z === undefined || w === undefined) {
          const rot = val;
          this._lrot.x = _tempFloatArray[0] = rot.x;
          this._lrot.y = _tempFloatArray[1] = rot.y;
          this._lrot.z = _tempFloatArray[2] = rot.z;
          this._lrot.w = _tempFloatArray[3] = rot.w;
        } else {
          this._lrot.x = _tempFloatArray[0] = val;
          this._lrot.y = _tempFloatArray[1] = y;
          this._lrot.z = _tempFloatArray[2] = z;
          this._lrot.w = _tempFloatArray[3] = w;
        }
        this._setRotation();
      };
      nodeProto.setRotationFromEuler = function setRotationFromEuler(val, y, zOpt) {
        const z = zOpt === undefined ? this._euler.z : zOpt;
        if (y === undefined) {
          const euler = val;
          this._euler.x = _tempFloatArray[0] = euler.x;
          this._euler.y = _tempFloatArray[1] = euler.y;
          this._euler.z = _tempFloatArray[2] = euler.z;
        } else {
          this._euler.x = _tempFloatArray[0] = val;
          this._euler.y = _tempFloatArray[1] = y;
          this._euler.z = _tempFloatArray[2] = z;
        }
        this._setRotationFromEuler();
      };
      nodeProto.getScale = function getScale(out) {
        if (out) {
          return Vec3.set(out, this._lscale.x, this._lscale.y, this._lscale.z);
        }
        return Vec3.copy(new Vec3(), this._lscale);
      };
      nodeProto.setScale = function setScale(val, y, z) {
        if (y === undefined && z === undefined) {
          _tempFloatArray[0] = 3;
          const scale = val;
          this._lscale.x = _tempFloatArray[1] = scale.x;
          this._lscale.y = _tempFloatArray[2] = scale.y;
          this._lscale.z = _tempFloatArray[3] = scale.z;
        } else if (z === undefined) {
          _tempFloatArray[0] = 2;
          this._lscale.x = _tempFloatArray[1] = val;
          this._lscale.y = _tempFloatArray[2] = y;
        } else {
          _tempFloatArray[0] = 3;
          this._lscale.x = _tempFloatArray[1] = val;
          this._lscale.y = _tempFloatArray[2] = y;
          this._lscale.z = _tempFloatArray[3] = z;
        }
        this._setScale();
      };
      nodeProto.getWorldPosition = function getWorldPosition(out) {
        this._getWorldPosition();
        out = out || new Vec3();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2]);
      };
      nodeProto.getWorldRotation = function getWorldRotation(out) {
        this._getWorldRotation();
        out = out || new Quat();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2], _tempFloatArray[3]);
      };
      nodeProto.getWorldScale = function getWorldScale(out) {
        this._getWorldScale();
        out = out || new Vec3();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2]);
      };
      nodeProto.getWorldMatrix = function getWorldMatrix(out) {
        this._getWorldMatrix();
        out = out || new Mat4();
        fillMat4WithTempFloatArray(out);
        return out;
      };
      nodeProto.getEulerAngles = function getEulerAngles(out) {
        this._getEulerAngles();
        out = out || new Vec3();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2]);
      };
      nodeProto.getForward = function getForward(out) {
        this._getForward();
        out = out || new Vec3();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2]);
      };
      nodeProto.getUp = function getUp(out) {
        this._getUp();
        out = out || new Vec3();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2]);
      };
      nodeProto.getRight = function getRight(out) {
        this._getRight();
        out = out || new Vec3();
        return out.set(_tempFloatArray[0], _tempFloatArray[1], _tempFloatArray[2]);
      };
      nodeProto.inverseTransformPoint = function inverseTransformPoint(out, p) {
        _tempFloatArray[0] = p.x;
        _tempFloatArray[1] = p.y;
        _tempFloatArray[2] = p.z;
        this._inverseTransformPoint();
        out.x = _tempFloatArray[0];
        out.y = _tempFloatArray[1];
        out.z = _tempFloatArray[2];
        return out;
      };
      nodeProto.getWorldRT = function getWorldRT(out) {
        out = out || new Mat4();
        this._getWorldRT();
        fillMat4WithTempFloatArray(out);
        return out;
      };
      nodeProto.getWorldRS = function getWorldRS(out) {
        out = out || new Mat4();
        this._getWorldRS();
        fillMat4WithTempFloatArray(out);
        return out;
      };
      nodeProto.isTransformDirty = function () {
        return this._transformFlags !== 0;
      };
      Object.defineProperty(nodeProto, 'name', {
        configurable: true,
        enumerable: true,
        get() {
          return this._name;
        },
        set(v) {
          this._name = v;
        }
      });
      Object.defineProperty(nodeProto, 'position', {
        configurable: true,
        enumerable: true,
        get() {
          return this._lpos;
        },
        set(v) {
          this.setPosition(v);
        }
      });
      Object.defineProperty(nodeProto, 'rotation', {
        configurable: true,
        enumerable: true,
        get() {
          return this._lrot;
        },
        set(v) {
          this.setRotation(v);
        }
      });
      Object.defineProperty(nodeProto, 'scale', {
        configurable: true,
        enumerable: true,
        get() {
          return this._lscale;
        },
        set(v) {
          this.setScale(v);
        }
      });
      Object.defineProperty(nodeProto, 'worldPosition', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldPosition();
        },
        set(v) {
          this.setWorldPosition(v);
        }
      });
      Object.defineProperty(nodeProto, 'worldRotation', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldRotation();
        },
        set(v) {
          this.setWorldRotation(v);
        }
      });
      Object.defineProperty(nodeProto, 'worldScale', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldScale();
        },
        set(v) {
          this.setWorldScale(v);
        }
      });
      Object.defineProperty(nodeProto, '_pos', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldPosition();
        }
      });
      Object.defineProperty(nodeProto, '_rot', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldRotation();
        }
      });
      Object.defineProperty(nodeProto, '_scale', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldScale();
        }
      });
      Object.defineProperty(nodeProto, 'eulerAngles', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getEulerAngles();
        },
        set(v) {
          this.setRotationFromEuler(v.x, v.y, v.z);
        }
      });
      Object.defineProperty(nodeProto, 'worldMatrix', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldMatrix();
        }
      });
      Object.defineProperty(nodeProto, '_mat', {
        configurable: true,
        enumerable: true,
        get() {
          return this.getWorldMatrix();
        }
      });
      Object.defineProperty(nodeProto, 'activeInHierarchy', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint8Arr[0] != 0;
        },
        set(v) {
          this._sharedUint8Arr[0] = v ? 1 : 0;
        }
      });
      Object.defineProperty(nodeProto, '_activeInHierarchy', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint8Arr[0] != 0;
        },
        set(v) {
          this._sharedUint8Arr[0] = v ? 1 : 0;
        }
      });
      Object.defineProperty(nodeProto, 'layer', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint32Arr[1];
        },
        set(v) {
          this._sharedUint32Arr[1] = v;
          if (this._uiProps && this._uiProps.uiComp) {
            this._uiProps.uiComp.setNodeDirty();
            this._uiProps.uiComp.markForUpdateRenderData();
          }
          this.emit("layer-changed", v);
        }
      });
      Object.defineProperty(nodeProto, '_layer', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint32Arr[1];
        },
        set(v) {
          this._sharedUint32Arr[1] = v;
        }
      });
      Object.defineProperty(nodeProto, '_eventMask', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint32Arr[0];
        },
        set(v) {
          this._sharedUint32Arr[0] = v;
        }
      });
      Object.defineProperty(nodeProto, '_siblingIndex', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedInt32Arr[0];
        },
        set(v) {
          this._sharedInt32Arr[0] = v;
        }
      });
      Object.defineProperty(nodeProto, 'prefab', {
        configurable: true,
        enumerable: true,
        get() {
          return this._prefab;
        }
      });
      Object.defineProperty(nodeProto, 'siblingIndex', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedInt32Arr[0];
        },
        set(v) {
          this._sharedInt32Arr[0] = v;
        }
      });
      nodeProto.getSiblingIndex = function getSiblingIndex() {
        return this._sharedInt32Arr[0];
      };
      Object.defineProperty(nodeProto, '_transformFlags', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint32Arr[2];
        },
        set(v) {
          this._sharedUint32Arr[2] = v;
        }
      });
      Object.defineProperty(nodeProto, '_active', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint8Arr[1] != 0;
        },
        set(v) {
          this._sharedUint8Arr[1] = v ? 1 : 0;
        }
      });
      Object.defineProperty(nodeProto, 'active', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint8Arr[1] != 0;
        },
        set(v) {
          this.setActive(!!v);
        }
      });
      Object.defineProperty(nodeProto, '_static', {
        configurable: true,
        enumerable: true,
        get() {
          return this._sharedUint8Arr[2] != 0;
        },
        set(v) {
          this._sharedUint8Arr[2] = v ? 1 : 0;
        }
      });
  