"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const global_1 = require("./global");
const util = __importStar(require("./global"));
const fs_extra_1 = require("fs-extra");
const fs = __importStar(require("fs-extra/lib/fs"));
function log(...arg) {
    return console.log(`[${global_1.PACKAGE_NAME}] `, ...arg);
}
let allAssets = [];
exports.throwError = true;
exports.load = function () {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`[${global_1.PACKAGE_NAME}] Load cocos plugin example in builder.`);
        allAssets = yield Editor.Message.request('asset-db', 'query-assets');
    });
};
exports.onBeforeBuild = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        // TODO some thing
        log(`${global_1.PACKAGE_NAME}.webTestOption`, 'onBeforeBuild');
    });
};
exports.onBeforeCompressSettings = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        const pkgOptions = options.packages[global_1.PACKAGE_NAME];
        if (pkgOptions.webTestOption) {
            console.debug('webTestOption', true);
        }
        // Todo some thing
        console.debug('get settings test', result.settings);
    });
};
exports.onAfterCompressSettings = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo some thing
        console.log('webTestOption', 'onAfterCompressSettings');
    });
};
exports.onAfterBuild = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        const pkgOptions = options.packages[global_1.PACKAGE_NAME];
        if (pkgOptions.h5Checkbox) {
            const applicationJS = result.paths.applicationJS;
            const jsName = applicationJS.substring(applicationJS.lastIndexOf("\\") + 1);
            let mainpath = result.dest + '\\h5\\' + "index.js"; //D:\xxxxxx\project\build\android
            console.log(mainpath);
            var content = fs.readFileSync(mainpath, 'utf-8'); //System.register(["../data/application.7e468.js"],
            content = content.replace(/application\.[a-z 0-9\.]*js/, jsName);
            fs_extra_1.outputFile(mainpath, content);
        }
        let destDir = result.dest + "\\h5\\assets";
        console.log("删除h5/assets文件夹");
        util.deleteFolderRecursive(destDir);
        if (!options.skipCompressTexture) {
            //把资源从发布目录复制到h5目录，并且清理发布目录里面的jpg/png
            //+add 没有从发布目录里面清除，因为有引擎系统图片是png的，比如 20835ba4-6145-4fbc-a58a-051ce700aa3e
            let assets = result.paths.assets;
            console.log("复制h5/assets文件夹");
            util.copyFolderRecursive(assets, destDir, [".astc"]);
        }
        else {
            //创建软链接
            let targetPath = "../data/assets"; // 目标文件或文件夹路径
            //     // 创建符号链接，需要管理员权限才能执行成功
            //     fs.symlinkSync(targetPath, destDir, 'dir'); // 'file' 或 'dir' 可以用来指明目标是文件还是目录
            //     console.log(`Symbolic link created at: ${destDir} / ${targetPath}`);
            console.log("创建h5/assets软链接:" + `${destDir} / ${targetPath}`);
            const { exec } = require('child_process');
            exec(`mklink /J "${destDir}" "${targetPath}"`, (err, stdout, stderr) => {
                if (err) {
                    console.error('Error creating junction:', err);
                    return;
                }
                console.log('Junction created:', stdout);
            });
        }
        // change the uuid to test
        const uuidTestMap = {
            image: '57520716-48c8-4a19-8acf-41c9f8777fb0',
        };
        for (const name of Object.keys(uuidTestMap)) {
            const uuid = uuidTestMap[name];
            console.debug(`containsAsset of ${name}`, result.containsAsset(uuid));
            console.debug(`getAssetPathInfo of ${name}`, result.getAssetPathInfo(uuid));
            console.debug(`getRawAssetPaths of ${name}`, result.getRawAssetPaths(uuid));
            console.debug(`getJsonPathInfo of ${name}`, result.getJsonPathInfo(uuid));
        }
        // test onError hook
        // throw new Error('Test onError');
    });
};
exports.unload = function () {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`[${global_1.PACKAGE_NAME}] Unload cocos plugin example in builder.`);
    });
};
exports.onError = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo some thing
        console.warn(`${global_1.PACKAGE_NAME} run onError`);
    });
};
exports.onBeforeMake = function (root, options) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`onBeforeMake: root: ${root}, options: ${options}`);
    });
};
exports.onAfterMake = function (root, options) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`onAfterMake: root: ${root}, options: ${options}`);
    });
};
