
export const PACKAGE_NAME = 'build-plugin-template';


import * as fs from 'fs-extra/lib/fs';

export const deleteFolderRecursive = (folderPath) => {
    if (fs.existsSync(folderPath)) {
        // 获取文件夹内的所有文件和子文件夹
        const files = fs.readdirSync(folderPath);

        files.forEach((file) => {
            // const currentPath = path.join(folderPath, file);
            const currentPath = folderPath + "/" + file;

            // 判断是文件还是文件夹
            if (fs.lstatSync(currentPath).isDirectory()) {
                // 如果是文件夹，递归调用删除
                deleteFolderRecursive(currentPath);
            } else {
                // 如果是文件，直接删除
                fs.unlinkSync(currentPath);
            }
        });

        // 最后删除空文件夹
        fs.rmdirSync(folderPath);
        // console.log(`${folderPath} has been deleted`);
    } else {
        console.log('The folder does not exist');
    }
};

// 递归复制文件夹函数
export const copyFolderRecursive = (sourceDir, destDir, filterExtName?:string[]) => {
    // 检查源文件夹是否存在
    if (!fs.existsSync(sourceDir)) {
        console.error('Source folder does not exist.');
        return;
    }

    // 创建目标文件夹（如果不存在）
    if (!fs.existsSync(destDir)) {
        fs.mkdirSync(destDir);
    }

    // 读取源文件夹的所有文件和子文件夹
    const items = fs.readdirSync(sourceDir);

    items.forEach((item) => {
        // 拼接源文件和目标文件的路径
        const sourcePath = sourceDir + '/' + item;
        const destPath = destDir + '/' + item;
        const stats = fs.statSync(sourcePath);

        // 如果是文件，复制文件
        if (stats.isFile()) {
            const extname = item.substring(item.lastIndexOf('.')).toLowerCase();  // 获取文件扩展名
            if (filterExtName && filterExtName.indexOf(extname) >= 0) {
                // console.log(`Skipped file: ${item}`);
            } else {
                fs.copyFileSync(sourcePath, destPath);
                // console.log(`Copied file: ${item}`);
            }
        } else if (stats.isDirectory()) {
            // 如果是文件夹，递归复制
            copyFolderRecursive(sourcePath, destPath, filterExtName);
        }
    });
};
