import { BuildHook, IBuildResult, ITaskOptions } from '../@types';
import { PACKAGE_NAME } from './global';
import * as util from './global';
import {outputFile} from 'fs-extra';
import * as fs from 'fs-extra/lib/fs';

function log(...arg: any[]) {
    return console.log(`[${PACKAGE_NAME}] `, ...arg);
}

let allAssets = [];

export const throwError: BuildHook.throwError = true;

export const load: BuildHook.load = async function() {
    console.log(`[${PACKAGE_NAME}] Load cocos plugin example in builder.`);
    allAssets = await Editor.Message.request('asset-db', 'query-assets');
};

export const onBeforeBuild: BuildHook.onBeforeBuild = async function(options: ITaskOptions, result: IBuildResult) {
    // TODO some thing
    log(`${PACKAGE_NAME}.webTestOption`, 'onBeforeBuild');
};

export const onBeforeCompressSettings: BuildHook.onBeforeCompressSettings = async function(options: ITaskOptions, result: IBuildResult) {
    const pkgOptions = options.packages[PACKAGE_NAME];
    if (pkgOptions.webTestOption) {
        console.debug('webTestOption', true);
    }
    // Todo some thing
    console.debug('get settings test', result.settings);
};

export const onAfterCompressSettings: BuildHook.onAfterCompressSettings = async function(options: ITaskOptions, result: IBuildResult) {
    // Todo some thing
    console.log('webTestOption', 'onAfterCompressSettings');
};

export const onAfterBuild: BuildHook.onAfterBuild = async function(options: ITaskOptions, result: IBuildResult) {
    const pkgOptions = options.packages[PACKAGE_NAME];
    if(pkgOptions.h5Checkbox){
        const applicationJS = result.paths.applicationJS;
        const jsName = applicationJS.substring(applicationJS.lastIndexOf("\\")+1);
        let mainpath = result.dest + '\\h5\\' + "index.js"; //D:\xxxxxx\project\build\android
        console.log(mainpath)
        var content = fs.readFileSync(mainpath, 'utf-8'); //System.register(["../data/application.7e468.js"],
        content = content.replace(/application\.[a-z 0-9\.]*js/, jsName);
        outputFile(mainpath, content);
    }
    let destDir = result.dest + "\\h5\\assets";
    console.log("删除h5/assets文件夹")
    util.deleteFolderRecursive(destDir);
    if(!options.skipCompressTexture){
        //把资源从发布目录复制到h5目录，并且清理发布目录里面的jpg/png
        //+add 没有从发布目录里面清除，因为有引擎系统图片是png的，比如 20835ba4-6145-4fbc-a58a-051ce700aa3e
        let assets = result.paths.assets;
        console.log("复制h5/assets文件夹")
        util.copyFolderRecursive(assets, destDir, [".astc"]);
    }
    else{
        //创建软链接
        let targetPath = "../data/assets" // 目标文件或文件夹路径
//     // 创建符号链接，需要管理员权限才能执行成功
//     fs.symlinkSync(targetPath, destDir, 'dir'); // 'file' 或 'dir' 可以用来指明目标是文件还是目录
//     console.log(`Symbolic link created at: ${destDir} / ${targetPath}`);
        console.log("创建h5/assets软链接:" + `${destDir} / ${targetPath}`)
        const { exec } = require('child_process');
        exec(`mklink /J "${destDir}" "${targetPath}"`, (err, stdout, stderr) => {
            if (err) {
                console.error('Error creating junction:', err);
                return;
            }
            console.log('Junction created:', stdout);
        });
    }
    
    // change the uuid to test
    const uuidTestMap = {
        image: '57520716-48c8-4a19-8acf-41c9f8777fb0',
    };
    for (const name of Object.keys(uuidTestMap)) {
        const uuid = uuidTestMap[name];
        console.debug(`containsAsset of ${name}`, result.containsAsset(uuid));
        console.debug(`getAssetPathInfo of ${name}`, result.getAssetPathInfo(uuid));
        console.debug(`getRawAssetPaths of ${name}`, result.getRawAssetPaths(uuid));
        console.debug(`getJsonPathInfo of ${name}`, result.getJsonPathInfo(uuid));
    }
    // test onError hook
    // throw new Error('Test onError');
};

export const unload: BuildHook.unload = async function() {
    console.log(`[${PACKAGE_NAME}] Unload cocos plugin example in builder.`);
};

export const onError: BuildHook.onError = async function(options, result) {
    // Todo some thing
    console.warn(`${PACKAGE_NAME} run onError`);
};

export const onBeforeMake: BuildHook.onBeforeMake = async function(root, options) {
    console.log(`onBeforeMake: root: ${root}, options: ${options}`);
};

export const onAfterMake: BuildHook.onAfterMake = async function(root, options) {
    console.log(`onAfterMake: root: ${root}, options: ${options}`);
};
