import {
    _decorator, Component, Node, Camera, RenderTexture, sys, UITransform, gfx,
    director, ImageAsset, Texture2D, SpriteFrame, Sprite, view, tween, Vec3, isValid
} from 'cc';
import * as cc from 'cc'

export class Util {

    public static validateNow(){
        if (cc.sys.isNative) {
            cc.director.root!.frameMove(0);
        } else {
            cc.director.tick(0);
        }
    }
    public static createRect(bgColor:number, x: number, y: number, width: number, height: number, node?:cc.Node, alpha?:number):cc.Node {
        if(!node) node = new cc.Node("modal");
        let shape = node.getComponent(cc.Graphics);
        if(!shape)
            shape = node.addComponent(cc.Graphics);
        let color = new cc.Color();
        color = color.fromHEX(bgColor);
        if(alpha != undefined){
            color.a = alpha * 255;
        }
        shape.fillColor = color;
        shape.fillRect(x - width/2, y - height/2, width, height);

        let uiT = node.getComponent(cc.UITransform);
        if(!uiT) uiT = node.addComponent(cc.UITransform);
        uiT.width = width;
        uiT.height = height;
        
        return node;
    }
    public static createStroke(lineColor:number, x: number, y: number, width: number, height: number, node?:cc.Node, alpha?:number):cc.Node {
        if(!node) node = new cc.Node("modal");
        let shape = node.getComponent(cc.Graphics);
        if(!shape)
            shape = node.addComponent(cc.Graphics);
        let color = new cc.Color();
        color = color.fromHEX(lineColor);
        if(alpha != undefined){
            color.a = alpha * 255;
        }
        shape.lineWidth = 3;
        shape.strokeColor = color;
        // shape.rect(x - width/2, y - height/2, width, height);
        shape.rect(x, y, width, height);
        shape.stroke();

        let uiT = node.getComponent(cc.UITransform);
        if(!uiT) uiT = node.addComponent(cc.UITransform);
        uiT.width = width;
        uiT.height = height;
        
        return node;
    }

    public static trim(str:string, is_global?) {
        if(!str) return str;
        
        var result;
        result = str.replace(/(^\s+)|(\s+$)/g,"");
        if(is_global && is_global.toLowerCase()=="g"){
            result = result.replace(/\s/g,"");
        }
        return result;
    }
    public static stringToIntArray(str:string, split:string=","):Array<number>{
        if(!str){
            return [];
        }
        var list:string[] = String(str).split(split);
        var newList:number[] = [];
        for(var i=0; i<list.length; i++){
            newList[i] = Number(list[i]);
        }
        return newList;
    }

    public static readTexturePixels(texture: cc.Texture2D, rect: cc.Rect): Uint8Array {
        const gfxTexture = texture.getGFXTexture();
        if (gfxTexture == null) return null;

        const bufferSize = 4 * texture.width * texture.height;
        const buffer = new Uint8Array(bufferSize);

        const region = new cc.gfx.BufferTextureCopy();
        region.texOffset.x = rect.x;
        region.texOffset.y = rect.y;
        region.texExtent.width = rect.width;
        region.texExtent.height = rect.height;
        const gfxDevice = director.root.device; //texture['_getGFXDevice']();
        gfxDevice.copyTextureToBuffers(gfxTexture, [buffer], [region]);
        return buffer;
    }
    public static resizeUint8Array(imageData:Uint8Array, originalWidth:number, originalHeight:number, scaleFactor:number) {
        // 计算新图像的宽度和高度
        const newWidth = Math.floor(originalWidth * scaleFactor);
        const newHeight = Math.floor(originalHeight * scaleFactor);
        
        // 创建一个新的 Uint8Array 来存储放大后的图像数据
        const newImageData = new Uint8Array(newWidth * newHeight * 4); // 每个像素4个字节（RGBA）
    
        // 遍历新图像中的每个像素
        for (let y = 0; y < newHeight; y++) {
            for (let x = 0; x < newWidth; x++) {
                // 计算原图像中的对应位置
                const srcX = Math.floor(x / scaleFactor);
                const srcY = Math.floor(y / scaleFactor);
    
                // 计算原图像中的像素索引（RGBA）
                const srcIndex = (srcY * originalWidth + srcX) * 4;
                const destIndex = (y * newWidth + x) * 4;
    
                // 拷贝 RGBA 数据
                newImageData[destIndex] = imageData[srcIndex]; // R
                newImageData[destIndex + 1] = imageData[srcIndex + 1]; // G
                newImageData[destIndex + 2] = imageData[srcIndex + 2]; // B
                newImageData[destIndex + 3] = imageData[srcIndex + 3]; // A
            }
        }
    
        return newImageData;
    }
}


