import {
    _decorator, Component, Node, Camera, RenderTexture, sys, UITransform, gfx,
    director, ImageAsset, Texture2D, SpriteFrame, Sprite, view, tween, Vec3, isValid
} from 'cc';
import * as cc from 'cc'

export class Util {

    public static validateNow(){
        if (cc.sys.isNative) {
            cc.director.root!.frameMove(0);
        } else {
            cc.director.tick(0);
        }
    }
    public static createRect(bgColor:number, x: number, y: number, width: number, height: number, node?:cc.Node, alpha?:number):cc.Node {
        if(!node) node = new cc.Node("modal");
        let shape = node.getComponent(cc.Graphics);
        if(!shape)
            shape = node.addComponent(cc.Graphics);
        let color = new cc.Color();
        color = color.fromHEX(bgColor);
        if(alpha != undefined){
            color.a = alpha * 255;
        }
        shape.fillColor = color;
        shape.fillRect(x - width/2, y - height/2, width, height);

        let uiT = node.getComponent(cc.UITransform);
        if(!uiT) uiT = node.addComponent(cc.UITransform);
        uiT.width = width;
        uiT.height = height;
        
        return node;
    }
    public static createStroke(lineColor:number, x: number, y: number, width: number, height: number, node?:cc.Node, alpha?:number):cc.Node {
        if(!node) node = new cc.Node("modal");
        let shape = node.getComponent(cc.Graphics);
        if(!shape)
            shape = node.addComponent(cc.Graphics);
        let color = new cc.Color();
        color = color.fromHEX(lineColor);
        if(alpha != undefined){
            color.a = alpha * 255;
        }
        shape.lineWidth = 3;
        shape.strokeColor = color;
        // shape.rect(x - width/2, y - height/2, width, height);
        shape.rect(x, y, width, height);
        shape.stroke();

        let uiT = node.getComponent(cc.UITransform);
        if(!uiT) uiT = node.addComponent(cc.UITransform);
        uiT.width = width;
        uiT.height = height;
        
        return node;
    }
}


